/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_open_X11X(), which opens an X11 window in a
 * _ more complete way, determining its size and position,
 * _ as well as title texts and the icon bitmap image.
 *
 * IMPORTANT NOTE: the character strings that are to be passed to
 * _ the X11 system must have been defined in the calling Fortran
 * _ program including the trailing NULL which is needed in the C
 * _ language; this can be done in Fortran with a line such as:
 * _
 * _    character_variable = 'some constant string'//char(0)
 * _
 * _ where the character variable must have been defined with a
 * _ size sufficient to hold all the required data, of course;
 * _ passing a constant string directly in the argument of the
 * _ function will usually also work correctly, many times even
 * _ without the trailing NULL, but it is much safer to add the
 * _ trailing NULL anyway, using as the argument the combination
 * _
 * _    'some constant string'//char(0)
 *
 * This is to be called from Fortran as an integer function,
 * _ that is, as "id = g2_open_x11x_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ iw_wid: width of the window;
 * _ iw_hei: height of the window;
 * _ ix_pos: x position of the window;
 * _ iy_pos: y position of the window;
 * _ t_win:  the title text for the window;
 * _ t_ico:  the title text for the icon;
 * _ d_ico:  the text data for the icon, or a filename;
 * _ ii_wid: width of the icon;
 * _ ii_hei: height of the icon.
 */
int g2_open_x11x_ctof__(int *iw_wid, int *iw_hei,
			int *ix_pos, int *iy_pos,
			char *t_win, char *t_ico, char *d_ico,
			int *ii_wid, int *ii_hei)
{
  /*
   * Local variables:
   * _ i_iw_wid, i_iw_hei: int variables to acquire the arguments;
   * _ i_ix_pos, i_iy_pos: int variables to acquire the arguments;
   * _ i_ii_wid, i_ii_hei: int variables to acquire the arguments;
   * _ i_id_xd: int variable to return the window id.
   */
  int i_iw_wid, i_iw_hei, i_ix_pos, i_iy_pos, i_ii_wid, i_ii_hei, i_id_xd;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_iw_wid = *iw_wid;
  i_iw_hei = *iw_hei;
  i_ix_pos = *ix_pos;
  i_iy_pos = *iy_pos;
  i_ii_wid = *ii_wid;
  i_ii_hei = *ii_hei;
  /*
   * Call the C function with the required arguments; note
   * _ that the text string pointers are passed directly
   * _ to the function, without any transformation.
   */
  i_id_xd = g2_open_X11X(i_iw_wid, i_iw_hei,
			 i_ix_pos, i_iy_pos,
			 t_win, t_ico, d_ico,
			 i_ii_wid, i_ii_hei);
  /*
   * Return the id of the window created.
   */
  return(i_id_xd);
}
/*
 * Compatibility function for gfortran.
 */
int g2_open_x11x_ctof_(int *iw_wid, int *iw_hei,
		       int *ix_pos, int *iy_pos,
		       char *t_win, char *t_ico, char *d_ico,
		       int *ii_wid, int *ii_hei)
{
  return g2_open_x11x_ctof__(iw_wid, iw_hei,
			     ix_pos, iy_pos,
			     t_win, t_ico, d_ico,
			     ii_wid, ii_hei);
}
