/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_triangle(), which draws a triangle given by
 * _ its three corner points.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_triangle_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_cp1: the x position of the first corner point;
 * _ y_cp1: the y position of the first corner point;
 * _ x_cp2: the x position of the second corner point;
 * _ y_cp2: the y position of the second corner point;
 * _ x_cp3: the x position of the third corner point;
 * _ y_cp3: the y position of the third corner point.
 */
void g2_triangle_ctof__(int *id_ad,
			float *x_cp1, float *y_cp1,
			float *x_cp2, float *y_cp2,
			float *x_cp3, float *y_cp3)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_cp1, f_y_cp1: float variables to acquire the arguments;
   * _ d_x_cp1, d_y_cp1: double versions of the variables above;
   * _ f_x_cp2, f_y_cp2: float variables to acquire the arguments;
   * _ d_x_cp2, d_y_cp2: double versions of the variables above;
   * _ f_x_cp3, f_y_cp3: float variables to acquire the arguments;
   * _ d_x_cp3, d_y_cp3: double versions of the variables above.
   */
  int    i_id_ad;
  float  f_x_cp1, f_y_cp1, f_x_cp2, f_y_cp2, f_x_cp3, f_y_cp3;
  double d_x_cp1, d_y_cp1, d_x_cp2, d_y_cp2, d_x_cp3, d_y_cp3;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_cp1 = *x_cp1;
  f_y_cp1 = *y_cp1;
  f_x_cp2 = *x_cp2;
  f_y_cp2 = *y_cp2;
  f_x_cp3 = *x_cp3;
  f_y_cp3 = *y_cp3;
  /*
   * Pass the float data to the double variables.
   */
  d_x_cp1 = f_x_cp1;
  d_y_cp1 = f_y_cp1;
  d_x_cp2 = f_x_cp2;
  d_y_cp2 = f_y_cp2;
  d_x_cp3 = f_x_cp3;
  d_y_cp3 = f_y_cp3;
  /*
   * Call the C function with the required arguments.
   */
  g2_triangle(i_id_ad,
	      d_x_cp1, d_y_cp1,
	      d_x_cp2, d_y_cp2,
	      d_x_cp3, d_y_cp3);
}
/*
 * Compatibility function for gfortran.
 */
void g2_triangle_ctof_(int *id_ad,
		       float *x_cp1, float *y_cp1,
		       float *x_cp2, float *y_cp2,
		       float *x_cp3, float *y_cp3)
{
  g2_triangle_ctof__(id_ad,
		     x_cp1, y_cp1,
		     x_cp2, y_cp2,
		     x_cp3, y_cp3);
}
