/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_set_line_width(), which sets the line width
 * _ to be used.
 *
 * OBSERVATION: note that, although the line width is in real format,
 * _ it has as its units the number of pixels, not coordinate units;
 * _ the pixel unit seems to refer to a typical 100-dpi X11 screen;
 * _ the reason for this seems to be that the size of a pixel is a
 * _ device-dependent quantity, leading to the necessity of using
 * _ fractions; for example, if the pixel unit refers to a typical
 * _ 100-dpi X11 screen (as seems to be the case), then a PS-format
 * _ output file meant for a 600-dpi printer would have the size of
 * _ a single pixel given by the value 1/6.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_set_line_width_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ wid_l: the line width to be used.
 */
void g2_set_line_width_ctof__(int *id_ad,
			      float *wid_l)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_wid_l: float variable to acquire the argument;
   * _ d_wid_l: double version of the variable above.
   */
  int    i_id_ad;
  float  f_wid_l;
  double d_wid_l;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_wid_l = *wid_l;
  /*
   * Pass the float datum to the double variable.
   */
  d_wid_l = f_wid_l;
  /*
   * Call the C function with the required arguments.
   */
  g2_set_line_width(i_id_ad,
		    d_wid_l);
}
/*
 * Compatibility function for gfortran.
 */
void g2_set_line_width_ctof_(int *id_ad,
			     float *wid_l)
{
  g2_set_line_width_ctof__(id_ad,
			   wid_l);
}
