/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_query_pointer(), which acquires the position
 * _ and button state of the pointer device.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_query_pointer_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the input argument is:
 * _ id_xd: the id of the physical device.
 *
 * The output arguments are:
 * _ x_pos: to return the x position of the pointer;
 * _ y_pos: to return the y position of the pointer;
 * _ i_but: to return the button state of the pointer.
 */
void g2_query_pointer_ctof__(int *id_xd,
			     float *x_pos, float *y_pos,
			     int *i_but)
{
  /*
   * Local variables:
   * _ i_id_xd: int variable to acquire the first argument;
   * _ f_x_pos, f_y_pos: float variables to return the position;
   * _ d_x_pos, d_y_pos: double versions of the variables above;
   * _ i_i_but: int variable to return the button state;
   * _ u_i_but: unsigned int version of the variable above.
   */
  int          i_id_xd;
  float        f_x_pos, f_y_pos;
  double       d_x_pos, d_y_pos;
  int          i_i_but;
  unsigned int u_i_but;
  /*
   * Pass the datum from the pointer argument to the local variable.
   */
  i_id_xd = *id_xd;
  /*
   * Call the C function with the required arguments; note
   * _ that the output variables are passed by pointer,
   * _ with the use of the "&" operator.
   */
  g2_query_pointer(i_id_xd,
		   &d_x_pos, &d_y_pos,
		   &u_i_but);
  /*
   * Pass the double data to the float variables.
   */
  f_x_pos = d_x_pos;
  f_y_pos = d_y_pos;
  /*
   * Pass the unsigned int datum to the int variable.
   */
  i_i_but = u_i_but;
  /*
   * Pass the data from the local variables
   * _ to the output pointer arguments.
   */
  *x_pos = f_x_pos;
  *y_pos = f_y_pos;
  *i_but = i_i_but;
}
/*
 * Compatibility function for gfortran.
 */
void g2_query_pointer_ctof_(int *id_xd,
			    float *x_pos, float *y_pos,
			    int *i_but)
{
  g2_query_pointer_ctof__(id_xd,
			  x_pos, y_pos,
			  i_but);
}
