/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_string(), which draws text at a given position.
 *
 * IMPORTANT NOTE: the character string that is to be passed to
 * _ the g2 routine must have been defined in the calling Fortran
 * _ program including the trailing NULL which is needed in the
 * _ C language; this can be done in Fortran with a line such as:
 * _
 * _    character_variable='some constant string'//char(0)
 * _
 * _ where the character variable must have been defined with a
 * _ size sufficient to hold all the required data, of course;
 * _ passing a constant string directly in the argument of the
 * _ function will usually also work correctly, many times even
 * _ without the trailing NULL, but it is much safer to add the
 * _ trailing NULL anyway, using as the argument the combination
 * _
 * _    'some constant string'//char(0)
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_string_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_pos: the x position of the text;
 * _ y_pos: the y position of the text;
 * _ t_str: the text string.
 */
void g2_string_ctof__(int *id_ad,
		      float *x_pos, float *y_pos,
		      char *t_str)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_pos, f_y_pos: float variables to acquire the arguments;
   * _ d_x_pos, d_y_pos: double versions of the variables above.
   */
  int    i_id_ad;
  float  f_x_pos, f_y_pos;
  double d_x_pos, d_y_pos;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_pos = *x_pos;
  f_y_pos = *y_pos;
  /*
   * Pass the float data to the double variables.
   */
  d_x_pos = f_x_pos;
  d_y_pos = f_y_pos;
  /*
   * Call the C function with the required arguments; note
   * _ that the text string pointer is passed directly to
   * _ the function, without any transformation.
   */
  g2_string(i_id_ad,
	    d_x_pos, d_y_pos,
	    t_str);
}
/*
 * Compatibility function for gfortran.
 */
void g2_string_ctof_(int *id_ad,
		     float *x_pos, float *y_pos,
		     char *t_str)
{
  g2_string_ctof__(id_ad,
		   x_pos, y_pos,
		   t_str);
}
