*     JLdL 29Jan12.
*     
*     Copyright (C) 2007-2012 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine draws an integration contour, and calculates the
*     _ line integral of the vector function over it; the contour
*     _ is drawn while the mouse Button2 or the combination
*     _ [Shift]-Button2 is pressed; if singularities os zeros of the
*     _ function are detected, then the color of the line is changed
*     _ in order to mark these events.
*     
      SUBROUTINE DRAW_INTEGRATION_CONTOUR
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     Save the value of the integral between consecutive calls
*     _ to this function.
      save ri_acc
*     
*     Initialize that variable at a default value.
      data ri_acc / 0.0 /
*     
*     Choose the color scheme for the contents of this routine.
      call set_color_scheme(ics_cont)
*     
*     Define the initial point.
      rx_ini = px_pos
      ry_ini = py_pos
*     
*     Evaluate the function at the initial point.
      call vector_function
     *     (
     *     rx_ini, ry_ini,
     *     vx_ini, vy_ini,
     *     vm_ini,
     *     sz_flag
     *     )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, change the color of the line to red in order to
*     _ mark the singularity.
      if (sz_flag .eq. 1) then
*     
*     Choose the color scheme for the singularities.
         call set_color_scheme(ics_sing)
*     
*     Check for a null vector, a root of the function; if there
*     _ is one, change the color of the line to green in order
*     _ to mark the root.
      else if (sz_flag .eq. -1) then
*     
*     Choose the color scheme for the roots.
         call set_color_scheme(ics_root)
*     
*     Otherwise, restore the normal colors.
      else
*     
*     Choose the color scheme for the contents of this routine.
         call set_color_scheme(ics_cont)
*     
      end if
*     
*     Initialize the current point.
      rx_cur = rx_ini
      ry_cur = ry_ini
*     
*     Initialize the current value of the vector function.
      vx_cur = vx_ini
      vy_cur = vy_ini
*     
*     Initialize an accumulator for the integral.
      ri_acc = 0.0
*     
*     Take the graphics cursor to the current point.
      call g2_move_(id_vd, rx_cur, ry_cur)
*     
*     Loop while the button state is the one of the required
*     _ ones, but without requiring a change in that state.
      do while
     *     (
     *     (ip_but .eq. 512) .or.
     *     (ip_but .eq. 513)
     *     )
*     
*     Get the state of the pointer device.
         call g2_query_pointer_ctof
     *        (
     *        id_xd,
     *        px_pos, py_pos,
     *        ip_but
     *        )
*     
*     Calculate the variation of the position.
         rx_del = px_pos - rx_cur
         ry_del = py_pos - ry_cur
*     
*     Calculate the distance between the new point
*     _ and the current point.
         p_dist = sqrt(rx_del**2 + ry_del**2)
*     
*     If the distance between the two points is at or over
*     _ the integration interval, then accept the new point
*     _ as part of the integration sequence.
         if (p_dist .ge. del_int) then
*     
*     Define the new point.
            rx_new = px_pos
            ry_new = py_pos
*     
*     Evaluate the function at the new point.
            call vector_function
     *           (
     *           rx_new, ry_new,
     *           vx_new, vy_new,
     *           vm_new,
     *           sz_flag
     *           )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, change the color of the line to red in order to
*     _ mark the singularity.
            if (sz_flag .eq. 1) then
*     
*     Choose the color scheme for the singularities.
               call set_color_scheme(ics_sing)
*     
*     Check for a null vector, a root of the function; if there
*     _ is one, change the color of the line to green in order
*     _ to mark the root.
            else if (sz_flag .eq. -1) then
*     
*     Choose the color scheme for the roots.
               call set_color_scheme(ics_root)
*     
*     Otherwise, restore the normal colors.
            else
*     
*     Choose the color scheme for the contents of this routine.
               call set_color_scheme(ics_cont)
*     
            end if
*     
*     Evaluate the function at the middle point between the
*     _ new one and the current one, in order to improve
*     _ the evaluation of the integral.
*     
*     Define the middle point.
            rx_mid = 0.5 * (rx_new + rx_cur)
            ry_mid = 0.5 * (ry_new + ry_cur)
*     
*     Evaluate the function at the middle point.
            call vector_function
     *           (
     *           rx_mid, ry_mid,
     *           vx_mid, vy_mid,
     *           vm_mid,
     *           sz_flag
     *           )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, change the color of the line to red in order to
*     _ mark the singularity.
            if (sz_flag .eq. 1) then
*     
*     Choose the color scheme for the singularities.
               call set_color_scheme(ics_sing)
*     
*     Check for a null vector, a root of the function; if there
*     _ is one, change the color of the line to green in order
*     _ to mark the root.
            else if (sz_flag .eq. -1) then
*     
*     Choose the color scheme for the roots.
               call set_color_scheme(ics_root)
*     
*     Otherwise, restore the normal colors.
            else
*     
*     Choose the color scheme for the contents of this routine.
               call set_color_scheme(ics_cont)
*     
            end if
*     
*     Calculate a weighted average of the three values, with
*     _ weights given by their fractions of the interval.
            vx_avr = 0.25 * (vx_new + 2.0 * vx_mid + vx_cur)
            vy_avr = 0.25 * (vy_new + 2.0 * vy_mid + vy_cur)
*     
*     Accumulate the line integral.
            ri_acc = ri_acc
     *           + rx_del * vx_avr
     *           + ry_del * vy_avr
*     
*     Draw a line to the new point.
            call g2_line_to_(id_vd, rx_new, ry_new)
*     
*     Flush the graphics buffers.
            call g2_flush_ctof(id_vd)
*     
*     Pass the new point to the current point.
            rx_cur = rx_new
            ry_cur = ry_new
*     
*     Pass the value of the vector function.
            vx_cur = vx_new
            vy_cur = vy_new
*     
         end if
*     
*     Sleep-wait for 0.01 second, in order to avoid
*     _ idly overloading the system.
         call musleep_ctof(10000)
*     
      end do
*     
*     If the button state corresponds to [Shift]-Button2, with
*     _ the Button2 switched off and the [Shift] left on, then
*     _ complete the integral on the last part of the contour,
*     _ from the current point back to the initial point, and
*     _ hence close the contour.
      if (ip_but .eq. 1) then
*     
*     Calculate the variation of the position.
         rx_del = rx_ini - rx_cur
         ry_del = ry_ini - ry_cur
*     
*     Evaluate the function at the middle point between the
*     _ current one and the first one, in order to improve
*     _ the evaluation of the integral.
*     
*     Define the middle point.
         rx_mid = 0.5 * (rx_ini + rx_cur)
         ry_mid = 0.5 * (ry_ini + ry_cur)
*     
*     Evaluate the function at the middle point.
         call vector_function
     *        (
     *        rx_mid, ry_mid,
     *        vx_mid, vy_mid,
     *        vm_mid,
     *        sz_flag
     *        )
*     
*     Check for a possible singularity in the function; if there
*     _ is one, change the color of the line to red in order to
*     _ mark the singularity.
         if (sz_flag .eq. 1) then
*     
*     Choose the color scheme for the singularities.
            call set_color_scheme(ics_sing)
*     
*     Check for a null vector, a root of the function; if there
*     _ is one, change the color of the line to green in order
*     _ to mark the root.
         else if (sz_flag .eq. -1) then
*     
*     Choose the color scheme for the roots.
            call set_color_scheme(ics_root)
*     
*     Otherwise, restore the normal colors.
         else
*     
*     Choose the color scheme for the contents of this routine.
            call set_color_scheme(ics_cont)
*     
         end if
*     
*     Calculate a weighted average of the three values, with
*     _ weights given by their fractions of the interval.
         vx_avr = 0.25 * (vx_ini + 2.0 * vx_mid + vx_cur)
         vy_avr = 0.25 * (vy_ini + 2.0 * vy_mid + vy_cur)
*     
*     Accumulate the line integral.
         ri_acc = ri_acc
     *        + rx_del * vx_avr
     *        + ry_del * vy_avr
*     
*     Draw the last part of the closed contour,
*     _ back to the initial point.
         call g2_line_to_(id_vd, rx_ini, ry_ini)
*     
      end if
*     
*     Write the result of the integration on the lower left-hand
*     _ corner of the plotting window, in reversed colors; note
*     _ that, since the size of the font is defined in pixels,
*     _ all dimensions here must also be given in pixels; since
*     _ the sizes and positions are to be given to the graphics
*     _ functions in coordinate units, we must use here the
*     _ inverse coordinate multipliers "xc_div" and "yc_div".
*     
*     Draw the background rectangles for the text, using reversed
*     _ colors, so use the normal colors for the rectangles.
      call set_color_scheme(ics_norm)
*     
*     Draw a background rectangle.
      call g2_filled_rectangle_ctof
     *     (
     *     id_vd,
     *     xr_min,                 yi_min,
     *     xr_min + 69.0 * xc_div, yi_min + 15.0 * yc_div
     *     )
*     
*     Reverse the colors in order to draw the text.
      call set_color_scheme(ics_reve)
*     
*     Draw the floating-point result as a string.
      call g2_float_string_ctof
     *     (
     *     id_vd,
     *     xr_min +  2.0 * xc_div, yi_min +  1.0 * yc_div,
     *     ri_acc,
     *     '%.4f'
     *     )
*     
*     Flush the graphics buffers.
      call g2_flush_ctof(id_vd)
*     
      return
*     
      END
