*     JLdL 11Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine monitors events that should lead to some action
*     _ within the program, such as the appearance of the temporary
*     _ data-transfer file, or a click of a mouse button, in this
*     _ case limited to the mouse position being within the active
*     _ coordinate area of the plotting window, that is, within the
*     _ coordinate ranges; the return variable "ievent" indicates
*     _ the type of event detected; the currently supported events
*     _ and the corresponding values of the variable are:
*     _ 
*     _ Event:               Value:    Function:
*     _
*     _ File                    0      Read data-transfer file.
*     _
*     _ Button1                 1      Plot single value.
*     _ [Shift]-Button1         2      Plot multiple values (fast).
*     _ [Ctrl]-Button1          3      Plot multiple values (slow).
*     _ Right-[Alt]-Button1     4      (currently unused)
*     _ Left-[Alt]-Button1      5      (currently unused)
*     _
*     _ Button2                21      Draw open integ. contour.
*     _ [Shift]-Button2        22      Draw closed integ. contour.
*     _ [Ctrl]-Button2         23      Draw integral-line contour.
*     _ Right-[Alt]-Button2    24      (currently unused)
*     _ Left-[Alt]-Button2     25      (currently unused)
*     _
*     _ Button3                41      Plot complete field line.
*     _ [Shift]-Button3        42      Plot forward field line.
*     _ [Ctrl]-Button3         43      Plot backward field line.
*     _ Right-[Alt]-Button3    44      (currently unused)
*     _ Left-[Alt]-Button3     45      (currently unused)
*     _ [Shift]-[Ctrl]-Button3 46      Plot multiple field lines.
*     
*     Note that in the case of the button events we must detect a
*     _ change in the button state, not simply that the button is
*     _ currently pressed, in order to avoid the rapid repetition
*     _ of the event, leading to instability in the code.
*     
*     These are the values of "ip_but" for each key or button, as
*     _ well as the binary numbers they correspond to; activating
*     _ two at the same time result in the sum of the numbers:
*     _
*     _    State:                  Value:    Active bits:
*     _    none:                    +0       0000000000000000
*     _    [Shift]:                 +1       0000000000000001
*     _    [Caps Lock]:             +2       0000000000000010 (*)
*     _    [Ctrl]:                  +4       0000000000000100
*     _    Right-[Alt]:             +8       0000000000001000
*     _    Left-[Alt]:              +64      0000000001000000
*     _    Left-Mouse   (Button1):  +256     0000000100000000
*     _    Middle-Mouse (Button2):  +512     0000001000000000
*     _    Right-Mouse  (Button3):  +1024    0000010000000000
*     _ 
*     _ The alternative marked with (*) is not always active and
*     _ hence is not usable in practice.
*     
      SUBROUTINE MONITOR_EVENTS (ievent)
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     Save the values of certain local variables between two
*     _ consecutive calls to this function:
*     _ px_old: the old x position of the pointer device;
*     _ py_old: the old y position of the pointer device;
*     _ ip_old: the old button state of the pointer device.
      save px_old, py_old, ip_old
*     
*     Initialize that variable at a default value.
      data px_old, py_old, ip_old / 0.0, 0.0, 0 /
*     
*     Enter an infinite event-monitoring loop.
      do while ( .true. )
*     
*     Step 1: check for a File event.
*     
*     Try to open an already existing file;
*     _ if it is not there, just continue.
         open(unit=1,
     *        file='complex-functions-params.tmp',
     *        status='old',
     *        iostat=ioerr)
*     
*     If the file is found, set the return variable
*     _ to the appropriate value and return.
         if (ioerr .eq. 0) then
            ievent = 0
*     
            return
*     
         end if
*     
*     Step 2: check for a button event.
*     
*     Get the state of the pointer device.
         call g2_query_pointer_ctof
     *        (
     *        id_xd,
     *        px_pos, py_pos,
     *        ip_but
     *        )
*     
*     Act only if the button state has changed,
*     _ otherwise just continue to wait.
         if (ip_but .ne. ip_old) then
*     
*     Store the new button state.
            ip_old = ip_but
*     
*     Only process the position of the pointer if we have
*     _ a possible button event, that is, if the new
*     _ button-state is one of the supported ones.
            if ( (ip_but .eq.  256) .or.
     *           (ip_but .eq.  257) .or.
     *           (ip_but .eq.  260) .or.
     *           (ip_but .eq.  512) .or.
     *           (ip_but .eq.  513) .or.
     *           (ip_but .eq.  516) .or.
     *           (ip_but .eq. 1024) .or.
     *           (ip_but .eq. 1025) .or.
     *           (ip_but .eq. 1028) .or.
     *           (ip_but .eq. 1029)
     *           ) then
*     
*     Check the position of the pointer cursor; if it
*     _ is not within the window, just continue.
               if ( (px_pos .ge. xr_min) .and.
     *              (px_pos .le. xr_max) .and.
     *              (py_pos .ge. yi_min) .and.
     *              (py_pos .le. yi_max) ) then
*     
*     If it is within the window, then check the value
*     _ of the button-state of the pointer.
*     
*     If it is a Button1 event, then set the return variable
*     _ to the appropriate value and return.
                  if (ip_but .eq. 256) then
*     
                     ievent = 1
*     
                     return
*     
*     If it is a [Shift]-Button1 event, then set the return
*     _ variable to the appropriate value and return.
                  else if (ip_but .eq. 257) then
*     
                     ievent = 2
*     
                     return
*     
*     If it is a [Ctrl]-Button1 event, then set the return
*     _ variable to the appropriate value and return.
                  else if (ip_but .eq. 260) then
*     
                     ievent = 3
*     
                     return
*     
*     If it is a Button2 event, then set the return variable
*     _ to the appropriate value and return.
                  else if (ip_but .eq. 512) then
*     
                     ievent = 21
*     
                     return
*     
*     If it is a [Shift]-Button2 event, then set the return
*     _ variable to the appropriate value and return.
                  else if (ip_but .eq. 513) then
*     
                     ievent = 22
*     
                     return
*     
*     If it is a [Ctrl]-Button2 event, then set the return
*     _ variable to the appropriate value and return.
                  else if (ip_but .eq. 516) then
*     
                     ievent = 23
*     
                     return
*     
*     If it is a Button3 event, then set the return variable
*     _ to the appropriate value and return.
                  else if (ip_but .eq. 1024) then
*     
                     ievent = 41
*     
                     return
*     
*     If it is a [Shift]-Button3 event, then set the return
*     _ variable to the appropriate value and return.
                  else if (ip_but .eq. 1025) then
*     
                     ievent = 42
*     
                     return
*     
*     If it is a [Ctrl]-Button3 event, then set the return
*     _ variable to the appropriate value and return.
                  else if (ip_but .eq. 1028) then
*     
                     ievent = 43
*     
                     return
*     
*     If it is a [Shift]-[Ctrl]-Button3 event, then set the return
*     _ variable to the appropriate value and return.
                  else if (ip_but .eq. 1029) then
*     
                     ievent = 46
*     
                     return
*     
                  end if
*     
               end if
*     
            end if
*     
         end if
*     
*     If the pointer is within the active coordinate area of the
*     _ plotting window, and its position has changed, then draw
*     _ its coordinates on the upper left-hand corner, in reversed
*     _ colors; note that, since the size of the font is defined in
*     _ pixels, all dimensions here must also be given in pixels;
*     _ since the sizes and positions are to be given to the
*     _ graphics functions in coordinate units, we must use here
*     _ the inverse coordinate multipliers "xc_div" and "yc_div";
*     _ note that this data is drawn directly to the X11 window
*     _ alone, and should not appear in the output PS file.
         if ( (
     *        (px_pos .ne. px_old) .or.
     *        (py_pos .ne. py_old)
     *        ) .and.
     *        (px_pos .ge. xr_min) .and.
     *        (px_pos .le. xr_max) .and.
     *        (py_pos .ge. yi_min) .and.
     *        (py_pos .le. yi_max)
     *        ) then
*     
*     Store the current position of the pointer.
            px_old = px_pos
            py_old = py_pos
*     
*     Draw the background rectangles for the text, using reversed
*     _ colors, so use the normal colors for the rectangles.
            call set_color_scheme(ics_norm)
*     
*     Draw two background rectangles.
            call g2_filled_rectangle_ctof
     *           (
     *           id_xd,
     *           xr_min,                  yi_max,
     *           xr_min +  49.0 * xc_div, yi_max - 15.0 * yc_div
     *           )
            call g2_filled_rectangle_ctof
     *           (
     *           id_xd,
     *           xr_min +  58.0 * xc_div, yi_max,
     *           xr_min + 107.0 * xc_div, yi_max - 15.0 * yc_div
     *           )
*     
*     Reverse the colors in order to draw the text.
            call set_color_scheme(ics_reve)
*     
*     Draw the x position.
            call g2_float_string_ctof
     *           (
     *           id_xd,
     *           xr_min +   2.0 * xc_div, yi_max - 15.0 * yc_div,
     *           px_pos,
     *           '%.2f'
     *           )
*     
*     Draw the y position.
            call g2_float_string_ctof
     *           (
     *           id_xd,
     *           xr_min +  60.0 * xc_div, yi_max - 15.0 * yc_div,
     *           py_pos,
     *           '%.2f'
     *           )
*     
         end if
*     
*     If there were no valid events, then sleep-wait for 0.01
*     _ second, in order to avoid idly overloading the system.
         call musleep_ctof(10000)
*     
      end do
*     
      END
