/* JLdL 29Jan12.
 *
 * Copyright (C) 2000-2012 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This module reads a 4-byte integer from the Linux strong
 * _ random number generator device /dev/urandom; since this
 * _ is not a normal file but rather a handle to an internal
 * _ kernel structure, we must do a careful and detailed
 * _ open-file procedure for it.
 *
 * This is to be called from Fortran as a subroutine (a void function),
 * _ that is, as "call urandom_ctof(nseed)".
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
void urandom_ctof__(int *nseed)
{
  /*
   * A file descriptor.
   */
  int fdesc;
  /*
   * A file stream.
   */
  FILE *fstrm;
  /*
   * The size of the data to be read is "size" bites,
   * _ the number of objects to be read is "numb".
   */
  size_t size, numb;
  /*
   * We want to read a single 4-byte integer.
   */
  size=4; numb=1;
  /*
   * Open the file and associate a file descriptor to it;
   * _ this is a system call (man 2).
   */
  fdesc = open("/dev/urandom", O_RDONLY);
  /*
   * Open a stream connected to the file descriptor;
   * _ this is a glibc call (man 3).
   */
  fstrm = fdopen(fdesc, "r");
  /*
   * Read from the stream, in binary form, and put the
   * _ result in the location of the variable nseed;
   * _ this is a glibc call (man 3).
   */
  fread(nseed, size, numb, fstrm);
  /*
   * Close the stream;
   * _ this is a glibc call (man 3).
   */
  fclose(fstrm);
  /*
   * Close the file descriptor;
   * _ this is a system call (man 2).
   */
  close(fdesc);
}
/*
 * Compatibility function for gfortran.
 */
void urandom_ctof_(int *nseed)
{
  urandom_ctof__(nseed);
}
