*     JLdL 30Jan14.
*     
*     Copyright (C) 2007-2014 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This program reads a sequence of numbers from stdin, then
*     _ calculates their average and writes it to stdout.
*     
      PROGRAM AVER
*     
*     Double precision everything.
      implicit double precision (a-h,o-z)
*     
*     The maximum number of numbers that this
*     _ program can deal with, plus one.
      parameter(nmax=10001)
*     
*     Storage for the numbers, in real form.
      dimension rnum(nmax)
*     
*     Read the numbers from stdin; this must be a single
*     _ column of single integer or real numbers.
      do inum=1,nmax
         read(*,*,iostat=ioerr) rnum(inum)
         if (ioerr.ne.0) exit
      end do
*     
*     There must have been an end-of-file read error.
      if (ioerr.ne.-1) then
*     
*     Write an error message and abort.
         if (ioerr.eq.0) then
            write(*,*) 'aver: ERROR: too many numbers'
         else
            write(*,*) 'aver: ERROR: input read error'
         end if
*     
         stop
*     
      end if
*     
*     Determine the number of numbers read in.
      nnum=inum-1
*     
*     Add all the numbers.
      sum=0.0d0
      do inum=1,nnum
         sum=sum+rnum(inum)
      end do
*     
*     Calculate the average.
      ravr=sum/dble(nnum)
*     
*     If the number is an integer, write it out as such;
*     _ otherwise, write it out as a real number.
      navr=int(ravr)
      if (dble(navr).eq.ravr) then
         write(*,*) navr
      else
         write(*,*) ravr
      end if
*     
      END
