if (typeof Test === 'undefined') require('../tester');

Test('dividedBy', function () {
    var n = 'null',
        N = 'NaN',
        I = 'Infinity';

    function t(dividend, divisor, expected, dp, rm) {
        if (dp != null) BigNumber.config({ DECIMAL_PLACES: dp, ROUNDING_MODE: rm });
        Test.areEqual(String(expected), String(new BigNumber(dividend).dividedBy(divisor)));
        //Test.areEqual(String(expected), String(new BigNumber(dividend).dividedBy(new BigNumber(divisor))));
    }

    Test.areEqual(BigNumber.prototype.dividedBy, BigNumber.prototype.div);

    BigNumber.config({
        DECIMAL_PLACES: 40,
        ROUNDING_MODE: 4,
        EXPONENTIAL_AT: [-7, 21],
        RANGE: 1E9
    });

    t(1, 0, I);
    t(1, -0, -I);
    t(-1, 0, -I);
    t(-1, -0, I);
    t(1, N, N);
    t(-1, N, N);
    Test.areEqual('0', new BigNumber(1).div(I).valueOf());
    Test.areEqual('-0', new BigNumber(1).div(-I).valueOf());
    Test.areEqual('-0', new BigNumber(-1).div(I).valueOf());
    Test.areEqual('0', new BigNumber(-1).div(-I).valueOf());
    Test.areEqual('0', new BigNumber(0).div(1).valueOf());
    Test.areEqual('-0', new BigNumber(0).div(-1).valueOf());
    Test.areEqual('-0', new BigNumber(-0).div(1).valueOf());
    Test.areEqual('0', new BigNumber(-0).div(-1).valueOf());
    t(0, 0, N);
    t(0, -0, N);
    t(-0, 0, N);
    t(-0, -0, N);
    t(0, N, N);
    t(-0, N, N);
    Test.areEqual('0', new BigNumber(0).div(I).valueOf());
    Test.areEqual('-0', new BigNumber(0).div(-I).valueOf());
    Test.areEqual('-0', new BigNumber(-0).div(I).valueOf());
    Test.areEqual('0', new BigNumber(-0).div(-I).valueOf());
    t(N, 1, N);
    t(N, -1, N);
    t(N, 0, N);
    t(N, -0, N);
    t(N, N, N);
    t(N, I, N);
    t(N, -I, N);
    t(I, 1, I);
    t(I, -1, -I);
    t(-I, 1, -I);
    t(-I, -1, I);
    t(I, 0, I);
    t(I, -0, -I);
    t(-I, 0, -I);
    t(-I, -0, I);
    t(I, N, N);
    t(-I, N, N);
    t(I, I, N);
    t(I, -I, N);
    t(-I, I, N);
    t(-I, -I, N);

    t(1, '1', '1');
    t(1, '-45', '-0.0222222222222222222222222222222222222222');
    t(1, '22', '0.0454545454545454545454545454545454545455');
    t(1, 0144, '0.01');
    t(1, '0144', '0.0069444444444444444444444444444444444444');
    t(1, '6.1915', '0.1615117499798110312525236210934345473633');
    t(1, '-1.02', '-0.9803921568627450980392156862745098039216');
    t(1, '0.09', '11.1111111111111111111111111111111111111111');
    t(1, '-0.0001', '-10000');
    t(1, '8e5', '0.00000125');
    t(1, '9E12', '1.111111111111111111111111111e-13');
    t(1, '1e-14', '100000000000000');
    t(1, '3.345E-9', '298953662.1823617339312406576980568011958146487294');
    t(1, '-345.43e+4', '-2.894942535390672495150971253220624e-7');
    t(1, '-94.12E+0', '-0.0106247343816404589885252868678283042924');
    t(1, ' 4.001', '0.2499375156210947263184203949012746813297');
    t(1, '4.001 ', '0.2499375156210947263184203949012746813297');
    t(1, I, '0');
    t(1, -I, '0');
    t(1, Number.POSITIVE_INFINITY, '0');
    t(1, Number.NEGATIVE_INFINITY, '0');
    t('0', 0, N);
    t(0, '+0', N);
    t('0', '0', N);
    t(3, -0, -I);
    t(9.654, 0, I);
    t(0, '0.001', '0');
    t(0, '111.1111111110000', '0');
    t(N, 0, N);
    t(0, N, N);
    t(N, '0', N);
    t(-1, 1, '-1');
    t(-0.01, 0.01, '-1');
    t(54, -54, '-1');
    t(9.99, '-9.99', '-1');
    t('0.0000023432495704937', '-0.0000023432495704937', '-1');
    t(NaN, NaN, N);
    t(NaN, N, N);
    t(N, NaN, N);
    t(N, 4, N);
    t(N, '4534534.45435435', N);
    t(N, 99999.999, N);
    t(Infinity, '354.345341', I);
    t(3, -I, '0');              // 78
    t(-Infinity, -I, N);
    t(-I, -Infinity, N);
    t(I, '-999e999', -I);
    t(1.21123e43, -I, '0');
    t('-999.0', I, '0');
    t('657.342e-45', -I, '0');
    t(I, 123, I);
    t(-0, I, '0');
    t(100, 100, '1');
    t(-999.99, '0.01', '-99999');
    t('10 ', 4, '2.5');
    t('03.333', -4, '-0.83325');
    t(-1, -0.1, '10');
    t(43534.5435, '0.054645', '796679.3576722481471314850398023606917375789185');
    t('99999', '1', '99999');
    t(' +3e0', 4, '0.75');

    t('999.5', 1, '1000', 0, 0);
    t('-999.5', 1, '-1000', 0, 0);

    t('999.5', 1, '999', 0, 1);
    t('-999.5', 1, '-999', 0, 1);

    t('999.5', 1, '1000', 0, 2);
    t('-999.5', 1, '-999', 0, 2);

    t('999.5', 1, '999', 0, 3);
    t('-999.5', 1, '-1000', 0, 3);

    t('999.5', 1, '1000', 0, 4);
    t('-999.5', 1, '-1000', 0, 4);

    t('999.5', 1, '999', 0, 5);
    t('-999.5', 1, '-999', 0, 5);

    t('999.5', 1, '1000', 0, 6);
    t('-999.5', 1, '-1000', 0, 6);
    t('999.4', 1, '999', 0, 6);
    t('-999.4', 1, '-999', 0, 6);
    t('999.500001', 1, '1000', 0, 6);
    t('-999.500001', 1, '-1000', 0, 6);

    t('999.5', 1, '1000', 0, 7);
    t('-999.5', 1, '-999', 0, 7);

    t('999.5', 1, '999', 0, 8);
    t('-999.5', 1, '-1000', 0, 8);

    t('-2.8', '3', '-1', 0, 3);
    t('-3', '-0.0047', '638.297872341', 9, 0);
    t('15', '-3', '-5', 11, 0);
    t('3', '0.38', '7.894736842106', 12, 2);
    t('-2.9', '-2.2', '1.3181818181818182', 16, 4);
    t('-1.20', '0.00035', '-3428.571428571', 9, 4);
    t('-6', '-1.0', '6', 14, 1);
    t('1.1', '-1.5', '-0.7333333', 7, 5);
    t('-1.05', '-2', '0.525', 9, 2);
    t('-2', '-1', '2', 13, 0);
    t('-5', '1', '-5', 16, 6);
    t('0.000033', '-1', '-0.000033', 11, 1);
    t('6', '-3', '-2', 20, 6);
    t('-1.20', '1', '-1.2', 13, 2);
    t('-1', '0.0019', '-526.315', 3, 1);
    t('-7', '3', '-2.333333333333', 12, 1);
    t('2', '4', '0.5', 8, 0);
    t('33', '-2', '-16.5', 14, 3);
    t('-2', '-1', '2', 4, 1);
    t('-10.2', '12', '-0.85', 16, 6);
    t('-1.0', '10', '-0.1', 10, 0);
    t('1.3', '-3.0', '-0.434', 3, 3);
    t('1.4', '6', '0.233333333333333333', 18, 5);
    t('55', '2', '27.5', 4, 4);
    t('1', '7', '0.14285714285714286', 17, 5);
    t('-1.4', '2', '-0.7', 12, 5);
    t('-5', '3', '-2', 0, 4);
    t('-1', '2', '-0.5', 15, 0);
    t('-8', '-3', '2.67', 2, 2);
    t('-16', '7', '-2.285714285714', 12, 4);
    t('1', '1', '1', 13, 6);
    t('0.000019', '1', '0.000019', 13, 4);
    t('26', '-7.7', '-3.376623', 6, 6);
    t('-5.7', '-9.1', '1', 0, 4);
    t('1', '6.9', '0.144927536232', 12, 0);
    t('33', '-5.5', '-6', 3, 2);
    t('1.9', '1', '1.9', 18, 2);
    t('-5', '0.00014', '-35714.2857142857142858', 16, 0);
    t('3.0', '3', '1', 1, 4);
    t('-2', '3', '-0.666666666666667', 15, 3);
    t('5', '3', '1.66666666666666666', 17, 1);
    t('-0.000059', '-4', '0.00001475', 10, 5);
    t('1.0', '3', '0.333', 3, 6);
    t('2', '4', '0.5', 16, 4);
    t('-6.3', '5.2', '-1.211538', 6, 4);
    t('3.5', '-1.7', '-2.0588235294117647058', 19, 1);
    t('3', '3', '1', 17, 2);
    t('3.5', '-6', '-0.5833333333', 10, 6);
    t('1', '-5.4', '0', 0, 4);
    t('-3.0', '-1.5', '2', 14, 3);
    t('-3', '-3', '1', 10, 1);
    t('11', '1', '11', 10, 6);
    t('-3.0', '-1.1', '2.7272727272727272', 16, 3);
    t('-1.2', '-7', '0.2', 1, 6);
    t('3', '7', '0.42857142858', 11, 2);
    t('1', '2', '0.5', 19, 5);
    t('-2', '-0.51', '3.92156862745098', 15, 1);
    t('8', '4', '2', 15, 1);
    t('1.2', '0.000016', '75000', 13, 5);
    t('37', '-2.5', '-14.8', 3, 2);
    t('0.015', '26', '0.00058', 5, 6);
    t('6', '-91', '-0.06593406', 8, 1);
    t('-3', '2', '-1.5', 13, 4);
    t('1', '-19', '-0.0526315789473684211', 19, 4);
    t('1.8', '3', '0.6', 4, 3);
    t('-1', '-8.7', '0.114943', 6, 4);
    t('-0.0056', '1', '-0.0056', 7, 1);
    t('7', '0.00119', '5882.35294117647059', 14, 4);
    t('1.2', '-1.0', '-1.2', 18, 3);
    t('-0.000013', '-0.38', '0.0000342105263157895', 19, 2);
    t('1', '-3', '-0.333333333333333333', 18, 6);
    t('5.8', '-2.1', '-2.761904761904762', 16, 3);
    t('-9', '-6.3', '1.429', 3, 6);
    t('-12', '-0.00027', '44444.444444444444', 12, 5);
    t('-9', '-2', '4.5', 16, 1);
    t('1', '3', '0.3333333333333', 13, 5);
    t('-1', '2', '-0.5', 16, 2);
    t('1', '-0.014', '-71.42857142857143', 14, 4);
    t('-4', '-7', '1', 0, 6);
    t('1.1', '1.2', '0.9166666666666', 13, 1);
    t('-1', '-6.1', '0.16393442622951', 14, 5);
    t('5', '2.8', '1.785714285714286', 15, 4);
    t('-1', '7', '-0.142857142857', 12, 6);
    t('-1', '0.000016', '-62500', 4, 3);
    t('-3', '-1.4', '2.14285715', 8, 2);
    t('6', '1', '6', 18, 5);
    t('-0.60', '-7', '0.0857142857', 10, 5);
    t('1', '3', '0.3333', 4, 4);
    t('-1', '-0.0061', '163.93442622950819672131', 20, 4);
    t('1.9', '-5', '-0.38', 17, 1);
    t('-9.5', '-3.1', '3.06451612903', 11, 5);
    t('-9', '-3', '3', 3, 2);
    t('-0.00090', '-5', '0.00018', 19, 1);
    t('6', '-2', '-3', 2, 2);
    t('4', '10.7', '0.373831775701', 12, 6);
    t('-20', '5.2', '-3.8461538461538462', 16, 5);
    t('-2', '1.22', '-1.639344262295082', 15, 6);
    t('-2.3', '2.5', '-0.92', 17, 6);
    t('0.000123', '-1.5', '-0.0001', 4, 6);
    t('-8', '1', '-8', 0, 6);
    t('-1.4', '-2.2', '0.6363636363636', 13, 1);
    t('7', '-3', '-2.33333333333333', 14, 6);
    t('7', '-0.076', '-92.105', 3, 5);
    t('-2.9', '8.0', '-0.3625', 11, 5);
    t('2', '6.6', '0.30303030303', 12, 5);
    t('-8', '10.0', '-0.8', 16, 6);
    t('8', '-1.1', '-7.27272727272728', 14, 0);
    t('4', '1', '4', 12, 5);
    t('-6', '9', '-0.67', 2, 3);
    t('1', '0.000033', '30303.03030303030303030304', 20, 0);
    t('2.0', '3', '0.66666666667', 11, 5);
    t('-2', '-30', '0.06666666667', 11, 4);
    t('1.8', '-1', '-1.8', 14, 5);
    t('2.6', '-0.00010', '-26000', 16, 6);
    t('-6.4', '-3', '2', 0, 6);
    t('-1', '8', '-0.125', 18, 6);
    t('-1.00', '3', '-0.33333333333333333', 17, 4);
    t('-4.0', '4', '-1', 14, 2);
    t('1', '2', '0.5', 5, 5);
    t('-0.00012', '8', '0', 3, 5);
    t('-2.9', '5.3', '-0.5471698113207548', 16, 0);
    t('-2', '3', '-0.66666666667', 11, 5);
    t('-5', '-6', '0.833333333333', 12, 1);
    t('97', '0.032', '3031.25', 20, 5);
    t('-8', '1.7', '-4', 0, 1);
    t('-1.1', '-5.5', '0', 0, 5);
    t('-15', '-3', '5', 4, 5);
    t('-6.1', '4', '-1.53', 2, 3);
    t('-2.7', '-6.7', '0.4029850746268656716', 19, 5);
    t('-4.8', '-4', '1.2', 3, 6);
    t('-8', '5', '-1.6', 8, 2);
    t('2', '6.1', '0.3278688524590163', 16, 1);
    t('5.6', '-15', '-0.373333333334', 12, 3);
    t('-3', '-4', '0.75', 7, 1);
    t('1.0', '0.00018', '5555.5555', 4, 1);
    t('-14', '-0.00012', '116666.6666667', 7, 2);
    t('-0.0000113', '-6', '0.00000188333', 11, 5);
    t('-2.0', '-7.7', '0.26', 3, 5);
    t('-3', '0.0073', '-410.958904109589041096', 18, 0);
    t('4.4', '-1', '-4', 0, 1);
    t('-3', '-1.4', '2.14285714285714', 14, 1);
    t('-2.2', '-7.6', '0.2895', 4, 5);
    t('3.8', '9.4', '0.40425531914893617', 18, 3);
    t('-1', '7', '-0.14285714285714', 14, 4);
    t('-5', '-4.3', '1.1627906977', 10, 6);
    t('3', '2', '2', 0, 4);
    t('2.7', '1', '2.7', 5, 2);
    t('4', '2', '2', 16, 2);

    t('4', '-0.0025', '-1600', 44, 2);
    t('205783.0120', '-6.58', '-31274.01398176291793313069908814', 26, 1);
    t('2.6', '0.0000014140003', '1838754.9139841059439662070793054287187916438207262049378631673557637', 61, 0);
    t('-43506731.7020', '0.0000000000000020852', '-2.0864536592173412622290427776712065988e+22', 15, 1);
    t('85374685.72', '-4602612.194', '-18.54918079591738899390748887413215766', 35, 5);
    t('-11.889579111', '-7', '1.698511301571428572', 18, 0);
    t('21.6', '-3', '-7.2', 24, 6);
    t('-180.72', '0.0000000001581', '-1143074003795.0664136622390891840607210626185958254269449715370018976', 55, 3);
    t('-0.00119467686529', '20885766', '-5.72005290727665913713674662447142230742219366050543705220100617e-11', 73, 1);
    t('-0.000000015740712', '-0.0000000000000000000266', '591756090225.56', 2, 1);
    t('-10', '1197', '-0.00835', 5, 5);
    t('-0.0000000000000000000759363178177', '3.916', '-1.939129668480592441266598569969356486210418794688457609806e-20', 77, 6);
    t('-52073715', '157.5445101', '-330533.351920334544', 12, 4);
    t('-325.0', '-90', '3.6111111111111111111111111111111111', 34, 5);
    t('-0.00000000000000031', '-0.0000000000000032', '0.096875', 9, 6);
    t('-0.00000000879', '-5.6', '1.5696428571428571428571428571428571428571428571428571428571428571428571428571429e-9', 88, 2);
    t('-0.00000251681', '127.91', '-1.96764131029630208740520678602142131185990149323743256977562348526307560003127198811664e-8', 94, 2);
    t('2961036591.4', '0.000013043', '227021129448746.45403664801042704899179636586674844744307291267', 47, 4);
    t('4', '3.38', '1.1834319526627218934911242603550295857988165680473372781065088757396449704142011835', 82, 2);
    t('-0.0000000000001136', '0.00000000000000144185989652', '-78.7871278438211', 13, 2);
    t('11.8853', '-3', '-3.961766666666666667', 18, 3);
    t('-1.20', '-9568301.017', '1.25414114571433324713095196302601858245865008826571702745166676229370972349291e-7', 85, 5);
    t('0', '-6988.9', '0', 99, 3);
    t('5', '-3936814629.28', '-1.2700623399468e-9', 22, 3);
    t('2102712', '0.00000000000000304964', '689495153526317860468.77664248894951535263178604687766424889495153526317860468776642488949515352631786046877665', 89, 2);
    t('0.00000000000000000006318187', '89048', '1e-16', 16, 0);
    t('-18.472', '-2304.31', '0.00801628253143023', 17, 4);
    t('0.933711', '-41.4', '-0.022553405797101', 15, 5);
    t('-0.00000000159747', '-54.285323180', '2.9427290958609339534561098287634805235030747771261587614997044952657496548775267e-11', 91, 6);
    t('36.0', '0.15278', '235.6329362482000261814373609111140202', 34, 2);
    t('3273788', '2.0', '1636894', 51, 4);
    t('-144.7', '0.000484419582', '-298707.99071042', 8, 4);
    t('-0.000136434', '5.30860461610', '0', 1, 2);
    t('0.00000000000027963249176', '690.93615', '0', 5, 6);
    t('0.000000000000000041166', '-954146.63778', '-4.31443117546170598004200620115714474e-23', 58, 4);
    t('80606.45399', '29030.6863', '2.7765948471566102796543256368003948980014296113970960445396015319141', 67, 1);
    t('-307761.1715', '3', '-102587.057166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666', 96, 1);
    t('-1.09', '-1.1', '0.990909090909090909090909090909090909090909', 42, 4);
    t('-0.000000122', '1489.273', '-8.1919164585673681051090028490411093197822024e-11', 54, 1);
    t('1663.22977564', '10487', '0.158599196685420043863831410317535996948603032325736626299227615142557452083', 75, 3);
    t('-98', '-4242.281285', '0.023100778429405819091036534132130279051027', 42, 4);
    t('0.00880312', '32.53937', '0.000270537505796823970470233443364146263434110740312427683756630813688157', 72, 4);
    t('5.82', '805.9', '0.0072217396699342350167514579972701327708152', 43, 3);
    t('5', '20.1', '0.2487562189054726368159203980099502487563', 40, 2);
    t('-0.000000190702099115', '-0.00000000000005357223', '3559719.2634131526725693516958319636871565734709942072599927238421846542509057', 70, 6);
    t('35.8812641704', '2402312', '0.00001493613825781164145206784131286860324554', 45, 6);
    t('-1425073364', '-10284292.72', '138.5679504462801793918600169910371', 31, 3);
    t('138823.37071', '-25036.2', '-5.5449058047946573361772153921122215032632747781212803860010704499884167725135', 76, 3);
    t('-1.0', '2.7', '-0.37037037037037037037037037037037037037037037037037037037037037037037037037037037037037037037038', 95, 3);
    t('29638493.73', '41.59351', '712574.96013200136271259626802354501940326748091228655624399094954958117263967383373031032966441159', 92, 5);
    t('-1392357420', '65060.9365', '-21400.8204447', 7, 5);
    t('-1.11047040', '0.000000226215484', '-4908905.35150104932693289907599782161684387616897170487233314232371468', 62, 6);
    t('-220.431900', '1674.3721017', '-0.1316504854423901203011', 22, 2);
    t('5.6685641929', '-924503127242', '-6.131471085241861e-12', 27, 3);
    t('-760.5', '-5.9896920', '126.968131249486618009740734582011896438080623', 42, 2);
    t('-0.00000065', '-32268321', '2e-14', 14, 5);
    t('-1.11', '104938.6447517', '-0.0000105776094462285121510625524763430267264835898746917817157441798492755443580876965212689285842', 97, 6);
    t('0.0000000000000000000389', '0.000000004345746504', '8.95128143443131675128191048301422047234994450564482e-12', 62, 6);
    t('-30614604.60', '-178450189969', '0.000171558262870542789273504424217640996351681502199029', 54, 0);
    t('5.09', '-261.708521', '-0.019449118357135952787719892391276018101069', 43, 2);
    t('-17657942.918', '0.000000000000120', '-147149524316666666666.66666666666666666666666667', 26, 0);
    t('-5228', '799347.8', '-0.006540332005667620527635154559754840133418769651', 48, 2);
    t('949309450.95', '-1', '-949309450.95', 85, 2);
    t('-122597442444', '-0.0000000000088102620620', '1.391530031470702919937729316547088199429316816614801e+22', 29, 1);
    t('-429572333.64', '-153.40', '2800341.158', 4, 4);
    t('-6', '0.0023', '-2608.6956521739130434782608695652173913043478260869565217391304347826086956522', 73, 6);
    t('13023138.990', '0.0000912303', '142750149785.7619672411468558143511530708547489156563115543848919', 52, 6);
    t('-1', '-356.9405623', '0.002801586890423296674455874806582608445675102249369656467312', 60, 0);
    t('-0.1761', '-1', '0.1761', 33, 3);
    t('-0.00000000000000001080427993', '0.00000000000000000542', '-1.993409581180811808118081180811808118081180811808118081180811808118081180811808118081180811808118081', 99, 6);
    t('-3', '-0.00000000000028491', '10529640939243.9717805622828261556280930820259029167105401705801832157523428', 61, 1);
    t('-2.11', '-1', '2.11', 81, 1);
    t('-125.8754715', '54.73', '-2.29993552896035081308240453133564772519641878311712040928193', 59, 5);
    t('-0.00000138983610179', '65323.63269', '-2.127616062605718506314134992421224454104988018234477033e-11', 66, 6);
    t('0.0000000627720', '2089419.6460', '3.0042792083520018744956320756256543784790276639334327384801473241244712599969494113e-14', 96, 6);
    t('-217', '13400814874', '-1.6193045127503341107643153014427650841973716232087e-8', 57, 0);
    t('-209172.068', '-95.8169', '2183.03940119123035706645', 20, 2);
    t('722260.251', '312846', '2.309', 3, 5);
    t('0.000000000000000000043026447166', '999.3474', '4.30545445617810182925377101096e-23', 52, 6);
    t('0.000001001769', '0.0000000000000545377150533', '18368371.300868872296239200828462479512442900146931227723210727885333446839709498', 72, 5);
    t('-21639.9', '1', '-21639.9', 1, 4);
    t('-4064.98760', '-1050752806.1', '0.00000386864310654349629150136228220537701973975247040741640708905074224574083676101638345175007951', 99, 2);
    t('-0.00000000000000612', '-38134.257', '1.60485623202256176120069679081462108990349543194194133636850457057548020405904329e-19', 99, 4);
    t('-265049816341', '-2', '132524908170.5', 49, 4);
    t('18', '1', '18', 75, 4);
    t('-0.0000000922', '-282.900786', '3.259093101283e-10', 22, 5);
    t('-260074626.109', '-8.200', '31716417.8181707317073170731707317073170731707317073170731708', 52, 0);
    t('-0.0000000000000003606626', '121920.32', '-2.9581828525384447809848268114781851e-21', 56, 4);
    t('0.051829', '-21845698', '-2.372503731e-9', 18, 3);
    t('0', '-108765478', '0', 37, 4);
    t('4.06', '-81.9529', '-0.049540650788440677511106989502506927759725403249915500244652721258186104457560379193414754085', 93, 0);
    t('11', '8.168', '1.34671890303623898139079333986287952987267384916748285994123408423114593535749265426053', 86, 4);
    t('3.0', '-187113.5', '-0.00001603304945928540699', 23, 4);
    t('0', '29.1292', '0', 86, 3);
    t('-539', '1.63309627', '-330.0479034221295478190027339906911', 31, 2);
    t('4.6', '9576522.7', '4.8034136649621265973712984567978938743600534670063487e-7', 59, 3);
    t('888.495', '2', '444.2475', 5, 0);
    t('0.0000000660515321', '0.000000000000000000157532', '419289617982.37818348', 9, 6);
    t('1194135', '19.3', '61872.2797927461139896373056994818652849740932642487046632124352331606217616580310880829015544041450777202', 100, 5);
    t('-199941187483', '1605', '-124573948.587538940809968847', 18, 6);
    t('0', '-0.000000000013210', '0', 47, 1);
    t('-15579.9582254', '1.82', '-8560.41660736263736263736263736263736263736263736263736263736263736263736', 68, 1);
    t('0.00021763543', '0.000000000000000006304245', '34522045066459.1874205', 7, 5);
    t('-9.6', '-6245', '0.001537229783827061649319455564451561248999199359487590072057646', 63, 1);
    t('-1558.3541291', '-0.0000000000905501700', '17209842114045.72735755217245864916653386735773108', 35, 4);
    t('-2196.0533764', '-6.3', '348.5799', 5, 1);
    t('134631.169', '-0.0051', '-26398268.43137254901960784313725490196078431373', 38, 6);
    t('0', '3', '0', 62, 0);
    t('-81.21601', '0.000000000000000331', '-245365589123867069.4864048338368580060422960725076', 31, 0);
    t('-0.18606', '-2.1', '0.0886', 35, 2);
    t('-0.000000000000000000461', '-19253159', '2.394412262424052073740210632447381751742662e-26', 68, 4);
    t('-929', '-424621853.40', '0.000002187828988454978092279223234156793', 39, 3);
    t('2.0', '-1186150187', '-1.68612712110123370068650505553560225506249488118151769932655e-9', 68, 6);
    t('0.000000000000000000522', '128362.3152', '0', 19, 5);
    t('-6.08', '-930214.3174', '0.0000065361281655972929233694893030249977100599720354293484668310696547444906054936625511027637511', 97, 1);
    t('-13468.73594', '-17.44', '772.28990481651376146788990826', 26, 5);
    t('-4.94229', '-2', '2.471145', 9, 0);
    t('-24.40246', '35.4837273223', '-0.687708474883474291', 18, 3);
    t('1', '29.98403894', '0.0333510772848536061833169430909230269296068356826913859390818947489000292767095', 79, 1);
    t('-430', '1689585.07', '-0.00025450035493033801488314524464873', 35, 2);
    t('3083081101.8', '-1', '-3083081101.8', 35, 1);
    t('2.4', '4.3', '0.558139534883720930232558139534883720930232558139534883720930232', 63, 3);
    t('467216723', '1.1', '424742475.45454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454', 95, 1);
    t('0', '-16208070.9330', '0', 9, 1);
    t('-14.01', '264360777.70', '-5.2995758757748578e-8', 24, 4);
    t('1', '-1', '-1', 67, 1);
    t('510', '1087.241548591', '0.46907699642359095636184954255459240447481123022295185773956042018', 65, 6);
    t('-522.4', '-0.0000000430', '12148837209.302325581395348837209', 21, 6);
    t('-0.0001750931579', '-1641610', '1.0665941234519770225571237991971296471147e-10', 50, 6);
    t('-61755625405', '-5.209793', '11853757990.9', 1, 3);
    t('0.0000052665303263', '0.00000029854211122', '17.64082897644887901654', 20, 0);
    t('-17926303.14', '11.395', '-1573172.7', 1, 4);
    t('0', '-3.40233', '0', 98, 1);
    t('-0.0000000965828945324', '1.2', '-8.04857454436666666666666666666666666666666666666666666666666666666666666666666666666666666667e-8', 100, 0);
    t('-22442925.654', '20806718.15', '-1.07863842304222302353', 20, 6);
    t('0', '0.0000000000005381', '0', 12, 5);
    t('-95.4860600', '92963', '-0.00102714047524283854866990092832632337596678248335359228940546238826199', 71, 2);
    t('-25.24782827', '96008.9585', '-0.00026297', 8, 5);
    t('38', '14576527.63', '0.000002606930879875127022964384831341344632706602978531177', 57, 3);
    t('546214273620', '-2', '-273107136810', 56, 3);
    t('13', '3015907', '0.0000043104777435113218', 22, 4);
    t('-1.271', '-6.28', '0.202388535031847133757961783439490445859872611464968152867', 57, 0);
    t('-6', '6964.78469', '-0.00086147673863', 14, 4);
    t('-142.72', '-26745.79', '0.005336166925710551081123421667484863972984159376111156185702497477173042934982', 78, 4);
    t('-28.0', '2363923123', '-1.1845e-8', 12, 0);
    t('-91504451.175', '-18397.6177841', '4973.71193645', 8, 5);
    t('-1151830', '5.2289', '-220281.5123639771271204268584214653177532559429325479546367304786857656486067815410506989997896307062670925', 100, 2);
    t('0.0000000129422662', '-776', '-1.6678178092783505154639175257731958762886597938144329896907216494845360824742268041237e-11', 96, 6);
    t('30323', '-0.00000000000000071420145253', '-42457208526506439363.7659352409214288776209918638766283439', 37, 1);
    t('-0.000000000000000000036513', '62054611', '-1e-8', 8, 0);
    t('-0.000000000000302978047', '-0.00000000000030', '1', 0, 5);
    t('36.98', '-0.61069704476', '-60.5537562647497361045', 19, 3);
    t('-2209843.27987', '30200516.420', '-0.07317236729126104129049856823607256713261196611021395', 53, 5);
    t('-11.0', '-2.17', '5.069124423963133640552995391705069124423963133640552995391705069124423963133640552995391705069124424', 99, 2);
    t('-0.000000470683', '0.000029822775', '-0.01578266945312768513325805529498848', 35, 3);
    t('-198.608', '-3.933769477', '50.4879610158203482344016367484769113225797699685593447396612662', 61, 2);
    t('-38294.7981', '34.2598', '-1117.77646396067694499092230544253031249452711340988563856181297030338764382745958821', 80, 0);
    t('0', '27.783', '0', 74, 5);
    t('-7', '-251.5', '0.02783300198807157057654076', 26, 4);
    t('54335.16', '-0.000000411', '-132202335766.42335766423357664233576642335766423357664233576642335766423357664233576642', 74, 1);
    t('-40946555.55', '2.60', '-15748675.211538461538461538461538', 24, 4);
    t('-198237302872', '7', '-28319614696', 97, 5);
    t('0.00000000000000000005371334', '8', '6.7141675e-21', 85, 1);
    t('1.5258', '-1190852944', '-1.2812665137938307855415605371337940782720187e-9', 52, 2);
    t('1', '-0.00000000000000000005562070', '-17978917920846015961.6833301270929707824604868331394606684202104612131815', 52, 3);
    t('-5.2', '-23421458', '2.2201862924161254179820914650146886671188446082220842101290192950413249252032047e-7', 86, 4);
    t('-1416968', '195116', '-7.2622', 4, 0);
    t('-2235863915', '4049', '-552201.510249444307236354655470486539886391701654729562855025932328970116', 66, 1);
    t('0.000000026', '-135677754', '0', 9, 1);
    t('0.000000000000000000040315579', '-2031.1', '0', 1, 1);
    t('19.54706', '26', '0.75181', 23, 0);
    t('-7', '777276.6629', '-0.000009005802353415800720292', 27, 5);
    t('-562908.8975', '-41412.2282', '13.59281840091859630967647377158034688894136828889588703657341480601616', 68, 4);
    t('51.0770', '-0.00000000049300', '-103604462474.645030425963488843813387423935091277890466531', 45, 6);
    t('-46603.49', '-7', '6657.64142857142857142857142857142857142857142857142857142857142857142857', 68, 1);
    t('82292411.5750', '0.00000000000000000001936', '4.25064109375e+27', 37, 5);
    t('0', '435', '0', 42, 4);
    t('-1.25603776', '35257646', '-3.562454963669440665437505385356696814075e-8', 47, 6);
    t('0.0000137705283114', '2102089', '6.55087787025192558450189311679952656619201185106815e-12', 62, 5);
    t('-1.452', '-0.00000000000003591683', '40426730309996.7342', 4, 0);
    t('2', '-136175936.0', '-1.4686882710319685263628369699621524907308145838630402364188633151748632004996829983235804599e-8', 99, 2);
    t('9.219390', '650720', '0.0000141679831571182689', 22, 3);
    t('-999.439', '0.000000323', '-3094238390.0928792569659442724458204334365325077399380804953560371517027863777089783281733746130030959752322', 98, 6);
    t('732035039.9', '-0.000000000000000035', '-2.09152868542857142857142857142857142857142857142857142857142857142e+25', 40, 1);
    t('239310308', '3.1', '77196873.5483870967741935483870967741935483870967741935483870967742', 59, 0);
    t('-2746.62', '0.00000053794792', '-5105735886.1058520311780367140372993727719962185186997284049355558433', 58, 1);
    t('27804.01396', '-9810.75291', '-2.8340346775689002649644755959917453471', 37, 4);
    t('27.71', '0.0000000000011523', '24047557059793.456565130608348520350603141543', 32, 6);
    t('-283504594', '78447408821.3', '-0.0036139446574432038958112757577688127075463618032118161382991188901351', 70, 3);
    t('2774774', '-79.4027727', '-34945.5554969555867914924839897939735295918702849025321253044857462515285691', 70, 1);
    t('2.50', '29.54', '0.0846310088016249153689911983750846310088016249153689912', 56, 5);
    t('-26269.730773', '-1.551888', '16927.5944997319394183085377295268730733145690926149309744002144484653531698163785016', 79, 0);
    t('-7339052664.8', '-14235', '515563.94', 2, 6);
    t('0.00000000000000233553653', '-0.108', '0', 13, 4);
    t('-0.0000000000000000008666', '47471219.4', '-1.82552715298482515913632e-26', 49, 6);
    t('-1069.7', '-1004', '1.06543824701195219123505976095617529880478087649402390438247011952191235059760956175298804780876494', 99, 5);
    t('-370.147', '0.0000000000000000017022491', '-217445848554127595074.069946637069744962708454', 24, 5);
    t('5720.76', '-1091.4373472', '-5.24149188652576099056178', 23, 1);
    t('1.82075', '-1.83', '-0.99494535519125683061', 20, 0);
    t('-0.0000202', '-120999', '1.6694352845891288357755022768783213084405656245092934652352498780981661005462855e-10', 90, 3);
    t('-2.383099', '0.000007206', '-330710.38023868998057174576742', 23, 0);
    t('3.507', '-4', '-0.87675', 45, 6);
    t('-5.4058497', '0.0000252', '-214517.84523809523809523809523809523809523809523809523809523809523809523809523809523809523', 83, 2);
    t('53.7606', '1.5', '35.8404', 70, 4);
    t('-472.386625', '-2133245.7', '0.0002214403268221752421673696564816701611', 41, 1);
    t('-21.439', '-0.000118', '181686.4406779661016949152542372881355932203389830508474576271', 55, 4);
    t('0', '7.07557', '0', 79, 1);
    t('3.282', '-1.4', '-2.344285714285714285714285714285714285714285714285714285714285714285714285714285714285714285715', 93, 3);
    t('0.0000000000000000001520', '-393665.3', '-3.8611480361616835418310935711123129216621327813246430407e-25', 80, 0);
    t('-1.49', '-50637.5', '0.000029424833374475438', 21, 6);
    t('-27957', '-0.00000000000000088964279', '31424972263305815135.0835991151010171172184737202220230436532847076746', 49, 5);
    t('-47', '-0.0000000000027870669', '16863606682710.05622434108058188341298875889918537656918102683505731419651246979396152996', 74, 2);
    t('0.0000000000013548773', '-40894', '-3.31314447107155083875385142e-17', 44, 2);
    t('-18409.7', '0.000000000000000003349', '-5.49707375335921170498656315318005374738727978501045088086e+21', 37, 4);
    t('-0.000000576194', '6781238.273', '-8.496884739976751440717293314904877992922281732659595045025e-14', 71, 0);
    t('-1175147973.37', '-227632.0', '5162.49021829092570464609545230898994868911225135306108105', 53, 0);
    t('2.634685', '-21.564121', '-0.1221791048195286976918743870895549139239202', 43, 4);
    t('-10.499', '6', '-1.749833333333333333333333333333333333333333333333333333333333333333334', 69, 3);
    t('10164.877', '1', '10164.877', 42, 2);
    t('-12826.3', '0.00000000003228296', '-397308673058480.38718', 5, 3);
    t('-6', '-0.00000000018569207', '32311557515.6225034273138319800086239547009196461647500617554643017335096754535613717914825334221327', 88, 6);
    t('-0.0000000000000025251098436', '-1196.32', '0', 11, 1);
    t('-38919054533', '2048.5', '-18998806.21576763485477178423236514522821577', 35, 0);
    t('-53882', '-0.00047938018', '112399306.95507686613159517775641037140918091357051933185890163', 53, 1);
    t('6.743484', '-35154451448', '-1.9e-10', 11, 5);
    t('135.562', '9.5', '14.2696842105263157894736842105263157894736842105263157894736842105263157894736843', 79, 2);
    t('-0.000000000000027', '-3', '9e-15', 88, 6);
    t('440895409.37', '-4.244', '-103886759.983506126295947219604147031102733270499528746465598492', 54, 6);
    t('-56.521', '1468243.7', '-0.000038495653003653276360048403408781', 36, 3);
    t('-1', '-9.113', '0.1097333479644464', 16, 2);
    t('-8.3', '-2599.30', '0.003193167391', 12, 5);

    t('-624543459250761.7424759511364533556458', '4477531294244125365082.7698', '-1.39483884803577698495727079613753595389155245e-7', 51, 3);
    t('-356908235519.71444083032467453390227880319955148184157', '1.5306788853374988708482675402655598', '-233169895357.2616012348273715319952073899926462999398380558436985', 52, 3);
    t('44066683550405105669624884328870069022314879447', '-40770501792465902237453034227.3256094462036', '-1080847220736152781.3481128021472592814155077674569111667555300023690897393571703604', 64, 0);
    t('-2786342133225766496.3702338301569', '-165650538939124201836345652088473601.4574844690271527', '1.682060409262981146172971109824e-17', 47, 0);
    t('-27919.220476', '-4179806.6616764499018', '0.00667954829872491564251784270468808686308419116657243607', 56, 5);
    t('4717013884021421661239642619803336709657446', '-4396945714.850835', '-1.072793295602796604728660784784714449361778834434e+33', 15, 3);
    t('4857571399.040444595942662244', '235459.415989501', '20630.1853702764679928756592238265024244813146438562020490437565058468946493729797', 76, 0);
    t('1896453874608071174280167452575.78153057727', '84295814589973288303632462340.69692148823798850938', '22.4976042266474303187971208456534528011604059650531484706610682', 61, 6);
    t('1349.21861774471', '600801146756400414339331720940860929.19297368', '1e-32', 32, 2);
    t('-380710280449994245527205.803445644072373925', '-6282699867838372405.6862362783503435232742435', '60596.604717484545128564924856036354467001617319065528212815689140862146569868287761955', 81, 6);
    t('-16408382343680930801622921026173292010.95184', '10.28420', '-1.5954942867389715098522900202420501362237062678673e+36', 13, 0);
    t('-572210837.06281547085212132889004786845500563257764747902', '11174933632587.888635200676212120616579965146776824585413', '-0.000051204853279321267251539617856120070847316696999394', 54, 4);
    t('51359578790378880398.04793830026219449183', '-455536654230074.23174939755093407387209616', '-112745.21669', 5, 0);
    t('-56161288675323037889788006369690.5728858', '-1344804.735014362693770845939698743390913699834', '4.176166785635479476729192379832848688266908371343918271530172573425201796828236768822077194256e+25', 68, 5);
    t('-0.06647', '2488734728502626956945778696723078815802336866604', '-2.67083507289e-50', 61, 3);
    t('-15709.702083869748710483750', '0.17343238577', '-90581.1334724035302676200393250232343845822654394774978825455616633532285173730041343', 79, 6);
    t('-0.000008986079351526333799928', '57158779759798.7587388', '-1.5721258202657563972830928281622437814997897501794197664807e-19', 77, 5);
    t('-0.00000000001388422828798892162774186257473892', '-69686337968148273523849327314060722575577', '1.99238885164765353309613753258918e-52', 86, 6);
    t('99883611200513084646975210060.60952323092198205344133', '6184477507904180826.367614', '16150695199.85400049006270290779814055968601439594063052012683068413', 57, 6);
    t('-0.0000000000000000000150207809788679934221011249575790605', '-28817046896.758970', '5.212463661763124150056312253142344531e-31', 67, 0);
    t('-527083357783510.481321402212159156076', '4756796954943078601565972017123.3001236870', '-1.10806360409347708706496e-16', 40, 5);
    t('-11916867.623189151', '-7.4112922348688463778178290807622357293427', '1607933.845480057142567124343022113195564935260597336976958134855837379', 63, 2);
    t('960299171557437856346556589204892.36952339465963106510841074', '23606941669264716370', '40678677696217.99646471', 8, 5);
    t('1047.5896930595555356981255029478888260642', '-103799285857826471881446418054582493405323846656553543983', '-1.009245e-53', 59, 2);
    t('-399488979125776633057389835971328054031.4924', '19142186348378884.30958', '-2.0869558568455196441280685191066041366482575030706546217893406693976412457e+22', 51, 0);
    t('-71368779920225744729992101649423801013.9826397267764457', '-83273287.6391659199300973471958', '8.57042899872958433994977444944486516265889892525299612767160815191262755920396329859133752045133245e+29', 69, 4);
    t('211208409622743840484103493394505.246103663548399', '-767386956806589826985766327524128477304930268638194243742361', '-2.75230648305084820188844632852158236744385890645776827212232048e-28', 90, 5);
    t('-100744.08431499', '-0.06551885488328366094728119464062698894646878061872889', '1537634.99826816460387156938259580438652967442179025881429425178830102616497580229', 74, 0);
    t('-0.00000000000000000336004973090925295770216060', '0.00000000000000000001515260842039336040123784515497940557955604703549', '-221.747281899470240379958517263', 27, 0);
    t('-17532870057814109047.600859829217332735092564821487411138', '23019.6449040', '-761648154475550.4212707754733494707749247114459957879434541949961262530168523576109808', 70, 6);
    t('-0.000000000000000026988260097683516148610380', '-45420382420145149189834745476421586567446848185762.708375835', '5.942e-67', 70, 2);
    t('-0.0000000000000000023799691081599249086032764017749602896732817654250', '991105482710213.567', '-1e-19', 19, 3);
    t('601453', '2041.66764295913', '294.589083621990798160301139631085149923553179452222733024041143164011323620273068508', 81, 2);
    t('-402521315714183175054571726943679054.7675', '3', '-1.34173771904727725018190575647893018255833333333333333333333333333334e+35', 33, 0);
    t('2206957.4504253', '5483536757267773.0781508858951720347886184285', '4.02469710356229758887237979439122257676387502e-10', 54, 3);
    t('-0.0000000000000005289549144694566634009672940013915898308679385505', '-18.89', '2.9e-17', 18, 2);
    t('-2211019241730.118931085998956737464', '1883345', '-1173985.25', 2, 5);
    t('676660413361215098841.6447', '-0.00000000011016974787223439675745714624897538289345097697566', '-6.141980229871714946783543386659759345952836e+30', 12, 5);
    t('-0.00000000000000000001122585876532469760883703742146468722976677', '-0.0000000000054744422221837600557', '2.05059407145349178334038027799621311225211509668637086903391590926456766746e-9', 83, 3);
    t('-58.2', '-1364461667135886369603850.1784667971192', '4.265418472485667689287105862913268192243368105085866387266e-23', 81, 5);
    t('-47225932306386643219733.96765155309', '-0.08091271579981112281034023212381984889369879198108909359', '5.8366514879107400140856446166707928594799801466940076002029905146259292256804324968441972873664122924704057077e+23', 86, 1);
    t('0.0000010981334284061199519633859544035268395486390675316144836610', '-8233507251008518719.119447816686546693006964245267741540211', '-0.1', 1, 0);
    t('-12629847025632238433603053865614665972.1494239645227896998674', '-2591992428721377159251056998048.128872', '4872640.40036664294743635414136385753534', 32, 6);
    t('-4252.07', '3415694163747861025', '-1.2448626241567330165894468829708493576e-15', 53, 5);
    t('67828346273094326856933', '-0.00000000000000000001981766141', '-3.42262110901077943368359324492061750287013305067865724525969686551426453097323353653966782551867203386638141175104474650523358599e+42', 86, 0);
    t('-13.806931363138', '0.0000000000270109174387398904696405526860183322846580991144310044469', '-511161140470.3963666869121585635945898573137993', 34, 2);
    t('9.63', '1171334609000199324775253397721344579658013052', '0', 22, 6);
    t('0.0000000001168642599645515450579400931900955126185213013465768', '0.0000000000121793918568216690573762516759087773884128915423497231', '9.59525', 5, 4);
    t('53506114651950883942285065699033', '65910628177729867715794374064.1138413', '811.79797752298971851967012659297691173513982414824506104066132362', 62, 1);
    t('-0.00000000000000000406627260678849033336293998551088992', '-3303171.983301811542274853533900179067748154', '1.231020554589438136806289366857685e-24', 57, 2);
    t('0.000001084617', '78817036436563311090367542.130181882621560', '0.01', 2, 0);
    t('-5744.73419', '122155848887.064230599', '-4.7027909366101111765684860860155074448700724899701e-8', 57, 2);
    t('426.344', '-127873488954305077741949807322665432845121236', '0', 21, 2);
    t('40030987601502826523314779745936856', '570996.314388459918349916072985491785987', '7.01072609275529678246947361074571833074130496873796082431e+28', 28, 1);
    t('470581.007268845392131980979824886', '183334837116430.861534072111318027730101341054073', '2.5667844402643043142954711637004e-9', 40, 3);
    t('48323137770242813929658748393131737173669293941681.2', '-302.5177156686213980269795794973417845274346400597970242478', '-1.59736555141703139979090089819188708015873544578179904997943129115168986035033030299897874617620575984889131116122934e+47', 69, 3);
    t('8.7', '0.000000000000000000166761710281741', '52170249305440090476.62082302362', 11, 1);
    t('-3387155.337280447827589', '21.94263', '-154364.14583304', 9, 5);
    t('1621091487090991767', '-625690863595514294116971833.8982', '-2.5908824651449069100905040391792376372343161e-9', 52, 3);
    t('0', '0.015395', '0', 85, 5);
    t('0.00000000000000178239599595974964583290109935985132141544888408370628', '-29516.521811036968024710638888599116696', '-6.0386383171111545590219859100069758779882121614779757e-20', 72, 1);
    t('74.969990492713749079688', '0.00000000000000052282880601480435829451617959658965518187770782597', '143392999066296488.15598221416532487350857268505818468778132959087203234559315393563482665694193790662836704381101', 95, 2);
    t('9596615571258.492610962809423', '-167633520.5824796874157222071297', '-57247.5930704', 7, 4);
    t('-2232071124436735511943814137.0522431130665912245715784551', '3564396711.368', '-626212878414444584.725490318710279686312169391968867215929674014486509260688453315113231564206302732269601343632478', 96, 1);
    t('-1382227618.75131191316862730899075392511410652', '754635905531929458984619.180888454231', '-1.831648359982293967304909354245656965e-15', 51, 0);
    t('-71067330303000363858876867.973933654727826106685', '-11661754495838287260.07549715908674', '6094051.313493355982412064832079563681', 30, 4);
    t('-1252371590193744774917140670', '-213356828779653985738.357', '5869845.3541749151279418641211276959015930731289804820486', 49, 0);
    t('13352367841149988', '-0.000000000142031141374476971294', '-9.401014250772902375534890054877166473120970323e+25', 20, 6);
    t('-10321.73245286387727432273304720136578247', '0.0000000012116081638922756022964368396', '-8519035081197.7404251464625469036910252', 25, 6);
    t('-0.00000000000000039871298374', '-34669636664769580398726661099025.86943584', '1.150035079961372033160736089419637803806556114650312e-47', 98, 6);
    t('-303137413399920257.30569152070980396', '4040056.76913163224875', '-75032958872.27754452352532363389769842427145464424631624396469616635312022963616794108317', 77, 2);
    t('3158137570873460228072670005805543345755314.88870', '0.0000000000083', '3.8049850251487472627381566335006546334401384201204819277109e+53', 5, 0);
    t('-2432289038390.2', '-318696105128138999338893487.9', '1e-11', 11, 0);
    t('0.00000000001159', '-1319597700477306095503339987.9244', '-0.00001', 5, 0);
    t('23648504.6466', '-270134.1', '-87.55', 2, 0);
    t('-346539606072077.2439', '862203.062816695290396772865420408873422969589343', '-401923422.70274641808047258150883287943664547849847021654039885668554386812303515806801631981', 83, 1);
    t('0.000000000000000000012', '21194406', '5.661871344731246537e-28', 46, 4);
    t('0.000000000000000000111480007578139775', '40759282340479757739197.929065157327869698454301', '2.73508268980055839501863e-42', 65, 1);
    t('-18128041192.156711945350321873109876', '-33986859592609750.47129863121', '5.333838256741600071709984030510568296793370390855043571400753611875916969218330361484e-7', 91, 6);
    t('37278526076638974862118765.098259276278986122514405', '422484277198516023929200423121333952607119189697795', '8.82365e-26', 31, 0);
    t('8768.0457926837864490653237778856176282232936793297952', '2911070376371882980749989481391259968018315772791348.594263', '0', 21, 6);
    t('-15955789117760043118300438387.88821275514711148675', '990985099985142384569.56827257552943577101744765232273140', '-16100937.4590992989250162977644764748579171495897739589653639122908862455819077118275788475438161', 88, 3);
    t('-212339967169681140.0656347177691098032583634264120432109692', '11427913738903003526979637293.05945166976', '-1.85808164133083e-11', 25, 1);
    t('9531.020434', '-334535567052877548087656305116448', '0', 3, 4);
    t('3841583091234025971151324407364910092214432429401407480438', '-22416824307585236203987598514653148538792.945067', '-171370531281459881.5845028347181699363', 19, 5);
    t('3216714522.970', '244060566972964907041409673187177473756.579577073127866342', '0', 11, 4);
    t('-0.0000149274144207078807596236297196457', '365070321314504.979770', '-4.088914806045830298008984522180321e-20', 53, 5);
    t('27022766.473594173737137389937884830415185959525864', '-539299052785656617700079811116319917441', '0', 2, 6);
    t('-28599579971171430131634037723710371659862', '-0.00000000000000003644973478672098783210762417899790764846187', '7.8463067395460310450266452407524485868916851065079313125316782921027252528619835701517998070723638e+56', 41, 0);
    t('0.000000000000000107501465095829712656', '-36.9', '0', 5, 2);
    t('3504221306553522426085327256227', '-25730.57184190476446062096107175383931', '-1.361890177989186277274384722436967581e+26', 10, 1);
    t('-5613976985159967030036081584308829303811752101719', '5826360651980204533629650242959093732650762454761251564090', '-9.635477994744361231994675869384292734433202261344614e-10', 61, 5);
    t('31450598647096365977207660693799877880.7722033791', '107521368334565489758', '292505565491262148.019571293699173528327044279742920906207753129416525762209451256122138367129671204843851546', 90, 4);
    t('1500908.503777', '-1015794940302252137891895242750618498147131.9366486805297', '-1.47757036802172020799761083929871197843150569793966301441245e-36', 95, 5);
    t('-73296034', '-5', '14659206.8', 90, 1);
    t('162689268248656604911961.73925878415346621140', '16.8530012184832', '9.6534300413050659945667091905274e+21', 10, 2);
    t('-0.0000000000000000006349044078849485', '309418015201986203793355024.150967286295740', '-2.051930969405536238876578741356000088614244e-45', 87, 1);
    t('0.00087604094095', '1392643254462374770962.4', '6.290490677658813987746781212472635606387062383544e-25', 73, 2);
    t('0.01471018444847', '-0.0000000000031444004384214340642523517788169191904279950', '-4678216002.2', 1, 6);
    t('187743709993796.4707441185609022061433785613916665', '-148037593060997360064291511624701384112069161633.117310780564', '-1.268216444970424611070255845307078487869328514291e-33', 81, 5);
    t('0.000011258', '0.00000002533815962089606530705098', '444.3100907263867470311330952968235026076982471394', 46, 5);
    t('757411567322940237009357511826689969429965.236585820277', '732371310539520997815.583055808555097036195690159014046186', '1.0341906576938037911928068192477326e+21', 13, 2);
    t('-568.38271', '-0.00000000000000000009831306318615957356693126102654593877784118926', '5.781354904218022750361120979397811789718111958564428281983974648837588268358968369893867421753377610560567601e+21', 87, 2);
    t('4961441143214745081236647304879610502095528582', '152849955322703', '3.2459552459403407242938276150370472621615e+31', 9, 4);
    t('3.07144121980414068036287438221', '-9172805577814.461', '-3.34842071354133190529054610280498225047720875195151670690172482e-13', 75, 3);
    t('44314348083704254263362409818654768380209.012579280', '-9.417687525064823672162', '-4.705438353710852226448547042633572616984454390342684398583290673e+39', 24, 6);
    t('2085098969276295556177971788779802383262842.2573', '0.00000000000095273487', '2.18854062649800521752496766364791747704462864605763825984453e+54', 5, 0);
    t('109753.2295760718524527484177', '-2410159320462121517944570628199834932322126563296852', '0', 13, 4);
    t('0.000000000069254571', '0.000000199024731561379031663465058346103053493401562136877453001348', '0.00034796967420424309603498770442174869249118067854495112595546767', 65, 4);
    t('0.05513850425913127663195321149816649956181', '1583707666489.2', '3.4816087227e-14', 24, 1);
    t('-0.00000000000000000001911867896259825309', '0.0000000000000026470470353798680890064052204548929047195017581076193006', '-0.00000722264421714539010209156219178435935', 41, 6);
    t('-6073252477791750891.3306202701', '0.00000000000000000318941067336920340144282050435242157283523553432927425299128', '-1.904192686285876887623788577946073103761642119860783779636402053198955991467191518914690989817783177670381359194515048092874262743002e+36', 96, 1);
    t('378672312.587170', '-0.0000000000000000001053', '-3.59612832466448243114909781577e+27', 2, 3);
    t('609789798178485116999338276095741737992.379075331', '17.0', '3.5869988128146183352902251535043631646610533843e+37', 27, 0);
    t('-124.716', '5216585338728473.111922771500014302179232803666', '-2.39075931671423873e-14', 31, 1);
    t('0.00008981163034929156059932182280362293647', '17.15462944126793230', '0.0000052354165187174924421618028002824702737088914242483722088492099572847282013733240288959490404', 97, 4);
    t('51.131', '0.00000000000000000163392086120629508806283832967421051655309', '31293437285726849899.9548981381946366968329515395443936573946414878412107077307898590483457854490120470465228429287396', 98, 0);
    t('0.000000000000000224443342970341249514955', '-195.075348122424284622226008810924357674021585884736420502', '0', 7, 6);
    t('-0.0000000000000523354375249977172294108', '-59305406992817199156555859872622215551484.43155864914470', '0', 35, 4);
    t('6', '0.0030', '2000', 56, 2);
    t('0.000000000000000000034611171122223173101604291856002430473572402', '-0.00000000000000001306934614', '-0.0026482710574396932379054957', 29, 5);
    t('1588463948.87932840027706', '0.0000000000022448099935370064122298031327392982562438924009101', '707616214046020578248.81130758203250848509051455636434814147439890491', 47, 2);
    t('331.68', '-33750.2034498218032862327555741660509773034307606364769', '-0.009827496314003737584808993904721204561638977989420994442365465662925539835282246204506787', 90, 1);
    t('0.327498818868821216689791032955550931752264897623', '21042718581930356317251390092870285676850.926244716344', '1.5563522250877247306423254201e-41', 69, 6);
    t('3958539212848304459958011955905583053', '-21696668207847236', '-182449174911407951863.4531483205530341836363930866093940294762697819985445794', 55, 3);
    t('1247355676807195054228866279313', '16.258834134091449785731551775353859635', '7.6718642094499587743177888766100455319156336611325707079731669e+28', 33, 5);
    t('0.0000000000012350636190251876598396', '-951304829839431745267098098582', '-1.2982837680259132276449985e-42', 67, 0);
    t('-104.734641992', '1733564860345817076999292.62701', '-6.0416e-23', 27, 5);
    t('0.0000028957367658033897750603780262704357073704233855043345', '6356266743779871175690.8320757525027414064', '4.5557193908470029595714225575995705e-28', 63, 4);
    t('-18558028455212231571697031', '-8', '2.319753556901528946462128875e+24', 29, 4);
    t('-13821411732239834470835288846455021839518308', '43191343517856916199296009474.4583', '-320004209327860.943280120415530700855745713808556291320032098976026114433405693', 63, 5);
    t('1105537642062114566378066835007', '-67031135832125199.608799899', '-16492897342972.91956535243888467391305299684032312977820150518076720770163876179182196342933551', 80, 5);
    t('0.0000000000000000001255914148577465716438366888116166812811129178359847494921', '14253616998215507072480525.5466822973429', '8.811196124707861086162541630740460525710456e-45', 87, 4);
    t('10307.48645', '-233.40', '-44.16232412167952013710368466152527849185946872322193658954584404455869751', 71, 6);
    t('51547410618891864439338459879661143474.873695893', '0.000000000000000676829184531107024516', '7.6160147636959276036734477149740626732082461515375015431101882226904527697230136479333303806794331563205180614e+52', 57, 2);
    t('204708594426498174030950107.254', '4440698384508500810481273876415279950855610099962910', '0', 18, 3);
    t('-6.13262', '23040527189197.48966', '-3e-13', 13, 3);
    t('84389016596253.6582867036429852020414930676618', '-0.000000000000068476172931286069798457953929796189460178155', '-1.23238512001737718906979098515503064223947711793583508345578763371912048018025047351275887045048034847634525910066e+27', 86, 3);
    t('-38248107466844304398754595001002', '0.0000035010431864427607738252', '-1.092477454004397498727080290040187638747725994106560343172688418173937260394324598159119517021792374783673726682471104291825439097915e+37', 95, 6);
    t('-6.04', '-52596312949208048443865032.445961', '1.148369469516388467461983778327576939930189067065907333733000607931365766262e-25', 100, 1);
    t('-813956145912449846600403054832', '10796.36780196', '-7.539166512692186931160646370173229289e+25', 11, 0);
    t('-2421788107883639375.690813214146289140632086497030390', '1731175528149788838817994796202724767.68013543816827528061235', '-1.3989269536821316086138504672469213952044063942010898714620955200178235e-18', 88, 6);
    t('6809195547555535.498930321150996302023166384162374', '11654400.3394158857916', '584259622.9105349102', 10, 0);
    t('7650.2', '167313423904874555768.53143200344236', '4.572376693665353260468390163017986446812909378918e-17', 65, 2);
    t('0.0000000000215178880', '-415105913902008739133981.125527139819700224156205940189343', '-5.1837102964231878130039665575920669505879406859e-35', 81, 0);
    t('22142223705380302372371177782.1735702866136041227753', '586007244566197651865789605.262', '37.784897560048902907217450655951502520247844259884569454602755728879103478107373423844615729', 91, 1);
    t('-692051984878.44837389610506', '-0.000000000003543', '1.953293776117551154095695907423087778718600056449336720293536550945526390064916737228337567033587355348574654e+23', 85, 6);
    t('-2098291.044481392971917438527834118527', '-5693120152498224716798827599', '0', 11, 4);
    t('0.0000000146185660337188726116266948236882286', '20.7', '0', 7, 1);
    t('10704495556869164920.51', '90619.2588', '118126055086086.898346050034123651', 18, 3);
    t('0.000000000000002487958710561768110187226959259', '4063693787689666341932152579391331936357.573517570229', '0', 27, 3);
    t('51618848316969818775925143304056624489535103456.6', '5', '1.032376966339396375518502866081132489790702069132e+46', 10, 6);
    t('2654107.13441542394', '-6123874494540609.39129700002676534532585907120017117261', '-4.3e-10', 11, 2);
    t('-1714194716329674533705519065.5334413206217103223746696', '5.98522507452367335745', '-2.86404386633045136335500224142654677487187643840811577337806125077173786775401349379930631210035469203499993508952054e+26', 90, 2);
    t('5702848846892587648420853565547712298213651451', '20315551290068.9958657451780294280', '2.80713467504096443336245665418400813749841454239681391965351719619477522552050607483391155099224061119513736999774116474859166959586e+32', 99, 5);
    t('5822711428013.7278457962610451325840881631471620796996', '7317134960.07267345871391728', '795.763841966350301550416023965287902186366947585252329405753890743811409560180259233344579873', 90, 4);
    t('6998999857049233887139.178', '536565672053559187736681540252526377121.4733799', '1.3044069387186968841309942400771742644732909128490501807562862836e-17', 81, 0);
    t('-736427.362', '26561785052330377.2389583235', '-2.7725070455512e-11', 24, 3);
    t('1706905651154879542863', '88.56507646747069', '19272897616498006457.7522807926014250674708948336033069877118029704230360991538', 58, 2);
    t('257245103.59464744281', '0.0000000029115137887165463109918224', '88354417070456755.53515', 5, 6);
    t('-0.00731213642756679', '22000291.2308', '-3.3236543784156522957658811e-10', 35, 3);
    t('-1.00153755', '-0.000000000004817370897527122943915648885377070823386522456337944', '207901274638.021808115928034265486', 21, 3);
    t('-18876185760828306319586606769243165085658142.582', '110420998917509223452862481780135937729683.9442', '-170.947427988130159944154589178595087116373885300937', 48, 5);
    t('10139455414077721510362752985718.349777032029', '-1592.15854283316275020881903273194474638353703333947', '-6.3683704488593777697061166680042965589526026607894963695742224646320751612955e+27', 50, 6);
    t('64058.2040554083', '0.0005021239538086', '127574483.49063637011849827272068476023898087743836443210535013094588197053638633850291146474453448271', 92, 1);
    t('-1428475428.20735903897201934602', '-0.0000000000242430554', '58923077336504335133.104523863770075780135', 21, 6);
    t('0', '0.000000000104418206', '0', 76, 1);
    t('-272327.1', '694.45577474495', '-392.14462592', 8, 0);
    t('6237855.72', '0.000000000000000056118290958004531753653601257', '1.111554827047036507995706512423927767064027042762859524443941584662214168498358135819148727524390167927840316489194652889418e+23', 100, 0);
    t('0.000000000000006937403050062051741264875394222559344579302', '1509646995595711435.959', '1e-27', 27, 0);
    t('-164471871725054325379243876510073498031765815264104734195', '-0.00402430947386126023272568404053794601387820869747399428664192', '4.0869588383630498731416861920107609850137223086980649346785688450001052069390464103e+58', 25, 5);
    t('-133380508526066123553.924166134978708537056649683776', '332452693837394951885538.01', '-0.00040120146715160475560382614621874425251758726814333122', 56, 6);
    t('-1002134.167299', '-251.640', '3982.4120461731044349', 17, 1);
    t('3091342449638972957936252157062677150123597', '-16288785543666.3129808', '-1.89783482712804340336650119939870960656049694756418219750511012425980687183218750107631468549277698312382362559693096e+29', 87, 4);
    t('-2121799566979', '-20804629779048036144946756642230281', '1.0198689375937973728019325041709023668770063207827995907217465870058272029e-22', 95, 5);
    t('-2.95', '-1', '2.95', 31, 4);
    t('-0.0000000000000000000128531295816420791177802740270342784459', '2133.1090', '0', 11, 2);
    t('-22.4694657270600021059023860420', '-11079.1', '0.0020280948567176036055187141', 28, 3);
    t('-0.0000000000000000014765999000906441441566319', '13980667685799243617101573702.2033564634481522785621111348', '-1e-25', 25, 3);
    t('-36625617695236881.773942648961', '1311498943574337365145309982488.6557', '-2.792653236564417936966141384470842862580855171690821248973320554198267761643707277475e-14', 98, 6);
    t('-2104684780739', '-45.6', '46155367998.6622807017543859649122807017543859649122807017544', 49, 2);
    t('14570972898277952428626.0983801671394340', '114423093266432345.2524483', '127342.938233191046005191826845887793763656551737627592531031804176335098511683913206903', 81, 4);
    t('81260582666910888471517.696291', '157183273101224011686.118', '516.9798354725703896250771557514765169801823622101619483914412', 58, 1);
    t('-2.525060632104990744774590726583480995133091410643517095', '8737246559917825.103222789941919016', '0', 13, 5);
    t('-6908481234802683425254138906190088906940533878.111', '15381.89870114390985717228404934058434081488126127180', '-4.4913058972940177512058867064538945149459323054127e+41', 8, 3);
    t('417982.58607482343146733674248486', '116386843556506317108.22539086', '0', 1, 3);
    t('-5780608294791.624458881861849817493', '682392959.70758196837', '-8471.084310818098502691272384981', 27, 1);
    t('40159.97604002006812174866', '-313664.679534078486903276', '-0.12803475', 8, 0);
    t('-4.047', '-1.81', '2.23591160220994475138121546961325966850828729281767955801104973', 62, 0);
    t('5061613769913356854864601678.89379478', '921818732154416225536544128239745673153253611567047', '5.490899233609274193409593992073909981216429810581822729779521522e-24', 87, 4);
    t('-25506.3998849214929', '0.000000000013985173677629659', '-1823817170445362.78619963707679912302299395613', 29, 0);
    t('11.4581525319001337207', '0.00000000000000000009416824099681963524706645466971745', '121677461643221226049.4121814719193701493831141147430299424294358706877279967065063044082706631899843825377434102964830059', 100, 5);
    t('-13.1', '71689907220027014271360598291.258402249236137629239531728', '-1.827314402820211048849800495e-28', 56, 6);
    t('-1125106278543860.42641857171081224001205', '0.000000000305408269978069643760450306647132844200436249835', '-3.683941756471265763378768331539492008773195171551609918202663377907462939251038817895e+24', 60, 3);
    t('-0.00000000000000000049608590807042330411', '27990', '-1.772368374672e-23', 35, 0);
    t('-25928884865429476681995775592751670033286619073442', '-219192400010954.9422554036825930132777', '1.182928097148148648508822522228604781132162339640607517123442344178576719677e+35', 40, 6);
    t('-4.46763325', '0.0000000000000179609090310047', '-248742045421410.882061859008635736643114865517174911865521227799944534457085', 60, 6);
    t('-1287033681371878104057667.7055777252542186915675', '195707186672724900856206502221720418737', '-6.57632e-15', 20, 2);
    t('0.00000000000000193175636808677074413', '1096214462030958100.02309399230397185919335500330064378', '1.7622066e-33', 40, 3);
    t('4.1855102693159094752', '-1769.223', '-0.002365733584356471442661552557252534021997227031301311366628175193291', 70, 2);
    t('-0.0000008679493116849', '0.00000000000001377', '-63031903.53557734205', 11, 3);
    t('619020164695232324.022470822521', '-0.0000000000004062829882447739486123366057322303105417101432919615', '-1.5236182232722239291358561175494240320173964254115460755085158141082760696213303513827725096088371826207242532e+30', 79, 3);
    t('42561960553952288419610167869608672152477976.7637409739', '264520977464840304990428792028340802894082649682880151.87', '1.609020235818898502867215862305232329970845e-10', 52, 3);
    t('-8432160850933490778.69395', '-903254.8849', '9335306115578.905936669072754216997426392772559', 33, 4);
    t('-68334918980853445275646478865113316249836762.819', '70067642250.1174035246005', '-9.75270706796744613698328349792670077865167e+32', 9, 6);
    t('-125210874454495603116740976.379', '-77140850018624120914', '1623146.159580377099547403143409912506569866772423197071869436970879279367977438726091333988946827384', 93, 2);
    t('-71924.8159', '11792', '-6.09945860753052917232', 20, 2);
    t('26738605472616.34809488607216342324130569467943599370', '-17848616068000574690442.240120938', '-1.498077238635546584508183889182860823798452319e-9', 54, 4);
    t('307728725034195445693818971152253110685320114730380.6360569', '-0.04791701101144421929437607982012423', '-6.42211854492967670147798513527529587291182927874576501544632945181254387470070916840287404357386e+51', 44, 3);
    t('1063469210609337404733995767077620', '157322.98262357845381312530739737044008643142255', '6.759782918391938594011489608657438980256117690815000289918435942612008089111174784431469936177200692245e+27', 75, 4);
    t('4721242310773063039516988216828059', '171400453736307845213676552.5264455791334235426375810', '27545098.0896263513314335', 16, 5);
    t('-3554846810422675439500939761.48523775084025501057', '3315590942268820.06130581', '-1072160852264.283056864970073195051461622948996967853643073530490983', 54, 2);
    t('-3', '33.42273262067', '-0.08975926756343902112491292', 26, 3);
    t('-1085841368229.94743889887943410676813741370545796101970', '149610498943278043790373953905696078398598966574.065396393', '-1e-33', 33, 3);
    t('-6855.326', '-6.61', '1037.11437216338880484114977307', 26, 4);
    t('482589.39032468525307515', '345620881.1', '0.00139629697369197885849365714148108512532809465139691758051015511979146', 71, 4);
    t('0.00000000000000018873012642883182832958209507253635128', '-316826894495349657610523346282389288091344754546005352412', '0', 37, 2);
    t('-0.003915504234894627513', '-2561178368548558.3', '1.5287901393269916111965312123266261603335417944432306248e-18', 74, 2);
    t('-0.0000012845584111321936644262379417469638861846223574683905234', '951434782049434793413124934712308714591814021.8202740667', '-1.350127654956228395192441e-51', 75, 1);
    t('8415663741.6', '-1168289085861655174422234758990445457837305401386032655', '-7.21e-45', 47, 3);
    t('15858062669861942257032429298168.061284122274275', '-0.0000632521476327715811032330323136282408108535316', '-2.507118455792277110934258995900949920340359411372602248666188373364931628696825287100597787416097233309978475814394363763e+35', 85, 3);
    t('0', '-0.00000000000000000159599025962211', '0', 81, 0);
    t('8012431158360693111.3422024194980884319325209488819277405', '2948627644398253137185410152161559.235676341420', '1', 0, 0);
    t('-16692108859470873479799641256137360063087170548211631950768', '37848415114043098758799686016767986.0657242693524879935887', '-4.410253060577300514678904143e+23', 4, 1);
    t('-4243226161', '-241235.3', '17589.5740009857595', 13, 5);
    t('5671433914958075722313198736271285623794662361', '-1529262.981377059120344780400627536817216209608491794503', '-3.708606030501768874471207730787071653798986595411035303838097501627810686978706206155e+39', 45, 2);
    t('15076573039121823.4228488681', '-161804219260400857597665.80520571234560198305156', '-9.317787328436859431009430461085894566148816536724215e-8', 59, 4);
    t('294.8050', '-1.964', '-150.1043788187372708757637474541751527494908350305498981', 52, 1);
    t('-84259403135132485171174.02638116507', '-114.25883199713512140486366465931939269178', '737443238849537430255.562897456860924998387708483089712271920400180306835801578116806671059372285530053918368188248465511', 99, 4);
    t('0.00000000000000000046329876', '17951420713085087388514.79177201848797', '1e-23', 23, 2);
    t('-0.0002610697214141198547803066285872786447209856526772883974', '-178463559138028170694183028.197759979905991059847', '0', 12, 1);
    t('10467906625915426931.86040412', '-47739824225253084453503246028.8', '-1e-8', 8, 0);
    t('0.00000016666446981689100983647498315835174605580766', '580387622169032702425477961127755252936733664151030131299360', '0', 0, 4);
    t('-224.769', '-24801326309696', '9.062781449398827959722015515861155e-12', 45, 1);
    t('-7', '0.000000012707354813051516957', '-550862087.58493263467522230046127695732435950160199797173188670287711444397512', 68, 3);
    t('-4.3656189571419062523183949678080584000285054747999', '-3293692576993760246104014415046803314.10507195460869', '1.32544821809888565170762281523897677163949595277716403402859734e-36', 98, 1);
    t('14.1957398777937590270133873552634805598', '-0.000000000000012563918029887170815634048090532307766027871798898663876504', '-1129881605724010.2', 1, 3);
    t('0.0000000000000000000443996740', '7513.561355', '5.909271502847799663705547793453800844087204502504525032922952686795488e-24', 93, 5);
    t('-0.0000000000989', '146556533.88', '0', 4, 6);
    t('0.00001391471605', '744.27894259', '1.869556594141772197897753236770100087428835180475907168e-8', 63, 5);
    t('-40310.2', '87709217', '-0.0004595890988286898057704', 25, 3);
    t('1044345208', '-78177.473', '-13358.6462689', 7, 3);
    t('-4682.4005', '-9097023696.17', '5.1471785238631063197511178523858062911980363528445549978499721443800782131606e-7', 83, 5);
    t('394883813', '-1.18', '-334647299.15254237288135593220338983050847457627118644067796610169491525423728813559322033898305', 86, 6);
    t('25.579', '2', '12.7895', 92, 4);
    t('0.0000000000030', '-30142812', '-9.952621541e-20', 29, 3);
    t('-1.89', '1.5', '-1.26', 82, 1);
    t('1843613.37', '-36', '-51211.4825', 7, 0);
    t('-2', '-6556.35592955', '0.00030504750222388725256420745657319634802955829712150804993051660367510469671127160930692062', 92, 5);
    t('10', '-0.123889533771', '-80.717068630544761887592', 21, 4);
    t('0', '3.8', '0', 13, 5);
    t('0', '-141.14989', '0', 86, 4);
    t('342.75', '7034856', '0.00004872167959088288374', 23, 6);
    t('-88980', '79214827', '-0.001123274560708186612589585028065516068096696089483348868514223984860813998874226', 81, 3);
    t('-10.16', '-417.5', '0.02433532934131736526946', 23, 5);
    t('-559.8', '-3.38112', '165.56643952299829642248722316865417376490630323679727', 50, 6);
    t('-1.9', '65.8', '-0.028875379939209726443768996960486322188449848024316109422492', 60, 5);
    t('0.0000000001462574', '-0.00015154345556', '-9.65118549392539666857785356415690803e-7', 42, 0);
    t('-115.231696', '-2', '57.615848', 15, 6);
    t('0.000233315045345', '-0.000000000000133029473', '-1753859803.270814', 6, 4);
    t('0', '-3532615.6', '0', 81, 3);
    t('-4.2', '1.17', '-3.5897435897435897435897435897435897435897435897435897435897435897435897435897435897435897436', 91, 4);
    t('0', '11.3930229', '0', 84, 6);
    t('-0.0000000000000020730', '0.000000000000000852834', '-2.43071922554682388366317477961713533935091706006092627639141966666432154440371749', 80, 0);
    t('-136440751.770', '-303', '450299.51079207920792079207920792079207920792079207920792079207920792079207920792079207920792', 86, 6);
    t('-85.113', '1', '-85.113', 46, 5);
    t('-10.47', '-0.00000690102', '1517167.03', 2, 6);
    t('-1.4292444', '-1144.70690499', '0.00124857', 8, 0);
    t('-0.0000000000000000000465276721', '714.1', '-6.51556814171684639e-23', 40, 0);
    t('3.20', '8.38866', '0.3814673618909337128933584148123776622249560716491072471646246241950442621', 73, 3);
    t('-303854.8', '-0.685651', '443162.48353754315', 11, 1);
    t('0', '3.73', '0', 76, 2);
    t('21.0', '-0.000000000000000002895581456', '-7252429371822859194.32963795027149807800122891794068735049946', 41, 3);
    t('27606161012', '1508', '18306472.81962864721485411140583554376657824933687002652519893899204244031830239', 71, 4);
    t('4.28', '10.7', '0.4', 75, 0);
    t('0.0000000000000347360853426', '-4.659453482', '-7.45496987506999646015566767278652273494250114e-15', 59, 0);
    t('-1169747921', '4.12', '-283919398.30097087378640776699029126213592233009708737864077669902912621359223300970873786', 80, 6);
    t('-0.004024373', '-7', '0.00057491042857143', 17, 4);
    t('1.8735138997', '118.931177', '0.01575292490126453553890246961904698883119604542381683484053975182639', 68, 0);
    t('-2.2', '764.12', '-0.00287912893262838297649583835', 29, 6);
    t('-0.00000000000000000009903285', '-2.0', '4.9516425e-20', 28, 0);
    t('13.43', '1.49', '9.013422818791946308724832214765100671140939597315', 48, 6);
    t('0.00000000002818631', '1.2282333', '2.2948661300747993072e-11', 30, 3);
    t('3080315675', '145441.14', '21179.12218647351086494509050190338167041319945649490921207026', 56, 4);
    t('-275.0', '-16890338.700', '0.00001628149706672252818707537226592146432208609292127457', 56, 4);
    t('-2.95', '-6976.96721', '0.0004228198171508964279624298248636888749259293136336812452928240148630424765891941177692', 88, 0);
    t('-2267', '-3.5', '647.7142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857143', 100, 4);
    t('3', '2', '1.5', 28, 0);
    t('1', '1.5', '0.66666666666666666666666666666666666666666666666666666666666666666666666667', 74, 2);
    t('-0.0000000000000121', '-0.000001452', '8.333333333333333333333333333333333333333e-9', 48, 3);
    t('2951740.2', '-6528832211.10', '-0.0004521084482737351136335745064281668900369882', 46, 4);
    t('1.2913929', '-582958', '-0.0000022152417498344649185704630522267470383801234394244525334586711221048514644279690818206458', 94, 3);
    t('0.0000000000126439856', '1.3', '9.72614276923076923076923076923076923076923076923076923076923076923076923076923077e-12', 93, 2);
    t('2.1612', '-63497969.006', '-3.40357342735763028004650382313363403892805131714420176332151331360017074e-8', 79, 5);
    t('-0.00000000002762629214', '69.16', '-3.99454773568536726431e-13', 33, 5);
    t('-211.50', '-3.98', '53.14070351758793969849246231155778894472361809045226130653266331658291457286432160805', 83, 0);
    t('-17667309622.8', '-0.000000050947899018', '346772093910253341.548302901600133653621272866125786431541286', 42, 4);
    t('-0.000000000000000181', '7', '0', 2, 6);
    t('0.05964073855', '112.04372', '0.00053229880755476522914448038676330989367364810807781105447052275665249243777339774152446919', 92, 1);
    t('-7.77', '30279', '-0.0002566134945011394', 19, 5);
    t('2819.841', '3566.03200', '0.790750335386782844349125302296782530274546050063487932805987158836488287', 72, 4);
    t('651.8', '-48389.208224', '-0.013469945550312', 15, 2);
    t('-164.881', '-496055826492', '0.1', 1, 0);
    t('0.0000000000000000015713402282', '-119.9', '-1e-9', 9, 0);
    t('-322.159598', '4.16', '-77.44221105769230769230769230769230769230769230769230769230769230769230769230769230769230769230769', 95, 4);
    t('-2.47', '0.0000000000093', '-265591397849.46236559139784946236559139784946236559139784946237', 50, 5);
    t('-1', '-51334.1413', '0.00001948021286955860699280850734713663165921117687031418211333', 62, 1);
    t('8.36631', '-0.0000000000146683885', '-570363267921.353460197757920033274275493862192155600460132345144', 51, 1);
    t('-2.7140570863', '0.000000000000000481895', '-5632050729515765.8826092821050228785', 19, 0);
    t('1.9', '-1620.0524', '-0.0011728015711096752179127045520256011472221515797884068441243011645796148322116000692323285345586', 97, 3);
    t('-4.72', '-1', '4.72', 34, 6);
    t('-730000.67163', '57682668.476', '-0.0126554594459119211293404', 25, 6);
    t('-9854.20', '100.05', '-98.49275362318840579710144927536231884057971014492753623188405797101449275362318840579710144927536231', 98, 2);
    t('109901.8', '-0.00000001677866616', '-6550091583680.45150974027127314868752356176565110226854886062051549871232434128124997511721158173397974086', 92, 0);
    t('23253.75', '-0.000000000000000339', '-68595132743362831858.4070796460176991150442477876106194690265486725663716814159292035398230088495575221238938054', 91, 0);
    t('-1', '2051.814989', '-0.00048737337691804921306187026787530695829223226324720059836', 59, 6);
    t('-2485.45799', '-22032614981', '1.12808125233584591726316065650854664658109744508497295743671308155194236133508913333e-7', 90, 6);
    t('5', '879097.79', '0.00000568764937971235259276445229147942687923262780584', 53, 2);
    t('-1624053653', '-45901.775', '35381.064305247455027610588043708549397054907', 39, 0);
    t('736', '-31820', '-0.023130106851037083595223130106851037083595223130106851037083595223130106851037', 79, 2);
    t('-33307.60', '-26398.486', '1.2617238731039348241410511193710124133634027345356093527484', 58, 1);
    t('-5', '85111326221', '-5.8746587816256136023628558422155102937812556824e-11', 58, 6);
    t('-1.649825', '-3', '0.5499416', 7, 1);
    t('0.000000000116045', '-786270', '-1.47589250511910666819285995904714665445712032762282676435e-16', 72, 0);
    t('-32.1', '3.29', '-9.756838905775075987841945288753799392097264437689969604863221884498480243161094225', 81, 3);
    t('5.004', '0.00000000000000028911148288', '17308202186064620.13937977834220293976031506424543437352660297', 44, 5);
    t('0.0000000000000000000942', '-2143.2', '-4.3952967525195968645016797e-23', 48, 5);
    t('-2.7', '79.3695', '-0.034018105191540831175703513314308393022509', 42, 5);
    t('-0.000000000000002036873550', '-215.2', '9.4650257899628252788104089219330855018587360594795539033457249070631971e-18', 88, 2);
    t('4330632.78', '-0.000000001568875959', '-2760341093352173.67557354481712725384429196929264692748089971847162456264013667635020468817063440003927040863018285', 98, 4);
    t('427991.031', '1293.75', '330.81432347826', 11, 1);
    t('-8.92547', '-7', '1.275067142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857', 96, 5);
    t('-5.4', '-1.0', '5.4', 42, 2);
    t('1.383447013', '222.81', '0.00621', 5, 6);
    t('-285', '5', '-57', 44, 4);
    t('512168', '-7', '-73166.8571', 4, 6);
    t('-0.000000000000000000285654941', '-63506.19980', '0', 7, 5);
    t('-70.1', '4272.202', '-0.0164084001646', 13, 6);
    t('-11.1381428', '-34', '0.32759243529411764705882352', 26, 1);
    t('-2.0946', '-7.7', '0.272025974025974', 15, 4);
    t('233298875909', '-118661.20', '-1966092.336071099904602346849686333864818491638378846665970005359797473816209510776', 75, 3);
    t('-0.0000000000000002412', '310.1', '-7.778136085133827797484682360528862e-19', 52, 6);
    t('-0.00000001472', '-796413753.5', '1.84828550929840264e-17', 34, 3);
    t('-1041.2', '-0.000000645681', '1612561001.485253553999575642', 18, 6);
    t('8.37456', '-2808724.72451', '-0.0000029816236268796314943861290758029707760497802718151357226', 61, 4);
    t('0', '-105271966383', '0', 82, 6);
    t('-29', '30.9036', '-0.93840199847266986', 17, 0);
    t('0.00000000000000002126401186', '-67.1', '-3.16900325782414307004470938897168405365126677e-19', 63, 0);
    t('-7', '-10.381', '0.6743088334457181389076196898179366149696561024949426837491', 58, 3);
    t('2.5', '2.3', '1.08695', 5, 1);
    t('-0.219855997', '101.7824524', '0', 2, 1);
    t('-5.21850', '-798', '0.00653947368421052631578948', 26, 2);
    t('-494.272', '1866', '-0.2648831725616291532690246516613076098606645230439442658092175777063236870311', 76, 0);
    t('-6.5449', '-26.022998995', '0.251504448094453765320141189', 27, 2);
    t('0.00000000000000232033499669', '0.000000000000354', '0.006554618634718', 15, 6);
    t('0.0000000005015', '639650467', '7.8402193990737757094453899617023182756466274e-19', 62, 3);
    t('0.0000000000103187470', '-0.000000000000000012571', '-820837.403547848222098481', 18, 3);
    t('6', '0.00000000000000012', '50000000000000000', 76, 5);
    t('1.090', '15002564.0', '7.265424763393777223679898982600574141860018060912787974108958975279158949097e-8', 84, 4);
    t('-264.50930', '589878.7702', '-0.00044841298477366358352796335303677284299051045929640408679349348789294671924099023965856909', 92, 5);
    t('-21198985599', '-30720.1', '690068.8994827490795928398670577244214699821940683786836631391173856855934713754186', 76, 3);
    t('-813123', '-0.0000000001663', '4889494888755261.57546603', 8, 5);
    t('-44239.76530', '-0.00000005206822', '849650041810.5324130534902095750536507681653031350025024862', 46, 6);
    t('-316.68', '-8624321.244', '0.000036719411422703725065462090757', 33, 3);
    t('-0.000000000000000007135328753', '41264989.38', '0', 7, 6);
    t('176180337.2', '5.6', '31460774.5', 75, 6);
    t('1.6', '-0.00523482', '-305.64565734829468826053235832368639227327778223511028077374198157720800334', 71, 3);
    t('-0.00000000000021866724', '-28126.0189548', '7.77455353178172209997205217413586893583984552e-18', 62, 2);
    t('2.135', '0.048050825667', '44.432', 3, 4);
    t('-1.362', '-11.2026409', '0.1215784753039794393480915736574221530210791635747246', 53, 4);
    t('-3.2', '-1.4', '2.28571428571428571428571428571428571428571429', 44, 0);
    t('3', '-8.154', '-0.3679175864606328182487122884473877851361295069904341427520235467255334805003679176', 82, 5);
    t('4885365', '32646', '149.64666421613673956993199779', 26, 3);
    t('0.08525779', '-0.0000000000000015', '-56838526666666.66666666666666666666666666666666666666666667', 44, 6);
    t('-0.0000102', '-17150', '5.94752186588921e-10', 24, 1);
    t('0', '-1.0', '0', 26, 2);
    t('-2', '-123843217', '1.61494512856525682791331236170972528919367461198944791623105e-8', 67, 1);
    t('0.000021', '2', '0.0000105', 95, 2);
    t('116116.0', '-5', '-23223.2', 14, 5);
    t('3141195.729', '-0.00000000000000867781', '-361980237986312214717.7686536119136049302761871946954358300078015075232115015193925656357998159', 73, 5);
    t('1.93448', '411691', '0.000005', 6, 5);
    t('-2376.356', '2951222.65', '-0.0008052106810714535550206623685271594130656323066644937819245864083', 67, 5);
    t('-0.000000000000001025074', '-0.000027628974509', '3.7101413216262778086592935152937492617525944238077548e-11', 64, 6);
    t('-0.000000478862541855', '653620457.66', '-7.326308964828859515351663358155728873732633102e-16', 61, 3);
    t('0.00000000000000318051', '5.368931740', '5.92391588126244272e-16', 33, 1);
    t('-11799683', '-54', '218512.648148148148148148148148148148148148148148148148148148148148148148148148148148148', 81, 4);
    t('325.3661', '1084482292.48', '0', 4, 1);
    t('0.0000000000000000037', '3.458751534', '1.069750158006001479954818864996851780218104559574298695489931656941044670021678e-18', 96, 2);
    t('0.0000000000000000066858340', '-1', '-6.685834e-18', 61, 4);
    t('-5', '-2357875.2242', '0.00000212055326282010644149165490858123', 38, 5);
    t('-70.0', '-0.0000000000000000160541', '4360256881419699640.59025420297618676848904641182003351168860291140580910795373144554973495867099370254327555', 90, 6);
    t('2238692.91', '-304048.2', '-7.36295399874098909317667396156267328666967935', 44, 3);
    t('48.36165096', '-17.2', '-2.811723893023255813953488372093023255813953488372093', 52, 2);
    t('0.0000000234101105561', '-0.00000056848429', '-0.041179872457161481102670400970974941101714525831487797138598148420249220959122722634956192', 90, 1);
    t('0.000031224', '-71558987.88', '-4.36339318442579403346362701517851596533788202595243302091264849231123585e-13', 84, 2);
    t('520778', '-14.1', '-36934.6099290780141844', 17, 4);
    t('-1', '-1', '1', 77, 3);
    t('0', '349262', '0', 52, 1);
    t('-12.1', '-9.25', '1.308108108108108108108108108108', 30, 5);
    t('-0.0767', '-98934421979', '7.7526101094e-13', 23, 5);
    t('0.000000000000024', '4', '6e-15', 16, 2);
    t('0', '6.94', '0', 35, 0);
    t('-1.2283864', '0.0000000000000084', '-146236476190476.19047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619047619', 99, 5);
    t('632.884', '1.4', '452.06', 39, 3);
    t('-18.23', '208221530', '-8e-8', 8, 1);
    t('-0.000062913', '400.8777994', '-1.569381e-7', 13, 0);
    t('9768.95198', '5', '1953.790396', 61, 2);
    t('-10', '-0.0000000000000000277023144493', '360980668900489159.96729444430868143982879657940927594970630669325877985206687832887720379010476659480245', 86, 5);
    t('-5892110.9', '1.5', '-3928073.93333333333333333333333333333333333', 35, 1);
    t('-5.03', '6044.396507', '-0.00083217571748887915899922281521495823338116425127501980405733829201949805176803236479006191047685', 98, 3);
    t('-0.13389091', '-117.19', '0.0011425113917569758511818414540489802884205136957', 49, 1);
    t('-19.20906', '-0.00001042226563602', '1843079.103032289899499099103753645', 27, 5);
    t('-0.000000006355', '260160366.550', '-2.44272411062222190738222574202473193740201e-17', 58, 1);
    t('-1.10', '-0.00000000000000017597992', '6250713149545698.1682910187', 10, 5);
    t('-13228586', '-20693329673.3', '0.000639268123', 12, 2);
    t('1.26', '2.9', '0.44', 2, 0);
    t('-197.26', '-9.309', '21.190245998496079063272102266623697497045869589', 45, 2);
    t('-47.49', '-0.000000045', '1055333333.333333333333333333', 18, 1);
    t('-0.063686480', '18267', '-0.00000348642251053812886626156456998959872995018339081403624021459462418569', 75, 4);
    t('-21.023531339', '541241.4', '-0.1', 1, 0);
    t('2693.21', '-0.00000000000000000011874', '-2.2681573185110325080007e+22', 0, 5);
    t('0.0000000000000006163225', '793', '7.7720365699873896595208e-19', 42, 3);
    t('59804615', '0.000058386725465', '1024284450338.8009961589305922895534', 22, 5);
    t('-1.88', '-6237933.024', '0.0001', 4, 2);
    t('-46.3', '-7840795.2', '0.00000590501330783387889024317329', 32, 1);
    t('698', '1.6957655', '411.61351613769710493579448337638665251769775950743189432737014640290771336013145685532582', 86, 2);
    t('-119345', '-0.00004408673767', '2707049927.1986617829506548743461', 22, 0);
    t('-24.8', '8989.322', '-0.002759', 6, 5);
    t('9.726', '2.529', '3.84578884934756820877817319098457888493475682087781731909845788849347568208778173190985', 86, 0);
    t('0', '-592.8', '0', 42, 3);
    t('0.00000000000000005825980', '2.8891214', '2.016523085530431500732367978721835641797537479733458067909503560494204224163096781e-17', 98, 2);
    t('-2424545.2084', '871.2930285', '-2782.69781702953221781689029088794092193290170460717740036', 53, 6);
    t('0.03141', '7784326.563', '4.035031128999154759638261594344677032275733419792809892166390604700020214195630990771e-9', 93, 2);
    t('0', '7', '0', 20, 3);
    t('-4', '-1', '4', 53, 3);
    t('1599.3', '63', '25.385714285714285714285714285714285714285714285714285714286', 57, 4);
    t('0', '703.9', '0', 16, 4);
    t('2', '0.0000000000000000001711184', '11687813817801007957.063647158926217168930985796968648608215130576255972472860896315066059523698211296973323734', 90, 0);
    t('-4.2', '-30.1', '0.13953488372093023255813953488372093023255813953488372093023255813953488372093023255813953488372', 96, 3);
    t('-0.00000000011', '1', '-1.1e-10', 48, 6);
    t('69561.2', '10940288', '0.00635826040411', 14, 5);
    t('-0.000029833', '-46.65726057', '6.3940745e-7', 15, 0);
    t('-0.0000000000000016492401761', '53.1', '-3.10591370263653483992467043314500941619585687382297551789077e-17', 76, 1);
    t('-115.81587', '-1.2', '96.513225', 29, 5);
    t('61515421', '-324783.60', '-189.40433260792724755806635556721460073722934286090800151239163553824762087740883', 77, 5);
    t('2438034', '-9.7', '-251343.71134020618556701030927835051546391752577319587628865979381443298969072164948453608247422680412', 95, 2);
    t('-215251219372', '-0.000000000000000000347192993', '6.199757014451037610658231227610057211033633965072561e+29', 22, 5);
    t('-39.9', '-0.000000000000045976', '867844092570036.54080389768574908647990255785627283800243605359317904993909', 59, 1);
    t('-0.00000000000000084628779457', '917.5', '-9.22384517242506811989100817438692e-19', 51, 4);
    t('-6294.4404575', '-0.0000000342498', '183780356600.622485386775981173612692628862066347832688074090943596750929932438', 66, 5);
    t('-146382323610', '6', '-24397053935', 39, 1);
    t('-147.42', '-860.2860220', '0.171361612568430177283526757104510992509', 39, 2);
    t('29.2', '2566652156', '1.1376687694801133777007218269899444839302953835868361431364913010051058901648845e-8', 88, 3);
    t('3493', '-5', '-698.6', 92, 4);
    t('36.33598029', '-0.2664688060', '-136.36110295776984867789740462153757689746243693530116241823817831795290890446666391412434219411033', 95, 2);
    t('-206.53', '0.00000000000003011551082', '-6857927837732091.3064293159480932224811586310658502056250361155255343598', 55, 6);
    t('-2185167.14998', '2', '-1092583.57', 2, 5);
    t('0.00000015544', '22.360', '6.9516994633273703041144901610017889087656529516994633273703041144901610017889087656e-9', 91, 1);
    t('-1', '-243969', '0.000004098881415261775061585693264308171', 39, 2);
    t('0.0000000000000015909805', '1', '1.5909805e-15', 32, 5);
    t('3740375.9865', '-9436', '-396.394233414582450190758796100042390843577787198', 46, 4);
    t('179.506', '312', '0.5753397435897435897435897435897435898', 37, 0);
    t('74542005.0369', '49234198.2063', '1.51402902357738847367808769587778211275856571', 44, 2);
    t('52693.3621208', '34', '1549.80476825882352941176470588235294117647058824', 44, 5);
    t('0', '9.6', '0', 55, 0);
    t('11.2', '1.31715041933', '8.5032049761614526410948365863433733808854270153846483990095181591608779', 70, 4);
    t('-1.006', '13234.8943280', '-0.000076011184907739446214', 24, 2);
    t('-38581.7829', '-0.0000000000000000056', '6.8896040892857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857142857e+21', 100, 4);
    t('0.00000017788', '-1773.0821', '-1.003224836571301464269477425777407601e-10', 46, 0);
    t('0.0000000000000217830374553', '-0.00000000000000002371157929', '-918.666664454807809640418092961196428177686345918631554802691508', 60, 4);
    t('2.3', '-0.000000197', '-11675126.90355329949238578680203045685279187817258883248730964467005076142132', 68, 5);
    t('27.6', '5111.79861782', '0.0053992737319081', 16, 3);
    t('-41484045.3618', '2', '-20742022.6809', 48, 0);
    t('-1.3', '278.24', '-0.0046722254169062679700977573317998849913743530764807', 52, 5);
    t('-3', '14.13', '0', 0, 1);
    t('3942.3337', '39.4', '100.05923096446700507614213197969543147208121827411167512', 53, 3);
    t('806322064.23', '11.937959', '67542706.775086093024779193830369161093617426563451926748952647600816856549767', 69, 6);
    t('122', '-3582', '-0.0340591848129536571747628', 25, 0);
    t('-1.18', '0.00000000000343', '-344023323615.160349854227405247813411078717201166180758', 43, 2);
    t('-6.9', '-1.6822', '4.10177148971584829390084413268339079776483176792295803114968493639282', 68, 0);
    t('-20047', '22.44', '-893.360071301247771836007130124777183600713012477718360071301247771836007130124778', 78, 0);
    t('-0.000000000000003783719', '11.7', '-3.2339478632478632478632478632478632478632478632478632478632478632478e-16', 83, 1);
    t('12.30', '-40.5769', '-0.30312813448045562869514428159864356320960940830866823241795208603910106489160088621852', 86, 3);
    t('-6.73', '-0.000000000000034239868273', '196554494495732.9567586213476318416909932952533237101218564025052083178614511371312482735964175243951879674335686', 97, 0);
    t('-0.0000000183', '-13836.03071', '1.322633e-12', 18, 3);
    t('0.000014732663289', '-11907.468', '-1', 0, 0);
    t('1', '-3.0', '-0.333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333334', 96, 0);
    t('-2', '-2152240.45', '9.2926420001073764783112407352068863866953155721982643714367509448119516572e-7', 80, 0);
    t('-0.0000488540655', '7.117', '-0.000006864418364479415', 21, 1);
    t('19.7779357', '15.5318', '1.2733833618769234731325409804401292831481219176141850912321817175085952690608944', 79, 3);
    t('0', '-7790934', '0', 93, 4);
    t('-5433809', '-24.9847486', '217485.03805237407912121237033379635446882183157128104943189222244165386559062675539589', 80, 2);
    t('6.4506726', '-0.0000006634', '-9723654.808561953572505275851673198673500150738619234247814290021103406692794694000602954476937', 87, 5);
    t('0', '2', '0', 8, 2);
    t('2732.745', '2.9', '942.325862068965517241379310344827586206896551724138', 49, 0);
    t('102.610852', '0.0000021', '48862310.476190476190476190476190476190476190476190476190476190476190476190476191', 72, 2);
    t('-45983380565.6', '-21990.85', '2091023.337688174854541775329284679764538433030101155707942166855760464011168281353381', 79, 1);
    t('0.000000000000000067586178898', '-80', '-8.44827236225e-19', 74, 3);
    t('-166379189.9', '0.00000000002611', '-6372240134048257372.654155496', 9, 4);
    t('-20635674995', '0.0000000006175', '-33418097157894736842.105263157894736842105263157894736', 33, 2);
    t('0.000000000000000002728336', '5540100.5', '4.924704885768768996158102186052401035e-25', 61, 4);
    t('48.99', '-0.000000000000000055715', '-879296419276675940.052050614735708516557480032307278111819079242573813156241586646325047114780579736157228753477519519', 99, 3);
    t('285265.038', '359018944.70', '0.000794568203743037741707227518347724673', 39, 1);
    t('-3', '26715362', '-1.122949410155849656837889750473903366909271152679870106195828453e-7', 70, 3);
    t('35', '-5.48580575', '-6.3801', 4, 1);
    t('-194676582', '-0.000000000024805310', '7848181780433302385.65855455948746457915664025162354350741837130840130601068884041', 62, 5);
    t('-256.3169164', '7938.868', '-0.032286330544859', 15, 3);
    t('3094.61', '468.530210', '6.604931622232000792435561412358020627954812', 42, 4);
    t('-16.54', '-183.3', '0.091', 3, 0);
    t('-29526831086', '-0.0032601', '9057032326002.269869022422625072850526057482899297567559277322781509769', 57, 3);
    t('32.4', '0.000001833940816', '17666873.2803861648717457848432552689312085194356675466456274126569196767362', 67, 5);
    t('-0.0000000000000616896835', '-70.8235095584', '8.710339812958805083264135380603e-16', 46, 0);
    t('0', '9', '0', 6, 0);
    t('-352', '-1.840340', '191.2690046404468739472054076964039253616179618983448710564352239260136713868089592140582718', 88, 3);
    t('-1.45800767', '-5.2640370', '0.2769751941333239109071611768686276331264388909121', 49, 4);
    t('0.0000000000000317829012497', '0.0000000000000000000411245727', '772844.53461810680406169910186082006391278565187377618637238752391948865161096251341719108', 85, 1);
    t('-4.3', '8.43', '-0.51008303677342823250296559905100830367734282325029655990510083037', 65, 6);
    t('-3.89', '-2489.03', '0.001562857820114663141866510246963676612977746350988135940506944472344648316814180625', 84, 5);
    t('8.3', '-955494.70778', '-0.00000868659965609255046166133355661190473328568036540381307940099954742', 71, 3);
    t('-7.20242138', '-1368431.52', '0.0000052632676715894413189196343562738163178235', 46, 4);
    t('355695.465', '-1', '-355695.465', 18, 3);
    t('-309', '0.0000000000007297626', '-423425371483822.2731611622738682415349868573697802545649777064486450799205111360872700245257841', 79, 6);
    t('-40640.908302', '0.00000000000000290351316', '-13997149681250282330.389024308744651944336288112432733041237533085608608021600977', 60, 4);
    t('-0.000000158322', '3.09268248', '-5.11924521912123355126970551467669581133333804122044886e-8', 61, 3);
    t('7978.2', '0.0076056771525', '1048979.57', 2, 3);
    t('-7742.6895', '475.0762115', '-16', 0, 4);
    t('21578.902630', '32.5630', '662.681651874827257930780333507354973436108466664619353253692841569', 63, 2);
    t('3.13693', '-24541106.36', '-1.278235e-7', 14, 0);
    t('63409', '-3.1', '-20454.5161290322580645162', 19, 3);
    t('0.00002566', '0.0000000001944451620', '131965.227296321', 9, 3);
    t('-0.000000245', '-0.253', '9.68379446640316205533596837944664031620553359683794466403162055335968379446640316205533597e-7', 96, 5);
    t('-0.0000000000000000000171175545', '133490374.369', '-1.2823062772063923029449392375e-28', 56, 3);
    t('-1954781', '0.00049611053', '-3940212678.009475025656077084273941937898395343473157080540096578881323079354917139130265991330601267423209098', 99, 6);
    t('-6.2', '1', '-6.2', 49, 6);
    t('-12286.3140300', '7', '-1755.187718571428571428571428571428571428571428571428571428571428572', 63, 3);
    t('19.849636679', '519.354', '0.03821985905374754021341897819213869537925961868012954555081890194356835607312160876781540144102096', 99, 1);
    t('7.6', '-42', '-0.180952380952381', 15, 5);
    t('433249', '-30893585.3', '-0.0140239145373651403289860306372404111995379183134176', 52, 4);
    t('-8969', '57.600315', '-155.8', 1, 3);
    t('0.0000108950356', '-81.23', '-1.3412576141819524806106118429151791211e-7', 44, 0);
    t('17257554596.7', '608', '28384135.84983552631578947368421052631578947368421052631578947368421052631578947368421052631578947368', 92, 4);
    t('2.9', '-22840.8', '-0.000126965780533081153024412454905257258940142201674197050892', 60, 0);
    t('-13734.55427', '-827538', '0.01659688651155596480162', 23, 5);
    t('-17.55380', '-357081.491', '0.00004915908676991605818068010699552052671360667080893307908810092876', 68, 2);
    t('9609', '-0.00006559', '-146500991.004726330233267266351577984448848909894801036743', 48, 5);
    t('-1986505519.2', '-1', '1986505519.2', 53, 6);
    t('2', '-452173479694', '-4.4230811620209633602979431439702536337489266551571568427190599366243954435520300874941211e-12', 100, 4);
    t('-3', '-1', '3', 2, 0);
    t('-0.000000000000000045', '-52784.4850', '8.52523236704876442386432301082411e-22', 54, 2);
    t('-18291.6313', '-45', '406.480695555555555555555555555555555555555555555555555555555555555555555555556', 75, 2);
    t('-4.207', '-213213497', '1.97313962727228286115e-8', 28, 6);
    t('1.641', '-1.6', '-1.025625', 17, 4);
    t('5790881110', '24095.79849', '240327.4210814501213070196122809624309735833950361028272360855056270849482855216224876389228137174715', 94, 4);
    t('0', '-0.000000000743462591', '0', 9, 0);
    t('96.5', '-2791122983', '-3.457389752718037075e-8', 26, 5);
    t('0.000000020126701423', '0.0000000000045', '4472.60031622222222222222222222222222222222222222222222222', 53, 1);
    t('2.3', '10.69', '0.215154349859681945743685687558465855940131', 43, 2);
    t('1.66', '-0.0000000000000000391535668164', '-42397159057924873.1803926502001743692152496396540277885915094781888235162703821490195813464452711347436564423093', 94, 3);
    t('5.5', '8', '0.6875', 28, 4);
    t('-21.2', '-8', '2.65', 74, 2);
    t('0', '3', '0', 4, 0);
    t('-16289', '60495201941.0', '-2.6e-7', 8, 2);
    t('-13.34453', '1.6800901', '-7.94274664198068901185716170817267478690577368439942595935777491934', 65, 0);
    t('2.6', '-837.2419', '-0.003105434642', 14, 1);
    t('53.3', '1', '53.3', 99, 5);
    t('3315.66598', '-1', '-3315.66598', 46, 5);
    t('-0.00000000232', '-1.4301592', '1.7e-9', 10, 0);
    t('30.1580564592', '0.0000000000000042', '7180489633142857.14285714285714285714285714285714285714285714285714285714285714285714285714285714285714286', 89, 5);
    t('-3640656264', '0.000614500900', '-5924574339923.668134579', 9, 4);
    t('8', '206.213627', '0.0387947203897', 13, 0);
    t('86.96253', '3.52672', '24.65818947917611831957172670356591960802105072135014971', 53, 1);
    t('193776850', '-211004.2379', '-918.35525166956848121200697457650446555320109994814469079438332930279027348388626842835558043547712', 95, 4);
    t('9.1', '571.3', '0.015928583931384561526343427271136005601260283563801855417468930509364607036583231227026', 88, 1);
    t('-344.953', '-15.8', '21.8324683544303797468354430379746835443037974683544303797468354430379746835443037', 79, 3);
    t('-247522439806', '2', '-123761219903', 80, 1);
    t('16.4131', '0.0000000006580318', '24942715534.41642182034363688806528803', 27, 3);
    t('24.14', '6.521', '3.701886', 6, 3);
    t('25194.6', '-436989173', '-0.000057654975355647999086695907680989615731280372019651846156838306838325259834297999872870992', 93, 5);
    t('346.01', '-0.0000000000000000011604272172', '-298174667804577239969.27293028679920556', 17, 4);
    t('-7253986.6', '0.000000000000000001040', '-6.97498711538461538461538461538461538461538461538461538461538461538461538461538461538461538461538462e+24', 74, 5);
    t('0.0000000000013848905844', '-0.0000000038192393595', '-0.000362609005103389095401366660533338065060857833359370520490154684', 66, 4);
    t('-315.3003', '-1.30', '242.5386923076923076923076923076923076923076923076923', 49, 4);
    t('-0.00000000000097624807', '23974440745.1', '-4.072036884528911513157680911262659441396e-23', 62, 2);
    t('-0.00000972384040183', '-6489.7', '1.4983497545079125383299690278e-9', 37, 1);
    t('-340.6133115', '-0.000000000001381520', '246549678252938.79205512768545', 14, 4);
    t('-2398.15210', '-14', '171.296578571428571429', 18, 5);
    t('-4506.7756', '4067', '-1.10813267764937300221293336611753134988935333169412343250553233341529382837472338332923530858126383', 98, 2);
    t('-0.0000000000002056', '8555298162', '-2.403189182969822016590051370789384301063474729660743e-23', 74, 5);
    t('-1890.634', '0.00000000000000129874859126', '-1455735169010480840.6735549493465249989787', 22, 6);
    t('-215', '4.3', '-50', 19, 1);
    t('-9045.91', '-93.909595', '96.325726887', 9, 4);
    t('0', '0.029309783', '0', 97, 2);
    t('-0.000000000000000072', '-11.4', '6.315789473684210526315789473684210526315789473684210526315789473684210526e-18', 90, 5);
    t('-5', '7930.738', '-0.0006304583507865220109402176695283591514434091757917106831671907456784', 70, 4);
    t('2.52', '1.4', '1.8', 12, 3);
    t('-2362.497', '7646.45', '-0.3089665138724506143373722446363998979918785841795866055489802457349488978545599591967514336718346', 97, 6);
    t('1.6', '131684.99', '0.000012150207855883954579789237938203890967376008457759688480820783', 68, 0);
    t('-3', '-0.00000000031029503961', '9668217718.7576214892621950412493092576898122', 34, 3);
    t('-0.0000000000000004155575', '-30.947327569', '1.3427896126845691837127043142521241072142153e-17', 60, 3);
    t('-274.3080', '1', '-274.308', 69, 1);
    t('2.7', '-8.06', '-0.334987593052109181141439205955334987593052109181141439205955334987593052109181141439205955334987593', 99, 4);
    t('1355257.02789', '-0.00000000000000037743272', '-3.5907247996146174078389388180229843347974706591415815777709998221669811774665429112770085222076135847e+21', 79, 4);
    t('-1.8560488417', '-79.0', '1', 0, 2);
    t('0', '-55610.94717', '0', 9, 3);
    t('-1', '0.00000000000000102635', '-974326496809080.7229502606323378964290933891947191503872947824816095873727286013543138305646', 76, 6);
    t('-1048642006.2', '-0.0000000000000000000117799', '8.901960171138974015059550590412482279136495216427983259620200511e+28', 36, 1);
    t('-10.606', '-308371.8482', '0.000034393541634583', 19, 6);
    t('-1563.76', '-1.0', '1563.76', 70, 3);
    t('3620.41', '-0.00839', '-431514.8986889153754469606674612634088200238379', 41, 2);
    t('-34.639108', '-421919490.29', '8.20988572397812942949457600417220109644629519729125192293329929449180744079249773972322457888e-8', 100, 3);
    t('-8', '67714.5152', '-0.0001', 4, 1);
    t('-78539595.81', '-27567.48437', '2848.9939363299256311503623788941319348973299154898550505644124538593145487', 70, 4);
    t('-12631.2256', '-10622.81721', '1.189065513441137334603538753727646980757941517850894094411326126922972818431844220729088493842209', 96, 1);
    t('1.4621430288', '583933', '0.00000250395683888391305166859896597726108988531218478832331791489', 65, 3);
    t('-17.4045', '663.99681', '-0.02621172231234062705813300518717853478844273363301248390033681', 62, 5);
    t('889993.2', '-0.0000000090576728', '-98258484232285.36142307988868840570173830965', 29, 4);
    t('-1429240.257', '-490.4', '2914.437718189233278955954323001631321370309951060358890701468189233278955954', 72, 6);
    t('49.299562', '-7459284.2', '-0.000006609154535230069394594189077820630564', 43, 5);
    t('-9308.8', '-0.000000090', '103431111111.2', 1, 2);
    t('-3180', '112.741', '-28.20624262690592', 14, 5);
    t('-15.5696', '-7.6', '2.048631578947368421052', 21, 1);
    t('-0.00007028933030', '0.000801688', '-0.0876766651116144934188861502230294079492', 40, 1);
    t('-172.12151767', '-0.000000000008024', '21450837197158.52442671984047856430707876370887337986041874376869391824526420737786640079760718', 80, 5);
    t('-167.292', '-31.31291781', '5.34258739524344569535980907682777199484496076095', 47, 2);
    t('-29.5080', '1.2916', '-22.85', 2, 6);
    t('-66.6420', '-18434630213', '3.615044035600151476713540519121667721407198047385101621620469442285526e-9', 78, 2);
    t('-161.612097', '-12126', '0.013327733547748639287481444829292429490351311232063334982681840672934191', 72, 0);
    t('2', '42059.8', '0.000047551343563212378565756375446388237699656203786037974502969581405522613', 76, 4);
    t('-538162', '422869947.0', '-0.00127264186972360085924952240694465809366206863596291462159641247808986529847', 77, 3);
    t('36', '3.274', '10.995723885155772755039706780696395846059865608', 45, 0);
    t('-4.7855', '40.6', '-0.11786945812807881773399014778325123152709359605911330049261083743842364532019704433', 83, 5);
    t('353.14338096', '19.9', '17.74589854070351758793969849246231155778894472361809045226130653266331658291458', 77, 2);
    t('27145.87391', '-0.00000000000000013462451', '-201641394349364762776.1096400647994930492226118408898944181858', 40, 5);
    t('0.000011380', '-939.665917947', '-1.2110687194937580380915434840947927246809264549787460761281687158465110383410384423797682e-8', 96, 1);
    t('-102081', '15.22005110', '-6707.0077051186773', 13, 3);
    t('49804.0200', '-7', '-7114.86', 94, 0);
    t('14.12', '0.224636', '62.8572446090564290674691500917039121066970565715201481507861607222350825335208960273509143681333357076', 100, 2);
    t('71855082', '-4598.44013', '-15625.96879999', 9, 6);
    t('8.656024', '4', '2.164006', 25, 1);
    t('-6', '-1812116344', '3.31104568416165667561574622606019605549123616314560429791035536292254753815078442888e-9', 92, 4);
    t('1515436', '127663', '11.87059680565238166109209402881022692557749700383039721767466', 60, 0);
    t('-5.5', '-188266070.4', '0', 6, 6);
    t('76943694944091384167086915802330', '-3170514344.13111437411632629436402363000882134793762203080559731', '-2.426852131627177782103584719976324063198598249615667667537013034965147477765909459742787670213e+22', 71, 0);
    t('-100106813802380591049673190434.29485007726830983381860757169221843019100', '-78094528555018220969404221099599857932226474465981358723152985003774326996070488958663.442862362122064587341729645', '0', 37, 3);
    t('2765444538823009380150927888.62817583856680697300833760', '-373748288687906995883.519458069547968158219485', '-7399216.591817636693983101292832142580414091203843524104084009183630806757', 66, 6);
    t('0.0000172463179744500990608615554398722487', '128351898662310623329971900021427807014001736937674026359996931286121280901491747367836548202.528608641660908590739943216651336106395324584507151', '1e-12', 12, 0);
    t('1618182994977486168089504.303412002229357379185662538096814339710756228978272205292369429799229740090454', '-1', '-1.618182994977486168089504303412002229357379185662538096814339710756228978272205292369429799229740090454e+24', 89, 5);
    t('0.0000000000000001522032939763705088667535980533375348092536476465289413241', '1496543943364674787461682993652979296106902960456836.034677750383049103427390868675285804492754316540692799996989618573', '0', 7, 1);
    t('289251150440844894569227868596141248263971687018908.7582', '969818345137713519457348076418917350.37856042901482781836418515983', '298252917044760.00160068480697641721380359737601457865036690355925562692260445875', 65, 2);
    t('-2213024.10057343', '-0.00000000000890742736591171593701106620816057819688709922018889419831412741863646672006726805124790913781880723722136288', '248447055436293962.98257200988127959945635068362403073', 35, 1);
    t('2096800095471614267703827121104.6754238308397', '2.973744016791308902667556831639027', '7.05104435227776125703251584926381124242257216881232643916317132478678635644883e+29', 48, 1);
    t('10728.59', '5824163674089127623690504744435273553136', '1.84208250323217471512375284637258221177216212e-36', 80, 4);
    t('0.00000000002538387070543995416405436499183653403597088747366207520144542550245681558184831091988077404423487890839376340304725844427690', '14562891408915478681.421127181921914449589980053944489651677113447812731103604100978570606466', '0', 16, 4);
    t('0.0000001139087102258881402161089659878951562048252365503155737106113169695', '112999330291096081712666114036319726856888730969', '0', 40, 4);
    t('0.0017737339683220256362258495322853553726', '344311488386394946670123243419052980555279569441.2581092289564252509313088826893414', '5.151538732078254393229534399097e-51', 81, 0);
    t('-842570312246603784256854878768113013090390680.4800826', '1835117010332854583781870084893679257611413400275028539694753574598984870187.174117913536', '0', 17, 5);
    t('-0.00000000000100684943301409650686603204274713', '-31144152.5321601643531272794334628', '0', 11, 6);
    t('-0.026503227279838553113169386052389485374661223774285251294146269277263514377060436706297988370', '-71045451218274393350706888.0027862323455368609062085008505902080395372345116114084151338799957479745433746186733925305567951229335217540', '1e-18', 18, 2);
    t('-110419631346006605487521542409376009922843127021.32729252503643353043', '244333847708274713267176368482599559622993490167843827', '-4.51921141428769337154851414365744921974137172e-7', 51, 5);
    t('138893.800038647216078219578724974257662781528220275806760809453342527939336259698744105819334031462550443269', '0.000000000000000006348171111337101567342719021981976900938596754527204884080611802666618593', '2.187934093184711195124371794142911460872e+22', 17, 4);
    t('-0.583518556009536368891167105653', '-10441784574938354731049901890211616945183846927326453960214418739234414890916007304010255785348300872046501133.6', '0', 25, 4);
    t('-7.7538588120693509533017285566489706570750381485420112364801121058765556097495024175321672371025233059644071513855874611523627', '-305644204.4597562604754745015566044566739234835770195994902485', '2.536891e-8', 14, 5);
    t('31789997685790129513765060203181448380957005660036613335.44368544620228705185948716548766405754804498731108711764', '-52434089730.1286441452387', '-6.06284915966102621783408308497372568922152725e+44', 2, 2);
    t('464203469483216305594181907657494380404.0131577756200', '2048.0377607488', '2.266576712499163303328179649892198707410967454841685911989506281906764109714566510065582e+35', 52, 4);
    t('1047446033974859.93', '-610168529437812151818980787637.081958441810504970300511542324279', '-1.7166503735286706929530210967953340945869136079522966136115448125308e-15', 82, 4);
    t('-118.33066509', '-9606875158.2747354159409455217', '1.2317289768055087728278381056836e-8', 39, 5);
    t('-598192155524599.543469895866422907968312515845807798812410543694536906451748175', '5694882.75800932980130397772', '-105040293.3551699886292866504040483598198656759423392804848834787366', 58, 1);
    t('-2049743760490918742562713287128097078960201454.7049014175851231280129287812874', '0.0000000000000005771177413168', '-3.55169077944831902790783522124802412003623956082372578582048268563797255797286310356936e+60', 26, 5);
    t('-0.00000000009884649504038136938680320284773210466871053456420299408286245343032575711592101304225442', '-1098525608842646403217112781968194558531214', '0', 17, 1);
    t('-9269786200775977340361260306515894998.021', '33193', '-2.79269309817611464476282960459009279005242069110957129515259241406320609767119573404031e+32', 54, 3);
    t('11958219415768809322523664.23510148866112269670', '-197354727314347918145898028040.448589287170209', '-0.00006059251571269269954205910357', 32, 4);
    t('1970642653364229432816602515045582440712477643422054228961879708118806395724379583117602361343660652032', '-31644394765386367730800662519558297968988.94299193490', '-6.2274619817339032278732958869917127861770080996927559003305288e+61', 0, 3);
    t('12.908', '-6090845987261539127416937275863176894837056503709934034705496307351876662575410450246138356839229866026764921029348319480510482423385605152870', '-1e-81', 81, 0);
    t('-3739413063818.436', '-0.000000000112265754744654239729057667928492728400303558521884186145185975438813258745093576284952622933', '3.330858169816469071325141276282506e+22', 12, 5);

    t('-770817.6149120', '1', '-770817.6', 1, 2);
    t('-0.0187466210691', '1', '-0.0187466210691', 59, 0);
    t('741750111.2', '1', '741750111.2', 167, 5);
    t('-658788.8898', '1', '-658788.8898', 108, 4);
    t('9.61', '1', '9.61', 175, 0);
    t('-0.0200812135393285', '1', '-0.0200812135393285', 80, 3);
    t('0', '1', '0', 83, 2);
    t('0.019711206', '1', '0.019711206', 227, 4);
    t('-37901147', '1', '-37901147', 9, 4);
    t('18.9', '1', '18.9', 45, 5);
    t('15.5', '1', '15.5', 77, 3);
    t('-7897.752568795', '1', '-7897.752568795', 290, 4);
    t('-1251.5193', '1', '-1251.5193', 111, 5);
    t('-322.51', '1', '-322.51', 183, 6);
    t('-1', '1', '-1', 279, 0);
    t('-30817.8', '1', '-30817.8', 31, 0);
    t('5945.68390922', '1', '5945.68390922', 62, 3);
    t('-34433584302.1', '1', '-34433584302.1', 65, 1);
    t('674578813.88', '1', '674578813.88', 124, 2);
    t('-27788.40581695', '1', '-27788.40581695', 124, 0);
    t('-0.00000001312054398836', '1', '-1.312054398836e-8', 166, 0);
    t('7285863936.63', '1', '7285863936.63', 259, 6);
    t('-160424.958593708', '1', '-160424.958593708', 152, 1);
    t('-1', '1', '-1', 152, 0);
    t('8462674971.041', '1', '8462674971.041', 181, 4);
    t('0', '1', '0', 230, 4);
    t('-2', '1', '-2', 286, 0);
    t('572.2', '1', '572.2', 15, 3);
    t('-0.00000078870910606', '1', '-7.8870910606e-7', 193, 2);
    t('-1.13508762818546', '1', '-1.13508762818546', 194, 3);
    t('-66055.885279477', '1', '-66055.885279477', 127, 5);
    t('7', '1', '7', 210, 5);

    t('-3627799291965346540712456501882577638718153439964273.69768754745407377945437075521783565726672078877524231088948196974675990545252844538838313048', '2902582598160223924761958365823830027858536030974673247874848195750710639118580059329', '0', 31, 5);
    t('-36001492.432242546296733753651918782904968060628', '0.0000000268571386752795633902', '-1340481309923749.60424676488025244368284003', 26, 4);
    t('0.028761002817864251956109170412427462717070528743863157542939339484227653369339502297446', '-0.000000094653664305603408767633117494180308734767461188738807756952982012636', '-303855.1442129602517346583444983127341880783118168865288269447897099302126198776', 73, 1);
    t('-85322335566464', '6469888.5944307193591905163370', '-13187605.060141139610979582454208887767681099267106809857522822603509317013524918783027403', 81, 0);
    t('16809851622.475024268444162553728588984396380486399687835621352324230348800918507804359930399204804510891779303641052273377163383820147883', '-57215392073691534065404484981855847094198821321.61', '0', 26, 5);
    t('-6811137700468.4120764694970441135733', '0.0000000023059798665870351445075811611361310997931893558813170397607609131', '-2.9536848084234293518878460220105623971538070065410169e+21', 31, 2);
    t('-638779241138332540350253234404280665291777745188393412936839021876823463401783663308918096038128976596374.561', '-68051131834015582432107963260604318921316821583135690566786271984905882370557171397765996', '9386754105668476.6600599', 7, 2);
    t('35355658849855129861180132974521949639236227942273180070920909591997.5412718864453961655409496833643232', '-6829894701612572880956944.30', '-5.17660379764090344784461795557673945820085318e+42', 2, 2);
    t('0.0000000000000004863277441095313650020277658', '-1915156649006139193824415428828548.226120476308930617348969557716204059468127709020706212182973396317634270963094', '-2.53936274279134646909595038496863193e-49', 84, 2);
    t('3110214615781612992890984598602049585353025840029996756.8', '-12363633.735703916761979890620833004650965570622978', '-2.51561529746702304379852124316472359173133213146019874592196121688793016060937069742986516173e+47', 45, 6);
    t('-2492672185265151812046174378926367157329542788.012959590780989023454605', '2952729318474530090870658399786053537408219.3906284777551455998495603485592436', '-844.19258130743328424729732809565777445198353443', 44, 3);
    t('-0.9240980589910997704959111664719986817089775045950366247068688279255379005723485652', '2755.6517853', '-0.0003353464555720329641810317761965302698250818448919198516365858150087574131', 76, 1);
    t('-11526.519029803437218611745', '-1980641645745226278812446291533504566961012681.6852819482283250153725775125045633888369820790039112495797481', '5.8195883412653009499001562175289054617e-42', 79, 6);
    t('-6932745342923694183863.4407712889787388', '34870883.827073144167437289748257172399669498831227487', '-198811861990754.361', 3, 3);
    t('33243257027', '12751607507856865851589951449477366328020361795144300426079667590.64133288964626', '2.60698e-54', 59, 3);
    t('-1069197506689172.41', '1533236526211500507519256343794194823892728051.876524428551329407055560589140164359', '0', 15, 5);
    t('28.66476546644904598250037221', '13561.3771956', '0.0021137060825761378236596338190565475019637983', 46, 5);
    t('-10.096692387169004444076101', '-7410.64884007451703882184197', '0.0013624572699449996017890531485487416503', 40, 4);
    t('44.7', '-0.0000000000000000301026373988561927150', '-1484919723402656472.793582', 6, 3);
    t('3.56894291995338299991755', '1743568375310759.8', '0', 11, 4);
    t('3', '-826.135811839846027331161', '-0.0036313641861364767959206955234182098243004715472601430821909469785', 67, 3);
    t('-1808754472.784798621211119', '-4.80680493504930', '376290383.576019', 6, 2);
    t('-13719.54124584038123510031', '-82799.7597925792605642', '0.165695423274283022702', 21, 2);
    t('211', '-3', '-70.33333333333333333333333333333333333334', 38, 0);
    t('3928.421774', '9', '436.49130822222222222222222222222222222222223', 41, 2);
    t('-2004652978881980253.113402793', '10322816999041770.04392455520279', '-194.196310858563604831647952256897110242003406104346850039990186256351', 66, 5);
    t('-2018773348883.71465054', '-95.6599547821640', '21103641053.153823906720595724139611921871346297547041415', 45, 2);
    t('-4', '3.4', '-1.17647058823529411764705882352941176470588235294', 47, 6);
    t('-0.0000000000028137592443635124', '-13000014', '0', 10, 4);
    t('2493563679699245721581.10118959', '-2.3', '-1.084158121608367705035261386778260869565217391304347826086956521739130434782608695652173914e+21', 69, 3);
    t('4263', '-377673230.165946', '-0.0000112875355188051814813466004829001', 37, 1);
    t('581039154', '126.1997353157348695726852159', '4604123.396505687590451186522030874068448145555', 39, 5);
    t('36718233569568035.5623632966', '-0.0000000000000000004253531230970461102986', '-8.632411889259977432652492553440731066395804170439188684436466736195285017185879275448308e+34', 53, 5);
    t('-463636264923890408.70', '-1523796614007631384233641.36636', '3.042638765973583e-7', 22, 3);
    t('-37055587088693300137.079346', '-929484432460697135181725', '0.0000398668184152295421171433434', 33, 3);
    t('0.000000015003766126680', '-3126735711697635910537.847162', '-4.7985399183398926661e-30', 49, 0);
    t('21403298.27', '490950349594', '0.0000435956472741079271932239552', 31, 1);
    t('12747419090.74910385808', '5609552870700.213864971009786', '0.0022724483367170588812509767026961008324355580443991349489495630841', 68, 6);
    t('-0.00000000031650284413470156532719022', '24884.25268228752104', '0', 4, 4);
    t('-0.0000000000000000025560659549131481713245589909', '-1839.19039965941103767929', '1.3897777823255771365831427167461403931142788015230608260379260680349248504469029e-21', 100, 1);
    t('0', '0.436', '0', 91, 5);
    t('1.647', '491019608.868', '3.3542448616196921e-9', 25, 4);
    t('-0.000047732386384257731', '-148.74', '3.20911566386027504370041683474519295414817802877504370041683474519295414817802877504370042e-7', 96, 0);
    t('0.0000000000000600', '881.6632103841255050511', '6.8053196836759278403754559818100822e-17', 51, 5);
    t('0.0000000000000000006637245', '13014712642.3817540382848', '5.099801418885075542945e-29', 50, 2);
    t('143776841518863171', '-0.00000000000034609861', '-4.15421609231147073950975994962822878716560000053164039000329992657294983068553785870448887385014346055882743938208824e+29', 87, 6);
    t('645.46862418407791010997', '-0.000000000000000167', '-3865081581940586288.083652694610778443114', 21, 6);
    t('-7', '34.6', '-0.2023121387283236994219653179190751445086705202312138728323699422', 65, 4);
    t('-1121235833199899', '-32.8', '34184019304874.96951219512195121951219512195121951219512195121951219512195121951', 65, 4);
    t('0.0000000000188990009740969592', '3378889801717.569696743', '5.59325757368297407e-24', 41, 2);
    t('-0.0000038752364', '21865.820957', '-1.77228031255757803194199e-10', 33, 5);
    t('3932331.838871822', '-23243490297748.2880832875437', '-1.69179920420676512721486683805551646729696968236e-7', 54, 5);
    t('206040930636923340359166692', '538.2', '3.82833390258125864658429379412857673727238e+23', 18, 3);
    t('0.0075', '22087187408224417.09296328', '3.3956337950060989374730469091936150605677e-19', 60, 1);
    t('4706.821112', '-4484.0913', '-1.04967111441285773998401861264510827422269479660238', 50, 4);
    t('-0.0000000000000003941356879017724141765125', '-2978880330505.199022894078127', '0', 2, 5);
    t('-3717638164756266179.31373', '-0.0000000000561', '6.6268059977830056672259001782531194295900178253119429590017825e+28', 33, 4);
    t('-166897.9202', '-288870139993051017637902283', '5.7776106663019878573e-22', 42, 2);
    t('-109773551.005', '0.000000000000000291', '-3.772286976116838487972509e+23', 1, 0);
    t('-69483831516149064933', '45666797733.7', '-1521539388.886757599986395999920494858843131', 33, 5);
    t('-2615008789.04', '-0.000000448699711223001786', '5827970742197229', 0, 0);
    t('-15.73379275132695121', '6940.2776264951217530', '-0.00226703', 8, 4);
    t('-6.2', '0.0000000000000061493836805438314318105727', '-1008231120724556', 0, 5);
    t('690', '0.000014578939930754707820', '47328544.0009547235807333066257912877', 29, 1);
    t('-29256.628612', '-755504.1526726314415', '0.03872464301950333628903545496047362726515935622535422', 53, 6);
    t('-322915.4117033386', '9.11', '-35446.2581452621953896816684961581', 28, 6);
    t('-4882625292842289459782.0713', '-13.38', '364919678089857209251.275881913303437967115097159940209267563527653213751868460388639760837070254110612855007473841555', 96, 4);
    t('0.000000000129351956271', '-1.23277829937087117', '-1.049271846665476808964426796136761445163472822311e-10', 58, 4);
    t('-48182353470928.914851766197711', '2272941918553283127', '-0.00002119823347778141066704688834669339833', 41, 2);
    t('0.000000053624403845025055012694', '-0.000000006053504014848', '-8.8585', 4, 3);
    t('-504313761620588', '-0.00000000000377', '1.33770228546575066312997347480106100795755968169761273209549071618037135278514588859416445623342175066312997347480106e+26', 90, 3);
    t('53662399.4035417690', '-65017.90', '-825.34809', 5, 6);
    t('704021459384072.011987216647', '261808795961066517287.30237', '0.000002689067251540191817460319532140345637081639220151448601586269279206225927743', 81, 3);
    t('-3.00', '6046001143510655285.0', '-4.961957381069941064583069603421034150719179715307203065064584517e-19', 82, 3);
    t('973187354320146232724757050', '-568184.017437886808358801', '-1.71280311387240648806239296872607262685395385114971208588734369281880271e+21', 51, 3);
    t('-7', '-228023476845.9625107669', '3.0698593394086058293957362e-11', 36, 3);
    t('-0.35128712', '84029956765557847990155625003', '-4.1804986402656983115928354008537100293091431728296533e-30', 82, 6);
    t('1.580', '26596811565693', '0', 6, 5);
    t('89476761206818481.30255306413', '6431672239.9', '13911896.917217546364625511259955397093741757541639618090079161404687487019778350630314121', 82, 1);
    t('-285.84043874171354004290', '-3.80', '75.22116808992461580076315789473684210526315789473684210526315789473684', 68, 1);
    t('5023551710351214.645250', '59', '85144944243240.9261906779661016949152542372881355932203389830508474576271186', 61, 4);
    t('55.8578416393', '-691700380830418738.5565', '-8.0754389020634e-17', 30, 6);
    t('-3911724.737800850440974979', '5777887024710204784553820488', '-6.770164804316e-22', 34, 6);
    t('50', '-1.7', '-29.41176470588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941', 98, 2);
    t('53803800627864394248948141885', '0.0000000000000001263391910050269947733', '4.2586785778708650076551456104714784704241888012e+44', 2, 1);
    t('-4427033.670465245740417', '0.0000236581313971487858', '-187125246544.145067202651826613329029261197764651089163179', 45, 0);
    t('-9647374130', '7946137.265686351', '-1214.09608309436924121296', 20, 4);
    t('67.235726', '-5573105471252449696.7', '-1.206431967721042366696605205e-17', 44, 0);
    t('202151625', '35175155404.094130', '0.005747000195952824', 18, 0);
    t('14835331211045.5493152', '0.0000000000526993611934416', '2.81508748400005203302285837296595379515264240755406139468921221479492486503e+23', 51, 1);
    t('8.069344', '-1033236.93413135539256239', '-0.0000078097711506837641217', 25, 3);
    t('-862630169598821067434895771.20', '-264324327', '3263529238452656941.54172866275755239130902998572658807904579', 41, 5);
    t('-0.00000000120003533', '-12.69445', '9.453228221782e-11', 23, 0);
    t('365895428531107702.61163381', '98087842.582662', '3730283171.666', 3, 5);
    t('713857126359238153466129958.2', '155931649939351528.34', '4578013037.35891749636140441', 17, 3);
    t('0.00076074305474025948675149820', '-8885880406', '0', 2, 2);
    t('-5.5062225112792408403541', '9514589.0213163653965887', '-5.787136468998470961850846060990378991351091119514e-7', 55, 1);
    t('0.00000506877891572040497122', '-3.902263937071', '-0.0000012989328752388233797415850039254655020843332436413852802139307588062849466157864782046595', 94, 0);
    t('-684.64', '-163036108473143.9045182524546', '4.1993151481089e-12', 25, 5);
    t('-115.2432253756119374', '0.00000000004559', '-2527818060443.341465233603860495722746216275499012941434525115156832638736565036192147400745777582803', 87, 5);
    t('-0.000475387045386359848022134', '-1153538800396479.29', '4.12111881475478780474633380955501014884339769086551346373265e-19', 78, 0);
    t('-1.19867', '11243158.062340655763654254507', '-1.066132836836107775099490457235780480587763022452727371256982516966577648609949e-7', 85, 0);
    t('-5360', '0.0000299063979378797693010823945', '-179225863.68086026271', 11, 1);
    t('1848.7', '-0.00001905117238', '-97038647.4451710357155458167136693558173557401', 37, 3);
    t('8391182377.4232316885', '-0.000011565465464', '-725537800751953.5219373856408759235044653625191958811075137200375111508784840032271441314815377498930206480792963', 97, 2);
    t('-103265.04277385519', '877.661', '-117.65937278044163976751843821247611549333968354524127197175219133583467876549146', 78, 6);
    t('-0.000003172790', '0.00000000000734552178620800', '-431935.27871052691777125857143344101398079282329855', 44, 1);
    t('845.149698634', '134608.469693066', '0.01', 2, 2);
    t('1213867.736088558497', '394513337588257389235052561.4', '0', 14, 1);
    t('903382849144828905627453.7', '-145214841100.492', '-6221009108288.50653300185138436076207033700018325051347599', 44, 1);
    t('-1851.2013658186151007551518', '902158.47437813188', '-0.002051969158849468552481150467195438558033', 42, 2);
    t('0.00000000000009286532571046638105826044092', '5.8170675953588773257319281514', '2e-14', 14, 0);
    t('-1.8', '-14023648062663978059.5676', '1.283546187095389865277054852377378944975885409409388208510620959318e-19', 85, 5);
    t('30310353.7', '-325658', '-93.074187337636416117522', 22, 2);
    t('43.01', '-0.000004044336362136732681', '-10634624.85530670587485242332285837151141452123361995240726115365877739982920896502305890948', 83, 2);
    t('-1560062512144707718870.67', '0.00000000000000000109417237569969976616828176251', '-1.4257922670978429728476419788183802901064679946982495391739203862934972237293303746615318547e+39', 52, 4);
    t('1020648162585306.6', '-2.1914898184005', '-465732559656720.572478372067308602018356676157574623601966177717104294492460074', 63, 6);
    t('3', '-41094051.07508828237681', '-7.3e-8', 9, 5);
    t('-1.500', '-46509992746526152636592.9583253', '3.225113381923792099892011542084055429665680469192e-23', 71, 4);
    t('26.35176', '129.279716', '0.2038352250093123657542688289940240895949', 40, 3);
    t('-327986.31492440227273268', '-4385770.7548116758221', '0.074784190342043070123660027229907124036893230965876429396666', 60, 1);
    t('-0.31396142411336445', '3760338356.14', '-8.34928653696065027314938490119187724335547457472740082316628740223841701645175613491967214e-11', 100, 5);
    t('29084829.399916', '-441225.25610969', '-65.91832402423812982677791123384997461876705508459707', 50, 6);
    t('106668039.3316', '16509842', '6.46087584191296318886637437232894173063558088563173408927838316078373130403065', 78, 4);
    t('33660.9012992698241', '231215262368.74297832866772', '1.4558252320552823585058e-7', 29, 1);
    t('30183289889874653144216.021691', '-0.0000000000000001850', '-1.63152918323646773752519036167567567567567567567567567567567567568e+38', 27, 6);
    t('4830163975203099.03869950', '-165327631.1366', '-29215709.0862339470497822764604891788203097047531376913682467957161830239082624908242430677144850454563', 94, 3);
    t('641.583800', '5.0', '128.31676', 36, 4);
    t('-1', '0.00000059794', '-1672408.60286985316252466802689233033414723885339666187242867177308760076261832291', 74, 0);
    t('114468080072.82454', '15882189820058955342014753', '7.2073235095234260194407547081109103e-15', 49, 1);
    t('1205.63063736256589', '-13323156977', '0', 2, 2);
    t('-0.0000000000000000032005131', '-20405770.066', '1.568435344340510908116982e-25', 49, 1);
    t('-46655578', '-17435198', '2.675941965213129', 15, 0);
    t('-1826391.95321290281351', '-21019556', '0.08689012999194192367859720728639558323686761', 44, 6);
    t('433', '34259436007990415554844288', '1.263885371314e-23', 35, 3);
    t('-0.00051660223042684501971002', '710667.3449091584106', '-7.26925521662853510559568125138211960288020929323343966226839411644763293707228331684697909e-10', 99, 0);
    t('6632516058123153544978.8173136', '4798337824752', '1382252834.28557935015374641580975576914925105981861839059550113290901610933603575423857', 78, 1);
    t('-410294', '-487431396', '0.0008417472', 10, 2);
    t('-10467.4881368', '-4862.011612840367', '2.1529130266073011054275331072440845263173777913371721864220333', 62, 4);
    t('24178718956171512.95123', '4.4', '5495163399129889.307097727272727272727272727272727272727272727272727272727272727272727272727272727273', 84, 6);
    t('0.000000000000000000053539203975686828042162', '-175327185.4193', '-3.1e-28', 29, 3);
    t('-0.16317738810100647624', '6260323849071065.14632897136', '-1e-11', 11, 3);
    t('0', '-0.00000000000000008058624768587745533362074523', '0', 37, 3);
    t('1786661973243896004484674.8427', '396.91748100', '4.501343626243299685973455129077572675616169195631874928683224e+21', 39, 1);
    t('699824037892.29566', '10830178822298.096957295230378', '0.06461795778029428029688562942713791286349020898535266704475778004693770130354368139085380837514233', 98, 5);
    t('27.3', '-24', '-1.1375', 25, 3);
    t('-7743258.888321', '427071695122.89611752', '-0.000018131051476246310744180936426415946345485474108798530074610022052497467343665750650673516727527', 100, 5);
    t('-0.001131684507013295031968373268', '-1041308839.16589692192831', '1.086790454904608603556308528336041092853580165784500403e-12', 66, 1);
    t('2002612.9276540289151', '32.61', '61411.006674456575133394664', 21, 3);
    t('60179824375164.647', '-2389940381984.057698243', '-25.180470956018216552468050930430455353105359149977', 48, 5);
    t('-0.000000000000000010257504915', '0.13', '-7.8903883961e-17', 27, 1);
    t('0.00000000000000001106225394185', '0.00000000002142311562290', '5.16369987287242537734434196204470693651936467886e-7', 54, 2);
    t('0.00000000005148472716539298157457', '312510049836876.427842', '1.6474582878940024381560607237302547675904884227203911e-25', 78, 4);
    t('1295.04', '2.7', '479.644444444444444444444444444444444444444444444444444444444444444444444444444444', 78, 6);
    t('-8.3', '79850188565363554', '-1.039446512165191466917812606438347257466854212445764877244764116930149631716572e-16', 94, 4);
    t('-2539862220.0207', '-44236.550550726180875', '57415.467264072333635960729236763378', 30, 4);
    t('16839944980983150.90655868', '44432765.7621', '378998351.6026631957333525953564219350038387962931060748756882525145122694635411377580328146268455715', 91, 1);
    t('-0.0000027046395062488122194', '0.0000000000000013619006519452', '-1985930106.124687565841353954068087337021798551917276386357928512080934434020694783', 72, 6);
    t('-1.1198910236', '-0.0030109339351', '371.9414134414762104887739355035442205574814705936920043848889', 59, 4);
    t('2009385673', '20.9', '96142855.1674641148325358851674641148325358851674641148325358851674641148325358851674641148325358851674642', 97, 0);
    t('16.7003690316461037', '93843.32', '0.001', 3, 2);
    t('-1935073101337397', '-0.000000000001658979394', '1.16642383162560064926279608750824544599497297915202435600595530965347240473319586029770783e+27', 62, 1);
    t('-330.366065140860', '1534019.623575', '-0.000215359739', 12, 5);
    t('-0.00000000000000269032', '-25.2161338454486377449', '1.06690423539514e-16', 30, 3);
    t('3.227', '-1630.742200259200945873', '-0.00197885355483354713384065004992007650246834325039707920127279577862987539580196966597908560236055', 98, 4);
    t('30126844.5139992367407931165139', '-464.64', '-64839.1109547159881645857362988550275482093663911845730027548209366391', 64, 2);
    t('-7977466949919.20197939320571750', '25201187.5848772923514999213774', '-316551.23089144869109015446556078962824', 33, 0);
    t('0.00000000000000426441195921089884284213238', '-18690382297316625066', '-2.28160766932153106668e-34', 54, 6);
    t('962013664.0107040', '9.3', '103442329.4635165591397849462365591397849462365591397849462365591397849462365591397849462365591397849462', 94, 4);
    t('1006973806184.623056', '-1.066971', '-943768674298.1984102660709616287602943285243928841552394582420703093148736', 63, 6);
    t('-25210.15', '-1', '25210.15', 80, 5);
    t('-0.000000000000001376148315', '-0.0000000029456', '4.671877766838674634e-7', 25, 2);
    t('37242.4', '316145754497658724540554.1', '1.178013605122627241684395290884998159939e-19', 58, 4);
    t('86328906834.10816309', '-0.00247371887769057820998', '-34898430703938.096391606813152501754497939669327', 33, 0);
    t('0.00000002765836017', '43.4221', '6e-10', 10, 5);
    t('910.80105073607989', '4268684621919.65', '2.13368082068917954228345323193625136056867444933e-10', 57, 1);
    t('980986779253.7448670475747006', '1260.3', '778375608.3898634190649644533841148932793779', 34, 1);
    t('-0.00000000000031260', '1.981416', '-1.57765961312515897721629380200826075897237127e-13', 57, 5);
    t('0.0000000000000017052396538958004912455', '2649918125.767736006', '0', 3, 3);
    t('-1752732913576622160', '-205825254612177219.70', '8.5156358333149142698669189920154989458330771987368756031356343736501194705', 73, 2);
    t('6922377660970977.67946', '-4388778700989588504770506415', '-2e-12', 12, 4);
    t('-0.0008967346570245', '679037.25394626927', '-1.32059714222315208715715586429957141837846338692429127615686697655109811863574e-9', 86, 1);
    t('10604413834153', '-11598666613031363424932579883', '-9.142787001256421998531972726183529e-16', 49, 0);
    t('-0.000012348', '-0.3832284502169', '0.0000322209898378141479427691532588808859523574928660271955209972049087057765552158694511685', 91, 1);
    t('-2225005.8', '6610854707.4', '-0.000336568552551819466114802969538939', 36, 1);
    t('-105884473', '-0.0000000000000106268', '9.96390945533933074867316595776715474084390409154213874355403319908156735800052696954868822223058682e+21', 77, 0);
    t('-8.45166', '0.000000000000000003351828', '-2521507666861187387.8969923277686086517565937154293120052699601530866142296084405285712751370297043881726627977330579', 98, 4);
    t('-0.0000000000000102799919001671062777', '-18.142', '5.666404971980545848142431926e-16', 43, 4);
    t('-265.4142', '-569510.1041779800093296', '0.000466039492632169853045073207505280730820703997180116748757530048956809346930242922759289414621', 98, 4);
    t('882686.635528258', '534854.79223598628', '1.6503294881927558448557149', 25, 2);
    t('-95518761105458384136', '-1.2396', '77056115767552746156.8247821878025169409486931268151016456921587608906098741529525653436592449177154', 79, 5);
    t('1.69', '35776.574327736085709825', '0.00004723761376700098130499', 26, 4);
    t('8323545844568', '-150063.7704', '-55466724.7289689583862408404473888922092550594743686382', 46, 0);
    t('0.0000000000006622282463026677511277066', '20.5189951491', '3.2273912123406992083565695120075562063187485370445576465444e-14', 72, 3);
    t('43639749.88168014571993635', '0.0001944531891408009166056131595', '224422906482', 0, 6);
    t('-50863101304', '-1.5', '33908734202.666666666666666666666666666666666666666666666666666', 51, 3);
    t('0.0000000000000015', '-0.000000000000000000140806553', '-10652.91329161363676021527208325311393710490164474092338585974759285528422814242175220353558402925', 92, 6);
    t('98.0949085616362', '20494774', '0.000004786337656694150420980489953194897391891220659471531620695109885085827245', 78, 3);
    t('-3009', '-205469071446121021512734996939', '0', 8, 5);
    t('-10.33', '3', '-3.4433333333333333333333333333333333333334', 40, 3);
    t('-1.0', '-0.0026695218361', '374.598921228880372371343271066191673171757053454131886207424456287256065124', 72, 5);
    t('0.000000000000000000096299113359374660689872154', '-0.000000041247', '-2.3347e-12', 17, 3);
    t('8556123431827', '4608076357009950869947910.5', '1.85676685214018981902e-12', 32, 3);
    t('5279', '-1.3', '-4060.7692307692307692307692307692307692307692307692307692307692307692307692307692307692307692307693', 94, 3);
    t('-2', '3460.2', '-0.0005780012716027975261545575400265880584937286862031096468412230506907115195653430437546962603317727', 100, 2);
    t('-9840946810698489631.31', '0.000000001340199962655292', '-7.3428944074889845947016437140958301917208345973724709410330506874828356015861442719287e+27', 58, 5);
    t('0.0000000084', '-4479933315301219812670', '0', 8, 2);
    t('-0.0000000000005699', '-22418743580046824.54672034', '1e-25', 25, 0);
    t('-11393.31', '363.1954', '-31.3696428974596043892626393395951600708', 37, 1);
    t('-698013.4', '-4.748519', '146996.02128579458142633524263038644259399614911512410501042535577935', 62, 4);
    t('-75.98013345303526819', '-113870220948852.52747420278', '6.6725200688917185714557430189134938e-13', 47, 5);

    t('-0.000234165067858386', '1204524.58490781295081290690165872894736', '-1.944045566129375287285413911441354845634213911376682320674485555498202e-10', 79, 4);
    t('-5.7', '0.00000530568171612961', '-1074320.0035297325370775240385470160210725918436357220360533165', 55, 0);
    t('0.0000000000000033124526299709013935', '-2763518770598702844.5257', '-1.19863583530256778728299146187175203922171872179799864636802734104900031920120940316532340914091294177225700870458187447011932777568573345799530311017003420260142628e-33', 198, 4);
    t('-23.5', '-10.07', '2.333664349553128103277060575968222442899702085402184707050645481628599801390268123138033763654419066534260178748758689175769612711022840119165839126117179741807348560079443892750744786494538232373386295928500497', 210, 6);
    t('166672266184423.021626904', '18059995237353198700384386643.010', '9.22881008515979e-15', 29, 6);
    t('26.913399141', '10383640753575568607140776334109', '2.591903916912039712271834490487152193455348739851838101216180411159779609836189141388848951365988108198314614508052418916462825623970036e-30', 165, 0);
    t('-21926821018666568031129910213716652606395.27', '-997410.64795140439778768906113385719', '2.198374467297132899908106309536727825928127237180292788209481559738646061389e+34', 41, 0);
    t('-30.67', '3.8976', '-7.8689449917898193760262725779967159277504105090311986863711001642036124794745484400656814449917898193760262725779967159277504105090311986863711001642036124794745484400656814449917898193760262725779967159277504105090311987', 220, 5);
    t('-0.0000000000000000000119043120923216765732104322725575428058', '87817.89', '-1.35556799330087258680553954012759163375480781877132324632258871170783083036952948880917088761754580985719424595603469862461965323922039119819435424832001771e-25', 181, 3);
    t('-614.6470035284084362635939', '0.0000036178254380789796882746012143141', '-169894046.589151728283103', 15, 3);
    t('-43040.4061516774233', '583988523334470923611250125489227.08', '-7.3700773956865342991994517695288528995346732712900162726204530185819328662358254662731547463004357865451232508161517484991367092169323944728800811313034790353095013941810415043379e-29', 207, 4);
    t('76684144324315387882960167710055593944236701.8471372220', '2266090205881393', '3.38398463244269590810638171240493548569128865819965019e+28', 25, 2);
    t('17080782645769555714704457227966901164193270.29845561', '-30391154887848.2554644606520118486138121046860', '-5.62031377511067124177509277508491860108479228022084079991223459422496469426745707223249134974052e+29', 66, 1);
    t('6951759681668432032711749392750783.9175356237927532111656318', '2.7064', '2.56863718654612475344064047914232335114381606294457994591775051729234407330771504581732190363582618977239136860774460537984037836240023647650014779781259237363287023352054389595033993496896245935560153709725e+33', 173, 4);
    t('3610.4019733373874707786743105929447', '634750877775355682588872001419455991096038.24825615001121', '5.687903868665688955305694340347322964961954295167397589705336952253660328941e-39', 114, 0);
    t('-0.000000000363816408313404776598470', '-0.000000000176054995898169309', '2.06649295271255569435711935566071788588382725518115529717617541560570250053194099172053838652853511065500135841507304305', 119, 5);
    t('-0.026120257089245975337460', '-10313527642984828336594593633', '2.532621038448735499393356786871240840301703234531308009570150881137642734676636913392599603e-30', 121, 6);
    t('0.000000000000000004410941969151600946547', '-44281616230979038183093822629266520089022454962.502', '-9.961113311997279471841231246847650178644604097067120465778325734554891728411328577767291415744156156277994614481535402329799780287979095306881233592159622160728e-65', 224, 1);
    t('7764427107488', '-0.000002674812529667537596160439177377599760935488475327567527', '-2902793007498387014.48044362598228935011502311864234520569237714021083485607508423178277747936902105982430826830844683987813637898007482287809417852492708407047036731916276421684209217493488238977913', 179, 4);

    t('-2.684589e+0', '-8.298191387835406867663644795762577999681e+33', '1e-8', 8, 0);
    t('6.977911290006014182648715746194971078277555330014970461399e-7', '4.321829466480785587848132891783076314e+36', '1', 0, 2);
    t('6.86140621534e+4', '-2.4476846364974384372861666982952981676991222127645053978394e+22', '-2.80322314117984e-18', 32, 1);
    t('7.357561152451242940317e+11', '-2.648460003354772976631704945839085e+20', '-2.7780525826825805216131501793e-9', 37, 3);
    t('3.8258392715e+1', '-2.228654383349426575347306076218045986778346e+32', '-1.7166588503284108260451166287229525317827195396729e-31', 80, 4);
    t('-1.2570687218822116166125857102810153948324213786e+46', '-4.809117934e+8', '2.613927832783756424744367082683016179973808433120450898886190633394435e+37', 32, 3);
    t('9.626195658e+7', '-2.0085501626269837453288189876105866300475813045157981e+4', '-4792.60903566874026466045202923289181547579680145575014194856793200300036317880008519360363', 86, 0);
    t('-3.64533907917885729535739841744314937737517731530437841e+23', '-1.7265126331152074647790745439743846377979463548536e+28', '0.0000211138859297046890962298', 28, 4);
    t('7.39795272246012132e+15', '-8.507649324190330772e-9', '-8.6956483989356028289430730108548466741894629427205910354758526866523678980437464869746571187378462716425111145661225601e+23', 95, 6);
    t('4.3343427747354259351058185933767988216018653e+20', '2.942769405736425339909419857531486875e+9', '147287883525.170761322706812750128616543853659164696768704020314521886872955783231335178457', 78, 2);
    t('1.042351453472645229718e+14', '-8.1066266385402751519347723e+25', '-1.28580172733887853360689025161397132403478201888896064498766e-12', 71, 2);
    t('6.38906035177779493e+13', '1.60337080310451456115855e+22', '3.9847678025613446771717106354216247648325819717141849e-9', 61, 5);
    t('3.1408858250837517594e-13', '-2.5696781557770853056570768387942747953e-5', '-1.2222876308546624206e-8', 27, 1);
    t('-1.1e+0', '1.65625870433963801924812297552444726205e+38', '-6.641474531e-39', 48, 3);
    t('2.13111e+0', '-2.113892292836264709191412822070652655316e+39', '-1.008e-39', 42, 2);
    t('-2.16169668759945865460592071150656e+8', '-4.61319410657275351248683519834438786301441e-7', '468590013266411.660197185452972162138337424697682692', 36, 6);
    t('-6.694576234276447704831254188731081371011543645e+39', '-4.9933816383e-19', '1.340689880967243773995926456869849096431228739194284548342730665421889e+58', 11, 0);
    t('-1.8622866502154589395913494293567400069289993e-12', '-3.51901484483879256773e+20', '5.292068184784173628395225e-33', 57, 5);
    t('8.171e+2', '-1.017285344548424669090869e+21', '-8.032161324045345318349494756349111649247256388570208173061814265805930600586683e-19', 98, 2);
    t('1.1593291795888842255456406799619572356750950858596669e+24', '4.3939043260187083422239580622172109613895683484967375e+34', '0', 4, 3);
    t('-3.691954879536400550465345429e+6', '-2.3286565939140717663765119466326782700047244284979272e+52', '1e-16', 16, 2);
    t('3.290995909250644626602403233982e-5', '-3.72804885383603841528932457594039248874217e+13', '-1e-15', 15, 3);
    t('-2.8257790508124e+13', '2.2099490200460778342645851618607e+11', '-127.866255066530086694493637648', 27, 6);
    t('1.222504367031675454484326842964789696580983337378049696e-15', '5.398989058287691837779392874e+27', '2.26432088273095513074257888426898404438e-43', 81, 4);
    t('4.061170008482961e+15', '1.2941019701447e+13', '313.821484100581', 12, 4);
    t('-7.112855e+2', '-4.471379399262893594476210623345636203005298072e-16', '1590751838498104940.448', 3, 6);
    t('1.51658497187542231e+14', '2.0466256499056096481968585948298376e-18', '7.4101727980657683623438886297543422771e+31', 6, 5);
    t('1.15629093366e+6', '-1.64780587468499e+14', '-7.017155063129310675892792381270633e-9', 42, 3);
    t('0e+0', '-6.4215255610276741653e+4', '0', 61, 5);
    t('1.53383929416394591831573929326266805686729e+19', '2.1001119162527479394989376499513738164781e+6', '7303607404412.959609521511410682657466697211721578772169', 43, 0);
    t('1.3682373349575334e+13', '7.3600491108875015330874e+4', '185900571.360799840901532589795015622988508772394680944957251367253071994448592590501014753952246546273653151', 99, 4);
    t('1.3154004825473805973728e-7', '-4.2582470979271932781366124122462035e-4', '-0.000308906564672511419324094397349121405120205734129928276', 57, 2);
    t('-2.104683784186112035861065543719370616598874094e+1', '2.949462623949027449275e-8', '-713582117.33097219832176840146725375704044380206297228453272535', 53, 0);
    t('7.264384e+6', '4.1347781511967869682324184706673016934485517898e-12', '1756898129564065538.5648236691867481772804909', 25, 3);
    t('8.452e+0', '-6.498752841059176815657360373992243370692529926e-6', '-1300557.231012109076220298338725550868419', 33, 0);
    t('-8.1e+0', '1.395459695825119273719768559e-18', '-5804538837082330156.779223742084551100646177915819', 30, 5);
    t('2.29759989e+9', '-6.74056783179189161439e-13', '-3.408614744834061231017348297805381333362918884614317205392744042799e+21', 45, 2);
    t('3.97091582794225350279171799532e-7', '2.41641837877861e+12', '0', 16, 6);
    t('3.91755997773439294874762704576067485095445759725e+8', '-1.250019237909e-19', '-3.1339997489059339788321458120106149277099554172394312726319722815414057472452e+27', 49, 4);
    t('-5.88024471232446948649e+20', '-8.47609867526076e+12', '69374424.928383325316192683904844889709235557779702197243871143943081592370136257760539021736478527', 90, 6);
    t('4.62653566481581417883704493628225e+7', '2.338441527793468175731223125091471817382739415e-8', '1978469681549561.9830730024638681222283016', 25, 0);
    t('-3.70841e+0', '2.0212835550025920164236650527972686e+14', '0', 7, 6);
    t('-1.243519842187341059877996186201005242904186e+24', '3.82960151991082846e+0', '-3.247125936529020862492815416213503335626772746119281932758760079466e+23', 43, 0);
    t('5.805502676478053e+3', '-4.436490697865052222068353951847332008937e-12', '-1308579927660347.1317553786911547314648452364448033931774319044807345184', 55, 0);
    t('5.2494545223e+10', '-5.27035784208457683653e+14', '-0.00009960337949697341656415916012814401160294873770325650334566064690145467', 74, 2);
    t('-6.491148513421149560857391627411087984e+6', '9.982586739202018304193114651e+2', '-6502.4714365166987562205089717878495692701415667688831557', 52, 3);
    t('-1.9168988826688945002797462392e+8', '-5.6803714774636698531824146882277509515920145e-6', '33746012743603.25453300564268832335590229566345157198883904613540264', 53, 3);
    t('-3.0258848821938566680797457e+4', '4.0777429787685523978273163156521728105076e-10', '-74204894667187.951707382924811293760803562598157029520944344469016807', 55, 3);
    t('3.69927674623251618e+4', '-5.220718872545424800848019614582913381e+7', '-0.000708576124580500336192976887065487350085252556049744741097735562040616366441083', 81, 0);
    t('9.0360008962766875594763448795524371902981009801e+9', '-2.223480500424439742e+18', '-4.06389932115519213237591244399326869093522905516048989011451996203527973232052e-9', 88, 5);
    t('7.846135938905626718e-1', '1.1227167968e+8', '6.9885263685988408630887956445331058219721470546364591452062258840875302027012481229852e-9', 94, 6);
    t('1.70727356485719357771889024622608240016418e+7', '-2.611709352972367924505574729526972189307321059e+23', '-1e-14', 14, 0);
    t('-8.146425e+5', '-1.9277404692834179214047867012804398030805175180163596757e+44', '4.2258931e-39', 46, 0);
    t('4.8547000826477016024456452593554872e+26', '1.48551069033736534532935793131415257927835e-7', '3.268034430331282259778757092657146e+33', 0, 3);
    t('6.03584602176774046327932728e-17', '-1.2586589303123068e+16', '-4.795457988185954652905480897359524202862898328367111641e-33', 87, 3);
    t('4.4172739030183528644508688032320793125e-4', '-2.3061374143740932698459421e+25', '-1.915442625181657396931840988726152e-29', 62, 2);
    t('1.4068028613883262515279256094430309654735814056843454e+53', '-2.07076327391642e+12', '-6.7936440592151796515531889859599302465619955e+40', 3, 0);
    t('-1e+0', '1.40766974210848837512174406460979031888474180076364280389e+41', '-7.10393901414789748275425e-42', 65, 2);
    t('1.7579655365177340193424e+13', '1.2e+0', '14649712804314.4501611866666666666666666666666666666666666666666666666667', 58, 6);
    t('-5.14439925941092475978e+11', '5.17344285354751095733170689026326670354045626959509e-14', '-9.943860220439720235358395841971427324498245807154312225967e+24', 33, 1);
    t('-2.37593121448325e+6', '-5.046060106975311967927899320989374191943529e+36', '1e-15', 15, 0);
    t('3.02711053991410051857924824689543e+26', '-1.075056872845582e+13', '-28157678131963.403137625452169598982', 21, 5);
    t('1.7031e+1', '-1.1e+0', '-15.48272727272727272727272727272727272727272727272727272727272727272727272727272727272727272727272728', 98, 3);
    t('1.11316380861757648895194104293992512257677e+23', '8.793892933245547e+5', '126583734538003185.4758241204022051444374083708665989607584433419645145130072780879142188536521', 76, 6);
    t('-1.2445771504873016754168e+6', '-2.1271991905337074249602498312341407038514567859e+48', '0', 19, 1);
    t('-3.2126287105084394430000471990181426501347496904162318481486e+11', '-8.3179486349e+2', '386228486.31561215352847732683444136017055289575412', 41, 4);
    t('7.690902892945358830667793524605728734978227614373987e-14', '-1.4356798866863650458584021720666350506943e+41', '0', 26, 5);
    t('1.7895458349982693e+1', '-5.416619312e+7', '-3.303805809342558611769022914121309029516675031195e-7', 55, 6);
    t('-4.9323788e+7', '-2.50190605470094677463478e+7', '1.9714484445698213940290620650359219518342171516654875835474849479064879154999306', 79, 4);
    t('2.4736831834e-14', '-7.4969e+0', '-3.2996080825407835238565273646440528751884112099667862716589524e-15', 76, 0);
    t('1.6917100595076468e+6', '-1.46580165410522403243e+20', '-1.15411935494118749818764893135261277486721803740858622355453e-14', 73, 5);
    t('-5.847430247560464729871452390733940532932e+32', '2.3541096749220802874394138545934615951759723816573e-20', '-2.483924308987010725424240411422860427064539227981711351325205989e+52', 11, 2);
    t('3.17135563092456572471636397368039837592982433063e+8', '-1.05914712549883732501350758e+18', '-2.9942541074554868997473426603892327061035895442213978e-10', 62, 3);
    t('-2.06351590455020120049e+16', '6.876717e+2', '-30007282611022.108376569807947600577426699397401405350838197936602596849630426844670211090553820958', 84, 5);
    t('-2.58574038568472804398707132394333396261003537509e+34', '-5.21101118437e+1', '4.962070304973522088497308062328913175297198877790786260422926984000792e+32', 37, 6);
    t('1.0902927014420428768829601430368355906592671e+9', '1.055311509526061274313257267095679915243147902389364e-20', '1.0331477403593291618651997366870712877657798362117890624111285603482011526479e+29', 47, 3);
    t('5.240416698263987e-10', '-1.333644541451033895111125e+4', '-3.929395378893315244205009777387015604392422371871707395300212485273e-14', 80, 0);
    t('-2.14459463571407661232358156993163236e+3', '9.50710872243e+4', '-0.0225578006766069890476863268275831247472021132902642208034682013658062249109412597', 83, 0);
    t('-8.76570122913186285413266288e+26', '-2.29060139655641091149799231649e+22', '38268.1213864176952764740852047', 25, 3);
    t('-4.298685082322146249068382224749649229024974889e+28', '1.133736034155732441317831862744713483858036136e+45', '0', 3, 6);
    t('-9.03007143e-4', '-6.527e-20', '13834949333537612.992186303048873908380574', 24, 2);
    t('-2.1983602077137e+4', '7.618052445037037559598956806049795697231989369872038175438e+19', '-2.8857246961405133513202683415394692463335185692463717333667e-16', 74, 4);
    t('1.06464442348e+8', '3.3798404104228937656216886e+25', '0', 13, 5);
    t('-1.4834231106114591731402527448376685e-20', '-1.008042281392878891612406531524600516179351763e-2', '1.471588184338572638073105330851883960616731833612321362739486010713142111976394343e-18', 99, 2);
    t('2.670388961061965347980551054975608950852709569216285620955e-19', '-1.60813026578e+0', '-1.66055512907515135118e-19', 39, 1);
    t('4.8418752886050656347980335514333887020889131e+43', '1.097542967900589815280405934238056787462980720668271e+49', '0.0000044115587546123474461506361364672762222874748810055883596997210401117', 73, 1);
    t('3.3224789713227436115862e-2', '1.608e-20', '2066218265747974882.827238805970149253731343283582089552238805970149253731343283582089552', 69, 6);
    t('2.961317953735582624263692428362719343623646795e+19', '-1.3517568497144e+10', '-2190717919.6918822065726495016909794400572784395953745101039724415568485', 61, 3);
    t('0e+0', '1.1939703967465696474752689253333379e+6', '0', 30, 4);

    t('1.927406136495888507993987941e+24', '1.438030590252297923893913048795149e+29', '0.000013403095522173357874079534560468176113', 42, 2);
    t('3.24212326974135648418e-15', '7e+0', '4.6316047e-16', 23, 5);
    t('7.613303622309e+5', '1.078208490228870823391454915626976483e+36', '0', 12, 3);
    t('3.20416228054285510572085206278236105463442970534e+12', '1.6960413350263732023625025547364237937819838557e+46', '0', 25, 5);
    t('8.593191363445046350756152e+0', '-1.570433736289043766632234946600540541686553633176108561786998e+47', '-5.4718586113355372590242787449103e-47', 79, 5);
    t('-2.68758e+4', '-7.0953708292053258e+10', '3.787793569488469121295862362727346329e-7', 44, 6);
    t('-1.531318158077305e-5', '-1.1380617052691314216353652177811558465991399982531118517422e+28', '0', 0, 1);
    t('-3e+0', '1.14435432275196793315720126619108758e+33', '-2.62156566402050665387412562251e-33', 62, 5);
    t('-2.675005685229929746166160572513230700756e+20', '4.14436597781000061858591078142577363785533e+14', '-645455.9514175622782476040846544677', 28, 0);
    t('1.2943858e+5', '-1.8466054547987821437798758500362545e+25', '-7.0095417331096560421575374461008227452969325188527599e-21', 73, 1);
    t('2.828495065320869006176625593653816409328638936862545e-9', '1.19269986839413e+3', '2.4e-12', 13, 4);
    t('1.210243877847039612e+3', '-1.82081562734910535203427760801450474e+20', '-6.646712932758673573125313203777193186183734559614460847922e-18', 75, 3);
    t('5.8148830377197331282016541541289207399557003956e+7', '1.056229070997461188792e+9', '0.055053237951767283878863413034205894856371908333169733927057002882531331286728', 78, 0);
    t('-5e+0', '-1.96568535828529880853418483305657775840927511e+38', '2.54364208337064997575e-38', 58, 6);
    t('-3.2710975342156963031791144657528359522602e-9', '2.86112985684284809e+14', '0', 22, 4);
    t('3.8319e-20', '-2.520431557490889161632506613701323929471352731856219e+43', '0', 34, 2);
    t('-8.232343400551955e+2', '-5.20932026777726541853187791660407377644637694122e+32', '0', 3, 4);
    t('-5.3494773221010117237806889955664072547846163248739e+30', '-2.59387637572e+3', '2.062348603879057547215513523296281812201359604151882946e+27', 27, 2);
    t('4.210650286098887243291899736898e+20', '8.91e+2', '472575789685621464', 0, 5);
    t('1.7992317374233982019511957167830673053571616653993e-6', '-7.1959332e+4', '-2.5003452469839467130561964038e-11', 40, 1);
    t('-1.573715055172521211522215811309672084e+8', '7.55616231614213598442e+5', '-208.269090753994686855749971', 24, 6);
    t('-6.112373e+0', '8.470579632143570229306087964378037933636252233195e+16', '-7.2160032317094208461e-17', 36, 6);
    t('1.49502278e+3', '4.6797822e-4', '3194641.79337235', 9, 2);
    t('4.50192713240673e-10', '-1.83138737441661804498055171563795220495306455282233620356e+25', '-2.4582058363489608126459180746648559401468394e-35', 79, 1);
    t('3e+0', '1.23022804e+0', '2.4385722829078095147302934177959396861089266', 44, 1);
    t('6.52170109089127400063480207122874352e-8', '-5.0413201777893220182578778e+22', '0', 0, 2);
    t('-3.4931500754729915735520354536278025e+29', '-7.0803342052231544601687791639049399601321e+40', '4.9335949041729e-12', 25, 6);
    t('8.4219412111336339e-5', '-7.6558806514206402233358672597608123579466137963472512586e-1', '-0.00011000617165539070906639094386733', 35, 3);
    t('-4.56922805217674411421595300737838921234147e+20', '-1.932275643042776159425443488200888505533e+18', '236.46874961', 8, 1);
    t('5.801123356279104329877669712e+13', '-2.350209490371783634e+9', '-24683.4309028401326292537826872846360450510445427584138231002584049526379811646768', 76, 6);
    t('-2.0683221e-17', '-1.90516529542282269709801887794794869648767e+20', '0', 16, 5);
    t('6e+0', '1.46347633775982708214268078973949e+18', '4.09982713433161598924535233481218591703156500235191121565951808598073e-18', 86, 6);
    t('-1.104187257041818439239e-14', '4.40128334891945718931344238589210027216364e-9', '-0.00000250878475550296795217894008810765745975221390594190696', 59, 5);
    t('5.1877e+1', '1.3103003307286068834323560431766615e+7', '0.000003959168656482993073974772012210824283071061', 48, 2);
    t('8.941988246622787e+0', '-2.4623932e-10', '-36314217593.7733543123819542711537702427053486015149814416316614259656012695291718641848101', 79, 5);
    t('-5.2980207337333299991336e+22', '-6.6721054945920543383019e+12', '7940553005.38568809625317549680403879186371719782517992', 44, 5);
    t('1.97986576327700624189364e+12', '1.2738234105229773295825566509987595447e+37', '0', 7, 6);
    t('-2.36098639281821977630122e-7', '-3.44105053573270000838e+3', '6.86123719573765841605056520283802613476492e-11', 52, 3);
    t('1.9545095879018890682606501393047079e+25', '5.328035298266656e+11', '36683495481678.58865692194372424944324651254224135546474678950544604295', 56, 4);
    t('-1.336328832747700384e+17', '3.2e+1', '-4176027602336563.7', 82, 3);

    t('6.187367411590709211084e-3', '-1.9016490483589853410164513292944135e+5', '-3.253685224899964775762923531318992984544093576167679281165724876e-8', 71, 0);
    t('-2.698534206828656555645951400586392511e-20', '1.41566409819611657131347812519308548766678285194938434253806e+23', '-1.90619668201461996680522995e-43', 70, 6);
    t('3.64338680869165730432721264095799056297576253203915505e+12', '2.49734543640219665770981076900260707826855027946e+11', '14.58903824670929929825096', 23, 5);
    t('1.37750576475437616802e+20', '3.1186519496663986e+12', '44169910.172301452450746870217307380822060649144439661963399', 51, 5);
    t('-3.7953891171370774966517431e-8', '3.111810168415618559e+17', '-1.2196724452087975157365242667935153943383951245128650341171253148108e-25', 92, 2);
    t('1.758687497055576219230940728575659698853957728014345e+25', '2.55987906294351248373600134010276392866914703516483e+46', '0', 18, 4);
    t('4.983521732075865023238944583705028e+3', '-4.60355004431025072736834106351363219067932246888e+19', '-1.0825388415697e-16', 29, 5);
    t('1.36210873191087156571300625683992927337759078388519616116957e+2', '-4.856011861229238531e+5', '-0.000280499465577102362081282866149858', 38, 2);
    t('-6.27292639398799941804769052811144481813654523344e+23', '-9.223861100927221622570481401681e+12', '68007598177.7025920604', 10, 3);
    t('1.451185082463737847802616854453333e+16', '2.67423846293035097281847174648822449142303424568339e+7', '542653582.53563236627592952195668145679814392738365254624328253671248', 59, 0);
    t('-1.30217e+4', '3.34207562054215771861e-2', '-389629.1250850749937369356768877727892124143497377121', 46, 2);
    t('6.0774200897757313464657364607565620534e+2', '1e+0', '607.74200897757313464657364607565620534', 63, 5);
    t('-1.4977805511498677e-5', '2.562493654824974661853706878407e+26', '0', 4, 5);
    t('2.37738940731e+11', '2.1197520687627033e+16', '0.00001121541260577', 17, 5);
    t('3.195e+1', '6.3559613761446696e+14', '5.026776927864197611599309013360652084107428630046636070537160730904010007615944523607e-14', 98, 4);
    t('2.322e+2', '-5.398093488026379244431502845e-13', '-430151868460684.3768540542081462239159342450111793279240742283', 47, 6);
    t('-6.5565196e+7', '2.711104726376443e+7', '-2.41839407242788026484854848409113719460326005903320644117285296918683756878243', 77, 1);
    t('1.0645627403778739844e-13', '1.3523634769128119105942e+13', '7.87186846252361e-27', 41, 6);
    t('1.043904773373277442180173714797789481695e+24', '-3e+0', '-3.47968257791092480726724571599263160565e+23', 85, 6);
    t('-3.8784966818454064082276654510557840673048257e+11', '1.27615024340009655855691378584236771e+21', '-3.03921634768628603145473809535079982052e-10', 48, 5);
    t('1e+0', '7.8059434837451907016038344313692e+32', '0', 27, 1);
    t('4.090963382185467544867391401161e+3', '-4.947353627083592126859423580421306070697601e+42', '0', 30, 6);
    t('-2.252526e+6', '-2.2751905784830644458152204427279971293971386564923526505e+55', '9.90038e-50', 55, 1);
    t('3.337179e+3', '-1.124109298808773078000919303240413683125e+18', '-2.9687317803850864155193603510953192628283148654325926932202383719798270184788317e-15', 94, 5);
    t('-4.350832932450342098804623837197850016325667240511e-4', '-1.661298881760292928966647592693722368086242162075596e+39', '2.6189344856719883193139326952496e-43', 74, 2);
    t('3.83705e+0', '3.570563711367172540823838290282453562478e+23', '1e-13', 13, 2);
    t('1.6901977568389407896942317215665594164649791131e-1', '2.22007914080350807009448350735886427080696147e+31', '0', 3, 5);
    t('2.840481e+6', '1.3327e+1', '213137.3152247317475801005477601860883919861934418848953252795', 55, 3);
    t('1.8244693340188831428316255121e+19', '1.00024476176549778435583070853827e+3', '18240228829577420.4741187267696143148954146464874986680767286208183813649772543', 61, 4);
    t('1.345966506e+1', '1.6817041820786075207825e+1', '0.800358660187410885552441495604885001196139987870917888069245179641377499257626555', 81, 6);

    // Rounding mode 7
    t('1.9640', '2.444', '0.80360065466448445171849427168576104746317512274959083469721767594', 65, 7);
    t('3607247394853566951317.77076581', '15782819408764618683425.244', '0.2285553234455921540387285974114769405274281136836665305041152998320784526374246178556985', 88, 7);
    t('1', '0.0000000000000194052811234', '51532363465435.329092388839409191', 18, 7);
    t('660716722326173271523', '479.97194389', '1376573632557148738.4776939404452905552516668788409085775073968563583659260705043457035', 68, 7);
    t('0.0000000000015', '5360559278853.1138548', '2.7982154882930862e-25', 41, 7);
    t('707502522397750932', '1', '707502522397750932', 74, 7);
    t('43125000853', '0.0000001802317770188696', '239275235290417027.96', 2, 7);
    t('0.4241762859699751144', '6', '0.070696047661662519066666666666666666666666666666666666666666666666666666666666666666666666666666667', 99, 7);
    t('33139607696828445002688', '0.000000001792296820835179632717882', '1.8490022027370419145710042278124111872435976327485643069e+31', 24, 7);
    t('173121.73744340768266', '0.00000000982290101590940367574518', '17624298276345.817480994098505871724687735852356624739604466130187169643522698514888693800981', 78, 7);
    t('72500577491.827058757', '1384314218.9', '52.372919747539160927851392742780993766761344937594789303944496239', 64, 7);
    t('0.00000000000016005742', '0.0001072510743316228614932735787327', '1.4923619273509435184608337879188270656177343392e-9', 55, 7);
    t('64.9247864841747039291', '4.942', '13.137350563370033170598947794415216511533791987049777418049', 57, 7);
    t('35996.281', '0.00000000000000074542201143965294641517170', '48289801545408412240.6700434620478582483162398124101957', 35, 7);
    t('7.28147866409558076', '0.03910511255889906305327760', '186.202728687416881931933868388966882657804173481008718667916', 57, 7);
    t('0.000000000000000823756117121327881', '0.000023106510', '3.5650391042235624549e-11', 30, 7);
    t('62583.79738', '178959437.41591752', '0.0003497093994241261156338351568369208', 37, 7);
    t('0.000000000443086974862808087088', '2487.74798091496736961', '1.7810766133145262917354356670998647e-13', 47, 7);
    t('2815926609336708.7', '0.00000000000000001001094905', '2.81284680930097102032499106565725654152640004e+32', 12, 7);
    t('0.000739794640371', '137321505041027011039861873710', '5.387318178241451967964081027204864758e-33', 69, 7);
    t('0.000000000000000000061851613', '24.062', '0', 1, 7);
    t('0.0771696832062', '2.1', '0.0367474681934285714285714285714285714285714285714285714285714285714285714', 73, 7);
    t('2529', '0.08465350119477616', '29874.7241910422103039742193188143373076032334005926511491689125172187743129512536', 76, 7);
    t('5', '0.126482574333741460', '39.531137204772734573055325355697133859836053208427591310576043239956817198183217645', 81, 7);
    t('0.00000000000009378684189488673074114501086', '7', '1.3398120270698104e-14', 30, 7);
    t('0.0000187', '4465054263059521', '4.1880790015721968729e-21', 40, 7);
    t('3.1864657', '0.0000000000182219', '174870112337.35230683957216316629989188833217172742688742666791059110191582656034771346566494163616307849346116', 98, 7);
    t('39819077.7207634188', '3393.28', '11734.68671042867632497170878913617502829121086382497170878913617502829121086382497170878913617502829', 95, 7);
    t('0.00000000000000000493115050264682953202876', '53.5909308156704932657', '0', 11, 7);
    t('0.0000000000000310741', '0.00000000008984416638925743537', '0.000345866640526985787017354106989915167446365', 45, 7);
    t('0', '69563752623', '0', 29, 7);
    t('63.43260001676', '1086125180.7184756659', '5.840266034049510731491489501810883327466513892469824400126826926582081431415e-8', 83, 7);
    t('6523672727931649502', '0.000000000000000000434', '1.503150398140933064976958525345622119815668202764976958525345622119815668202764977e+37', 45, 7);
    t('12870616112352300332.7', '252600421736629380772963.0', '0', 2, 7);
    t('574191.68966', '0.000000000000034439', '16672716677603879322.8607102412962048839977931995702546531548535091030517727', 55, 7);
    t('12.1', '0.00000000000309613994708762118732362135', '3908092078131.62469168712555874225899954380960302', 35, 7);
    t('5.7302793', '50878587876729840772.76', '1.1262653975152556294179452325870732792984423847779921331877432894905264370203e-19', 95, 7);
    t('5573.086', '26150952594220522.98', '2.131122e-13', 19, 7);
    t('168186325277194054376873', '1.61', '1.044635560727913381222813664596273291925465839e+23', 22, 7);
    t('58236248756795.9900527', '252537967.550469224', '230603.9338229709497', 13, 7);
    t('0.00000000000000000001138047224833670', '566502039.976811672976', '0', 22, 7);
    t('715846101.8231243141900849', '2658.45445', '269271.531743989186720910301848504494782673443962901075848788757693403398354258054', 75, 7);
    t('559654492614629609571232', '0.0000000000000035492549047527', '1.5768224814318441564203219886464439859081537559261572461898277455455807566104982592423229234110550476113391222528392e+38', 77, 7);
    t('0.0000000000000000217172631', '43728.1', '4.96643190534233136129857002705354223028e-22', 60, 7);
    t('10918850.97505', '0.000000000000000009353517255427747', '1.167352416943894172108361615414923895822878e+24', 18, 7);
    t('1', '0.000000000024506088608155668091726061802', '40806185596.96214818148515993262878438760674256131327543011945572368751014760958644113863312', 80, 7);
    t('227794877.826863756631939', '240432470695110862966.411', '9.47438077595298409185055810628228404579316683619935327287797e-13', 72, 7);
    t('31611287495276783548533221067', '2073240039945.869561', '15247287765145673.1121303', 7, 7);
    t('0.0000000000000014148163739447713375129068', '28.413089850789', '0', 14, 7);
    t('29425898489.4727866910401', '0.00000000000160393107113352382657806', '1.83461116372519874093803481296646218449925093785900540751563279136392e+22', 46, 7);
    t('3737757585710940', '195050171601038626200196.154915', '1.9163057151040397991462588170012e-8', 39, 7);
    t('17.4433702063910', '0.0000000000000000031', '5626893614964838709.677', 3, 7);
    t('38750870710122252693', '17644957716082679631219376', '0.000002', 6, 7);
    t('524474068.7', '0.000002789', '188050938938687.7016851918250268913589100035855145213338114', 44, 7);
    t('0.00000464240477182', '3128190452409.2', '1.484054389413731560053972393e-18', 45, 7);
    t('2', '3418684.78663', '0', 4, 7);
    t('2.2467656', '7', '0.3209665142857142857142857142857142857142857142857142857142857142857142857', 73, 7);
    t('120346443.16', '10795.972253', '11147.3464677123', 10, 7);
    t('30.665927794529695749918529609', '13710005334545760885', '2.23675535101793726041875619585950659615902979082071524893692077e-18', 80, 7);
    t('6633593816637931424587', '444197881205229005', '14933.8709105032132218253006505943896289155435162360528575521807293744', 64, 7);
    t('1571.549', '1237.453980', '1.26998581393709687692789997733895526361311634', 44, 7);
    t('0.000000000000000015794505075839547404564047992', '6.1', '2.589263127186811049928532457704918032787e-18', 57, 7);
    t('76559.94', '111629.7005405322970563974', '0.6858384428989970505', 19, 7);
    t('244551812.15724', '56006595.2223526197705987', '4.3664823970523685618310184966997289543047553093959901', 52, 7);
    t('0.0000000000000000008642890306628732071', '0.0000000000000000065072462188738', '0.1328194756417952939496716723354783765019753', 43, 7);
    t('0.00000000000000000002071098103220294112', '0.00000000000000000169909', '0.0121894549624816467167719190860990294804866134224790917491127603599573889552643', 79, 7);
    t('0.0000000000000000150048564643898532465014623', '0.00000000000000062620106822249151915', '0.0239617228807705788219886937261993269368455270569958890204360942043911812763', 76, 7);
    t('6', '482332800801.1376014798687', '1.24395437963875019892040028789683014676578136731092388876046146e-11', 74, 7);
    t('1030107435.88667', '22.98709', '44812433.23477090836639174', 17, 7);
    t('20.38421819966', '1388.8', '0.0146775764686491935483870967741935483870967741935483870968', 58, 7);
    t('0.000000290', '0.01226', '0.0000236541598694942903752039151712887438825448613376835236541598694942903752039151712887438825449', 97, 7);
    t('9011546386.3', '600935335126742567574145813', '1.4995867041833020699502671609097127059674764e-17', 60, 7);
    t('675890990.187954036', '168219.67', '4017.907003312716259638364526574092079', 33, 7);
    t('111440801838835', '72724921.52233375857078', '1532360.56507275334901916822250664379203332142633090814283424789804076617073030238973326672111201', 89, 7);
    t('313.58', '2414861916168.724704150652', '1.2985421563875886056403211877459005314470820608369116293430403688704059998594562355e-10', 92, 7);
    t('81465775764.6721077', '21935100139.4945706812436', '3.71394592441323793557453488321185928621238370485979200381224', 59, 7);
    t('11792938.18701', '66040043', '0.1786', 4, 7);
    t('2', '8337344.083', '2.398845e-7', 13, 7);
    t('283001531705038626', '0.0000000000000000364782', '7.758100227123011168314226030889682056680428310607431287728012895373126963501488560290803823e+33', 57, 7);
    t('90550804574.460682467', '552.9449449953936', '163760977.3', 1, 7);
    t('5507.2276', '105395.8', '0.05225281842350454192671814246867522235231384931847379117573945072', 65, 7);
    t('2.60', '0.277947421041438305408673', '9.3542871894910447489326863886756667775526560092606691887434241614357773209297510953944', 85, 7);
    t('1.627811963945396061', '1.1', '1.47982905813218', 14, 7);
    t('16191893456602475', '0.051415', '314925478101769425.265000486239424292521637654381', 31, 7);
    t('0.00000000000000000016175855761', '0.000000060', '2.695975960166666666666666666666666667e-12', 48, 7);
    t('0.0000000018311297116910805120217377', '2.3', '7.9614335290916544000945e-10', 32, 7);
    t('664.1450778', '2815689593.9115356966', '2.35872973795159871701992471952059263967036190631445213618529e-7', 66, 7);
    t('47797327162.2', '87470295196300621.499466523701', '5.46440675145011867816909510499127013339953114016677191490819e-7', 69, 7);
    t('83837224395420149', '5.4', '15525411925077805.3704', 4, 7);
    t('552.696169530231988140', '3279501', '0.000168530568989072419291837386236503663209738310797892728192490259951132809534133394074281422692', 97, 7);
    t('0.00000000000000997268', '0.00000000000000000012240324757473093665387564404', '81473.98208459602353194963615251083215979921534755534180942844561629851421128799181515050003304', 89, 7);
    t('975027858433.3925', '0.000000000000013521480722321248062', '7.210954764915778782160596306991516802579265488282443328731892e+25', 35, 7);
    t('15061.884981243', '68354258636780906782812232', '2.203503524378554846533499723090610604e-22', 58, 7);
    t('0.000000000000000000036671006543330', '2447454417984.5014868313', '1.4983325643927158634340427366961e-32', 63, 7);
    t('178402158272272733747.98326', '0.0000000000000000125814945508250840107533', '1.417972702301677408463731595182742641977077119785296004418407146971519328221279829833e+37', 47, 7);
    t('42247173', '0.00000000000000000504442268', '8.3750263766556532887525594901179058214844121666664142426700848946305982432066933772488708261854060176e+24', 76, 7);
    t('765659229728755695156.9082', '0.0000000002856', '2.68087965591301013710402030812324929971988795518207282913165266106442577030812324929972e+30', 57, 7);
    t('7', '643470.0303827', '0.00001087851752137825493530528816743596623812029865737703697532239061630286202', 77, 7);
    t('397.4', '983057.9893', '0', 0, 7);
    t('5103.92', '0.00018068326073165321903680074', '28247885.16286646527', 11, 7);
    t('19.61', '373318.166171813', '0.00005252892', 12, 7);
    t('0.000000000000000001662577895090753263', '2228416234059060691616130', '7.460804986e-43', 52, 7);
    t('54297525.059590468063632576129', '0.00000050686352239646624582390441', '107124546668637.95578', 5, 7);
    t('696047.2912663272603657890', '154', '4519.78760562550169068694155844155844155844155844155844155844155844155844156', 71, 7);
    t('982690266962.637009', '0.000000000871679040793538843583', '1.1273533272843618602522783702763994066094122611943721708491657217737e+21', 46, 7);
    t('11', '5233148807229.55195904', '0', 9, 7);
    t('364238.538076974338426991545', '0.000000002247870914170050579975634', '162037124009612.87206351260573', 14, 7);
    t('204187.458192293', '700873.253124745303', '0.29133292971582493162814663011415070407599267571475859793180279506135196600778935', 80, 7);
    t('9757567873.2439599', '3.62394191', '2692528775.452683760044045518378632068084115619833432', 42, 7);
    t('566814769534522178180', '3.587855605105755455', '157981488644054496158.261832756780430094168', 21, 7);
    t('0.00000001479126040527474770', '29128.1319', '5.0779982925285873550991e-13', 35, 7);
    t('496', '48738201953', '0', 2, 7);
    t('6316787574385342587.5140', '27395538971708885508405597', '2.3057723306369805e-7', 23, 7);
    t('849919316761557510', '2.6', '326892044908291350', 40, 7);
    t('7.089610589881496', '57235949.3794', '0', 3, 7);
    t('240375088183.198416', '16.31', '14737896271.1954884120171673819742489270386266094420600858369098712446351931330472103', 74, 7);
    t('419.98071', '73751832.2', '0.00000569451222392818059372903280903169209673', 44, 7);
    t('235771.666012878', '552438.5', '0.4267835533057127625971035689945577652535078565306364418844812589998705738286', 76, 7);
    t('0.00000000000000000380753434486683321337165292', '2.0', '1.90376717e-18', 26, 7);
    t('11.5932', '0.0000000000000000262287535', '442003467682899989.890865381765092267918870029412568157308733714699785485422', 57, 7);
    t('10779351792796719162.3617', '1415090585486344', '7617.4288086949771952766896621959742901751841418823659573004', 55, 7);
    t('0.027598', '1.4', '0.0197128571428571428571428571428571429', 37, 7);
    t('0.00000000216460367495974647080', '3.3', '6.559405075635595366061e-10', 31, 7);
    t('11506516140.64410', '2', '5753258070.32205', 99, 7);
    t('85.52', '100993785025857123074524', '8.46784779658516429845025154337022e-22', 54, 7);
    t('6', '814288396.736913', '7.3683967793765940195459398039541052986450373e-9', 52, 7);
    t('4.4759', '0.0000000000000000281635009877150383490293935', '158925554104668817.1877179147909227857905', 22, 7);
    t('9844006.4346460', '279.163961', '35262.45436331948306178389552224472126615225953', 41, 7);
    t('0.00000053552527520459569140536870931', '35565565.400671653136477197', '1.50574092994591430064e-14', 35, 7);
    t('4333.7690', '0.000000016396479178639435474', '264310950709.8225768837965320956179316644683592293115566421757871173160024351', 64, 7);
    t('1349.2', '38.2013647053751026', '35.31810997867732026930769809015256179566815137', 44, 7);
    t('280835487062136497723.25201', '42329.881831', '6634450060204716.797884037305901356037262971115710696253656168161959261293738431839753179111585694235055564902', 93, 7);
    t('4204.803128135912', '647533787.553192160', '0.00000649356560068381793837735493734519852', 41, 7);
    t('4108.034', '41502.0203238', '0.098983952297960346169185015823757298470469311018163383187582111036063122867821', 78, 7);
    t('7117.131844542984516505045', '3', '2372.3772815143282', 13, 7);
    t('853147827.593', '2958', '288420.49614367816091954022988505747126437', 35, 7);
    t('409537.9932941849932417', '0.000000000008097424', '50576330607633365.035806449063307046784261266299010648324701781702427833839502538091126264352712665163637225863435', 96, 7);
    t('64548404726726447985505252', '5169956070701948.577270377', '12485290753.730218041121059766763942628372064639331888', 42, 7);
    t('23978.3767956833276762', '1941213317', '0.000012352262672883429264152322936078436', 39, 7);
    t('0', '1', '0', 66, 7);
    t('0.00000000000000134872', '3649502.8219702176842945945', '3.69562668065531484072725465054914173730388168818847787068078e-22', 81, 7);
    t('1', '383972970.8', '2.60435e-9', 14, 7);
    t('64227380.914', '89.343838182', '718878.68509929111520739703427844391194973298578407384499531529203897214320373241562469', 80, 7);
    t('1803264827', '12772665.85770752', '141.181554977564870796280888146795849121098557274333646474978278173712297', 69, 7);
    t('11.8685', '3.17951331950', '3.732803988336932645455458046', 27, 7);
    t('145236800.848226297', '328.64868256807', '441921.14118134255694083304943429217710315248716869087', 47, 7);
    t('14955841523.44', '0.00000000000000475', '3.1485982154610526315789473684210526315789473684210526315789473684210526315789473684210526315789473684210526315789474e+24', 91, 7);
    t('0.0000000001055969764713269265345397', '3778.15', '2.7949386993986e-14', 27, 7);

    // Rounding mode 8
    t('98.279720', '2.53957847', '38.6992255450960725777455500321673462604209272572703768432876972689093556538', 73, 8);
    t('567760561.7785308681773297', '25.70527530', '22087316.9', 1, 8);
    t('0.0012191112606041703889162', '0.000032', '38.09722689388032465363125', 28, 8);
    t('129657255941820913688848', '33081581802.919547384', '3919318511256.26277', 6, 8);
    t('0.0217584130', '20.190198000585', '0.001077672096101759964106368368502268997284037166777108290738', 60, 8);
    t('646.5843279', '269072952197356.049', '2.4030075212678825104846927800254704083201459834859925333e-12', 67, 8);
    t('7864078301796658569643944.23236', '10837904158.13', '725608769652890.8010656231924413617780013056071223314347263', 43, 8);
    t('78679420542045375.9975', '0.0782661303193792336016', '1005280575658712602.61680378079930506136624703481529194064192962117609952681462485873187679145246510441123971833116', 95, 8);
    t('7.514', '256.60', '0.02928293063133281', 17, 8);
    t('0.0000605257696842294792', '8033035003.233', '7.53460798563e-15', 26, 8);
    t('13837937692767479166.65', '275610217.5', '50208362441.3070940182034434191468246274287708509935775512386437560138713', 61, 8);
    t('2.2565965', '100585389373.34587', '2.243463503058204274951773207641628982021885698427e-11', 59, 8);
    t('6133264803063744580897553177', '9995746.796702745151086720621', '613587451523571883660.1575705543668700897162744310354121480887959030268229442699890503634942309767', 76, 8);
    t('559642614623878559406', '0.1484896293938559908', '3.7689003394269008645348669826984575696063765927445382806274759040238226477e+21', 52, 8);
    t('7', '5.583', '1.2538061973849185026', 20, 8);
    t('0.000019392833638', '912499614.60', '2.12524294013000452175752623052121560863177596349200693678846404194415535920819226174e-14', 98, 8);
    t('1856578117288670194.164370', '885051.284694629512509739', '2097706821508.3693696462196233117313417739235657909916514451444495705075128837', 64, 8);
    t('6.7', '9723.09', '0.0006890813517102073518', 22, 8);
    t('2714014896637441245', '34614182791153137', '78.4075970538614742132440602741198612612885622756238264830395543075257221019743367280142', 85, 8);
    t('0.00020170', '8', '0.0000252125', 17, 8);
    t('102538367478655695.075405188', '0.00013596981288', '754125973308140181617.974349896009064802649156958963375459489710816464573', 51, 8);
    t('1128723265306.844245', '26132204626636641662.6', '4.3192806785093551895102839159321771479520060953807911856977757e-8', 69, 8);
    t('113223838307388069631593537.840', '9304003647533688952924', '12169.36736019031062911900307415852967418356356710503674260874013723509386108779872158719419219', 89, 8);
    t('12160.3647741798522812607676988', '60689168.916732881', '0.00020037125225531081480095322605', 33, 8);
    t('42884.218', '5329.5', '8.0465743503142883947837508209025236889013978797260531006661', 59, 8);
    t('60357614629933.010037051378', '574812381.00740122422567785922', '105004.026747217631156932482582114856103973819981158519761390819080955050829400336586', 78, 8);
    t('0.000150194537', '0.021', '0.0071521208095238095238095238095238095238095238095238095238095238095238095238095238', 82, 8);
    t('8804964.1459992689585824461', '40378291.606', '0.218061829656282386663549474688986176717443957923552571809617735', 63, 8);
    t('0.63909253839264108', '294.940692616505391', '0.002166851012395284369118179744', 30, 8);
    t('1023243.070', '9.51441130417414270754', '107546.650789743021923557496742565683663', 33, 8);
    t('7', '2117.74441844', '0.003305403588388', 15, 8);
    t('41488521062.77986', '0.00002008707', '2065434185412798.38224290551085847761769138057466818206936103672661070032', 56, 8);
    t('844263691.81902410775', '849374349595.80775419530', '0.000993983032594266994271775568537851134160059362982128423015854142015009634155367884379090417', 93, 8);
    t('13349918933820', '4.8', '2781233111212.5', 75, 8);
    t('103760735.6946522860573', '0.0004066794', '255141361216.359338725541545', 15, 8);
    t('68917515178552754.0', '0.14', '492267965561091100', 99, 8);
    t('1031321877143445764011877', '33533.28411855', '30755170698384932347.16716890130212497978525108505503021614960729391920145088917232195595937553032431988707255', 89, 8);
    t('0.02960', '1016451.52', '0', 2, 8);
    t('17245127707901932.49', '15580355401258735553027686444', '1.1068507273273560966150042669129924380128661863167389006956883625215153093650921e-12', 91, 8);
    t('1', '209.18012626629520667', '0.0047805688707107740463542216', 29, 8);
    t('7.79', '153378108750701532.05407442', '5.079e-17', 21, 8);
    t('0.004200', '1635366313', '2.56823194082755940931504316733470588494383398736427316881e-12', 68, 8);
    t('0.0228701', '5645801207898376084612044', '4.050815669528912e-27', 42, 8);
    t('0.0033960799', '6.75182164', '0.00050298720568690851851353111276796109205278118099103103677365505762975', 71, 8);
    t('7.08285516742655064343921', '41358.75514', '0.000171254070473131524', 21, 8);
    t('0.261974324049215172124', '1038017550335', '2.523794746675218045305497922287208145983452082381019041925022001e-13', 76, 8);
    t('112905012578123386.8', '290487062922.09', '388674.8395690345891611134670102067513236044112423072681893863179188640425926943863878606519681', 89, 8);
    t('1.5087535', '187.4054956619681', '0.0080507430941161297879756641335428652573953779583996227223557', 61, 8);
    t('588.42740761976096', '9.5', '61.9397271178695747368421052631578947368421052631578947368421052631579', 67, 8);
    t('68296130005806947526.81816792', '0.039530792374', '1.727669138520136144003571951269382364645034069207549854209254257434025e+21', 48, 8);
    t('566421798102744783494667', '5195.650', '109018467006581425518.398467949149769518732016205864521282226477919', 46, 8);
    t('11359422564.37423411195876', '0.00006551526', '173385903747832.70511265253316555562780335452', 29, 8);
    t('5.80', '407750993888797', '0', 10, 8);
    t('7687825.6738488', '1057505129', '0.00726977625263962194929458351591597812477370972637618', 53, 8);
    t('0.00078563973970489', '202107544290040667654103220.376', '3.887236087423997640951095666504554463e-30', 66, 8);
    t('7.957', '9332.9282488444250412050295', '0.00085257271756966648521864328811305903793546656282144671796441534561142844065', 77, 8);
    t('1363993.640215242473', '11322181003651970211710339', '0', 9, 8);
    t('70051191.07525111147', '180874508835.433332', '0.00038729167269770674', 20, 8);
    t('19.967022398', '911742389938', '0', 7, 8);
    t('811691978843777618265931961', '1.39233479313', '5.829718418650414913702990162380156278182283191594640546408220604573322130150537811835339292897642824273878813315265443e+26', 91, 8);
    t('785907', '7600844.0115014771025450', '0.10339733308705953458', 20, 8);
    t('5417495622857086103130303', '42514587331142358.59392', '127426748.3925150700035933258199706194577051286199226663494412517', 55, 8);
    t('3580181223966485629383762', '86567.2', '41357248749716816870.40544224602389819700764261752719275', 35, 8);
    t('0.0000943', '0.001990995881', '0.047363232088976883222391759433278305210115098', 45, 8);
    t('8.91022368966896404786448', '0.03976933558288092342', '224.0475873955624205613672819256304872438280858760387773354384', 58, 8);
    t('381700.72', '2.2105', '172676.19090703460755485184347432707532232526577697353539923094323', 59, 8);
    t('0.166', '3418904.547797444446176113', '4.855356377437969759910445352291295989815e-8', 47, 8);
    t('65903.58933744566987', '56.2615595533', '1171.3786439746873377398855234090000936127676128572206789737162868850253237119769182038338319', 88, 8);
    t('1364.6', '1', '1364.6', 81, 8);
    t('1', '5897.1660228538858402716968', '0.0001695729772783398899888240918068539485885533810472934733226537712262559577239337', 82, 8);
    t('1569245.6135066', '7114895275448.255083650', '0', 1, 8);
    t('0.00009130', '44.7', '0.0000020425055928411633109619686800894854586129753914988814317673378076062639821029082774049217', 96, 8);
    t('147753814958.677594', '1306.6440741771799803', '113078854.355744229099762226676784700240199575836518150301745721', 54, 8);
    t('921277167355764.87', '0.006283411187', '146620544149940711.17758921225920400679326097396147', 32, 8);
    t('68535077.68961895546', '0.00020476107110133807', '334707556084.72246032', 8, 8);
    t('1872307.169908427', '633.45', '2955.730002223422527429157786723498302944194490488594206', 51, 8);
    t('9107.60078475', '36542593.211876613610568939', '0', 2, 8);
    t('3.72394', '0.0193816788', '192.1371228172453255184478653108212690017337404229400396419736354314157760163', 73, 8);
    t('1.07', '0.55756802460172206', '1.9190483542601185304611221787', 28, 8);
    t('6.17', '389593.210', '0', 1, 8);
    t('38780128.7122', '3549568036202326830.2', '1.0925309309943740094679096249984072870308e-11', 51, 8);
    t('2', '22.81806926', '0.1', 1, 8);
    t('0.0000100', '1139564681325', '0', 0, 8);
    t('46.50319', '3416231842748933380.74230902081', '0', 2, 8);
    t('1', '7379791076831238.56', '1.355051910804748180507625617404703505832609199543246e-16', 68, 8);
    t('0.000022443054742391293104475', '0.008064051238131175', '0.002783099223907265067377410989707648496147253672561285876033737240647636187236', 78, 8);
    t('625145862686.997263120154', '2107779905203297.038208159865', '0.0002965897251149196483307959749934321300112818055438759362685105274', 67, 8);
    t('184386.9682167', '84432536994766383635239875.1', '0', 19, 8);
    t('3.5448928900685867111376203095', '163550.93004066', '0.00002167455048520543104468539239259044', 38, 8);
    t('318867142782283.0363615', '676591310394863109686.52422', '4.71284714839435475918651247413746523e-7', 42, 8);
    t('428.1', '777.391', '0.55068813505687614083517817932031628871443070475475018362702938418376338290512753556447141786', 92, 8);
    t('0.6926940356', '0.00039099680', '1771.6104980910329700908038122051126761139733112905271859002426618325265066107957916791134863507834', 94, 8);
    t('0.002130211805', '140.19660134762083', '0.000015194461096229350255974061693960641852324192167557092840177376', 66, 8);
    t('49981882492075177635482718', '145796595747510229984200694096', '0.0003428192697903148316427330346057289022069783388696851477455', 61, 8);
    t('152.8586609630441', '107410163', '0.000001423130332304254114203327295946846296099559964358307509504477709432393', 75, 8);
    t('2.933829723', '1491.3817233720637', '0.001967189001328589019839007543945424526885', 42, 8);
    t('156217760732890.34181906', '0.062726236685805602', '2490469203746142.36826638502513312167296', 23, 8);
    t('0.0000547574887966090149', '24563584.6437', '2.229214082e-12', 21, 8);
    t('27591022.7711878347573089269', '935.18100071', '29503.403886777445219371373877619759754411146691782752054238', 54, 8);
    t('11.076', '456170163920614807291064343', '2.42804130476352356723599286207859050694e-26', 64, 8);
    t('1', '912586039339459022586.3891', '1.0957870895371271241e-21', 40, 8);
    t('30521310.73994', '13399401100577405739962147', '2.27781156119169971932669239543326815443551088771527744274e-18', 74, 8);
    t('0.003060360361', '40814243495.1557', '7.498e-14', 17, 8);
    t('393562142372.6699944163', '2709111978097.9730553380', '0.1452734864983263187522827746799', 31, 8);
    t('159837823.83396', '14505.28645341', '11019.28075307911293485694830191635452262752322811523282893369238174101063535102774433337684219419086', 95, 8);
    t('277723.92715223712984194709', '909319009144881.8606790641124', '3.054196869956639796826219565e-10', 37, 8);
    t('5154325576234', '238231.85', '21635753.473912073469605344541462445092879058782442398025285032207070549131025091733116289866363377', 90, 8);
    t('24812964145333591', '1878494699477.89929200135933136', '13208.96149040505631773529079144196060102935838240800320787494878988367434179429', 74, 8);
    t('5.4', '2417740018257723686.948179', '2.2334907637800353956807877701697903215360962459590518620256780423842788e-18', 88, 8);
    t('3716641856955803178.210', '3562351870.3701495053437060', '1043311270.8121171722993', 13, 8);
    t('922353440.1222198038485563827', '1171478560221579954809', '0', 7, 8);
    t('1616227508.5386179952261148005', '125752725147536.893701', '0.000012852425318357205', 21, 8);
    t('0.00002995', '269908512252198465961060', '1.109635251963271509119907392064404912967049003603986598448525389918281476e-28', 100, 8);
    t('0.26', '6792618697591', '3.8276843081477385884074285311309311873334525946946333526154459025428012291e-14', 87, 8);
    t('1084.902723556411673448636981', '13.27757', '81.7094335451751844237038088294770805200047900331159993884423129', 61, 8);
    t('207389914022.22221', '1053192.0136883', '196915.577906766007469497356564880225194', 33, 8);
    t('131.669219908878655', '0.0005307509', '248081.01108990800580837451241250839141299619086844694940696285206487638551', 68, 8);
    t('2', '53569022282027512', '0', 9, 8);
    t('0.03738172891910893041812276477', '52', '0.0007188794022905563541946685532692307692307692307692307692307692307692307692307692307692307692', 94, 8);
    t('412264171442951057.7361095', '50867725637.06220391', '8104631.498259390479455821393714832842253133346477938618046134121269', 60, 8);
    t('0.000014599', '0.000244239824', '0.0597732170000253521309448699897523673289250323076', 49, 8);
    t('2985804868.615', '482745099093247954326254', '6.18505475088884599340849357229221901935477717691061428e-15', 68, 8);
    t('1116399', '84553466081700776.9557', '1.3203468192791368128410881062598342805009693925396921044310838e-11', 72, 8);
    t('56.47', '517123748551.41', '1.09200168e-10', 18, 8);
    t('91890006292.8931376', '1571814055.6', '58.461117563817984221873629617643177410965506065169201175579562618589933927551016614029062', 87, 8);
    t('22630058916.8929', '158399.84399', '142866.67427729011363655699772258342613788075612864118452847978717254796', 66, 8);
    t('0.00257381701', '2728.0', '9.4348130865102639296187683284457478005865103e-7', 50, 8);
    t('2613.2484185', '2009900023138286.18110', '1.30018826230950390436120395966100721290467931993643111597e-12', 69, 8);
    t('0.0000561357186557576060078609217', '34430.01836170882655364741890', '1.6304295300111912206696516226345647077432147176729656846977674487871225e-9', 79, 8);
    t('19341833369042334971814.3', '792', '24421506779093857287.644318181818181818181818181818181818181818181818182', 51, 8);
    t('8', '5878749.616759672569203', '0.0000013608335992390072977', 25, 8);
    t('0.0013157737110166924023882', '0.00002450730617641171810659288', '53.689038752171162045564690319695207836437329411996357070555570567750137', 69, 8);
    t('19810.5', '2877531874906.917236', '6.88454580564492706183282039699170937193096e-9', 50, 8);
    t('2445412586541380912833.924775', '0.012371088804317191', '1.976715732319369476938170286069551427398460449463285166e+23', 31, 8);
    t('13488954.69149290270474', '0.0002040', '66122326919.082856395784314', 15, 8);
    t('141.84130518408', '0.260237160284', '545.0463147895052597399253290108960863272', 38, 8);
    t('10641673.3330931452141539307931', '26227452783350405180887260', '0', 17, 8);
    t('255357.87552', '294742078902132776442', '8.663773984059804047707640588294408274426684397902483873876159418581450563171e-16', 91, 8);
    t('211.47519696522740215766', '173739178.714', '0.00000121719924389274560754650074499488231764083760776421969750741617978476246522634980941596394612', 98, 8);
    t('6808350866.212', '4670611887821094.6', '0.000001457699982301074980352460135688', 36, 8);
    t('1724257.37586183654376', '0.016567742613356095142153', '104073162.89859702904495573149679115062463446876792498334187044473069739', 62, 8);
    t('0.2218267497479178849103995260', '1', '0.221826749747917884910399526', 45, 8);
    t('3056.9914315', '107136957848669820324475752', '0', 6, 8);
    t('-0.00006521496311421916', '1.4735162', '-0.0000442580564192094800179326158748712772889772097517489118884475107908552345742788576060446', 91, 8);
    t('95.2451', '-3', '-31.748366666666666666666666666666666666666666666666666666666666666666666666666666667', 81, 8);
    t('11298179623224', '-53438143.35488024586439', '-211425.3773412992683362572145230163175744530909060632329620342655', 58, 8);
    t('0.001395397', '-52.8711906969003', '-0.00002639238839918557927088552480937343181967745671767997864643878031311986864968747', 83, 8);
    t('-3.3', '0.000197965', '-16669.6133154850604904907433132119314020155077917813754956684262369610789786073', 73, 8);
    t('45573.038', '-1951245006.57', '-0.0000233558768102170098357070718333190030237587540949009', 55, 8);
    t('11697035101999953412797412955.51', '-0.00002645182103613', '-4.422015061278092346231915492159911911859012754718621042083122434161972684365584014570167e+32', 57, 8);

    t('1', '1e+1000000000', '1', 0, 0);
    t('1', '1e+1000000000', '0', 0, 4);
    t('10', '1e+1000000000', '0', 0, 4);
    t('1', '1e-1000000000', '1e+1000000000');
    t('10', '1e-1000000000', 'Infinity');
    var x = new BigNumber(1e-9);
    BigNumber.config({ RANGE: [-8, 1e9] });
    t(x, 1, '0', 9, 4);

    // Issue #58
    t(1, '0.50000025000012500006', '1.99999900000000000001', 20, 4);
});
