'''OpenGL extension EXT.multiview_draw_buffers

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.multiview_draw_buffers to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/multiview_draw_buffers.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.multiview_draw_buffers import *
from OpenGL.raw.GLES2.EXT.multiview_draw_buffers import _EXTENSION_NAME

def glInitMultiviewDrawBuffersEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawBuffersIndexedEXT.indices size not checked against n
# INPUT glDrawBuffersIndexedEXT.location size not checked against n
glDrawBuffersIndexedEXT=wrapper.wrapper(glDrawBuffersIndexedEXT).setInputArraySize(
    'indices', None
).setInputArraySize(
    'location', None
)
### END AUTOGENERATED SECTION