//---------------------------------------------------------------------------
//
// "" for ʳβʳβ
// ѥ(ż
//
//      Programed by NAKAUE.T (Meister)
//
//  2002.03.18                KIU˹碌TKawariCompilerʬΥ
//                            Ǥ⡢󥿡եäȰ㤦()
//  2002.04.18  Phase 8.0.0   륫󥿥åѥý
//
//---------------------------------------------------------------------------
#ifndef COMPILER_H__
#define COMPILER_H__
//---------------------------------------------------------------------------
#include <string>
#include <vector>
//---------------------------------------------------------------------------
class TKVMCode_base;		// ֥
class TKVMExprCode_base;	// ֥
class TKVMSetCode_base;		// 黻֥
//-------------------------------------------------------------------------
//
// ѥý
//
//-------------------------------------------------------------------------
class TKawariCompiler {
public:
	//=====================================================================
	// ᥽å
	//=====================================================================

	enum Mode {
		M_DICT,		// ȥ⡼
		M_KIS,		// KIS⡼
		M_END,		// ⡼ɤ1Ľλ
		M_UNKNOWN,	// ???
		M_EOF		// EOF
	};

	// 󥹥ȥ饯
	TKawariCompiler(std::istream &is, class TKawariLogger &lgr, const std::string &filename, bool pp=true);

	// ǥȥ饯
	~TKawariCompiler();

	// ⡼ɤ
	Mode GetNextMode(void);

	// ȥɤ
	//  : եνλ⡼ڤؤfalse. ʳtrue.
	bool LoadEntryDefinition(std::vector<std::string> &entries, std::vector<TKVMCode_base *> &sentences);

	// ĤKISʣʸɤ
	TKVMCode_base *LoadInlineScript(void);


	// ʸStatementȤ֥ɤإѥ
	static TKVMCode_base *Compile(const std::string &src, class TKawariLogger &logger);

	// ʸ򡢤ΤޤStringȤ֥ɲ
	static TKVMCode_base *CompileAsString(const std::string &src);

	// ʸ򽸹黻('$[']')Ȥƥѥ
	static TKVMSetCode_base *CompileAsEntryExpression(const std::string &src, class TKawariLogger &logger);

	// ʸ򥨥ȥ̾ǻѲǽʸ˥󥳡ɤ
	static std::string EncodeEntryName(const std::string &orgsen);

private:
	// ϴ
	class TKawariLexer *lexer;

	// 
	class TKawariLogger &logger;

	//=====================================================================
	// ᥽å
	//=====================================================================

	// ȥ̾¤ ( IdLiteral S | IdLiteral S ',' S EntryIdList )
	// return : 줿ȥ̾ο
	int compileEntryIdList(std::vector<std::string> &list);

	// Բʸ¤ӡ()ԥɤɤ߹ǽλ
	// return : 줿ʸο
	int compileNRStatementList(std::vector<TKVMCode_base *> &list);

	// ʸ¤ӡ')'ǽλ
	// return : 줿ʸο
	int compileStatementList(std::vector<TKVMCode_base *> &list);

	//=====================================================================
	// ñ

	// ʸ ( (Word WS)* )
	// ǿλ⥤󥹥󥹤֤$(NULL)롣
	// 
	// noret : Ԥʤtrue.
	// mode : TKawariLexer::ModeƱ͡ǥեȤϥȥ⡼ɡ
	TKVMCode_base *compileStatement(bool noret, int mode=1);

	// ʸ ( Literal )ˤϥѥ¸ߤʤ

	// ñ ( (Literal | Block | Subst )* )
	// ǿä硢NULL֤
	// mode : TKawariLexer::ModeƱ
	TKVMCode_base *compileWord(int mode);

	// ִ ( '$' ( EntryCallSubst | EntryIndexSubst | InlineScriptSubst | ExprSubst ) )
	// ɬƬ'$'뤳ȡ
	TKVMCode_base *compileSubst(void);

	// ץʸ ( WS ( Word WS ) * )
	TKVMCode_base *compileScriptStatement(void);

	// 饤󥹥ץ ( '(' ScriptStatementSeq ') )
	TKVMCode_base *compileInlineScriptSubst(void);

	// ֥å ( '(' WS Statement ')' )
	// ǿλ⥤󥹥󥹤֤$(NULL)롣
	TKVMCode_base *compileBlock(void);

	// źդȥƤӽФʰ
	// ( ( EntryName | Subst ) '[' WS Expr WS ']' )
	TKVMCode_base *compileEntryIndexSubst(void);

	// ȥ̾ ( (IdLiteral | Subst)+ WS )
	TKVMCode_base *compileEntryWord(void);

	//=====================================================================
	// ץȹʸ

	// if
	TKVMCode_base *compileScriptIF(void);


	//=====================================================================
	// 

	//  ( '[' Expression  ']' )
	TKVMCode_base *compileExprSubst(void);

	//  ( '||' )
	TKVMExprCode_base *compileExpr0(void);

	//  ( '&&' )
	TKVMExprCode_base *compileExpr1(void);

	//  ( '=' | '==' | '!=' )
	TKVMExprCode_base *compileExpr2(void);

	//  ( '<' | '<=' | '>' | '>=' )
	TKVMExprCode_base *compileExpr3(void);

	// ӥåOR ('|' | '^')
	TKVMExprCode_base *compileExpr4(void);

	// ӥåAND ('&')
	TKVMExprCode_base *compileExpr5(void);

	// ø ('+' | '-')
	TKVMExprCode_base *compileExpr6(void);

	//  ('*' | '/' | '%')
	TKVMExprCode_base *compileExpr7(void);

	// ñ黻 ('+' | '-' | '!' | '~')
	TKVMExprCode_base *compileExpr8(void);

	// ߾ ( '**' )
	TKVMExprCode_base *compileExpr9(void);

	// Expr ( '(' Expression ')' | ExprWord )
	TKVMExprCode_base *compileExprFactor(void);

	// Exprñ ( DecimalLiteral WS | (QuotedLiteral | Subst)+ WS )
	TKVMExprCode_base *compileExprWord(void);

	//=====================================================================
	// ȥ꽸黻

	// ȥƤӽФ ( '{' EntryExpr '}' )
	TKVMCode_base *compileEntryCallSubst(void);

	// º ('+' | '-')
	TKVMSetCode_base *compileSetExpr0(void);

	//  ('&')
	TKVMSetCode_base *compileSetExpr1(void);

	// 黻 ( '(' EntryExpr ')' | EntryWord )
	TKVMSetCode_base *compileSetExprFactor(void);

	// 黻ñ ( (IdLiteral | Subst)+ WS )
	TKVMSetCode_base *compileSetExprWord(void);
};
//---------------------------------------------------------------------------
#endif // COMPILER_H__
