/*File generated by libtheora with OC_COLLECT_METRICS defined at compile time.*/
#if !defined(_modedec_H)
# define _modedec_H (1)



# if defined(OC_COLLECT_METRICS)
typedef struct oc_mode_metrics oc_mode_metrics;
# endif
typedef struct oc_mode_rd      oc_mode_rd;



/*The number of extra bits of precision at which to store rate metrics.*/
# define OC_BIT_SCALE  (6)
/*The number of extra bits of precision at which to store RMSE metrics.
  This must be at least half OC_BIT_SCALE (rounded up).*/
# define OC_RMSE_SCALE (5)
/*The number of bins to partition statistics into.*/
# define OC_SAD_BINS   (24)
/*The number of bits of precision to drop from SAD scores to assign them to a
   bin.*/
# define OC_SAD_SHIFT  (9)



# if defined(OC_COLLECT_METRICS)
struct oc_mode_metrics{
  double fragw;
  double satd;
  double rate;
  double rmse;
  double satd2;
  double satdrate;
  double rate2;
  double satdrmse;
  double rmse2;
};


int             oc_has_mode_metrics;
oc_mode_metrics OC_MODE_METRICS[64][3][2][OC_SAD_BINS];
# endif



struct oc_mode_rd{
  ogg_int16_t rate;
  ogg_int16_t rmse;
};


# if !defined(OC_COLLECT_METRICS)
static const
# endif
oc_mode_rd OC_MODE_RD[64][3][2][OC_SAD_BINS]={
  {
    {
      /*Y'  qi=0  INTRA*/
      {
        {   87,  -66},{  132, 1611},{  197, 3474},{  285, 5130},
        {  376, 6419},{  450, 7545},{  521, 8587},{  600, 9587},
        {  689,10498},{  790,11348},{  899,12158},{ 1030,12855},
        { 1166,13459},{ 1276,14052},{ 1353,14732},{ 1444,15425},
        { 1535,16101},{ 1609,16856},{ 1697,17532},{ 1823,17995},
        { 1962,18426},{ 2085,18919},{ 2201,19503},{ 2304,20307}
      },
      /*Y'  qi=0  INTER*/
      {
        {   32, -105},{   40, 1268},{   54, 2919},{   91, 4559},
        {  118, 6244},{  132, 7932},{  142, 9514},{  149,10989},
        {  155,12375},{  161,13679},{  168,14958},{  176,16215},
        {  187,17431},{  196,18623},{  207,19790},{  218,20941},
        {  230,22083},{  246,23213},{  265,24333},{  292,25439},
        {  328,26512},{  372,27538},{  427,28522},{  494,29479}
      }
    },
    {
      /*Cb  qi=0  INTRA*/
      {
        {    1,    6},{   27,  368},{   52,  738},{   67, 1171},
        {   80, 1642},{   99, 2134},{  110, 2642},{  112, 3144},
        {  126, 3578},{  154, 3967},{  167, 4387},{  172, 4839},
        {  191, 5278},{  208, 5666},{  220, 6036},{  223, 6398},
        {  227, 6814},{  253, 7157},{  284, 7403},{  292, 7699},
        {  314, 7983},{  339, 8203},{  363, 8460},{  399, 8919}
      },
      /*Cb  qi=0  INTER*/
      {
        {   68,  -55},{   63,  275},{   58,  602},{   53,  936},
        {   50, 1290},{   54, 1691},{   58, 2116},{   62, 2553},
        {   67, 2992},{   72, 3422},{   78, 3843},{   84, 4253},
        {   89, 4658},{   94, 5062},{   98, 5455},{  100, 5848},
        {  102, 6231},{  104, 6604},{  104, 6982},{  105, 7359},
        {  105, 7733},{  104, 8104},{  105, 8465},{  111, 8828}
      }
    },
    {
      /*Cr  qi=0  INTRA*/
      {
        {    1,    8},{   23,  375},{   47,  759},{   63, 1220},
        {   71, 1693},{   82, 2171},{   94, 2652},{  109, 3103},
        {  125, 3567},{  133, 3995},{  151, 4375},{  168, 4819},
        {  174, 5244},{  190, 5635},{  215, 6005},{  242, 6347},
        {  257, 6758},{  280, 7068},{  311, 7336},{  326, 7652},
        {  346, 7968},{  372, 8213},{  388, 8515},{  408, 9060}
      },
      /*Cr  qi=0  INTER*/
      {
        {   69,    0},{   60,  314},{   49,  624},{   45,  943},
        {   45, 1285},{   49, 1691},{   55, 2130},{   62, 2560},
        {   71, 2973},{   79, 3385},{   85, 3800},{   89, 4207},
        {   92, 4620},{   95, 5037},{   96, 5436},{   97, 5839},
        {   98, 6252},{   99, 6653},{   99, 7038},{  103, 7426},
        {  107, 7810},{  108, 8178},{  107, 8539},{  106, 8937}
      }
    }
  },
  {
    {
      /*Y'  qi=1  INTRA*/
      {
        {   81,  -71},{  133, 1610},{  203, 3460},{  296, 5083},
        {  392, 6342},{  467, 7454},{  541, 8486},{  625, 9466},
        {  716,10352},{  823,11181},{  940,11961},{ 1074,12643},
        { 1211,13233},{ 1324,13807},{ 1408,14489},{ 1504,15167},
        { 1598,15824},{ 1679,16544},{ 1788,17161},{ 1928,17579},
        { 2070,17991},{ 2202,18456},{ 2324,19021},{ 2425,19894}
      },
      /*Y'  qi=1  INTER*/
      {
        {   34,    4},{   40, 1307},{   55, 2914},{   93, 4555},
        {  120, 6243},{  134, 7912},{  144, 9468},{  152,10918},
        {  158,12275},{  164,13569},{  171,14846},{  180,16098},
        {  191,17310},{  204,18484},{  216,19636},{  228,20779},
        {  242,21912},{  261,23036},{  286,24146},{  320,25221},
        {  363,26265},{  418,27261},{  485,28203},{  551,29148}
      }
    },
    {
      /*Cb  qi=1  INTRA*/
      {
        {    1,    6},{   28,  367},{   52,  738},{   68, 1172},
        {   86, 1644},{  106, 2135},{  115, 2642},{  119, 3141},
        {  132, 3569},{  157, 3951},{  172, 4366},{  177, 4819},
        {  194, 5258},{  211, 5638},{  224, 6006},{  233, 6367},
        {  236, 6784},{  258, 7121},{  299, 7357},{  319, 7637},
        {  337, 7921},{  358, 8141},{  381, 8367},{  401, 8768}
      },
      /*Cb  qi=1  INTER*/
      {
        {   95,  -31},{   81,  295},{   67,  614},{   53,  953},
        {   48, 1305},{   51, 1700},{   56, 2125},{   61, 2563},
        {   67, 3008},{   73, 3435},{   79, 3844},{   85, 4251},
        {   90, 4663},{   95, 5073},{   98, 5458},{  100, 5844},
        {  101, 6231},{  102, 6606},{  102, 6980},{  103, 7347},
        {  104, 7726},{  105, 8096},{  105, 8453},{  105, 8789}
      }
    },
    {
      /*Cr  qi=1  INTRA*/
      {
        {    1,    8},{   25,  375},{   50,  759},{   65, 1221},
        {   74, 1695},{   86, 2172},{  101, 2651},{  117, 3101},
        {  129, 3561},{  135, 3985},{  153, 4368},{  171, 4807},
        {  182, 5223},{  202, 5608},{  225, 5964},{  251, 6300},
        {  271, 6697},{  295, 6978},{  324, 7235},{  348, 7558},
        {  367, 7877},{  394, 8101},{  413, 8386},{  409, 8945}
      },
      /*Cr  qi=1  INTER*/
      {
        {   66,   11},{   59,  323},{   51,  631},{   44,  949},
        {   44, 1292},{   49, 1703},{   56, 2140},{   62, 2566},
        {   69, 2991},{   77, 3397},{   84, 3799},{   89, 4211},
        {   93, 4634},{   94, 5049},{   95, 5444},{   96, 5854},
        {   94, 6260},{   95, 6640},{   96, 7032},{  101, 7423},
        {  104, 7790},{  105, 8158},{  109, 8527},{  108, 8872}
      }
    }
  },
  {
    {
      /*Y'  qi=2  INTRA*/
      {
        {   87,  -72},{  139, 1607},{  213, 3426},{  315, 4992},
        {  416, 6217},{  495, 7315},{  574, 8317},{  666, 9265},
        {  763,10124},{  875,10906},{ 1001,11654},{ 1147,12305},
        { 1289,12865},{ 1407,13424},{ 1503,14076},{ 1610,14724},
        { 1720,15342},{ 1815,16020},{ 1937,16579},{ 2084,16981},
        { 2236,17371},{ 2385,17779},{ 2536,18250},{ 2689,18931}
      },
      /*Y'  qi=2  INTER*/
      {
        {   30,   -2},{   40, 1308},{   57, 2921},{   96, 4567},
        {  122, 6260},{  136, 7902},{  148, 9418},{  156,10826},
        {  162,12157},{  169,13448},{  177,14709},{  188,15938},
        {  200,17133},{  213,18295},{  228,19433},{  245,20564},
        {  264,21685},{  289,22790},{  323,23876},{  368,24916},
        {  427,25906},{  499,26837},{  585,27700},{  680,28514}
      }
    },
    {
      /*Cb  qi=2  INTRA*/
      {
        {    1,    6},{   30,  367},{   58,  738},{   77, 1172},
        {   93, 1645},{  111, 2137},{  123, 2642},{  126, 3133},
        {  136, 3553},{  162, 3934},{  178, 4352},{  183, 4803},
        {  199, 5231},{  220, 5596},{  235, 5957},{  245, 6314},
        {  256, 6718},{  286, 7048},{  320, 7285},{  336, 7568},
        {  366, 7829},{  387, 8045},{  405, 8261},{  445, 8550}
      },
      /*Cb  qi=2  INTER*/
      {
        {  115,  -61},{   93,  277},{   71,  609},{   54,  963},
        {   49, 1329},{   53, 1715},{   58, 2138},{   63, 2583},
        {   69, 3017},{   75, 3442},{   81, 3857},{   88, 4263},
        {   93, 4667},{   96, 5065},{  101, 5451},{  101, 5832},
        {  102, 6213},{  103, 6593},{  103, 6968},{  104, 7336},
        {  104, 7710},{  105, 8076},{  106, 8440},{  106, 8822}
      }
    },
    {
      /*Cr  qi=2  INTRA*/
      {
        {    1,    8},{   27,  375},{   54,  759},{   70, 1222},
        {   79, 1696},{   89, 2173},{  106, 2652},{  123, 3098},
        {  135, 3553},{  143, 3972},{  161, 4348},{  181, 4782},
        {  194, 5189},{  213, 5565},{  235, 5907},{  266, 6229},
        {  286, 6618},{  311, 6897},{  339, 7152},{  362, 7454},
        {  392, 7721},{  416, 7946},{  429, 8227},{  458, 8540}
      },
      /*Cr  qi=2  INTER*/
      {
        {   74,   20},{   63,  330},{   51,  635},{   44,  942},
        {   47, 1287},{   54, 1710},{   59, 2147},{   65, 2571},
        {   72, 2996},{   79, 3413},{   86, 3820},{   91, 4230},
        {   93, 4642},{   95, 5046},{   95, 5442},{   95, 5839},
        {   96, 6243},{   97, 6641},{   99, 7021},{  101, 7396},
        {  103, 7764},{  106, 8138},{  109, 8507},{  114, 8851}
      }
    }
  },
  {
    {
      /*Y'  qi=3  INTRA*/
      {
        {   91,  -67},{  141, 1606},{  219, 3405},{  328, 4929},
        {  433, 6122},{  515, 7209},{  598, 8204},{  693, 9145},
        {  796, 9986},{  912,10756},{ 1045,11471},{ 1200,12079},
        { 1345,12640},{ 1471,13179},{ 1571,13809},{ 1678,14450},
        { 1798,15047},{ 1905,15701},{ 2043,16205},{ 2202,16569},
        { 2351,16971},{ 2501,17393},{ 2660,17851},{ 2825,18455}
      },
      /*Y'  qi=3  INTER*/
      {
        {   53, -164},{   38, 1314},{   59, 2917},{   99, 4563},
        {  124, 6253},{  139, 7882},{  150, 9375},{  159,10749},
        {  166,12059},{  173,13349},{  183,14608},{  194,15826},
        {  208,17003},{  223,18150},{  240,19287},{  259,20411},
        {  284,21508},{  317,22593},{  359,23656},{  414,24671},
        {  483,25634},{  569,26519},{  670,27332},{  786,28072}
      }
    },
    {
      /*Cb  qi=3  INTRA*/
      {
        {    1,    5},{   31,  367},{   58,  739},{   78, 1173},
        {   96, 1645},{  113, 2134},{  125, 2638},{  133, 3127},
        {  148, 3542},{  171, 3915},{  184, 4328},{  192, 4776},
        {  209, 5197},{  230, 5556},{  245, 5909},{  252, 6261},
        {  272, 6641},{  304, 6942},{  330, 7184},{  342, 7477},
        {  380, 7736},{  404, 7962},{  428, 8151},{  469, 8430}
      },
      /*Cb  qi=3  INTER*/
      {
        {   86,  -29},{   72,  296},{   58,  618},{   46,  964},
        {   47, 1338},{   51, 1743},{   56, 2158},{   63, 2594},
        {   69, 3035},{   77, 3455},{   84, 3859},{   89, 4266},
        {   94, 4673},{   98, 5074},{  101, 5460},{  101, 5842},
        {  101, 6217},{  101, 6593},{  102, 6964},{  104, 7325},
        {  103, 7696},{  103, 8056},{  104, 8430},{  103, 8792}
      }
    },
    {
      /*Cr  qi=3  INTRA*/
      {
        {    1,    8},{   27,  374},{   56,  759},{   74, 1221},
        {   83, 1696},{   96, 2173},{  113, 2650},{  127, 3091},
        {  140, 3542},{  151, 3960},{  164, 4334},{  188, 4764},
        {  208, 5144},{  224, 5493},{  250, 5841},{  278, 6162},
        {  298, 6548},{  334, 6816},{  365, 7045},{  388, 7343},
        {  419, 7613},{  443, 7836},{  455, 8105},{  484, 8445}
      },
      /*Cr  qi=3  INTER*/
      {
        {   76,   26},{   65,  332},{   53,  638},{   45,  945},
        {   45, 1304},{   53, 1725},{   60, 2153},{   68, 2584},
        {   74, 3007},{   81, 3425},{   87, 3844},{   91, 4253},
        {   94, 4657},{   95, 5061},{   94, 5462},{   94, 5856},
        {   95, 6250},{   96, 6635},{   97, 7014},{  101, 7393},
        {  104, 7761},{  106, 8137},{  109, 8506},{  111, 8823}
      }
    }
  },
  {
    {
      /*Y'  qi=4  INTRA*/
      {
        {   80,  -67},{  143, 1603},{  227, 3378},{  344, 4861},
        {  454, 6026},{  537, 7104},{  626, 8089},{  725, 9006},
        {  830, 9827},{  950,10581},{ 1089,11270},{ 1257,11826},
        { 1409,12366},{ 1535,12912},{ 1640,13528},{ 1753,14173},
        { 1884,14756},{ 2007,15368},{ 2148,15852},{ 2307,16212},
        { 2464,16591},{ 2614,17019},{ 2785,17455},{ 2970,17963}
      },
      /*Y'  qi=4  INTER*/
      {
        {   50, -145},{   38, 1324},{   61, 2921},{  102, 4566},
        {  127, 6248},{  142, 7845},{  154, 9300},{  163,10656},
        {  169,11965},{  177,13246},{  188,14495},{  202,15702},
        {  218,16864},{  236,18003},{  256,19124},{  278,20233},
        {  307,21330},{  347,22398},{  398,23437},{  463,24429},
        {  546,25343},{  649,26170},{  767,26935},{  888,27674}
      }
    },
    {
      /*Cb  qi=4  INTRA*/
      {
        {    1,    5},{   33,  367},{   61,  739},{   80, 1173},
        {   98, 1646},{  114, 2136},{  126, 2639},{  137, 3124},
        {  152, 3535},{  176, 3903},{  194, 4307},{  206, 4753},
        {  222, 5165},{  242, 5508},{  260, 5857},{  272, 6205},
        {  294, 6559},{  332, 6848},{  356, 7104},{  364, 7389},
        {  396, 7637},{  415, 7878},{  446, 8064},{  506, 8294}
      },
      /*Cb  qi=4  INTER*/
      {
        {   86,  -15},{   73,  308},{   60,  627},{   46,  967},
        {   47, 1343},{   51, 1754},{   56, 2183},{   63, 2615},
        {   70, 3044},{   79, 3459},{   85, 3866},{   90, 4276},
        {   94, 4686},{   97, 5088},{  100, 5467},{  102, 5837},
        {  102, 6205},{  101, 6569},{  103, 6939},{  104, 7317},
        {  105, 7690},{  107, 8043},{  107, 8394},{  111, 8736}
      }
    },
    {
      /*Cr  qi=4  INTRA*/
      {
        {    1,    7},{   28,  375},{   57,  759},{   79, 1221},
        {   92, 1697},{  105, 2174},{  122, 2648},{  135, 3085},
        {  146, 3530},{  157, 3947},{  171, 4316},{  195, 4737},
        {  218, 5117},{  239, 5445},{  268, 5767},{  295, 6074},
        {  315, 6460},{  355, 6735},{  392, 6933},{  418, 7218},
        {  448, 7495},{  471, 7688},{  481, 7954},{  504, 8313}
      },
      /*Cr  qi=4  INTER*/
      {
        {   68,   28},{   57,  334},{   47,  639},{   43,  953},
        {   48, 1314},{   54, 1736},{   59, 2169},{   69, 2592},
        {   78, 3017},{   84, 3434},{   88, 3850},{   92, 4260},
        {   95, 4663},{   96, 5068},{   95, 5455},{   95, 5839},
        {   96, 6243},{   97, 6626},{   98, 7006},{  101, 7390},
        {  104, 7755},{  108, 8115},{  111, 8471},{  110, 8825}
      }
    }
  },
  {
    {
      /*Y'  qi=5  INTRA*/
      {
        {   84,  -69},{  147, 1599},{  237, 3350},{  360, 4796},
        {  475, 5934},{  562, 6992},{  657, 7953},{  765, 8837},
        {  874, 9641},{  998,10384},{ 1146,11047},{ 1322,11572},
        { 1484,12076},{ 1617,12609},{ 1731,13203},{ 1856,13806},
        { 1995,14367},{ 2132,14936},{ 2289,15386},{ 2460,15721},
        { 2635,16066},{ 2802,16442},{ 2980,16805},{ 3177,17272}
      },
      /*Y'  qi=5  INTER*/
      {
        {   38,  -86},{   37, 1349},{   64, 2920},{  105, 4563},
        {  129, 6236},{  145, 7809},{  158, 9236},{  167,10572},
        {  174,11871},{  182,13141},{  195,14368},{  212,15558},
        {  230,16706},{  250,17828},{  274,18944},{  303,20041},
        {  342,21116},{  394,22152},{  460,23144},{  543,24073},
        {  648,24919},{  773,25673},{  922,26323},{ 1084,26924}
      }
    },
    {
      /*Cb  qi=5  INTRA*/
      {
        {    1,    5},{   34,  367},{   63,  739},{   82, 1174},
        {  102, 1647},{  119, 2137},{  134, 2639},{  145, 3121},
        {  161, 3529},{  189, 3891},{  207, 4290},{  216, 4721},
        {  232, 5113},{  258, 5455},{  277, 5798},{  294, 6124},
        {  322, 6427},{  352, 6697},{  370, 6982},{  384, 7283},
        {  423, 7529},{  448, 7766},{  478, 7943},{  527, 8151}
      },
      /*Cb  qi=5  INTER*/
      {
        {   83,  -49},{   69,  284},{   55,  611},{   48,  961},
        {   49, 1355},{   52, 1769},{   58, 2191},{   65, 2616},
        {   73, 3041},{   80, 3460},{   87, 3868},{   92, 4276},
        {   95, 4682},{   98, 5077},{  100, 5459},{  102, 5827},
        {  102, 6200},{  102, 6568},{  103, 6930},{  103, 7303},
        {  104, 7672},{  106, 8032},{  106, 8391},{  106, 8727}
      }
    },
    {
      /*Cr  qi=5  INTRA*/
      {
        {    1,    8},{   28,  375},{   57,  760},{   81, 1222},
        {   99, 1696},{  111, 2175},{  125, 2648},{  140, 3079},
        {  152, 3520},{  162, 3927},{  179, 4294},{  203, 4714},
        {  225, 5080},{  254, 5389},{  286, 5703},{  318, 5997},
        {  342, 6364},{  380, 6640},{  416, 6837},{  445, 7103},
        {  473, 7370},{  497, 7562},{  514, 7811},{  549, 8148}
      },
      /*Cr  qi=5  INTER*/
      {
        {   60,    6},{   54,  323},{   46,  638},{   43,  958},
        {   45, 1329},{   54, 1749},{   61, 2175},{   70, 2600},
        {   79, 3021},{   85, 3437},{   89, 3847},{   93, 4254},
        {   95, 4660},{   96, 5065},{   95, 5456},{   95, 5849},
        {   96, 6243},{   96, 6621},{   97, 6996},{  101, 7366},
        {  104, 7722},{  107, 8088},{  111, 8448},{  119, 8816}
      }
    }
  },
  {
    {
      /*Y'  qi=6  INTRA*/
      {
        {   88,  -69},{  151, 1593},{  251, 3294},{  387, 4681},
        {  507, 5790},{  601, 6837},{  702, 7787},{  813, 8648},
        {  927, 9427},{ 1059,10152},{ 1213,10787},{ 1399,11284},
        { 1568,11781},{ 1705,12312},{ 1823,12890},{ 1957,13482},
        { 2106,14036},{ 2249,14600},{ 2411,15042},{ 2588,15359},
        { 2772,15699},{ 2947,16062},{ 3127,16429},{ 3320,16849}
      },
      /*Y'  qi=6  INTER*/
      {
        {   44,  -80},{   36, 1346},{   69, 2919},{  111, 4563},
        {  136, 6216},{  154, 7746},{  168, 9139},{  178,10461},
        {  185,11747},{  195,13007},{  211,14229},{  230,15408},
        {  250,16547},{  274,17663},{  302,18769},{  339,19851},
        {  386,20907},{  446,21933},{  527,22884},{  631,23746},
        {  760,24512},{  914,25178},{ 1087,25758},{ 1278,26262}
      }
    },
    {
      /*Cb  qi=6  INTRA*/
      {
        {    1,    4},{   36,  367},{   66,  739},{   84, 1174},
        {  105, 1648},{  126, 2139},{  140, 2639},{  149, 3116},
        {  164, 3523},{  194, 3880},{  217, 4271},{  226, 4694},
        {  243, 5077},{  270, 5407},{  291, 5742},{  310, 6061},
        {  340, 6340},{  373, 6609},{  394, 6890},{  409, 7189},
        {  444, 7434},{  469, 7652},{  499, 7853},{  559, 8135}
      },
      /*Cb  qi=6  INTER*/
      {
        {   68,  -46},{   60,  291},{   50,  623},{   49,  971},
        {   50, 1357},{   55, 1781},{   61, 2211},{   69, 2634},
        {   78, 3052},{   86, 3466},{   91, 3882},{   95, 4292},
        {   98, 4691},{  101, 5080},{  102, 5458},{  103, 5830},
        {  103, 6192},{  104, 6554},{  104, 6916},{  106, 7278},
        {  108, 7641},{  110, 8004},{  112, 8371},{  112, 8758}
      }
    },
    {
      /*Cr  qi=6  INTRA*/
      {
        {    1,    8},{   29,  375},{   59,  760},{   84, 1223},
        {   99, 1698},{  112, 2176},{  129, 2647},{  143, 3076},
        {  156, 3510},{  168, 3906},{  189, 4269},{  220, 4682},
        {  241, 5047},{  266, 5342},{  299, 5649},{  331, 5954},
        {  357, 6309},{  393, 6579},{  431, 6765},{  467, 6997},
        {  501, 7276},{  520, 7488},{  525, 7749},{  548, 8146}
      },
      /*Cr  qi=6  INTER*/
      {
        {   94,   31},{   69,  335},{   47,  641},{   43,  967},
        {   50, 1350},{   57, 1772},{   65, 2197},{   74, 2625},
        {   83, 3043},{   90, 3454},{   94, 3867},{   97, 4273},
        {   98, 4671},{   99, 5068},{   99, 5461},{   98, 5857},
        {   98, 6245},{   99, 6610},{  103, 6975},{  105, 7345},
        {  108, 7712},{  111, 8073},{  113, 8415},{  119, 8768}
      }
    }
  },
  {
    {
      /*Y'  qi=7  INTRA*/
      {
        {   92,  -70},{  156, 1590},{  261, 3267},{  403, 4618},
        {  529, 5704},{  628, 6730},{  736, 7657},{  856, 8491},
        {  978, 9246},{ 1118, 9943},{ 1281,10550},{ 1472,11028},
        { 1645,11507},{ 1793,12008},{ 1924,12565},{ 2067,13130},
        { 2229,13638},{ 2388,14160},{ 2558,14584},{ 2744,14886},
        { 2932,15194},{ 3116,15531},{ 3311,15858},{ 3538,16197}
      },
      /*Y'  qi=7  INTER*/
      {
        {   43,   -8},{   36, 1351},{   71, 2923},{  112, 4568},
        {  138, 6201},{  157, 7705},{  171, 9083},{  181,10390},
        {  189,11664},{  202,12910},{  220,14121},{  241,15281},
        {  266,16401},{  295,17507},{  328,18608},{  371,19677},
        {  430,20701},{  508,21676},{  604,22588},{  727,23397},
        {  878,24093},{ 1055,24690},{ 1263,25151},{ 1496,25504}
      }
    },
    {
      /*Cb  qi=7  INTRA*/
      {
        {    1,    5},{   40,  367},{   72,  740},{   89, 1175},
        {  108, 1649},{  129, 2140},{  143, 2637},{  154, 3110},
        {  169, 3507},{  198, 3860},{  224, 4237},{  235, 4652},
        {  253, 5037},{  282, 5358},{  307, 5674},{  329, 5986},
        {  361, 6273},{  393, 6527},{  419, 6777},{  435, 7078},
        {  467, 7342},{  495, 7554},{  529, 7757},{  591, 8053}
      },
      /*Cb  qi=7  INTER*/
      {
        {   79,  -33},{   68,  299},{   56,  627},{   50,  978},
        {   51, 1366},{   55, 1786},{   61, 2213},{   70, 2642},
        {   80, 3062},{   87, 3474},{   92, 3886},{   96, 4292},
        {   99, 4684},{  102, 5072},{  103, 5450},{  104, 5814},
        {  104, 6176},{  104, 6538},{  107, 6905},{  110, 7270},
        {  110, 7625},{  110, 7978},{  111, 8340},{  117, 8674}
      }
    },
    {
      /*Cr  qi=7  INTRA*/
      {
        {    2,    7},{   31,  375},{   62,  760},{   87, 1223},
        {  103, 1698},{  115, 2175},{  131, 2644},{  147, 3066},
        {  161, 3494},{  175, 3889},{  199, 4250},{  229, 4653},
        {  250, 5001},{  279, 5275},{  311, 5577},{  343, 5889},
        {  376, 6227},{  417, 6486},{  457, 6689},{  484, 6925},
        {  518, 7174},{  544, 7393},{  549, 7662},{  577, 8050}
      },
      /*Cr  qi=7  INTER*/
      {
        {   89,   22},{   62,  332},{   45,  641},{   47,  976},
        {   52, 1363},{   59, 1779},{   67, 2203},{   76, 2628},
        {   84, 3046},{   90, 3460},{   94, 3875},{   98, 4272},
        {   99, 4666},{   98, 5063},{   98, 5459},{   98, 5849},
        {   99, 6226},{  101, 6594},{  104, 6957},{  109, 7324},
        {  109, 7686},{  111, 8042},{  115, 8379},{  119, 8699}
      }
    }
  },
  {
    {
      /*Y'  qi=8  INTRA*/
      {
        {   91,  -69},{  160, 1585},{  274, 3226},{  423, 4538},
        {  557, 5596},{  664, 6595},{  778, 7506},{  905, 8319},
        { 1038, 9035},{ 1186, 9701},{ 1355,10292},{ 1554,10754},
        { 1739,11196},{ 1904,11639},{ 2047,12184},{ 2194,12763},
        { 2361,13256},{ 2529,13753},{ 2709,14155},{ 2902,14433},
        { 3100,14723},{ 3292,15026},{ 3489,15327},{ 3714,15705}
      },
      /*Y'  qi=8  INTER*/
      {
        {   32, -157},{   33, 1346},{   74, 2914},{  116, 4554},
        {  142, 6172},{  162, 7648},{  177, 9004},{  186,10300},
        {  196,11570},{  210,12808},{  231,14001},{  256,15150},
        {  285,16259},{  319,17352},{  359,18435},{  415,19475},
        {  489,20470},{  584,21400},{  703,22246},{  852,22968},
        { 1038,23556},{ 1253,24032},{ 1503,24367},{ 1778,24628}
      }
    },
    {
      /*Cb  qi=8  INTRA*/
      {
        {    1,    4},{   42,  367},{   75,  740},{   93, 1176},
        {  111, 1649},{  128, 2139},{  144, 2635},{  157, 3103},
        {  174, 3494},{  206, 3844},{  233, 4207},{  251, 4605},
        {  277, 4980},{  304, 5284},{  335, 5584},{  359, 5888},
        {  393, 6152},{  432, 6398},{  455, 6656},{  471, 6956},
        {  502, 7193},{  528, 7405},{  562, 7630},{  603, 7922}
      },
      /*Cb  qi=8  INTER*/
      {
        {   77,  -37},{   68,  299},{   58,  632},{   50,  991},
        {   50, 1382},{   55, 1799},{   62, 2226},{   73, 2647},
        {   82, 3066},{   90, 3480},{   94, 3891},{   96, 4296},
        {   98, 4687},{  101, 5073},{  103, 5456},{  104, 5817},
        {  105, 6170},{  106, 6523},{  107, 6886},{  108, 7250},
        {  109, 7600},{  110, 7955},{  111, 8305},{  112, 8641}
      }
    },
    {
      /*Cr  qi=8  INTRA*/
      {
        {    2,    7},{   33,  375},{   64,  760},{   92, 1224},
        {  111, 1700},{  122, 2173},{  137, 2637},{  156, 3055},
        {  172, 3476},{  186, 3856},{  211, 4211},{  242, 4597},
        {  263, 4939},{  292, 5214},{  335, 5489},{  376, 5772},
        {  406, 6099},{  440, 6378},{  483, 6578},{  517, 6797},
        {  550, 7049},{  571, 7283},{  583, 7560},{  618, 7967}
      },
      /*Cr  qi=8  INTER*/
      {
        {   74,   25},{   58,  328},{   43,  637},{   45,  980},
        {   51, 1371},{   59, 1788},{   69, 2207},{   79, 2630},
        {   86, 3051},{   91, 3470},{   95, 3880},{   97, 4280},
        {   98, 4680},{   97, 5074},{   96, 5456},{   97, 5839},
        {   99, 6219},{  101, 6583},{  103, 6945},{  106, 7312},
        {  110, 7671},{  114, 8009},{  115, 8345},{  117, 8686}
      }
    }
  },
  {
    {
      /*Y'  qi=9  INTRA*/
      {
        {  104,  -68},{  164, 1580},{  288, 3173},{  448, 4439},
        {  587, 5485},{  702, 6465},{  824, 7351},{  958, 8148},
        { 1096, 8845},{ 1253, 9480},{ 1432,10047},{ 1640,10494},
        { 1835,10926},{ 2015,11350},{ 2166,11871},{ 2321,12428},
        { 2508,12876},{ 2684,13345},{ 2866,13741},{ 3069,13991},
        { 3281,14243},{ 3487,14518},{ 3689,14813},{ 3911,15175}
      },
      /*Y'  qi=9  INTER*/
      {
        {   47, -140},{   34, 1348},{   77, 2915},{  119, 4552},
        {  145, 6150},{  166, 7600},{  182, 8936},{  192,10221},
        {  203,11482},{  220,12711},{  244,13886},{  274,15012},
        {  308,16111},{  349,17190},{  401,18244},{  470,19257},
        {  561,20209},{  680,21069},{  830,21822},{ 1010,22463},
        { 1227,22971},{ 1482,23328},{ 1769,23544},{ 2077,23655}
      }
    },
    {
      /*Cb  qi=9  INTRA*/
      {
        {    1,    5},{   43,  367},{   76,  740},{   95, 1176},
        {  114, 1649},{  135, 2138},{  153, 2629},{  165, 3091},
        {  184, 3481},{  217, 3831},{  244, 4187},{  260, 4572},
        {  290, 4930},{  320, 5231},{  351, 5521},{  379, 5812},
        {  414, 6055},{  452, 6307},{  483, 6564},{  502, 6848},
        {  525, 7115},{  554, 7321},{  589, 7533},{  626, 7833}
      },
      /*Cb  qi=9  INTER*/
      {
        {  101,  -43},{   81,  298},{   62,  637},{   49,  989},
        {   51, 1381},{   56, 1806},{   65, 2231},{   74, 2653},
        {   84, 3071},{   91, 3482},{   95, 3892},{   97, 4293},
        {   99, 4684},{  101, 5066},{  103, 5437},{  103, 5793},
        {  103, 6148},{  104, 6511},{  105, 6867},{  107, 7221},
        {  110, 7572},{  111, 7926},{  112, 8283},{  116, 8625}
      }
    },
    {
      /*Cr  qi=9  INTRA*/
      {
        {    2,    7},{   35,  375},{   66,  761},{   93, 1224},
        {  112, 1700},{  126, 2173},{  144, 2633},{  165, 3047},
        {  183, 3458},{  199, 3835},{  224, 4191},{  257, 4558},
        {  283, 4887},{  309, 5176},{  351, 5446},{  397, 5713},
        {  433, 6017},{  469, 6283},{  508, 6480},{  546, 6687},
        {  579, 6945},{  600, 7182},{  610, 7434},{  623, 7793}
      },
      /*Cr  qi=9  INTER*/
      {
        {   77,   15},{   57,  330},{   45,  640},{   48,  980},
        {   54, 1380},{   61, 1802},{   70, 2220},{   80, 2639},
        {   87, 3057},{   92, 3474},{   94, 3882},{   98, 4282},
        {   98, 4675},{   97, 5062},{   97, 5450},{   98, 5829},
        {  100, 6197},{  101, 6561},{  104, 6927},{  107, 7289},
        {  113, 7638},{  117, 7978},{  119, 8311},{  117, 8629}
      }
    }
  },
  {
    {
      /*Y'  qi=10  INTRA*/
      {
        {  101,  -69},{  168, 1574},{  299, 3143},{  465, 4386},
        {  610, 5410},{  736, 6353},{  866, 7207},{ 1006, 7982},
        { 1153, 8655},{ 1319, 9261},{ 1504, 9812},{ 1719,10248},
        { 1928,10653},{ 2116,11056},{ 2282,11550},{ 2458,12070},
        { 2654,12492},{ 2846,12923},{ 3043,13291},{ 3249,13537},
        { 3466,13764},{ 3682,13999},{ 3896,14268},{ 4145,14548}
      },
      /*Y'  qi=10  INTER*/
      {
        {   48,  -94},{   34, 1355},{   81, 2920},{  124, 4545},
        {  151, 6113},{  174, 7532},{  190, 8850},{  201,10125},
        {  214,11379},{  235,12591},{  264,13745},{  299,14859},
        {  338,15948},{  388,17008},{  456,18029},{  546,18988},
        {  661,19877},{  808,20666},{  993,21321},{ 1218,21835},
        { 1481,22203},{ 1783,22420},{ 2117,22504},{ 2469,22481}
      }
    },
    {
      /*Cb  qi=10  INTRA*/
      {
        {    2,    4},{   44,  367},{   79,  740},{   99, 1178},
        {  117, 1652},{  137, 2141},{  156, 2630},{  170, 3089},
        {  192, 3474},{  227, 3813},{  259, 4157},{  282, 4526},
        {  310, 4860},{  342, 5140},{  377, 5425},{  400, 5714},
        {  436, 5952},{  475, 6194},{  496, 6468},{  522, 6748},
        {  559, 6996},{  587, 7216},{  617, 7433},{  673, 7678}
      },
      /*Cb  qi=10  INTER*/
      {
        {   87,  -37},{   72,  301},{   58,  636},{   49,  995},
        {   51, 1394},{   57, 1819},{   66, 2241},{   78, 2660},
        {   87, 3074},{   93, 3482},{   97, 3891},{   99, 4294},
        {  101, 4678},{  103, 5050},{  105, 5414},{  106, 5773},
        {  107, 6134},{  108, 6485},{  110, 6832},{  113, 7187},
        {  113, 7547},{  114, 7887},{  117, 8230},{  112, 8590}
      }
    },
    {
      /*Cr  qi=10  INTRA*/
      {
        {    2,    7},{   38,  375},{   69,  761},{   96, 1224},
        {  116, 1701},{  131, 2175},{  148, 2634},{  168, 3041},
        {  190, 3439},{  211, 3802},{  238, 4151},{  271, 4506},
        {  297, 4824},{  331, 5103},{  373, 5360},{  415, 5632},
        {  459, 5928},{  500, 6176},{  535, 6386},{  573, 6586},
        {  608, 6834},{  629, 7079},{  642, 7337},{  686, 7680}
      },
      /*Cr  qi=10  INTER*/
      {
        {   81,   34},{   63,  333},{   50,  633},{   48,  987},
        {   53, 1397},{   61, 1820},{   71, 2237},{   83, 2651},
        {   91, 3065},{   95, 3479},{   98, 3882},{  100, 4279},
        {  101, 4673},{  101, 5054},{  100, 5429},{  101, 5801},
        {  102, 6173},{  104, 6541},{  108, 6904},{  110, 7264},
        {  114, 7609},{  119, 7945},{  123, 8275},{  128, 8615}
      }
    }
  },
  {
    {
      /*Y'  qi=11  INTRA*/
      {
        {  110,  -66},{  176, 1564},{  316, 3087},{  492, 4296},
        {  645, 5299},{  781, 6217},{  924, 7039},{ 1075, 7776},
        { 1232, 8421},{ 1410, 9005},{ 1607, 9532},{ 1834, 9929},
        { 2053,10300},{ 2249,10697},{ 2427,11184},{ 2619,11682},
        { 2826,12083},{ 3019,12508},{ 3225,12869},{ 3452,13064},
        { 3670,13280},{ 3890,13519},{ 4123,13750},{ 4367,14059}
      },
      /*Y'  qi=11  INTER*/
      {
        {   72, -115},{   32, 1354},{   83, 2911},{  126, 4534},
        {  154, 6080},{  178, 7475},{  194, 8779},{  205,10047},
        {  222,11290},{  246,12488},{  281,13621},{  322,14714},
        {  372,15786},{  436,16821},{  519,17813},{  628,18728},
        {  770,19549},{  950,20254},{ 1175,20800},{ 1443,21197},
        { 1752,21446},{ 2095,21555},{ 2457,21553},{ 2808,21544}
      }
    },
    {
      /*Cb  qi=11  INTRA*/
      {
        {    2,    4},{   45,  367},{   81,  740},{  101, 1177},
        {  121, 1650},{  142, 2136},{  159, 2621},{  174, 3075},
        {  199, 3451},{  234, 3778},{  265, 4117},{  297, 4473},
        {  333, 4789},{  367, 5054},{  402, 5319},{  427, 5613},
        {  462, 5871},{  503, 6107},{  532, 6336},{  560, 6584},
        {  601, 6842},{  631, 7092},{  662, 7292},{  721, 7497}
      },
      /*Cb  qi=11  INTER*/
      {
        {  117,  -24},{   93,  308},{   69,  638},{   52,  993},
        {   52, 1395},{   58, 1822},{   68, 2246},{   80, 2665},
        {   89, 3082},{   94, 3492},{   96, 3900},{   98, 4299},
        {  101, 4679},{  103, 5047},{  104, 5405},{  106, 5763},
        {  106, 6120},{  107, 6474},{  109, 6823},{  112, 7163},
        {  115, 7516},{  117, 7868},{  118, 8213},{  119, 8561}
      }
    },
    {
      /*Cr  qi=11  INTRA*/
      {
        {    2,    7},{   40,  375},{   75,  761},{  100, 1224},
        {  119, 1700},{  137, 2169},{  154, 2622},{  178, 3025},
        {  198, 3416},{  220, 3770},{  255, 4114},{  294, 4459},
        {  323, 4756},{  359, 5028},{  399, 5292},{  438, 5556},
        {  483, 5827},{  518, 6073},{  551, 6298},{  598, 6501},
        {  634, 6754},{  652, 6997},{  670, 7211},{  689, 7560}
      },
      /*Cr  qi=11  INTER*/
      {
        {   75,   30},{   61,  334},{   51,  639},{   49,  995},
        {   53, 1403},{   62, 1821},{   73, 2237},{   84, 2654},
        {   91, 3070},{   95, 3485},{   96, 3890},{   98, 4287},
        {   98, 4672},{   99, 5050},{   99, 5427},{  100, 5798},
        {  103, 6169},{  105, 6528},{  107, 6881},{  113, 7233},
        {  118, 7580},{  121, 7916},{  125, 8240},{  130, 8551}
      }
    }
  },
  {
    {
      /*Y'  qi=12  INTRA*/
      {
        {  104,  -69},{  182, 1557},{  335, 3040},{  521, 4205},
        {  684, 5178},{  831, 6068},{  986, 6854},{ 1151, 7559},
        { 1323, 8169},{ 1523, 8704},{ 1736, 9192},{ 1978, 9558},
        { 2213, 9908},{ 2421,10298},{ 2613,10757},{ 2822,11208},
        { 3042,11585},{ 3250,11991},{ 3474,12308},{ 3710,12480},
        { 3939,12687},{ 4174,12902},{ 4416,13102},{ 4672,13369}
      },
      /*Y'  qi=12  INTER*/
      {
        {   52,  -91},{   34, 1355},{   86, 2911},{  129, 4518},
        {  159, 6037},{  184, 7405},{  200, 8694},{  213, 9955},
        {  232,11185},{  263,12360},{  304,13479},{  354,14555},
        {  415,15601},{  495,16608},{  601,17549},{  738,18400},
        {  915,19136},{ 1139,19724},{ 1414,20150},{ 1731,20412},
        { 2090,20520},{ 2473,20509},{ 2851,20442},{ 3227,20328}
      }
    },
    {
      /*Cb  qi=12  INTRA*/
      {
        {    1,    4},{   46,  367},{   85,  740},{  109, 1178},
        {  126, 1650},{  145, 2134},{  165, 2617},{  182, 3061},
        {  209, 3428},{  245, 3749},{  281, 4077},{  316, 4417},
        {  354, 4718},{  392, 4970},{  430, 5217},{  456, 5501},
        {  490, 5771},{  534, 5996},{  571, 6207},{  600, 6458},
        {  644, 6697},{  675, 6942},{  707, 7151},{  766, 7342}
      },
      /*Cb  qi=12  INTER*/
      {
        {   84,  -24},{   73,  311},{   60,  644},{   52,  998},
        {   53, 1398},{   60, 1825},{   71, 2249},{   83, 2665},
        {   90, 3081},{   94, 3490},{   97, 3893},{   99, 4286},
        {  102, 4663},{  104, 5032},{  105, 5393},{  106, 5751},
        {  107, 6102},{  108, 6445},{  111, 6788},{  113, 7136},
        {  114, 7483},{  117, 7828},{  121, 8163},{  122, 8496}
      }
    },
    {
      /*Cr  qi=12  INTRA*/
      {
        {    3,    7},{   41,  375},{   78,  761},{  106, 1225},
        {  124, 1700},{  140, 2167},{  163, 2616},{  188, 3010},
        {  213, 3385},{  240, 3718},{  271, 4062},{  309, 4406},
        {  345, 4691},{  387, 4956},{  430, 5212},{  469, 5467},
        {  513, 5729},{  554, 5970},{  587, 6176},{  633, 6395},
        {  673, 6659},{  692, 6868},{  712, 7061},{  758, 7259}
      },
      /*Cr  qi=12  INTER*/
      {
        {   73,   31},{   59,  335},{   48,  638},{   50,  998},
        {   56, 1410},{   65, 1827},{   75, 2240},{   85, 2657},
        {   92, 3073},{   95, 3485},{   97, 3888},{   99, 4279},
        {   98, 4663},{   99, 5042},{  101, 5412},{  102, 5779},
        {  105, 6142},{  107, 6498},{  108, 6848},{  113, 7198},
        {  118, 7540},{  121, 7867},{  127, 8188},{  132, 8508}
      }
    }
  },
  {
    {
      /*Y'  qi=13  INTRA*/
      {
        {  109,  -68},{  187, 1551},{  347, 3010},{  541, 4153},
        {  709, 5107},{  864, 5975},{ 1026, 6745},{ 1194, 7433},
        { 1375, 8021},{ 1581, 8550},{ 1803, 9026},{ 2054, 9371},
        { 2301, 9713},{ 2522,10082},{ 2728,10515},{ 2949,10956},
        { 3184,11297},{ 3408,11653},{ 3643,11946},{ 3886,12100},
        { 4124,12277},{ 4377,12459},{ 4632,12635},{ 4898,12861}
      },
      /*Y'  qi=13  INTER*/
      {
        {   48,  -78},{   35, 1357},{   89, 2914},{  133, 4512},
        {  164, 6004},{  190, 7348},{  207, 8627},{  222, 9881},
        {  247,11096},{  284,12251},{  333,13350},{  392,14407},
        {  466,15426},{  565,16391},{  696,17279},{  865,18058},
        { 1085,18689},{ 1358,19156},{ 1684,19456},{ 2050,19605},
        { 2447,19614},{ 2855,19524},{ 3243,19398},{ 3611,19201}
      }
    },
    {
      /*Cb  qi=13  INTRA*/
      {
        {    2,    4},{   47,  367},{   86,  741},{  108, 1179},
        {  127, 1651},{  150, 2133},{  173, 2611},{  194, 3050},
        {  222, 3417},{  262, 3733},{  303, 4048},{  337, 4375},
        {  378, 4657},{  420, 4897},{  456, 5148},{  486, 5422},
        {  518, 5682},{  558, 5903},{  592, 6113},{  623, 6372},
        {  662, 6628},{  700, 6833},{  751, 6989},{  805, 7147}
      },
      /*Cb  qi=13  INTER*/
      {
        {   94,  -34},{   78,  303},{   60,  638},{   51,  994},
        {   54, 1406},{   61, 1836},{   73, 2253},{   84, 2668},
        {   92, 3082},{   96, 3492},{   99, 3894},{  101, 4284},
        {  103, 4659},{  105, 5023},{  106, 5376},{  108, 5726},
        {  109, 6070},{  110, 6418},{  113, 6765},{  117, 7105},
        {  119, 7448},{  122, 7784},{  126, 8119},{  131, 8463}
      }
    },
    {
      /*Cr  qi=13  INTRA*/
      {
        {    3,    7},{   43,  375},{   80,  762},{  110, 1226},
        {  131, 1701},{  149, 2166},{  172, 2610},{  196, 2999},
        {  221, 3359},{  254, 3679},{  292, 4005},{  332, 4329},
        {  369, 4612},{  408, 4880},{  456, 5139},{  500, 5388},
        {  544, 5631},{  581, 5877},{  615, 6101},{  660, 6316},
        {  692, 6594},{  714, 6795},{  736, 6997},{  789, 7290}
      },
      /*Cr  qi=13  INTER*/
      {
        {   73,   28},{   61,  336},{   46,  642},{   50, 1003},
        {   58, 1414},{   67, 1832},{   79, 2245},{   87, 2660},
        {   93, 3075},{   97, 3484},{   99, 3888},{  100, 4277},
        {  100, 4651},{  100, 5027},{  101, 5403},{  102, 5765},
        {  105, 6116},{  109, 6470},{  113, 6825},{  119, 7163},
        {  124, 7497},{  127, 7827},{  131, 8137},{  135, 8437}
      }
    }
  },
  {
    {
      /*Y'  qi=14  INTRA*/
      {
        {  113,  -68},{  191, 1545},{  358, 2981},{  559, 4104},
        {  733, 5044},{  896, 5890},{ 1066, 6636},{ 1241, 7304},
        { 1428, 7886},{ 1642, 8402},{ 1872, 8871},{ 2128, 9219},
        { 2380, 9547},{ 2609, 9908},{ 2825,10321},{ 3055,10728},
        { 3294,11076},{ 3523,11425},{ 3766,11689},{ 4013,11845},
        { 4254,12022},{ 4506,12209},{ 4759,12383},{ 5013,12637}
      },
      /*Y'  qi=14  INTER*/
      {
        {   58,  -82},{   38, 1362},{   93, 2914},{  138, 4492},
        {  171, 5962},{  198, 7289},{  216, 8559},{  234, 9804},
        {  263,11005},{  306,12143},{  363,13222},{  434,14259},
        {  523,15255},{  639,16188},{  794,17021},{ 1000,17717},
        { 1262,18260},{ 1575,18645},{ 1943,18841},{ 2356,18872},
        { 2782,18802},{ 3194,18682},{ 3576,18559},{ 3923,18447}
      }
    },
    {
      /*Cb  qi=14  INTRA*/
      {
        {    2,    3},{   50,  367},{   91,  741},{  114, 1180},
        {  134, 1651},{  157, 2131},{  181, 2601},{  208, 3028},
        {  239, 3391},{  279, 3706},{  322, 4000},{  361, 4309},
        {  406, 4587},{  445, 4822},{  482, 5067},{  515, 5344},
        {  546, 5612},{  589, 5821},{  626, 6020},{  655, 6276},
        {  701, 6523},{  748, 6717},{  796, 6876},{  815, 7151}
      },
      /*Cb  qi=14  INTER*/
      {
        {   80,  -43},{   68,  301},{   56,  644},{   50, 1004},
        {   54, 1412},{   63, 1836},{   75, 2253},{   87, 2670},
        {   94, 3083},{   98, 3487},{  101, 3885},{  103, 4271},
        {  106, 4645},{  107, 5004},{  108, 5358},{  109, 5705},
        {  112, 6047},{  115, 6388},{  118, 6731},{  121, 7081},
        {  126, 7421},{  129, 7747},{  132, 8076},{  137, 8419}
      }
    },
    {
      /*Cr  qi=14  INTRA*/
      {
        {    3,    6},{   45,  375},{   85,  762},{  116, 1226},
        {  138, 1700},{  158, 2163},{  180, 2602},{  206, 2985},
        {  236, 3333},{  270, 3639},{  310, 3956},{  359, 4258},
        {  397, 4524},{  430, 4802},{  478, 5068},{  527, 5316},
        {  572, 5560},{  613, 5802},{  654, 6012},{  699, 6216},
        {  734, 6489},{  755, 6707},{  775, 6898},{  841, 7111}
      },
      /*Cr  qi=14  INTER*/
      {
        {   78,    0},{   59,  322},{   46,  649},{   51, 1016},
        {   58, 1422},{   68, 1839},{   81, 2253},{   90, 2666},
        {   95, 3080},{   98, 3486},{  101, 3881},{  102, 4268},
        {  102, 4644},{  103, 5017},{  105, 5382},{  106, 5743},
        {  108, 6093},{  112, 6442},{  118, 6791},{  124, 7130},
        {  127, 7463},{  133, 7784},{  138, 8085},{  142, 8395}
      }
    }
  },
  {
    {
      /*Y'  qi=15  INTRA*/
      {
        {  111,  -66},{  197, 1538},{  370, 2949},{  579, 4050},
        {  762, 4968},{  933, 5798},{ 1112, 6520},{ 1299, 7161},
        { 1497, 7725},{ 1723, 8219},{ 1967, 8654},{ 2234, 8990},
        { 2499, 9302},{ 2740, 9637},{ 2968,10039},{ 3215,10414},
        { 3473,10709},{ 3721,11015},{ 3971,11270},{ 4228,11402},
        { 4487,11543},{ 4752,11707},{ 5011,11871},{ 5290,12099}
      },
      /*Y'  qi=15  INTER*/
      {
        {   59, -113},{   37, 1349},{   95, 2904},{  139, 4478},
        {  174, 5929},{  201, 7244},{  220, 8505},{  241, 9736},
        {  275,10922},{  327,12040},{  395,13097},{  477,14114},
        {  585,15071},{  730,15947},{  917,16714},{ 1162,17326},
        { 1468,17770},{ 1833,18029},{ 2251,18111},{ 2694,18068},
        { 3125,17968},{ 3529,17845},{ 3908,17713},{ 4260,17587}
      }
    },
    {
      /*Cb  qi=15  INTRA*/
      {
        {    2,    3},{   51,  367},{   94,  741},{  120, 1180},
        {  140, 1651},{  160, 2129},{  184, 2591},{  213, 3010},
        {  246, 3371},{  289, 3680},{  335, 3969},{  374, 4274},
        {  418, 4546},{  460, 4783},{  498, 5019},{  532, 5280},
        {  565, 5553},{  608, 5765},{  647, 5958},{  683, 6193},
        {  732, 6433},{  782, 6620},{  832, 6769},{  848, 7027}
      },
      /*Cb  qi=15  INTER*/
      {
        {   71,  -52},{   63,  296},{   54,  644},{   50, 1010},
        {   53, 1417},{   64, 1837},{   77, 2253},{   88, 2666},
        {   95, 3079},{   98, 3487},{  100, 3882},{  103, 4264},
        {  106, 4633},{  108, 4991},{  109, 5343},{  109, 5693},
        {  112, 6038},{  114, 6371},{  119, 6709},{  123, 7051},
        {  125, 7385},{  130, 7716},{  135, 8050},{  140, 8374}
      }
    },
    {
      /*Cr  qi=15  INTRA*/
      {
        {    2,    6},{   47,  375},{   87,  763},{  119, 1225},
        {  143, 1699},{  162, 2158},{  185, 2595},{  213, 2971},
        {  246, 3315},{  279, 3618},{  320, 3920},{  372, 4210},
        {  409, 4480},{  446, 4756},{  496, 5017},{  542, 5263},
        {  590, 5487},{  639, 5721},{  687, 5923},{  724, 6132},
        {  753, 6417},{  781, 6622},{  805, 6806},{  856, 6977}
      },
      /*Cr  qi=15  INTER*/
      {
        {   71,    3},{   61,  326},{   52,  651},{   50, 1017},
        {   58, 1422},{   69, 1837},{   82, 2251},{   90, 2668},
        {   95, 3080},{   98, 3484},{  101, 3877},{  102, 4257},
        {  102, 4632},{  101, 5005},{  103, 5370},{  106, 5733},
        {  110, 6082},{  116, 6424},{  120, 6774},{  124, 7106},
        {  130, 7427},{  135, 7748},{  141, 8052},{  147, 8333}
      }
    }
  },
  {
    {
      /*Y'  qi=16  INTRA*/
      {
        {  114,  -63},{  206, 1525},{  396, 2887},{  618, 3945},
        {  816, 4832},{ 1002, 5626},{ 1196, 6319},{ 1401, 6923},
        { 1616, 7458},{ 1857, 7928},{ 2121, 8334},{ 2405, 8645},
        { 2685, 8934},{ 2938, 9255},{ 3175, 9638},{ 3433, 9990},
        { 3707,10263},{ 3958,10577},{ 4218,10807},{ 4488,10906},
        { 4760,11028},{ 5037,11148},{ 5306,11286},{ 5625,11463}
      },
      /*Y'  qi=16  INTER*/
      {
        {   69, -153},{   39, 1348},{   98, 2894},{  144, 4448},
        {  181, 5872},{  209, 7167},{  228, 8422},{  254, 9644},
        {  297,10810},{  359,11908},{  438,12944},{  539,13930},
        {  672,14842},{  850,15650},{ 1085,16318},{ 1391,16793},
        { 1769,17082},{ 2200,17198},{ 2659,17174},{ 3116,17072},
        { 3547,16948},{ 3943,16819},{ 4299,16701},{ 4611,16644}
      }
    },
    {
      /*Cb  qi=16  INTRA*/
      {
        {    3,    4},{   54,  367},{   97,  742},{  122, 1181},
        {  143, 1651},{  168, 2123},{  197, 2575},{  226, 2985},
        {  263, 3338},{  314, 3631},{  367, 3903},{  409, 4200},
        {  453, 4468},{  491, 4703},{  528, 4932},{  566, 5188},
        {  601, 5459},{  647, 5672},{  693, 5844},{  734, 6058},
        {  784, 6305},{  836, 6460},{  882, 6602},{  905, 6891}
      },
      /*Cb  qi=16  INTER*/
      {
        {   75,  -64},{   67,  292},{   56,  645},{   51, 1016},
        {   54, 1421},{   66, 1842},{   79, 2257},{   89, 2670},
        {   95, 3082},{   98, 3488},{  101, 3879},{  104, 4258},
        {  106, 4623},{  108, 4974},{  109, 5321},{  113, 5664},
        {  116, 6001},{  117, 6341},{  123, 6677},{  128, 7004},
        {  130, 7336},{  136, 7671},{  143, 7996},{  148, 8310}
      }
    },
    {
      /*Cr  qi=16  INTRA*/
      {
        {    4,    7},{   50,  375},{   90,  763},{  124, 1225},
        {  148, 1698},{  168, 2154},{  195, 2582},{  227, 2948},
        {  263, 3279},{  302, 3575},{  343, 3865},{  394, 4137},
        {  439, 4402},{  482, 4672},{  533, 4925},{  579, 5165},
        {  626, 5382},{  675, 5616},{  725, 5812},{  769, 5991},
        {  810, 6242},{  848, 6430},{  868, 6615},{  944, 6732}
      },
      /*Cr  qi=16  INTER*/
      {
        {   78,   11},{   62,  327},{   49,  650},{   50, 1025},
        {   59, 1431},{   72, 1841},{   83, 2253},{   90, 2671},
        {   95, 3084},{   98, 3487},{  100, 3879},{  101, 4254},
        {  102, 4625},{  103, 4994},{  106, 5355},{  108, 5708},
        {  111, 6058},{  115, 6400},{  121, 6733},{  128, 7058},
        {  134, 7374},{  140, 7691},{  146, 7993},{  146, 8317}
      }
    }
  },
  {
    {
      /*Y'  qi=17  INTRA*/
      {
        {  112,  -59},{  210, 1515},{  409, 2850},{  640, 3882},
        {  844, 4748},{ 1038, 5529},{ 1240, 6206},{ 1452, 6803},
        { 1676, 7330},{ 1925, 7792},{ 2194, 8201},{ 2483, 8512},
        { 2766, 8801},{ 3027, 9121},{ 3279, 9482},{ 3548, 9810},
        { 3825,10069},{ 4088,10345},{ 4362,10544},{ 4638,10644},
        { 4915,10744},{ 5196,10850},{ 5471,10981},{ 5802,11136}
      },
      /*Y'  qi=17  INTER*/
      {
        {   70, -147},{   45, 1349},{  106, 2894},{  155, 4425},
        {  195, 5818},{  225, 7099},{  247, 8348},{  278, 9565},
        {  328,10717},{  399,11794},{  491,12807},{  609,13760},
        {  766,14623},{  984,15349},{ 1274,15902},{ 1642,16256},
        { 2082,16411},{ 2563,16409},{ 3048,16315},{ 3508,16194},
        { 3924,16064},{ 4306,15938},{ 4656,15828},{ 4966,15733}
      }
    },
    {
      /*Cb  qi=17  INTRA*/
      {
        {    3,    4},{   57,  367},{  101,  742},{  126, 1182},
        {  148, 1650},{  175, 2118},{  207, 2565},{  241, 2966},
        {  279, 3307},{  331, 3588},{  389, 3845},{  435, 4132},
        {  474, 4408},{  517, 4641},{  560, 4869},{  602, 5122},
        {  638, 5389},{  672, 5610},{  716, 5787},{  758, 6002},
        {  817, 6226},{  869, 6393},{  916, 6530},{  950, 6799}
      },
      /*Cb  qi=17  INTER*/
      {
        {  105,  -65},{   86,  288},{   66,  638},{   54, 1014},
        {   59, 1427},{   71, 1844},{   86, 2257},{   95, 2668},
        {  100, 3075},{  103, 3476},{  106, 3867},{  110, 4241},
        {  112, 4598},{  114, 4948},{  117, 5294},{  121, 5633},
        {  123, 5968},{  126, 6301},{  131, 6637},{  136, 6968},
        {  144, 7287},{  152, 7606},{  158, 7931},{  162, 8262}
      }
    },
    {
      /*Cr  qi=17  INTRA*/
      {
        {    4,    6},{   55,  376},{   97,  765},{  128, 1226},
        {  152, 1696},{  175, 2144},{  204, 2568},{  241, 2928},
        {  282, 3250},{  323, 3530},{  368, 3811},{  420, 4089},
        {  463, 4347},{  505, 4609},{  562, 4860},{  609, 5094},
        {  655, 5303},{  709, 5535},{  759, 5740},{  803, 5913},
        {  844, 6153},{  879, 6350},{  905, 6527},{  972, 6637}
      },
      /*Cr  qi=17  INTER*/
      {
        {   88,    8},{   68,  330},{   51,  653},{   54, 1028},
        {   65, 1433},{   77, 1845},{   89, 2257},{   96, 2669},
        {  100, 3081},{  102, 3481},{  105, 3867},{  106, 4245},
        {  108, 4613},{  110, 4971},{  112, 5328},{  115, 5679},
        {  120, 6019},{  127, 6355},{  133, 6686},{  140, 7007},
        {  149, 7316},{  158, 7618},{  166, 7924},{  170, 8232}
      }
    }
  },
  {
    {
      /*Y'  qi=18  INTRA*/
      {
        {  122,  -58},{  216, 1506},{  425, 2815},{  665, 3822},
        {  882, 4666},{ 1088, 5425},{ 1301, 6084},{ 1529, 6653},
        { 1766, 7162},{ 2026, 7611},{ 2312, 7987},{ 2612, 8278},
        { 2913, 8551},{ 3196, 8840},{ 3454, 9184},{ 3734, 9490},
        { 4030, 9725},{ 4305, 9973},{ 4585,10162},{ 4864,10251},
        { 5150,10324},{ 5443,10420},{ 5727,10536},{ 6053,10682}
      },
      /*Y'  qi=18  INTER*/
      {
        {   66, -143},{   47, 1351},{  108, 2886},{  158, 4401},
        {  200, 5775},{  232, 7044},{  256, 8288},{  292, 9493},
        {  351,10625},{  434,11679},{  541,12665},{  681,13578},
        {  875,14379},{ 1136,15025},{ 1483,15475},{ 1914,15709},
        { 2399,15767},{ 2907,15699},{ 3400,15579},{ 3852,15453},
        { 4259,15332},{ 4630,15221},{ 4976,15121},{ 5294,15061}
      }
    },
    {
      /*Cb  qi=18  INTRA*/
      {
        {    2,    3},{   61,  367},{  107,  743},{  131, 1182},
        {  155, 1648},{  183, 2110},{  220, 2542},{  260, 2927},
        {  303, 3265},{  359, 3540},{  416, 3785},{  462, 4063},
        {  506, 4334},{  553, 4567},{  595, 4797},{  636, 5049},
        {  676, 5304},{  717, 5516},{  759, 5698},{  801, 5904},
        {  861, 6133},{  911, 6311},{  962, 6443},{ 1021, 6645}
      },
      /*Cb  qi=18  INTER*/
      {
        {  126,    5},{   95,  326},{   66,  643},{   55, 1015},
        {   60, 1427},{   73, 1843},{   87, 2256},{   96, 2667},
        {  101, 3073},{  104, 3470},{  108, 3853},{  111, 4226},
        {  114, 4584},{  117, 4928},{  119, 5274},{  122, 5612},
        {  126, 5942},{  130, 6271},{  136, 6606},{  141, 6931},
        {  148, 7247},{  156, 7568},{  164, 7891},{  173, 8211}
      }
    },
    {
      /*Cr  qi=18  INTRA*/
      {
        {    4,    6},{   59,  376},{  104,  765},{  133, 1226},
        {  156, 1692},{  184, 2136},{  218, 2548},{  260, 2893},
        {  308, 3204},{  348, 3481},{  397, 3751},{  448, 4024},
        {  490, 4281},{  541, 4523},{  593, 4776},{  634, 5022},
        {  685, 5236},{  748, 5455},{  812, 5638},{  856, 5818},
        {  891, 6048},{  928, 6230},{  961, 6405},{ 1055, 6449}
      },
      /*Cr  qi=18  INTER*/
      {
        {   81,   34},{   68,  342},{   57,  652},{   59, 1027},
        {   67, 1439},{   80, 1848},{   91, 2257},{   97, 2670},
        {  100, 3076},{  103, 3473},{  106, 3857},{  108, 4231},
        {  109, 4599},{  110, 4958},{  113, 5307},{  119, 5650},
        {  125, 5991},{  130, 6325},{  138, 6651},{  147, 6971},
        {  153, 7278},{  162, 7578},{  172, 7874},{  177, 8156}
      }
    }
  },
  {
    {
      /*Y'  qi=19  INTRA*/
      {
        {  128,  -55},{  228, 1495},{  448, 2775},{  699, 3758},
        {  931, 4571},{ 1154, 5296},{ 1386, 5914},{ 1636, 6450},
        { 1894, 6930},{ 2177, 7342},{ 2479, 7698},{ 2792, 7976},
        { 3099, 8235},{ 3392, 8517},{ 3658, 8853},{ 3938, 9155},
        { 4242, 9371},{ 4527, 9605},{ 4810, 9781},{ 5089, 9853},
        { 5378, 9920},{ 5674,10009},{ 5972,10110},{ 6336,10196}
      },
      /*Y'  qi=19  INTER*/
      {
        {   69, -147},{   49, 1353},{  111, 2883},{  162, 4381},
        {  205, 5737},{  237, 6996},{  264, 8232},{  307, 9421},
        {  376,10534},{  472,11567},{  596,12525},{  761,13395},
        {  990,14130},{ 1298,14694},{ 1695,15053},{ 2172,15195},
        { 2696,15173},{ 3213,15075},{ 3696,14948},{ 4141,14829},
        { 4541,14721},{ 4910,14609},{ 5245,14506},{ 5536,14399}
      }
    },
    {
      /*Cb  qi=19  INTRA*/
      {
        {    3,    3},{   61,  367},{  109,  743},{  135, 1182},
        {  161, 1646},{  191, 2101},{  229, 2524},{  273, 2898},
        {  318, 3221},{  376, 3490},{  436, 3731},{  487, 3994},
        {  539, 4251},{  584, 4485},{  621, 4721},{  664, 4967},
        {  709, 5225},{  752, 5431},{  801, 5595},{  846, 5796},
        {  912, 6011},{  959, 6193},{ 1015, 6321},{ 1121, 6504}
      },
      /*Cb  qi=19  INTER*/
      {
        {  126,    4},{   97,  329},{   69,  649},{   56, 1017},
        {   61, 1432},{   74, 1846},{   88, 2255},{   98, 2663},
        {  103, 3065},{  106, 3460},{  110, 3844},{  114, 4211},
        {  117, 4564},{  120, 4911},{  122, 5253},{  125, 5588},
        {  129, 5916},{  135, 6241},{  142, 6567},{  149, 6885},
        {  155, 7206},{  163, 7527},{  174, 7843},{  188, 8145}
      }
    },
    {
      /*Cr  qi=19  INTRA*/
      {
        {    5,    6},{   61,  376},{  106,  765},{  135, 1225},
        {  160, 1689},{  192, 2126},{  229, 2531},{  271, 2869},
        {  321, 3168},{  370, 3433},{  421, 3704},{  476, 3965},
        {  520, 4212},{  572, 4452},{  629, 4691},{  671, 4939},
        {  724, 5152},{  792, 5347},{  858, 5510},{  895, 5696},
        {  939, 5905},{  991, 6056},{ 1027, 6244},{ 1127, 6333}
      },
      /*Cr  qi=19  INTER*/
      {
        {   80,   45},{   66,  344},{   55,  654},{   56, 1030},
        {   66, 1440},{   80, 1850},{   91, 2259},{   98, 2668},
        {  102, 3072},{  104, 3466},{  107, 3845},{  109, 4215},
        {  110, 4578},{  112, 4933},{  116, 5283},{  122, 5625},
        {  129, 5963},{  136, 6287},{  143, 6611},{  151, 6927},
        {  160, 7229},{  170, 7528},{  181, 7818},{  191, 8092}
      }
    }
  },
  {
    {
      /*Y'  qi=20  INTRA*/
      {
        {  129,  -50},{  238, 1481},{  469, 2728},{  730, 3684},
        {  974, 4473},{ 1213, 5171},{ 1463, 5763},{ 1729, 6281},
        { 2002, 6744},{ 2299, 7146},{ 2613, 7492},{ 2940, 7746},
        { 3265, 7978},{ 3571, 8228},{ 3853, 8543},{ 4156, 8815},
        { 4476, 9001},{ 4775, 9218},{ 5070, 9373},{ 5352, 9446},
        { 5649, 9510},{ 5956, 9580},{ 6268, 9660},{ 6647, 9705}
      },
      /*Y'  qi=20  INTER*/
      {
        {   64,  -93},{   52, 1340},{  116, 2862},{  170, 4344},
        {  216, 5678},{  249, 6928},{  281, 8155},{  333, 9326},
        {  418,10410},{  533,11411},{  683,12329},{  890,13127},
        { 1183,13750},{ 1579,14162},{ 2066,14357},{ 2611,14370},
        { 3159,14284},{ 3675,14167},{ 4142,14053},{ 4568,13953},
        { 4961,13852},{ 5320,13755},{ 5649,13675},{ 5933,13610}
      }
    },
    {
      /*Cb  qi=20  INTRA*/
      {
        {    3,    3},{   62,  367},{  112,  743},{  140, 1183},
        {  165, 1646},{  196, 2099},{  235, 2517},{  284, 2883},
        {  334, 3198},{  393, 3460},{  457, 3690},{  509, 3945},
        {  560, 4198},{  605, 4435},{  647, 4658},{  699, 4888},
        {  742, 5155},{  788, 5350},{  835, 5517},{  880, 5730},
        {  956, 5914},{ 1007, 6060},{ 1053, 6199},{ 1158, 6358}
      },
      /*Cb  qi=20  INTER*/
      {
        {  128,   -6},{   96,  322},{   66,  653},{   54, 1025},
        {   63, 1431},{   79, 1844},{   91, 2256},{   99, 2665},
        {  104, 3065},{  107, 3455},{  111, 3831},{  115, 4189},
        {  120, 4539},{  123, 4885},{  126, 5219},{  130, 5548},
        {  135, 5876},{  141, 6199},{  149, 6519},{  156, 6837},
        {  166, 7153},{  179, 7468},{  189, 7784},{  194, 8102}
      }
    },
    {
      /*Cr  qi=20  INTRA*/
      {
        {    4,    6},{   63,  376},{  109,  765},{  139, 1225},
        {  165, 1689},{  199, 2124},{  239, 2523},{  285, 2852},
        {  340, 3140},{  388, 3398},{  438, 3662},{  499, 3914},
        {  547, 4155},{  596, 4392},{  652, 4634},{  699, 4877},
        {  759, 5074},{  824, 5257},{  883, 5428},{  936, 5589},
        {  986, 5790},{ 1030, 5960},{ 1074, 6119},{ 1172, 6191}
      },
      /*Cr  qi=20  INTER*/
      {
        {   92,   40},{   70,  345},{   55,  658},{   57, 1034},
        {   69, 1441},{   84, 1852},{   94, 2261},{   98, 2669},
        {  102, 3074},{  105, 3465},{  107, 3841},{  110, 4206},
        {  112, 4562},{  116, 4915},{  121, 5260},{  127, 5591},
        {  134, 5920},{  142, 6246},{  153, 6562},{  163, 6870},
        {  173, 7170},{  186, 7463},{  198, 7746},{  199, 8030}
      }
    }
  },
  {
    {
      /*Y'  qi=21  INTRA*/
      {
        {  130,  -51},{  244, 1476},{  483, 2705},{  756, 3635},
        { 1013, 4396},{ 1266, 5070},{ 1530, 5647},{ 1806, 6153},
        { 2093, 6600},{ 2411, 6976},{ 2739, 7299},{ 3079, 7534},
        { 3422, 7744},{ 3738, 7987},{ 4032, 8274},{ 4348, 8533},
        { 4675, 8721},{ 4989, 8909},{ 5291, 9051},{ 5577, 9111},
        { 5879, 9163},{ 6190, 9228},{ 6506, 9286},{ 6899, 9295}
      },
      /*Y'  qi=21  INTER*/
      {
        {   64,  -56},{   55, 1341},{  119, 2859},{  174, 4324},
        {  223, 5640},{  258, 6880},{  295, 8096},{  359, 9246},
        {  460,10302},{  595,11268},{  778,12131},{ 1032,12857},
        { 1387,13385},{ 1850,13683},{ 2399,13774},{ 2976,13729},
        { 3527,13619},{ 4034,13504},{ 4492,13401},{ 4912,13291},
        { 5298,13209},{ 5648,13137},{ 5974,13046},{ 6308,12977}
      }
    },
    {
      /*Cb  qi=21  INTRA*/
      {
        {    4,    3},{   64,  367},{  114,  743},{  141, 1183},
        {  166, 1645},{  201, 2092},{  247, 2502},{  299, 2856},
        {  352, 3158},{  413, 3412},{  480, 3642},{  536, 3893},
        {  588, 4137},{  637, 4367},{  678, 4598},{  725, 4834},
        {  774, 5083},{  827, 5269},{  883, 5420},{  930, 5633},
        {  999, 5829},{ 1057, 5959},{ 1113, 6082},{ 1200, 6265}
      },
      /*Cb  qi=21  INTER*/
      {
        {  109,   -8},{   84,  321},{   62,  654},{   54, 1028},
        {   64, 1434},{   80, 1847},{   92, 2259},{  100, 2664},
        {  105, 3060},{  109, 3445},{  114, 3815},{  118, 4172},
        {  122, 4519},{  126, 4861},{  128, 5194},{  133, 5520},
        {  139, 5847},{  146, 6169},{  155, 6487},{  166, 6801},
        {  177, 7114},{  189, 7423},{  201, 7729},{  208, 8035}
      }
    },
    {
      /*Cr  qi=21  INTRA*/
      {
        {    4,    6},{   64,  377},{  111,  766},{  144, 1225},
        {  174, 1683},{  206, 2114},{  248, 2506},{  302, 2824},
        {  357, 3099},{  404, 3357},{  455, 3622},{  519, 3867},
        {  573, 4098},{  625, 4331},{  683, 4571},{  733, 4802},
        {  793, 4994},{  863, 5173},{  926, 5337},{  978, 5492},
        { 1030, 5685},{ 1079, 5856},{ 1126, 6027},{ 1217, 6159}
      },
      /*Cr  qi=21  INTER*/
      {
        {   82,   29},{   67,  341},{   55,  660},{   58, 1038},
        {   71, 1443},{   85, 1851},{   95, 2258},{   99, 2666},
        {  103, 3069},{  107, 3456},{  110, 3826},{  112, 4188},
        {  114, 4544},{  118, 4891},{  124, 5231},{  132, 5567},
        {  139, 5894},{  148, 6210},{  159, 6520},{  171, 6822},
        {  185, 7111},{  196, 7403},{  209, 7691},{  225, 7945}
      }
    }
  },
  {
    {
      /*Y'  qi=22  INTRA*/
      {
        {  128,  -45},{  254, 1463},{  507, 2662},{  794, 3562},
        { 1070, 4292},{ 1340, 4941},{ 1622, 5492},{ 1920, 5968},
        { 2229, 6387},{ 2565, 6742},{ 2911, 7047},{ 3263, 7264},
        { 3615, 7464},{ 3944, 7689},{ 4258, 7950},{ 4591, 8183},
        { 4934, 8347},{ 5259, 8517},{ 5573, 8634},{ 5870, 8683},
        { 6186, 8723},{ 6508, 8762},{ 6831, 8801},{ 7232, 8830}
      },
      /*Y'  qi=22  INTER*/
      {
        {   77,  -48},{   57, 1343},{  122, 2853},{  180, 4299},
        {  231, 5597},{  269, 6826},{  314, 8025},{  393, 9150},
        {  512,10179},{  673,11103},{  894,11908},{ 1207,12542},
        { 1635,12956},{ 2166,13148},{ 2755,13167},{ 3345,13088},
        { 3895,12966},{ 4386,12848},{ 4832,12746},{ 5252,12647},
        { 5634,12563},{ 5978,12497},{ 6299,12412},{ 6633,12338}
      }
    },
    {
      /*Cb  qi=22  INTRA*/
      {
        {    4,    3},{   66,  367},{  122,  744},{  153, 1182},
        {  177, 1640},{  213, 2080},{  263, 2475},{  323, 2811},
        {  382, 3103},{  451, 3346},{  522, 3568},{  581, 3814},
        {  633, 4054},{  674, 4288},{  719, 4523},{  768, 4756},
        {  823, 4979},{  883, 5162},{  937, 5325},{  996, 5510},
        { 1070, 5687},{ 1129, 5807},{ 1193, 5929},{ 1311, 6099}
      },
      /*Cb  qi=22  INTER*/
      {
        {  107,   -5},{   83,  322},{   61,  653},{   55, 1030},
        {   66, 1436},{   81, 1845},{   94, 2253},{  102, 2656},
        {  107, 3050},{  111, 3435},{  115, 3804},{  119, 4158},
        {  124, 4501},{  128, 4835},{  132, 5164},{  138, 5490},
        {  146, 5812},{  154, 6128},{  163, 6442},{  174, 6754},
        {  188, 7060},{  205, 7361},{  219, 7662},{  233, 7953}
      }
    },
    {
      /*Cr  qi=22  INTRA*/
      {
        {    4,    6},{   67,  378},{  118,  767},{  151, 1222},
        {  182, 1675},{  221, 2097},{  269, 2476},{  329, 2774},
        {  389, 3039},{  444, 3292},{  500, 3545},{  560, 3788},
        {  615, 4020},{  671, 4251},{  734, 4484},{  781, 4712},
        {  850, 4887},{  925, 5060},{  981, 5229},{ 1031, 5369},
        { 1092, 5549},{ 1148, 5715},{ 1200, 5861},{ 1291, 5943}
      },
      /*Cr  qi=22  INTER*/
      {
        {   88,   34},{   69,  340},{   57,  657},{   60, 1039},
        {   73, 1445},{   87, 1851},{   96, 2257},{  100, 2662},
        {  103, 3058},{  107, 3442},{  111, 3812},{  115, 4172},
        {  118, 4524},{  123, 4864},{  129, 5199},{  136, 5531},
        {  145, 5855},{  156, 6168},{  170, 6468},{  184, 6765},
        {  193, 7066},{  207, 7353},{  222, 7628},{  230, 7900}
      }
    }
  },
  {
    {
      /*Y'  qi=23  INTRA*/
      {
        {  126,  -40},{  257, 1458},{  521, 2636},{  825, 3501},
        { 1111, 4207},{ 1391, 4842},{ 1684, 5385},{ 1992, 5858},
        { 2311, 6277},{ 2653, 6626},{ 3005, 6929},{ 3366, 7134},
        { 3729, 7311},{ 4071, 7526},{ 4396, 7770},{ 4734, 7986},
        { 5086, 8131},{ 5421, 8286},{ 5735, 8404},{ 6033, 8456},
        { 6357, 8486},{ 6682, 8525},{ 7003, 8573},{ 7387, 8604}
      },
      /*Y'  qi=23  INTER*/
      {
        {   64,  -57},{   60, 1345},{  124, 2853},{  185, 4284},
        {  239, 5565},{  282, 6783},{  336, 7967},{  429, 9069},
        {  568,10063},{  758,10943},{ 1028,11679},{ 1407,12216},
        { 1909,12520},{ 2502,12616},{ 3126,12573},{ 3722,12461},
        { 4258,12344},{ 4742,12236},{ 5185,12136},{ 5590,12052},
        { 5970,11980},{ 6315,11901},{ 6631,11826},{ 6954,11769}
      }
    },
    {
      /*Cb  qi=23  INTRA*/
      {
        {    3,    3},{   70,  367},{  124,  744},{  151, 1182},
        {  181, 1637},{  222, 2071},{  276, 2460},{  343, 2785},
        {  403, 3072},{  468, 3317},{  542, 3534},{  605, 3773},
        {  659, 4009},{  703, 4243},{  747, 4479},{  795, 4707},
        {  852, 4923},{  908, 5105},{  972, 5254},{ 1043, 5423},
        { 1118, 5594},{ 1172, 5731},{ 1240, 5853},{ 1365, 6005}
      },
      /*Cb  qi=23  INTER*/
      {
        {  109,  -10},{   87,  325},{   63,  650},{   57, 1031},
        {   67, 1439},{   83, 1847},{   96, 2253},{  103, 2652},
        {  109, 3041},{  114, 3421},{  117, 3789},{  122, 4141},
        {  128, 4480},{  134, 4811},{  139, 5138},{  144, 5463},
        {  152, 5781},{  161, 6096},{  174, 6404},{  185, 6714},
        {  198, 7023},{  216, 7320},{  233, 7621},{  245, 7935}
      }
    },
    {
      /*Cr  qi=23  INTRA*/
      {
        {    5,    6},{   70,  379},{  122,  768},{  155, 1222},
        {  187, 1671},{  231, 2088},{  283, 2459},{  346, 2750},
        {  411, 3009},{  465, 3261},{  523, 3509},{  585, 3746},
        {  639, 3980},{  695, 4219},{  754, 4449},{  803, 4671},
        {  873, 4840},{  953, 5001},{ 1015, 5156},{ 1071, 5286},
        { 1137, 5464},{ 1191, 5629},{ 1249, 5782},{ 1359, 5885}
      },
      /*Cr  qi=23  INTER*/
      {
        {   84,   29},{   69,  343},{   58,  660},{   62, 1041},
        {   75, 1448},{   88, 1853},{   97, 2258},{  102, 2659},
        {  105, 3050},{  108, 3430},{  113, 3799},{  116, 4155},
        {  121, 4505},{  126, 4845},{  132, 5176},{  142, 5504},
        {  153, 5826},{  165, 6133},{  180, 6432},{  197, 6722},
        {  212, 7005},{  226, 7287},{  244, 7555},{  258, 7828}
      }
    }
  },
  {
    {
      /*Y'  qi=24  INTRA*/
      {
        {  125,  -34},{  268, 1444},{  547, 2590},{  866, 3422},
        { 1172, 4098},{ 1476, 4702},{ 1790, 5222},{ 2117, 5678},
        { 2453, 6080},{ 2811, 6418},{ 3178, 6700},{ 3552, 6895},
        { 3928, 7055},{ 4286, 7243},{ 4627, 7477},{ 4981, 7674},
        { 5344, 7802},{ 5683, 7944},{ 6009, 8043},{ 6313, 8082},
        { 6633, 8111},{ 6959, 8151},{ 7280, 8197},{ 7660, 8221}
      },
      /*Y'  qi=24  INTER*/
      {
        {   62,  -63},{   68, 1345},{  134, 2840},{  199, 4245},
        {  256, 5508},{  304, 6715},{  371, 7880},{  484, 8950},
        {  652, 9899},{  892,10709},{ 1238,11334},{ 1722,11722},
        { 2326,11875},{ 2983,11864},{ 3616,11783},{ 4189,11678},
        { 4707,11570},{ 5178,11476},{ 5617,11395},{ 6017,11319},
        { 6380,11252},{ 6720,11185},{ 7044,11126},{ 7377,11118}
      }
    },
    {
      /*Cb  qi=24  INTRA*/
      {
        {    4,    3},{   75,  367},{  132,  745},{  159, 1182},
        {  187, 1634},{  230, 2061},{  289, 2439},{  361, 2753},
        {  425, 3034},{  492, 3278},{  566, 3490},{  630, 3720},
        {  686, 3956},{  732, 4190},{  777, 4420},{  829, 4637},
        {  894, 4840},{  958, 5012},{ 1023, 5155},{ 1090, 5326},
        { 1165, 5502},{ 1226, 5622},{ 1299, 5717},{ 1408, 5887}
      },
      /*Cb  qi=24  INTER*/
      {
        {  110,   35},{   92,  337},{   70,  651},{   63, 1033},
        {   74, 1440},{   91, 1846},{  102, 2248},{  109, 2644},
        {  114, 3031},{  120, 3404},{  127, 3762},{  133, 4109},
        {  138, 4445},{  144, 4772},{  151, 5094},{  159, 5411},
        {  168, 5728},{  180, 6037},{  195, 6338},{  210, 6640},
        {  227, 6944},{  249, 7236},{  272, 7528},{  299, 7809}
      }
    },
    {
      /*Cr  qi=24  INTRA*/
      {
        {    5,    6},{   72,  380},{  124,  770},{  158, 1222},
        {  195, 1668},{  240, 2079},{  297, 2438},{  367, 2715},
        {  433, 2966},{  488, 3218},{  549, 3467},{  609, 3701},
        {  664, 3935},{  728, 4165},{  792, 4379},{  845, 4586},
        {  917, 4744},{  995, 4898},{ 1063, 5049},{ 1120, 5187},
        { 1190, 5359},{ 1249, 5522},{ 1304, 5672},{ 1397, 5806}
      },
      /*Cr  qi=24  INTER*/
      {
        {   91,   56},{   73,  353},{   61,  664},{   66, 1045},
        {   80, 1449},{   95, 1851},{  103, 2250},{  107, 2648},
        {  111, 3038},{  116, 3413},{  120, 3774},{  124, 4128},
        {  130, 4471},{  138, 4802},{  145, 5130},{  156, 5453},
        {  171, 5764},{  187, 6061},{  204, 6355},{  220, 6643},
        {  238, 6923},{  254, 7204},{  275, 7475},{  289, 7752}
      }
    }
  },
  {
    {
      /*Y'  qi=25  INTRA*/
      {
        {  125,  -28},{  285, 1426},{  582, 2540},{  917, 3351},
        { 1244, 3997},{ 1569, 4570},{ 1903, 5071},{ 2258, 5498},
        { 2626, 5866},{ 3002, 6182},{ 3382, 6448},{ 3770, 6623},
        { 4162, 6760},{ 4528, 6934},{ 4882, 7144},{ 5249, 7328},
        { 5610, 7453},{ 5958, 7578},{ 6291, 7672},{ 6597, 7708},
        { 6928, 7715},{ 7258, 7737},{ 7575, 7781},{ 7950, 7829}
      },
      /*Y'  qi=25  INTER*/
      {
        {   64,  -16},{   72, 1348},{  139, 2832},{  206, 4218},
        {  268, 5465},{  322, 6659},{  403, 7803},{  540, 8838},
        {  747, 9734},{ 1044,10465},{ 1473,10981},{ 2048,11249},
        { 2717,11311},{ 3397,11257},{ 4025,11161},{ 4589,11052},
        { 5099,10947},{ 5560,10859},{ 5989,10786},{ 6389,10717},
        { 6753,10652},{ 7078,10592},{ 7389,10535},{ 7697,10460}
      }
    },
    {
      /*Cb  qi=25  INTRA*/
      {
        {    3,    3},{   78,  368},{  133,  745},{  159, 1180},
        {  193, 1627},{  242, 2046},{  304, 2411},{  381, 2714},
        {  456, 2983},{  527, 3224},{  598, 3437},{  667, 3655},
        {  726, 3888},{  776, 4117},{  826, 4333},{  883, 4543},
        {  954, 4727},{ 1019, 4878},{ 1095, 5014},{ 1171, 5187},
        { 1255, 5342},{ 1319, 5458},{ 1396, 5546},{ 1536, 5678}
      },
      /*Cb  qi=25  INTER*/
      {
        {  117,   32},{   89,  342},{   67,  660},{   64, 1037},
        {   77, 1441},{   93, 1845},{  105, 2243},{  113, 2633},
        {  120, 3016},{  125, 3387},{  131, 3739},{  137, 4080},
        {  144, 4416},{  152, 4741},{  160, 5057},{  169, 5369},
        {  180, 5680},{  193, 5990},{  209, 6294},{  227, 6594},
        {  249, 6888},{  269, 7180},{  294, 7467},{  317, 7768}
      }
    },
    {
      /*Cr  qi=25  INTRA*/
      {
        {    6,    6},{   74,  380},{  129,  770},{  165, 1220},
        {  201, 1658},{  253, 2061},{  315, 2410},{  388, 2676},
        {  462, 2920},{  523, 3166},{  584, 3404},{  647, 3637},
        {  701, 3870},{  769, 4086},{  838, 4296},{  898, 4491},
        {  980, 4627},{ 1065, 4759},{ 1126, 4920},{ 1187, 5058},
        { 1283, 5180},{ 1347, 5332},{ 1404, 5475},{ 1527, 5534}
      },
      /*Cr  qi=25  INTER*/
      {
        {   92,   41},{   75,  347},{   64,  664},{   70, 1045},
        {   85, 1448},{   98, 1849},{  105, 2245},{  110, 2637},
        {  115, 3023},{  120, 3395},{  126, 3753},{  131, 4102},
        {  136, 4439},{  145, 4768},{  156, 5094},{  168, 5410},
        {  184, 5717},{  203, 6010},{  221, 6300},{  239, 6577},
        {  262, 6847},{  282, 7123},{  303, 7390},{  322, 7665}
      }
    }
  },
  {
    {
      /*Y'  qi=26  INTRA*/
      {
        {  130,  -24},{  292, 1423},{  594, 2525},{  943, 3307},
        { 1289, 3921},{ 1633, 4467},{ 1991, 4943},{ 2368, 5348},
        { 2753, 5696},{ 3148, 5991},{ 3545, 6247},{ 3942, 6415},
        { 4342, 6535},{ 4726, 6690},{ 5093, 6883},{ 5466, 7047},
        { 5840, 7159},{ 6202, 7274},{ 6545, 7351},{ 6855, 7375},
        { 7186, 7384},{ 7517, 7416},{ 7840, 7447},{ 8238, 7450}
      },
      /*Y'  qi=26  INTER*/
      {
        {   52,   16},{   75, 1336},{  143, 2815},{  213, 4191},
        {  278, 5427},{  339, 6611},{  436, 7734},{  600, 8732},
        {  843, 9579},{ 1195,10243},{ 1702,10660},{ 2355,10825},
        { 3070,10820},{ 3755,10743},{ 4372,10643},{ 4925,10538},
        { 5426,10440},{ 5882,10354},{ 6296,10290},{ 6686,10224},
        { 7049,10163},{ 7380,10113},{ 7672,10062},{ 7937,10021}
      }
    },
    {
      /*Cb  qi=26  INTRA*/
      {
        {    4,    3},{   79,  368},{  138,  745},{  167, 1180},
        {  200, 1623},{  252, 2034},{  322, 2389},{  403, 2682},
        {  480, 2941},{  558, 3176},{  631, 3393},{  700, 3608},
        {  766, 3825},{  819, 4046},{  868, 4265},{  926, 4472},
        { 1002, 4645},{ 1070, 4800},{ 1151, 4924},{ 1242, 5063},
        { 1325, 5221},{ 1393, 5338},{ 1464, 5431},{ 1595, 5559}
      },
      /*Cb  qi=26  INTER*/
      {
        {   98,   33},{   83,  343},{   65,  662},{   65, 1037},
        {   80, 1437},{   96, 1839},{  107, 2238},{  115, 2628},
        {  122, 3007},{  128, 3373},{  134, 3722},{  142, 4060},
        {  149, 4390},{  158, 4713},{  167, 5029},{  178, 5341},
        {  191, 5647},{  208, 5948},{  227, 6244},{  247, 6539},
        {  269, 6833},{  295, 7114},{  328, 7388},{  369, 7658}
      }
    },
    {
      /*Cr  qi=26  INTRA*/
      {
        {    5,    6},{   75,  380},{  133,  769},{  172, 1217},
        {  212, 1652},{  266, 2048},{  333, 2384},{  412, 2643},
        {  490, 2880},{  552, 3124},{  616, 3365},{  681, 3594},
        {  739, 3816},{  810, 4024},{  880, 4224},{  945, 4405},
        { 1029, 4538},{ 1114, 4674},{ 1183, 4822},{ 1254, 4946},
        { 1346, 5063},{ 1417, 5201},{ 1478, 5345},{ 1597, 5411}
      },
      /*Cr  qi=26  INTER*/
      {
        {   97,   29},{   75,  342},{   62,  667},{   70, 1047},
        {   87, 1447},{  100, 1846},{  107, 2242},{  113, 2633},
        {  118, 3016},{  123, 3382},{  128, 3737},{  135, 4082},
        {  142, 4417},{  151, 4746},{  162, 5066},{  176, 5377},
        {  194, 5679},{  217, 5963},{  239, 6244},{  260, 6522},
        {  284, 6789},{  309, 7052},{  335, 7313},{  355, 7582}
      }
    }
  },
  {
    {
      /*Y'  qi=27  INTRA*/
      {
        {  118,  -10},{  308, 1404},{  630, 2473},{  997, 3227},
        { 1360, 3819},{ 1719, 4354},{ 2086, 4829},{ 2470, 5233},
        { 2863, 5576},{ 3267, 5870},{ 3677, 6117},{ 4085, 6268},
        { 4499, 6376},{ 4888, 6521},{ 5257, 6705},{ 5638, 6865},
        { 6020, 6962},{ 6394, 7056},{ 6744, 7130},{ 7051, 7158},
        { 7386, 7164},{ 7717, 7185},{ 8042, 7209},{ 8444, 7206}
      },
      /*Y'  qi=27  INTER*/
      {
        {   54,   19},{   77, 1333},{  147, 2806},{  221, 4166},
        {  290, 5390},{  360, 6564},{  474, 7665},{  664, 8630},
        {  949, 9423},{ 1370,10002},{ 1958,10323},{ 2670,10414},
        { 3406,10375},{ 4086,10285},{ 4691,10182},{ 5233,10085},
        { 5724, 9994},{ 6169, 9918},{ 6582, 9863},{ 6962, 9813},
        { 7316, 9759},{ 7645, 9707},{ 7948, 9660},{ 8262, 9623}
      }
    },
    {
      /*Cb  qi=27  INTRA*/
      {
        {    4,    3},{   79,  368},{  137,  745},{  166, 1180},
        {  200, 1622},{  253, 2030},{  324, 2381},{  407, 2671},
        {  487, 2925},{  567, 3156},{  640, 3372},{  712, 3580},
        {  782, 3792},{  833, 4015},{  887, 4227},{  954, 4422},
        { 1031, 4592},{ 1103, 4738},{ 1187, 4856},{ 1280, 4990},
        { 1371, 5135},{ 1442, 5244},{ 1520, 5321},{ 1684, 5398}
      },
      /*Cb  qi=27  INTER*/
      {
        {  113,   20},{   90,  338},{   66,  661},{   67, 1034},
        {   82, 1438},{   97, 1842},{  108, 2238},{  115, 2624},
        {  123, 3000},{  130, 3361},{  138, 3708},{  146, 4040},
        {  155, 4367},{  164, 4688},{  174, 4999},{  186, 5306},
        {  203, 5609},{  222, 5908},{  243, 6202},{  268, 6494},
        {  295, 6781},{  326, 7058},{  367, 7319},{  420, 7551}
      }
    },
    {
      /*Cr  qi=27  INTRA*/
      {
        {    5,    6},{   75,  380},{  133,  770},{  173, 1217},
        {  214, 1650},{  268, 2040},{  337, 2375},{  418, 2631},
        {  496, 2862},{  558, 3104},{  625, 3346},{  692, 3571},
        {  753, 3786},{  825, 3989},{  896, 4182},{  969, 4352},
        { 1059, 4479},{ 1144, 4614},{ 1212, 4757},{ 1284, 4871},
        { 1380, 4982},{ 1457, 5125},{ 1528, 5267},{ 1651, 5346}
      },
      /*Cr  qi=27  INTER*/
      {
        {   92,   24},{   74,  341},{   61,  669},{   71, 1049},
        {   88, 1448},{  100, 1849},{  107, 2243},{  113, 2631},
        {  119, 3010},{  125, 3373},{  131, 3723},{  137, 4064},
        {  146, 4396},{  159, 4720},{  172, 5033},{  189, 5340},
        {  210, 5636},{  233, 5920},{  256, 6197},{  282, 6465},
        {  310, 6730},{  332, 7000},{  359, 7259},{  385, 7515}
      }
    }
  },
  {
    {
      /*Y'  qi=28  INTRA*/
      {
        {  116,   -8},{  314, 1400},{  640, 2458},{ 1013, 3197},
        { 1386, 3768},{ 1762, 4279},{ 2151, 4733},{ 2558, 5117},
        { 2970, 5442},{ 3393, 5714},{ 3820, 5935},{ 4243, 6069},
        { 4671, 6161},{ 5074, 6289},{ 5456, 6457},{ 5849, 6598},
        { 6244, 6689},{ 6632, 6777},{ 6984, 6833},{ 7294, 6855},
        { 7625, 6862},{ 7961, 6875},{ 8302, 6890},{ 8720, 6883}
      },
      /*Y'  qi=28  INTER*/
      {
        {   54,    8},{   81, 1333},{  154, 2793},{  231, 4138},
        {  304, 5352},{  384, 6512},{  519, 7585},{  743, 8508},
        { 1082, 9236},{ 1587, 9717},{ 2267, 9928},{ 3034, 9944},
        { 3775, 9878},{ 4438, 9786},{ 5031, 9686},{ 5563, 9601},
        { 6042, 9523},{ 6481, 9456},{ 6890, 9405},{ 7266, 9356},
        { 7614, 9313},{ 7933, 9265},{ 8238, 9220},{ 8545, 9193}
      }
    },
    {
      /*Cb  qi=28  INTRA*/
      {
        {    3,    3},{   80,  368},{  138,  746},{  168, 1179},
        {  208, 1615},{  268, 2014},{  345, 2354},{  432, 2637},
        {  515, 2884},{  595, 3108},{  669, 3323},{  745, 3533},
        {  818, 3740},{  876, 3953},{  932, 4160},{ 1003, 4349},
        { 1088, 4501},{ 1154, 4648},{ 1241, 4768},{ 1349, 4889},
        { 1441, 5023},{ 1524, 5113},{ 1611, 5187},{ 1783, 5283}
      },
      /*Cb  qi=28  INTER*/
      {
        {  117,   29},{   91,  341},{   65,  663},{   68, 1038},
        {   85, 1440},{  100, 1841},{  110, 2234},{  119, 2616},
        {  127, 2985},{  135, 3342},{  142, 3685},{  151, 4015},
        {  162, 4337},{  174, 4652},{  186, 4960},{  201, 5264},
        {  218, 5567},{  239, 5863},{  266, 6149},{  295, 6434},
        {  328, 6715},{  371, 6976},{  409, 7239},{  460, 7477}
      }
    },
    {
      /*Cr  qi=28  INTRA*/
      {
        {    6,    7},{   79,  381},{  138,  771},{  178, 1215},
        {  222, 1644},{  285, 2026},{  359, 2347},{  441, 2597},
        {  521, 2827},{  588, 3066},{  655, 3303},{  725, 3523},
        {  791, 3728},{  870, 3920},{  950, 4103},{ 1030, 4265},
        { 1121, 4388},{ 1198, 4520},{ 1266, 4659},{ 1356, 4759},
        { 1461, 4865},{ 1540, 4993},{ 1619, 5115},{ 1786, 5160}
      },
      /*Cr  qi=28  INTER*/
      {
        {   96,   18},{   78,  340},{   66,  672},{   74, 1051},
        {   90, 1450},{  103, 1845},{  110, 2235},{  116, 2619},
        {  122, 2995},{  129, 3356},{  137, 3702},{  146, 4038},
        {  156, 4365},{  168, 4684},{  182, 4995},{  203, 5297},
        {  227, 5588},{  253, 5866},{  282, 6131},{  311, 6394},
        {  339, 6664},{  366, 6918},{  400, 7171},{  424, 7450}
      }
    }
  },
  {
    {
      /*Y'  qi=29  INTRA*/
      {
        {  112,    7},{  334, 1382},{  681, 2410},{ 1081, 3112},
        { 1484, 3650},{ 1894, 4128},{ 2316, 4547},{ 2749, 4905},
        { 3188, 5208},{ 3634, 5458},{ 4079, 5666},{ 4517, 5791},
        { 4952, 5870},{ 5359, 5983},{ 5754, 6137},{ 6165, 6268},
        { 6568, 6351},{ 6958, 6423},{ 7320, 6471},{ 7638, 6490},
        { 7979, 6490},{ 8313, 6499},{ 8651, 6517},{ 9085, 6499}
      },
      /*Y'  qi=29  INTER*/
      {
        {   55,   15},{   85, 1336},{  160, 2780},{  242, 4104},
        {  323, 5302},{  418, 6443},{  586, 7480},{  859, 8342},
        { 1278, 8982},{ 1888, 9347},{ 2658, 9457},{ 3457, 9425},
        { 4192, 9343},{ 4842, 9247},{ 5417, 9162},{ 5935, 9086},
        { 6404, 9011},{ 6841, 8952},{ 7241, 8907},{ 7609, 8867},
        { 7953, 8832},{ 8267, 8792},{ 8562, 8740},{ 8836, 8701}
      }
    },
    {
      /*Cb  qi=29  INTRA*/
      {
        {    5,    3},{   84,  368},{  144,  746},{  176, 1175},
        {  219, 1604},{  285, 1991},{  372, 2318},{  462, 2591},
        {  546, 2833},{  628, 3058},{  704, 3274},{  788, 3473},
        {  870, 3664},{  935, 3865},{  995, 4059},{ 1072, 4239},
        { 1167, 4388},{ 1248, 4518},{ 1334, 4634},{ 1429, 4765},
        { 1536, 4884},{ 1628, 4964},{ 1716, 5038},{ 1885, 5128}
      },
      /*Cb  qi=29  INTER*/
      {
        {  126,   25},{   95,  340},{   69,  662},{   71, 1039},
        {   88, 1440},{  102, 1839},{  113, 2227},{  122, 2604},
        {  132, 2969},{  141, 3320},{  151, 3659},{  161, 3985},
        {  172, 4301},{  186, 4612},{  200, 4917},{  219, 5213},
        {  241, 5509},{  265, 5800},{  296, 6081},{  329, 6360},
        {  369, 6633},{  414, 6899},{  465, 7148},{  520, 7387}
      }
    },
    {
      /*Cr  qi=29  INTRA*/
      {
        {    6,    7},{   82,  382},{  142,  772},{  185, 1211},
        {  233, 1632},{  303, 2000},{  388, 2306},{  475, 2550},
        {  556, 2779},{  627, 3007},{  707, 3237},{  778, 3459},
        {  843, 3654},{  927, 3834},{ 1012, 4012},{ 1101, 4152},
        { 1197, 4262},{ 1275, 4399},{ 1359, 4511},{ 1455, 4596},
        { 1562, 4708},{ 1644, 4833},{ 1719, 4954},{ 1888, 4988}
      },
      /*Cr  qi=29  INTER*/
      {
        {  101,   28},{   81,  343},{   67,  673},{   75, 1053},
        {   93, 1450},{  106, 1844},{  113, 2230},{  119, 2610},
        {  127, 2980},{  135, 3334},{  143, 3676},{  153, 4007},
        {  165, 4330},{  180, 4645},{  201, 4951},{  224, 5243},
        {  253, 5522},{  284, 5794},{  314, 6060},{  345, 6322},
        {  381, 6578},{  419, 6828},{  455, 7073},{  495, 7316}
      }
    }
  },
  {
    {
      /*Y'  qi=30  INTRA*/
      {
        {  112,    8},{  335, 1380},{  682, 2401},{ 1083, 3093},
        { 1489, 3619},{ 1902, 4092},{ 2332, 4511},{ 2777, 4865},
        { 3231, 5156},{ 3693, 5394},{ 4153, 5585},{ 4605, 5689},
        { 5049, 5764},{ 5468, 5871},{ 5875, 6004},{ 6295, 6120},
        { 6706, 6201},{ 7099, 6273},{ 7461, 6311},{ 7785, 6320},
        { 8128, 6322},{ 8469, 6331},{ 8806, 6342},{ 9220, 6338}
      },
      /*Y'  qi=30  INTER*/
      {
        {   58,    8},{   90, 1340},{  169, 2771},{  257, 4079},
        {  345, 5266},{  459, 6387},{  660, 7383},{  990, 8180},
        { 1496, 8726},{ 2203, 8992},{ 3029, 9038},{ 3833, 8984},
        { 4549, 8900},{ 5183, 8813},{ 5745, 8735},{ 6250, 8674},
        { 6715, 8619},{ 7138, 8565},{ 7529, 8528},{ 7899, 8495},
        { 8234, 8465},{ 8550, 8429},{ 8856, 8395},{ 9160, 8374}
      }
    },
    {
      /*Cb  qi=30  INTRA*/
      {
        {    7,    3},{   88,  369},{  149,  747},{  185, 1175},
        {  232, 1599},{  304, 1976},{  392, 2293},{  486, 2557},
        {  573, 2797},{  656, 3027},{  735, 3243},{  819, 3442},
        {  903, 3629},{  966, 3828},{ 1025, 4027},{ 1105, 4204},
        { 1201, 4343},{ 1282, 4469},{ 1379, 4575},{ 1486, 4689},
        { 1588, 4813},{ 1678, 4900},{ 1767, 4969},{ 1911, 5080}
      },
      /*Cb  qi=30  INTER*/
      {
        {  120,   23},{   96,  336},{   72,  661},{   75, 1043},
        {   91, 1441},{  105, 1837},{  117, 2221},{  127, 2592},
        {  137, 2953},{  148, 3301},{  159, 3635},{  170, 3959},
        {  184, 4271},{  199, 4578},{  216, 4879},{  238, 5175},
        {  262, 5466},{  294, 5750},{  332, 6027},{  373, 6298},
        {  421, 6559},{  473, 6805},{  526, 7053},{  587, 7298}
      }
    },
    {
      /*Cr  qi=30  INTRA*/
      {
        {   10,    7},{   89,  384},{  147,  773},{  192, 1211},
        {  245, 1627},{  322, 1984},{  412, 2280},{  501, 2520},
        {  583, 2750},{  654, 2982},{  736, 3207},{  810, 3419},
        {  873, 3614},{  957, 3794},{ 1048, 3965},{ 1139, 4102},
        { 1237, 4208},{ 1327, 4328},{ 1408, 4448},{ 1496, 4545},
        { 1604, 4652},{ 1699, 4760},{ 1780, 4877},{ 1937, 4942}
      },
      /*Cr  qi=30  INTER*/
      {
        {  115,   26},{   89,  342},{   70,  672},{   79, 1055},
        {   96, 1451},{  108, 1841},{  116, 2222},{  124, 2599},
        {  132, 2965},{  141, 3316},{  151, 3655},{  163, 3984},
        {  178, 4301},{  197, 4609},{  219, 4909},{  247, 5195},
        {  280, 5469},{  317, 5734},{  351, 5991},{  383, 6248},
        {  423, 6500},{  467, 6744},{  502, 6995},{  558, 7226}
      }
    }
  },
  {
    {
      /*Y'  qi=31  INTRA*/
      {
        {  116,   20},{  359, 1361},{  732, 2350},{ 1162, 3010},
        { 1597, 3507},{ 2042, 3950},{ 2503, 4339},{ 2974, 4670},
        { 3446, 4951},{ 3922, 5179},{ 4394, 5357},{ 4858, 5454},
        { 5313, 5519},{ 5734, 5626},{ 6154, 5755},{ 6585, 5859},
        { 7004, 5928},{ 7408, 5998},{ 7775, 6039},{ 8102, 6048},
        { 8442, 6051},{ 8790, 6054},{ 9136, 6057},{ 9554, 6041}
      },
      /*Y'  qi=31  INTER*/
      {
        {   53,   12},{   90, 1340},{  169, 2765},{  259, 4062},
        {  353, 5236},{  483, 6340},{  713, 7305},{ 1086, 8059},
        { 1651, 8548},{ 2423, 8751},{ 3288, 8754},{ 4106, 8674},
        { 4827, 8572},{ 5451, 8482},{ 6007, 8407},{ 6514, 8344},
        { 6970, 8282},{ 7397, 8225},{ 7795, 8193},{ 8159, 8161},
        { 8498, 8120},{ 8814, 8093},{ 9127, 8066},{ 9432, 8040}
      }
    },
    {
      /*Cb  qi=31  INTRA*/
      {
        {    7,    3},{   88,  369},{  149,  746},{  185, 1173},
        {  234, 1595},{  308, 1967},{  399, 2278},{  494, 2537},
        {  583, 2774},{  669, 2997},{  755, 3204},{  847, 3390},
        {  936, 3569},{ 1008, 3759},{ 1078, 3942},{ 1162, 4104},
        { 1262, 4238},{ 1352, 4364},{ 1442, 4470},{ 1557, 4567},
        { 1676, 4674},{ 1759, 4781},{ 1850, 4853},{ 2043, 4897}
      },
      /*Cb  qi=31  INTER*/
      {
        {  121,   23},{   96,  335},{   72,  660},{   74, 1043},
        {   90, 1440},{  105, 1834},{  116, 2217},{  127, 2586},
        {  138, 2945},{  148, 3293},{  159, 3626},{  172, 3945},
        {  185, 4256},{  202, 4559},{  223, 4856},{  245, 5150},
        {  272, 5440},{  306, 5719},{  346, 5989},{  391, 6253},
        {  443, 6511},{  510, 6743},{  583, 6965},{  651, 7182}
      }
    },
    {
      /*Cr  qi=31  INTRA*/
      {
        {   10,    7},{   88,  384},{  147,  773},{  192, 1209},
        {  247, 1622},{  326, 1974},{  417, 2262},{  509, 2500},
        {  596, 2726},{  670, 2949},{  754, 3170},{  836, 3370},
        {  912, 3548},{  999, 3724},{ 1093, 3888},{ 1198, 4000},
        { 1304, 4095},{ 1384, 4230},{ 1470, 4347},{ 1577, 4422},
        { 1696, 4513},{ 1798, 4620},{ 1869, 4746},{ 1991, 4798}
      },
      /*Cr  qi=31  INTER*/
      {
        {  113,   32},{   88,  345},{   69,  674},{   79, 1055},
        {   96, 1451},{  108, 1839},{  115, 2218},{  123, 2592},
        {  132, 2957},{  141, 3308},{  151, 3643},{  163, 3968},
        {  179, 4285},{  200, 4590},{  225, 4886},{  254, 5169},
        {  291, 5436},{  330, 5696},{  368, 5951},{  409, 6200},
        {  452, 6448},{  493, 6695},{  536, 6940},{  571, 7204}
      }
    }
  },
  {
    {
      /*Y'  qi=32  INTRA*/
      {
        {  123,   26},{  370, 1356},{  756, 2321},{ 1211, 2944},
        { 1674, 3408},{ 2148, 3826},{ 2639, 4193},{ 3138, 4504},
        { 3634, 4765},{ 4133, 4973},{ 4625, 5137},{ 5101, 5225},
        { 5567, 5274},{ 6002, 5363},{ 6437, 5482},{ 6885, 5566},
        { 7312, 5625},{ 7723, 5686},{ 8101, 5721},{ 8429, 5732},
        { 8769, 5728},{ 9120, 5726},{ 9472, 5723},{ 9918, 5700}
      },
      /*Y'  qi=32  INTER*/
      {
        {   54,   -3},{   95, 1343},{  179, 2750},{  276, 4027},
        {  382, 5185},{  543, 6256},{  830, 7161},{ 1301, 7815},
        { 2003, 8172},{ 2883, 8266},{ 3779, 8217},{ 4578, 8127},
        { 5274, 8035},{ 5886, 7952},{ 6430, 7887},{ 6929, 7835},
        { 7380, 7779},{ 7796, 7737},{ 8190, 7705},{ 8552, 7672},
        { 8896, 7640},{ 9210, 7612},{ 9510, 7589},{ 9746, 7552}
      }
    },
    {
      /*Cb  qi=32  INTRA*/
      {
        {    6,    3},{   89,  369},{  153,  746},{  193, 1167},
        {  247, 1577},{  330, 1935},{  429, 2236},{  528, 2494},
        {  620, 2732},{  712, 2948},{  801, 3146},{  898, 3325},
        {  999, 3489},{ 1078, 3664},{ 1155, 3832},{ 1251, 3985},
        { 1360, 4115},{ 1451, 4236},{ 1549, 4338},{ 1667, 4433},
        { 1797, 4522},{ 1891, 4613},{ 1989, 4687},{ 2162, 4776}
      },
      /*Cb  qi=32  INTER*/
      {
        {  116,   -1},{   98,  321},{   80,  656},{   80, 1042},
        {   96, 1438},{  110, 1827},{  122, 2205},{  133, 2570},
        {  144, 2925},{  157, 3268},{  170, 3597},{  185, 3911},
        {  202, 4216},{  221, 4516},{  244, 4809},{  273, 5096},
        {  308, 5376},{  350, 5644},{  401, 5907},{  459, 6160},
        {  520, 6401},{  592, 6630},{  676, 6837},{  758, 7050}
      }
    },
    {
      /*Cr  qi=32  INTRA*/
      {
        {   12,    7},{   91,  386},{  152,  773},{  201, 1202},
        {  261, 1603},{  347, 1942},{  447, 2223},{  540, 2460},
        {  626, 2684},{  711, 2901},{  801, 3115},{  887, 3312},
        {  969, 3480},{ 1068, 3633},{ 1176, 3779},{ 1283, 3885},
        { 1392, 3969},{ 1485, 4090},{ 1573, 4206},{ 1686, 4274},
        { 1813, 4354},{ 1911, 4459},{ 2004, 4563},{ 2162, 4590}
      },
      /*Cr  qi=32  INTER*/
      {
        {  129,    5},{   98,  334},{   75,  673},{   84, 1055},
        {  101, 1448},{  113, 1832},{  121, 2206},{  129, 2577},
        {  140, 2937},{  151, 3282},{  163, 3614},{  179, 3932},
        {  198, 4240},{  221, 4542},{  252, 4830},{  290, 5102},
        {  329, 5364},{  373, 5618},{  420, 5864},{  468, 6105},
        {  513, 6351},{  564, 6587},{  624, 6810},{  697, 7017}
      }
    }
  },
  {
    {
      /*Y'  qi=33  INTRA*/
      {
        {  115,   36},{  388, 1338},{  791, 2289},{ 1258, 2899},
        { 1732, 3352},{ 2220, 3760},{ 2730, 4117},{ 3244, 4415},
        { 3751, 4662},{ 4261, 4858},{ 4766, 5012},{ 5249, 5094},
        { 5719, 5141},{ 6159, 5225},{ 6597, 5333},{ 7044, 5416},
        { 7474, 5472},{ 7893, 5531},{ 8268, 5570},{ 8591, 5580},
        { 8931, 5578},{ 9283, 5579},{ 9634, 5582},{10067, 5560}
      },
      /*Y'  qi=33  INTER*/
      {
        {   65,  -14},{  102, 1345},{  190, 2736},{  294, 3999},
        {  411, 5146},{  597, 6192},{  934, 7045},{ 1488, 7622},
        { 2281, 7895},{ 3213, 7937},{ 4108, 7871},{ 4883, 7784},
        { 5556, 7709},{ 6150, 7643},{ 6685, 7585},{ 7176, 7539},
        { 7620, 7502},{ 8034, 7466},{ 8427, 7435},{ 8793, 7409},
        { 9136, 7386},{ 9446, 7364},{ 9743, 7339},{10025, 7303}
      }
    },
    {
      /*Cb  qi=33  INTRA*/
      {
        {    5,    3},{   92,  369},{  159,  746},{  203, 1163},
        {  263, 1564},{  353, 1911},{  458, 2204},{  557, 2460},
        {  650, 2697},{  744, 2913},{  836, 3110},{  934, 3292},
        { 1036, 3454},{ 1125, 3616},{ 1204, 3781},{ 1298, 3932},
        { 1410, 4058},{ 1507, 4170},{ 1606, 4265},{ 1725, 4358},
        { 1853, 4445},{ 1955, 4535},{ 2067, 4597},{ 2258, 4663}
      },
      /*Cb  qi=33  INTER*/
      {
        {  109,   37},{   94,  343},{   81,  662},{   85, 1042},
        {  102, 1436},{  116, 1823},{  128, 2195},{  141, 2554},
        {  154, 2906},{  167, 3246},{  183, 3570},{  202, 3881},
        {  220, 4185},{  241, 4482},{  268, 4772},{  302, 5053},
        {  341, 5328},{  388, 5592},{  446, 5846},{  507, 6096},
        {  581, 6328},{  670, 6534},{  762, 6731},{  842, 6922}
      }
    },
    {
      /*Cr  qi=33  INTRA*/
      {
        {   11,    7},{   93,  387},{  158,  774},{  211, 1197},
        {  278, 1589},{  372, 1917},{  475, 2191},{  569, 2429},
        {  658, 2655},{  744, 2868},{  835, 3083},{  926, 3271},
        { 1010, 3430},{ 1110, 3586},{ 1224, 3724},{ 1336, 3826},
        { 1449, 3908},{ 1547, 4021},{ 1636, 4136},{ 1751, 4200},
        { 1886, 4277},{ 1977, 4384},{ 2070, 4474},{ 2232, 4510}
      },
      /*Cr  qi=33  INTER*/
      {
        {   77,    9},{   90,  347},{   80,  674},{   91, 1053},
        {  107, 1444},{  119, 1825},{  127, 2196},{  137, 2563},
        {  149, 2919},{  161, 3259},{  176, 3588},{  194, 3905},
        {  217, 4209},{  246, 4504},{  280, 4786},{  320, 5055},
        {  364, 5316},{  409, 5565},{  460, 5804},{  517, 6039},
        {  578, 6264},{  640, 6489},{  701, 6721},{  772, 6948}
      }
    }
  },
  {
    {
      /*Y'  qi=34  INTRA*/
      {
        {  124,   40},{  401, 1333},{  823, 2262},{ 1318, 2842},
        { 1823, 3265},{ 2339, 3650},{ 2872, 3991},{ 3405, 4274},
        { 3926, 4513},{ 4448, 4704},{ 4961, 4845},{ 5450, 4921},
        { 5925, 4971},{ 6372, 5053},{ 6813, 5160},{ 7264, 5242},
        { 7704, 5291},{ 8124, 5346},{ 8500, 5382},{ 8831, 5384},
        { 9178, 5380},{ 9525, 5387},{ 9869, 5389},{10310, 5356}
      },
      /*Y'  qi=34  INTER*/
      {
        {   64,  -17},{  101, 1344},{  190, 2730},{  299, 3981},
        {  430, 5110},{  648, 6127},{ 1036, 6933},{ 1664, 7445},
        { 2535, 7652},{ 3504, 7653},{ 4402, 7572},{ 5173, 7479},
        { 5843, 7400},{ 6441, 7334},{ 6976, 7280},{ 7464, 7231},
        { 7910, 7189},{ 8332, 7157},{ 8730, 7125},{ 9091, 7103},
        { 9422, 7086},{ 9753, 7061},{10067, 7036},{10316, 7029}
      }
    },
    {
      /*Cb  qi=34  INTRA*/
      {
        {    5,    3},{   91,  369},{  158,  746},{  204, 1162},
        {  266, 1561},{  358, 1903},{  466, 2189},{  570, 2439},
        {  665, 2671},{  765, 2880},{  864, 3069},{  970, 3238},
        { 1079, 3392},{ 1174, 3545},{ 1265, 3693},{ 1360, 3841},
        { 1471, 3968},{ 1572, 4083},{ 1675, 4181},{ 1804, 4255},
        { 1939, 4332},{ 2048, 4411},{ 2155, 4484},{ 2339, 4584}
      },
      /*Cb  qi=34  INTER*/
      {
        {   99,   44},{   92,  345},{   82,  661},{   86, 1043},
        {  101, 1436},{  116, 1821},{  128, 2191},{  140, 2549},
        {  154, 2898},{  168, 3235},{  185, 3556},{  203, 3865},
        {  224, 4166},{  248, 4457},{  278, 4741},{  315, 5021},
        {  361, 5289},{  416, 5546},{  483, 5792},{  559, 6025},
        {  651, 6237},{  752, 6432},{  849, 6626},{  967, 6790}
      }
    },
    {
      /*Cr  qi=34  INTRA*/
      {
        {   11,    7},{   93,  387},{  158,  773},{  212, 1195},
        {  282, 1584},{  378, 1909},{  483, 2179},{  578, 2414},
        {  671, 2633},{  766, 2837},{  866, 3038},{  960, 3223},
        { 1049, 3376},{ 1158, 3520},{ 1285, 3644},{ 1400, 3740},
        { 1505, 3828},{ 1616, 3928},{ 1713, 4030},{ 1820, 4104},
        { 1957, 4185},{ 2063, 4280},{ 2160, 4355},{ 2320, 4341}
      },
      /*Cr  qi=34  INTER*/
      {
        {   78,   11},{   89,  347},{   79,  674},{   90, 1053},
        {  106, 1444},{  117, 1823},{  127, 2192},{  137, 2558},
        {  149, 2912},{  163, 3249},{  178, 3574},{  197, 3888},
        {  222, 4189},{  252, 4481},{  293, 4755},{  341, 5013},
        {  386, 5268},{  436, 5512},{  498, 5743},{  563, 5970},
        {  622, 6200},{  694, 6415},{  776, 6622},{  871, 6818}
      }
    }
  },
  {
    {
      /*Y'  qi=35  INTRA*/
      {
        {  116,   51},{  433, 1312},{  881, 2221},{ 1406, 2771},
        { 1948, 3156},{ 2511, 3501},{ 3085, 3811},{ 3654, 4066},
        { 4212, 4273},{ 4763, 4444},{ 5298, 4572},{ 5799, 4638},
        { 6285, 4678},{ 6747, 4746},{ 7203, 4838},{ 7673, 4905},
        { 8124, 4950},{ 8552, 5003},{ 8938, 5027},{ 9275, 5026},
        { 9628, 5019},{ 9981, 5024},{10331, 5030},{10795, 5000}
      },
      /*Y'  qi=35  INTER*/
      {
        {   71,  -10},{  108, 1348},{  203, 2710},{  325, 3938},
        {  485, 5040},{  766, 6000},{ 1267, 6706},{ 2048, 7089},
        { 3037, 7191},{ 4032, 7146},{ 4903, 7061},{ 5648, 6977},
        { 6301, 6912},{ 6884, 6857},{ 7413, 6812},{ 7898, 6775},
        { 8342, 6739},{ 8764, 6710},{ 9160, 6688},{ 9519, 6668},
        { 9859, 6646},{10190, 6625},{10492, 6612},{10755, 6595}
      }
    },
    {
      /*Cb  qi=35  INTRA*/
      {
        {    6,    3},{   95,  369},{  164,  746},{  214, 1156},
        {  287, 1542},{  390, 1869},{  504, 2143},{  611, 2388},
        {  712, 2613},{  822, 2811},{  937, 2987},{ 1055, 3147},
        { 1174, 3285},{ 1286, 3420},{ 1386, 3560},{ 1488, 3698},
        { 1604, 3814},{ 1714, 3916},{ 1825, 4008},{ 1958, 4088},
        { 2101, 4159},{ 2224, 4226},{ 2339, 4292},{ 2538, 4383}
      },
      /*Cb  qi=35  INTER*/
      {
        {   98,   41},{   90,  348},{   86,  665},{   92, 1042},
        {  108, 1432},{  122, 1812},{  136, 2175},{  151, 2528},
        {  165, 2872},{  182, 3202},{  202, 3516},{  225, 3819},
        {  251, 4112},{  281, 4398},{  320, 4675},{  367, 4944},
        {  421, 5204},{  493, 5450},{  579, 5679},{  672, 5892},
        {  785, 6082},{  906, 6258},{ 1026, 6432},{ 1153, 6592}
      }
    },
    {
      /*Cr  qi=35  INTRA*/
      {
        {   12,    7},{   98,  388},{  166,  773},{  226, 1187},
        {  306, 1563},{  411, 1874},{  524, 2134},{  622, 2365},
        {  721, 2577},{  826, 2768},{  947, 2946},{ 1066, 3106},
        { 1163, 3250},{ 1274, 3395},{ 1417, 3508},{ 1539, 3590},
        { 1639, 3671},{ 1754, 3765},{ 1865, 3855},{ 1979, 3921},
        { 2127, 3998},{ 2249, 4085},{ 2346, 4172},{ 2473, 4210}
      },
      /*Cr  qi=35  INTER*/
      {
        {   86,   12},{   94,  354},{   85,  677},{   96, 1052},
        {  113, 1439},{  125, 1811},{  135, 2177},{  147, 2537},
        {  160, 2884},{  177, 3215},{  195, 3535},{  219, 3842},
        {  252, 4133},{  292, 4413},{  339, 4680},{  396, 4928},
        {  455, 5169},{  514, 5408},{  588, 5626},{  672, 5835},
        {  750, 6051},{  837, 6257},{  943, 6442},{ 1073, 6595}
      }
    }
  },
  {
    {
      /*Y'  qi=36  INTRA*/
      {
        {  116,   52},{  432, 1312},{  881, 2215},{ 1407, 2759},
        { 1948, 3140},{ 2511, 3484},{ 3090, 3789},{ 3672, 4036},
        { 4243, 4236},{ 4803, 4397},{ 5346, 4517},{ 5856, 4581},
        { 6350, 4614},{ 6821, 4675},{ 7286, 4763},{ 7754, 4832},
        { 8201, 4875},{ 8631, 4922},{ 9015, 4948},{ 9351, 4945},
        { 9706, 4941},{10061, 4948},{10408, 4949},{10878, 4923}
      },
      /*Y'  qi=36  INTER*/
      {
        {   63,  -16},{  114, 1332},{  216, 2690},{  343, 3914},
        {  515, 5009},{  829, 5939},{ 1399, 6586},{ 2263, 6901},
        { 3290, 6967},{ 4272, 6920},{ 5115, 6847},{ 5839, 6779},
        { 6478, 6726},{ 7051, 6685},{ 7571, 6649},{ 8050, 6614},
        { 8495, 6587},{ 8908, 6567},{ 9298, 6550},{ 9673, 6530},
        {10005, 6512},{10324, 6499},{10640, 6483},{10936, 6487}
      }
    },
    {
      /*Cb  qi=36  INTRA*/
      {
        {    6,    3},{   98,  370},{  170,  746},{  225, 1150},
        {  306, 1527},{  416, 1845},{  534, 2116},{  642, 2363},
        {  743, 2591},{  851, 2794},{  964, 2972},{ 1081, 3133},
        { 1198, 3275},{ 1311, 3410},{ 1411, 3547},{ 1519, 3680},
        { 1642, 3789},{ 1750, 3892},{ 1860, 3982},{ 1998, 4054},
        { 2141, 4129},{ 2256, 4204},{ 2372, 4278},{ 2567, 4356}
      },
      /*Cb  qi=36  INTER*/
      {
        {  107,   30},{   96,  346},{   88,  667},{  100, 1039},
        {  115, 1426},{  128, 1804},{  142, 2164},{  158, 2512},
        {  176, 2851},{  195, 3178},{  218, 3491},{  243, 3791},
        {  270, 4084},{  307, 4365},{  348, 4638},{  397, 4908},
        {  464, 5157},{  545, 5392},{  635, 5620},{  734, 5831},
        {  854, 6015},{  993, 6170},{ 1124, 6327},{ 1234, 6502}
      }
    },
    {
      /*Cr  qi=36  INTRA*/
      {
        {   12,    7},{  102,  388},{  172,  773},{  239, 1182},
        {  328, 1546},{  439, 1848},{  554, 2106},{  651, 2341},
        {  747, 2561},{  850, 2757},{  972, 2934},{ 1086, 3097},
        { 1182, 3245},{ 1302, 3382},{ 1447, 3491},{ 1572, 3567},
        { 1677, 3641},{ 1793, 3733},{ 1899, 3828},{ 2013, 3894},
        { 2163, 3967},{ 2283, 4059},{ 2387, 4142},{ 2559, 4145}
      },
      /*Cr  qi=36  INTER*/
      {
        {   98,  -10},{   96,  347},{   89,  676},{  102, 1048},
        {  118, 1433},{  130, 1804},{  141, 2167},{  154, 2523},
        {  171, 2866},{  190, 3194},{  212, 3508},{  240, 3809},
        {  276, 4099},{  320, 4377},{  372, 4638},{  428, 4887},
        {  492, 5122},{  560, 5353},{  638, 5572},{  725, 5779},
        {  814, 5985},{  902, 6192},{ 1013, 6377},{ 1155, 6527}
      }
    }
  },
  {
    {
      /*Y'  qi=37  INTRA*/
      {
        {  109,   58},{  445, 1302},{  927, 2177},{ 1489, 2689},
        { 2053, 3052},{ 2632, 3387},{ 3230, 3683},{ 3830, 3922},
        { 4417, 4114},{ 4992, 4266},{ 5546, 4375},{ 6067, 4430},
        { 6571, 4459},{ 7046, 4516},{ 7513, 4599},{ 7991, 4663},
        { 8445, 4706},{ 8883, 4749},{ 9273, 4771},{ 9612, 4770},
        { 9970, 4765},{10325, 4773},{10672, 4778},{11106, 4758}
      },
      /*Y'  qi=37  INTER*/
      {
        {   56,  -14},{  114, 1333},{  218, 2683},{  354, 3894},
        {  550, 4966},{  916, 5854},{ 1569, 6437},{ 2520, 6685},
        { 3596, 6704},{ 4585, 6635},{ 5424, 6556},{ 6147, 6489},
        { 6787, 6437},{ 7358, 6395},{ 7876, 6358},{ 8361, 6325},
        { 8807, 6294},{ 9229, 6271},{ 9631, 6253},{10002, 6238},
        {10356, 6228},{10678, 6212},{10975, 6197},{11274, 6185}
      }
    },
    {
      /*Cb  qi=37  INTRA*/
      {
        {    6,    3},{   99,  370},{  171,  746},{  227, 1149},
        {  309, 1522},{  421, 1836},{  541, 2104},{  652, 2347},
        {  757, 2572},{  871, 2768},{  989, 2936},{ 1111, 3087},
        { 1238, 3223},{ 1357, 3352},{ 1465, 3486},{ 1576, 3612},
        { 1709, 3705},{ 1828, 3801},{ 1937, 3895},{ 2076, 3967},
        { 2220, 4035},{ 2345, 4104},{ 2466, 4173},{ 2680, 4265}
      },
      /*Cb  qi=37  INTER*/
      {
        {  111,   27},{   97,  344},{   87,  667},{   99, 1038},
        {  115, 1425},{  128, 1802},{  143, 2160},{  159, 2506},
        {  176, 2843},{  198, 3167},{  220, 3477},{  247, 3774},
        {  280, 4061},{  321, 4338},{  368, 4608},{  427, 4867},
        {  501, 5109},{  595, 5332},{  701, 5544},{  818, 5738},
        {  956, 5905},{ 1105, 6066},{ 1248, 6217},{ 1381, 6353}
      }
    },
    {
      /*Cr  qi=37  INTRA*/
      {
        {   12,    7},{  102,  388},{  173,  773},{  242, 1180},
        {  331, 1541},{  444, 1839},{  562, 2095},{  662, 2326},
        {  763, 2540},{  871, 2728},{ 1003, 2892},{ 1130, 3045},
        { 1230, 3188},{ 1350, 3321},{ 1503, 3418},{ 1634, 3492},
        { 1737, 3568},{ 1856, 3653},{ 1970, 3744},{ 2091, 3802},
        { 2247, 3871},{ 2371, 3962},{ 2477, 4041},{ 2655, 4052}
      },
      /*Cr  qi=37  INTER*/
      {
        {   89,   -9},{   97,  347},{   88,  677},{  102, 1048},
        {  118, 1432},{  130, 1802},{  141, 2163},{  154, 2517},
        {  172, 2857},{  192, 3181},{  216, 3494},{  246, 3793},
        {  286, 4074},{  337, 4343},{  395, 4600},{  464, 4837},
        {  534, 5066},{  608, 5289},{  694, 5501},{  788, 5704},
        {  893, 5901},{ 1010, 6088},{ 1151, 6249},{ 1331, 6374}
      }
    }
  },
  {
    {
      /*Y'  qi=38  INTRA*/
      {
        {  107,   65},{  476, 1286},{  968, 2148},{ 1548, 2641},
        { 2141, 2979},{ 2757, 3289},{ 3390, 3564},{ 4020, 3784},
        { 4632, 3957},{ 5224, 4097},{ 5794, 4201},{ 6326, 4250},
        { 6828, 4274},{ 7309, 4322},{ 7790, 4401},{ 8271, 4463},
        { 8729, 4498},{ 9165, 4540},{ 9552, 4566},{ 9901, 4560},
        {10266, 4552},{10617, 4563},{10964, 4572},{11393, 4567}
      },
      /*Y'  qi=38  INTER*/
      {
        {   57,  -13},{  118, 1332},{  233, 2665},{  386, 3856},
        {  620, 4899},{ 1070, 5722},{ 1849, 6211},{ 2898, 6384},
        { 3989, 6376},{ 4947, 6311},{ 5754, 6249},{ 6454, 6199},
        { 7077, 6161},{ 7640, 6132},{ 8159, 6101},{ 8639, 6076},
        { 9081, 6054},{ 9502, 6037},{ 9900, 6027},{10274, 6012},
        {10621, 5999},{10938, 5991},{11237, 5977},{11557, 5966}
      }
    },
    {
      /*Cb  qi=38  INTRA*/
      {
        {    8,    3},{  104,  370},{  179,  744},{  243, 1139},
        {  338, 1498},{  458, 1801},{  584, 2060},{  700, 2297},
        {  812, 2514},{  935, 2699},{ 1061, 2858},{ 1189, 3007},
        { 1321, 3141},{ 1446, 3266},{ 1563, 3388},{ 1684, 3512},
        { 1816, 3614},{ 1942, 3702},{ 2055, 3793},{ 2201, 3857},
        { 2357, 3923},{ 2477, 3994},{ 2593, 4061},{ 2768, 4178}
      },
      /*Cb  qi=38  INTER*/
      {
        {  118,   24},{  102,  342},{   91,  663},{  101, 1040},
        {  116, 1427},{  131, 1799},{  147, 2152},{  168, 2491},
        {  191, 2822},{  215, 3139},{  244, 3441},{  276, 3731},
        {  316, 4013},{  363, 4286},{  423, 4546},{  495, 4795},
        {  584, 5028},{  691, 5242},{  814, 5439},{  959, 5608},
        { 1119, 5759},{ 1277, 5906},{ 1449, 6035},{ 1655, 6144}
      }
    },
    {
      /*Cr  qi=38  INTRA*/
      {
        {   12,    6},{  106,  387},{  182,  771},{  261, 1168},
        {  364, 1514},{  483, 1802},{  603, 2053},{  707, 2282},
        {  817, 2489},{  933, 2670},{ 1074, 2825},{ 1210, 2967},
        { 1320, 3104},{ 1444, 3229},{ 1599, 3324},{ 1735, 3396},
        { 1846, 3464},{ 1971, 3547},{ 2086, 3646},{ 2206, 3711},
        { 2366, 3773},{ 2499, 3859},{ 2603, 3945},{ 2766, 3952}
      },
      /*Cr  qi=38  INTER*/
      {
        {   86,   -9},{   91,  352},{   85,  680},{  102, 1053},
        {  119, 1435},{  132, 1799},{  146, 2153},{  162, 2501},
        {  183, 2835},{  209, 3154},{  240, 3458},{  278, 3751},
        {  327, 4025},{  388, 4284},{  455, 4532},{  529, 4766},
        {  616, 4980},{  711, 5188},{  815, 5386},{  920, 5583},
        { 1042, 5770},{ 1186, 5936},{ 1348, 6080},{ 1542, 6196}
      }
    }
  },
  {
    {
      /*Y'  qi=39  INTRA*/
      {
        {  103,   66},{  479, 1283},{  998, 2125},{ 1610, 2591},
        { 2223, 2913},{ 2855, 3214},{ 3501, 3482},{ 4146, 3698},
        { 4772, 3868},{ 5376, 3999},{ 5956, 4095},{ 6496, 4140},
        { 7008, 4162},{ 7499, 4209},{ 7987, 4282},{ 8478, 4338},
        { 8947, 4374},{ 9385, 4417},{ 9783, 4437},{10143, 4433},
        {10504, 4424},{10866, 4435},{11225, 4444},{11665, 4430}
      },
      /*Y'  qi=39  INTER*/
      {
        {   56,    2},{  118, 1332},{  235, 2660},{  395, 3843},
        {  653, 4867},{ 1153, 5652},{ 2003, 6089},{ 3113, 6214},
        { 4228, 6178},{ 5189, 6102},{ 6002, 6031},{ 6707, 5976},
        { 7336, 5936},{ 7901, 5900},{ 8424, 5870},{ 8915, 5844},
        { 9361, 5822},{ 9784, 5807},{10187, 5794},{10571, 5778},
        {10931, 5763},{11264, 5751},{11582, 5742},{11916, 5730}
      }
    },
    {
      /*Cb  qi=39  INTRA*/
      {
        {    8,    3},{  104,  370},{  179,  744},{  244, 1138},
        {  340, 1496},{  461, 1796},{  588, 2053},{  705, 2288},
        {  820, 2503},{  945, 2684},{ 1073, 2840},{ 1210, 2981},
        { 1352, 3106},{ 1480, 3225},{ 1603, 3342},{ 1728, 3464},
        { 1865, 3559},{ 1990, 3645},{ 2106, 3734},{ 2258, 3796},
        { 2413, 3856},{ 2540, 3920},{ 2667, 3986},{ 2887, 4060}
      },
      /*Cb  qi=39  INTER*/
      {
        {  119,   19},{  103,  340},{   90,  664},{  100, 1040},
        {  115, 1426},{  131, 1797},{  148, 2148},{  169, 2486},
        {  192, 2816},{  217, 3131},{  247, 3432},{  282, 3721},
        {  324, 3999},{  374, 4268},{  435, 4526},{  520, 4766},
        {  621, 4990},{  738, 5194},{  878, 5376},{ 1035, 5543},
        { 1202, 5686},{ 1374, 5819},{ 1545, 5950},{ 1729, 6064}
      }
    },
    {
      /*Cr  qi=39  INTRA*/
      {
        {   12,    6},{  106,  387},{  182,  771},{  262, 1167},
        {  365, 1512},{  486, 1798},{  608, 2047},{  713, 2274},
        {  824, 2479},{  945, 2655},{ 1091, 2804},{ 1231, 2941},
        { 1346, 3073},{ 1475, 3194},{ 1633, 3282},{ 1778, 3345},
        { 1891, 3414},{ 2013, 3501},{ 2138, 3584},{ 2266, 3640},
        { 2428, 3701},{ 2568, 3782},{ 2674, 3863},{ 2816, 3894}
      },
      /*Cr  qi=39  INTER*/
      {
        {   88,   -7},{   92,  352},{   85,  680},{  102, 1053},
        {  119, 1434},{  132, 1797},{  146, 2151},{  163, 2498},
        {  185, 2830},{  211, 3147},{  243, 3451},{  285, 3735},
        {  337, 4005},{  401, 4260},{  477, 4499},{  565, 4721},
        {  655, 4937},{  749, 5148},{  858, 5344},{  979, 5529},
        { 1110, 5710},{ 1264, 5871},{ 1460, 5990},{ 1677, 6086}
      }
    }
  },
  {
    {
      /*Y'  qi=40  INTRA*/
      {
        {   98,   71},{  491, 1274},{ 1023, 2103},{ 1641, 2559},
        { 2257, 2877},{ 2898, 3171},{ 3566, 3429},{ 4233, 3629},
        { 4881, 3784},{ 5499, 3906},{ 6088, 3997},{ 6631, 4040},
        { 7145, 4060},{ 7640, 4107},{ 8128, 4178},{ 8618, 4233},
        { 9077, 4267},{ 9514, 4304},{ 9919, 4324},{10277, 4317},
        {10635, 4312},{10985, 4324},{11338, 4331},{11792, 4334}
      },
      /*Y'  qi=40  INTER*/
      {
        {   63,  -26},{  125, 1331},{  256, 2640},{  439, 3801},
        {  757, 4782},{ 1391, 5474},{ 2399, 5805},{ 3582, 5870},
        { 4678, 5824},{ 5600, 5763},{ 6386, 5710},{ 7076, 5667},
        { 7693, 5637},{ 8252, 5610},{ 8775, 5586},{ 9255, 5571},
        { 9694, 5556},{10115, 5541},{10530, 5530},{10903, 5522},
        {11242, 5515},{11596, 5501},{11904, 5482},{12205, 5475}
      }
    },
    {
      /*Cb  qi=40  INTRA*/
      {
        {    8,    3},{  108,  371},{  189,  743},{  265, 1128},
        {  371, 1475},{  499, 1767},{  628, 2022},{  746, 2256},
        {  864, 2467},{  991, 2647},{ 1124, 2801},{ 1270, 2933},
        { 1412, 3054},{ 1547, 3165},{ 1677, 3277},{ 1804, 3393},
        { 1946, 3483},{ 2078, 3569},{ 2201, 3651},{ 2352, 3711},
        { 2513, 3766},{ 2643, 3826},{ 2775, 3880},{ 3025, 3919}
      },
      /*Cb  qi=40  INTER*/
      {
        {  114,   35},{  104,  349},{   96,  667},{  106, 1040},
        {  121, 1423},{  138, 1789},{  158, 2132},{  184, 2464},
        {  212, 2787},{  242, 3095},{  279, 3389},{  321, 3671},
        {  374, 3941},{  438, 4199},{  517, 4446},{  617, 4673},
        {  740, 4881},{  891, 5064},{ 1058, 5225},{ 1239, 5372},
        { 1441, 5499},{ 1638, 5610},{ 1840, 5719},{ 2076, 5814}
      }
    },
    {
      /*Cr  qi=40  INTRA*/
      {
        {   14,    7},{  114,  389},{  193,  771},{  283, 1156},
        {  399, 1488},{  523, 1768},{  643, 2018},{  752, 2245},
        {  865, 2450},{  984, 2626},{ 1139, 2763},{ 1290, 2887},
        { 1413, 3014},{ 1550, 3128},{ 1711, 3211},{ 1865, 3268},
        { 1981, 3334},{ 2103, 3415},{ 2237, 3486},{ 2365, 3543},
        { 2529, 3610},{ 2666, 3700},{ 2775, 3779},{ 2929, 3803}
      },
      /*Cr  qi=40  INTER*/
      {
        {   89,   -8},{   95,  353},{   90,  681},{  107, 1053},
        {  124, 1430},{  139, 1787},{  156, 2136},{  177, 2477},
        {  203, 2803},{  237, 3112},{  276, 3406},{  329, 3683},
        {  395, 3942},{  475, 4182},{  567, 4407},{  665, 4624},
        {  767, 4834},{  879, 5032},{ 1011, 5213},{ 1169, 5375},
        { 1348, 5525},{ 1547, 5654},{ 1785, 5743},{ 2066, 5787}
      }
    }
  },
  {
    {
      /*Y'  qi=41  INTRA*/
      {
        {   98,   71},{  495, 1272},{ 1040, 2090},{ 1675, 2533},
        { 2302, 2842},{ 2953, 3132},{ 3631, 3381},{ 4309, 3574},
        { 4966, 3726},{ 5593, 3846},{ 6189, 3934},{ 6738, 3972},
        { 7256, 3991},{ 7754, 4036},{ 8250, 4099},{ 8747, 4150},
        { 9207, 4185},{ 9650, 4222},{10057, 4242},{10411, 4237},
        {10771, 4230},{11127, 4244},{11486, 4254},{11933, 4252}
      },
      /*Y'  qi=41  INTER*/
      {
        {   65,  -25},{  125, 1331},{  260, 2633},{  457, 3782},
        {  807, 4740},{ 1499, 5397},{ 2562, 5693},{ 3766, 5743},
        { 4859, 5695},{ 5776, 5638},{ 6556, 5590},{ 7243, 5554},
        { 7859, 5529},{ 8417, 5506},{ 8935, 5486},{ 9419, 5473},
        { 9869, 5460},{10296, 5446},{10711, 5436},{11089, 5430},
        {11445, 5421},{11802, 5412},{12129, 5404},{12465, 5393}
      }
    },
    {
      /*Cb  qi=41  INTRA*/
      {
        {    8,    3},{  108,  371},{  189,  743},{  267, 1126},
        {  374, 1471},{  504, 1760},{  635, 2011},{  758, 2241},
        {  881, 2447},{ 1013, 2621},{ 1147, 2773},{ 1293, 2906},
        { 1441, 3023},{ 1580, 3131},{ 1712, 3243},{ 1844, 3360},
        { 1985, 3451},{ 2114, 3532},{ 2240, 3613},{ 2390, 3680},
        { 2550, 3740},{ 2687, 3800},{ 2825, 3862},{ 3052, 3944}
      },
      /*Cb  qi=41  INTER*/
      {
        {  104,   39},{  100,  350},{   95,  667},{  105, 1040},
        {  121, 1422},{  137, 1787},{  159, 2129},{  185, 2459},
        {  216, 2778},{  249, 3083},{  287, 3374},{  335, 3653},
        {  393, 3920},{  462, 4175},{  549, 4414},{  660, 4636},
        {  791, 4839},{  952, 5014},{ 1135, 5166},{ 1337, 5297},
        { 1552, 5411},{ 1752, 5530},{ 1972, 5634},{ 2224, 5724}
      }
    },
    {
      /*Cr  qi=41  INTRA*/
      {
        {   15,    7},{  115,  389},{  193,  770},{  284, 1154},
        {  401, 1484},{  528, 1761},{  652, 2005},{  764, 2228},
        {  882, 2427},{ 1008, 2599},{ 1167, 2734},{ 1320, 2859},
        { 1443, 2990},{ 1580, 3103},{ 1743, 3181},{ 1894, 3241},
        { 2012, 3309},{ 2141, 3385},{ 2272, 3459},{ 2398, 3519},
        { 2566, 3584},{ 2707, 3680},{ 2816, 3762},{ 2991, 3770}
      },
      /*Cr  qi=41  INTER*/
      {
        {   92,   -9},{   98,  354},{   90,  682},{  107, 1052},
        {  124, 1429},{  139, 1786},{  156, 2132},{  178, 2471},
        {  207, 2794},{  241, 3100},{  285, 3391},{  345, 3662},
        {  417, 3915},{  503, 4151},{  600, 4375},{  703, 4589},
        {  815, 4791},{  942, 4981},{ 1088, 5155},{ 1250, 5316},
        { 1432, 5462},{ 1653, 5575},{ 1930, 5639},{ 2250, 5655}
      }
    }
  },
  {
    {
      /*Y'  qi=42  INTRA*/
      {
        {  109,   75},{  534, 1257},{ 1114, 2047},{ 1793, 2456},
        { 2461, 2735},{ 3157, 2994},{ 3879, 3221},{ 4595, 3396},
        { 5282, 3531},{ 5931, 3638},{ 6546, 3714},{ 7105, 3749},
        { 7633, 3766},{ 8147, 3803},{ 8652, 3865},{ 9148, 3915},
        { 9613, 3946},{10075, 3976},{10489, 3997},{10835, 3994},
        {11195, 3985},{11553, 3997},{11909, 4004},{12369, 3990}
      },
      /*Y'  qi=42  INTER*/
      {
        {   69,  -23},{  134, 1332},{  287, 2611},{  521, 3730},
        {  970, 4624},{ 1827, 5176},{ 3028, 5382},{ 4262, 5389},
        { 5325, 5338},{ 6214, 5291},{ 6976, 5255},{ 7651, 5228},
        { 8260, 5206},{ 8821, 5190},{ 9343, 5177},{ 9823, 5165},
        {10273, 5152},{10709, 5143},{11121, 5136},{11502, 5129},
        {11857, 5125},{12193, 5115},{12520, 5107},{12802, 5097}
      }
    },
    {
      /*Cb  qi=42  INTRA*/
      {
        {    9,    3},{  113,  371},{  199,  743},{  279, 1123},
        {  390, 1462},{  525, 1743},{  662, 1986},{  789, 2208},
        {  916, 2406},{ 1057, 2571},{ 1204, 2712},{ 1362, 2835},
        { 1524, 2943},{ 1676, 3040},{ 1815, 3145},{ 1959, 3249},
        { 2117, 3325},{ 2249, 3406},{ 2377, 3488},{ 2537, 3547},
        { 2706, 3597},{ 2854, 3646},{ 2999, 3705},{ 3236, 3759}
      },
      /*Cb  qi=42  INTER*/
      {
        {  114,   44},{  107,  353},{  101,  670},{  111, 1041},
        {  129, 1418},{  148, 1775},{  174, 2110},{  208, 2432},
        {  244, 2746},{  283, 3046},{  330, 3330},{  388, 3602},
        {  460, 3858},{  546, 4101},{  655, 4326},{  793, 4530},
        {  966, 4703},{ 1165, 4851},{ 1388, 4980},{ 1630, 5088},
        { 1869, 5189},{ 2122, 5268},{ 2403, 5328},{ 2667, 5417}
      }
    },
    {
      /*Cr  qi=42  INTRA*/
      {
        {   15,    7},{  120,  390},{  202,  771},{  298, 1150},
        {  421, 1473},{  553, 1743},{  681, 1982},{  796, 2199},
        {  923, 2388},{ 1062, 2547},{ 1225, 2678},{ 1392, 2792},
        { 1531, 2907},{ 1682, 3007},{ 1856, 3074},{ 2009, 3134},
        { 2138, 3192},{ 2274, 3257},{ 2407, 3333},{ 2536, 3393},
        { 2711, 3455},{ 2875, 3531},{ 3000, 3598},{ 3186, 3599}
      },
      /*Cr  qi=42  INTER*/
      {
        {   87,   -4},{   95,  358},{   97,  683},{  113, 1052},
        {  131, 1423},{  148, 1774},{  170, 2116},{  198, 2448},
        {  234, 2762},{  276, 3062},{  331, 3343},{  404, 3603},
        {  494, 3844},{  598, 4067},{  715, 4276},{  842, 4471},
        {  977, 4661},{ 1128, 4840},{ 1311, 4991},{ 1516, 5127},
        { 1759, 5233},{ 2050, 5300},{ 2377, 5323},{ 2710, 5304}
      }
    }
  },
  {
    {
      /*Y'  qi=43  INTRA*/
      {
        {   99,   79},{  557, 1244},{ 1175, 2016},{ 1882, 2408},
        { 2570, 2677},{ 3288, 2926},{ 4030, 3141},{ 4760, 3307},
        { 5458, 3435},{ 6115, 3537},{ 6743, 3608},{ 7312, 3636},
        { 7841, 3652},{ 8357, 3687},{ 8870, 3742},{ 9376, 3788},
        { 9850, 3821},{10315, 3853},{10734, 3873},{11084, 3870},
        {11442, 3862},{11800, 3874},{12160, 3879},{12618, 3876}
      },
      /*Y'  qi=43  INTER*/
      {
        {   69,  -22},{  134, 1331},{  294, 2601},{  551, 3703},
        { 1056, 4563},{ 2003, 5061},{ 3276, 5215},{ 4534, 5194},
        { 5599, 5133},{ 6488, 5083},{ 7257, 5044},{ 7938, 5014},
        { 8556, 4992},{ 9124, 4975},{ 9648, 4960},{10138, 4948},
        {10594, 4939},{11039, 4926},{11462, 4919},{11847, 4912},
        {12216, 4904},{12570, 4896},{12883, 4889},{13189, 4879}
      }
    },
    {
      /*Cb  qi=43  INTRA*/
      {
        {    9,    3},{  114,  371},{  202,  740},{  294, 1110},
        {  417, 1440},{  558, 1716},{  700, 1956},{  833, 2172},
        {  966, 2365},{ 1116, 2524},{ 1269, 2661},{ 1431, 2781},
        { 1599, 2885},{ 1756, 2980},{ 1902, 3082},{ 2051, 3185},
        { 2209, 3261},{ 2337, 3342},{ 2464, 3420},{ 2633, 3475},
        { 2809, 3525},{ 2948, 3579},{ 3094, 3633},{ 3347, 3678}
      },
      /*Cb  qi=43  INTER*/
      {
        {  111,   44},{  106,  353},{  102,  670},{  112, 1040},
        {  128, 1416},{  148, 1771},{  176, 2104},{  211, 2424},
        {  250, 2734},{  293, 3030},{  347, 3309},{  411, 3575},
        {  490, 3828},{  589, 4064},{  716, 4278},{  869, 4472},
        { 1050, 4640},{ 1264, 4781},{ 1512, 4895},{ 1775, 4991},
        { 2042, 5069},{ 2310, 5141},{ 2593, 5207},{ 2912, 5239}
      }
    },
    {
      /*Cr  qi=43  INTRA*/
      {
        {   15,    7},{  121,  390},{  208,  767},{  315, 1135},
        {  449, 1449},{  586, 1715},{  718, 1950},{  843, 2158},
        {  977, 2342},{ 1120, 2501},{ 1290, 2632},{ 1466, 2739},
        { 1613, 2845},{ 1763, 2945},{ 1937, 3015},{ 2093, 3070},
        { 2225, 3126},{ 2366, 3194},{ 2501, 3267},{ 2634, 3324},
        { 2815, 3385},{ 2964, 3466},{ 3087, 3538},{ 3263, 3555}
      },
      /*Cr  qi=43  INTER*/
      {
        {   84,   -4},{   93,  358},{   95,  683},{  113, 1052},
        {  131, 1421},{  148, 1770},{  171, 2110},{  201, 2439},
        {  240, 2750},{  287, 3046},{  348, 3322},{  429, 3576},
        {  527, 3811},{  641, 4029},{  767, 4230},{  904, 4422},
        { 1053, 4603},{ 1225, 4765},{ 1433, 4903},{ 1661, 5030},
        { 1928, 5121},{ 2252, 5160},{ 2604, 5164},{ 2979, 5125}
      }
    }
  },
  {
    {
      /*Y'  qi=44  INTRA*/
      {
        {  103,   80},{  560, 1244},{ 1183, 2009},{ 1891, 2391},
        { 2586, 2649},{ 3324, 2884},{ 4093, 3089},{ 4850, 3243},
        { 5575, 3358},{ 6252, 3452},{ 6886, 3518},{ 7459, 3546},
        { 7993, 3562},{ 8515, 3594},{ 9030, 3645},{ 9534, 3691},
        {10004, 3723},{10469, 3750},{10887, 3765},{11236, 3766},
        {11596, 3762},{11960, 3775},{12317, 3784},{12766, 3789}
      },
      /*Y'  qi=44  INTER*/
      {
        {   77,  -24},{  145, 1332},{  332, 2580},{  642, 3649},
        { 1270, 4438},{ 2360, 4860},{ 3685, 4982},{ 4910, 4966},
        { 5929, 4928},{ 6785, 4900},{ 7529, 4880},{ 8198, 4863},
        { 8804, 4850},{ 9361, 4842},{ 9882, 4836},{10371, 4830},
        {10827, 4822},{11262, 4816},{11672, 4811},{12052, 4807},
        {12431, 4806},{12780, 4798},{13095, 4792},{13401, 4791}
      }
    },
    {
      /*Cb  qi=44  INTRA*/
      {
        {    9,    2},{  122,  371},{  214,  741},{  307, 1109},
        {  433, 1432},{  576, 1704},{  718, 1939},{  855, 2152},
        {  991, 2340},{ 1141, 2497},{ 1298, 2632},{ 1463, 2749},
        { 1636, 2851},{ 1796, 2944},{ 1947, 3041},{ 2101, 3140},
        { 2260, 3219},{ 2392, 3297},{ 2527, 3366},{ 2693, 3424},
        { 2872, 3477},{ 3025, 3525},{ 3175, 3584},{ 3451, 3626}
      },
      /*Cb  qi=44  INTER*/
      {
        {  111,   14},{  110,  339},{  109,  671},{  120, 1040},
        {  139, 1410},{  162, 1758},{  197, 2084},{  243, 2397},
        {  291, 2702},{  342, 2992},{  405, 3265},{  484, 3521},
        {  584, 3760},{  705, 3983},{  855, 4185},{ 1048, 4356},
        { 1274, 4500},{ 1531, 4617},{ 1816, 4707},{ 2111, 4783},
        { 2409, 4846},{ 2720, 4901},{ 3044, 4957},{ 3391, 4985}
      }
    },
    {
      /*Cr  qi=44  INTRA*/
      {
        {   17,    7},{  128,  392},{  219,  770},{  329, 1135},
        {  465, 1442},{  601, 1703},{  734, 1935},{  862, 2142},
        {  998, 2325},{ 1147, 2482},{ 1321, 2606},{ 1496, 2710},
        { 1649, 2813},{ 1809, 2908},{ 1984, 2977},{ 2143, 3032},
        { 2279, 3087},{ 2423, 3152},{ 2559, 3225},{ 2684, 3288},
        { 2866, 3351},{ 3025, 3426},{ 3161, 3492},{ 3372, 3500}
      },
      /*Cr  qi=44  INTER*/
      {
        {   89,    0},{  101,  352},{  104,  683},{  121, 1051},
        {  141, 1414},{  163, 1757},{  192, 2092},{  231, 2415},
        {  278, 2720},{  336, 3007},{  412, 3273},{  510, 3516},
        {  633, 3733},{  769, 3936},{  914, 4130},{ 1076, 4307},
        { 1256, 4472},{ 1469, 4617},{ 1723, 4732},{ 2012, 4822},
        { 2347, 4871},{ 2716, 4875},{ 3082, 4866},{ 3422, 4826}
      }
    }
  },
  {
    {
      /*Y'  qi=45  INTRA*/
      {
        {  119,   78},{  610, 1226},{ 1271, 1965},{ 2026, 2319},
        { 2768, 2550},{ 3556, 2757},{ 4369, 2938},{ 5157, 3076},
        { 5901, 3182},{ 6598, 3268},{ 7253, 3326},{ 7844, 3343},
        { 8392, 3356},{ 8922, 3386},{ 9453, 3433},{ 9973, 3474},
        {10457, 3503},{10929, 3530},{11351, 3543},{11709, 3541},
        {12068, 3537},{12434, 3547},{12805, 3555},{13268, 3563}
      },
      /*Y'  qi=45  INTER*/
      {
        {   77,  -20},{  146, 1330},{  342, 2566},{  699, 3604},
        { 1439, 4332},{ 2669, 4672},{ 4075, 4727},{ 5318, 4679},
        { 6345, 4630},{ 7209, 4595},{ 7963, 4570},{ 8644, 4551},
        { 9262, 4535},{ 9831, 4525},{10370, 4515},{10872, 4506},
        {11334, 4500},{11783, 4492},{12219, 4489},{12617, 4483},
        {12995, 4477},{13350, 4472},{13674, 4466},{13968, 4468}
      }
    },
    {
      /*Cb  qi=45  INTRA*/
      {
        {    9,    2},{  122,  370},{  219,  735},{  324, 1096},
        {  465, 1414},{  619, 1679},{  771, 1905},{  920, 2103},
        { 1070, 2276},{ 1236, 2419},{ 1410, 2539},{ 1595, 2644},
        { 1784, 2736},{ 1949, 2831},{ 2104, 2931},{ 2275, 3021},
        { 2443, 3092},{ 2586, 3166},{ 2735, 3234},{ 2904, 3288},
        { 3093, 3338},{ 3262, 3382},{ 3419, 3427},{ 3708, 3456}
      },
      /*Cb  qi=45  INTER*/
      {
        {  103,    0},{  109,  339},{  109,  670},{  119, 1039},
        {  137, 1408},{  162, 1754},{  199, 2076},{  248, 2386},
        {  301, 2684},{  360, 2967},{  433, 3234},{  525, 3481},
        {  640, 3713},{  780, 3924},{  956, 4110},{ 1176, 4266},
        { 1438, 4390},{ 1736, 4481},{ 2057, 4553},{ 2385, 4613},
        { 2718, 4656},{ 3056, 4698},{ 3416, 4733},{ 3799, 4755}
      }
    },
    {
      /*Cr  qi=45  INTRA*/
      {
        {   16,    7},{  128,  391},{  225,  763},{  350, 1120},
        {  500, 1420},{  649, 1673},{  792, 1893},{  929, 2089},
        { 1084, 2257},{ 1250, 2401},{ 1440, 2518},{ 1633, 2614},
        { 1799, 2708},{ 1968, 2798},{ 2151, 2863},{ 2314, 2914},
        { 2453, 2968},{ 2611, 3025},{ 2759, 3095},{ 2887, 3160},
        { 3082, 3210},{ 3259, 3278},{ 3403, 3342},{ 3593, 3354}
      },
      /*Cr  qi=45  INTER*/
      {
        {   92,    0},{  101,  352},{  103,  682},{  120, 1049},
        {  140, 1412},{  163, 1752},{  193, 2083},{  234, 2402},
        {  287, 2702},{  353, 2983},{  442, 3240},{  557, 3471},
        {  694, 3680},{  846, 3873},{ 1014, 4056},{ 1200, 4224},
        { 1414, 4369},{ 1664, 4495},{ 1946, 4595},{ 2278, 4654},
        { 2654, 4673},{ 3047, 4658},{ 3438, 4627},{ 3825, 4585}
      }
    }
  },
  {
    {
      /*Y'  qi=46  INTRA*/
      {
        {  119,   78},{  610, 1227},{ 1277, 1960},{ 2043, 2309},
        { 2805, 2529},{ 3618, 2719},{ 4452, 2887},{ 5257, 3016},
        { 6017, 3115},{ 6727, 3195},{ 7392, 3248},{ 7984, 3267},
        { 8528, 3281},{ 9059, 3310},{ 9593, 3354},{10119, 3395},
        {10599, 3425},{11064, 3450},{11493, 3464},{11850, 3466},
        {12207, 3462},{12578, 3471},{12948, 3480},{13407, 3487}
      },
      /*Y'  qi=46  INTER*/
      {
        {   74,  -14},{  149, 1326},{  382, 2538},{  807, 3541},
        { 1670, 4211},{ 3000, 4499},{ 4416, 4533},{ 5628, 4490},
        { 6628, 4453},{ 7479, 4425},{ 8228, 4406},{ 8902, 4393},
        { 9521, 4380},{10090, 4371},{10623, 4364},{11124, 4356},
        {11586, 4351},{12043, 4344},{12476, 4341},{12863, 4340},
        {13244, 4337},{13610, 4329},{13936, 4324},{14246, 4329}
      }
    },
    {
      /*Cb  qi=46  INTRA*/
      {
        {   11,    2},{  132,  371},{  234,  737},{  340, 1094},
        {  481, 1405},{  637, 1667},{  791, 1891},{  944, 2084},
        { 1099, 2253},{ 1268, 2392},{ 1444, 2507},{ 1633, 2610},
        { 1825, 2700},{ 1990, 2794},{ 2147, 2895},{ 2321, 2984},
        { 2493, 3053},{ 2640, 3126},{ 2787, 3198},{ 2954, 3253},
        { 3146, 3297},{ 3313, 3344},{ 3473, 3393},{ 3757, 3434}
      },
      /*Cb  qi=46  INTER*/
      {
        {   97,    0},{  109,  339},{  108,  669},{  120, 1035},
        {  142, 1398},{  173, 1737},{  221, 2052},{  281, 2353},
        {  345, 2646},{  415, 2924},{  504, 3183},{  616, 3421},
        {  749, 3643},{  914, 3842},{ 1123, 4012},{ 1379, 4150},
        { 1685, 4250},{ 2014, 4327},{ 2366, 4382},{ 2731, 4426},
        { 3083, 4470},{ 3445, 4490},{ 3805, 4511},{ 4146, 4539}
      }
    },
    {
      /*Cr  qi=46  INTRA*/
      {
        {   19,    7},{  137,  393},{  237,  765},{  364, 1116},
        {  516, 1411},{  665, 1662},{  809, 1880},{  951, 2072},
        { 1109, 2236},{ 1278, 2378},{ 1474, 2491},{ 1669, 2584},
        { 1835, 2678},{ 2014, 2766},{ 2203, 2828},{ 2366, 2880},
        { 2506, 2933},{ 2661, 2988},{ 2810, 3053},{ 2941, 3116},
        { 3131, 3175},{ 3310, 3243},{ 3461, 3303},{ 3656, 3321}
      },
      /*Cr  qi=46  INTER*/
      {
        {   91,    1},{  103,  351},{  104,  681},{  121, 1046},
        {  144, 1401},{  173, 1736},{  213, 2060},{  265, 2373},
        {  330, 2666},{  410, 2938},{  517, 3185},{  655, 3404},
        {  815, 3601},{  989, 3784},{ 1183, 3951},{ 1400, 4104},
        { 1649, 4241},{ 1933, 4352},{ 2261, 4427},{ 2646, 4458},
        { 3057, 4446},{ 3453, 4418},{ 3820, 4385},{ 4171, 4352}
      }
    }
  },
  {
    {
      /*Y'  qi=47  INTRA*/
      {
        {  117,   83},{  670, 1205},{ 1408, 1904},{ 2239, 2219},
        { 3049, 2414},{ 3905, 2584},{ 4775, 2734},{ 5610, 2852},
        { 6393, 2944},{ 7121, 3017},{ 7804, 3066},{ 8407, 3081},
        { 8957, 3093},{ 9498, 3119},{10043, 3160},{10582, 3199},
        {11083, 3226},{11561, 3250},{11993, 3263},{12352, 3264},
        {12711, 3259},{13092, 3266},{13463, 3271},{13918, 3275}
      },
      /*Y'  qi=47  INTER*/
      {
        {   74,  -11},{  148, 1325},{  404, 2518},{  910, 3478},
        { 1916, 4080},{ 3369, 4298},{ 4823, 4292},{ 6035, 4238},
        { 7037, 4197},{ 7894, 4168},{ 8650, 4146},{ 9337, 4129},
        { 9968, 4116},{10549, 4105},{11096, 4096},{11605, 4089},
        {12081, 4083},{12547, 4076},{12990, 4070},{13399, 4070},
        {13776, 4065},{14133, 4059},{14486, 4057},{14842, 4053}
      }
    },
    {
      /*Cb  qi=47  INTRA*/
      {
        {   11,    2},{  133,  370},{  242,  731},{  367, 1077},
        {  524, 1378},{  692, 1630},{  860, 1844},{ 1028, 2024},
        { 1203, 2178},{ 1393, 2305},{ 1582, 2413},{ 1787, 2507},
        { 1992, 2590},{ 2175, 2676},{ 2351, 2767},{ 2534, 2851},
        { 2707, 2923},{ 2862, 2994},{ 3021, 3060},{ 3193, 3111},
        { 3396, 3147},{ 3573, 3184},{ 3752, 3220},{ 4038, 3255}
      },
      /*Cb  qi=47  INTER*/
      {
        {  101,    0},{  107,  339},{  108,  667},{  120, 1033},
        {  142, 1394},{  175, 1729},{  227, 2040},{  295, 2335},
        {  369, 2619},{  452, 2888},{  556, 3138},{  686, 3368},
        {  850, 3574},{ 1050, 3758},{ 1299, 3910},{ 1605, 4024},
        { 1950, 4104},{ 2317, 4163},{ 2689, 4210},{ 3077, 4239},
        { 3466, 4258},{ 3840, 4278},{ 4205, 4298},{ 4515, 4340}
      }
    },
    {
      /*Cr  qi=47  INTRA*/
      {
        {   19,    7},{  138,  392},{  248,  758},{  396, 1094},
        {  563, 1378},{  723, 1621},{  881, 1829},{ 1037, 2011},
        { 1214, 2165},{ 1410, 2290},{ 1623, 2393},{ 1834, 2480},
        { 2016, 2564},{ 2203, 2647},{ 2405, 2707},{ 2569, 2757},
        { 2709, 2810},{ 2871, 2860},{ 3027, 2924},{ 3178, 2980},
        { 3375, 3034},{ 3563, 3097},{ 3724, 3151},{ 3952, 3153}
      },
      /*Cr  qi=47  INTER*/
      {
        {   91,    1},{  100,  351},{  102,  681},{  120, 1043},
        {  144, 1397},{  175, 1729},{  219, 2049},{  277, 2356},
        {  353, 2640},{  451, 2902},{  579, 3136},{  739, 3342},
        {  926, 3525},{ 1125, 3698},{ 1343, 3859},{ 1595, 3998},
        { 1881, 4113},{ 2208, 4205},{ 2589, 4253},{ 3014, 4250},
        { 3444, 4220},{ 3838, 4183},{ 4196, 4147},{ 4521, 4116}
      }
    }
  },
  {
    {
      /*Y'  qi=48  INTRA*/
      {
        {  107,   87},{  681, 1200},{ 1456, 1883},{ 2306, 2193},
        { 3122, 2386},{ 3984, 2548},{ 4862, 2693},{ 5704, 2808},
        { 6495, 2899},{ 7232, 2970},{ 7915, 3018},{ 8524, 3034},
        { 9085, 3043},{ 9635, 3068},{10192, 3108},{10735, 3145},
        {11237, 3171},{11719, 3194},{12153, 3207},{12516, 3206},
        {12888, 3202},{13266, 3210},{13637, 3218},{14101, 3219}
      },
      /*Y'  qi=48  INTER*/
      {
        {   83,  -18},{  147, 1328},{  398, 2519},{  923, 3468},
        { 1979, 4047},{ 3472, 4246},{ 4936, 4232},{ 6148, 4178},
        { 7150, 4139},{ 8007, 4111},{ 8765, 4091},{ 9458, 4076},
        {10090, 4063},{10676, 4054},{11226, 4045},{11742, 4038},
        {12223, 4033},{12686, 4029},{13127, 4022},{13527, 4015},
        {13915, 4012},{14277, 4007},{14619, 4004},{14966, 4001}
      }
    },
    {
      /*Cb  qi=48  INTRA*/
      {
        {   11,    2},{  134,  369},{  245,  730},{  373, 1075},
        {  531, 1374},{  698, 1625},{  865, 1839},{ 1033, 2019},
        { 1207, 2173},{ 1397, 2300},{ 1588, 2408},{ 1795, 2501},
        { 2003, 2581},{ 2187, 2666},{ 2362, 2757},{ 2548, 2841},
        { 2719, 2912},{ 2876, 2983},{ 3034, 3047},{ 3209, 3097},
        { 3409, 3137},{ 3589, 3178},{ 3762, 3216},{ 4004, 3252}
      },
      /*Cb  qi=48  INTER*/
      {
        {  113,   26},{  112,  344},{  111,  668},{  120, 1032},
        {  141, 1392},{  173, 1727},{  224, 2036},{  290, 2330},
        {  363, 2612},{  447, 2880},{  551, 3130},{  685, 3358},
        {  852, 3563},{ 1061, 3742},{ 1332, 3884},{ 1654, 3993},
        { 2011, 4068},{ 2394, 4120},{ 2782, 4160},{ 3172, 4186},
        { 3557, 4209},{ 3932, 4228},{ 4306, 4237},{ 4675, 4236}
      }
    },
    {
      /*Cr  qi=48  INTRA*/
      {
        {   18,    7},{  139,  389},{  252,  755},{  404, 1090},
        {  573, 1372},{  732, 1615},{  889, 1823},{ 1045, 2005},
        { 1222, 2159},{ 1417, 2285},{ 1631, 2387},{ 1843, 2474},
        { 2027, 2558},{ 2212, 2639},{ 2413, 2697},{ 2578, 2746},
        { 2720, 2798},{ 2887, 2852},{ 3040, 2913},{ 3181, 2970},
        { 3381, 3024},{ 3581, 3081},{ 3743, 3130},{ 3948, 3133}
      },
      /*Cr  qi=48  INTER*/
      {
        {   89,    0},{  106,  352},{  105,  682},{  120, 1044},
        {  144, 1395},{  174, 1724},{  215, 2044},{  270, 2350},
        {  343, 2635},{  441, 2895},{  571, 3129},{  735, 3334},
        {  926, 3518},{ 1139, 3684},{ 1371, 3836},{ 1628, 3977},
        { 1933, 4089},{ 2279, 4164},{ 2672, 4204},{ 3105, 4205},
        { 3533, 4176},{ 3931, 4135},{ 4290, 4089},{ 4624, 4057}
      }
    }
  },
  {
    {
      /*Y'  qi=49  INTRA*/
      {
        {  120,   85},{  706, 1194},{ 1485, 1875},{ 2348, 2187},
        { 3190, 2372},{ 4076, 2521},{ 4967, 2658},{ 5819, 2771},
        { 6611, 2861},{ 7345, 2936},{ 8026, 2990},{ 8626, 3013},
        { 9182, 3030},{ 9723, 3059},{10266, 3100},{10802, 3143},
        {11293, 3179},{11768, 3206},{12201, 3221},{12556, 3225},
        {12914, 3226},{13281, 3237},{13639, 3247},{14089, 3257}
      },
      /*Y'  qi=49  INTER*/
      {
        {   72,  -11},{  155, 1320},{  458, 2485},{ 1090, 3386},
        { 2284, 3907},{ 3835, 4075},{ 5272, 4064},{ 6449, 4026},
        { 7426, 4003},{ 8267, 3987},{ 9017, 3976},{ 9698, 3967},
        {10328, 3962},{10913, 3959},{11452, 3954},{11961, 3950},
        {12442, 3947},{12904, 3946},{13347, 3945},{13749, 3943},
        {14123, 3941},{14490, 3941},{14826, 3939},{15153, 3937}
      }
    },
    {
      /*Cb  qi=49  INTRA*/
      {
        {   11,    2},{  145,  369},{  262,  729},{  393, 1070},
        {  557, 1363},{  731, 1607},{  907, 1811},{ 1085, 1983},
        { 1268, 2130},{ 1465, 2251},{ 1658, 2359},{ 1868, 2454},
        { 2079, 2534},{ 2264, 2621},{ 2440, 2717},{ 2625, 2802},
        { 2792, 2878},{ 2945, 2954},{ 3106, 3021},{ 3277, 3075},
        { 3466, 3119},{ 3638, 3170},{ 3824, 3213},{ 4100, 3243}
      },
      /*Cb  qi=49  INTER*/
      {
        {   98,   -6},{  113,  343},{  110,  669},{  122, 1029},
        {  149, 1380},{  192, 1706},{  258, 2007},{  340, 2293},
        {  426, 2569},{  525, 2831},{  653, 3071},{  814, 3287},
        { 1013, 3478},{ 1262, 3637},{ 1575, 3761},{ 1936, 3851},
        { 2328, 3910},{ 2741, 3949},{ 3163, 3970},{ 3559, 3994},
        { 3936, 4025},{ 4300, 4050},{ 4655, 4060},{ 4962, 4062}
      }
    },
    {
      /*Cr  qi=49  INTRA*/
      {
        {   19,    7},{  151,  389},{  270,  753},{  427, 1084},
        {  602, 1360},{  767, 1595},{  933, 1794},{ 1098, 1968},
        { 1285, 2115},{ 1489, 2237},{ 1699, 2342},{ 1912, 2435},
        { 2101, 2519},{ 2288, 2601},{ 2486, 2663},{ 2651, 2715},
        { 2799, 2769},{ 2958, 2825},{ 3106, 2890},{ 3257, 2948},
        { 3452, 3007},{ 3634, 3075},{ 3786, 3136},{ 3959, 3164}
      },
      /*Cr  qi=49  INTER*/
      {
        {   85,    1},{  103,  352},{  104,  681},{  121, 1039},
        {  152, 1382},{  195, 1702},{  248, 2015},{  316, 2316},
        {  403, 2595},{  520, 2847},{  676, 3068},{  870, 3258},
        { 1091, 3429},{ 1329, 3585},{ 1597, 3725},{ 1894, 3849},
        { 2242, 3940},{ 2656, 3984},{ 3098, 3992},{ 3531, 3981},
        { 3936, 3950},{ 4304, 3915},{ 4646, 3879},{ 4915, 3861}
      }
    }
  },
  {
    {
      /*Y'  qi=50  INTRA*/
      {
        {  122,   89},{  798, 1170},{ 1682, 1812},{ 2613, 2096},
        { 3501, 2260},{ 4430, 2388},{ 5352, 2510},{ 6228, 2613},
        { 7043, 2698},{ 7793, 2770},{ 8486, 2823},{ 9092, 2846},
        { 9652, 2865},{10210, 2895},{10773, 2936},{11315, 2979},
        {11817, 3014},{12297, 3041},{12734, 3057},{13097, 3064},
        {13443, 3067},{13813, 3078},{14190, 3088},{14646, 3103}
      },
      /*Y'  qi=50  INTER*/
      {
        {   73,  -11},{  154, 1318},{  501, 2457},{ 1281, 3291},
        { 2685, 3719},{ 4356, 3810},{ 5811, 3769},{ 6988, 3726},
        { 7976, 3700},{ 8835, 3682},{ 9606, 3669},{10307, 3659},
        {10953, 3652},{11556, 3645},{12115, 3643},{12641, 3640},
        {13138, 3636},{13613, 3634},{14068, 3629},{14488, 3627},
        {14876, 3625},{15237, 3621},{15585, 3623},{15922, 3629}
      }
    },
    {
      /*Cb  qi=50  INTRA*/
      {
        {   11,    2},{  148,  368},{  278,  724},{  431, 1052},
        {  613, 1334},{  806, 1567},{ 1004, 1756},{ 1203, 1915},
        { 1405, 2051},{ 1621, 2163},{ 1833, 2262},{ 2059, 2347},
        { 2280, 2424},{ 2476, 2512},{ 2670, 2598},{ 2864, 2679},
        { 3037, 2754},{ 3201, 2826},{ 3376, 2887},{ 3562, 2936},
        { 3756, 2976},{ 3932, 3022},{ 4117, 3065},{ 4385, 3094}
      },
      /*Cb  qi=50  INTER*/
      {
        {   92,   -3},{  112,  343},{  109,  669},{  121, 1027},
        {  149, 1375},{  196, 1697},{  270, 1992},{  366, 2267},
        {  471, 2532},{  594, 2782},{  747, 3011},{  942, 3212},
        { 1189, 3384},{ 1497, 3521},{ 1875, 3613},{ 2297, 3673},
        { 2739, 3710},{ 3195, 3725},{ 3644, 3737},{ 4057, 3751},
        { 4445, 3763},{ 4841, 3769},{ 5211, 3779},{ 5568, 3769}
      }
    },
    {
      /*Cr  qi=50  INTRA*/
      {
        {   19,    7},{  155,  388},{  290,  744},{  474, 1060},
        {  666, 1324},{  847, 1549},{ 1033, 1737},{ 1219, 1898},
        { 1428, 2034},{ 1653, 2147},{ 1885, 2245},{ 2115, 2329},
        { 2316, 2410},{ 2517, 2486},{ 2730, 2539},{ 2901, 2586},
        { 3042, 2638},{ 3199, 2693},{ 3366, 2755},{ 3534, 2805},
        { 3738, 2858},{ 3934, 2916},{ 4079, 2975},{ 4257, 2992}
      },
      /*Cr  qi=50  INTER*/
      {
        {   87,    1},{  102,  353},{  103,  680},{  121, 1036},
        {  153, 1377},{  199, 1694},{  260, 1999},{  339, 2291},
        {  446, 2559},{  590, 2797},{  780, 3003},{ 1010, 3176},
        { 1267, 3331},{ 1547, 3474},{ 1874, 3594},{ 2245, 3688},
        { 2666, 3742},{ 3130, 3758},{ 3594, 3748},{ 4028, 3711},
        { 4415, 3674},{ 4771, 3641},{ 5122, 3605},{ 5482, 3569}
      }
    }
  },
  {
    {
      /*Y'  qi=51  INTRA*/
      {
        {  115,   93},{  819, 1164},{ 1739, 1806},{ 2695, 2101},
        { 3612, 2257},{ 4552, 2374},{ 5479, 2490},{ 6352, 2593},
        { 7158, 2683},{ 7898, 2761},{ 8580, 2823},{ 9177, 2854},
        { 9728, 2880},{10268, 2917},{10816, 2966},{11350, 3016},
        {11834, 3058},{12311, 3089},{12741, 3109},{13092, 3119},
        {13434, 3126},{13791, 3142},{14156, 3155},{14590, 3171}
      },
      /*Y'  qi=51  INTER*/
      {
        {   58,    0},{  171, 1307},{  610, 2407},{ 1563, 3175},
        { 3116, 3545},{ 4789, 3624},{ 6185, 3602},{ 7320, 3583},
        { 8282, 3574},{ 9124, 3569},{ 9878, 3567},{10569, 3565},
        {11207, 3563},{11801, 3564},{12359, 3566},{12884, 3567},
        {13373, 3568},{13841, 3567},{14289, 3566},{14699, 3568},
        {15086, 3568},{15446, 3566},{15788, 3564},{16103, 3568}
      }
    },
    {
      /*Cb  qi=51  INTRA*/
      {
        {   14,    3},{  161,  369},{  297,  722},{  454, 1047},
        {  639, 1325},{  833, 1554},{ 1033, 1742},{ 1236, 1897},
        { 1440, 2032},{ 1653, 2148},{ 1860, 2253},{ 2077, 2347},
        { 2288, 2432},{ 2476, 2525},{ 2661, 2621},{ 2841, 2714},
        { 3010, 2797},{ 3170, 2876},{ 3333, 2945},{ 3510, 3000},
        { 3696, 3054},{ 3865, 3114},{ 4046, 3164},{ 4317, 3200}
      },
      /*Cb  qi=51  INTER*/
      {
        {   88,  -11},{  109,  341},{  109,  668},{  126, 1019},
        {  168, 1358},{  233, 1670},{  329, 1955},{  451, 2219},
        {  584, 2472},{  736, 2711},{  931, 2923},{ 1179, 3104},
        { 1480, 3254},{ 1846, 3368},{ 2265, 3448},{ 2714, 3501},
        { 3180, 3524},{ 3638, 3529},{ 4074, 3543},{ 4485, 3560},
        { 4868, 3571},{ 5238, 3581},{ 5597, 3594},{ 5953, 3591}
      }
    },
    {
      /*Cr  qi=51  INTRA*/
      {
        {   24,    7},{  168,  388},{  309,  742},{  496, 1054},
        {  688, 1316},{  873, 1538},{ 1063, 1723},{ 1252, 1882},
        { 1460, 2018},{ 1682, 2134},{ 1907, 2238},{ 2125, 2332},
        { 2317, 2422},{ 2507, 2510},{ 2705, 2575},{ 2869, 2630},
        { 3015, 2684},{ 3178, 2744},{ 3329, 2815},{ 3477, 2878},
        { 3667, 2945},{ 3848, 3016},{ 3997, 3082},{ 4174, 3121}
      },
      /*Cr  qi=51  INTER*/
      {
        {   83,   -2},{  102,  351},{  102,  680},{  126, 1029},
        {  172, 1359},{  238, 1665},{  321, 1962},{  422, 2246},
        {  552, 2505},{  733, 2728},{  970, 2912},{ 1247, 3069},
        { 1552, 3209},{ 1876, 3338},{ 2251, 3440},{ 2692, 3502},
        { 3161, 3529},{ 3637, 3525},{ 4084, 3509},{ 4487, 3479},
        { 4850, 3444},{ 5181, 3419},{ 5507, 3406},{ 5786, 3398}
      }
    }
  },
  {
    {
      /*Y'  qi=52  INTRA*/
      {
        {  117,   93},{  814, 1168},{ 1729, 1822},{ 2706, 2119},
        { 3655, 2262},{ 4604, 2374},{ 5528, 2490},{ 6394, 2596},
        { 7189, 2691},{ 7921, 2777},{ 8596, 2846},{ 9184, 2885},
        { 9728, 2918},{10260, 2961},{10796, 3014},{11316, 3069},
        {11793, 3115},{12267, 3150},{12692, 3172},{13037, 3185},
        {13367, 3196},{13717, 3214},{14087, 3227},{14521, 3249}
      },
      /*Y'  qi=52  INTER*/
      {
        {   52,    0},{  169, 1308},{  668, 2382},{ 1735, 3112},
        { 3384, 3451},{ 5077, 3519},{ 6461, 3506},{ 7587, 3496},
        { 8545, 3494},{ 9384, 3494},{10142, 3498},{10838, 3501},
        {11475, 3503},{12078, 3508},{12640, 3511},{13162, 3513},
        {13654, 3517},{14130, 3521},{14576, 3522},{14980, 3523},
        {15369, 3523},{15737, 3522},{16071, 3521},{16382, 3516}
      }
    },
    {
      /*Cb  qi=52  INTRA*/
      {
        {   14,    3},{  163,  369},{  299,  722},{  457, 1044},
        {  645, 1319},{  843, 1545},{ 1050, 1728},{ 1261, 1879},
        { 1468, 2013},{ 1678, 2132},{ 1883, 2240},{ 2093, 2338},
        { 2301, 2428},{ 2488, 2523},{ 2667, 2619},{ 2843, 2718},
        { 3010, 2805},{ 3163, 2887},{ 3323, 2963},{ 3490, 3028},
        { 3665, 3087},{ 3841, 3145},{ 4011, 3197},{ 4289, 3230}
      },
      /*Cb  qi=52  INTER*/
      {
        {   98,   -7},{  109,  342},{  109,  668},{  126, 1018},
        {  170, 1355},{  242, 1663},{  352, 1941},{  490, 2195},
        {  642, 2439},{  823, 2666},{ 1052, 2868},{ 1333, 3039},
        { 1670, 3178},{ 2074, 3280},{ 2524, 3348},{ 2996, 3390},
        { 3469, 3410},{ 3923, 3420},{ 4355, 3434},{ 4771, 3451},
        { 5166, 3468},{ 5532, 3483},{ 5885, 3499},{ 6263, 3501}
      }
    },
    {
      /*Cr  qi=52  INTRA*/
      {
        {   25,    7},{  170,  388},{  312,  741},{  500, 1051},
        {  694, 1310},{  883, 1529},{ 1082, 1709},{ 1280, 1864},
        { 1491, 1998},{ 1710, 2117},{ 1932, 2225},{ 2143, 2324},
        { 2328, 2418},{ 2516, 2506},{ 2708, 2578},{ 2870, 2637},
        { 3017, 2693},{ 3170, 2758},{ 3312, 2835},{ 3455, 2901},
        { 3644, 2972},{ 3827, 3049},{ 3968, 3121},{ 4115, 3166}
      },
      /*Cr  qi=52  INTER*/
      {
        {   86,   -2},{  101,  352},{  100,  680},{  126, 1028},
        {  175, 1356},{  247, 1657},{  341, 1948},{  458, 2224},
        {  615, 2471},{  828, 2681},{ 1091, 2857},{ 1395, 3008},
        { 1732, 3140},{ 2095, 3257},{ 2502, 3348},{ 2968, 3402},
        { 3457, 3420},{ 3926, 3413},{ 4360, 3388},{ 4759, 3357},
        { 5128, 3329},{ 5449, 3306},{ 5741, 3295},{ 6071, 3296}
      }
    }
  },
  {
    {
      /*Y'  qi=53  INTRA*/
      {
        {  138,   93},{  850, 1161},{ 1773, 1810},{ 2763, 2103},
        { 3722, 2245},{ 4675, 2360},{ 5600, 2483},{ 6464, 2597},
        { 7255, 2700},{ 7982, 2792},{ 8652, 2867},{ 9237, 2913},
        { 9775, 2950},{10302, 2998},{10834, 3058},{11347, 3121},
        {11826, 3169},{12299, 3207},{12713, 3235},{13054, 3250},
        {13387, 3265},{13744, 3286},{14110, 3302},{14515, 3323}
      },
      /*Y'  qi=53  INTER*/
      {
        {   52,    2},{  169, 1308},{  680, 2377},{ 1763, 3103},
        { 3410, 3450},{ 5094, 3531},{ 6469, 3526},{ 7590, 3525},
        { 8547, 3530},{ 9385, 3534},{10139, 3540},{10835, 3548},
        {11479, 3553},{12075, 3559},{12634, 3565},{13159, 3570},
        {13650, 3573},{14124, 3576},{14575, 3580},{14993, 3583},
        {15375, 3584},{15744, 3584},{16091, 3583},{16421, 3586}
      }
    },
    {
      /*Cb  qi=53  INTRA*/
      {
        {   14,    3},{  167,  367},{  317,  717},{  492, 1033},
        {  687, 1306},{  887, 1531},{ 1095, 1715},{ 1309, 1866},
        { 1517, 2000},{ 1729, 2119},{ 1932, 2227},{ 2146, 2325},
        { 2358, 2414},{ 2544, 2511},{ 2724, 2611},{ 2902, 2711},
        { 3070, 2800},{ 3227, 2878},{ 3381, 2954},{ 3548, 3021},
        { 3724, 3077},{ 3888, 3140},{ 4065, 3196},{ 4359, 3225}
      },
      /*Cb  qi=53  INTER*/
      {
        {   93,   -8},{  110,  342},{  108,  668},{  125, 1018},
        {  170, 1355},{  242, 1663},{  353, 1939},{  494, 2192},
        {  651, 2433},{  838, 2658},{ 1076, 2856},{ 1368, 3022},
        { 1716, 3158},{ 2123, 3260},{ 2575, 3330},{ 3042, 3373},
        { 3507, 3396},{ 3962, 3413},{ 4394, 3430},{ 4797, 3452},
        { 5169, 3476},{ 5547, 3496},{ 5914, 3510},{ 6235, 3525}
      }
    },
    {
      /*Cr  qi=53  INTRA*/
      {
        {   25,    7},{  175,  386},{  335,  734},{  541, 1037},
        {  737, 1296},{  926, 1516},{ 1125, 1696},{ 1324, 1851},
        { 1540, 1984},{ 1763, 2102},{ 1989, 2210},{ 2202, 2310},
        { 2386, 2404},{ 2572, 2495},{ 2768, 2569},{ 2929, 2627},
        { 3071, 2684},{ 3231, 2749},{ 3374, 2825},{ 3514, 2894},
        { 3703, 2963},{ 3882, 3040},{ 4024, 3111},{ 4190, 3150}
      },
      /*Cr  qi=53  INTER*/
      {
        {   87,   -1},{   99,  352},{  100,  680},{  125, 1027},
        {  175, 1355},{  249, 1657},{  343, 1946},{  462, 2220},
        {  624, 2465},{  844, 2671},{ 1122, 2841},{ 1435, 2989},
        { 1768, 3125},{ 2134, 3243},{ 2545, 3334},{ 3002, 3393},
        { 3490, 3412},{ 3965, 3405},{ 4401, 3384},{ 4797, 3359},
        { 5156, 3328},{ 5482, 3297},{ 5800, 3292},{ 6135, 3293}
      }
    }
  },
  {
    {
      /*Y'  qi=54  INTRA*/
      {
        {  184,   94},{  902, 1151},{ 1876, 1776},{ 2881, 2057},
        { 3832, 2200},{ 4785, 2315},{ 5709, 2442},{ 6570, 2562},
        { 7362, 2672},{ 8092, 2771},{ 8760, 2852},{ 9337, 2901},
        { 9874, 2943},{10402, 2995},{10928, 3059},{11443, 3126},
        {11926, 3178},{12396, 3220},{12805, 3251},{13139, 3266},
        {13466, 3280},{13822, 3304},{14184, 3322},{14585, 3342}
      },
      /*Y'  qi=54  INTER*/
      {
        {   60,    5},{  169, 1308},{  683, 2375},{ 1791, 3090},
        { 3478, 3412},{ 5184, 3470},{ 6568, 3455},{ 7697, 3446},
        { 8659, 3446},{ 9503, 3447},{10266, 3450},{10971, 3454},
        {11619, 3458},{12223, 3462},{12789, 3467},{13315, 3471},
        {13811, 3475},{14291, 3479},{14743, 3479},{15148, 3481},
        {15535, 3483},{15913, 3481},{16252, 3479},{16569, 3472}
      }
    },
    {
      /*Cb  qi=54  INTRA*/
      {
        {   13,    2},{  165,  367},{  318,  715},{  498, 1030},
        {  698, 1301},{  906, 1523},{ 1121, 1703},{ 1336, 1853},
        { 1549, 1984},{ 1765, 2100},{ 1974, 2207},{ 2192, 2306},
        { 2402, 2396},{ 2587, 2493},{ 2773, 2591},{ 2953, 2691},
        { 3119, 2778},{ 3277, 2858},{ 3430, 2940},{ 3603, 3004},
        { 3788, 3059},{ 3950, 3121},{ 4128, 3173},{ 4398, 3215}
      },
      /*Cb  qi=54  INTER*/
      {
        {  100,   -3},{  109,  343},{  107,  668},{  125, 1018},
        {  169, 1354},{  241, 1662},{  353, 1938},{  496, 2190},
        {  655, 2431},{  843, 2655},{ 1082, 2851},{ 1381, 3015},
        { 1739, 3146},{ 2154, 3243},{ 2610, 3310},{ 3094, 3344},
        { 3581, 3358},{ 4034, 3371},{ 4457, 3384},{ 4867, 3399},
        { 5255, 3413},{ 5630, 3425},{ 6003, 3440},{ 6346, 3440}
      }
    },
    {
      /*Cr  qi=54  INTRA*/
      {
        {   23,    7},{  174,  386},{  338,  732},{  549, 1034},
        {  751, 1289},{  947, 1506},{ 1150, 1685},{ 1353, 1837},
        { 1572, 1969},{ 1800, 2087},{ 2031, 2192},{ 2248, 2291},
        { 2434, 2387},{ 2622, 2477},{ 2815, 2549},{ 2976, 2607},
        { 3126, 2663},{ 3286, 2727},{ 3427, 2807},{ 3569, 2877},
        { 3761, 2941},{ 3942, 3016},{ 4084, 3093},{ 4226, 3131}
      },
      /*Cr  qi=54  INTER*/
      {
        {   88,   -2},{   99,  351},{  100,  680},{  125, 1027},
        {  175, 1354},{  248, 1656},{  343, 1945},{  463, 2219},
        {  626, 2463},{  850, 2668},{ 1128, 2837},{ 1445, 2983},
        { 1791, 3111},{ 2168, 3224},{ 2597, 3309},{ 3075, 3351},
        { 3560, 3364},{ 4029, 3356},{ 4464, 3335},{ 4858, 3307},
        { 5218, 3275},{ 5547, 3256},{ 5850, 3247},{ 6171, 3214}
      }
    }
  },
  {
    {
      /*Y'  qi=55  INTRA*/
      {
        {  178,   95},{  968, 1137},{ 2000, 1747},{ 3013, 2027},
        { 3966, 2173},{ 4920, 2294},{ 5842, 2427},{ 6702, 2553},
        { 7489, 2668},{ 8213, 2773},{ 8875, 2858},{ 9452, 2913},
        { 9986, 2959},{10504, 3016},{11023, 3085},{11530, 3157},
        {12011, 3213},{12480, 3257},{12882, 3291},{13214, 3310},
        {13542, 3325},{13890, 3350},{14248, 3371},{14671, 3398}
      },
      /*Y'  qi=55  INTER*/
      {
        {   59,    5},{  170, 1307},{  725, 2358},{ 1886, 3058},
        { 3589, 3385},{ 5284, 3459},{ 6654, 3458},{ 7771, 3461},
        { 8727, 3470},{ 9564, 3478},{10322, 3488},{11019, 3497},
        {11658, 3505},{12258, 3513},{12819, 3520},{13344, 3527},
        {13840, 3533},{14314, 3537},{14755, 3541},{15161, 3544},
        {15552, 3548},{15916, 3548},{16257, 3548},{16576, 3540}
      }
    },
    {
      /*Cb  qi=55  INTRA*/
      {
        {   13,    2},{  167,  366},{  322,  714},{  508, 1026},
        {  716, 1292},{  930, 1511},{ 1148, 1690},{ 1366, 1839},
        { 1578, 1972},{ 1793, 2090},{ 2001, 2199},{ 2217, 2300},
        { 2427, 2393},{ 2609, 2495},{ 2784, 2600},{ 2961, 2704},
        { 3121, 2797},{ 3268, 2884},{ 3423, 2965},{ 3590, 3032},
        { 3764, 3096},{ 3926, 3165},{ 4101, 3223},{ 4405, 3258}
      },
      /*Cb  qi=55  INTER*/
      {
        {   90,   -4},{  109,  344},{  107,  668},{  126, 1017},
        {  172, 1351},{  249, 1657},{  370, 1928},{  527, 2174},
        {  702, 2407},{  909, 2624},{ 1170, 2814},{ 1493, 2970},
        { 1869, 3097},{ 2292, 3192},{ 2752, 3258},{ 3232, 3295},
        { 3709, 3314},{ 4156, 3335},{ 4592, 3355},{ 5004, 3373},
        { 5377, 3389},{ 5737, 3411},{ 6092, 3432},{ 6473, 3423}
      }
    },
    {
      /*Cr  qi=55  INTRA*/
      {
        {   23,    7},{  175,  385},{  342,  730},{  561, 1028},
        {  771, 1279},{  973, 1493},{ 1181, 1669},{ 1384, 1822},
        { 1602, 1956},{ 1830, 2076},{ 2057, 2184},{ 2270, 2288},
        { 2452, 2389},{ 2637, 2484},{ 2823, 2559},{ 2983, 2621},
        { 3129, 2682},{ 3280, 2753},{ 3417, 2833},{ 3554, 2904},
        { 3743, 2977},{ 3921, 3060},{ 4055, 3137},{ 4185, 3186}
      },
      /*Cr  qi=55  INTER*/
      {
        {   85,    0},{   99,  352},{  100,  679},{  126, 1025},
        {  178, 1351},{  256, 1650},{  359, 1935},{  493, 2202},
        {  675, 2439},{  921, 2636},{ 1220, 2799},{ 1552, 2941},
        { 1910, 3068},{ 2303, 3177},{ 2735, 3262},{ 3206, 3311},
        { 3689, 3333},{ 4152, 3327},{ 4588, 3299},{ 4978, 3272},
        { 5325, 3243},{ 5651, 3221},{ 5969, 3210},{ 6218, 3185}
      }
    }
  },
  {
    {
      /*Y'  qi=56  INTRA*/
      {
        {  137,  104},{ 1048, 1128},{ 2147, 1760},{ 3261, 2029},
        { 4319, 2131},{ 5310, 2234},{ 6245, 2351},{ 7101, 2464},
        { 7886, 2572},{ 8610, 2675},{ 9270, 2762},{ 9840, 2818},
        {10365, 2869},{10875, 2928},{11393, 2997},{11900, 3071},
        {12371, 3128},{12834, 3172},{13233, 3208},{13562, 3228},
        {13878, 3245},{14221, 3271},{14584, 3292},{15008, 3320}
      },
      /*Y'  qi=56  INTER*/
      {
        {   19,   21},{  207, 1292},{ 1031, 2252},{ 2553, 2846},
        { 4463, 3085},{ 6137, 3131},{ 7441, 3151},{ 8526, 3172},
        { 9468, 3193},{10301, 3209},{11059, 3224},{11760, 3237},
        {12405, 3249},{13008, 3261},{13570, 3270},{14100, 3278},
        {14597, 3284},{15074, 3289},{15524, 3297},{15929, 3302},
        {16314, 3306},{16675, 3307},{17004, 3305},{17288, 3301}
      }
    },
    {
      /*Cb  qi=56  INTRA*/
      {
        {   16,    3},{  188,  367},{  353,  712},{  546, 1017},
        {  765, 1275},{  989, 1484},{ 1221, 1653},{ 1459, 1791},
        { 1681, 1920},{ 1893, 2046},{ 2102, 2160},{ 2323, 2257},
        { 2534, 2347},{ 2720, 2447},{ 2902, 2549},{ 3075, 2654},
        { 3239, 2749},{ 3392, 2835},{ 3544, 2920},{ 3712, 2988},
        { 3882, 3052},{ 4052, 3123},{ 4227, 3181},{ 4483, 3213}
      },
      /*Cb  qi=56  INTER*/
      {
        {   92,   -1},{  111,  343},{  114,  665},{  148, 1003},
        {  224, 1321},{  345, 1609},{  526, 1858},{  754, 2077},
        { 1009, 2281},{ 1319, 2464},{ 1702, 2614},{ 2145, 2732},
        { 2625, 2824},{ 3123, 2890},{ 3634, 2933},{ 4137, 2954},
        { 4614, 2965},{ 5052, 2988},{ 5468, 3015},{ 5852, 3035},
        { 6213, 3060},{ 6557, 3081},{ 6906, 3094},{ 7243, 3112}
      }
    },
    {
      /*Cr  qi=56  INTRA*/
      {
        {   28,    8},{  195,  385},{  373,  727},{  598, 1019},
        {  816, 1263},{ 1033, 1465},{ 1260, 1630},{ 1482, 1773},
        { 1717, 1900},{ 1949, 2018},{ 2178, 2128},{ 2393, 2233},
        { 2570, 2338},{ 2749, 2435},{ 2937, 2514},{ 3097, 2577},
        { 3240, 2638},{ 3398, 2709},{ 3540, 2791},{ 3673, 2865},
        { 3869, 2938},{ 4049, 3019},{ 4179, 3095},{ 4330, 3137}
      },
      /*Cr  qi=56  INTER*/
      {
        {   83,    0},{   99,  353},{  103,  676},{  146, 1010},
        {  232, 1320},{  355, 1601},{  512, 1866},{  713, 2109},
        {  988, 2312},{ 1344, 2471},{ 1750, 2602},{ 2180, 2719},
        { 2642, 2819},{ 3141, 2892},{ 3653, 2939},{ 4159, 2961},
        { 4636, 2961},{ 5072, 2945},{ 5464, 2917},{ 5813, 2895},
        { 6134, 2890},{ 6458, 2883},{ 6735, 2881},{ 6953, 2902}
      }
    }
  },
  {
    {
      /*Y'  qi=57  INTRA*/
      {
        {  170,  106},{ 1106, 1120},{ 2246, 1740},{ 3399, 1993},
        { 4482, 2077},{ 5492, 2167},{ 6446, 2273},{ 7324, 2379},
        { 8130, 2482},{ 8866, 2578},{ 9537, 2661},{10119, 2715},
        {10646, 2762},{11161, 2820},{11694, 2886},{12214, 2957},
        {12693, 3013},{13166, 3053},{13569, 3087},{13897, 3106},
        {14224, 3122},{14568, 3148},{14931, 3167},{15390, 3192}
      },
      /*Y'  qi=57  INTER*/
      {
        {   19,   20},{  205, 1292},{ 1096, 2229},{ 2775, 2766},
        { 4811, 2943},{ 6512, 2964},{ 7832, 2976},{ 8940, 2990},
        { 9903, 3004},{10755, 3017},{11532, 3029},{12243, 3039},
        {12891, 3047},{13502, 3058},{14073, 3065},{14603, 3071},
        {15097, 3078},{15581, 3083},{16036, 3086},{16452, 3090},
        {16855, 3093},{17222, 3094},{17552, 3092},{17851, 3098}
      }
    },
    {
      /*Cb  qi=57  INTRA*/
      {
        {   16,    3},{  197,  365},{  384,  704},{  603, 1001},
        {  837, 1252},{ 1077, 1455},{ 1326, 1618},{ 1581, 1748},
        { 1819, 1871},{ 2042, 1993},{ 2264, 2104},{ 2500, 2196},
        { 2722, 2280},{ 2916, 2375},{ 3103, 2473},{ 3290, 2575},
        { 3456, 2667},{ 3612, 2748},{ 3775, 2829},{ 3958, 2896},
        { 4145, 2947},{ 4307, 3012},{ 4476, 3070},{ 4733, 3110}
      },
      /*Cb  qi=57  INTER*/
      {
        {   94,   -1},{  111,  344},{  112,  665},{  147, 1002},
        {  227, 1319},{  353, 1604},{  543, 1849},{  785, 2062},
        { 1066, 2257},{ 1408, 2430},{ 1827, 2568},{ 2320, 2670},
        { 2848, 2743},{ 3386, 2791},{ 3934, 2812},{ 4453, 2820},
        { 4929, 2830},{ 5368, 2842},{ 5787, 2856},{ 6190, 2875},
        { 6554, 2896},{ 6895, 2913},{ 7229, 2927},{ 7572, 2932}
      }
    },
    {
      /*Cr  qi=57  INTRA*/
      {
        {   28,    8},{  207,  383},{  413,  716},{  661,  999},
        {  889, 1237},{ 1123, 1433},{ 1365, 1592},{ 1603, 1731},
        { 1853, 1852},{ 2103, 1965},{ 2345, 2072},{ 2571, 2173},
        { 2763, 2271},{ 2949, 2364},{ 3146, 2438},{ 3315, 2497},
        { 3459, 2552},{ 3618, 2616},{ 3767, 2697},{ 3906, 2773},
        { 4099, 2841},{ 4281, 2916},{ 4429, 2987},{ 4569, 3030}
      },
      /*Cr  qi=57  INTER*/
      {
        {   85,    0},{   99,  352},{  102,  675},{  147, 1008},
        {  235, 1317},{  363, 1597},{  529, 1858},{  748, 2094},
        { 1050, 2287},{ 1439, 2436},{ 1877, 2557},{ 2352, 2660},
        { 2869, 2740},{ 3413, 2791},{ 3962, 2815},{ 4485, 2819},
        { 4955, 2816},{ 5382, 2800},{ 5769, 2772},{ 6107, 2748},
        { 6443, 2740},{ 6754, 2739},{ 7029, 2737},{ 7284, 2745}
      }
    }
  },
  {
    {
      /*Y'  qi=58  INTRA*/
      {
        {  164,  109},{ 1198, 1111},{ 2396, 1737},{ 3606, 1978},
        { 4727, 2048},{ 5749, 2138},{ 6708, 2243},{ 7584, 2347},
        { 8388, 2449},{ 9122, 2549},{ 9784, 2635},{10354, 2691},
        {10876, 2740},{11385, 2800},{11912, 2869},{12429, 2941},
        {12902, 2997},{13375, 3040},{13779, 3075},{14103, 3096},
        {14435, 3112},{14783, 3140},{15141, 3160},{15599, 3186}
      },
      /*Y'  qi=58  INTER*/
      {
        {   14,   23},{  210, 1290},{ 1277, 2178},{ 3118, 2677},
        { 5207, 2834},{ 6902, 2857},{ 8218, 2878},{ 9323, 2900},
        {10285, 2919},{11132, 2934},{11899, 2949},{12599, 2961},
        {13235, 2971},{13835, 2982},{14394, 2991},{14917, 2997},
        {15412, 3005},{15882, 3009},{16325, 3013},{16735, 3016},
        {17131, 3018},{17501, 3021},{17824, 3021},{18125, 3016}
      }
    },
    {
      /*Cb  qi=58  INTRA*/
      {
        {   17,    3},{  200,  365},{  389,  703},{  613,  996},
        {  853, 1243},{ 1095, 1445},{ 1349, 1604},{ 1613, 1731},
        { 1853, 1853},{ 2074, 1978},{ 2292, 2091},{ 2526, 2184},
        { 2750, 2266},{ 2945, 2360},{ 3134, 2458},{ 3320, 2561},
        { 3482, 2654},{ 3641, 2737},{ 3804, 2818},{ 3985, 2881},
        { 4168, 2935},{ 4331, 3003},{ 4499, 3060},{ 4751, 3100}
      },
      /*Cb  qi=58  INTER*/
      {
        {   94,   -1},{  112,  345},{  112,  665},{  152,  998},
        {  247, 1307},{  406, 1580},{  644, 1810},{  938, 2007},
        { 1271, 2189},{ 1668, 2348},{ 2151, 2470},{ 2691, 2558},
        { 3249, 2619},{ 3798, 2659},{ 4334, 2682},{ 4849, 2692},
        { 5314, 2700},{ 5747, 2721},{ 6167, 2742},{ 6547, 2765},
        { 6902, 2790},{ 7251, 2804},{ 7583, 2819},{ 7924, 2833}
      }
    },
    {
      /*Cr  qi=58  INTRA*/
      {
        {   29,    8},{  210,  382},{  419,  714},{  671,  993},
        {  903, 1229},{ 1141, 1422},{ 1390, 1578},{ 1635, 1713},
        { 1889, 1833},{ 2140, 1946},{ 2379, 2055},{ 2604, 2157},
        { 2794, 2256},{ 2977, 2349},{ 3174, 2422},{ 3339, 2482},
        { 3483, 2537},{ 3643, 2604},{ 3790, 2684},{ 3927, 2757},
        { 4112, 2826},{ 4294, 2900},{ 4451, 2975},{ 4600, 3011}
      },
      /*Cr  qi=58  INTER*/
      {
        {   86,    0},{   99,  352},{  103,  675},{  151, 1004},
        {  256, 1306},{  417, 1573},{  628, 1819},{  901, 2040},
        { 1262, 2217},{ 1705, 2353},{ 2191, 2466},{ 2713, 2556},
        { 3268, 2622},{ 3831, 2664},{ 4374, 2682},{ 4881, 2686},
        { 5339, 2685},{ 5747, 2668},{ 6123, 2646},{ 6465, 2630},
        { 6783, 2618},{ 7082, 2623},{ 7366, 2632},{ 7673, 2654}
      }
    }
  },
  {
    {
      /*Y'  qi=59  INTRA*/
      {
        {  142,  112},{ 1259, 1100},{ 2552, 1711},{ 3815, 1933},
        { 4955, 1987},{ 5983, 2068},{ 6949, 2165},{ 7832, 2263},
        { 8645, 2359},{ 9392, 2454},{10066, 2536},{10643, 2589},
        {11174, 2636},{11696, 2693},{12230, 2758},{12752, 2826},
        {13239, 2883},{13721, 2926},{14139, 2959},{14479, 2978},
        {14811, 2993},{15166, 3020},{15532, 3039},{16000, 3062}
      },
      /*Y'  qi=59  INTER*/
      {
        {    8,   25},{  211, 1289},{ 1394, 2144},{ 3421, 2580},
        { 5611, 2689},{ 7316, 2701},{ 8643, 2717},{ 9762, 2734},
        {10735, 2750},{11587, 2763},{12353, 2775},{13056, 2785},
        {13693, 2793},{14288, 2805},{14843, 2814},{15361, 2821},
        {15857, 2827},{16328, 2831},{16763, 2834},{17171, 2838},
        {17568, 2840},{17941, 2842},{18285, 2843},{18586, 2839}
      }
    },
    {
      /*Cb  qi=59  INTRA*/
      {
        {   17,    3},{  224,  363},{  441,  696},{  689,  982},
        {  945, 1222},{ 1204, 1416},{ 1474, 1571},{ 1751, 1695},
        { 2001, 1816},{ 2228, 1941},{ 2453, 2055},{ 2693, 2147},
        { 2924, 2227},{ 3125, 2321},{ 3321, 2416},{ 3510, 2520},
        { 3676, 2616},{ 3839, 2699},{ 4008, 2778},{ 4193, 2842},
        { 4371, 2898},{ 4535, 2965},{ 4710, 3023},{ 4921, 3068}
      },
      /*Cb  qi=59  INTER*/
      {
        {   95,   -5},{  111,  343},{  112,  664},{  157,  995},
        {  258, 1302},{  429, 1569},{  691, 1790},{ 1017, 1977},
        { 1387, 2148},{ 1832, 2294},{ 2368, 2401},{ 2961, 2472},
        { 3553, 2518},{ 4133, 2545},{ 4688, 2557},{ 5198, 2563},
        { 5663, 2574},{ 6100, 2590},{ 6511, 2608},{ 6898, 2621},
        { 7274, 2634},{ 7631, 2655},{ 7984, 2669},{ 8361, 2669}
      }
    },
    {
      /*Cr  qi=59  INTRA*/
      {
        {   31,    8},{  240,  379},{  480,  706},{  748,  978},
        {  993, 1208},{ 1250, 1394},{ 1519, 1543},{ 1779, 1674},
        { 2047, 1792},{ 2307, 1904},{ 2552, 2013},{ 2780, 2116},
        { 2973, 2216},{ 3165, 2309},{ 3362, 2383},{ 3528, 2444},
        { 3677, 2499},{ 3841, 2566},{ 3995, 2646},{ 4139, 2720},
        { 4324, 2793},{ 4504, 2867},{ 4658, 2939},{ 4806, 2975}
      },
      /*Cr  qi=59  INTER*/
      {
        {   89,   -3},{   98,  352},{  103,  674},{  156, 1002},
        {  268, 1300},{  441, 1562},{  673, 1801},{  980, 2010},
        { 1385, 2175},{ 1868, 2301},{ 2401, 2402},{ 2984, 2474},
        { 3591, 2520},{ 4179, 2545},{ 4729, 2555},{ 5232, 2553},
        { 5679, 2545},{ 6081, 2530},{ 6447, 2510},{ 6791, 2496},
        { 7101, 2487},{ 7393, 2489},{ 7684, 2499},{ 7950, 2501}
      }
    }
  },
  {
    {
      /*Y'  qi=60  INTRA*/
      {
        {   92,  116},{ 1361, 1085},{ 2746, 1686},{ 4050, 1895},
        { 5209, 1939},{ 6244, 2012},{ 7213, 2103},{ 8105, 2197},
        { 8928, 2290},{ 9685, 2381},{10371, 2460},{10952, 2511},
        {11487, 2556},{12026, 2611},{12574, 2674},{13102, 2739},
        {13597, 2793},{14092, 2831},{14523, 2862},{14862, 2881},
        {15198, 2897},{15568, 2923},{15949, 2941},{16416, 2964}
      },
      /*Y'  qi=60  INTER*/
      {
        {    4,   30},{  215, 1287},{ 1547, 2104},{ 3729, 2491},
        { 5973, 2568},{ 7672, 2577},{ 9001, 2591},{10123, 2606},
        {11094, 2620},{11943, 2632},{12709, 2643},{13409, 2652},
        {14044, 2660},{14641, 2669},{15193, 2677},{15709, 2684},
        {16201, 2689},{16675, 2693},{17118, 2696},{17522, 2701},
        {17920, 2704},{18293, 2706},{18620, 2702},{18923, 2700}
      }
    },
    {
      /*Cb  qi=60  INTRA*/
      {
        {   18,    3},{  227,  362},{  447,  694},{  708,  974},
        {  981, 1207},{ 1252, 1397},{ 1532, 1547},{ 1822, 1663},
        { 2082, 1780},{ 2316, 1903},{ 2548, 2013},{ 2794, 2101},
        { 3029, 2178},{ 3242, 2266},{ 3445, 2360},{ 3638, 2459},
        { 3816, 2547},{ 3980, 2628},{ 4146, 2708},{ 4344, 2766},
        { 4546, 2812},{ 4725, 2872},{ 4880, 2930},{ 5054, 2966}
      },
      /*Cb  qi=60  INTER*/
      {
        {   97,   -4},{  112,  343},{  114,  664},{  162,  993},
        {  273, 1294},{  472, 1553},{  774, 1762},{ 1138, 1939},
        { 1543, 2102},{ 2034, 2236},{ 2620, 2329},{ 3244, 2389},
        { 3860, 2423},{ 4443, 2440},{ 4997, 2449},{ 5502, 2455},
        { 5962, 2458},{ 6413, 2466},{ 6836, 2485},{ 7217, 2506},
        { 7592, 2518},{ 7957, 2533},{ 8291, 2543},{ 8574, 2545}
      }
    },
    {
      /*Cr  qi=60  INTRA*/
      {
        {   32,    8},{  243,  379},{  488,  702},{  771,  968},
        { 1030, 1192},{ 1300, 1373},{ 1581, 1517},{ 1854, 1643},
        { 2127, 1757},{ 2393, 1864},{ 2645, 1968},{ 2879, 2068},
        { 3078, 2166},{ 3277, 2256},{ 3484, 2325},{ 3660, 2381},
        { 3808, 2433},{ 3970, 2496},{ 4138, 2571},{ 4288, 2643},
        { 4475, 2710},{ 4655, 2778},{ 4810, 2843},{ 4959, 2879}
      },
      /*Cr  qi=60  INTER*/
      {
        {   86,   -2},{   99,  352},{  103,  673},{  160,  998},
        {  284, 1292},{  484, 1546},{  753, 1774},{ 1100, 1973},
        { 1546, 2129},{ 2072, 2246},{ 2652, 2334},{ 3279, 2392},
        { 3911, 2425},{ 4504, 2440},{ 5044, 2443},{ 5536, 2440},
        { 5979, 2430},{ 6381, 2413},{ 6735, 2397},{ 7062, 2382},
        { 7383, 2376},{ 7680, 2375},{ 7962, 2373},{ 8203, 2379}
      }
    }
  },
  {
    {
      /*Y'  qi=61  INTRA*/
      {
        {   54,  121},{ 1477, 1069},{ 3061, 1638},{ 4465, 1808},
        { 5649, 1827},{ 6710, 1884},{ 7716, 1958},{ 8648, 2037},
        { 9514, 2116},{10311, 2192},{11033, 2261},{11641, 2305},
        {12202, 2342},{12771, 2387},{13356, 2440},{13924, 2493},
        {14444, 2541},{14951, 2576},{15409, 2600},{15779, 2615},
        {16131, 2626},{16521, 2648},{16921, 2663},{17409, 2694}
      },
      /*Y'  qi=61  INTER*/
      {
        {   -1,   32},{  216, 1286},{ 1806, 2036},{ 4279, 2327},
        { 6629, 2352},{ 8347, 2352},{ 9707, 2357},{10860, 2364},
        {11857, 2372},{12726, 2377},{13508, 2382},{14225, 2387},
        {14877, 2392},{15484, 2398},{16048, 2401},{16581, 2405},
        {17092, 2409},{17573, 2409},{18016, 2410},{18427, 2413},
        {18829, 2415},{19221, 2415},{19578, 2415},{19980, 2413}
      }
    },
    {
      /*Cb  qi=61  INTRA*/
      {
        {   19,    3},{  231,  362},{  456,  693},{  733,  965},
        { 1032, 1188},{ 1330, 1369},{ 1637, 1508},{ 1956, 1612},
        { 2241, 1718},{ 2496, 1832},{ 2750, 1932},{ 3019, 2007},
        { 3274, 2074},{ 3505, 2154},{ 3725, 2236},{ 3943, 2323},
        { 4138, 2403},{ 4323, 2476},{ 4505, 2543},{ 4706, 2592},
        { 4909, 2630},{ 5109, 2675},{ 5292, 2724},{ 5495, 2768}
      },
      /*Cb  qi=61  INTER*/
      {
        {   91,   -2},{  111,  344},{  114,  663},{  166,  989},
        {  291, 1285},{  522, 1534},{  875, 1729},{ 1302, 1889},
        { 1786, 2031},{ 2368, 2141},{ 3042, 2207},{ 3734, 2243},
        { 4388, 2259},{ 4982, 2264},{ 5533, 2265},{ 6043, 2262},
        { 6524, 2264},{ 6982, 2274},{ 7422, 2283},{ 7831, 2295},
        { 8198, 2308},{ 8593, 2319},{ 8965, 2329},{ 9258, 2340}
      }
    },
    {
      /*Cr  qi=61  INTRA*/
      {
        {   33,    9},{  245,  378},{  497,  699},{  801,  958},
        { 1087, 1171},{ 1384, 1342},{ 1692, 1474},{ 1992, 1589},
        { 2290, 1692},{ 2576, 1789},{ 2852, 1884},{ 3109, 1973},
        { 3324, 2061},{ 3544, 2142},{ 3763, 2199},{ 3945, 2244},
        { 4103, 2292},{ 4283, 2349},{ 4469, 2413},{ 4635, 2476},
        { 4836, 2534},{ 5038, 2592},{ 5210, 2649},{ 5358, 2682}
      },
      /*Cr  qi=61  INTER*/
      {
        {   82,    0},{   97,  353},{  104,  672},{  165,  995},
        {  303, 1284},{  532, 1529},{  852, 1742},{ 1273, 1921},
        { 1798, 2057},{ 2409, 2154},{ 3090, 2212},{ 3794, 2240},
        { 4460, 2251},{ 5057, 2249},{ 5596, 2249},{ 6085, 2245},
        { 6519, 2234},{ 6908, 2220},{ 7269, 2203},{ 7618, 2196},
        { 7949, 2198},{ 8269, 2195},{ 8554, 2196},{ 8928, 2217}
      }
    }
  },
  {
    {
      /*Y'  qi=62  INTRA*/
      {
        {   29,  124},{ 1527, 1067},{ 3221, 1618},{ 4703, 1751},
        { 5909, 1744},{ 7001, 1779},{ 8057, 1829},{ 9049, 1885},
        { 9968, 1943},{10813, 1999},{11572, 2050},{12206, 2082},
        {12801, 2107},{13402, 2140},{14020, 2180},{14625, 2223},
        {15179, 2260},{15718, 2288},{16196, 2305},{16581, 2313},
        {16963, 2324},{17382, 2341},{17800, 2351},{18318, 2376}
      },
      /*Y'  qi=62  INTER*/
      {
        {   -8,   36},{  218, 1284},{ 2073, 1965},{ 4814, 2159},
        { 7237, 2138},{ 8979, 2124},{10378, 2115},{11570, 2109},
        {12601, 2106},{13503, 2103},{14320, 2103},{15064, 2103},
        {15746, 2103},{16384, 2104},{16975, 2105},{17534, 2105},
        {18062, 2106},{18564, 2107},{19035, 2106},{19471, 2107},
        {19890, 2107},{20288, 2107},{20651, 2107},{21012, 2108}
      }
    },
    {
      /*Cb  qi=62  INTRA*/
      {
        {   21,    3},{  283,  360},{  565,  683},{  907,  938},
        { 1269, 1143},{ 1611, 1311},{ 1949, 1441},{ 2290, 1535},
        { 2596, 1632},{ 2877, 1738},{ 3162, 1828},{ 3458, 1893},
        { 3745, 1948},{ 4011, 2016},{ 4253, 2089},{ 4506, 2164},
        { 4734, 2233},{ 4943, 2294},{ 5162, 2353},{ 5381, 2393},
        { 5593, 2420},{ 5807, 2454},{ 6003, 2496},{ 6210, 2543}
      },
      /*Cb  qi=62  INTER*/
      {
        {   91,   -1},{  110,  344},{  113,  663},{  169,  987},
        {  306, 1279},{  562, 1519},{  961, 1701},{ 1450, 1845},
        { 2013, 1967},{ 2686, 2053},{ 3437, 2095},{ 4171, 2109},
        { 4841, 2109},{ 5441, 2105},{ 6002, 2097},{ 6542, 2089},
        { 7028, 2087},{ 7491, 2088},{ 7949, 2090},{ 8377, 2089},
        { 8789, 2095},{ 9195, 2103},{ 9569, 2104},{ 9937, 2102}
      }
    },
    {
      /*Cr  qi=62  INTRA*/
      {
        {   38,    8},{  308,  374},{  619,  685},{  984,  925},
        { 1326, 1126},{ 1662, 1285},{ 1999, 1407},{ 2328, 1512},
        { 2659, 1604},{ 2976, 1691},{ 3285, 1774},{ 3570, 1853},
        { 3815, 1931},{ 4068, 1998},{ 4304, 2044},{ 4491, 2082},
        { 4666, 2124},{ 4870, 2174},{ 5078, 2231},{ 5262, 2285},
        { 5480, 2335},{ 5703, 2378},{ 5905, 2423},{ 6075, 2454}
      },
      /*Cr  qi=62  INTER*/
      {
        {   79,    1},{   95,  353},{  102,  671},{  169,  992},
        {  318, 1277},{  569, 1515},{  936, 1716},{ 1428, 1876},
        { 2034, 1993},{ 2738, 2067},{ 3511, 2095},{ 4268, 2094},
        { 4943, 2087},{ 5543, 2079},{ 6074, 2074},{ 6552, 2069},
        { 6985, 2057},{ 7366, 2043},{ 7728, 2030},{ 8086, 2021},
        { 8423, 2017},{ 8752, 2016},{ 9057, 2014},{ 9376, 2008}
      }
    }
  },
  {
    {
      /*Y'  qi=63  INTRA*/
      {
        {  -59,  134},{ 1734, 1036},{ 3743, 1521},{ 5309, 1618},
        { 6520, 1597},{ 7664, 1609},{ 8809, 1630},{ 9894, 1657},
        {10907, 1687},{11838, 1717},{12673, 1744},{13379, 1758},
        {14038, 1767},{14698, 1784},{15379, 1806},{16062, 1831},
        {16694, 1852},{17300, 1867},{17827, 1878},{18250, 1881},
        {18702, 1884},{19199, 1892},{19665, 1896},{20273, 1908}
      },
      /*Y'  qi=63  INTER*/
      {
        {   -7,   33},{  209, 1285},{ 2309, 1904},{ 5274, 2025},
        { 7801, 1966},{ 9637, 1924},{11126, 1892},{12403, 1868},
        {13515, 1849},{14491, 1834},{15380, 1822},{16197, 1814},
        {16944, 1806},{17645, 1799},{18303, 1794},{18916, 1789},
        {19494, 1785},{20056, 1782},{20568, 1779},{21047, 1776},
        {21508, 1775},{21925, 1772},{22327, 1770},{22678, 1771}
      }
    },
    {
      /*Cb  qi=63  INTRA*/
      {
        {   20,    3},{  294,  357},{  608,  673},{ 1047,  908},
        { 1501, 1090},{ 1898, 1240},{ 2275, 1353},{ 2654, 1427},
        { 3014, 1502},{ 3366, 1579},{ 3726, 1637},{ 4084, 1674},
        { 4425, 1703},{ 4752, 1743},{ 5058, 1791},{ 5377, 1838},
        { 5676, 1877},{ 5946, 1912},{ 6213, 1945},{ 6458, 1969},
        { 6704, 1982},{ 6969, 1997},{ 7210, 2017},{ 7439, 2037}
      },
      /*Cb  qi=63  INTER*/
      {
        {   86,    1},{  108,  345},{  111,  663},{  168,  985},
        {  307, 1276},{  577, 1513},{ 1007, 1688},{ 1550, 1819},
        { 2189, 1921},{ 2938, 1981},{ 3744, 2002},{ 4512, 2002},
        { 5199, 1996},{ 5824, 1986},{ 6419, 1971},{ 6978, 1954},
        { 7507, 1940},{ 8015, 1932},{ 8502, 1928},{ 8978, 1920},
        { 9410, 1915},{ 9842, 1910},{10262, 1901},{10634, 1896}
      }
    },
    {
      /*Cr  qi=63  INTRA*/
      {
        {   38,    7},{  324,  367},{  677,  670},{ 1136,  892},
        { 1562, 1070},{ 1951, 1209},{ 2326, 1313},{ 2694, 1399},
        { 3074, 1471},{ 3460, 1531},{ 3850, 1575},{ 4214, 1622},
        { 4522, 1679},{ 4819, 1723},{ 5089, 1749},{ 5315, 1769},
        { 5530, 1792},{ 5756, 1825},{ 6006, 1860},{ 6244, 1889},
        { 6514, 1924},{ 6792, 1946},{ 7026, 1962},{ 7191, 1971}
      },
      /*Cr  qi=63  INTER*/
      {
        {   80,    2},{   95,  354},{  101,  671},{  167,  990},
        {  321, 1274},{  585, 1509},{  984, 1702},{ 1534, 1849},
        { 2217, 1947},{ 3005, 1995},{ 3839, 1999},{ 4619, 1986},
        { 5310, 1973},{ 5933, 1961},{ 6486, 1952},{ 6988, 1942},
        { 7435, 1927},{ 7817, 1911},{ 8198, 1900},{ 8552, 1895},
        { 8881, 1890},{ 9253, 1883},{ 9598, 1876},{ 9923, 1859}
      }
    }
  }
};

#endif
