/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#ifndef _afc7b2d7_0869_4fea_9a9b_7fe6228baca9_0018
#define _afc7b2d7_0869_4fea_9a9b_7fe6228baca9_0018

#include <map>
#include <string>

#include "odil/odil.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{
Tag const ContrastBolusAgent(0x0018, 0x0010);
Tag const ContrastBolusAgentSequence(0x0018, 0x0012);
Tag const ContrastBolusT1Relaxivity(0x0018, 0x0013);
Tag const ContrastBolusAdministrationRouteSequence(0x0018, 0x0014);
Tag const BodyPartExamined(0x0018, 0x0015);
Tag const ScanningSequence(0x0018, 0x0020);
Tag const SequenceVariant(0x0018, 0x0021);
Tag const ScanOptions(0x0018, 0x0022);
Tag const MRAcquisitionType(0x0018, 0x0023);
Tag const SequenceName(0x0018, 0x0024);
Tag const AngioFlag(0x0018, 0x0025);
Tag const InterventionDrugInformationSequence(0x0018, 0x0026);
Tag const InterventionDrugStopTime(0x0018, 0x0027);
Tag const InterventionDrugDose(0x0018, 0x0028);
Tag const InterventionDrugCodeSequence(0x0018, 0x0029);
Tag const AdditionalDrugSequence(0x0018, 0x002a);
Tag const Radionuclide(0x0018, 0x0030);
Tag const Radiopharmaceutical(0x0018, 0x0031);
Tag const EnergyWindowCenterline(0x0018, 0x0032);
Tag const EnergyWindowTotalWidth(0x0018, 0x0033);
Tag const InterventionDrugName(0x0018, 0x0034);
Tag const InterventionDrugStartTime(0x0018, 0x0035);
Tag const InterventionSequence(0x0018, 0x0036);
Tag const TherapyType(0x0018, 0x0037);
Tag const InterventionStatus(0x0018, 0x0038);
Tag const TherapyDescription(0x0018, 0x0039);
Tag const InterventionDescription(0x0018, 0x003a);
Tag const CineRate(0x0018, 0x0040);
Tag const InitialCineRunState(0x0018, 0x0042);
Tag const SliceThickness(0x0018, 0x0050);
Tag const KVP(0x0018, 0x0060);
Tag const CountsAccumulated(0x0018, 0x0070);
Tag const AcquisitionTerminationCondition(0x0018, 0x0071);
Tag const EffectiveDuration(0x0018, 0x0072);
Tag const AcquisitionStartCondition(0x0018, 0x0073);
Tag const AcquisitionStartConditionData(0x0018, 0x0074);
Tag const AcquisitionTerminationConditionData(0x0018, 0x0075);
Tag const RepetitionTime(0x0018, 0x0080);
Tag const EchoTime(0x0018, 0x0081);
Tag const InversionTime(0x0018, 0x0082);
Tag const NumberOfAverages(0x0018, 0x0083);
Tag const ImagingFrequency(0x0018, 0x0084);
Tag const ImagedNucleus(0x0018, 0x0085);
Tag const EchoNumbers(0x0018, 0x0086);
Tag const MagneticFieldStrength(0x0018, 0x0087);
Tag const SpacingBetweenSlices(0x0018, 0x0088);
Tag const NumberOfPhaseEncodingSteps(0x0018, 0x0089);
Tag const DataCollectionDiameter(0x0018, 0x0090);
Tag const EchoTrainLength(0x0018, 0x0091);
Tag const PercentSampling(0x0018, 0x0093);
Tag const PercentPhaseFieldOfView(0x0018, 0x0094);
Tag const PixelBandwidth(0x0018, 0x0095);
Tag const DeviceSerialNumber(0x0018, 0x1000);
Tag const DeviceUID(0x0018, 0x1002);
Tag const DeviceID(0x0018, 0x1003);
Tag const PlateID(0x0018, 0x1004);
Tag const GeneratorID(0x0018, 0x1005);
Tag const GridID(0x0018, 0x1006);
Tag const CassetteID(0x0018, 0x1007);
Tag const GantryID(0x0018, 0x1008);
Tag const UniqueDeviceIdentifier(0x0018, 0x1009);
Tag const UDISequence(0x0018, 0x100a);
Tag const SecondaryCaptureDeviceID(0x0018, 0x1010);
Tag const HardcopyCreationDeviceID(0x0018, 0x1011);
Tag const DateOfSecondaryCapture(0x0018, 0x1012);
Tag const TimeOfSecondaryCapture(0x0018, 0x1014);
Tag const SecondaryCaptureDeviceManufacturer(0x0018, 0x1016);
Tag const HardcopyDeviceManufacturer(0x0018, 0x1017);
Tag const SecondaryCaptureDeviceManufacturerModelName(0x0018, 0x1018);
Tag const SecondaryCaptureDeviceSoftwareVersions(0x0018, 0x1019);
Tag const HardcopyDeviceSoftwareVersion(0x0018, 0x101a);
Tag const HardcopyDeviceManufacturerModelName(0x0018, 0x101b);
Tag const SoftwareVersions(0x0018, 0x1020);
Tag const VideoImageFormatAcquired(0x0018, 0x1022);
Tag const DigitalImageFormatAcquired(0x0018, 0x1023);
Tag const ProtocolName(0x0018, 0x1030);
Tag const ContrastBolusRoute(0x0018, 0x1040);
Tag const ContrastBolusVolume(0x0018, 0x1041);
Tag const ContrastBolusStartTime(0x0018, 0x1042);
Tag const ContrastBolusStopTime(0x0018, 0x1043);
Tag const ContrastBolusTotalDose(0x0018, 0x1044);
Tag const SyringeCounts(0x0018, 0x1045);
Tag const ContrastFlowRate(0x0018, 0x1046);
Tag const ContrastFlowDuration(0x0018, 0x1047);
Tag const ContrastBolusIngredient(0x0018, 0x1048);
Tag const ContrastBolusIngredientConcentration(0x0018, 0x1049);
Tag const SpatialResolution(0x0018, 0x1050);
Tag const TriggerTime(0x0018, 0x1060);
Tag const TriggerSourceOrType(0x0018, 0x1061);
Tag const NominalInterval(0x0018, 0x1062);
Tag const FrameTime(0x0018, 0x1063);
Tag const CardiacFramingType(0x0018, 0x1064);
Tag const FrameTimeVector(0x0018, 0x1065);
Tag const FrameDelay(0x0018, 0x1066);
Tag const ImageTriggerDelay(0x0018, 0x1067);
Tag const MultiplexGroupTimeOffset(0x0018, 0x1068);
Tag const TriggerTimeOffset(0x0018, 0x1069);
Tag const SynchronizationTrigger(0x0018, 0x106a);
Tag const SynchronizationChannel(0x0018, 0x106c);
Tag const TriggerSamplePosition(0x0018, 0x106e);
Tag const RadiopharmaceuticalRoute(0x0018, 0x1070);
Tag const RadiopharmaceuticalVolume(0x0018, 0x1071);
Tag const RadiopharmaceuticalStartTime(0x0018, 0x1072);
Tag const RadiopharmaceuticalStopTime(0x0018, 0x1073);
Tag const RadionuclideTotalDose(0x0018, 0x1074);
Tag const RadionuclideHalfLife(0x0018, 0x1075);
Tag const RadionuclidePositronFraction(0x0018, 0x1076);
Tag const RadiopharmaceuticalSpecificActivity(0x0018, 0x1077);
Tag const RadiopharmaceuticalStartDateTime(0x0018, 0x1078);
Tag const RadiopharmaceuticalStopDateTime(0x0018, 0x1079);
Tag const BeatRejectionFlag(0x0018, 0x1080);
Tag const LowRRValue(0x0018, 0x1081);
Tag const HighRRValue(0x0018, 0x1082);
Tag const IntervalsAcquired(0x0018, 0x1083);
Tag const IntervalsRejected(0x0018, 0x1084);
Tag const PVCRejection(0x0018, 0x1085);
Tag const SkipBeats(0x0018, 0x1086);
Tag const HeartRate(0x0018, 0x1088);
Tag const CardiacNumberOfImages(0x0018, 0x1090);
Tag const TriggerWindow(0x0018, 0x1094);
Tag const ReconstructionDiameter(0x0018, 0x1100);
Tag const DistanceSourceToDetector(0x0018, 0x1110);
Tag const DistanceSourceToPatient(0x0018, 0x1111);
Tag const EstimatedRadiographicMagnificationFactor(0x0018, 0x1114);
Tag const GantryDetectorTilt(0x0018, 0x1120);
Tag const GantryDetectorSlew(0x0018, 0x1121);
Tag const TableHeight(0x0018, 0x1130);
Tag const TableTraverse(0x0018, 0x1131);
Tag const TableMotion(0x0018, 0x1134);
Tag const TableVerticalIncrement(0x0018, 0x1135);
Tag const TableLateralIncrement(0x0018, 0x1136);
Tag const TableLongitudinalIncrement(0x0018, 0x1137);
Tag const TableAngle(0x0018, 0x1138);
Tag const TableType(0x0018, 0x113a);
Tag const RotationDirection(0x0018, 0x1140);
Tag const AngularPosition(0x0018, 0x1141);
Tag const RadialPosition(0x0018, 0x1142);
Tag const ScanArc(0x0018, 0x1143);
Tag const AngularStep(0x0018, 0x1144);
Tag const CenterOfRotationOffset(0x0018, 0x1145);
Tag const RotationOffset(0x0018, 0x1146);
Tag const FieldOfViewShape(0x0018, 0x1147);
Tag const FieldOfViewDimensions(0x0018, 0x1149);
Tag const ExposureTime(0x0018, 0x1150);
Tag const XRayTubeCurrent(0x0018, 0x1151);
Tag const Exposure(0x0018, 0x1152);
Tag const ExposureInuAs(0x0018, 0x1153);
Tag const AveragePulseWidth(0x0018, 0x1154);
Tag const RadiationSetting(0x0018, 0x1155);
Tag const RectificationType(0x0018, 0x1156);
Tag const RadiationMode(0x0018, 0x115a);
Tag const ImageAndFluoroscopyAreaDoseProduct(0x0018, 0x115e);
Tag const FilterType(0x0018, 0x1160);
Tag const TypeOfFilters(0x0018, 0x1161);
Tag const IntensifierSize(0x0018, 0x1162);
Tag const ImagerPixelSpacing(0x0018, 0x1164);
Tag const Grid(0x0018, 0x1166);
Tag const GeneratorPower(0x0018, 0x1170);
Tag const CollimatorGridName(0x0018, 0x1180);
Tag const CollimatorType(0x0018, 0x1181);
Tag const FocalDistance(0x0018, 0x1182);
Tag const XFocusCenter(0x0018, 0x1183);
Tag const YFocusCenter(0x0018, 0x1184);
Tag const FocalSpots(0x0018, 0x1190);
Tag const AnodeTargetMaterial(0x0018, 0x1191);
Tag const BodyPartThickness(0x0018, 0x11a0);
Tag const CompressionForce(0x0018, 0x11a2);
Tag const CompressionPressure(0x0018, 0x11a3);
Tag const PaddleDescription(0x0018, 0x11a4);
Tag const CompressionContactArea(0x0018, 0x11a5);
Tag const DateOfLastCalibration(0x0018, 0x1200);
Tag const TimeOfLastCalibration(0x0018, 0x1201);
Tag const DateTimeOfLastCalibration(0x0018, 0x1202);
Tag const ConvolutionKernel(0x0018, 0x1210);
Tag const UpperLowerPixelValues(0x0018, 0x1240);
Tag const ActualFrameDuration(0x0018, 0x1242);
Tag const CountRate(0x0018, 0x1243);
Tag const PreferredPlaybackSequencing(0x0018, 0x1244);
Tag const ReceiveCoilName(0x0018, 0x1250);
Tag const TransmitCoilName(0x0018, 0x1251);
Tag const PlateType(0x0018, 0x1260);
Tag const PhosphorType(0x0018, 0x1261);
Tag const WaterEquivalentDiameter(0x0018, 0x1271);
Tag const WaterEquivalentDiameterCalculationMethodCodeSequence(0x0018, 0x1272);
Tag const ScanVelocity(0x0018, 0x1300);
Tag const WholeBodyTechnique(0x0018, 0x1301);
Tag const ScanLength(0x0018, 0x1302);
Tag const AcquisitionMatrix(0x0018, 0x1310);
Tag const InPlanePhaseEncodingDirection(0x0018, 0x1312);
Tag const FlipAngle(0x0018, 0x1314);
Tag const VariableFlipAngleFlag(0x0018, 0x1315);
Tag const SAR(0x0018, 0x1316);
Tag const dBdt(0x0018, 0x1318);
Tag const B1rms(0x0018, 0x1320);
Tag const AcquisitionDeviceProcessingDescription(0x0018, 0x1400);
Tag const AcquisitionDeviceProcessingCode(0x0018, 0x1401);
Tag const CassetteOrientation(0x0018, 0x1402);
Tag const CassetteSize(0x0018, 0x1403);
Tag const ExposuresOnPlate(0x0018, 0x1404);
Tag const RelativeXRayExposure(0x0018, 0x1405);
Tag const ExposureIndex(0x0018, 0x1411);
Tag const TargetExposureIndex(0x0018, 0x1412);
Tag const DeviationIndex(0x0018, 0x1413);
Tag const ColumnAngulation(0x0018, 0x1450);
Tag const TomoLayerHeight(0x0018, 0x1460);
Tag const TomoAngle(0x0018, 0x1470);
Tag const TomoTime(0x0018, 0x1480);
Tag const TomoType(0x0018, 0x1490);
Tag const TomoClass(0x0018, 0x1491);
Tag const NumberOfTomosynthesisSourceImages(0x0018, 0x1495);
Tag const PositionerMotion(0x0018, 0x1500);
Tag const PositionerType(0x0018, 0x1508);
Tag const PositionerPrimaryAngle(0x0018, 0x1510);
Tag const PositionerSecondaryAngle(0x0018, 0x1511);
Tag const PositionerPrimaryAngleIncrement(0x0018, 0x1520);
Tag const PositionerSecondaryAngleIncrement(0x0018, 0x1521);
Tag const DetectorPrimaryAngle(0x0018, 0x1530);
Tag const DetectorSecondaryAngle(0x0018, 0x1531);
Tag const ShutterShape(0x0018, 0x1600);
Tag const ShutterLeftVerticalEdge(0x0018, 0x1602);
Tag const ShutterRightVerticalEdge(0x0018, 0x1604);
Tag const ShutterUpperHorizontalEdge(0x0018, 0x1606);
Tag const ShutterLowerHorizontalEdge(0x0018, 0x1608);
Tag const CenterOfCircularShutter(0x0018, 0x1610);
Tag const RadiusOfCircularShutter(0x0018, 0x1612);
Tag const VerticesOfThePolygonalShutter(0x0018, 0x1620);
Tag const ShutterPresentationValue(0x0018, 0x1622);
Tag const ShutterOverlayGroup(0x0018, 0x1623);
Tag const ShutterPresentationColorCIELabValue(0x0018, 0x1624);
Tag const CollimatorShape(0x0018, 0x1700);
Tag const CollimatorLeftVerticalEdge(0x0018, 0x1702);
Tag const CollimatorRightVerticalEdge(0x0018, 0x1704);
Tag const CollimatorUpperHorizontalEdge(0x0018, 0x1706);
Tag const CollimatorLowerHorizontalEdge(0x0018, 0x1708);
Tag const CenterOfCircularCollimator(0x0018, 0x1710);
Tag const RadiusOfCircularCollimator(0x0018, 0x1712);
Tag const VerticesOfThePolygonalCollimator(0x0018, 0x1720);
Tag const AcquisitionTimeSynchronized(0x0018, 0x1800);
Tag const TimeSource(0x0018, 0x1801);
Tag const TimeDistributionProtocol(0x0018, 0x1802);
Tag const NTPSourceAddress(0x0018, 0x1803);
Tag const PageNumberVector(0x0018, 0x2001);
Tag const FrameLabelVector(0x0018, 0x2002);
Tag const FramePrimaryAngleVector(0x0018, 0x2003);
Tag const FrameSecondaryAngleVector(0x0018, 0x2004);
Tag const SliceLocationVector(0x0018, 0x2005);
Tag const DisplayWindowLabelVector(0x0018, 0x2006);
Tag const NominalScannedPixelSpacing(0x0018, 0x2010);
Tag const DigitizingDeviceTransportDirection(0x0018, 0x2020);
Tag const RotationOfScannedFilm(0x0018, 0x2030);
Tag const BiopsyTargetSequence(0x0018, 0x2041);
Tag const TargetUID(0x0018, 0x2042);
Tag const LocalizingCursorPosition(0x0018, 0x2043);
Tag const CalculatedTargetPosition(0x0018, 0x2044);
Tag const TargetLabel(0x0018, 0x2045);
Tag const DisplayedZValue(0x0018, 0x2046);
Tag const IVUSAcquisition(0x0018, 0x3100);
Tag const IVUSPullbackRate(0x0018, 0x3101);
Tag const IVUSGatedRate(0x0018, 0x3102);
Tag const IVUSPullbackStartFrameNumber(0x0018, 0x3103);
Tag const IVUSPullbackStopFrameNumber(0x0018, 0x3104);
Tag const LesionNumber(0x0018, 0x3105);
Tag const AcquisitionComments(0x0018, 0x4000);
Tag const OutputPower(0x0018, 0x5000);
Tag const TransducerData(0x0018, 0x5010);
Tag const FocusDepth(0x0018, 0x5012);
Tag const ProcessingFunction(0x0018, 0x5020);
Tag const PostprocessingFunction(0x0018, 0x5021);
Tag const MechanicalIndex(0x0018, 0x5022);
Tag const BoneThermalIndex(0x0018, 0x5024);
Tag const CranialThermalIndex(0x0018, 0x5026);
Tag const SoftTissueThermalIndex(0x0018, 0x5027);
Tag const SoftTissueFocusThermalIndex(0x0018, 0x5028);
Tag const SoftTissueSurfaceThermalIndex(0x0018, 0x5029);
Tag const DynamicRange(0x0018, 0x5030);
Tag const TotalGain(0x0018, 0x5040);
Tag const DepthOfScanField(0x0018, 0x5050);
Tag const PatientPosition(0x0018, 0x5100);
Tag const ViewPosition(0x0018, 0x5101);
Tag const ProjectionEponymousNameCodeSequence(0x0018, 0x5104);
Tag const ImageTransformationMatrix(0x0018, 0x5210);
Tag const ImageTranslationVector(0x0018, 0x5212);
Tag const Sensitivity(0x0018, 0x6000);
Tag const SequenceOfUltrasoundRegions(0x0018, 0x6011);
Tag const RegionSpatialFormat(0x0018, 0x6012);
Tag const RegionDataType(0x0018, 0x6014);
Tag const RegionFlags(0x0018, 0x6016);
Tag const RegionLocationMinX0(0x0018, 0x6018);
Tag const RegionLocationMinY0(0x0018, 0x601a);
Tag const RegionLocationMaxX1(0x0018, 0x601c);
Tag const RegionLocationMaxY1(0x0018, 0x601e);
Tag const ReferencePixelX0(0x0018, 0x6020);
Tag const ReferencePixelY0(0x0018, 0x6022);
Tag const PhysicalUnitsXDirection(0x0018, 0x6024);
Tag const PhysicalUnitsYDirection(0x0018, 0x6026);
Tag const ReferencePixelPhysicalValueX(0x0018, 0x6028);
Tag const ReferencePixelPhysicalValueY(0x0018, 0x602a);
Tag const PhysicalDeltaX(0x0018, 0x602c);
Tag const PhysicalDeltaY(0x0018, 0x602e);
Tag const TransducerFrequency(0x0018, 0x6030);
Tag const TransducerType(0x0018, 0x6031);
Tag const PulseRepetitionFrequency(0x0018, 0x6032);
Tag const DopplerCorrectionAngle(0x0018, 0x6034);
Tag const SteeringAngle(0x0018, 0x6036);
Tag const DopplerSampleVolumeXPositionRetired(0x0018, 0x6038);
Tag const DopplerSampleVolumeXPosition(0x0018, 0x6039);
Tag const DopplerSampleVolumeYPositionRetired(0x0018, 0x603a);
Tag const DopplerSampleVolumeYPosition(0x0018, 0x603b);
Tag const TMLinePositionX0Retired(0x0018, 0x603c);
Tag const TMLinePositionX0(0x0018, 0x603d);
Tag const TMLinePositionY0Retired(0x0018, 0x603e);
Tag const TMLinePositionY0(0x0018, 0x603f);
Tag const TMLinePositionX1Retired(0x0018, 0x6040);
Tag const TMLinePositionX1(0x0018, 0x6041);
Tag const TMLinePositionY1Retired(0x0018, 0x6042);
Tag const TMLinePositionY1(0x0018, 0x6043);
Tag const PixelComponentOrganization(0x0018, 0x6044);
Tag const PixelComponentMask(0x0018, 0x6046);
Tag const PixelComponentRangeStart(0x0018, 0x6048);
Tag const PixelComponentRangeStop(0x0018, 0x604a);
Tag const PixelComponentPhysicalUnits(0x0018, 0x604c);
Tag const PixelComponentDataType(0x0018, 0x604e);
Tag const NumberOfTableBreakPoints(0x0018, 0x6050);
Tag const TableOfXBreakPoints(0x0018, 0x6052);
Tag const TableOfYBreakPoints(0x0018, 0x6054);
Tag const NumberOfTableEntries(0x0018, 0x6056);
Tag const TableOfPixelValues(0x0018, 0x6058);
Tag const TableOfParameterValues(0x0018, 0x605a);
Tag const RWaveTimeVector(0x0018, 0x6060);
Tag const DetectorConditionsNominalFlag(0x0018, 0x7000);
Tag const DetectorTemperature(0x0018, 0x7001);
Tag const DetectorType(0x0018, 0x7004);
Tag const DetectorConfiguration(0x0018, 0x7005);
Tag const DetectorDescription(0x0018, 0x7006);
Tag const DetectorMode(0x0018, 0x7008);
Tag const DetectorID(0x0018, 0x700a);
Tag const DateOfLastDetectorCalibration(0x0018, 0x700c);
Tag const TimeOfLastDetectorCalibration(0x0018, 0x700e);
Tag const ExposuresOnDetectorSinceLastCalibration(0x0018, 0x7010);
Tag const ExposuresOnDetectorSinceManufactured(0x0018, 0x7011);
Tag const DetectorTimeSinceLastExposure(0x0018, 0x7012);
Tag const DetectorActiveTime(0x0018, 0x7014);
Tag const DetectorActivationOffsetFromExposure(0x0018, 0x7016);
Tag const DetectorBinning(0x0018, 0x701a);
Tag const DetectorElementPhysicalSize(0x0018, 0x7020);
Tag const DetectorElementSpacing(0x0018, 0x7022);
Tag const DetectorActiveShape(0x0018, 0x7024);
Tag const DetectorActiveDimensions(0x0018, 0x7026);
Tag const DetectorActiveOrigin(0x0018, 0x7028);
Tag const DetectorManufacturerName(0x0018, 0x702a);
Tag const DetectorManufacturerModelName(0x0018, 0x702b);
Tag const FieldOfViewOrigin(0x0018, 0x7030);
Tag const FieldOfViewRotation(0x0018, 0x7032);
Tag const FieldOfViewHorizontalFlip(0x0018, 0x7034);
Tag const PixelDataAreaOriginRelativeToFOV(0x0018, 0x7036);
Tag const PixelDataAreaRotationAngleRelativeToFOV(0x0018, 0x7038);
Tag const GridAbsorbingMaterial(0x0018, 0x7040);
Tag const GridSpacingMaterial(0x0018, 0x7041);
Tag const GridThickness(0x0018, 0x7042);
Tag const GridPitch(0x0018, 0x7044);
Tag const GridAspectRatio(0x0018, 0x7046);
Tag const GridPeriod(0x0018, 0x7048);
Tag const GridFocalDistance(0x0018, 0x704c);
Tag const FilterMaterial(0x0018, 0x7050);
Tag const FilterThicknessMinimum(0x0018, 0x7052);
Tag const FilterThicknessMaximum(0x0018, 0x7054);
Tag const FilterBeamPathLengthMinimum(0x0018, 0x7056);
Tag const FilterBeamPathLengthMaximum(0x0018, 0x7058);
Tag const ExposureControlMode(0x0018, 0x7060);
Tag const ExposureControlModeDescription(0x0018, 0x7062);
Tag const ExposureStatus(0x0018, 0x7064);
Tag const PhototimerSetting(0x0018, 0x7065);
Tag const ExposureTimeInuS(0x0018, 0x8150);
Tag const XRayTubeCurrentInuA(0x0018, 0x8151);
Tag const ContentQualification(0x0018, 0x9004);
Tag const PulseSequenceName(0x0018, 0x9005);
Tag const MRImagingModifierSequence(0x0018, 0x9006);
Tag const EchoPulseSequence(0x0018, 0x9008);
Tag const InversionRecovery(0x0018, 0x9009);
Tag const FlowCompensation(0x0018, 0x9010);
Tag const MultipleSpinEcho(0x0018, 0x9011);
Tag const MultiPlanarExcitation(0x0018, 0x9012);
Tag const PhaseContrast(0x0018, 0x9014);
Tag const TimeOfFlightContrast(0x0018, 0x9015);
Tag const Spoiling(0x0018, 0x9016);
Tag const SteadyStatePulseSequence(0x0018, 0x9017);
Tag const EchoPlanarPulseSequence(0x0018, 0x9018);
Tag const TagAngleFirstAxis(0x0018, 0x9019);
Tag const MagnetizationTransfer(0x0018, 0x9020);
Tag const T2Preparation(0x0018, 0x9021);
Tag const BloodSignalNulling(0x0018, 0x9022);
Tag const SaturationRecovery(0x0018, 0x9024);
Tag const SpectrallySelectedSuppression(0x0018, 0x9025);
Tag const SpectrallySelectedExcitation(0x0018, 0x9026);
Tag const SpatialPresaturation(0x0018, 0x9027);
Tag const Tagging(0x0018, 0x9028);
Tag const OversamplingPhase(0x0018, 0x9029);
Tag const TagSpacingFirstDimension(0x0018, 0x9030);
Tag const GeometryOfKSpaceTraversal(0x0018, 0x9032);
Tag const SegmentedKSpaceTraversal(0x0018, 0x9033);
Tag const RectilinearPhaseEncodeReordering(0x0018, 0x9034);
Tag const TagThickness(0x0018, 0x9035);
Tag const PartialFourierDirection(0x0018, 0x9036);
Tag const CardiacSynchronizationTechnique(0x0018, 0x9037);
Tag const ReceiveCoilManufacturerName(0x0018, 0x9041);
Tag const MRReceiveCoilSequence(0x0018, 0x9042);
Tag const ReceiveCoilType(0x0018, 0x9043);
Tag const QuadratureReceiveCoil(0x0018, 0x9044);
Tag const MultiCoilDefinitionSequence(0x0018, 0x9045);
Tag const MultiCoilConfiguration(0x0018, 0x9046);
Tag const MultiCoilElementName(0x0018, 0x9047);
Tag const MultiCoilElementUsed(0x0018, 0x9048);
Tag const MRTransmitCoilSequence(0x0018, 0x9049);
Tag const TransmitCoilManufacturerName(0x0018, 0x9050);
Tag const TransmitCoilType(0x0018, 0x9051);
Tag const SpectralWidth(0x0018, 0x9052);
Tag const ChemicalShiftReference(0x0018, 0x9053);
Tag const VolumeLocalizationTechnique(0x0018, 0x9054);
Tag const MRAcquisitionFrequencyEncodingSteps(0x0018, 0x9058);
Tag const Decoupling(0x0018, 0x9059);
Tag const DecoupledNucleus(0x0018, 0x9060);
Tag const DecouplingFrequency(0x0018, 0x9061);
Tag const DecouplingMethod(0x0018, 0x9062);
Tag const DecouplingChemicalShiftReference(0x0018, 0x9063);
Tag const KSpaceFiltering(0x0018, 0x9064);
Tag const TimeDomainFiltering(0x0018, 0x9065);
Tag const NumberOfZeroFills(0x0018, 0x9066);
Tag const BaselineCorrection(0x0018, 0x9067);
Tag const ParallelReductionFactorInPlane(0x0018, 0x9069);
Tag const CardiacRRIntervalSpecified(0x0018, 0x9070);
Tag const AcquisitionDuration(0x0018, 0x9073);
Tag const FrameAcquisitionDateTime(0x0018, 0x9074);
Tag const DiffusionDirectionality(0x0018, 0x9075);
Tag const DiffusionGradientDirectionSequence(0x0018, 0x9076);
Tag const ParallelAcquisition(0x0018, 0x9077);
Tag const ParallelAcquisitionTechnique(0x0018, 0x9078);
Tag const InversionTimes(0x0018, 0x9079);
Tag const MetaboliteMapDescription(0x0018, 0x9080);
Tag const PartialFourier(0x0018, 0x9081);
Tag const EffectiveEchoTime(0x0018, 0x9082);
Tag const MetaboliteMapCodeSequence(0x0018, 0x9083);
Tag const ChemicalShiftSequence(0x0018, 0x9084);
Tag const CardiacSignalSource(0x0018, 0x9085);
Tag const DiffusionBValue(0x0018, 0x9087);
Tag const DiffusionGradientOrientation(0x0018, 0x9089);
Tag const VelocityEncodingDirection(0x0018, 0x9090);
Tag const VelocityEncodingMinimumValue(0x0018, 0x9091);
Tag const VelocityEncodingAcquisitionSequence(0x0018, 0x9092);
Tag const NumberOfKSpaceTrajectories(0x0018, 0x9093);
Tag const CoverageOfKSpace(0x0018, 0x9094);
Tag const SpectroscopyAcquisitionPhaseRows(0x0018, 0x9095);
Tag const ParallelReductionFactorInPlaneRetired(0x0018, 0x9096);
Tag const TransmitterFrequency(0x0018, 0x9098);
Tag const ResonantNucleus(0x0018, 0x9100);
Tag const FrequencyCorrection(0x0018, 0x9101);
Tag const MRSpectroscopyFOVGeometrySequence(0x0018, 0x9103);
Tag const SlabThickness(0x0018, 0x9104);
Tag const SlabOrientation(0x0018, 0x9105);
Tag const MidSlabPosition(0x0018, 0x9106);
Tag const MRSpatialSaturationSequence(0x0018, 0x9107);
Tag const MRTimingAndRelatedParametersSequence(0x0018, 0x9112);
Tag const MREchoSequence(0x0018, 0x9114);
Tag const MRModifierSequence(0x0018, 0x9115);
Tag const MRDiffusionSequence(0x0018, 0x9117);
Tag const CardiacSynchronizationSequence(0x0018, 0x9118);
Tag const MRAveragesSequence(0x0018, 0x9119);
Tag const MRFOVGeometrySequence(0x0018, 0x9125);
Tag const VolumeLocalizationSequence(0x0018, 0x9126);
Tag const SpectroscopyAcquisitionDataColumns(0x0018, 0x9127);
Tag const DiffusionAnisotropyType(0x0018, 0x9147);
Tag const FrameReferenceDateTime(0x0018, 0x9151);
Tag const MRMetaboliteMapSequence(0x0018, 0x9152);
Tag const ParallelReductionFactorOutOfPlane(0x0018, 0x9155);
Tag const SpectroscopyAcquisitionOutOfPlanePhaseSteps(0x0018, 0x9159);
Tag const BulkMotionStatus(0x0018, 0x9166);
Tag const ParallelReductionFactorSecondInPlane(0x0018, 0x9168);
Tag const CardiacBeatRejectionTechnique(0x0018, 0x9169);
Tag const RespiratoryMotionCompensationTechnique(0x0018, 0x9170);
Tag const RespiratorySignalSource(0x0018, 0x9171);
Tag const BulkMotionCompensationTechnique(0x0018, 0x9172);
Tag const BulkMotionSignalSource(0x0018, 0x9173);
Tag const ApplicableSafetyStandardAgency(0x0018, 0x9174);
Tag const ApplicableSafetyStandardDescription(0x0018, 0x9175);
Tag const OperatingModeSequence(0x0018, 0x9176);
Tag const OperatingModeType(0x0018, 0x9177);
Tag const OperatingMode(0x0018, 0x9178);
Tag const SpecificAbsorptionRateDefinition(0x0018, 0x9179);
Tag const GradientOutputType(0x0018, 0x9180);
Tag const SpecificAbsorptionRateValue(0x0018, 0x9181);
Tag const GradientOutput(0x0018, 0x9182);
Tag const FlowCompensationDirection(0x0018, 0x9183);
Tag const TaggingDelay(0x0018, 0x9184);
Tag const RespiratoryMotionCompensationTechniqueDescription(0x0018, 0x9185);
Tag const RespiratorySignalSourceID(0x0018, 0x9186);
Tag const ChemicalShiftMinimumIntegrationLimitInHz(0x0018, 0x9195);
Tag const ChemicalShiftMaximumIntegrationLimitInHz(0x0018, 0x9196);
Tag const MRVelocityEncodingSequence(0x0018, 0x9197);
Tag const FirstOrderPhaseCorrection(0x0018, 0x9198);
Tag const WaterReferencedPhaseCorrection(0x0018, 0x9199);
Tag const MRSpectroscopyAcquisitionType(0x0018, 0x9200);
Tag const RespiratoryCyclePosition(0x0018, 0x9214);
Tag const VelocityEncodingMaximumValue(0x0018, 0x9217);
Tag const TagSpacingSecondDimension(0x0018, 0x9218);
Tag const TagAngleSecondAxis(0x0018, 0x9219);
Tag const FrameAcquisitionDuration(0x0018, 0x9220);
Tag const MRImageFrameTypeSequence(0x0018, 0x9226);
Tag const MRSpectroscopyFrameTypeSequence(0x0018, 0x9227);
Tag const MRAcquisitionPhaseEncodingStepsInPlane(0x0018, 0x9231);
Tag const MRAcquisitionPhaseEncodingStepsOutOfPlane(0x0018, 0x9232);
Tag const SpectroscopyAcquisitionPhaseColumns(0x0018, 0x9234);
Tag const CardiacCyclePosition(0x0018, 0x9236);
Tag const SpecificAbsorptionRateSequence(0x0018, 0x9239);
Tag const RFEchoTrainLength(0x0018, 0x9240);
Tag const GradientEchoTrainLength(0x0018, 0x9241);
Tag const ArterialSpinLabelingContrast(0x0018, 0x9250);
Tag const MRArterialSpinLabelingSequence(0x0018, 0x9251);
Tag const ASLTechniqueDescription(0x0018, 0x9252);
Tag const ASLSlabNumber(0x0018, 0x9253);
Tag const ASLSlabThickness(0x0018, 0x9254);
Tag const ASLSlabOrientation(0x0018, 0x9255);
Tag const ASLMidSlabPosition(0x0018, 0x9256);
Tag const ASLContext(0x0018, 0x9257);
Tag const ASLPulseTrainDuration(0x0018, 0x9258);
Tag const ASLCrusherFlag(0x0018, 0x9259);
Tag const ASLCrusherFlowLimit(0x0018, 0x925a);
Tag const ASLCrusherDescription(0x0018, 0x925b);
Tag const ASLBolusCutoffFlag(0x0018, 0x925c);
Tag const ASLBolusCutoffTimingSequence(0x0018, 0x925d);
Tag const ASLBolusCutoffTechnique(0x0018, 0x925e);
Tag const ASLBolusCutoffDelayTime(0x0018, 0x925f);
Tag const ASLSlabSequence(0x0018, 0x9260);
Tag const ChemicalShiftMinimumIntegrationLimitInppm(0x0018, 0x9295);
Tag const ChemicalShiftMaximumIntegrationLimitInppm(0x0018, 0x9296);
Tag const WaterReferenceAcquisition(0x0018, 0x9297);
Tag const EchoPeakPosition(0x0018, 0x9298);
Tag const CTAcquisitionTypeSequence(0x0018, 0x9301);
Tag const AcquisitionType(0x0018, 0x9302);
Tag const TubeAngle(0x0018, 0x9303);
Tag const CTAcquisitionDetailsSequence(0x0018, 0x9304);
Tag const RevolutionTime(0x0018, 0x9305);
Tag const SingleCollimationWidth(0x0018, 0x9306);
Tag const TotalCollimationWidth(0x0018, 0x9307);
Tag const CTTableDynamicsSequence(0x0018, 0x9308);
Tag const TableSpeed(0x0018, 0x9309);
Tag const TableFeedPerRotation(0x0018, 0x9310);
Tag const SpiralPitchFactor(0x0018, 0x9311);
Tag const CTGeometrySequence(0x0018, 0x9312);
Tag const DataCollectionCenterPatient(0x0018, 0x9313);
Tag const CTReconstructionSequence(0x0018, 0x9314);
Tag const ReconstructionAlgorithm(0x0018, 0x9315);
Tag const ConvolutionKernelGroup(0x0018, 0x9316);
Tag const ReconstructionFieldOfView(0x0018, 0x9317);
Tag const ReconstructionTargetCenterPatient(0x0018, 0x9318);
Tag const ReconstructionAngle(0x0018, 0x9319);
Tag const ImageFilter(0x0018, 0x9320);
Tag const CTExposureSequence(0x0018, 0x9321);
Tag const ReconstructionPixelSpacing(0x0018, 0x9322);
Tag const ExposureModulationType(0x0018, 0x9323);
Tag const EstimatedDoseSaving(0x0018, 0x9324);
Tag const CTXRayDetailsSequence(0x0018, 0x9325);
Tag const CTPositionSequence(0x0018, 0x9326);
Tag const TablePosition(0x0018, 0x9327);
Tag const ExposureTimeInms(0x0018, 0x9328);
Tag const CTImageFrameTypeSequence(0x0018, 0x9329);
Tag const XRayTubeCurrentInmA(0x0018, 0x9330);
Tag const ExposureInmAs(0x0018, 0x9332);
Tag const ConstantVolumeFlag(0x0018, 0x9333);
Tag const FluoroscopyFlag(0x0018, 0x9334);
Tag const DistanceSourceToDataCollectionCenter(0x0018, 0x9335);
Tag const ContrastBolusAgentNumber(0x0018, 0x9337);
Tag const ContrastBolusIngredientCodeSequence(0x0018, 0x9338);
Tag const ContrastAdministrationProfileSequence(0x0018, 0x9340);
Tag const ContrastBolusUsageSequence(0x0018, 0x9341);
Tag const ContrastBolusAgentAdministered(0x0018, 0x9342);
Tag const ContrastBolusAgentDetected(0x0018, 0x9343);
Tag const ContrastBolusAgentPhase(0x0018, 0x9344);
Tag const CTDIvol(0x0018, 0x9345);
Tag const CTDIPhantomTypeCodeSequence(0x0018, 0x9346);
Tag const CalciumScoringMassFactorPatient(0x0018, 0x9351);
Tag const CalciumScoringMassFactorDevice(0x0018, 0x9352);
Tag const EnergyWeightingFactor(0x0018, 0x9353);
Tag const CTAdditionalXRaySourceSequence(0x0018, 0x9360);
Tag const ProjectionPixelCalibrationSequence(0x0018, 0x9401);
Tag const DistanceSourceToIsocenter(0x0018, 0x9402);
Tag const DistanceObjectToTableTop(0x0018, 0x9403);
Tag const ObjectPixelSpacingInCenterOfBeam(0x0018, 0x9404);
Tag const PositionerPositionSequence(0x0018, 0x9405);
Tag const TablePositionSequence(0x0018, 0x9406);
Tag const CollimatorShapeSequence(0x0018, 0x9407);
Tag const PlanesInAcquisition(0x0018, 0x9410);
Tag const XAXRFFrameCharacteristicsSequence(0x0018, 0x9412);
Tag const FrameAcquisitionSequence(0x0018, 0x9417);
Tag const XRayReceptorType(0x0018, 0x9420);
Tag const AcquisitionProtocolName(0x0018, 0x9423);
Tag const AcquisitionProtocolDescription(0x0018, 0x9424);
Tag const ContrastBolusIngredientOpaque(0x0018, 0x9425);
Tag const DistanceReceptorPlaneToDetectorHousing(0x0018, 0x9426);
Tag const IntensifierActiveShape(0x0018, 0x9427);
Tag const IntensifierActiveDimensions(0x0018, 0x9428);
Tag const PhysicalDetectorSize(0x0018, 0x9429);
Tag const PositionOfIsocenterProjection(0x0018, 0x9430);
Tag const FieldOfViewSequence(0x0018, 0x9432);
Tag const FieldOfViewDescription(0x0018, 0x9433);
Tag const ExposureControlSensingRegionsSequence(0x0018, 0x9434);
Tag const ExposureControlSensingRegionShape(0x0018, 0x9435);
Tag const ExposureControlSensingRegionLeftVerticalEdge(0x0018, 0x9436);
Tag const ExposureControlSensingRegionRightVerticalEdge(0x0018, 0x9437);
Tag const ExposureControlSensingRegionUpperHorizontalEdge(0x0018, 0x9438);
Tag const ExposureControlSensingRegionLowerHorizontalEdge(0x0018, 0x9439);
Tag const CenterOfCircularExposureControlSensingRegion(0x0018, 0x9440);
Tag const RadiusOfCircularExposureControlSensingRegion(0x0018, 0x9441);
Tag const VerticesOfThePolygonalExposureControlSensingRegion(0x0018, 0x9442);
Tag const ColumnAngulationPatient(0x0018, 0x9447);
Tag const BeamAngle(0x0018, 0x9449);
Tag const FrameDetectorParametersSequence(0x0018, 0x9451);
Tag const CalculatedAnatomyThickness(0x0018, 0x9452);
Tag const CalibrationSequence(0x0018, 0x9455);
Tag const ObjectThicknessSequence(0x0018, 0x9456);
Tag const PlaneIdentification(0x0018, 0x9457);
Tag const FieldOfViewDimensionsInFloat(0x0018, 0x9461);
Tag const IsocenterReferenceSystemSequence(0x0018, 0x9462);
Tag const PositionerIsocenterPrimaryAngle(0x0018, 0x9463);
Tag const PositionerIsocenterSecondaryAngle(0x0018, 0x9464);
Tag const PositionerIsocenterDetectorRotationAngle(0x0018, 0x9465);
Tag const TableXPositionToIsocenter(0x0018, 0x9466);
Tag const TableYPositionToIsocenter(0x0018, 0x9467);
Tag const TableZPositionToIsocenter(0x0018, 0x9468);
Tag const TableHorizontalRotationAngle(0x0018, 0x9469);
Tag const TableHeadTiltAngle(0x0018, 0x9470);
Tag const TableCradleTiltAngle(0x0018, 0x9471);
Tag const FrameDisplayShutterSequence(0x0018, 0x9472);
Tag const AcquiredImageAreaDoseProduct(0x0018, 0x9473);
Tag const CArmPositionerTabletopRelationship(0x0018, 0x9474);
Tag const XRayGeometrySequence(0x0018, 0x9476);
Tag const IrradiationEventIdentificationSequence(0x0018, 0x9477);
Tag const XRay3DFrameTypeSequence(0x0018, 0x9504);
Tag const ContributingSourcesSequence(0x0018, 0x9506);
Tag const XRay3DAcquisitionSequence(0x0018, 0x9507);
Tag const PrimaryPositionerScanArc(0x0018, 0x9508);
Tag const SecondaryPositionerScanArc(0x0018, 0x9509);
Tag const PrimaryPositionerScanStartAngle(0x0018, 0x9510);
Tag const SecondaryPositionerScanStartAngle(0x0018, 0x9511);
Tag const PrimaryPositionerIncrement(0x0018, 0x9514);
Tag const SecondaryPositionerIncrement(0x0018, 0x9515);
Tag const StartAcquisitionDateTime(0x0018, 0x9516);
Tag const EndAcquisitionDateTime(0x0018, 0x9517);
Tag const PrimaryPositionerIncrementSign(0x0018, 0x9518);
Tag const SecondaryPositionerIncrementSign(0x0018, 0x9519);
Tag const ApplicationName(0x0018, 0x9524);
Tag const ApplicationVersion(0x0018, 0x9525);
Tag const ApplicationManufacturer(0x0018, 0x9526);
Tag const AlgorithmType(0x0018, 0x9527);
Tag const AlgorithmDescription(0x0018, 0x9528);
Tag const XRay3DReconstructionSequence(0x0018, 0x9530);
Tag const ReconstructionDescription(0x0018, 0x9531);
Tag const PerProjectionAcquisitionSequence(0x0018, 0x9538);
Tag const DetectorPositionSequence(0x0018, 0x9541);
Tag const XRayAcquisitionDoseSequence(0x0018, 0x9542);
Tag const XRaySourceIsocenterPrimaryAngle(0x0018, 0x9543);
Tag const XRaySourceIsocenterSecondaryAngle(0x0018, 0x9544);
Tag const BreastSupportIsocenterPrimaryAngle(0x0018, 0x9545);
Tag const BreastSupportIsocenterSecondaryAngle(0x0018, 0x9546);
Tag const BreastSupportXPositionToIsocenter(0x0018, 0x9547);
Tag const BreastSupportYPositionToIsocenter(0x0018, 0x9548);
Tag const BreastSupportZPositionToIsocenter(0x0018, 0x9549);
Tag const DetectorIsocenterPrimaryAngle(0x0018, 0x9550);
Tag const DetectorIsocenterSecondaryAngle(0x0018, 0x9551);
Tag const DetectorXPositionToIsocenter(0x0018, 0x9552);
Tag const DetectorYPositionToIsocenter(0x0018, 0x9553);
Tag const DetectorZPositionToIsocenter(0x0018, 0x9554);
Tag const XRayGridSequence(0x0018, 0x9555);
Tag const XRayFilterSequence(0x0018, 0x9556);
Tag const DetectorActiveAreaTLHCPosition(0x0018, 0x9557);
Tag const DetectorActiveAreaOrientation(0x0018, 0x9558);
Tag const PositionerPrimaryAngleDirection(0x0018, 0x9559);
Tag const DiffusionBMatrixSequence(0x0018, 0x9601);
Tag const DiffusionBValueXX(0x0018, 0x9602);
Tag const DiffusionBValueXY(0x0018, 0x9603);
Tag const DiffusionBValueXZ(0x0018, 0x9604);
Tag const DiffusionBValueYY(0x0018, 0x9605);
Tag const DiffusionBValueYZ(0x0018, 0x9606);
Tag const DiffusionBValueZZ(0x0018, 0x9607);
Tag const FunctionalMRSequence(0x0018, 0x9621);
Tag const FunctionalSettlingPhaseFramesPresent(0x0018, 0x9622);
Tag const FunctionalSyncPulse(0x0018, 0x9623);
Tag const SettlingPhaseFrame(0x0018, 0x9624);
Tag const DecayCorrectionDateTime(0x0018, 0x9701);
Tag const StartDensityThreshold(0x0018, 0x9715);
Tag const StartRelativeDensityDifferenceThreshold(0x0018, 0x9716);
Tag const StartCardiacTriggerCountThreshold(0x0018, 0x9717);
Tag const StartRespiratoryTriggerCountThreshold(0x0018, 0x9718);
Tag const TerminationCountsThreshold(0x0018, 0x9719);
Tag const TerminationDensityThreshold(0x0018, 0x9720);
Tag const TerminationRelativeDensityThreshold(0x0018, 0x9721);
Tag const TerminationTimeThreshold(0x0018, 0x9722);
Tag const TerminationCardiacTriggerCountThreshold(0x0018, 0x9723);
Tag const TerminationRespiratoryTriggerCountThreshold(0x0018, 0x9724);
Tag const DetectorGeometry(0x0018, 0x9725);
Tag const TransverseDetectorSeparation(0x0018, 0x9726);
Tag const AxialDetectorDimension(0x0018, 0x9727);
Tag const RadiopharmaceuticalAgentNumber(0x0018, 0x9729);
Tag const PETFrameAcquisitionSequence(0x0018, 0x9732);
Tag const PETDetectorMotionDetailsSequence(0x0018, 0x9733);
Tag const PETTableDynamicsSequence(0x0018, 0x9734);
Tag const PETPositionSequence(0x0018, 0x9735);
Tag const PETFrameCorrectionFactorsSequence(0x0018, 0x9736);
Tag const RadiopharmaceuticalUsageSequence(0x0018, 0x9737);
Tag const AttenuationCorrectionSource(0x0018, 0x9738);
Tag const NumberOfIterations(0x0018, 0x9739);
Tag const NumberOfSubsets(0x0018, 0x9740);
Tag const PETReconstructionSequence(0x0018, 0x9749);
Tag const PETFrameTypeSequence(0x0018, 0x9751);
Tag const TimeOfFlightInformationUsed(0x0018, 0x9755);
Tag const ReconstructionType(0x0018, 0x9756);
Tag const DecayCorrected(0x0018, 0x9758);
Tag const AttenuationCorrected(0x0018, 0x9759);
Tag const ScatterCorrected(0x0018, 0x9760);
Tag const DeadTimeCorrected(0x0018, 0x9761);
Tag const GantryMotionCorrected(0x0018, 0x9762);
Tag const PatientMotionCorrected(0x0018, 0x9763);
Tag const CountLossNormalizationCorrected(0x0018, 0x9764);
Tag const RandomsCorrected(0x0018, 0x9765);
Tag const NonUniformRadialSamplingCorrected(0x0018, 0x9766);
Tag const SensitivityCalibrated(0x0018, 0x9767);
Tag const DetectorNormalizationCorrection(0x0018, 0x9768);
Tag const IterativeReconstructionMethod(0x0018, 0x9769);
Tag const AttenuationCorrectionTemporalRelationship(0x0018, 0x9770);
Tag const PatientPhysiologicalStateSequence(0x0018, 0x9771);
Tag const PatientPhysiologicalStateCodeSequence(0x0018, 0x9772);
Tag const DepthsOfFocus(0x0018, 0x9801);
Tag const ExcludedIntervalsSequence(0x0018, 0x9803);
Tag const ExclusionStartDateTime(0x0018, 0x9804);
Tag const ExclusionDuration(0x0018, 0x9805);
Tag const USImageDescriptionSequence(0x0018, 0x9806);
Tag const ImageDataTypeSequence(0x0018, 0x9807);
Tag const DataType(0x0018, 0x9808);
Tag const TransducerScanPatternCodeSequence(0x0018, 0x9809);
Tag const AliasedDataType(0x0018, 0x980b);
Tag const PositionMeasuringDeviceUsed(0x0018, 0x980c);
Tag const TransducerGeometryCodeSequence(0x0018, 0x980d);
Tag const TransducerBeamSteeringCodeSequence(0x0018, 0x980e);
Tag const TransducerApplicationCodeSequence(0x0018, 0x980f);
Tag const ZeroVelocityPixelValue(0x0018, 0x9810);
Tag const ReferenceLocationLabel(0x0018, 0x9900);
Tag const ReferenceLocationDescription(0x0018, 0x9901);
Tag const ReferenceBasisCodeSequence(0x0018, 0x9902);
Tag const ReferenceGeometryCodeSequence(0x0018, 0x9903);
Tag const OffsetDistance(0x0018, 0x9904);
Tag const OffsetDirection(0x0018, 0x9905);
Tag const PotentialScheduledProtocolCodeSequence(0x0018, 0x9906);
Tag const PotentialRequestedProcedureCodeSequence(0x0018, 0x9907);
Tag const PotentialReasonsForProcedure(0x0018, 0x9908);
Tag const PotentialReasonsForProcedureCodeSequence(0x0018, 0x9909);
Tag const PotentialDiagnosticTasks(0x0018, 0x990a);
Tag const ContraindicationsCodeSequence(0x0018, 0x990b);
Tag const ReferencedDefinedProtocolSequence(0x0018, 0x990c);
Tag const ReferencedPerformedProtocolSequence(0x0018, 0x990d);
Tag const PredecessorProtocolSequence(0x0018, 0x990e);
Tag const ProtocolPlanningInformation(0x0018, 0x990f);
Tag const ProtocolDesignRationale(0x0018, 0x9910);
Tag const PatientSpecificationSequence(0x0018, 0x9911);
Tag const ModelSpecificationSequence(0x0018, 0x9912);
Tag const ParametersSpecificationSequence(0x0018, 0x9913);
Tag const InstructionSequence(0x0018, 0x9914);
Tag const InstructionIndex(0x0018, 0x9915);
Tag const InstructionText(0x0018, 0x9916);
Tag const InstructionDescription(0x0018, 0x9917);
Tag const InstructionPerformedFlag(0x0018, 0x9918);
Tag const InstructionPerformedDateTime(0x0018, 0x9919);
Tag const InstructionPerformanceComment(0x0018, 0x991a);
Tag const PatientPositioningInstructionSequence(0x0018, 0x991b);
Tag const PositioningMethodCodeSequence(0x0018, 0x991c);
Tag const PositioningLandmarkSequence(0x0018, 0x991d);
Tag const TargetFrameOfReferenceUID(0x0018, 0x991e);
Tag const AcquisitionProtocolElementSpecificationSequence(0x0018, 0x991f);
Tag const AcquisitionProtocolElementSequence(0x0018, 0x9920);
Tag const ProtocolElementNumber(0x0018, 0x9921);
Tag const ProtocolElementName(0x0018, 0x9922);
Tag const ProtocolElementCharacteristicsSummary(0x0018, 0x9923);
Tag const ProtocolElementPurpose(0x0018, 0x9924);
Tag const AcquisitionMotion(0x0018, 0x9930);
Tag const AcquisitionStartLocationSequence(0x0018, 0x9931);
Tag const AcquisitionEndLocationSequence(0x0018, 0x9932);
Tag const ReconstructionProtocolElementSpecificationSequence(0x0018, 0x9933);
Tag const ReconstructionProtocolElementSequence(0x0018, 0x9934);
Tag const StorageProtocolElementSpecificationSequence(0x0018, 0x9935);
Tag const StorageProtocolElementSequence(0x0018, 0x9936);
Tag const RequestedSeriesDescription(0x0018, 0x9937);
Tag const SourceAcquisitionProtocolElementNumber(0x0018, 0x9938);
Tag const SourceAcquisitionBeamNumber(0x0018, 0x9939);
Tag const SourceReconstructionProtocolElementNumber(0x0018, 0x993a);
Tag const ReconstructionStartLocationSequence(0x0018, 0x993b);
Tag const ReconstructionEndLocationSequence(0x0018, 0x993c);
Tag const ReconstructionAlgorithmSequence(0x0018, 0x993d);
Tag const ReconstructionTargetCenterLocationSequence(0x0018, 0x993e);
Tag const ImageFilterDescription(0x0018, 0x9941);
Tag const CTDIvolNotificationTrigger(0x0018, 0x9942);
Tag const DLPNotificationTrigger(0x0018, 0x9943);
Tag const AutoKVPSelectionType(0x0018, 0x9944);
Tag const AutoKVPUpperBound(0x0018, 0x9945);
Tag const AutoKVPLowerBound(0x0018, 0x9946);
Tag const ProtocolDefinedPatientPosition(0x0018, 0x9947);
Tag const ContributingEquipmentSequence(0x0018, 0xa001);
Tag const ContributionDateTime(0x0018, 0xa002);
Tag const ContributionDescription(0x0018, 0xa003);

}

}

#endif // _afc7b2d7_0869_4fea_9a9b_7fe6228baca9_0018