/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uoscodeconv.h"
UosCharSet uos_conv_guess_ja_encoding		(const gchar	*str){
    return conv_guess_ja_encoding		(str);
}

gchar *uos_conv_utf8todisp			(const gchar	*inbuf,
                                     gint		*error){
    return conv_utf8todisp			(inbuf,error);
}

gchar *uos_conv_localetodisp		(const gchar	*inbuf,
                                     gint		*error){
    return conv_localetodisp		(inbuf,error);
}


UosCodeConverter *uos_conv_code_converter_new	(const gchar	*src_encoding,
                                                 const gchar	*dest_encoding){
    return conv_code_converter_new	(src_encoding,dest_encoding);
}

void uos_conv_code_converter_destroy	(UosCodeConverter	*conv){
    conv_code_converter_destroy	(conv);
}

gchar *uos_conv_convert			(UosCodeConverter	*conv,
                                 const gchar	*inbuf){
    return conv_convert			(conv,inbuf);
}



#define uosconv_codeset_strdup(inbuf, src_code, dest_code) conv_codeset_strdup(inbuf, src_code, dest_code)

gchar *uos_conv_codeset_strdup_full		(const gchar	*inbuf,
                                         const gchar	*src_encoding,
                                         const gchar	*dest_encoding,
                                         gint		*error){
    return conv_codeset_strdup_full		(inbuf,src_encoding,dest_encoding,error);
}



UosCodeConvFunc uos_conv_get_code_conv_func	(const gchar	*src_encoding,
                                             const gchar	*dest_encoding){
    return conv_get_code_conv_func	(src_encoding,dest_encoding);
}


gchar *uos_conv_iconv_strdup		(const gchar	*inbuf,
                                     const gchar	*src_encoding,
                                     const gchar	*dest_encoding,
                                     gint		*error){
    return conv_iconv_strdup		(inbuf,src_encoding,dest_encoding,error);
}


gchar *uos_conv_iconv_strdup_with_cd	(const gchar	*inbuf,
                                         iconv_t	 cd,
                                         gint		*error){
    return conv_iconv_strdup_with_cd	(inbuf,cd,error);
}


const gchar *uos_conv_get_charset_str		(UosCharSet	 charset){
    return conv_get_charset_str		(charset);
}

UosCharSet uos_conv_get_charset_from_str		(const gchar	*charset){
    return conv_get_charset_from_str		(charset);
}

UosCharSet uos_conv_get_locale_charset			(void){
    return conv_get_locale_charset			();
}

const gchar *uos_conv_get_locale_charset_str	(void){
    return conv_get_locale_charset_str			();
}

UosCharSet uos_conv_get_internal_charset		(void){
    return conv_get_internal_charset			();
}

const gchar *uos_conv_get_internal_charset_str	(void){
    return conv_get_internal_charset_str			();
}

UosCharSet uos_conv_get_outgoing_charset		(void){
    return conv_get_outgoing_charset			();
}

const gchar *uos_conv_get_outgoing_charset_str	(void){
    return conv_get_outgoing_charset_str			();
}

gboolean uos_conv_is_multibyte_encoding		(UosCharSet	 encoding){
    return conv_is_multibyte_encoding		(encoding);
}


const gchar *uos_conv_get_current_locale		(void){
    return conv_get_current_locale			();
}

gboolean uos_conv_is_ja_locale			(void){
    return conv_is_ja_locale			();
}


void uos_conv_set_autodetect_type			(UosConvADType	 type){
    conv_set_autodetect_type			(type);
}

UosConvADType uos_conv_get_autodetect_type		(void){
    return conv_get_autodetect_type			();
}

gchar *uos_conv_unmime_header		(const gchar	*str,
                                     const gchar	*default_encoding){
    return conv_unmime_header		(str,default_encoding);
}

void uos_conv_encode_header			(gchar		*dest,
                                     gint		 len,
                                     const gchar	*src,
                                     gint		 header_len,
                                     gboolean	 addr_field,
                                     const gchar	*out_encoding){
    conv_encode_header			(dest,len,src,header_len,addr_field,out_encoding);
}

gchar *uos_conv_encode_filename		(const gchar	*src,
                                     const gchar	*param_name,
                                     const gchar	*out_encoding){
    return conv_encode_filename	(src,param_name,out_encoding);
}


gint uos_conv_copy_file			(const gchar	*src,
                                 const gchar	*dest,
                                 const gchar	*src_encoding){
    return conv_copy_file			(src,dest,src_encoding);
}

gint uos_conv_copy_dir			(const gchar	*src,
                                 const gchar	*dest,
                                 const gchar	*src_encoding){
    return conv_copy_dir			(src,dest,src_encoding);
}


UosCharSet uos_conv_check_file_encoding	(const gchar	*file){
    return conv_check_file_encoding	(file);
}


gchar *uos_conv_filename_from_utf8		(const gchar	*utf8_file){
    return conv_filename_from_utf8		(utf8_file);
}


gchar *uos_conv_filename_to_utf8		(const gchar	*fs_file){
    return conv_filename_to_utf8		(fs_file);
}


