package http

import (
	"testing"
)

var testDataSet1 = []struct {
	in  string
	out bool
}{
	{"https://professional-packages.chinauos.com/desktop-professional", true},
	{"https://professional-packages.chinauosxxx.com/desktop-professional", false},
}

// DialUrlHttpGet
func TestDialUrlHttpGet(t *testing.T) {
	t.Parallel()
	for _, tds := range testDataSet1 {
		ret := DialUrlHttpGet(tds.in, 5)
		retB := (ret == nil)
		if retB != tds.out {
			t.Errorf("the key %v , ret %v", tds, ret)
		}
	}
}

var testDataSet2 = []struct {
	in    string
	out   string
	state bool
}{
	{"http://pools.uniontech.com/desktop-professional/dists/eagle/1050/main/binary-amd64/Packages.gz", "Packages.gz", true},
	{"http://pools.uniontech.com/desktop-professional/dists/eagle/1050/main/binary-amd64", "binary-amd64", true},
	{"http://pools.uniontech.com/desktop-professional/dists/eagle/1050/main/binary-amd64/AAAA", "AAAA", false},
}

// DownloadFileHttpGet
func TestDownloadFileHttpGet(t *testing.T) {
	t.Parallel()
	for _, tds := range testDataSet2 {
		out, _, ret := DownloadFileHttpGet(tds.in, "/tmp/", 10)
		retB := (ret == nil)
		//t.Logf("DownloadFileHttpGet out:%+v,ret:%+v,in:%+v", out, ret, tds)
		if retB != tds.state && (out == tds.out || !tds.state) {
			t.Errorf("the key %v , ret %v", tds, ret)
		}
	}
}
