# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network vnet create",
)
class Create(AAZCommand):
    """Create a virtual network.

    You may also create a subnet at the same time by specifying a subnet name and (optionally) an address prefix. To learn about how to create a virtual network visit https://learn.microsoft.com/azure/virtual-network/manage-virtual-network#create-a-virtual-network.

    :example: Create a virtual network with a specific address prefix and one subnet.
        az network vnet create -g MyResourceGroup -n MyVnet --address-prefix 10.0.0.0/16 --subnet-name MySubnet --subnet-prefixes 10.0.0.0/24

    :example: Create a virtual network.
        az network vnet create --address-prefixes 10.0.0.0/16 --name MyVirtualNetwork --resource-group MyResourceGroup --subnet-name MyAseSubnet --subnet-prefixes 10.0.0.0/24
    """

    _aaz_info = {
        "version": "2017-10-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/virtualnetworks/{}", "2017-10-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The virtual network (VNet) name.",
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.address_prefixes = AAZListArg(
            options=["--address-prefixes"],
            help="Space-separated list of IP address prefixes for the VNet. Default: 10.0.0.0/16.",
            default=["10.0.0.0/16"],
        )
        _args_schema.dns_servers = AAZListArg(
            options=["--dns-servers"],
            help="Space-separated list of DNS server IP addresses.",
        )
        _args_schema.ddos_protection = AAZBoolArg(
            options=["--ddos-protection"],
            help="Control whether DDoS protection is enabled.",
            default=False,
        )
        _args_schema.vm_protection = AAZBoolArg(
            options=["--vm-protection"],
            help="Enable VM protection for all subnets in the VNet.",
            default=False,
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...].",
        )

        address_prefixes = cls._args_schema.address_prefixes
        address_prefixes.Element = AAZStrArg()

        dns_servers = cls._args_schema.dns_servers
        dns_servers.Element = AAZStrArg()

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Parameters"

        # define Arg Group "Properties"

        # define Arg Group "Subnet"

        _args_schema = cls._args_schema
        _args_schema.subnets = AAZListArg(
            options=["--subnets"],
            arg_group="Subnet",
            help="Manage a list of subnets in a Virtual Network (similar to `az network vnet subnet`).",
        )

        subnets = cls._args_schema.subnets
        subnets.Element = AAZObjectArg()

        _element = cls._args_schema.subnets.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The subnet name.",
        )
        _element.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The address prefix for the subnet.",
        )
        _element.network_security_group = AAZObjectArg(
            options=["nsg", "network-security-group"],
            help="The reference to the NetworkSecurityGroup resource.",
        )
        _element.route_table = AAZObjectArg(
            options=["route-table"],
            help="The reference to the RouteTable resource.",
        )
        _element.service_endpoints = AAZListArg(
            options=["service-endpoints"],
            help="An array of service endpoints.",
        )

        network_security_group = cls._args_schema.subnets.Element.network_security_group
        network_security_group.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        network_security_group.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkSecurityGroups/{}",
            ),
        )
        network_security_group.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        network_security_group.default_security_rules = AAZListArg(
            options=["default-security-rules"],
            help="The default security rules of network security group.",
        )
        network_security_group.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        network_security_group.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the network security group resource.",
        )
        network_security_group.security_rules = AAZListArg(
            options=["security-rules"],
            help="A collection of security rules of the network security group.",
        )
        network_security_group.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        default_security_rules = cls._args_schema.subnets.Element.network_security_group.default_security_rules
        default_security_rules.Element = AAZObjectArg()
        cls._build_args_security_rule_create(default_security_rules.Element)

        security_rules = cls._args_schema.subnets.Element.network_security_group.security_rules
        security_rules.Element = AAZObjectArg()

        _element = cls._args_schema.subnets.Element.network_security_group.security_rules.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        _element.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        _element.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        _element.destination_address_prefixes = AAZListArg(
            options=["destination-address-prefixes"],
            help="The destination address prefixes. CIDR or destination IP ranges.",
        )
        _element.destination_application_security_groups = AAZListArg(
            options=["destination-application-security-groups"],
            help="The application security group specified as destination.",
        )
        _element.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        _element.destination_port_ranges = AAZListArg(
            options=["destination-port-ranges"],
            help="The destination port ranges.",
        )
        _element.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        _element.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        _element.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.",
        )
        _element.source_address_prefixes = AAZListArg(
            options=["source-address-prefixes"],
            help="The CIDR or source IP ranges.",
        )
        _element.source_application_security_groups = AAZListArg(
            options=["source-application-security-groups"],
            help="The application security group specified as source.",
        )
        _element.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        _element.source_port_ranges = AAZListArg(
            options=["source-port-ranges"],
            help="The source port ranges.",
        )

        destination_address_prefixes = cls._args_schema.subnets.Element.network_security_group.security_rules.Element.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrArg()

        destination_application_security_groups = cls._args_schema.subnets.Element.network_security_group.security_rules.Element.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(destination_application_security_groups.Element)

        destination_port_ranges = cls._args_schema.subnets.Element.network_security_group.security_rules.Element.destination_port_ranges
        destination_port_ranges.Element = AAZStrArg()

        source_address_prefixes = cls._args_schema.subnets.Element.network_security_group.security_rules.Element.source_address_prefixes
        source_address_prefixes.Element = AAZStrArg()

        source_application_security_groups = cls._args_schema.subnets.Element.network_security_group.security_rules.Element.source_application_security_groups
        source_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(source_application_security_groups.Element)

        source_port_ranges = cls._args_schema.subnets.Element.network_security_group.security_rules.Element.source_port_ranges
        source_port_ranges.Element = AAZStrArg()

        tags = cls._args_schema.subnets.Element.network_security_group.tags
        tags.Element = AAZStrArg()

        route_table = cls._args_schema.subnets.Element.route_table
        route_table.etag = AAZStrArg(
            options=["etag"],
            help="Gets a unique read-only string that changes whenever the resource is updated.",
        )
        route_table.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}",
            ),
        )
        route_table.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        route_table.disable_bgp_route_propagation = AAZBoolArg(
            options=["disable-bgp-route-propagation"],
            help="Whether to disable the routes learned by BGP on that route table. True means disable.",
        )
        route_table.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        route_table.routes = AAZListArg(
            options=["routes"],
            help="Collection of routes contained within a route table.",
        )
        route_table.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        routes = cls._args_schema.subnets.Element.route_table.routes
        routes.Element = AAZObjectArg()

        _element = cls._args_schema.subnets.Element.route_table.routes.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}/routes/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The destination CIDR to which the route applies.",
        )
        _element.next_hop_ip_address = AAZStrArg(
            options=["next-hop-ip-address"],
            help="The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.",
        )
        _element.next_hop_type = AAZStrArg(
            options=["next-hop-type"],
            help="The type of Azure hop the packet should be sent to.",
            enum={"Internet": "Internet", "None": "None", "VirtualAppliance": "VirtualAppliance", "VirtualNetworkGateway": "VirtualNetworkGateway", "VnetLocal": "VnetLocal"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )

        tags = cls._args_schema.subnets.Element.route_table.tags
        tags.Element = AAZStrArg()

        service_endpoints = cls._args_schema.subnets.Element.service_endpoints
        service_endpoints.Element = AAZObjectArg()

        _element = cls._args_schema.subnets.Element.service_endpoints.Element
        _element.locations = AAZListArg(
            options=["locations"],
            help="A list of locations.",
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the resource.",
        )
        _element.service = AAZStrArg(
            options=["service"],
            help="The type of the endpoint service.",
        )

        locations = cls._args_schema.subnets.Element.service_endpoints.Element.locations
        locations.Element = AAZStrArg()
        return cls._args_schema

    _args_address_space_create = None

    @classmethod
    def _build_args_address_space_create(cls, _schema):
        if cls._args_address_space_create is not None:
            _schema.address_prefixes = cls._args_address_space_create.address_prefixes
            return

        cls._args_address_space_create = AAZObjectArg()

        address_space_create = cls._args_address_space_create
        address_space_create.address_prefixes = AAZListArg(
            options=["address-prefixes"],
            help="A list of address blocks reserved for this virtual network in CIDR notation.",
        )

        address_prefixes = cls._args_address_space_create.address_prefixes
        address_prefixes.Element = AAZStrArg()

        _schema.address_prefixes = cls._args_address_space_create.address_prefixes

    _args_application_security_group_create = None

    @classmethod
    def _build_args_application_security_group_create(cls, _schema):
        if cls._args_application_security_group_create is not None:
            _schema.id = cls._args_application_security_group_create.id
            _schema.location = cls._args_application_security_group_create.location
            _schema.tags = cls._args_application_security_group_create.tags
            return

        cls._args_application_security_group_create = AAZObjectArg()

        application_security_group_create = cls._args_application_security_group_create
        application_security_group_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/applicationSecurityGroups/{}",
            ),
        )
        application_security_group_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        application_security_group_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        tags = cls._args_application_security_group_create.tags
        tags.Element = AAZStrArg()

        _schema.id = cls._args_application_security_group_create.id
        _schema.location = cls._args_application_security_group_create.location
        _schema.tags = cls._args_application_security_group_create.tags

    _args_security_rule_create = None

    @classmethod
    def _build_args_security_rule_create(cls, _schema):
        if cls._args_security_rule_create is not None:
            _schema.access = cls._args_security_rule_create.access
            _schema.description = cls._args_security_rule_create.description
            _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
            _schema.destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
            _schema.destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
            _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
            _schema.destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
            _schema.direction = cls._args_security_rule_create.direction
            _schema.etag = cls._args_security_rule_create.etag
            _schema.name = cls._args_security_rule_create.name
            _schema.priority = cls._args_security_rule_create.priority
            _schema.protocol = cls._args_security_rule_create.protocol
            _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
            _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
            _schema.source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
            _schema.source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
            _schema.source_port_range = cls._args_security_rule_create.source_port_range
            _schema.source_port_ranges = cls._args_security_rule_create.source_port_ranges
            return

        cls._args_security_rule_create = AAZObjectArg()

        security_rule_create = cls._args_security_rule_create
        security_rule_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        security_rule_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        security_rule_create.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        security_rule_create.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        security_rule_create.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        security_rule_create.destination_address_prefixes = AAZListArg(
            options=["destination-address-prefixes"],
            help="The destination address prefixes. CIDR or destination IP ranges.",
        )
        security_rule_create.destination_application_security_groups = AAZListArg(
            options=["destination-application-security-groups"],
            help="The application security group specified as destination.",
        )
        security_rule_create.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        security_rule_create.destination_port_ranges = AAZListArg(
            options=["destination-port-ranges"],
            help="The destination port ranges.",
        )
        security_rule_create.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        security_rule_create.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        security_rule_create.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        security_rule_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        security_rule_create.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. ",
        )
        security_rule_create.source_address_prefixes = AAZListArg(
            options=["source-address-prefixes"],
            help="The CIDR or source IP ranges.",
        )
        security_rule_create.source_application_security_groups = AAZListArg(
            options=["source-application-security-groups"],
            help="The application security group specified as source.",
        )
        security_rule_create.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        security_rule_create.source_port_ranges = AAZListArg(
            options=["source-port-ranges"],
            help="The source port ranges.",
        )

        destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrArg()

        destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(destination_application_security_groups.Element)

        destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
        destination_port_ranges.Element = AAZStrArg()

        source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
        source_address_prefixes.Element = AAZStrArg()

        source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
        source_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(source_application_security_groups.Element)

        source_port_ranges = cls._args_security_rule_create.source_port_ranges
        source_port_ranges.Element = AAZStrArg()

        _schema.access = cls._args_security_rule_create.access
        _schema.description = cls._args_security_rule_create.description
        _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
        _schema.destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
        _schema.destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
        _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
        _schema.destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
        _schema.direction = cls._args_security_rule_create.direction
        _schema.etag = cls._args_security_rule_create.etag
        _schema.name = cls._args_security_rule_create.name
        _schema.priority = cls._args_security_rule_create.priority
        _schema.protocol = cls._args_security_rule_create.protocol
        _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
        _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
        _schema.source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
        _schema.source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
        _schema.source_port_range = cls._args_security_rule_create.source_port_range
        _schema.source_port_ranges = cls._args_security_rule_create.source_port_ranges

    def _execute_operations(self):
        self.pre_operations()
        yield self.VirtualNetworksCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualNetworksCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkName", self.ctx.args.name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2017-10-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("addressSpace", AAZObjectType)
                properties.set_prop("dhcpOptions", AAZObjectType)
                properties.set_prop("enableDdosProtection", AAZBoolType, ".ddos_protection")
                properties.set_prop("enableVmProtection", AAZBoolType, ".vm_protection")
                properties.set_prop("subnets", AAZListType, ".subnets")

            address_space = _builder.get(".properties.addressSpace")
            if address_space is not None:
                address_space.set_prop("addressPrefixes", AAZListType, ".address_prefixes")

            address_prefixes = _builder.get(".properties.addressSpace.addressPrefixes")
            if address_prefixes is not None:
                address_prefixes.set_elements(AAZStrType, ".")

            dhcp_options = _builder.get(".properties.dhcpOptions")
            if dhcp_options is not None:
                dhcp_options.set_prop("dnsServers", AAZListType, ".dns_servers")

            dns_servers = _builder.get(".properties.dhcpOptions.dnsServers")
            if dns_servers is not None:
                dns_servers.set_elements(AAZStrType, ".")

            subnets = _builder.get(".properties.subnets")
            if subnets is not None:
                subnets.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.subnets[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.subnets[].properties")
            if properties is not None:
                properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
                properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group")
                properties.set_prop("routeTable", AAZObjectType, ".route_table")
                properties.set_prop("serviceEndpoints", AAZListType, ".service_endpoints")

            network_security_group = _builder.get(".properties.subnets[].properties.networkSecurityGroup")
            if network_security_group is not None:
                network_security_group.set_prop("etag", AAZStrType, ".etag")
                network_security_group.set_prop("id", AAZStrType, ".id")
                network_security_group.set_prop("location", AAZStrType, ".location")
                network_security_group.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                network_security_group.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties")
            if properties is not None:
                properties.set_prop("defaultSecurityRules", AAZListType, ".default_security_rules")
                properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
                properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")
                properties.set_prop("securityRules", AAZListType, ".security_rules")

            default_security_rules = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.defaultSecurityRules")
            if default_security_rules is not None:
                _CreateHelper._build_schema_security_rule_create(default_security_rules.set_elements(AAZObjectType, "."))

            security_rules = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules")
            if security_rules is not None:
                security_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[]")
            if _elements is not None:
                _elements.set_prop("etag", AAZStrType, ".etag")
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties")
            if properties is not None:
                properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix")
                properties.set_prop("destinationAddressPrefixes", AAZListType, ".destination_address_prefixes")
                properties.set_prop("destinationApplicationSecurityGroups", AAZListType, ".destination_application_security_groups")
                properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
                properties.set_prop("destinationPortRanges", AAZListType, ".destination_port_ranges")
                properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("priority", AAZIntType, ".priority")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
                properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix")
                properties.set_prop("sourceAddressPrefixes", AAZListType, ".source_address_prefixes")
                properties.set_prop("sourceApplicationSecurityGroups", AAZListType, ".source_application_security_groups")
                properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")
                properties.set_prop("sourcePortRanges", AAZListType, ".source_port_ranges")

            destination_address_prefixes = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties.destinationAddressPrefixes")
            if destination_address_prefixes is not None:
                destination_address_prefixes.set_elements(AAZStrType, ".")

            destination_application_security_groups = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties.destinationApplicationSecurityGroups")
            if destination_application_security_groups is not None:
                _CreateHelper._build_schema_application_security_group_create(destination_application_security_groups.set_elements(AAZObjectType, "."))

            destination_port_ranges = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties.destinationPortRanges")
            if destination_port_ranges is not None:
                destination_port_ranges.set_elements(AAZStrType, ".")

            source_address_prefixes = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties.sourceAddressPrefixes")
            if source_address_prefixes is not None:
                source_address_prefixes.set_elements(AAZStrType, ".")

            source_application_security_groups = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties.sourceApplicationSecurityGroups")
            if source_application_security_groups is not None:
                _CreateHelper._build_schema_application_security_group_create(source_application_security_groups.set_elements(AAZObjectType, "."))

            source_port_ranges = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties.sourcePortRanges")
            if source_port_ranges is not None:
                source_port_ranges.set_elements(AAZStrType, ".")

            tags = _builder.get(".properties.subnets[].properties.networkSecurityGroup.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            route_table = _builder.get(".properties.subnets[].properties.routeTable")
            if route_table is not None:
                route_table.set_prop("etag", AAZStrType, ".etag")
                route_table.set_prop("id", AAZStrType, ".id")
                route_table.set_prop("location", AAZStrType, ".location")
                route_table.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                route_table.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.subnets[].properties.routeTable.properties")
            if properties is not None:
                properties.set_prop("disableBgpRoutePropagation", AAZBoolType, ".disable_bgp_route_propagation")
                properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
                properties.set_prop("routes", AAZListType, ".routes")

            routes = _builder.get(".properties.subnets[].properties.routeTable.properties.routes")
            if routes is not None:
                routes.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.subnets[].properties.routeTable.properties.routes[]")
            if _elements is not None:
                _elements.set_prop("etag", AAZStrType, ".etag")
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.subnets[].properties.routeTable.properties.routes[].properties")
            if properties is not None:
                properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
                properties.set_prop("nextHopIpAddress", AAZStrType, ".next_hop_ip_address")
                properties.set_prop("nextHopType", AAZStrType, ".next_hop_type", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

            tags = _builder.get(".properties.subnets[].properties.routeTable.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            service_endpoints = _builder.get(".properties.subnets[].properties.serviceEndpoints")
            if service_endpoints is not None:
                service_endpoints.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.subnets[].properties.serviceEndpoints[]")
            if _elements is not None:
                _elements.set_prop("locations", AAZListType, ".locations")
                _elements.set_prop("provisioningState", AAZStrType, ".provisioning_state")
                _elements.set_prop("service", AAZStrType, ".service")

            locations = _builder.get(".properties.subnets[].properties.serviceEndpoints[].locations")
            if locations is not None:
                locations.set_elements(AAZStrType, ".")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType()
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.address_space = AAZObjectType(
                serialized_name="addressSpace",
            )
            _CreateHelper._build_schema_address_space_read(properties.address_space)
            properties.dhcp_options = AAZObjectType(
                serialized_name="dhcpOptions",
            )
            properties.enable_ddos_protection = AAZBoolType(
                serialized_name="enableDdosProtection",
            )
            properties.enable_vm_protection = AAZBoolType(
                serialized_name="enableVmProtection",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.resource_guid = AAZStrType(
                serialized_name="resourceGuid",
            )
            properties.subnets = AAZListType()
            properties.virtual_network_peerings = AAZListType(
                serialized_name="virtualNetworkPeerings",
            )

            dhcp_options = cls._schema_on_200_201.properties.dhcp_options
            dhcp_options.dns_servers = AAZListType(
                serialized_name="dnsServers",
            )

            dns_servers = cls._schema_on_200_201.properties.dhcp_options.dns_servers
            dns_servers.Element = AAZStrType()

            subnets = cls._schema_on_200_201.properties.subnets
            subnets.Element = AAZObjectType()
            _CreateHelper._build_schema_subnet_read(subnets.Element)

            virtual_network_peerings = cls._schema_on_200_201.properties.virtual_network_peerings
            virtual_network_peerings.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.virtual_network_peerings.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200_201.properties.virtual_network_peerings.Element.properties
            properties.allow_forwarded_traffic = AAZBoolType(
                serialized_name="allowForwardedTraffic",
            )
            properties.allow_gateway_transit = AAZBoolType(
                serialized_name="allowGatewayTransit",
            )
            properties.allow_virtual_network_access = AAZBoolType(
                serialized_name="allowVirtualNetworkAccess",
            )
            properties.peering_state = AAZStrType(
                serialized_name="peeringState",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.remote_address_space = AAZObjectType(
                serialized_name="remoteAddressSpace",
            )
            _CreateHelper._build_schema_address_space_read(properties.remote_address_space)
            properties.remote_virtual_network = AAZObjectType(
                serialized_name="remoteVirtualNetwork",
            )
            _CreateHelper._build_schema_sub_resource_read(properties.remote_virtual_network)
            properties.use_remote_gateways = AAZBoolType(
                serialized_name="useRemoteGateways",
            )

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_address_space_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("addressPrefixes", AAZListType, ".address_prefixes")

        address_prefixes = _builder.get(".addressPrefixes")
        if address_prefixes is not None:
            address_prefixes.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_application_security_group_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("tags", AAZDictType, ".tags")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_security_rule_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("description", AAZStrType, ".description")
            properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix")
            properties.set_prop("destinationAddressPrefixes", AAZListType, ".destination_address_prefixes")
            properties.set_prop("destinationApplicationSecurityGroups", AAZListType, ".destination_application_security_groups")
            properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
            properties.set_prop("destinationPortRanges", AAZListType, ".destination_port_ranges")
            properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("priority", AAZIntType, ".priority")
            properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix")
            properties.set_prop("sourceAddressPrefixes", AAZListType, ".source_address_prefixes")
            properties.set_prop("sourceApplicationSecurityGroups", AAZListType, ".source_application_security_groups")
            properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")
            properties.set_prop("sourcePortRanges", AAZListType, ".source_port_ranges")

        destination_address_prefixes = _builder.get(".properties.destinationAddressPrefixes")
        if destination_address_prefixes is not None:
            destination_address_prefixes.set_elements(AAZStrType, ".")

        destination_application_security_groups = _builder.get(".properties.destinationApplicationSecurityGroups")
        if destination_application_security_groups is not None:
            cls._build_schema_application_security_group_create(destination_application_security_groups.set_elements(AAZObjectType, "."))

        destination_port_ranges = _builder.get(".properties.destinationPortRanges")
        if destination_port_ranges is not None:
            destination_port_ranges.set_elements(AAZStrType, ".")

        source_address_prefixes = _builder.get(".properties.sourceAddressPrefixes")
        if source_address_prefixes is not None:
            source_address_prefixes.set_elements(AAZStrType, ".")

        source_application_security_groups = _builder.get(".properties.sourceApplicationSecurityGroups")
        if source_application_security_groups is not None:
            cls._build_schema_application_security_group_create(source_application_security_groups.set_elements(AAZObjectType, "."))

        source_port_ranges = _builder.get(".properties.sourcePortRanges")
        if source_port_ranges is not None:
            source_port_ranges.set_elements(AAZStrType, ".")

    _schema_address_space_read = None

    @classmethod
    def _build_schema_address_space_read(cls, _schema):
        if cls._schema_address_space_read is not None:
            _schema.address_prefixes = cls._schema_address_space_read.address_prefixes
            return

        cls._schema_address_space_read = _schema_address_space_read = AAZObjectType()

        address_space_read = _schema_address_space_read
        address_space_read.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )

        address_prefixes = _schema_address_space_read.address_prefixes
        address_prefixes.Element = AAZStrType()

        _schema.address_prefixes = cls._schema_address_space_read.address_prefixes

    _schema_application_security_group_read = None

    @classmethod
    def _build_schema_application_security_group_read(cls, _schema):
        if cls._schema_application_security_group_read is not None:
            _schema.etag = cls._schema_application_security_group_read.etag
            _schema.id = cls._schema_application_security_group_read.id
            _schema.location = cls._schema_application_security_group_read.location
            _schema.name = cls._schema_application_security_group_read.name
            _schema.properties = cls._schema_application_security_group_read.properties
            _schema.tags = cls._schema_application_security_group_read.tags
            _schema.type = cls._schema_application_security_group_read.type
            return

        cls._schema_application_security_group_read = _schema_application_security_group_read = AAZObjectType()

        application_security_group_read = _schema_application_security_group_read
        application_security_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.id = AAZStrType()
        application_security_group_read.location = AAZStrType()
        application_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        application_security_group_read.tags = AAZDictType()
        application_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_application_security_group_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        tags = _schema_application_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_application_security_group_read.etag
        _schema.id = cls._schema_application_security_group_read.id
        _schema.location = cls._schema_application_security_group_read.location
        _schema.name = cls._schema_application_security_group_read.name
        _schema.properties = cls._schema_application_security_group_read.properties
        _schema.tags = cls._schema_application_security_group_read.tags
        _schema.type = cls._schema_application_security_group_read.type

    _schema_ip_configuration_read = None

    @classmethod
    def _build_schema_ip_configuration_read(cls, _schema):
        if cls._schema_ip_configuration_read is not None:
            _schema.etag = cls._schema_ip_configuration_read.etag
            _schema.id = cls._schema_ip_configuration_read.id
            _schema.name = cls._schema_ip_configuration_read.name
            _schema.properties = cls._schema_ip_configuration_read.properties
            return

        cls._schema_ip_configuration_read = _schema_ip_configuration_read = AAZObjectType()

        ip_configuration_read = _schema_ip_configuration_read
        ip_configuration_read.etag = AAZStrType()
        ip_configuration_read.id = AAZStrType()
        ip_configuration_read.name = AAZStrType()
        ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_ip_configuration_read.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        _schema.etag = cls._schema_ip_configuration_read.etag
        _schema.id = cls._schema_ip_configuration_read.id
        _schema.name = cls._schema_ip_configuration_read.name
        _schema.properties = cls._schema_ip_configuration_read.properties

    _schema_network_interface_ip_configuration_read = None

    @classmethod
    def _build_schema_network_interface_ip_configuration_read(cls, _schema):
        if cls._schema_network_interface_ip_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
            _schema.id = cls._schema_network_interface_ip_configuration_read.id
            _schema.name = cls._schema_network_interface_ip_configuration_read.name
            _schema.properties = cls._schema_network_interface_ip_configuration_read.properties
            return

        cls._schema_network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read = AAZObjectType()

        network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
        network_interface_ip_configuration_read.etag = AAZStrType()
        network_interface_ip_configuration_read.id = AAZStrType()
        network_interface_ip_configuration_read.name = AAZStrType()
        network_interface_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_rules = AAZListType(
            serialized_name="loadBalancerInboundNatRules",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType()

        properties = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties
        properties.backend_addresses = AAZListType(
            serialized_name="backendAddresses",
        )
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_addresses = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses
        backend_addresses.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses.Element
        _element.fqdn = AAZStrType()
        _element.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_nat_rule = AAZObjectType(
            serialized_name="outboundNatRule",
        )
        cls._build_schema_sub_resource_read(properties.outbound_nat_rule)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        load_balancing_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element.properties
        properties.backend_ip_configuration = AAZObjectType(
            serialized_name="backendIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port = AAZIntType(
            serialized_name="frontendPort",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
        _schema.id = cls._schema_network_interface_ip_configuration_read.id
        _schema.name = cls._schema_network_interface_ip_configuration_read.name
        _schema.properties = cls._schema_network_interface_ip_configuration_read.properties

    _schema_network_security_group_read = None

    @classmethod
    def _build_schema_network_security_group_read(cls, _schema):
        if cls._schema_network_security_group_read is not None:
            _schema.etag = cls._schema_network_security_group_read.etag
            _schema.id = cls._schema_network_security_group_read.id
            _schema.location = cls._schema_network_security_group_read.location
            _schema.name = cls._schema_network_security_group_read.name
            _schema.properties = cls._schema_network_security_group_read.properties
            _schema.tags = cls._schema_network_security_group_read.tags
            _schema.type = cls._schema_network_security_group_read.type
            return

        cls._schema_network_security_group_read = _schema_network_security_group_read = AAZObjectType()

        network_security_group_read = _schema_network_security_group_read
        network_security_group_read.etag = AAZStrType()
        network_security_group_read.id = AAZStrType()
        network_security_group_read.location = AAZStrType()
        network_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_security_group_read.tags = AAZDictType()
        network_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties
        properties.default_security_rules = AAZListType(
            serialized_name="defaultSecurityRules",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.security_rules = AAZListType(
            serialized_name="securityRules",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        default_security_rules = _schema_network_security_group_read.properties.default_security_rules
        default_security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(default_security_rules.Element)

        network_interfaces = _schema_network_security_group_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()

        _element = _schema_network_security_group_read.properties.network_interfaces.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.location = AAZStrType()
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties.network_interfaces.Element.properties
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.mac_address = AAZStrType(
            serialized_name="macAddress",
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.primary = AAZBoolType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.virtual_machine = AAZObjectType(
            serialized_name="virtualMachine",
        )
        cls._build_schema_sub_resource_read(properties.virtual_machine)

        dns_settings = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings
        dns_settings.applied_dns_servers = AAZListType(
            serialized_name="appliedDnsServers",
        )
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )
        dns_settings.internal_dns_name_label = AAZStrType(
            serialized_name="internalDnsNameLabel",
        )
        dns_settings.internal_domain_name_suffix = AAZStrType(
            serialized_name="internalDomainNameSuffix",
        )
        dns_settings.internal_fqdn = AAZStrType(
            serialized_name="internalFqdn",
        )

        applied_dns_servers = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings.applied_dns_servers
        applied_dns_servers.Element = AAZStrType()

        dns_servers = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        ip_configurations = _schema_network_security_group_read.properties.network_interfaces.Element.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

        tags = _schema_network_security_group_read.properties.network_interfaces.Element.tags
        tags.Element = AAZStrType()

        security_rules = _schema_network_security_group_read.properties.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        subnets = _schema_network_security_group_read.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_network_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_security_group_read.etag
        _schema.id = cls._schema_network_security_group_read.id
        _schema.location = cls._schema_network_security_group_read.location
        _schema.name = cls._schema_network_security_group_read.name
        _schema.properties = cls._schema_network_security_group_read.properties
        _schema.tags = cls._schema_network_security_group_read.tags
        _schema.type = cls._schema_network_security_group_read.type

    _schema_public_ip_address_read = None

    @classmethod
    def _build_schema_public_ip_address_read(cls, _schema):
        if cls._schema_public_ip_address_read is not None:
            _schema.etag = cls._schema_public_ip_address_read.etag
            _schema.id = cls._schema_public_ip_address_read.id
            _schema.location = cls._schema_public_ip_address_read.location
            _schema.name = cls._schema_public_ip_address_read.name
            _schema.properties = cls._schema_public_ip_address_read.properties
            _schema.sku = cls._schema_public_ip_address_read.sku
            _schema.tags = cls._schema_public_ip_address_read.tags
            _schema.type = cls._schema_public_ip_address_read.type
            _schema.zones = cls._schema_public_ip_address_read.zones
            return

        cls._schema_public_ip_address_read = _schema_public_ip_address_read = AAZObjectType()

        public_ip_address_read = _schema_public_ip_address_read
        public_ip_address_read.etag = AAZStrType()
        public_ip_address_read.id = AAZStrType()
        public_ip_address_read.location = AAZStrType()
        public_ip_address_read.name = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_read.sku = AAZObjectType()
        public_ip_address_read.tags = AAZDictType()
        public_ip_address_read.type = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.zones = AAZListType()

        properties = _schema_public_ip_address_read.properties
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )
        properties.ip_configuration = AAZObjectType(
            serialized_name="ipConfiguration",
        )
        cls._build_schema_ip_configuration_read(properties.ip_configuration)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_allocation_method = AAZStrType(
            serialized_name="publicIPAllocationMethod",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )

        dns_settings = _schema_public_ip_address_read.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
        )
        dns_settings.fqdn = AAZStrType()
        dns_settings.reverse_fqdn = AAZStrType(
            serialized_name="reverseFqdn",
        )

        sku = _schema_public_ip_address_read.sku
        sku.name = AAZStrType()

        tags = _schema_public_ip_address_read.tags
        tags.Element = AAZStrType()

        zones = _schema_public_ip_address_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_public_ip_address_read.etag
        _schema.id = cls._schema_public_ip_address_read.id
        _schema.location = cls._schema_public_ip_address_read.location
        _schema.name = cls._schema_public_ip_address_read.name
        _schema.properties = cls._schema_public_ip_address_read.properties
        _schema.sku = cls._schema_public_ip_address_read.sku
        _schema.tags = cls._schema_public_ip_address_read.tags
        _schema.type = cls._schema_public_ip_address_read.type
        _schema.zones = cls._schema_public_ip_address_read.zones

    _schema_security_rule_read = None

    @classmethod
    def _build_schema_security_rule_read(cls, _schema):
        if cls._schema_security_rule_read is not None:
            _schema.etag = cls._schema_security_rule_read.etag
            _schema.id = cls._schema_security_rule_read.id
            _schema.name = cls._schema_security_rule_read.name
            _schema.properties = cls._schema_security_rule_read.properties
            return

        cls._schema_security_rule_read = _schema_security_rule_read = AAZObjectType()

        security_rule_read = _schema_security_rule_read
        security_rule_read.etag = AAZStrType()
        security_rule_read.id = AAZStrType()
        security_rule_read.name = AAZStrType()
        security_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_security_rule_read.properties
        properties.access = AAZStrType(
            flags={"required": True},
        )
        properties.description = AAZStrType()
        properties.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
        )
        properties.destination_address_prefixes = AAZListType(
            serialized_name="destinationAddressPrefixes",
        )
        properties.destination_application_security_groups = AAZListType(
            serialized_name="destinationApplicationSecurityGroups",
        )
        properties.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        properties.destination_port_ranges = AAZListType(
            serialized_name="destinationPortRanges",
        )
        properties.direction = AAZStrType(
            flags={"required": True},
        )
        properties.priority = AAZIntType()
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
        )
        properties.source_address_prefixes = AAZListType(
            serialized_name="sourceAddressPrefixes",
        )
        properties.source_application_security_groups = AAZListType(
            serialized_name="sourceApplicationSecurityGroups",
        )
        properties.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )
        properties.source_port_ranges = AAZListType(
            serialized_name="sourcePortRanges",
        )

        destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrType()

        destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(destination_application_security_groups.Element)

        destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
        destination_port_ranges.Element = AAZStrType()

        source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
        source_address_prefixes.Element = AAZStrType()

        source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
        source_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(source_application_security_groups.Element)

        source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
        source_port_ranges.Element = AAZStrType()

        _schema.etag = cls._schema_security_rule_read.etag
        _schema.id = cls._schema_security_rule_read.id
        _schema.name = cls._schema_security_rule_read.name
        _schema.properties = cls._schema_security_rule_read.properties

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_subnet_read = None

    @classmethod
    def _build_schema_subnet_read(cls, _schema):
        if cls._schema_subnet_read is not None:
            _schema.etag = cls._schema_subnet_read.etag
            _schema.id = cls._schema_subnet_read.id
            _schema.name = cls._schema_subnet_read.name
            _schema.properties = cls._schema_subnet_read.properties
            return

        cls._schema_subnet_read = _schema_subnet_read = AAZObjectType()

        subnet_read = _schema_subnet_read
        subnet_read.etag = AAZStrType()
        subnet_read.id = AAZStrType()
        subnet_read.name = AAZStrType()
        subnet_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"read_only": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_navigation_links = AAZListType(
            serialized_name="resourceNavigationLinks",
        )
        properties.route_table = AAZObjectType(
            serialized_name="routeTable",
        )
        properties.service_endpoints = AAZListType(
            serialized_name="serviceEndpoints",
        )

        ip_configurations = _schema_subnet_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_ip_configuration_read(ip_configurations.Element)

        resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
        resource_navigation_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.resource_navigation_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        route_table = _schema_subnet_read.properties.route_table
        route_table.etag = AAZStrType()
        route_table.id = AAZStrType()
        route_table.location = AAZStrType()
        route_table.name = AAZStrType(
            flags={"read_only": True},
        )
        route_table.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        route_table.tags = AAZDictType()
        route_table.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties
        properties.disable_bgp_route_propagation = AAZBoolType(
            serialized_name="disableBgpRoutePropagation",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.routes = AAZListType()
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        routes = _schema_subnet_read.properties.route_table.properties.routes
        routes.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.route_table.properties.routes.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.next_hop_ip_address = AAZStrType(
            serialized_name="nextHopIpAddress",
        )
        properties.next_hop_type = AAZStrType(
            serialized_name="nextHopType",
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        subnets = _schema_subnet_read.properties.route_table.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.route_table.tags
        tags.Element = AAZStrType()

        service_endpoints = _schema_subnet_read.properties.service_endpoints
        service_endpoints.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoints.Element
        _element.locations = AAZListType()
        _element.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        _element.service = AAZStrType()

        locations = _schema_subnet_read.properties.service_endpoints.Element.locations
        locations.Element = AAZStrType()

        _schema.etag = cls._schema_subnet_read.etag
        _schema.id = cls._schema_subnet_read.id
        _schema.name = cls._schema_subnet_read.name
        _schema.properties = cls._schema_subnet_read.properties


__all__ = ["Create"]
