# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "disk create",
)
class Create(AAZCommand):
    """Create a managed disk.

    :example: Create a managed disk by importing from a blob uri.
        az disk create -g MyResourceGroup -n MyDisk --source https://vhd1234.blob.core.windows.net/vhds/osdisk1234.vhd

    :example: Create an empty managed disk.
        az disk create -g MyResourceGroup -n MyDisk --size-gb 10

    :example: Create an empty managed disk with bursting enabled.
        az disk create -g MyResourceGroup -n MyDisk --size-gb 1024 --location centraluseuap --enable-bursting

    :example: Create a managed disk by copying an existing disk or snapshot.
        az disk create -g MyResourceGroup -n MyDisk2 --source MyDisk

    :example: Create a disk in an availability zone in the region of "East US 2".
        az disk create -g MyResourceGroup -n MyDisk --size-gb 10 --location eastus2 --zone 1

    :example: Create a disk from image.
        az disk create -g MyResourceGroup -n MyDisk --image-reference Canonical:0001-com-ubuntu-server-jammy:22_04-lts-gen2:latest

    :example: Create a disk from the OS Disk of a compute gallery image version.
        az disk create -g MyResourceGroup -n MyDisk --gallery-image-reference /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.Compute/galleries/myGallery/images/myImage/versions/1.0.0

    :example: Create a disk from the OS Disk of the latest version in a compute gallery image.
        az disk create -g MyResourceGroup -n MyDisk --gallery-image-reference /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.Compute/galleries/myGallery/images/myImage

    :example: Create a disk from the OS Disk of a shared gallery image version.
        az disk create -g MyResourceGroup -n MyDisk --gallery-image-reference /SharedGalleries/sharedGalleryUniqueName/Images/imageName/Versions/1.0.0

    :example: Create a disk from the OS Disk of a community gallery image version.
        az disk create -g MyResourceGroup -n MyDisk --gallery-image-reference /CommunityGalleries/communityGalleryPublicGalleryName/Images/imageName/Versions/1.0.0

    :example: Create a disk from the Data Disk of a gallery image.
        az disk create -g MyResourceGroup -n MyDisk --gallery-image-reference /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.Compute/galleries/myGallery/images/myImage/versions/1.0.0 --gallery-image-reference-lun 0

    :example: Create a disk with total number of IOPS and total throughput (MBps) limitation.
        az disk create -g MyResourceGroup -n MyDisk --size-gb 10 --sku UltraSSD_LRS --disk-iops-read-only 200 --disk-mbps-read-only 30

    :example: Create a disk and specify maximum number of VMs that can attach to the disk at the same time.
        az disk create -g MyResourceGroup -n MyDisk --size-gb 256 --max-shares 2 -l centraluseuap

    :example: Create a disk and associate it with a disk access resource.
        az disk create -g MyResourceGroup -n MyDisk --size-gb 10 --network-access-policy AllowPrivate --disk-access MyDiskAccessID

    :example: Create a disk from the blob URI for VM guest state VHD.
        az disk create -g MyResourceGroup -n MyDisk --size-gb 10 --security-data-uri GuestStateDiskVhdUri --security-type TrustedLaunch --hyper-v-generation V2

    :example: Create a standard disk for uploading blobs.
        az disk create -g MyResourceGroup -n MyDisk --upload-size-bytes 20972032 --upload-type Upload

    :example: Create an OS disk for uploading along with VM guest state.
        az disk create -g MyResourceGroup -n MyDisk --upload-size-bytes 20972032 --upload-type UploadWithSecurityData --security-type TrustedLaunch --hyper-v-generation V2
    """

    _aaz_info = {
        "version": "2017-03-30",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/disks/{}", "2017-03-30"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.disk_name = AAZStrArg(
            options=["-n", "--name", "--disk-name"],
            help="The name of the managed disk that is being created. The name can't be changed after the disk is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Disk"

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Disk",
            help="Resource location",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.sku = AAZObjectArg(
            options=["--sku"],
            arg_group="Disk",
            help="The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, StandardSSD_ZRS, or PremiumV2_LRS.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Disk",
            help="Resource tags",
        )
        _args_schema.zones = AAZListArg(
            options=["--zones"],
            arg_group="Disk",
            help="The Logical zone list for Disk.",
        )

        sku = cls._args_schema.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="The sku name.",
            enum={"Premium_LRS": "Premium_LRS", "Standard_LRS": "Standard_LRS"},
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        zones = cls._args_schema.zones
        zones.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.creation_data = AAZObjectArg(
            options=["--creation-data"],
            arg_group="Properties",
            help="Disk source information. CreationData information cannot be changed after the disk has been created.",
        )
        _args_schema.disk_size_gb = AAZIntArg(
            options=["--disk-size-gb"],
            arg_group="Properties",
            help="If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.",
        )
        _args_schema.encryption_settings = AAZObjectArg(
            options=["--encryption-settings"],
            arg_group="Properties",
            help="Encryption settings for disk or snapshot",
        )
        _args_schema.os_type = AAZStrArg(
            options=["--os-type"],
            arg_group="Properties",
            help="The Operating System type.",
            enum={"Linux": "Linux", "Windows": "Windows"},
        )

        creation_data = cls._args_schema.creation_data
        creation_data.create_option = AAZStrArg(
            options=["create-option"],
            help="This enumerates the possible sources of a disk's creation.",
            required=True,
            enum={"Attach": "Attach", "Copy": "Copy", "Empty": "Empty", "FromImage": "FromImage", "Import": "Import"},
        )
        creation_data.image_reference = AAZObjectArg(
            options=["image-reference"],
            help="Disk source information for PIR or user images.",
        )
        creation_data.source_resource_id = AAZStrArg(
            options=["source-resource-id"],
            help="If createOption is Copy, this is the ARM id of the source snapshot or disk.",
        )
        creation_data.source_uri = AAZStrArg(
            options=["source-uri"],
            help="If createOption is Import, this is the URI of a blob to be imported into a managed disk.",
        )
        creation_data.storage_account_id = AAZStrArg(
            options=["storage-account-id"],
            help="Required if createOption is Import. The Azure Resource Manager identifier of the storage account containing the blob to import as a disk.",
        )

        image_reference = cls._args_schema.creation_data.image_reference
        image_reference.id = AAZStrArg(
            options=["id"],
            help="A relative uri containing either a Platform Image Repository or user image reference.",
        )
        image_reference.lun = AAZIntArg(
            options=["lun"],
            help="If the disk is created from an image's data disk, this is an index that indicates which of the data disks in the image to use. For OS disks, this field is null.",
        )

        encryption_settings = cls._args_schema.encryption_settings
        encryption_settings.disk_encryption_key = AAZObjectArg(
            options=["disk-encryption-key"],
            help="Key Vault Secret Url and vault id of the disk encryption key",
        )
        encryption_settings.enabled = AAZBoolArg(
            options=["enabled"],
            help="Set this flag to true and provide DiskEncryptionKey and optional KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object, the existing settings remain unchanged.",
        )
        encryption_settings.key_encryption_key = AAZObjectArg(
            options=["key-encryption-key"],
            help="Key Vault Key Url and vault id of the key encryption key",
        )

        disk_encryption_key = cls._args_schema.encryption_settings.disk_encryption_key
        disk_encryption_key.secret_url = AAZStrArg(
            options=["secret-url"],
            help="Url pointing to a key or secret in KeyVault",
            required=True,
        )
        disk_encryption_key.source_vault = AAZObjectArg(
            options=["source-vault"],
            help="Resource id of the KeyVault containing the key or secret",
            required=True,
        )
        cls._build_args_source_vault_create(disk_encryption_key.source_vault)

        key_encryption_key = cls._args_schema.encryption_settings.key_encryption_key
        key_encryption_key.key_url = AAZStrArg(
            options=["key-url"],
            help="Url pointing to a key or secret in KeyVault",
            required=True,
        )
        key_encryption_key.source_vault = AAZObjectArg(
            options=["source-vault"],
            help="Resource id of the KeyVault containing the key or secret",
            required=True,
        )
        cls._build_args_source_vault_create(key_encryption_key.source_vault)
        return cls._args_schema

    _args_source_vault_create = None

    @classmethod
    def _build_args_source_vault_create(cls, _schema):
        if cls._args_source_vault_create is not None:
            _schema.id = cls._args_source_vault_create.id
            return

        cls._args_source_vault_create = AAZObjectArg()

        source_vault_create = cls._args_source_vault_create
        source_vault_create.id = AAZStrArg(
            options=["id"],
            help="Resource Id",
        )

        _schema.id = cls._args_source_vault_create.id

    def _execute_operations(self):
        self.pre_operations()
        yield self.DisksCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class DisksCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/disks/{diskName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "diskName", self.ctx.args.disk_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2017-03-30",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("sku", AAZObjectType, ".sku")
            _builder.set_prop("tags", AAZDictType, ".tags")
            _builder.set_prop("zones", AAZListType, ".zones")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("creationData", AAZObjectType, ".creation_data", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("diskSizeGB", AAZIntType, ".disk_size_gb")
                properties.set_prop("encryptionSettings", AAZObjectType, ".encryption_settings")
                properties.set_prop("osType", AAZStrType, ".os_type")

            creation_data = _builder.get(".properties.creationData")
            if creation_data is not None:
                creation_data.set_prop("createOption", AAZStrType, ".create_option", typ_kwargs={"flags": {"required": True}})
                creation_data.set_prop("imageReference", AAZObjectType, ".image_reference")
                creation_data.set_prop("sourceResourceId", AAZStrType, ".source_resource_id")
                creation_data.set_prop("sourceUri", AAZStrType, ".source_uri")
                creation_data.set_prop("storageAccountId", AAZStrType, ".storage_account_id")

            image_reference = _builder.get(".properties.creationData.imageReference")
            if image_reference is not None:
                image_reference.set_prop("id", AAZStrType, ".id")
                image_reference.set_prop("lun", AAZIntType, ".lun")

            encryption_settings = _builder.get(".properties.encryptionSettings")
            if encryption_settings is not None:
                encryption_settings.set_prop("diskEncryptionKey", AAZObjectType, ".disk_encryption_key")
                encryption_settings.set_prop("enabled", AAZBoolType, ".enabled")
                encryption_settings.set_prop("keyEncryptionKey", AAZObjectType, ".key_encryption_key")

            disk_encryption_key = _builder.get(".properties.encryptionSettings.diskEncryptionKey")
            if disk_encryption_key is not None:
                disk_encryption_key.set_prop("secretUrl", AAZStrType, ".secret_url", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_source_vault_create(disk_encryption_key.set_prop("sourceVault", AAZObjectType, ".source_vault", typ_kwargs={"flags": {"required": True}}))

            key_encryption_key = _builder.get(".properties.encryptionSettings.keyEncryptionKey")
            if key_encryption_key is not None:
                key_encryption_key.set_prop("keyUrl", AAZStrType, ".key_url", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_source_vault_create(key_encryption_key.set_prop("sourceVault", AAZObjectType, ".source_vault", typ_kwargs={"flags": {"required": True}}))

            sku = _builder.get(".sku")
            if sku is not None:
                sku.set_prop("name", AAZStrType, ".name")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            zones = _builder.get(".zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _CreateHelper._build_schema_disk_read(cls._schema_on_200)

            return cls._schema_on_200


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_source_vault_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    _schema_disk_read = None

    @classmethod
    def _build_schema_disk_read(cls, _schema):
        if cls._schema_disk_read is not None:
            _schema.id = cls._schema_disk_read.id
            _schema.location = cls._schema_disk_read.location
            _schema.managed_by = cls._schema_disk_read.managed_by
            _schema.name = cls._schema_disk_read.name
            _schema.properties = cls._schema_disk_read.properties
            _schema.sku = cls._schema_disk_read.sku
            _schema.tags = cls._schema_disk_read.tags
            _schema.type = cls._schema_disk_read.type
            _schema.zones = cls._schema_disk_read.zones
            return

        cls._schema_disk_read = _schema_disk_read = AAZObjectType()

        disk_read = _schema_disk_read
        disk_read.id = AAZStrType(
            flags={"read_only": True},
        )
        disk_read.location = AAZStrType(
            flags={"required": True},
        )
        disk_read.managed_by = AAZStrType(
            serialized_name="managedBy",
            flags={"read_only": True},
        )
        disk_read.name = AAZStrType(
            flags={"read_only": True},
        )
        disk_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        disk_read.sku = AAZObjectType()
        disk_read.tags = AAZDictType()
        disk_read.type = AAZStrType(
            flags={"read_only": True},
        )
        disk_read.zones = AAZListType()

        properties = _schema_disk_read.properties
        properties.creation_data = AAZObjectType(
            serialized_name="creationData",
            flags={"required": True},
        )
        properties.disk_size_gb = AAZIntType(
            serialized_name="diskSizeGB",
        )
        properties.encryption_settings = AAZObjectType(
            serialized_name="encryptionSettings",
        )
        properties.os_type = AAZStrType(
            serialized_name="osType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.time_created = AAZStrType(
            serialized_name="timeCreated",
            flags={"read_only": True},
        )

        creation_data = _schema_disk_read.properties.creation_data
        creation_data.create_option = AAZStrType(
            serialized_name="createOption",
            flags={"required": True},
        )
        creation_data.image_reference = AAZObjectType(
            serialized_name="imageReference",
        )
        creation_data.source_resource_id = AAZStrType(
            serialized_name="sourceResourceId",
        )
        creation_data.source_uri = AAZStrType(
            serialized_name="sourceUri",
        )
        creation_data.storage_account_id = AAZStrType(
            serialized_name="storageAccountId",
        )

        image_reference = _schema_disk_read.properties.creation_data.image_reference
        image_reference.id = AAZStrType()
        image_reference.lun = AAZIntType()

        encryption_settings = _schema_disk_read.properties.encryption_settings
        encryption_settings.disk_encryption_key = AAZObjectType(
            serialized_name="diskEncryptionKey",
        )
        encryption_settings.enabled = AAZBoolType()
        encryption_settings.key_encryption_key = AAZObjectType(
            serialized_name="keyEncryptionKey",
        )

        disk_encryption_key = _schema_disk_read.properties.encryption_settings.disk_encryption_key
        disk_encryption_key.secret_url = AAZStrType(
            serialized_name="secretUrl",
            flags={"required": True},
        )
        disk_encryption_key.source_vault = AAZObjectType(
            serialized_name="sourceVault",
            flags={"required": True},
        )
        cls._build_schema_source_vault_read(disk_encryption_key.source_vault)

        key_encryption_key = _schema_disk_read.properties.encryption_settings.key_encryption_key
        key_encryption_key.key_url = AAZStrType(
            serialized_name="keyUrl",
            flags={"required": True},
        )
        key_encryption_key.source_vault = AAZObjectType(
            serialized_name="sourceVault",
            flags={"required": True},
        )
        cls._build_schema_source_vault_read(key_encryption_key.source_vault)

        sku = _schema_disk_read.sku
        sku.name = AAZStrType()
        sku.tier = AAZStrType(
            flags={"read_only": True},
        )

        tags = _schema_disk_read.tags
        tags.Element = AAZStrType()

        zones = _schema_disk_read.zones
        zones.Element = AAZStrType()

        _schema.id = cls._schema_disk_read.id
        _schema.location = cls._schema_disk_read.location
        _schema.managed_by = cls._schema_disk_read.managed_by
        _schema.name = cls._schema_disk_read.name
        _schema.properties = cls._schema_disk_read.properties
        _schema.sku = cls._schema_disk_read.sku
        _schema.tags = cls._schema_disk_read.tags
        _schema.type = cls._schema_disk_read.type
        _schema.zones = cls._schema_disk_read.zones

    _schema_source_vault_read = None

    @classmethod
    def _build_schema_source_vault_read(cls, _schema):
        if cls._schema_source_vault_read is not None:
            _schema.id = cls._schema_source_vault_read.id
            return

        cls._schema_source_vault_read = _schema_source_vault_read = AAZObjectType()

        source_vault_read = _schema_source_vault_read
        source_vault_read.id = AAZStrType()

        _schema.id = cls._schema_source_vault_read.id


__all__ = ["Create"]
