/***************************************************************************//**
 *   @file   TxAttenTable.h
 *   @brief  adrv9002 TX attenuation table.
 *   @author Darius Berghe (darius.berghe@analog.com)
********************************************************************************
 * Copyright 2020(c) Analog Devices, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. Neither the name of Analog Devices, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. “AS IS” AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL ANALOG DEVICES, INC. BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/
#ifndef TX_ATTEN_TABLE_H
#define TX_ATTEN_TABLE_H

#include <stdint.h>

struct TxAttenTableEntry {
	uint16_t attenIndex;
	uint8_t txAttenHp;
	uint16_t txAttenMult;
};

struct TxAttenTableEntry TxAttenTable[] = {
	{0, 0, 4095},
	{1, 0, 4072},
	{2, 0, 4049},
	{3, 1, 4090},
	{4, 1, 4066},
	{5, 1, 4043},
	{6, 2, 4085},
	{7, 2, 4061},
	{8, 2, 4038},
	{9, 3, 4080},
	{10, 3, 4057},
	{11, 3, 4034},
	{12, 4, 4077},
	{13, 4, 4054},
	{14, 4, 4031},
	{15, 5, 4076},
	{16, 5, 4052},
	{17, 5, 4029},
	{18, 6, 4075},
	{19, 6, 4051},
	{20, 6, 4028},
	{21, 7, 4075},
	{22, 7, 4052},
	{23, 7, 4029},
	{24, 8, 4077},
	{25, 8, 4054},
	{26, 8, 4030},
	{27, 9, 4080},
	{28, 9, 4057},
	{29, 9, 4033},
	{30, 10, 4085},
	{31, 10, 4061},
	{32, 10, 4038},
	{33, 11, 4090},
	{34, 11, 4067},
	{35, 11, 4044},
	{36, 11, 4020},
	{37, 12, 4074},
	{38, 12, 4051},
	{39, 12, 4028},
	{40, 13, 4083},
	{41, 13, 4059},
	{42, 13, 4036},
	{43, 14, 4093},
	{44, 14, 4070},
	{45, 14, 4046},
	{46, 14, 4023},
	{47, 15, 4082},
	{48, 15, 4058},
	{49, 15, 4035},
	{50, 16, 4095},
	{51, 16, 4072},
	{52, 16, 4049},
	{53, 16, 4025},
	{54, 17, 4087},
	{55, 17, 4064},
	{56, 17, 4041},
	{57, 17, 4017},
	{58, 18, 4081},
	{59, 18, 4058},
	{60, 18, 4034},
	{61, 18, 4011},
	{62, 19, 4077},
	{63, 19, 4053},
	{64, 19, 4030},
	{65, 19, 4007},
	{66, 20, 4075},
	{67, 20, 4051},
	{68, 20, 4028},
	{69, 20, 4005},
	{70, 21, 4074},
	{71, 21, 4051},
	{72, 21, 4028},
	{73, 21, 4005},
	{74, 22, 4077},
	{75, 22, 4053},
	{76, 22, 4030},
	{77, 22, 4007},
	{78, 23, 4081},
	{79, 23, 4057},
	{80, 23, 4034},
	{81, 23, 4011},
	{82, 24, 4088},
	{83, 24, 4064},
	{84, 24, 4041},
	{85, 24, 4018},
	{86, 24, 3995},
	{87, 25, 4074},
	{88, 25, 4050},
	{89, 25, 4027},
	{90, 25, 4004},
	{91, 26, 4086},
	{92, 26, 4062},
	{93, 26, 4039},
	{94, 26, 4016},
	{95, 26, 3993},
	{96, 27, 4077},
	{97, 27, 4054},
	{98, 27, 4030},
	{99, 27, 4007},
	{100, 28, 4095},
	{101, 28, 4071},
	{102, 28, 4048},
	{103, 28, 4025},
	{104, 28, 4002},
	{105, 29, 4092},
	{106, 29, 4069},
	{107, 29, 4045},
	{108, 29, 4022},
	{109, 29, 3999},
	{110, 30, 4093},
	{111, 30, 4070},
	{112, 30, 4046},
	{113, 30, 4023},
	{114, 30, 4000},
	{115, 30, 3977},
	{116, 31, 4074},
	{117, 31, 4051},
	{118, 31, 4027},
	{119, 31, 4004},
	{120, 31, 3981},
	{121, 32, 4082},
	{122, 32, 4059},
	{123, 32, 4035},
	{124, 32, 4012},
	{125, 32, 3989},
	{126, 33, 4094},
	{127, 33, 4071},
	{128, 33, 4047},
	{129, 33, 4024},
	{130, 33, 4001},
	{131, 33, 3978},
	{132, 34, 4087},
	{133, 34, 4064},
	{134, 34, 4040},
	{135, 34, 4017},
	{136, 34, 3994},
	{137, 34, 3971},
	{138, 35, 4085},
	{139, 35, 4061},
	{140, 35, 4038},
	{141, 35, 4015},
	{142, 35, 3992},
	{143, 35, 3969},
	{144, 36, 4087},
	{145, 36, 4063},
	{146, 36, 4040},
	{147, 36, 4017},
	{148, 36, 3994},
	{149, 36, 3971},
	{150, 37, 4094},
	{151, 37, 4071},
	{152, 37, 4047},
	{153, 37, 4024},
	{154, 37, 4001},
	{155, 37, 3978},
	{156, 37, 3955},
	{157, 38, 4084},
	{158, 38, 4060},
	{159, 38, 4037},
	{160, 38, 4014},
	{161, 38, 3991},
	{162, 38, 3968},
	{163, 38, 3945},
	{164, 39, 4079},
	{165, 39, 4056},
	{166, 39, 4033},
	{167, 39, 4010},
	{168, 39, 3987},
	{169, 39, 3964},
	{170, 39, 3941},
	{171, 40, 4082},
	{172, 40, 4058},
	{173, 40, 4035},
	{174, 40, 4012},
	{175, 40, 3989},
	{176, 40, 3966},
	{177, 40, 3943},
	{178, 41, 4091},
	{179, 41, 4067},
	{180, 41, 4044},
	{181, 41, 4021},
	{182, 41, 3998},
	{183, 41, 3975},
	{184, 41, 3952},
	{185, 41, 3929},
	{186, 42, 4084},
	{187, 42, 4061},
	{188, 42, 4038},
	{189, 42, 4014},
	{190, 42, 3991},
	{191, 42, 3968},
	{192, 42, 3946},
	{193, 42, 3923},
	{194, 43, 4086},
	{195, 43, 4063},
	{196, 43, 4039},
	{197, 43, 4016},
	{198, 43, 3993},
	{199, 43, 3970},
	{200, 43, 3947},
	{201, 43, 3925},
	{202, 43, 3902},
	{203, 44, 4074},
	{204, 44, 4051},
	{205, 44, 4027},
	{206, 44, 4004},
	{207, 44, 3981},
	{208, 44, 3958},
	{209, 44, 3936},
	{210, 44, 3913},
	{211, 45, 4095},
	{212, 45, 4072},
	{213, 45, 4048},
	{214, 45, 4025},
	{215, 45, 4002},
	{216, 45, 3979},
	{217, 45, 3956},
	{218, 45, 3934},
	{219, 45, 3911},
	{220, 45, 3889},
	{221, 46, 4081},
	{222, 46, 4058},
	{223, 46, 4034},
	{224, 46, 4011},
	{225, 46, 3988},
	{226, 46, 3965},
	{227, 46, 3942},
	{228, 46, 3920},
	{229, 46, 3897},
	{230, 46, 3875},
	{231, 47, 4079},
	{232, 47, 4056},
	{233, 47, 4033},
	{234, 47, 4010},
	{235, 47, 3986},
	{236, 47, 3964},
	{237, 47, 3941},
	{238, 47, 3918},
	{239, 47, 3896},
	{240, 47, 3873},
	{241, 48, 4092},
	{242, 48, 4068},
	{243, 48, 4045},
	{244, 48, 4022},
	{245, 48, 3999},
	{246, 48, 3976},
	{247, 48, 3953},
	{248, 48, 3930},
	{249, 48, 3908},
	{250, 48, 3885},
	{251, 48, 3863},
	{252, 48, 3841},
	{253, 49, 4073},
	{254, 49, 4050},
	{255, 49, 4027},
	{256, 49, 4004},
	{257, 49, 3981},
	{258, 49, 3958},
	{259, 49, 3935},
	{260, 49, 3912},
	{261, 49, 3890},
	{262, 49, 3868},
	{263, 49, 3845},
	{264, 49, 3823},
	{265, 50, 4073},
	{266, 50, 4050},
	{267, 50, 4026},
	{268, 50, 4003},
	{269, 50, 3980},
	{270, 50, 3957},
	{271, 50, 3935},
	{272, 50, 3912},
	{273, 50, 3890},
	{274, 50, 3867},
	{275, 50, 3845},
	{276, 50, 3823},
	{277, 51, 4094},
	{278, 51, 4070},
	{279, 51, 4047},
	{280, 51, 4023},
	{281, 51, 4000},
	{282, 51, 3977},
	{283, 51, 3955},
	{284, 51, 3932},
	{285, 51, 3909},
	{286, 51, 3887},
	{287, 51, 3865},
	{288, 51, 3842},
	{289, 51, 3820},
	{290, 51, 3798},
	{291, 52, 4091},
	{292, 52, 4068},
	{293, 52, 4044},
	{294, 52, 4021},
	{295, 52, 3998},
	{296, 52, 3975},
	{297, 52, 3952},
	{298, 52, 3930},
	{299, 52, 3907},
	{300, 52, 3885},
	{301, 52, 3862},
	{302, 52, 3840},
	{303, 52, 3818},
	{304, 52, 3796},
	{305, 52, 3774},
	{306, 53, 4094},
	{307, 53, 4070},
	{308, 53, 4047},
	{309, 53, 4024},
	{310, 53, 4001},
	{311, 53, 3978},
	{312, 53, 3955},
	{313, 53, 3932},
	{314, 53, 3910},
	{315, 53, 3887},
	{316, 53, 3865},
	{317, 53, 3843},
	{318, 53, 3821},
	{319, 53, 3799},
	{320, 53, 3777},
	{321, 53, 3755},
	{322, 53, 3734},
	{323, 54, 4084},
	{324, 54, 4060},
	{325, 54, 4037},
	{326, 54, 4014},
	{327, 54, 3991},
	{328, 54, 3968},
	{329, 54, 3945},
	{330, 54, 3922},
	{331, 54, 3900},
	{332, 54, 3877},
	{333, 54, 3855},
	{334, 54, 3833},
	{335, 54, 3811},
	{336, 54, 3789},
	{337, 54, 3767},
	{338, 54, 3746},
	{339, 54, 3724},
	{340, 54, 3703},
	{341, 55, 4091},
	{342, 55, 4067},
	{343, 55, 4044},
	{344, 55, 4021},
	{345, 55, 3998},
	{346, 55, 3975},
	{347, 55, 3952},
	{348, 55, 3929},
	{349, 55, 3907},
	{350, 55, 3884},
	{351, 55, 3862},
	{352, 55, 3840},
	{353, 55, 3818},
	{354, 55, 3796},
	{355, 55, 3774},
	{356, 55, 3752},
	{357, 55, 3731},
	{358, 55, 3709},
	{359, 55, 3688},
	{360, 55, 3667},
	{361, 55, 3646},
	{362, 56, 4078},
	{363, 56, 4055},
	{364, 56, 4031},
	{365, 56, 4008},
	{366, 56, 3985},
	{367, 56, 3962},
	{368, 56, 3940},
	{369, 56, 3917},
	{370, 56, 3894},
	{371, 56, 3872},
	{372, 56, 3850},
	{373, 56, 3828},
	{374, 56, 3806},
	{375, 56, 3784},
	{376, 56, 3762},
	{377, 56, 3741},
	{378, 56, 3719},
	{379, 56, 3698},
	{380, 56, 3677},
	{381, 56, 3656},
	{382, 56, 3635},
	{383, 56, 3614},
	{384, 56, 3593},
	{385, 57, 4083},
	{386, 57, 4059},
	{387, 57, 4036},
	{388, 57, 4013},
	{389, 57, 3990},
	{390, 57, 3967},
	{391, 57, 3944},
	{392, 57, 3921},
	{393, 57, 3899},
	{394, 57, 3877},
	{395, 57, 3854},
	{396, 57, 3832},
	{397, 57, 3810},
	{398, 57, 3788},
	{399, 57, 3767},
	{400, 57, 3745},
	{401, 57, 3723},
	{402, 57, 3702},
	{403, 57, 3681},
	{404, 57, 3660},
	{405, 57, 3639},
	{406, 57, 3618},
	{407, 57, 3597},
	{408, 57, 3576},
	{409, 57, 3556},
	{410, 57, 3535},
	{411, 57, 3515},
	{412, 58, 4077},
	{413, 58, 4054},
	{414, 58, 4031},
	{415, 58, 4008},
	{416, 58, 3985},
	{417, 58, 3962},
	{418, 58, 3939},
	{419, 58, 3916},
	{420, 58, 3894},
	{421, 58, 3872},
	{422, 58, 3849},
	{423, 58, 3827},
	{424, 58, 3805},
	{425, 58, 3783},
	{426, 58, 3762},
	{427, 58, 3740},
	{428, 58, 3719},
	{429, 58, 3697},
	{430, 58, 3676},
	{431, 58, 3655},
	{432, 58, 3634},
	{433, 58, 3613},
	{434, 58, 3592},
	{435, 58, 3572},
	{436, 58, 3551},
	{437, 58, 3531},
	{438, 58, 3511},
	{439, 58, 3491},
	{440, 58, 3470},
	{441, 58, 3451},
	{442, 58, 3431},
	{443, 59, 4093},
	{444, 59, 4070},
	{445, 59, 4046},
	{446, 59, 4023},
	{447, 59, 4000},
	{448, 59, 3977},
	{449, 59, 3954},
	{450, 59, 3932},
	{451, 59, 3909},
	{452, 59, 3887},
	{453, 59, 3864},
	{454, 59, 3842},
	{455, 59, 3820},
	{456, 59, 3798},
	{457, 59, 3776},
	{458, 59, 3755},
	{459, 59, 3733},
	{460, 59, 3712},
	{461, 59, 3690},
	{462, 59, 3669},
	{463, 59, 3648},
	{464, 59, 3627},
	{465, 59, 3606},
	{466, 59, 3586},
	{467, 59, 3565},
	{468, 59, 3545},
	{469, 59, 3524},
	{470, 59, 3504},
	{471, 59, 3484},
	{472, 59, 3464},
	{473, 59, 3444},
	{474, 59, 3424},
	{475, 59, 3405},
	{476, 59, 3385},
	{477, 59, 3366},
	{478, 59, 3346},
	{479, 59, 3327},
	{480, 59, 3308},
	{481, 59, 3289},
	{482, 60, 4088},
	{483, 60, 4064},
	{484, 60, 4041},
	{485, 60, 4018},
	{486, 60, 3995},
	{487, 60, 3972},
	{488, 60, 3949},
	{489, 60, 3926},
	{490, 60, 3904},
	{491, 60, 3881},
	{492, 60, 3859},
	{493, 60, 3837},
	{494, 60, 3815},
	{495, 60, 3793},
	{496, 60, 3771},
	{497, 60, 3750},
	{498, 60, 3728},
	{499, 60, 3707},
	{500, 60, 3685},
	{501, 60, 3664},
	{502, 60, 3643},
	{503, 60, 3622},
	{504, 60, 3601},
	{505, 60, 3581},
	{506, 60, 3560},
	{507, 60, 3540},
	{508, 60, 3519},
	{509, 60, 3499},
	{510, 60, 3479},
	{511, 60, 3459},
	{512, 60, 3439},
	{513, 60, 3420},
	{514, 60, 3400},
	{515, 60, 3380},
	{516, 60, 3361},
	{517, 60, 3342},
	{518, 60, 3323},
	{519, 60, 3304},
	{520, 60, 3285},
	{521, 60, 3266},
	{522, 60, 3247},
	{523, 60, 3228},
	{524, 60, 3210},
	{525, 60, 3191},
	{526, 60, 3173},
	{527, 60, 3155},
	{528, 60, 3137},
	{529, 60, 3119},
	{530, 60, 3101},
	{531, 60, 3083},
	{532, 61, 4087},
	{533, 61, 4064},
	{534, 61, 4040},
	{535, 61, 4017},
	{536, 61, 3994},
	{537, 61, 3971},
	{538, 61, 3948},
	{539, 61, 3926},
	{540, 61, 3903},
	{541, 61, 3881},
	{542, 61, 3859},
	{543, 61, 3836},
	{544, 61, 3814},
	{545, 61, 3792},
	{546, 61, 3771},
	{547, 61, 3749},
	{548, 61, 3728},
	{549, 61, 3706},
	{550, 61, 3685},
	{551, 61, 3664},
	{552, 61, 3643},
	{553, 61, 3622},
	{554, 61, 3601},
	{555, 61, 3580},
	{556, 61, 3560},
	{557, 61, 3539},
	{558, 61, 3519},
	{559, 61, 3499},
	{560, 61, 3479},
	{561, 61, 3459},
	{562, 61, 3439},
	{563, 61, 3419},
	{564, 61, 3400},
	{565, 61, 3380},
	{566, 61, 3361},
	{567, 61, 3341},
	{568, 61, 3322},
	{569, 61, 3303},
	{570, 61, 3284},
	{571, 61, 3265},
	{572, 61, 3247},
	{573, 61, 3228},
	{574, 61, 3209},
	{575, 61, 3191},
	{576, 61, 3173},
	{577, 61, 3154},
	{578, 61, 3136},
	{579, 61, 3118},
	{580, 61, 3100},
	{581, 61, 3083},
	{582, 61, 3065},
	{583, 61, 3047},
	{584, 61, 3030},
	{585, 61, 3012},
	{586, 61, 2995},
	{587, 61, 2978},
	{588, 61, 2961},
	{589, 61, 2944},
	{590, 61, 2927},
	{591, 61, 2910},
	{592, 61, 2893},
	{593, 61, 2877},
	{594, 61, 2860},
	{595, 61, 2844},
	{596, 61, 2828},
	{597, 61, 2811},
	{598, 61, 2795},
	{599, 61, 2779},
	{600, 61, 2763},
	{601, 61, 2747},
	{602, 61, 2732},
	{603, 62, 4074},
	{604, 62, 4051},
	{605, 62, 4027},
	{606, 62, 4004},
	{607, 62, 3981},
	{608, 62, 3958},
	{609, 62, 3936},
	{610, 62, 3913},
	{611, 62, 3891},
	{612, 62, 3868},
	{613, 62, 3846},
	{614, 62, 3824},
	{615, 62, 3802},
	{616, 62, 3780},
	{617, 62, 3758},
	{618, 62, 3737},
	{619, 62, 3715},
	{620, 62, 3694},
	{621, 62, 3673},
	{622, 62, 3652},
	{623, 62, 3631},
	{624, 62, 3610},
	{625, 62, 3589},
	{626, 62, 3569},
	{627, 62, 3548},
	{628, 62, 3528},
	{629, 62, 3508},
	{630, 62, 3487},
	{631, 62, 3467},
	{632, 62, 3448},
	{633, 62, 3428},
	{634, 62, 3408},
	{635, 62, 3389},
	{636, 62, 3369},
	{637, 62, 3350},
	{638, 62, 3331},
	{639, 62, 3311},
	{640, 62, 3292},
	{641, 62, 3273},
	{642, 62, 3255},
	{643, 62, 3236},
	{644, 62, 3217},
	{645, 62, 3199},
	{646, 62, 3181},
	{647, 62, 3162},
	{648, 62, 3144},
	{649, 62, 3126},
	{650, 62, 3108},
	{651, 62, 3090},
	{652, 62, 3073},
	{653, 62, 3055},
	{654, 62, 3037},
	{655, 62, 3020},
	{656, 62, 3003},
	{657, 62, 2985},
	{658, 62, 2968},
	{659, 62, 2951},
	{660, 62, 2934},
	{661, 62, 2917},
	{662, 62, 2901},
	{663, 62, 2884},
	{664, 62, 2868},
	{665, 62, 2851},
	{666, 62, 2835},
	{667, 62, 2818},
	{668, 62, 2802},
	{669, 62, 2786},
	{670, 62, 2770},
	{671, 62, 2754},
	{672, 62, 2738},
	{673, 62, 2723},
	{674, 62, 2707},
	{675, 62, 2692},
	{676, 62, 2676},
	{677, 62, 2661},
	{678, 62, 2646},
	{679, 62, 2630},
	{680, 62, 2615},
	{681, 62, 2600},
	{682, 62, 2585},
	{683, 62, 2570},
	{684, 62, 2556},
	{685, 62, 2541},
	{686, 62, 2526},
	{687, 62, 2512},
	{688, 62, 2498},
	{689, 62, 2483},
	{690, 62, 2469},
	{691, 62, 2455},
	{692, 62, 2441},
	{693, 62, 2427},
	{694, 62, 2413},
	{695, 62, 2399},
	{696, 62, 2385},
	{697, 62, 2371},
	{698, 62, 2358},
	{699, 62, 2344},
	{700, 62, 2331},
	{701, 62, 2317},
	{702, 62, 2304},
	{703, 62, 2291},
	{704, 62, 2278},
	{705, 62, 2265},
	{706, 62, 2252},
	{707, 62, 2239},
	{708, 62, 2226},
	{709, 62, 2213},
	{710, 62, 2200},
	{711, 62, 2188},
	{712, 62, 2175},
	{713, 62, 2163},
	{714, 62, 2150},
	{715, 62, 2138},
	{716, 62, 2126},
	{717, 62, 2114},
	{718, 62, 2101},
	{719, 62, 2089},
	{720, 62, 2077},
	{721, 62, 2065},
	{722, 62, 2054},
	{723, 63, 4084},
	{724, 63, 4060},
	{725, 63, 4037},
	{726, 63, 4014},
	{727, 63, 3991},
	{728, 63, 3968},
	{729, 63, 3945},
	{730, 63, 3922},
	{731, 63, 3900},
	{732, 63, 3877},
	{733, 63, 3855},
	{734, 63, 3833},
	{735, 63, 3811},
	{736, 63, 3789},
	{737, 63, 3767},
	{738, 63, 3746},
	{739, 63, 3724},
	{740, 63, 3703},
	{741, 63, 3682},
	{742, 63, 3660},
	{743, 63, 3639},
	{744, 63, 3619},
	{745, 63, 3598},
	{746, 63, 3577},
	{747, 63, 3557},
	{748, 63, 3536},
	{749, 63, 3516},
	{750, 63, 3496},
	{751, 63, 3476},
	{752, 63, 3456},
	{753, 63, 3436},
	{754, 63, 3416},
	{755, 63, 3397},
	{756, 63, 3377},
	{757, 63, 3358},
	{758, 63, 3338},
	{759, 63, 3319},
	{760, 63, 3300},
	{761, 63, 3281},
	{762, 63, 3262},
	{763, 63, 3244},
	{764, 63, 3225},
	{765, 63, 3207},
	{766, 63, 3188},
	{767, 63, 3170},
	{768, 63, 3152},
	{769, 63, 3134},
	{770, 63, 3116},
	{771, 63, 3098},
	{772, 63, 3080},
	{773, 63, 3062},
	{774, 63, 3045},
	{775, 63, 3027},
	{776, 63, 3010},
	{777, 63, 2993},
	{778, 63, 2975},
	{779, 63, 2958},
	{780, 63, 2941},
	{781, 63, 2924},
	{782, 63, 2908},
	{783, 63, 2891},
	{784, 63, 2874},
	{785, 63, 2858},
	{786, 63, 2841},
	{787, 63, 2825},
	{788, 63, 2809},
	{789, 63, 2793},
	{790, 63, 2777},
	{791, 63, 2761},
	{792, 63, 2745},
	{793, 63, 2729},
	{794, 63, 2714},
	{795, 63, 2698},
	{796, 63, 2683},
	{797, 63, 2667},
	{798, 63, 2652},
	{799, 63, 2637},
	{800, 63, 2621},
	{801, 63, 2606},
	{802, 63, 2591},
	{803, 63, 2577},
	{804, 63, 2562},
	{805, 63, 2547},
	{806, 63, 2532},
	{807, 63, 2518},
	{808, 63, 2503},
	{809, 63, 2489},
	{810, 63, 2475},
	{811, 63, 2461},
	{812, 63, 2446},
	{813, 63, 2432},
	{814, 63, 2418},
	{815, 63, 2405},
	{816, 63, 2391},
	{817, 63, 2377},
	{818, 63, 2363},
	{819, 63, 2350},
	{820, 63, 2336},
	{821, 63, 2323},
	{822, 63, 2310},
	{823, 63, 2296},
	{824, 63, 2283},
	{825, 63, 2270},
	{826, 63, 2257},
	{827, 63, 2244},
	{828, 63, 2231},
	{829, 63, 2218},
	{830, 63, 2206},
	{831, 63, 2193},
	{832, 63, 2180},
	{833, 63, 2168},
	{834, 63, 2155},
	{835, 63, 2143},
	{836, 63, 2131},
	{837, 63, 2119},
	{838, 63, 2106},
	{839, 63, 2094},
	{840, 0, 4095},
	{841, 0, 4074},
	{842, 0, 4051},
	{843, 0, 4027},
	{844, 0, 4004},
	{845, 0, 3981},
	{846, 0, 3958},
	{847, 0, 3936},
	{848, 0, 3913},
	{849, 0, 3891},
	{850, 0, 3868},
	{851, 0, 3846},
	{852, 0, 3824},
	{853, 0, 3802},
	{854, 0, 3780},
	{855, 0, 3758},
	{856, 0, 3737},
	{857, 0, 3715},
	{858, 0, 3694},
	{859, 0, 3673},
	{860, 0, 3652},
	{861, 0, 3631},
	{862, 0, 3610},
	{863, 0, 3589},
	{864, 0, 3569},
	{865, 0, 3548},
	{866, 0, 3528},
	{867, 0, 3508},
	{868, 0, 3487},
	{869, 0, 3467},
	{870, 0, 3448},
	{871, 0, 3428},
	{872, 0, 3408},
	{873, 0, 3389},
	{874, 0, 3369},
	{875, 0, 3350},
	{876, 0, 3331},
	{877, 0, 3311},
	{878, 0, 3292},
	{879, 0, 3273},
	{880, 0, 3255},
	{881, 0, 3236},
	{882, 0, 3217},
	{883, 0, 3199},
	{884, 0, 3181},
	{885, 0, 3162},
	{886, 0, 3144},
	{887, 0, 3126},
	{888, 0, 3108},
	{889, 0, 3090},
	{890, 0, 3073},
	{891, 0, 3055},
	{892, 0, 3037},
	{893, 0, 3020},
	{894, 0, 3003},
	{895, 0, 2985},
	{896, 0, 2968},
	{897, 0, 2951},
	{898, 0, 2934},
	{899, 0, 2917},
	{900, 0, 2901},
	{901, 0, 2884},
	{902, 0, 2868},
	{903, 0, 2851},
	{904, 0, 2835},
	{905, 0, 2818},
	{906, 0, 2802},
	{907, 0, 2786},
	{908, 0, 2770},
	{909, 0, 2754},
	{910, 0, 2738},
	{911, 0, 2723},
	{912, 0, 2707},
	{913, 0, 2692},
	{914, 0, 2676},
	{915, 0, 2661},
	{916, 0, 2646},
	{917, 0, 2630},
	{918, 0, 2615},
	{919, 0, 2600},
	{920, 0, 2585},
	{921, 0, 2570},
	{922, 0, 2556},
	{923, 0, 2541},
	{924, 0, 2526},
	{925, 0, 2512},
	{926, 0, 2498},
	{927, 0, 2483},
	{928, 0, 2469},
	{929, 0, 2455},
	{930, 0, 2441},
	{931, 0, 2427},
	{932, 0, 2413},
	{933, 0, 2399},
	{934, 0, 2385},
	{935, 0, 2371},
	{936, 0, 2358},
	{937, 0, 2344},
	{938, 0, 2331},
	{939, 0, 2317},
	{940, 0, 2304},
	{941, 0, 2291},
	{942, 0, 2278},
	{943, 0, 2265},
	{944, 0, 2252},
	{945, 0, 2239},
	{946, 0, 2226},
	{947, 0, 2213},
	{948, 0, 2200},
	{949, 0, 2188},
	{950, 0, 2175},
	{951, 0, 2163},
	{952, 0, 2150},
	{953, 0, 2138},
	{954, 0, 2126},
	{955, 0, 2114},
	{956, 0, 2101},
	{957, 0, 2089},
	{958, 0, 2077},
	{959, 0, 2065},
};

#endif
