/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.Arrays;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.EqualityMatcher;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.TimeValue;

public class SimpleTypeComparison
implements EqualityMatcher<AtomicSequence> {
    private static final SimpleTypeComparison INSTANCE = new SimpleTypeComparison();

    public static SimpleTypeComparison getInstance() {
        return INSTANCE;
    }

    public int compareSequences(AtomicSequence a1, AtomicSequence a2) {
        AtomicValue item2;
        AtomicValue item1;
        int c;
        if (a1.getLength() == 1 && a2.getLength() == 1) {
            return this.compareItems(a1.itemAt(0), a2.itemAt(0));
        }
        AtomicIterator iter1 = a1.iterate();
        AtomicIterator iter2 = a2.iterate();
        do {
            item1 = iter1.next();
            item2 = iter2.next();
            if (item1 == null && item2 == null) {
                return 0;
            }
            if (item1 == null) {
                return -1;
            }
            if (item2 != null) continue;
            return 1;
        } while ((c = this.compareItems(item1, item2)) == 0);
        return c;
    }

    public int compareItems(AtomicValue a1, AtomicValue a2) {
        int c2;
        int c1 = a1.getItemType().getBasicAlphaCode().charAt(1);
        if (c1 == 90) {
            c1 = 83;
        }
        if ((c2 = a2.getItemType().getBasicAlphaCode().charAt(1)) == 90) {
            c2 = 83;
        }
        if (c1 != c2) {
            return Integer.MIN_VALUE;
        }
        switch (c1) {
            case 83: 
            case 90: {
                return CodepointCollator.getInstance().compareStrings(a1.getUnicodeStringValue(), a2.getUnicodeStringValue());
            }
            case 66: {
                return a1.equals(a2) ? 0 : Integer.MIN_VALUE;
            }
            case 82: {
                DurationValue dur1 = (DurationValue)a1;
                DurationValue dur2 = (DurationValue)a2;
                return dur1.getSchemaComparable().compareTo(dur2.getSchemaComparable());
            }
            case 77: {
                DateTimeValue dt1 = (DateTimeValue)a1;
                DateTimeValue dt2 = (DateTimeValue)a2;
                return dt1.getSchemaComparable().compareTo(dt2.getSchemaComparable());
            }
            case 65: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                GDateValue gd1 = (GDateValue)a1;
                GDateValue gd2 = (GDateValue)a2;
                return gd1.getSchemaComparable().compareTo(gd2.getSchemaComparable());
            }
            case 84: {
                TimeValue t1 = (TimeValue)a1;
                TimeValue t2 = (TimeValue)a2;
                return t1.getSchemaComparable().compareTo(t2.getSchemaComparable());
            }
            case 88: {
                HexBinaryValue h1 = (HexBinaryValue)a1;
                HexBinaryValue h2 = (HexBinaryValue)a2;
                return Arrays.equals(h1.getBinaryValue(), h2.getBinaryValue()) ? 0 : Integer.MIN_VALUE;
            }
            case 50: {
                Base64BinaryValue x1 = (Base64BinaryValue)a1;
                Base64BinaryValue x2 = (Base64BinaryValue)a2;
                return Arrays.equals(x1.getBinaryValue(), x2.getBinaryValue()) ? 0 : Integer.MIN_VALUE;
            }
            case 85: {
                return a1.equals(a2) ? 0 : Integer.MIN_VALUE;
            }
            case 81: {
                return a1.equals(a2) ? 0 : Integer.MIN_VALUE;
            }
            case 78: {
                return a1.equals(a2) ? 0 : Integer.MIN_VALUE;
            }
            case 68: {
                if (a1 instanceof Int64Value && a2 instanceof Int64Value) {
                    return Long.compare(((Int64Value)a1).longValue(), ((Int64Value)a2).longValue());
                }
                return ((DecimalValue)a1).getDecimalValue().compareTo(((DecimalValue)a2).getDecimalValue());
            }
            case 70: {
                float f1 = ((FloatValue)a1).getFloatValue();
                float f2 = ((FloatValue)a2).getFloatValue();
                if (f1 == f2) {
                    return 0;
                }
                return f1 < f2 ? -1 : 1;
            }
            case 79: {
                double d1 = ((DoubleValue)a1).getDoubleValue();
                double d2 = ((DoubleValue)a2).getDoubleValue();
                if (d1 == d2) {
                    return 0;
                }
                return d1 < d2 ? -1 : 1;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean equal(AtomicSequence a, AtomicSequence b) {
        return this.compareSequences(a, b) == 0;
    }

    @Override
    public int hash(AtomicSequence a) {
        int h2 = 1451382402;
        for (AtomicValue val : a) {
            char type = val.getItemType().getBasicAlphaCode().charAt(1);
            switch (type) {
                case 'S': 
                case 'Z': {
                    h2 ^= val.getUnicodeStringValue().hashCode();
                    break;
                }
                case 'B': {
                    h2 ^= ((BooleanValue)val).hashCode();
                    break;
                }
                case 'R': {
                    h2 ^= ((DurationValue)val).getSchemaComparable().hashCode();
                    break;
                }
                case 'M': {
                    h2 ^= ((DateTimeValue)val).getSchemaComparable().hashCode();
                    break;
                }
                case 'A': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': {
                    h2 ^= ((GDateValue)val).getSchemaComparable().hashCode();
                    break;
                }
                case 'T': {
                    h2 ^= ((TimeValue)val).getSchemaComparable().hashCode();
                    break;
                }
                case 'X': {
                    h2 ^= Arrays.hashCode(((HexBinaryValue)val).getBinaryValue());
                    break;
                }
                case '2': {
                    h2 ^= Arrays.hashCode(((Base64BinaryValue)val).getBinaryValue());
                    break;
                }
                case 'U': {
                    h2 ^= ((AnyURIValue)val).getUnicodeStringValue().hashCode();
                    break;
                }
                case 'N': 
                case 'Q': {
                    h2 ^= ((QualifiedNameValue)val).getStructuredQName().hashCode();
                    break;
                }
                case 'D': 
                case 'F': 
                case 'O': {
                    h2 ^= val.hashCode();
                    break;
                }
                default: {
                    throw new IllegalStateException("Alphacode " + type);
                }
            }
            h2 <<= 1;
        }
        return h2;
    }

    public boolean equalOrIdentical(AtomicSequence a1, AtomicSequence a2) {
        AtomicValue item2;
        AtomicValue item1;
        if (a1.getLength() == 1 && a2.getLength() == 1) {
            AtomicValue v2;
            AtomicValue v1 = a1.head();
            return this.compareItems(v1, v2 = a2.head()) == 0 || v1.isNaN() && v2.isNaN();
        }
        AtomicIterator iter1 = a1.iterate();
        AtomicIterator iter2 = a2.iterate();
        do {
            item1 = iter1.next();
            item2 = iter2.next();
            if (item1 == null && item2 == null) {
                return true;
            }
            if (item1 != null && item2 != null) continue;
            return false;
        } while (this.compareItems(item1, item2) == 0 || item1.isNaN() && item2.isNaN());
        return false;
    }
}

