<!--
SPDX-FileCopyrightText: 2023 UnionTech Software Technology Co., Ltd.

SPDX-License-Identifier: LGPL-3.0-or-later
-->

# 概述

如意玲珑是统信软件自研的开源软件包格式，用于替代 `deb`、`rpm`等包管理工具，实现了应用包管理、分发、容器、集成开发工具等功能。

## 当前包管理器存在的问题

1. `deb`、`rpm`都属于强依赖型的包管理系统，同时允许各个组件之间有复杂的交叉依赖（或循环依赖）关系。这使得维护包管理系统需要极强的专业知识，稍有不慎，就会导致系统彻底故障，无法修复。
2. 安装依赖和运行依赖耦合，多版本共存困难。`rpm`和 `deb`虽然提供了方案来解决多版本共存的问题，但是这些方案要求源码级别的改动，不具备实施的可行性。
3. `Hook`系统设计复杂，没有限制，可以通过 `Hook`系统做很多破坏系统的操作。
4. 可靠性不足，没有冗余的恢复设计，缺乏校验机制。一旦包管理系统故障，系统基本没有修复的可能性。
5. `deb`、`rpm`权限管控松散，有较大的安全风险。
6. 当前包更新不支持增量更新，对资源有较大浪费。

## 如意玲珑的优势

1. 提升易用性，解决 `deb`、`rpm`依赖冲突问题。
2. 加强安全防护，如意玲珑实现了应用权限管理机制。
3. 支持应用增量更新。

## 对比

| 特性                      | 如意玲珑                            | Flatpak       | Snap             | AppImage                                |
| ------------------------- | ------------------------------- | ------------- | ---------------- | --------------------------------------- |
| 打包桌面应用              | ✔                              | ✔            | ✔               | ✔                                      |
| 打包终端应用              | ✔                              | ✔            | ✔               | ✔                                      |
| 处理服务器应用            | ✔                              | ✘            | ✔               | ✘                                      |
| 打包系统服务（root 权限） | ✘                              | ✘            | ✔               | ✘                                      |
| 主题功能正常              | ✔                              | ✔            | ✔               | ✔                                      |
| 提供库托管服务            | ✔                              | ✘            | ✘               | ✘                                      |
| 库/依赖来源               | 包自身携带                      |               |                  |                                         |
| 宿主系统                  | 包自身携带                      |               |                  |                                         |
| SDK                       | 包自身携带                      |               |                  |                                         |
| Snap Base                 |                                 |               |                  |                                         |
| 商业支持                  | ✔                              | ✘            | ✔               | ✘                                      |
| 应用商店数量              | 预计 3000+                      | 1400+         | 6600+            | 1300+                                   |
| 开发工具支持              |                                 | GNOME Builder | electron-builder |                                         |
| 容器支持                  | ✔                              | ✔            | ✔               | ◐ （官方不提供，技术上可行）           |
| rootless 容器             | ✔                              | ✘            | ✘               | ✘                                      |
| 不安装运行                | ✔ （提供 Bundle 模式）         | ✘            | ✘               | ✔                                      |
| 不解压运行                | ✔ （提供 Bundle 模式）         | ✘            | ✔               | ✔                                      |
| 自分发/绿色格式分发       | ◐ （技术可行，但是系统做限制） | ✘            | ✘               | ✔                                      |
| 支持 Wine 应用运行        | ◐   (适配中)                 | ◐ （理论可行 | ◐ （理论可行）  | ◐ （使用 LD 修改 open 调用，兼容性差） |
| 离线环境支持              | ✔                              | ✔            | ✔               | ✔                                      |
| 权限管理                  | ✔                              | ✔            | ✔               | ✘                                      |
| 中心仓库                  | mirror-repo-linglong.deepin.com | FlatHub       | Snap Store       | AppImageHub                             |
| 多版本共存                | ✔                              | ✔            | ✔               | ✔                                      |
| 点对点分发                | ✔                              | ✔            | ✔               | ✔                                      |
| 应用升级                  | 仓库升级                        | 仓库升级      | 仓库升级         | 官方工具升级                            |
