/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.DomainProtocolException;
import org.apache.harmony.jndi.provider.dns.Message;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;
import org.apache.harmony.jndi.provider.dns.QuestionRecord;
import org.apache.harmony.jndi.provider.dns.ResolverCache;
import org.apache.harmony.jndi.provider.dns.ResourceRecord;
import org.apache.harmony.jndi.provider.dns.SList;
import org.apache.harmony.jndi.provider.dns.TransportMgr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver
implements Runnable {
    private static final int MSG_MAX_BYTES = 512;
    private static final Random rndGen = new Random();
    private int initialTimeout;
    private int timeoutRetries;
    private boolean authoritativeAnswerDesired;
    private boolean recursionDesired;
    private int threadNumberLimit;
    private final ArrayList<ThreadListEntry> resolverThreads = new ArrayList();
    private final ArrayList<ThreadListEntry> hostnamesToResolve = new ArrayList();
    private final Object threadListSemaphore = new ThreadListSemaphore();

    public Resolver() {
        this(1000, 4, 7, false, true);
    }

    public Resolver(int initialTimeout, int timeoutRetries, int maxThreads, boolean authoritativeAnswerDesired, boolean recursionDesired) {
        this.initialTimeout = initialTimeout;
        this.timeoutRetries = timeoutRetries;
        this.threadNumberLimit = maxThreads;
        this.authoritativeAnswerDesired = authoritativeAnswerDesired;
        this.recursionDesired = recursionDesired;
    }

    public int getThreadNumberLimit() {
        return this.threadNumberLimit;
    }

    public void setThreadNumberLimit(int threadNumberLimit) {
        this.threadNumberLimit = threadNumberLimit;
    }

    public boolean isAuthoritativeAnswerDesired() {
        return this.authoritativeAnswerDesired;
    }

    public void setAuthoritativeAnswerDesired(boolean authoritativeAnswerDesired) {
        this.authoritativeAnswerDesired = authoritativeAnswerDesired;
    }

    public int getInitialTimeout() {
        return this.initialTimeout;
    }

    public void setInitialTimeout(int initialTimeout) {
        this.initialTimeout = initialTimeout;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public void setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
    }

    public int getTimeoutRetries() {
        return this.timeoutRetries;
    }

    public void setTimeoutRetries(int timeoutRetries) {
        this.timeoutRetries = timeoutRetries;
    }

    public Enumeration<ResourceRecord> lookup(String name, int[] types, int[] classes) throws SecurityException, NameNotFoundException, ServiceUnavailableException, DomainProtocolException {
        ResolverCache cache = ResolverCache.getInstance();
        Vector<QuestionRecord> questions = new Vector<QuestionRecord>();
        Vector<ResourceRecord> answers = new Vector<ResourceRecord>();
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (types == null) {
            throw new NullPointerException(Messages.getString("jndi.6B"));
        }
        if (classes == null) {
            throw new NullPointerException(Messages.getString("jndi.6C"));
        }
        int[] nArray = classes;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int element = nArray[n];
            int[] nArray2 = types;
            int n3 = 0;
            int n4 = nArray2.length;
            while (n3 < n4) {
                int element0 = nArray2[n3];
                QuestionRecord quest = new QuestionRecord(name, element0, element);
                questions.addElement(quest);
                ++n3;
            }
            ++n;
        }
        int i = 0;
        while (i < questions.size()) {
            Enumeration<ResourceRecord> recEnum;
            QuestionRecord curQuestion = (QuestionRecord)questions.elementAt(i);
            String qName = curQuestion.getQName();
            Message mesToSend = null;
            Message receivedMes = null;
            AnalysisReport report = null;
            Hashtable<SList.Server, Object> visitedServers = new Hashtable<SList.Server, Object>();
            if (curQuestion.getQType() != 255 && curQuestion.getQClass() != 255 && (recEnum = cache.get(curQuestion)).hasMoreElements()) {
                while (recEnum.hasMoreElements()) {
                    answers.addElement(recEnum.nextElement());
                }
            } else {
                String workZone;
                if (qName != null && !qName.equals(".")) {
                    workZone = qName;
                    while (workZone.startsWith("_")) {
                        workZone = ProviderMgr.getParentName(workZone);
                    }
                } else {
                    workZone = ".";
                }
                mesToSend = Resolver.createMessageForSending(qName, curQuestion.getQType(), curQuestion.getQClass());
                while (true) {
                    boolean noIdea = false;
                    try {
                        receivedMes = this.queryServers(mesToSend, workZone, visitedServers, false);
                        if (receivedMes != null) {
                            ResourceRecord rec;
                            int k;
                            report = this.analyzeAnswer(mesToSend, receivedMes);
                            if (!report.messageWasTruncated) {
                                k = 0;
                                while (k < report.extraRecords.size()) {
                                    rec = report.extraRecords.elementAt(k);
                                    cache.put(rec);
                                    ++k;
                                }
                            }
                            if (report.completeAnswerWasReceived) {
                                k = 0;
                                while (k < report.records.size()) {
                                    rec = report.records.elementAt(k);
                                    answers.addElement(rec);
                                    cache.put(rec);
                                    ++k;
                                }
                                break;
                            }
                            if (report.nameError) {
                                throw new NameNotFoundException(Messages.getString("jndi.6D", name));
                            }
                            if (report.aliasInfoWasReceived) {
                                Enumeration<ResourceRecord> recEnum2;
                                qName = report.newName;
                                curQuestion.setQName(qName);
                                if (curQuestion.getQType() != 255 && curQuestion.getQClass() != 255 && (recEnum2 = cache.get(curQuestion)).hasMoreElements()) {
                                    while (recEnum2.hasMoreElements()) {
                                        answers.addElement(recEnum2.nextElement());
                                    }
                                    break;
                                }
                                workZone = qName != null && !qName.equals(".") ? qName : ".";
                                visitedServers = new Hashtable();
                                int k2 = 0;
                                while (k2 < report.records.size()) {
                                    answers.addElement(report.records.elementAt(k2));
                                    ++k2;
                                }
                                mesToSend = Resolver.createMessageForSending(qName, curQuestion.getQType(), curQuestion.getQClass());
                            }
                            if (report.delegationArrived) {
                                int k17 = -1;
                                int matchingCount = ProviderMgr.getMatchingCount(qName, workZone);
                                int k3 = 0;
                                while (k3 < report.delegationZones.size()) {
                                    String curZone = report.delegationZones.elementAt(k3);
                                    int tmpMatchingCount = ProviderMgr.getMatchingCount(qName, curZone);
                                    if (tmpMatchingCount > matchingCount) {
                                        k17 = k3;
                                        matchingCount = tmpMatchingCount;
                                    }
                                    ++k3;
                                }
                                if (k17 != -1) {
                                    workZone = report.delegationZones.elementAt(k17);
                                }
                            } else {
                                noIdea = true;
                            }
                        } else {
                            noIdea = true;
                        }
                        if (!noIdea) continue;
                        if (!workZone.equals(".")) {
                            workZone = ProviderMgr.getParentName(workZone);
                            continue;
                        }
                        break;
                    }
                    catch (NameNotFoundException e) {
                        throw e;
                    }
                    catch (DomainProtocolException e) {
                        throw e;
                    }
                }
            }
            ++i;
        }
        return answers.elements();
    }

    public Enumeration<ResourceRecord> list(String name) throws NamingException {
        Vector<ResourceRecord> answerVect = new Vector<ResourceRecord>();
        Message mesToSend = null;
        Message receivedMes = null;
        HashSet<Object> authoritativeServers = new HashSet<Object>();
        int[] qClassArr = new int[1];
        byte[] outBuf = new byte[512];
        byte[] inBuf = new byte[65536];
        boolean received = false;
        boolean completeAnswer = false;
        String proto = null;
        ResolverCache cache = ResolverCache.getInstance();
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (name.startsWith("_")) {
            int n = name.indexOf(46);
            if (n != -1) {
                proto = name.substring(0, n);
                name = name.length() > n ? name.substring(n + 1, name.length()) : ".";
            } else {
                name = ".";
            }
        }
        Enumeration<ResourceRecord> enum1 = this.lookup(name, new int[]{2}, new int[]{255});
        mesToSend = Resolver.createMessageForSending(name, 252, 255);
        int outLen = mesToSend.writeBytes(outBuf, 0);
        while (enum1.hasMoreElements()) {
            StringTokenizer st;
            ResourceRecord resourceRecord = enum1.nextElement();
            if (resourceRecord.getRRType() == 2) {
                authoritativeServers.add(resourceRecord.getRData());
                qClassArr[0] = resourceRecord.getRRClass();
                continue;
            }
            if (resourceRecord.getRRType() != 6 || !(st = new StringTokenizer((String)resourceRecord.getRData(), " ")).hasMoreTokens()) continue;
            authoritativeServers.add(st.nextToken());
            qClassArr[0] = resourceRecord.getRRClass();
            break;
        }
        block15: for (String string : authoritativeServers) {
            Enumeration<ResourceRecord> addrEnum = this.lookup(string, new int[]{1}, qClassArr);
            while (addrEnum.hasMoreElements()) {
                ResourceRecord curRR = addrEnum.nextElement();
                String ip = (String)curRR.getRData();
                try {
                    TransportMgr.sendReceiveTCP(ip, 53, outBuf, outLen, inBuf, 65536, this.initialTimeout * this.timeoutRetries);
                    received = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (DomainProtocolException domainProtocolException) {}
                if (received) {
                    receivedMes = new Message();
                    try {
                        Message.parseMessage(inBuf, 0, receivedMes);
                        int rCode = receivedMes.getRCode();
                        switch (rCode) {
                            case 0: {
                                int k = 0;
                                while (k < 3) {
                                    switch (k) {
                                        case 0: {
                                            enum1 = receivedMes.getAnswerRRs();
                                            break;
                                        }
                                        case 1: {
                                            enum1 = receivedMes.getAuthorityRRs();
                                            break;
                                        }
                                        case 2: {
                                            enum1 = receivedMes.getAdditionalRRs();
                                        }
                                    }
                                    while (enum1.hasMoreElements()) {
                                        ResourceRecord rr = enum1.nextElement();
                                        cache.put(rr);
                                        if (k != 0) continue;
                                        answerVect.addElement(rr);
                                    }
                                    ++k;
                                }
                                completeAnswer = true;
                                break;
                            }
                            case 3: {
                                throw new NameNotFoundException(Messages.getString("jndi.6D", name));
                            }
                        }
                    }
                    catch (DomainProtocolException domainProtocolException) {}
                }
                if (completeAnswer) break block15;
            }
        }
        if (!completeAnswer) {
            throw new ServiceUnavailableException(Messages.getString("jndi.6E"));
        }
        if (proto != null) {
            Vector<ResourceRecord> vector = new Vector<ResourceRecord>();
            int i = 0;
            while (i < answerVect.size()) {
                ResourceRecord rr = (ResourceRecord)answerVect.elementAt(i);
                StringTokenizer st = new StringTokenizer(rr.getName(), ".");
                String token = null;
                boolean valid = false;
                if (st.hasMoreTokens() && (token = st.nextToken()).length() > 0 && token.charAt(0) == '_' && st.hasMoreTokens() && (token = st.nextToken()).equalsIgnoreCase(proto)) {
                    valid = true;
                }
                if (valid) {
                    vector.addElement(rr);
                }
                ++i;
            }
            answerVect = vector;
        }
        return answerVect.elements();
    }

    public void addInitialServer(String name, String ip, int port, String zoneName) {
        InetAddress addrObj;
        SList.Server server = new SList.Server(name, ip, port);
        SList slist = SList.getInstance();
        if (name == null && ip == null) {
            throw new NullPointerException(Messages.getString("jndi.6F"));
        }
        if (zoneName == null) {
            throw new NullPointerException(Messages.getString("jndi.70"));
        }
        if (ip == null && !slist.hasServer(name) && (addrObj = TransportMgr.getIPByName_OS(name)) != null) {
            server.setIP(ProviderMgr.getIpStr(addrObj.getAddress()));
        }
        if (!slist.hasServer(zoneName, server)) {
            slist.updateEntry(zoneName, server, SList.UNKNOWN);
        }
    }

    Message queryServers(Message request, String workZone, Hashtable<SList.Server, Object> visitedServers, boolean tcpOnly) throws DomainProtocolException, SecurityException {
        SList slist = SList.getInstance();
        byte[] outBuf = new byte[512];
        byte[] inBuf = new byte[512];
        Message receivedMes = null;
        int idx = 0;
        int curTimeout = this.initialTimeout;
        boolean received = false;
        boolean parsed = false;
        boolean correctAnswer = false;
        int rCode = -1;
        if (!request.getQuestionRecords().hasMoreElements()) {
            throw new IllegalArgumentException(Messages.getString("jndi.71"));
        }
        QuestionRecord qRecord = request.getQuestionRecords().nextElement();
        int outBufLen = request.writeBytes(outBuf, 0);
        int round = 0;
        while (round < this.timeoutRetries) {
            HashSet<SList.Server> queriedServers = new HashSet<SList.Server>();
            while (true) {
                int responseTime = 0;
                received = false;
                parsed = false;
                rCode = -1;
                SList.Server curServer = slist.getBestGuess(workZone, visitedServers);
                if (curServer == null || queriedServers.contains(curServer)) break;
                if (curServer.getIP() == null) {
                    this.startResolvingThread(curServer.getName(), qRecord.getQClass());
                    slist.updateEntry(workZone, curServer, SList.NETWORK_FAILURE);
                    queriedServers.add(curServer);
                    continue;
                }
                try {
                    if (tcpOnly) {
                        TransportMgr.sendReceiveTCP(curServer.getIP(), curServer.getPort(), outBuf, outBufLen, inBuf, inBuf.length, curTimeout);
                    } else {
                        TransportMgr.sendReceiveUDP(curServer.getIP(), curServer.getPort(), outBuf, outBufLen, inBuf, inBuf.length, curTimeout);
                    }
                    received = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    slist.updateEntry(workZone, curServer, SList.TIMEOUT);
                }
                catch (DomainProtocolException domainProtocolException) {
                    slist.updateEntry(workZone, curServer, SList.NETWORK_FAILURE);
                }
                if (received) {
                    try {
                        boolean answerSectionIsTruncated = false;
                        receivedMes = new Message();
                        idx = 0;
                        idx = Message.parseMessage(inBuf, idx, receivedMes);
                        parsed = true;
                        if (receivedMes.isTc() && !tcpOnly) {
                            try {
                                TransportMgr.sendReceiveTCP(curServer.getIP(), curServer.getPort(), outBuf, outBufLen, inBuf, inBuf.length, curTimeout);
                                Message receivedMesTcp = new Message();
                                int idx2 = Message.parseMessage(inBuf, 0, receivedMesTcp);
                                if (!receivedMesTcp.isTc()) {
                                    receivedMes = receivedMesTcp;
                                    idx = idx2;
                                }
                            }
                            catch (Exception exception) {}
                        }
                        if (receivedMes.isTc() && !receivedMes.getAuthorityRRs().hasMoreElements() && !receivedMes.getAdditionalRRs().hasMoreElements()) {
                            answerSectionIsTruncated = true;
                        }
                        if ((rCode = receivedMes.getRCode()) == 0) {
                            slist.updateEntry(workZone, curServer, responseTime);
                            visitedServers.put(curServer, new Object());
                            if (!answerSectionIsTruncated) {
                                correctAnswer = true;
                                break;
                            }
                        } else if (rCode == 2) {
                            slist.updateEntry(workZone, curServer, SList.SERVER_FAILURE);
                            visitedServers.put(curServer, new Object());
                        } else if (rCode == 1) {
                            slist.updateEntry(workZone, curServer, SList.SERVER_FAILURE);
                            visitedServers.put(curServer, new Object());
                        } else if (rCode == 3) {
                            if (receivedMes.isAA()) {
                                slist.updateEntry(workZone, curServer, responseTime);
                                visitedServers.put(curServer, new Object());
                                correctAnswer = true;
                                break;
                            }
                            slist.updateEntry(workZone, curServer, SList.SERVER_FAILURE);
                            visitedServers.put(curServer, new Object());
                        } else if (rCode == 4) {
                            slist.updateEntry(workZone, curServer, SList.SERVER_FAILURE);
                            visitedServers.put(curServer, new Object());
                        } else if (rCode == 5) {
                            slist.updateEntry(workZone, curServer, SList.SERVER_FAILURE);
                            visitedServers.put(curServer, new Object());
                        }
                    }
                    catch (DomainProtocolException domainProtocolException) {
                        slist.dropServer(workZone, curServer);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        slist.dropServer(workZone, curServer);
                    }
                }
                queriedServers.add(curServer);
            }
            if (received & parsed & correctAnswer) {
                return receivedMes;
            }
            curTimeout *= 2;
            ++round;
        }
        return null;
    }

    AnalysisReport analyzeAnswer(Message request, Message answer) throws DomainProtocolException {
        Enumeration<ResourceRecord> additionalRRs;
        ResourceRecord curRec;
        Enumeration<QuestionRecord> questions = request.getQuestionRecords();
        Enumeration<ResourceRecord> answerRRs = answer.getAnswerRRs();
        Enumeration<ResourceRecord> authorityRRs = answer.getAuthorityRRs();
        AnalysisReport report = new AnalysisReport();
        if (request.getId() != answer.getId()) {
            throw new DomainProtocolException(Messages.getString("jndi.72"));
        }
        if (!questions.hasMoreElements()) {
            throw new IllegalArgumentException(Messages.getString("jndi.73"));
        }
        QuestionRecord question = questions.nextElement();
        if (answer.getRCode() == 3) {
            report.nameError = true;
            return report;
        }
        if (answer.isTc()) {
            report.messageWasTruncated = true;
        }
        while (answerRRs.hasMoreElements()) {
            curRec = answerRRs.nextElement();
            if (question.getQClass() != curRec.getRRClass() && question.getQClass() != 255) continue;
            if (question.getQType() == 255 && ProviderMgr.namesAreEqual(curRec.getName(), question.getQName())) {
                report.records.addElement(curRec);
                if (curRec.getRRType() == 5) {
                    report.aliasInfoWasReceived = true;
                    report.newName = (String)curRec.getRData();
                    continue;
                }
                report.completeAnswerWasReceived = true;
                continue;
            }
            if (question.getQType() == curRec.getRRType() && ProviderMgr.namesAreEqual(question.getQName(), curRec.getName())) {
                report.records.addElement(curRec);
                report.completeAnswerWasReceived = true;
                continue;
            }
            if (curRec.getRRType() == 5 && ProviderMgr.namesAreEqual(curRec.getName(), question.getQName())) {
                ResourceRecord tmpRec;
                Enumeration<ResourceRecord> answerRRs2 = answer.getAnswerRRs();
                Enumeration<ResourceRecord> additionalRRs2 = answer.getAdditionalRRs();
                report.aliasInfoWasReceived = true;
                report.newName = (String)curRec.getRData();
                report.extraRecords.addElement(curRec);
                while (answerRRs2.hasMoreElements()) {
                    tmpRec = answerRRs2.nextElement();
                    if (tmpRec.getRRType() != question.getQType() || !ProviderMgr.namesAreEqual(tmpRec.getName(), report.newName)) continue;
                    report.records.addElement(tmpRec);
                    report.completeAnswerWasReceived = true;
                }
                while (additionalRRs2.hasMoreElements()) {
                    tmpRec = additionalRRs2.nextElement();
                    if (tmpRec.getRRType() != question.getQType() || !ProviderMgr.namesAreEqual(tmpRec.getName(), report.newName)) continue;
                    report.records.addElement(tmpRec);
                    report.completeAnswerWasReceived = true;
                }
                continue;
            }
            if (answer.isAA()) {
                report.completeAnswerWasReceived = true;
            }
            report.extraRecords.addElement(curRec);
        }
        while (authorityRRs.hasMoreElements()) {
            curRec = authorityRRs.nextElement();
            SList slist = SList.getInstance();
            report.extraRecords.addElement(curRec);
            if (curRec.getRRType() != 2) continue;
            String serverName = (String)curRec.getRData();
            SList.Server server2 = new SList.Server(serverName, null, 53);
            SList.Server server = slist.getServerByServer(curRec.getName(), server2);
            report.delegationArrived = true;
            if (server == null) {
                slist.updateEntry(curRec.getName(), server2, SList.UNKNOWN);
                report.delegationZones.addElement(curRec.getName());
                server = server2;
            }
            if (server == null || server.getIP() != null) continue;
            additionalRRs = answer.getAdditionalRRs();
            while (additionalRRs.hasMoreElements()) {
                ResourceRecord addRec = additionalRRs.nextElement();
                if (!ProviderMgr.namesAreEqual(addRec.getName(), serverName) || addRec.getRRType() != 1) continue;
                server.setIP((String)addRec.getRData());
            }
            if (server.getIP() != null) continue;
            this.startResolvingThread(server.getName(), curRec.getRRClass());
        }
        additionalRRs = answer.getAdditionalRRs();
        while (additionalRRs.hasMoreElements()) {
            ResourceRecord addRec = additionalRRs.nextElement();
            report.extraRecords.addElement(addRec);
        }
        int k = 0;
        while (k < 2) {
            Vector<ResourceRecord> records = null;
            HashSet<String> processed = new HashSet<String>();
            switch (k) {
                case 0: {
                    records = report.records;
                    break;
                }
                case 1: {
                    records = report.extraRecords;
                }
            }
            int i = 0;
            while (i < records.size()) {
                ResourceRecord rr = records.elementAt(i);
                String key = String.valueOf(rr.getName()) + " " + rr.getRRClass() + " " + rr.getRRType();
                long ttl = rr.getTtl();
                Vector<ResourceRecord> objToUpdateTTL = new Vector<ResourceRecord>();
                if (!processed.contains(key)) {
                    ResourceRecord rr2;
                    objToUpdateTTL.addElement(rr);
                    int j = i;
                    while (j < records.size()) {
                        rr2 = records.elementAt(j);
                        String key2 = String.valueOf(rr2.getName()) + " " + rr2.getRRClass() + " " + rr2.getRRType();
                        long ttl2 = rr2.getTtl();
                        if (!processed.contains(key2) && key.equals(key2)) {
                            if (ttl > ttl2) {
                                ttl = ttl2;
                            }
                            objToUpdateTTL.addElement(rr2);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < objToUpdateTTL.size()) {
                        rr2 = (ResourceRecord)objToUpdateTTL.elementAt(j);
                        if (rr2.getTtl() != ttl) {
                            rr2.setTtl(ttl);
                        }
                        ++j;
                    }
                    processed.add(key);
                }
                ++i;
            }
            ++k;
        }
        return report;
    }

    static Message createMessageForSending(String desiredName, int recType, int recClass) throws DomainProtocolException {
        Message mes = new Message();
        QuestionRecord qr = new QuestionRecord();
        mes.setId(rndGen.nextInt() & 0xFFFF);
        mes.setQR(false);
        mes.setOpCode(0);
        mes.setRD(true);
        mes.setQDCount(1);
        qr.setQName(desiredName);
        qr.setQType(recType);
        qr.setQClass(recClass);
        mes.addQuestionRecord(qr);
        return mes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startResolvingThread(String hostname, int dnsClass) {
        int[] classes = new int[1];
        Object object = this.threadListSemaphore;
        synchronized (object) {
            ThreadListEntry entry;
            int i = 0;
            while (i < this.resolverThreads.size()) {
                entry = this.resolverThreads.get(i);
                if (ProviderMgr.namesAreEqual(hostname, entry.serverNameToResolve) && entry.dnsClass == dnsClass) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.hostnamesToResolve.size()) {
                entry = this.hostnamesToResolve.get(i);
                if (ProviderMgr.namesAreEqual(hostname, entry.serverNameToResolve) && entry.dnsClass == dnsClass) {
                    return;
                }
                ++i;
            }
            if (this.resolverThreads.size() >= this.threadNumberLimit) {
                return;
            }
            classes[0] = dnsClass;
            ThreadListEntry newEntry = new ThreadListEntry();
            newEntry.serverNameToResolve = hostname;
            newEntry.dnsClass = dnsClass;
            this.hostnamesToResolve.add(newEntry);
            Thread newThread = new Thread(this);
            newThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadListEntry entryToProcess;
        SList slist = SList.getInstance();
        int[] classes = new int[1];
        Object object = this.threadListSemaphore;
        synchronized (object) {
            if (this.hostnamesToResolve.size() <= 0) {
                return;
            }
            entryToProcess = this.hostnamesToResolve.get(0);
            this.hostnamesToResolve.remove(0);
            entryToProcess.thread = Thread.currentThread();
            this.resolverThreads.add(entryToProcess);
        }
        try {
            classes[0] = entryToProcess.dnsClass;
            Enumeration<ResourceRecord> foundRecords = this.lookup(entryToProcess.serverNameToResolve, new int[]{1}, classes);
            while (foundRecords != null && foundRecords.hasMoreElements()) {
                ResourceRecord rr = foundRecords.nextElement();
                if (rr.getRRType() != 1) continue;
                slist.setServerIP(entryToProcess.serverNameToResolve, (String)rr.getRData());
            }
        }
        catch (NamingException namingException) {}
        object = this.threadListSemaphore;
        synchronized (object) {
            int i = 0;
            while (i < this.resolverThreads.size()) {
                ThreadListEntry entry = this.resolverThreads.get(i);
                if (ProviderMgr.namesAreEqual(entryToProcess.serverNameToResolve, entry.serverNameToResolve) && entryToProcess.dnsClass == entry.dnsClass) {
                    this.resolverThreads.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    private static class ThreadListEntry {
        Thread thread;
        String serverNameToResolve;
        int dnsClass;

        private ThreadListEntry() {
        }
    }

    private class ThreadListSemaphore {
        private ThreadListSemaphore() {
        }
    }

    static class AnalysisReport {
        boolean completeAnswerWasReceived = false;
        boolean nameError = false;
        boolean delegationArrived = false;
        boolean aliasInfoWasReceived = false;
        boolean messageWasTruncated = false;
        Vector<ResourceRecord> records = new Vector();
        Vector<String> delegationZones = new Vector();
        String newName = null;
        Vector<ResourceRecord> extraRecords = new Vector();

        AnalysisReport() {
        }
    }
}

