#ifndef EAIEAIPROMPT_H
#define EAIEAIPROMPT_H

#include "eaiprompt.h"

//Add all app ai prompt in this file.

//对话模式
class EConversationPrompt : public EAiPrompt
{
public:
    explicit EConversationPrompt(const QString &userData);

    QString getAiPrompt() override;
};

//文档总结
class EAiDocSummaryPrompt : public EAiPrompt
{
public:
    explicit EAiDocSummaryPrompt(const QString &userData, const QString &aiData);

    QString getAiPrompt() override;
};

// uos/deepin 系统助手
class EAiSysAssistantPrompt : public EAiPrompt
{
public:
    explicit EAiSysAssistantPrompt(const QString &userData);

    QString getAiPrompt() override;

    QString getReferences();

private:
    void embeddingSearch();
    QHash<QString, QVector<QString>> m_references;
};

// 个人知识助手
class EAiPersonalAssistantPrompt : public EAiPrompt
{
public:
    explicit EAiPersonalAssistantPrompt(const QString &userData);

    QString getAiPrompt() override;

    QString getReferences();

private:
    void embeddingSearch();
    QHash<QString, QVector<QString>> m_references;
};

// 生成问题
class EAiGenerateQuestionPrompt : public EAiPrompt
{
public:
    explicit EAiGenerateQuestionPrompt();

    QString getAiPrompt() override;
};

// 划词助手
class EAiWordSelectionPrompt : public EAiPrompt
{
public:
    explicit EAiWordSelectionPrompt(const QString &prompt);

    QString getAiPrompt() override;
};

// 指令
class EAiInstructionPrompt : public EAiPrompt
{
public:
    explicit EAiInstructionPrompt(const QString &prompt);

    QString getAiPrompt() override;
};

#endif // EAIEAIPROMPT_H
