#ifndef EPARSERDOCUMENT_H
#define EPARSERDOCUMENT_H

#include "serverdefs.h"
#include <QObject>

namespace uos_ai {
class EParserDocument : public QObject
{
    Q_OBJECT
public:
    static EParserDocument *instance();

    enum ParserStart {
        Success = 0,
        MoreOneError,
        SuffixError,
        NoDocError,
        ExceedSize
    };

    enum ParserResult {
        NoError = 0,
        ParsingFailed,
        NoTextError
    };

    void parserDocument(const QString &docPath);
    void selectDocument(AssistantType type);
    void dragInViewDocument(const QStringList &docPaths, const QString &defaultPrompt, AssistantType type);

signals:
    void sigParserStart(const QString &docPath, const QString &iconData, const QString &defaultPrompt, int error);
    void sigParserResult(int error, const QString &docPath, const QString &docContent);

private:
    explicit EParserDocument();

    bool isExceedDocSize(const QString &docPath);
    QString getFileIconData(const QString &docPath);
    void updateSupSuffix(AssistantType type);

private:
    QString m_lastImportPath;
    QStringList m_supSuffix;
};
}
#endif // EPARSERDOCUMENT_H
