//
// Created by uos on 2022/3/16.
//

#ifndef UOS_RECOVERY_RESTOREMODULE_H
#define UOS_RECOVERY_RESTOREMODULE_H

#include "interface/ModuleInterface.h"
#include "RestoreWidget.h"
#include "SystemRestoreWidget.h"
#include "UserDataRestoreWidget.h"
#include "dimFileRestoreWidget.h"
#include "common/ResultWidget.h"
#include "common/ProgressWidget.h"
#include <QObject>

class FrameProxyInterface;
class QString;

class RestoreModule : public QObject, public ModuleInterface
{
    Q_OBJECT
public:
    explicit RestoreModule(FrameProxyInterface *frame, ComDeepinDaemonUosrecoveryInterface *interface,
                           QObject *parent = nullptr);
    ~RestoreModule() override;

    void initialize() override;

    QString name() const override;

    QString icons() const override;

    QString text() const override;

    void active() override;
    void setSystemSyncType(int type);
    void setUserDataSyncType(int type);

public Q_SLOTS:
    void onSystemRestore();
    void onStartSystemRestore(BackupInfo &backupInfo);
    void onDataRestore();
    void onStartUserDataRestore(BackupInfo &backupInfo);
    void onDimFileRestore(const QString &dimFilePath);
    void onInitializeRestore();
    void onOtherRestore();
    void onBack();
    void onBackHome();
    void onShowResult(bool success, int operateType, const QString &errorMsg = "");
    void onShowProgress(const QString &mainTitle, const QString &subTitle, const QString &warning);
    void updateProgress(const QString &progress);
    void onError(const QString &errMsg);
    void onSpaceChanged(const QString &space);
//    void onSucess();

private:
    int reboot();
    bool showRebootDialog(const QString &title, const QString &msg, const QString &iconName,
                          const QString &leftBtnText, const QString &rightBtnText);
    void restoreToOStreeFactory(const QString &request);

private:
    RestoreWidget *m_restoreWidget = nullptr;
    SystemRestoreWidget *m_systemRestoreWidget = nullptr;
    UserDataRestoreWidget *m_userDataRestoreWidget = nullptr;
    dimFileRestoreWidget *m_dimFileRestoreWidget = nullptr;
    ProgressWidget *m_progressWidget = nullptr;
    ResultWidget *m_resultWidget = nullptr;
    int m_systemSyncType = -1;
    int m_userDataSyncType = -1;
    QString m_dimRestoreImgFilePath = "";
    bool m_isDimFileRestoreDone = false;
};


#endif //UOS_RECOVERY_RESTOREMODULE_H
