//
// Created by uos on 2022/2/24.
//

#ifndef UOS_RECOVERY_RSYNCTASK_H
#define UOS_RECOVERY_RSYNCTASK_H

#include "AsyncTask.h"
#include <QSet>
#include <QTimer>
#include <QTime>
#include "global.h"

class RsyncTask : public AsyncTask
{
    Q_OBJECT
public:
    RsyncTask();
    explicit RsyncTask(bool reportProgress);
    virtual ~RsyncTask();
    void readStandardOutput() override;
    void readAllStandardError() override;
    bool buildArgumentsForBackup() override;
    bool buildArgumentsForRestore(const QString &fromDir) override;
    void doResult() override;
    void setOptions(const QStringList &options);
    void setLinkDest(const QString &path);
    void setSourcePath(const QString &path);
    void setDestinationPath(const QString &path);
    void setExcludes(const QStringList &excludes);
    void enableDryRun(bool enable);
    QTime getStartTime(){ return m_startTime; }
    void updateGrub();
    void setOperateType(OperateType opType);

signals:
    void progressChanged(const QJsonObject &progress);

private:
    int parseProgress(const QString &info);
    void reportProgress(int progress, int remainSecond);
protected:
    QStringList m_options;
    QString m_linkDest;
    QString m_src;
    QString m_dest;
    QSet<QString> m_excludes;
    QTimer m_timer;
    QTime m_startTime;
    OperateType m_opType = OperateType::Invalid;
    int m_progress = 0;
    int m_rsyncProgress = 0;
    int m_remainSecond = 0;
    bool m_dryRun = true;
    bool m_autoIncProgress = true;
    bool m_reportProgress = true;
};


#endif //UOS_RECOVERY_RSYNCTASK_H
