/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                  rwifree.c                        |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   27.06.95                        |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <math.h>

# include <mut.h>
# include "rds.h"
# include "rtl.h"
# include "rwi.h"

# include "rwifree.h"
# include "rwierror.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        Free Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        Free Rds Rec Win                     |
|                                                             |
\------------------------------------------------------------*/

void freerdsrecwin( RecWin )

  rdsrecwin_list *RecWin;
{
  rdsfreeheap( (char *)RecWin, sizeof(rdsrecwin_list) );
}

/*------------------------------------------------------------\
|                                                             |
|                        Free Rds Win Rec                     |
|                                                             |
\------------------------------------------------------------*/

void freerdswinrec( WinRec )

  rdswinrec_list *WinRec;
{
  rdsfreeheap( (char *)WinRec, sizeof(rdswinrec_list) );
}

/*------------------------------------------------------------\
|                                                             |
|                          Free Rds Win                       |
|                                                             |
\------------------------------------------------------------*/

void freerdswin( Win )

  rdswin_list *Win;
{
  rdsfreeblock( (char *)Win );
}

/*------------------------------------------------------------\
|                                                             |
|                          Free Rds Win Layer                 |
|                                                             |
\------------------------------------------------------------*/

void freerdswinlayer( Win )

  rdswin_list *Win;
{
  if ( Win->LAYERTAB != (rdswinrec_list **)NULL )
  {
    rdsfreeblock( (char *)Win->LAYERTAB );
    Win->LAYERTAB = (rdswinrec_list **)NULL;
  }
}

/*------------------------------------------------------------\
|                                                             |
|                          Free Rds Window                    |
|                                                             |
\------------------------------------------------------------*/

void freerdswindow( RdsWindow )

  rdswindow *RdsWindow;
{
  rdsfreeblock( (char *)RdsWindow );
}

