/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:43:13 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoListener;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class SimpleGotoEventSource_ESTest extends SimpleGotoEventSource_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("U,ES}", "EntryEdit.fireAction () - unknown event");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = Entry.newEntry(bases0);
      FeatureVector featureVector0 = entry0.checkForEMBLDuplicates();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "U,ES}");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      simpleGotoEventSource0.gotoFirstBase();
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      Range range0 = new Range((-383));
      Bases bases1 = bases0.truncate(range0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(1);
      assertTrue(markerRange0.isForwardMarker());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      EntryGroup entryGroup0 = simpleGotoEventSource0.getEntryGroup();
      assertNull(entryGroup0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      simpleGotoEventSource0.getEntryGroup();
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      Entry entry0 = new Entry(bases0, mSPcrunchDocumentEntry0);
      FeatureVector featureVector0 = entry0.checkFeatureStartCodons();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      filteredEntryGroup0.ref();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      EntryGroup entryGroup0 = simpleGotoEventSource0.getEntryGroup();
      assertEquals(0, entryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Range range0 = new Range((-1));
      FeatureVector featureVector0 = simpleEntryGroup0.getFeaturesInRange(range0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      filteredEntryGroup0.unref();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      EntryGroup entryGroup0 = simpleGotoEventSource0.getEntryGroup();
      assertSame(entryGroup0, filteredEntryGroup0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.sendGotoEvent((GotoEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.gotoBase(Integer.MIN_VALUE);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Location: ", "");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "@gM^ys 1^HL;[$x4");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      Strand strand0 = bases0.getForwardStrand();
      Marker marker0 = strand0.makeMarkerFromRawPosition(1);
      GotoEvent gotoEvent0 = new GotoEvent(fastaStreamSequence0, marker0);
      simpleGotoEventSource0.sendGotoEvent(gotoEvent0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      GotoEvent gotoEvent0 = new GotoEvent(simpleEntryGroup0, (Marker) null);
      simpleGotoEventSource0.sendGotoEvent(gotoEvent0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      MarkerRange markerRange0 = simpleGotoEventSource0.gotoBase(2207);
      assertNull(markerRange0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      simpleGotoEventSource0.gotoBase((Marker) null);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("{Lx50", "{Lx50");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "{Lx50");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      simpleGotoEventSource0.removeGotoListener((GotoListener) null);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      Bases bases0 = new Bases(emblStreamSequence0);
      Range range0 = new Range((-383));
      Bases bases1 = bases0.truncate(range0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases1);
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      simpleGotoEventSource0.gotoLastBase();
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("`", "`");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("`");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "`");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "");
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(filteredEntryGroup0);
      simpleGotoEventSource0.addGotoListener((GotoListener) null);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.gotoLastBase();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.gotoFirstBase();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }
}
