/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef __CVC4__OPTIONS__PROOF_H
#define __CVC4__OPTIONS__PROOF_H

#include "options/options.h"




#define CVC4_OPTIONS__PROOF__FOR_OPTION_HOLDER \
  aggressiveCoreMin__option_t::type aggressiveCoreMin;\
  bool aggressiveCoreMin__setByUser__; \
  allowEmptyDependencies__option_t::type allowEmptyDependencies;\
  bool allowEmptyDependencies__setByUser__; \
  fewerPreprocessingHoles__option_t::type fewerPreprocessingHoles;\
  bool fewerPreprocessingHoles__setByUser__; \
  lfscLetification__option_t::type lfscLetification;\
  bool lfscLetification__setByUser__;


namespace CVC4 {

namespace options {

extern struct CVC4_PUBLIC aggressiveCoreMin__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} aggressiveCoreMin CVC4_PUBLIC;
extern struct CVC4_PUBLIC allowEmptyDependencies__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} allowEmptyDependencies CVC4_PUBLIC;
extern struct CVC4_PUBLIC fewerPreprocessingHoles__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fewerPreprocessingHoles CVC4_PUBLIC;
extern struct CVC4_PUBLIC lfscLetification__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} lfscLetification CVC4_PUBLIC;


}  // namespace options

template <> const options::aggressiveCoreMin__option_t::type& Options::operator[](
    options::aggressiveCoreMin__option_t) const;
template <> bool Options::wasSetByUser(options::aggressiveCoreMin__option_t) const;
template <> void Options::assignBool(
    options::aggressiveCoreMin__option_t,
    std::string option,
    bool value);
template <> const options::allowEmptyDependencies__option_t::type& Options::operator[](
    options::allowEmptyDependencies__option_t) const;
template <> bool Options::wasSetByUser(options::allowEmptyDependencies__option_t) const;
template <> void Options::assignBool(
    options::allowEmptyDependencies__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fewerPreprocessingHoles__option_t,
    const options::fewerPreprocessingHoles__option_t::type& x);
template <> const options::fewerPreprocessingHoles__option_t::type& Options::operator[](
    options::fewerPreprocessingHoles__option_t) const;
template <> bool Options::wasSetByUser(options::fewerPreprocessingHoles__option_t) const;
template <> void Options::assignBool(
    options::fewerPreprocessingHoles__option_t,
    std::string option,
    bool value);
template <> const options::lfscLetification__option_t::type& Options::operator[](
    options::lfscLetification__option_t) const;
template <> bool Options::wasSetByUser(options::lfscLetification__option_t) const;
template <> void Options::assignBool(
    options::lfscLetification__option_t,
    std::string option,
    bool value);


namespace options {

inline aggressiveCoreMin__option_t::type aggressiveCoreMin__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool aggressiveCoreMin__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline allowEmptyDependencies__option_t::type allowEmptyDependencies__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool allowEmptyDependencies__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fewerPreprocessingHoles__option_t::type fewerPreprocessingHoles__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fewerPreprocessingHoles__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fewerPreprocessingHoles__option_t::set(const fewerPreprocessingHoles__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline lfscLetification__option_t::type lfscLetification__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool lfscLetification__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}


}  // namespace options
}  // namespace CVC4

#endif /* __CVC4__OPTIONS__PROOF_H */
