/*
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co., Ltd.
 *
 * Author:     ZhangYong <zhangyong@uniontech.com>
 *
 * Maintainer: ZhangYong <ZhangYong@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include <gtest/gtest.h>
#include <gmock/gmock-matchers.h>

#include <QTestEventList>
#include <QObject>
#include <QStandardPaths>

#define private public
#define protected public

#include "ocrapplication.h"
#include "mainwidget.h"
#include "view/imageview.h"
//初始拉起主界面
TEST(MainWindow, mainwindow)
{
    OcrApplication instance;
    instance.openFile("");
    QTest::qWait(2000);
}

//其余case
//初始拉起主界面,带有参数的
TEST(MainWindow, mainwindow_openFile)
{
    QString picPath = QStandardPaths::writableLocation(QStandardPaths::PicturesLocation) + "/Wallpapers/luca-micheli-ruWkmt3nU58-unsplash.jpg";
    OcrApplication instance;
    instance.openFile(picPath);
    bool bRet = false;
    while (!bRet) {
        if (!TessOcrUtils::instance()->isRunning()) {
            bRet = true;
            QTest::qWait(1000);
        }
    }

    instance.openImage(QImage(picPath).scaled(200, 200));

    bRet = false;
    while (!bRet) {
        if (!TessOcrUtils::instance()->isRunning()) {
            bRet = true;
            QTest::qWait(1000);
        }
    }

    instance.openImageAndName(QImage(picPath).scaled(10, 10), picPath);
    QTest::qWait(2000);
}

//初始拉起主界面,带有参数的
TEST(MainWidget, MainWidget_show)
{
    MainWidget *a = new MainWidget();
    a->loadHtml("");
    a->loadHtml("test");
    a->loadString("");
    a->loadString("test");
    a->slotCopy();
    a->deleteLater();
    a = nullptr;
    QTest::qWait(2000);
}

TEST(ImageView, ImageView_show)
{
    QString picPath = QStandardPaths::writableLocation(QStandardPaths::PicturesLocation) + "/Wallpapers/luca-micheli-ruWkmt3nU58-unsplash.jpg";
    ImageView *imageView = new ImageView();
    imageView->openImage(picPath);
    imageView->fitImage();
    imageView->fitWindow();
    imageView->autoFit();
    imageView->imageRelativeScale();
    imageView->setScaleValue(1.1);
    imageView->setScaleValue(0.9);
    imageView->RotateImage(90);
    QTest::qWait(2000);
}
