/*
 * Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co., Ltd.
 *
 * Author:     zhangliangliang <zhangliangliang@uniontech.com>
 * Maintainer: zhangliangliang <zhangliangliang@uniontech.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "DeleteFileTask.h"

#include <QDebug>
#include <QFileInfo>
#include <QProcess>

#include "utils.h"

DeleteFileTask::DeleteFileTask(QObject *parent)
    : PMTask(parent)
{
}

DeleteFileTask::~DeleteFileTask()
{
    qDebug() << "~DeleteFileTask()";
}

void DeleteFileTask::run()
{
    qDebug() << __LINE__ << "delete file start.";

    if (m_fileList.size() > 0) {
        deleteFile(); //使用统一的删除方法
    }

    qDebug() << __LINE__ << "delete file end.";
}

void DeleteFileTask::setPathList(const QStringList &pathList)
{
    m_fileList = pathList;
}

void DeleteFileTask::deleteFile()
{
    foreach (QString strItemFile, m_fileList) {
        if (m_bsTaskCanRun == false)
            break;

        //int ret = deleteFunc_cmd(strItemFile);
        int ret = remove(strItemFile.toLocal8Bit().data()); //C库函数快速删除
        //大小为0的文件可能删除失败，使用下述方式再删一次
        if (ret != 0) {
            ret = Utils::deleteFunc_cmd(strItemFile);
        }

        emit sigDeleteFileResult(ret, strItemFile);
    }

    emit sigTaskFinished();
}

//int DeleteFileTask::deleteFunc_cmd(QString path)
//{
//    QString cmd = "rm";
//    QStringList args;
//    args << "-rf" << path;
//    return QProcess::execute(cmd, args);
//}

//bool DeleteFileTask::deleteFunc_qt(QString path)
//{
//    bool bRet;
//    QFileInfo fileInfo(path);
//    if (fileInfo.isDir()) {
//        QDir dir(path);
//        bRet = dir.removeRecursively();
//    } else {
//        QFile fileName(path);
//        bRet = fileName.remove();
//    }

//    return bRet;
//}

/**
 * @brief 删除文件特殊处理
 * @param[in]
 * @param[out]
 * @return
 * @author zhangliangliang
 * @date 2020-07-23 10:47
 * @copyright (c) 2020
 */
//void DeleteFileTask::adbDeleteFile()
//{
//    int nIndex = 0;

//    //取得挂载路径下的第一层文件夹
//    QString mountPath = Utils::getAndroidMountRootPath(m_devInfo.strPhoneID);

//    foreach (QString strItemFile, m_fileList) {
//        if (m_isExit)
//            break;

//        //此处传入的路径可能是挂载路径，要转成adb路径/sdcard
//        QString adbFilePath = strItemFile;
//        adbFilePath = Utils::mountPathToAdbPath(mountPath, strItemFile);
//        int ret = Utils::adbDeleteFile(m_devInfo.strPhoneID, adbFilePath);

//        QFileInfo file_info;
//        emit sigFileProcResult(ret, strItemFile, 0, file_info);
//        // send progress
//        emit sigProgressRefresh(++nIndex);
//    }
//}
