package utils

import (
	"crypto/md5"
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"sort"
)

func IsFileExist(path string) bool {
	_, err := os.Stat(path)
	return err == nil || os.IsExist(err)
}

func StrInList(s string, strv []string) bool {
	for _, v := range strv {
		if v == s {
			return true
		}
	}
	return false
}

func StrvEqual(l1, l2 []string, sorted bool) bool {
	len1 := len(l1)
	len2 := len(l2)
	if len1 != len2 {
		return false
	}

	if sorted {
		sort.Strings(l1)
		sort.Strings(l2)
	}
	for i := 0; i < len1; i++ {
		if l1[i] != l2[i] {
			return false
		}
	}
	return true
}

func SumFileMd5(filename string) (string, error) {
	contents, err := ioutil.ReadFile(filename)
	if err != nil {
		return "", err
	}
	return fmt.Sprintf("%x", md5.Sum(contents)), nil
}

// TrimFileURI uri format 'file:///usr/xxxx'
func TrimFileURI(uri string) string {
	if len(uri) == 0 {
		return uri
	}

	data := []byte(uri)
	if data[0] != '/' {
		return string(data[7:])
	}
	return string(data)
}

// EnsureParentDirExists create dirs
func EnsureParentDirExists(filename string) error {
	return os.MkdirAll(filepath.Dir(filename), 0755)
}
