package power

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

// Data power configurations
type Data struct {
	Version         string `json:"version"`
	ScreenBlackLock bool   `json:"screen_black_lock"`
	SleepLock       bool   `json:"sleep_lock"`
}

const (
	// Name module name
	Name = "power"
)

// Name module name
func (core *Data) Name() string {
	return Name
}

// Model return module instance
func (core *Data) Model() interface{} {
	return &Data{}
}

// ToIFC return module interface instance
func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

// Equal check whether equal, target must be Data type
func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

// GenCache generate cache data
func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

// Merge merge cloud data according to current and cache
func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeBool(&core.SleepLock, curInfo.SleepLock, cacheInfo.SleepLock)
	utils.MergeBool(&core.ScreenBlackLock, curInfo.ScreenBlackLock,
		cacheInfo.ScreenBlackLock)
}
