/******************************************************************************
 *
 * Copyright (C) 1997-2018 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby
 * granted. No representations are made about the suitability of this software
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#include "emoji.h"
#include "message.h"
#include "util.h"
#include "textstream.h"

static struct emojiEntityInfo
{
  const char *name;
  const char *unicode;
} g_emojiEntities[] =
/* generated using the download_github_emojis.py script */
{
  { ":+1:",                                    "&#x1f44d;"                            },
  { ":-1:",                                    "&#x1f44e;"                            },
  { ":100:",                                   "&#x1f4af;"                            },
  { ":1234:",                                  "&#x1f522;"                            },
  { ":1st_place_medal:",                       "&#x1f947;"                            },
  { ":2nd_place_medal:",                       "&#x1f948;"                            },
  { ":3rd_place_medal:",                       "&#x1f949;"                            },
  { ":8ball:",                                 "&#x1f3b1;"                            },
  { ":a:",                                     "&#x1f170;"                            },
  { ":ab:",                                    "&#x1f18e;"                            },
  { ":abacus:",                                "&#x1f9ee;"                            },
  { ":abc:",                                   "&#x1f524;"                            },
  { ":abcd:",                                  "&#x1f521;"                            },
  { ":accept:",                                "&#x1f251;"                            },
  { ":accordion:",                             "&#x1fa97;"                            },
  { ":adhesive_bandage:",                      "&#x1fa79;"                            },
  { ":adult:",                                 "&#x1f9d1;"                            },
  { ":aerial_tramway:",                        "&#x1f6a1;"                            },
  { ":afghanistan:",                           "&#x1f1e6;&#x1f1eb;"                   },
  { ":airplane:",                              "&#x2708;"                             },
  { ":aland_islands:",                         "&#x1f1e6;&#x1f1fd;"                   },
  { ":alarm_clock:",                           "&#x23f0;"                             },
  { ":albania:",                               "&#x1f1e6;&#x1f1f1;"                   },
  { ":alembic:",                               "&#x2697;"                             },
  { ":algeria:",                               "&#x1f1e9;&#x1f1ff;"                   },
  { ":alien:",                                 "&#x1f47d;"                            },
  { ":ambulance:",                             "&#x1f691;"                            },
  { ":american_samoa:",                        "&#x1f1e6;&#x1f1f8;"                   },
  { ":amphora:",                               "&#x1f3fa;"                            },
  { ":anatomical_heart:",                      "&#x1fac0;"                            },
  { ":anchor:",                                "&#x2693;"                             },
  { ":andorra:",                               "&#x1f1e6;&#x1f1e9;"                   },
  { ":angel:",                                 "&#x1f47c;"                            },
  { ":anger:",                                 "&#x1f4a2;"                            },
  { ":angola:",                                "&#x1f1e6;&#x1f1f4;"                   },
  { ":angry:",                                 "&#x1f620;"                            },
  { ":anguilla:",                              "&#x1f1e6;&#x1f1ee;"                   },
  { ":anguished:",                             "&#x1f627;"                            },
  { ":ant:",                                   "&#x1f41c;"                            },
  { ":antarctica:",                            "&#x1f1e6;&#x1f1f6;"                   },
  { ":antigua_barbuda:",                       "&#x1f1e6;&#x1f1ec;"                   },
  { ":apple:",                                 "&#x1f34e;"                            },
  { ":aquarius:",                              "&#x2652;"                             },
  { ":argentina:",                             "&#x1f1e6;&#x1f1f7;"                   },
  { ":aries:",                                 "&#x2648;"                             },
  { ":armenia:",                               "&#x1f1e6;&#x1f1f2;"                   },
  { ":arrow_backward:",                        "&#x25c0;"                             },
  { ":arrow_double_down:",                     "&#x23ec;"                             },
  { ":arrow_double_up:",                       "&#x23eb;"                             },
  { ":arrow_down:",                            "&#x2b07;"                             },
  { ":arrow_down_small:",                      "&#x1f53d;"                            },
  { ":arrow_forward:",                         "&#x25b6;"                             },
  { ":arrow_heading_down:",                    "&#x2935;"                             },
  { ":arrow_heading_up:",                      "&#x2934;"                             },
  { ":arrow_left:",                            "&#x2b05;"                             },
  { ":arrow_lower_left:",                      "&#x2199;"                             },
  { ":arrow_lower_right:",                     "&#x2198;"                             },
  { ":arrow_right:",                           "&#x27a1;"                             },
  { ":arrow_right_hook:",                      "&#x21aa;"                             },
  { ":arrow_up:",                              "&#x2b06;"                             },
  { ":arrow_up_down:",                         "&#x2195;"                             },
  { ":arrow_up_small:",                        "&#x1f53c;"                            },
  { ":arrow_upper_left:",                      "&#x2196;"                             },
  { ":arrow_upper_right:",                     "&#x2197;"                             },
  { ":arrows_clockwise:",                      "&#x1f503;"                            },
  { ":arrows_counterclockwise:",               "&#x1f504;"                            },
  { ":art:",                                   "&#x1f3a8;"                            },
  { ":articulated_lorry:",                     "&#x1f69b;"                            },
  { ":artificial_satellite:",                  "&#x1f6f0;"                            },
  { ":artist:",                                "&#x1f9d1;&#x200d;&#x1f3a8;"           },
  { ":aruba:",                                 "&#x1f1e6;&#x1f1fc;"                   },
  { ":ascension_island:",                      "&#x1f1e6;&#x1f1e8;"                   },
  { ":asterisk:",                              "&#x002a;&#xfe0f;&#x20e3;"             },
  { ":astonished:",                            "&#x1f632;"                            },
  { ":astronaut:",                             "&#x1f9d1;&#x200d;&#x1f680;"           },
  { ":athletic_shoe:",                         "&#x1f45f;"                            },
  { ":atm:",                                   "&#x1f3e7;"                            },
  { ":atom_symbol:",                           "&#x269b;"                             },
  { ":australia:",                             "&#x1f1e6;&#x1f1fa;"                   },
  { ":austria:",                               "&#x1f1e6;&#x1f1f9;"                   },
  { ":auto_rickshaw:",                         "&#x1f6fa;"                            },
  { ":avocado:",                               "&#x1f951;"                            },
  { ":axe:",                                   "&#x1fa93;"                            },
  { ":azerbaijan:",                            "&#x1f1e6;&#x1f1ff;"                   },
  { ":b:",                                     "&#x1f171;"                            },
  { ":baby:",                                  "&#x1f476;"                            },
  { ":baby_bottle:",                           "&#x1f37c;"                            },
  { ":baby_chick:",                            "&#x1f424;"                            },
  { ":baby_symbol:",                           "&#x1f6bc;"                            },
  { ":back:",                                  "&#x1f519;"                            },
  { ":bacon:",                                 "&#x1f953;"                            },
  { ":badger:",                                "&#x1f9a1;"                            },
  { ":badminton:",                             "&#x1f3f8;"                            },
  { ":bagel:",                                 "&#x1f96f;"                            },
  { ":baggage_claim:",                         "&#x1f6c4;"                            },
  { ":baguette_bread:",                        "&#x1f956;"                            },
  { ":bahamas:",                               "&#x1f1e7;&#x1f1f8;"                   },
  { ":bahrain:",                               "&#x1f1e7;&#x1f1ed;"                   },
  { ":balance_scale:",                         "&#x2696;"                             },
  { ":bald_man:",                              "&#x1f468;&#x200d;&#x1f9b2;"           },
  { ":bald_woman:",                            "&#x1f469;&#x200d;&#x1f9b2;"           },
  { ":ballet_shoes:",                          "&#x1fa70;"                            },
  { ":balloon:",                               "&#x1f388;"                            },
  { ":ballot_box:",                            "&#x1f5f3;"                            },
  { ":ballot_box_with_check:",                 "&#x2611;"                             },
  { ":bamboo:",                                "&#x1f38d;"                            },
  { ":banana:",                                "&#x1f34c;"                            },
  { ":bangbang:",                              "&#x203c;"                             },
  { ":bangladesh:",                            "&#x1f1e7;&#x1f1e9;"                   },
  { ":banjo:",                                 "&#x1fa95;"                            },
  { ":bank:",                                  "&#x1f3e6;"                            },
  { ":bar_chart:",                             "&#x1f4ca;"                            },
  { ":barbados:",                              "&#x1f1e7;&#x1f1e7;"                   },
  { ":barber:",                                "&#x1f488;"                            },
  { ":baseball:",                              "&#x26be;"                             },
  { ":basket:",                                "&#x1f9fa;"                            },
  { ":basketball:",                            "&#x1f3c0;"                            },
  { ":basketball_man:",                        "&#x26f9;&#xfe0f;&#x200d;&#x2642;&#xfe0f;" },
  { ":basketball_woman:",                      "&#x26f9;&#xfe0f;&#x200d;&#x2640;&#xfe0f;" },
  { ":bat:",                                   "&#x1f987;"                            },
  { ":bath:",                                  "&#x1f6c0;"                            },
  { ":bathtub:",                               "&#x1f6c1;"                            },
  { ":battery:",                               "&#x1f50b;"                            },
  { ":beach_umbrella:",                        "&#x1f3d6;"                            },
  { ":bear:",                                  "&#x1f43b;"                            },
  { ":bearded_person:",                        "&#x1f9d4;"                            },
  { ":beaver:",                                "&#x1f9ab;"                            },
  { ":bed:",                                   "&#x1f6cf;"                            },
  { ":bee:",                                   "&#x1f41d;"                            },
  { ":beer:",                                  "&#x1f37a;"                            },
  { ":beers:",                                 "&#x1f37b;"                            },
  { ":beetle:",                                "&#x1fab2;"                            },
  { ":beginner:",                              "&#x1f530;"                            },
  { ":belarus:",                               "&#x1f1e7;&#x1f1fe;"                   },
  { ":belgium:",                               "&#x1f1e7;&#x1f1ea;"                   },
  { ":belize:",                                "&#x1f1e7;&#x1f1ff;"                   },
  { ":bell:",                                  "&#x1f514;"                            },
  { ":bell_pepper:",                           "&#x1fad1;"                            },
  { ":bellhop_bell:",                          "&#x1f6ce;"                            },
  { ":benin:",                                 "&#x1f1e7;&#x1f1ef;"                   },
  { ":bento:",                                 "&#x1f371;"                            },
  { ":bermuda:",                               "&#x1f1e7;&#x1f1f2;"                   },
  { ":beverage_box:",                          "&#x1f9c3;"                            },
  { ":bhutan:",                                "&#x1f1e7;&#x1f1f9;"                   },
  { ":bicyclist:",                             "&#x1f6b4;"                            },
  { ":bike:",                                  "&#x1f6b2;"                            },
  { ":biking_man:",                            "&#x1f6b4;&#x200d;&#x2642;&#xfe0f;"    },
  { ":biking_woman:",                          "&#x1f6b4;&#x200d;&#x2640;&#xfe0f;"    },
  { ":bikini:",                                "&#x1f459;"                            },
  { ":billed_cap:",                            "&#x1f9e2;"                            },
  { ":biohazard:",                             "&#x2623;"                             },
  { ":bird:",                                  "&#x1f426;"                            },
  { ":birthday:",                              "&#x1f382;"                            },
  { ":bison:",                                 "&#x1f9ac;"                            },
  { ":black_cat:",                             "&#x1f408;&#x200d;&#x2b1b;"            },
  { ":black_circle:",                          "&#x26ab;"                             },
  { ":black_flag:",                            "&#x1f3f4;"                            },
  { ":black_heart:",                           "&#x1f5a4;"                            },
  { ":black_joker:",                           "&#x1f0cf;"                            },
  { ":black_large_square:",                    "&#x2b1b;"                             },
  { ":black_medium_small_square:",             "&#x25fe;"                             },
  { ":black_medium_square:",                   "&#x25fc;"                             },
  { ":black_nib:",                             "&#x2712;"                             },
  { ":black_small_square:",                    "&#x25aa;"                             },
  { ":black_square_button:",                   "&#x1f532;"                            },
  { ":blond_haired_man:",                      "&#x1f471;&#x200d;&#x2642;&#xfe0f;"    },
  { ":blond_haired_person:",                   "&#x1f471;"                            },
  { ":blond_haired_woman:",                    "&#x1f471;&#x200d;&#x2640;&#xfe0f;"    },
  { ":blonde_woman:",                          "&#x1f471;&#x200d;&#x2640;&#xfe0f;"    },
  { ":blossom:",                               "&#x1f33c;"                            },
  { ":blowfish:",                              "&#x1f421;"                            },
  { ":blue_book:",                             "&#x1f4d8;"                            },
  { ":blue_car:",                              "&#x1f699;"                            },
  { ":blue_heart:",                            "&#x1f499;"                            },
  { ":blue_square:",                           "&#x1f7e6;"                            },
  { ":blueberries:",                           "&#x1fad0;"                            },
  { ":blush:",                                 "&#x1f60a;"                            },
  { ":boar:",                                  "&#x1f417;"                            },
  { ":boat:",                                  "&#x26f5;"                             },
  { ":bolivia:",                               "&#x1f1e7;&#x1f1f4;"                   },
  { ":bomb:",                                  "&#x1f4a3;"                            },
  { ":bone:",                                  "&#x1f9b4;"                            },
  { ":book:",                                  "&#x1f4d6;"                            },
  { ":bookmark:",                              "&#x1f516;"                            },
  { ":bookmark_tabs:",                         "&#x1f4d1;"                            },
  { ":books:",                                 "&#x1f4da;"                            },
  { ":boom:",                                  "&#x1f4a5;"                            },
  { ":boomerang:",                             "&#x1fa83;"                            },
  { ":boot:",                                  "&#x1f462;"                            },
  { ":bosnia_herzegovina:",                    "&#x1f1e7;&#x1f1e6;"                   },
  { ":botswana:",                              "&#x1f1e7;&#x1f1fc;"                   },
  { ":bouncing_ball_man:",                     "&#x26f9;&#xfe0f;&#x200d;&#x2642;&#xfe0f;" },
  { ":bouncing_ball_person:",                  "&#x26f9;"                             },
  { ":bouncing_ball_woman:",                   "&#x26f9;&#xfe0f;&#x200d;&#x2640;&#xfe0f;" },
  { ":bouquet:",                               "&#x1f490;"                            },
  { ":bouvet_island:",                         "&#x1f1e7;&#x1f1fb;"                   },
  { ":bow:",                                   "&#x1f647;"                            },
  { ":bow_and_arrow:",                         "&#x1f3f9;"                            },
  { ":bowing_man:",                            "&#x1f647;&#x200d;&#x2642;&#xfe0f;"    },
  { ":bowing_woman:",                          "&#x1f647;&#x200d;&#x2640;&#xfe0f;"    },
  { ":bowl_with_spoon:",                       "&#x1f963;"                            },
  { ":bowling:",                               "&#x1f3b3;"                            },
  { ":boxing_glove:",                          "&#x1f94a;"                            },
  { ":boy:",                                   "&#x1f466;"                            },
  { ":brain:",                                 "&#x1f9e0;"                            },
  { ":brazil:",                                "&#x1f1e7;&#x1f1f7;"                   },
  { ":bread:",                                 "&#x1f35e;"                            },
  { ":breast_feeding:",                        "&#x1f931;"                            },
  { ":bricks:",                                "&#x1f9f1;"                            },
  { ":bride_with_veil:",                       "&#x1f470;&#x200d;&#x2640;&#xfe0f;"    },
  { ":bridge_at_night:",                       "&#x1f309;"                            },
  { ":briefcase:",                             "&#x1f4bc;"                            },
  { ":british_indian_ocean_territory:",        "&#x1f1ee;&#x1f1f4;"                   },
  { ":british_virgin_islands:",                "&#x1f1fb;&#x1f1ec;"                   },
  { ":broccoli:",                              "&#x1f966;"                            },
  { ":broken_heart:",                          "&#x1f494;"                            },
  { ":broom:",                                 "&#x1f9f9;"                            },
  { ":brown_circle:",                          "&#x1f7e4;"                            },
  { ":brown_heart:",                           "&#x1f90e;"                            },
  { ":brown_square:",                          "&#x1f7eb;"                            },
  { ":brunei:",                                "&#x1f1e7;&#x1f1f3;"                   },
  { ":bubble_tea:",                            "&#x1f9cb;"                            },
  { ":bucket:",                                "&#x1faa3;"                            },
  { ":bug:",                                   "&#x1f41b;"                            },
  { ":building_construction:",                 "&#x1f3d7;"                            },
  { ":bulb:",                                  "&#x1f4a1;"                            },
  { ":bulgaria:",                              "&#x1f1e7;&#x1f1ec;"                   },
  { ":bullettrain_front:",                     "&#x1f685;"                            },
  { ":bullettrain_side:",                      "&#x1f684;"                            },
  { ":burkina_faso:",                          "&#x1f1e7;&#x1f1eb;"                   },
  { ":burrito:",                               "&#x1f32f;"                            },
  { ":burundi:",                               "&#x1f1e7;&#x1f1ee;"                   },
  { ":bus:",                                   "&#x1f68c;"                            },
  { ":business_suit_levitating:",              "&#x1f574;"                            },
  { ":busstop:",                               "&#x1f68f;"                            },
  { ":bust_in_silhouette:",                    "&#x1f464;"                            },
  { ":busts_in_silhouette:",                   "&#x1f465;"                            },
  { ":butter:",                                "&#x1f9c8;"                            },
  { ":butterfly:",                             "&#x1f98b;"                            },
  { ":cactus:",                                "&#x1f335;"                            },
  { ":cake:",                                  "&#x1f370;"                            },
  { ":calendar:",                              "&#x1f4c6;"                            },
  { ":call_me_hand:",                          "&#x1f919;"                            },
  { ":calling:",                               "&#x1f4f2;"                            },
  { ":cambodia:",                              "&#x1f1f0;&#x1f1ed;"                   },
  { ":camel:",                                 "&#x1f42b;"                            },
  { ":camera:",                                "&#x1f4f7;"                            },
  { ":camera_flash:",                          "&#x1f4f8;"                            },
  { ":cameroon:",                              "&#x1f1e8;&#x1f1f2;"                   },
  { ":camping:",                               "&#x1f3d5;"                            },
  { ":canada:",                                "&#x1f1e8;&#x1f1e6;"                   },
  { ":canary_islands:",                        "&#x1f1ee;&#x1f1e8;"                   },
  { ":cancer:",                                "&#x264b;"                             },
  { ":candle:",                                "&#x1f56f;"                            },
  { ":candy:",                                 "&#x1f36c;"                            },
  { ":canned_food:",                           "&#x1f96b;"                            },
  { ":canoe:",                                 "&#x1f6f6;"                            },
  { ":cape_verde:",                            "&#x1f1e8;&#x1f1fb;"                   },
  { ":capital_abcd:",                          "&#x1f520;"                            },
  { ":capricorn:",                             "&#x2651;"                             },
  { ":car:",                                   "&#x1f697;"                            },
  { ":card_file_box:",                         "&#x1f5c3;"                            },
  { ":card_index:",                            "&#x1f4c7;"                            },
  { ":card_index_dividers:",                   "&#x1f5c2;"                            },
  { ":caribbean_netherlands:",                 "&#x1f1e7;&#x1f1f6;"                   },
  { ":carousel_horse:",                        "&#x1f3a0;"                            },
  { ":carpentry_saw:",                         "&#x1fa9a;"                            },
  { ":carrot:",                                "&#x1f955;"                            },
  { ":cartwheeling:",                          "&#x1f938;"                            },
  { ":cat:",                                   "&#x1f431;"                            },
  { ":cat2:",                                  "&#x1f408;"                            },
  { ":cayman_islands:",                        "&#x1f1f0;&#x1f1fe;"                   },
  { ":cd:",                                    "&#x1f4bf;"                            },
  { ":central_african_republic:",              "&#x1f1e8;&#x1f1eb;"                   },
  { ":ceuta_melilla:",                         "&#x1f1ea;&#x1f1e6;"                   },
  { ":chad:",                                  "&#x1f1f9;&#x1f1e9;"                   },
  { ":chains:",                                "&#x26d3;"                             },
  { ":chair:",                                 "&#x1fa91;"                            },
  { ":champagne:",                             "&#x1f37e;"                            },
  { ":chart:",                                 "&#x1f4b9;"                            },
  { ":chart_with_downwards_trend:",            "&#x1f4c9;"                            },
  { ":chart_with_upwards_trend:",              "&#x1f4c8;"                            },
  { ":checkered_flag:",                        "&#x1f3c1;"                            },
  { ":cheese:",                                "&#x1f9c0;"                            },
  { ":cherries:",                              "&#x1f352;"                            },
  { ":cherry_blossom:",                        "&#x1f338;"                            },
  { ":chess_pawn:",                            "&#x265f;"                             },
  { ":chestnut:",                              "&#x1f330;"                            },
  { ":chicken:",                               "&#x1f414;"                            },
  { ":child:",                                 "&#x1f9d2;"                            },
  { ":children_crossing:",                     "&#x1f6b8;"                            },
  { ":chile:",                                 "&#x1f1e8;&#x1f1f1;"                   },
  { ":chipmunk:",                              "&#x1f43f;"                            },
  { ":chocolate_bar:",                         "&#x1f36b;"                            },
  { ":chopsticks:",                            "&#x1f962;"                            },
  { ":christmas_island:",                      "&#x1f1e8;&#x1f1fd;"                   },
  { ":christmas_tree:",                        "&#x1f384;"                            },
  { ":church:",                                "&#x26ea;"                             },
  { ":cinema:",                                "&#x1f3a6;"                            },
  { ":circus_tent:",                           "&#x1f3aa;"                            },
  { ":city_sunrise:",                          "&#x1f307;"                            },
  { ":city_sunset:",                           "&#x1f306;"                            },
  { ":cityscape:",                             "&#x1f3d9;"                            },
  { ":cl:",                                    "&#x1f191;"                            },
  { ":clamp:",                                 "&#x1f5dc;"                            },
  { ":clap:",                                  "&#x1f44f;"                            },
  { ":clapper:",                               "&#x1f3ac;"                            },
  { ":classical_building:",                    "&#x1f3db;"                            },
  { ":climbing:",                              "&#x1f9d7;"                            },
  { ":climbing_man:",                          "&#x1f9d7;&#x200d;&#x2642;&#xfe0f;"    },
  { ":climbing_woman:",                        "&#x1f9d7;&#x200d;&#x2640;&#xfe0f;"    },
  { ":clinking_glasses:",                      "&#x1f942;"                            },
  { ":clipboard:",                             "&#x1f4cb;"                            },
  { ":clipperton_island:",                     "&#x1f1e8;&#x1f1f5;"                   },
  { ":clock1:",                                "&#x1f550;"                            },
  { ":clock10:",                               "&#x1f559;"                            },
  { ":clock1030:",                             "&#x1f565;"                            },
  { ":clock11:",                               "&#x1f55a;"                            },
  { ":clock1130:",                             "&#x1f566;"                            },
  { ":clock12:",                               "&#x1f55b;"                            },
  { ":clock1230:",                             "&#x1f567;"                            },
  { ":clock130:",                              "&#x1f55c;"                            },
  { ":clock2:",                                "&#x1f551;"                            },
  { ":clock230:",                              "&#x1f55d;"                            },
  { ":clock3:",                                "&#x1f552;"                            },
  { ":clock330:",                              "&#x1f55e;"                            },
  { ":clock4:",                                "&#x1f553;"                            },
  { ":clock430:",                              "&#x1f55f;"                            },
  { ":clock5:",                                "&#x1f554;"                            },
  { ":clock530:",                              "&#x1f560;"                            },
  { ":clock6:",                                "&#x1f555;"                            },
  { ":clock630:",                              "&#x1f561;"                            },
  { ":clock7:",                                "&#x1f556;"                            },
  { ":clock730:",                              "&#x1f562;"                            },
  { ":clock8:",                                "&#x1f557;"                            },
  { ":clock830:",                              "&#x1f563;"                            },
  { ":clock9:",                                "&#x1f558;"                            },
  { ":clock930:",                              "&#x1f564;"                            },
  { ":closed_book:",                           "&#x1f4d5;"                            },
  { ":closed_lock_with_key:",                  "&#x1f510;"                            },
  { ":closed_umbrella:",                       "&#x1f302;"                            },
  { ":cloud:",                                 "&#x2601;"                             },
  { ":cloud_with_lightning:",                  "&#x1f329;"                            },
  { ":cloud_with_lightning_and_rain:",         "&#x26c8;"                             },
  { ":cloud_with_rain:",                       "&#x1f327;"                            },
  { ":cloud_with_snow:",                       "&#x1f328;"                            },
  { ":clown_face:",                            "&#x1f921;"                            },
  { ":clubs:",                                 "&#x2663;"                             },
  { ":cn:",                                    "&#x1f1e8;&#x1f1f3;"                   },
  { ":coat:",                                  "&#x1f9e5;"                            },
  { ":cockroach:",                             "&#x1fab3;"                            },
  { ":cocktail:",                              "&#x1f378;"                            },
  { ":coconut:",                               "&#x1f965;"                            },
  { ":cocos_islands:",                         "&#x1f1e8;&#x1f1e8;"                   },
  { ":coffee:",                                "&#x2615;"                             },
  { ":coffin:",                                "&#x26b0;"                             },
  { ":coin:",                                  "&#x1fa99;"                            },
  { ":cold_face:",                             "&#x1f976;"                            },
  { ":cold_sweat:",                            "&#x1f630;"                            },
  { ":collision:",                             "&#x1f4a5;"                            },
  { ":colombia:",                              "&#x1f1e8;&#x1f1f4;"                   },
  { ":comet:",                                 "&#x2604;"                             },
  { ":comoros:",                               "&#x1f1f0;&#x1f1f2;"                   },
  { ":compass:",                               "&#x1f9ed;"                            },
  { ":computer:",                              "&#x1f4bb;"                            },
  { ":computer_mouse:",                        "&#x1f5b1;"                            },
  { ":confetti_ball:",                         "&#x1f38a;"                            },
  { ":confounded:",                            "&#x1f616;"                            },
  { ":confused:",                              "&#x1f615;"                            },
  { ":congo_brazzaville:",                     "&#x1f1e8;&#x1f1ec;"                   },
  { ":congo_kinshasa:",                        "&#x1f1e8;&#x1f1e9;"                   },
  { ":congratulations:",                       "&#x3297;"                             },
  { ":construction:",                          "&#x1f6a7;"                            },
  { ":construction_worker:",                   "&#x1f477;"                            },
  { ":construction_worker_man:",               "&#x1f477;&#x200d;&#x2642;&#xfe0f;"    },
  { ":construction_worker_woman:",             "&#x1f477;&#x200d;&#x2640;&#xfe0f;"    },
  { ":control_knobs:",                         "&#x1f39b;"                            },
  { ":convenience_store:",                     "&#x1f3ea;"                            },
  { ":cook:",                                  "&#x1f9d1;&#x200d;&#x1f373;"           },
  { ":cook_islands:",                          "&#x1f1e8;&#x1f1f0;"                   },
  { ":cookie:",                                "&#x1f36a;"                            },
  { ":cool:",                                  "&#x1f192;"                            },
  { ":cop:",                                   "&#x1f46e;"                            },
  { ":copyright:",                             "&#x00a9;"                             },
  { ":corn:",                                  "&#x1f33d;"                            },
  { ":costa_rica:",                            "&#x1f1e8;&#x1f1f7;"                   },
  { ":cote_divoire:",                          "&#x1f1e8;&#x1f1ee;"                   },
  { ":couch_and_lamp:",                        "&#x1f6cb;"                            },
  { ":couple:",                                "&#x1f46b;"                            },
  { ":couple_with_heart:",                     "&#x1f491;"                            },
  { ":couple_with_heart_man_man:",             "&#x1f468;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f468;" },
  { ":couple_with_heart_woman_man:",           "&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f468;" },
  { ":couple_with_heart_woman_woman:",         "&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f469;" },
  { ":couplekiss:",                            "&#x1f48f;"                            },
  { ":couplekiss_man_man:",                    "&#x1f468;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f468;" },
  { ":couplekiss_man_woman:",                  "&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f468;" },
  { ":couplekiss_woman_woman:",                "&#x1f469;&#x200d;&#x2764;&#xfe0f;&#x200d;&#x1f48b;&#x200d;&#x1f469;" },
  { ":cow:",                                   "&#x1f42e;"                            },
  { ":cow2:",                                  "&#x1f404;"                            },
  { ":cowboy_hat_face:",                       "&#x1f920;"                            },
  { ":crab:",                                  "&#x1f980;"                            },
  { ":crayon:",                                "&#x1f58d;"                            },
  { ":credit_card:",                           "&#x1f4b3;"                            },
  { ":crescent_moon:",                         "&#x1f319;"                            },
  { ":cricket:",                               "&#x1f997;"                            },
  { ":cricket_game:",                          "&#x1f3cf;"                            },
  { ":croatia:",                               "&#x1f1ed;&#x1f1f7;"                   },
  { ":crocodile:",                             "&#x1f40a;"                            },
  { ":croissant:",                             "&#x1f950;"                            },
  { ":crossed_fingers:",                       "&#x1f91e;"                            },
  { ":crossed_flags:",                         "&#x1f38c;"                            },
  { ":crossed_swords:",                        "&#x2694;"                             },
  { ":crown:",                                 "&#x1f451;"                            },
  { ":cry:",                                   "&#x1f622;"                            },
  { ":crying_cat_face:",                       "&#x1f63f;"                            },
  { ":crystal_ball:",                          "&#x1f52e;"                            },
  { ":cuba:",                                  "&#x1f1e8;&#x1f1fa;"                   },
  { ":cucumber:",                              "&#x1f952;"                            },
  { ":cup_with_straw:",                        "&#x1f964;"                            },
  { ":cupcake:",                               "&#x1f9c1;"                            },
  { ":cupid:",                                 "&#x1f498;"                            },
  { ":curacao:",                               "&#x1f1e8;&#x1f1fc;"                   },
  { ":curling_stone:",                         "&#x1f94c;"                            },
  { ":curly_haired_man:",                      "&#x1f468;&#x200d;&#x1f9b1;"           },
  { ":curly_haired_woman:",                    "&#x1f469;&#x200d;&#x1f9b1;"           },
  { ":curly_loop:",                            "&#x27b0;"                             },
  { ":currency_exchange:",                     "&#x1f4b1;"                            },
  { ":curry:",                                 "&#x1f35b;"                            },
  { ":cursing_face:",                          "&#x1f92c;"                            },
  { ":custard:",                               "&#x1f36e;"                            },
  { ":customs:",                               "&#x1f6c3;"                            },
  { ":cut_of_meat:",                           "&#x1f969;"                            },
  { ":cyclone:",                               "&#x1f300;"                            },
  { ":cyprus:",                                "&#x1f1e8;&#x1f1fe;"                   },
  { ":czech_republic:",                        "&#x1f1e8;&#x1f1ff;"                   },
  { ":dagger:",                                "&#x1f5e1;"                            },
  { ":dancer:",                                "&#x1f483;"                            },
  { ":dancers:",                               "&#x1f46f;"                            },
  { ":dancing_men:",                           "&#x1f46f;&#x200d;&#x2642;&#xfe0f;"    },
  { ":dancing_women:",                         "&#x1f46f;&#x200d;&#x2640;&#xfe0f;"    },
  { ":dango:",                                 "&#x1f361;"                            },
  { ":dark_sunglasses:",                       "&#x1f576;"                            },
  { ":dart:",                                  "&#x1f3af;"                            },
  { ":dash:",                                  "&#x1f4a8;"                            },
  { ":date:",                                  "&#x1f4c5;"                            },
  { ":de:",                                    "&#x1f1e9;&#x1f1ea;"                   },
  { ":deaf_man:",                              "&#x1f9cf;&#x200d;&#x2642;&#xfe0f;"    },
  { ":deaf_person:",                           "&#x1f9cf;"                            },
  { ":deaf_woman:",                            "&#x1f9cf;&#x200d;&#x2640;&#xfe0f;"    },
  { ":deciduous_tree:",                        "&#x1f333;"                            },
  { ":deer:",                                  "&#x1f98c;"                            },
  { ":denmark:",                               "&#x1f1e9;&#x1f1f0;"                   },
  { ":department_store:",                      "&#x1f3ec;"                            },
  { ":derelict_house:",                        "&#x1f3da;"                            },
  { ":desert:",                                "&#x1f3dc;"                            },
  { ":desert_island:",                         "&#x1f3dd;"                            },
  { ":desktop_computer:",                      "&#x1f5a5;"                            },
  { ":detective:",                             "&#x1f575;"                            },
  { ":diamond_shape_with_a_dot_inside:",       "&#x1f4a0;"                            },
  { ":diamonds:",                              "&#x2666;"                             },
  { ":diego_garcia:",                          "&#x1f1e9;&#x1f1ec;"                   },
  { ":disappointed:",                          "&#x1f61e;"                            },
  { ":disappointed_relieved:",                 "&#x1f625;"                            },
  { ":disguised_face:",                        "&#x1f978;"                            },
  { ":diving_mask:",                           "&#x1f93f;"                            },
  { ":diya_lamp:",                             "&#x1fa94;"                            },
  { ":dizzy:",                                 "&#x1f4ab;"                            },
  { ":dizzy_face:",                            "&#x1f635;"                            },
  { ":djibouti:",                              "&#x1f1e9;&#x1f1ef;"                   },
  { ":dna:",                                   "&#x1f9ec;"                            },
  { ":do_not_litter:",                         "&#x1f6af;"                            },
  { ":dodo:",                                  "&#x1f9a4;"                            },
  { ":dog:",                                   "&#x1f436;"                            },
  { ":dog2:",                                  "&#x1f415;"                            },
  { ":dollar:",                                "&#x1f4b5;"                            },
  { ":dolls:",                                 "&#x1f38e;"                            },
  { ":dolphin:",                               "&#x1f42c;"                            },
  { ":dominica:",                              "&#x1f1e9;&#x1f1f2;"                   },
  { ":dominican_republic:",                    "&#x1f1e9;&#x1f1f4;"                   },
  { ":door:",                                  "&#x1f6aa;"                            },
  { ":doughnut:",                              "&#x1f369;"                            },
  { ":dove:",                                  "&#x1f54a;"                            },
  { ":dragon:",                                "&#x1f409;"                            },
  { ":dragon_face:",                           "&#x1f432;"                            },
  { ":dress:",                                 "&#x1f457;"                            },
  { ":dromedary_camel:",                       "&#x1f42a;"                            },
  { ":drooling_face:",                         "&#x1f924;"                            },
  { ":drop_of_blood:",                         "&#x1fa78;"                            },
  { ":droplet:",                               "&#x1f4a7;"                            },
  { ":drum:",                                  "&#x1f941;"                            },
  { ":duck:",                                  "&#x1f986;"                            },
  { ":dumpling:",                              "&#x1f95f;"                            },
  { ":dvd:",                                   "&#x1f4c0;"                            },
  { ":e-mail:",                                "&#x1f4e7;"                            },
  { ":eagle:",                                 "&#x1f985;"                            },
  { ":ear:",                                   "&#x1f442;"                            },
  { ":ear_of_rice:",                           "&#x1f33e;"                            },
  { ":ear_with_hearing_aid:",                  "&#x1f9bb;"                            },
  { ":earth_africa:",                          "&#x1f30d;"                            },
  { ":earth_americas:",                        "&#x1f30e;"                            },
  { ":earth_asia:",                            "&#x1f30f;"                            },
  { ":ecuador:",                               "&#x1f1ea;&#x1f1e8;"                   },
  { ":egg:",                                   "&#x1f95a;"                            },
  { ":eggplant:",                              "&#x1f346;"                            },
  { ":egypt:",                                 "&#x1f1ea;&#x1f1ec;"                   },
  { ":eight:",                                 "&#x0038;&#xfe0f;&#x20e3;"             },
  { ":eight_pointed_black_star:",              "&#x2734;"                             },
  { ":eight_spoked_asterisk:",                 "&#x2733;"                             },
  { ":eject_button:",                          "&#x23cf;"                             },
  { ":el_salvador:",                           "&#x1f1f8;&#x1f1fb;"                   },
  { ":electric_plug:",                         "&#x1f50c;"                            },
  { ":elephant:",                              "&#x1f418;"                            },
  { ":elevator:",                              "&#x1f6d7;"                            },
  { ":elf:",                                   "&#x1f9dd;"                            },
  { ":elf_man:",                               "&#x1f9dd;&#x200d;&#x2642;&#xfe0f;"    },
  { ":elf_woman:",                             "&#x1f9dd;&#x200d;&#x2640;&#xfe0f;"    },
  { ":email:",                                 "&#x1f4e7;"                            },
  { ":end:",                                   "&#x1f51a;"                            },
  { ":england:",                               "&#x1f3f4;&#xe0067;&#xe0062;&#xe0065;&#xe006e;&#xe0067;&#xe007f;" },
  { ":envelope:",                              "&#x2709;"                             },
  { ":envelope_with_arrow:",                   "&#x1f4e9;"                            },
  { ":equatorial_guinea:",                     "&#x1f1ec;&#x1f1f6;"                   },
  { ":eritrea:",                               "&#x1f1ea;&#x1f1f7;"                   },
  { ":es:",                                    "&#x1f1ea;&#x1f1f8;"                   },
  { ":estonia:",                               "&#x1f1ea;&#x1f1ea;"                   },
  { ":ethiopia:",                              "&#x1f1ea;&#x1f1f9;"                   },
  { ":eu:",                                    "&#x1f1ea;&#x1f1fa;"                   },
  { ":euro:",                                  "&#x1f4b6;"                            },
  { ":european_castle:",                       "&#x1f3f0;"                            },
  { ":european_post_office:",                  "&#x1f3e4;"                            },
  { ":european_union:",                        "&#x1f1ea;&#x1f1fa;"                   },
  { ":evergreen_tree:",                        "&#x1f332;"                            },
  { ":exclamation:",                           "&#x2757;"                             },
  { ":exploding_head:",                        "&#x1f92f;"                            },
  { ":expressionless:",                        "&#x1f611;"                            },
  { ":eye:",                                   "&#x1f441;&#xfe0f;&#x200d;&#x1f5e8;&#xfe0f;" },
  { ":eye_speech_bubble:",                     "&#x1f441;&#xfe0f;&#x200d;&#x1f5e8;&#xfe0f;" },
  { ":eyeglasses:",                            "&#x1f453;"                            },
  { ":eyes:",                                  "&#x1f440;"                            },
  { ":face_exhaling:",                         "&#x1f62e;&#x200d;&#x1f4a8;"           },
  { ":face_in_clouds:",                        "&#x1f636;&#x200d;&#x1f32b;&#xfe0f;"   },
  { ":face_with_head_bandage:",                "&#x1f915;"                            },
  { ":face_with_spiral_eyes:",                 "&#x1f635;&#x200d;&#x1f4ab;"           },
  { ":face_with_thermometer:",                 "&#x1f912;"                            },
  { ":facepalm:",                              "&#x1f926;"                            },
  { ":facepunch:",                             "&#x1f44a;"                            },
  { ":factory:",                               "&#x1f3ed;"                            },
  { ":factory_worker:",                        "&#x1f9d1;&#x200d;&#x1f3ed;"           },
  { ":fairy:",                                 "&#x1f9da;"                            },
  { ":fairy_man:",                             "&#x1f9da;&#x200d;&#x2642;&#xfe0f;"    },
  { ":fairy_woman:",                           "&#x1f9da;&#x200d;&#x2640;&#xfe0f;"    },
  { ":falafel:",                               "&#x1f9c6;"                            },
  { ":falkland_islands:",                      "&#x1f1eb;&#x1f1f0;"                   },
  { ":fallen_leaf:",                           "&#x1f342;"                            },
  { ":family:",                                "&#x1f46a;"                            },
  { ":family_man_boy:",                        "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f466;" },
  { ":family_man_boy_boy:",                    "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f466;&#x200d;&#x1f466;" },
  { ":family_man_girl:",                       "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;" },
  { ":family_man_girl_boy:",                   "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f466;" },
  { ":family_man_girl_girl:",                  "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f467;" },
  { ":family_man_man_boy:",                    "&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f466;" },
  { ":family_man_man_boy_boy:",                "&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f466;&#x200d;&#x1f466;" },
  { ":family_man_man_girl:",                   "&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f467;" },
  { ":family_man_man_girl_boy:",               "&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f467;&#x200d;&#x1f466;" },
  { ":family_man_man_girl_girl:",              "&#x1f468;&#x200d;&#x1f468;&#x200d;&#x1f467;&#x200d;&#x1f467;" },
  { ":family_man_woman_boy:",                  "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f466;" },
  { ":family_man_woman_boy_boy:",              "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f466;&#x200d;&#x1f466;" },
  { ":family_man_woman_girl:",                 "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;" },
  { ":family_man_woman_girl_boy:",             "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f466;" },
  { ":family_man_woman_girl_girl:",            "&#x1f468;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f467;" },
  { ":family_woman_boy:",                      "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f466;" },
  { ":family_woman_boy_boy:",                  "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f466;&#x200d;&#x1f466;" },
  { ":family_woman_girl:",                     "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;" },
  { ":family_woman_girl_boy:",                 "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f466;" },
  { ":family_woman_girl_girl:",                "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f467;" },
  { ":family_woman_woman_boy:",                "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f466;" },
  { ":family_woman_woman_boy_boy:",            "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f466;&#x200d;&#x1f466;" },
  { ":family_woman_woman_girl:",               "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;" },
  { ":family_woman_woman_girl_boy:",           "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f466;" },
  { ":family_woman_woman_girl_girl:",          "&#x1f469;&#x200d;&#x1f469;&#x200d;&#x1f467;&#x200d;&#x1f467;" },
  { ":farmer:",                                "&#x1f9d1;&#x200d;&#x1f33e;"           },
  { ":faroe_islands:",                         "&#x1f1eb;&#x1f1f4;"                   },
  { ":fast_forward:",                          "&#x23e9;"                             },
  { ":fax:",                                   "&#x1f4e0;"                            },
  { ":fearful:",                               "&#x1f628;"                            },
  { ":feather:",                               "&#x1fab6;"                            },
  { ":feet:",                                  "&#x1f43e;"                            },
  { ":female_detective:",                      "&#x1f575;&#xfe0f;&#x200d;&#x2640;&#xfe0f;" },
  { ":female_sign:",                           "&#x2640;"                             },
  { ":ferris_wheel:",                          "&#x1f3a1;"                            },
  { ":ferry:",                                 "&#x26f4;"                             },
  { ":field_hockey:",                          "&#x1f3d1;"                            },
  { ":fiji:",                                  "&#x1f1eb;&#x1f1ef;"                   },
  { ":file_cabinet:",                          "&#x1f5c4;"                            },
  { ":file_folder:",                           "&#x1f4c1;"                            },
  { ":film_projector:",                        "&#x1f4fd;"                            },
  { ":film_strip:",                            "&#x1f39e;"                            },
  { ":finland:",                               "&#x1f1eb;&#x1f1ee;"                   },
  { ":fire:",                                  "&#x1f525;"                            },
  { ":fire_engine:",                           "&#x1f692;"                            },
  { ":fire_extinguisher:",                     "&#x1f9ef;"                            },
  { ":firecracker:",                           "&#x1f9e8;"                            },
  { ":firefighter:",                           "&#x1f9d1;&#x200d;&#x1f692;"           },
  { ":fireworks:",                             "&#x1f386;"                            },
  { ":first_quarter_moon:",                    "&#x1f313;"                            },
  { ":first_quarter_moon_with_face:",          "&#x1f31b;"                            },
  { ":fish:",                                  "&#x1f41f;"                            },
  { ":fish_cake:",                             "&#x1f365;"                            },
  { ":fishing_pole_and_fish:",                 "&#x1f3a3;"                            },
  { ":fist:",                                  "&#x270a;"                             },
  { ":fist_left:",                             "&#x1f91b;"                            },
  { ":fist_oncoming:",                         "&#x1f44a;"                            },
  { ":fist_raised:",                           "&#x270a;"                             },
  { ":fist_right:",                            "&#x1f91c;"                            },
  { ":five:",                                  "&#x0035;&#xfe0f;&#x20e3;"             },
  { ":flags:",                                 "&#x1f38f;"                            },
  { ":flamingo:",                              "&#x1f9a9;"                            },
  { ":flashlight:",                            "&#x1f526;"                            },
  { ":flat_shoe:",                             "&#x1f97f;"                            },
  { ":flatbread:",                             "&#x1fad3;"                            },
  { ":fleur_de_lis:",                          "&#x269c;"                             },
  { ":flight_arrival:",                        "&#x1f6ec;"                            },
  { ":flight_departure:",                      "&#x1f6eb;"                            },
  { ":flipper:",                               "&#x1f42c;"                            },
  { ":floppy_disk:",                           "&#x1f4be;"                            },
  { ":flower_playing_cards:",                  "&#x1f3b4;"                            },
  { ":flushed:",                               "&#x1f633;"                            },
  { ":fly:",                                   "&#x1fab0;"                            },
  { ":flying_disc:",                           "&#x1f94f;"                            },
  { ":flying_saucer:",                         "&#x1f6f8;"                            },
  { ":fog:",                                   "&#x1f32b;"                            },
  { ":foggy:",                                 "&#x1f301;"                            },
  { ":fondue:",                                "&#x1fad5;"                            },
  { ":foot:",                                  "&#x1f9b6;"                            },
  { ":football:",                              "&#x1f3c8;"                            },
  { ":footprints:",                            "&#x1f463;"                            },
  { ":fork_and_knife:",                        "&#x1f374;"                            },
  { ":fortune_cookie:",                        "&#x1f960;"                            },
  { ":fountain:",                              "&#x26f2;"                             },
  { ":fountain_pen:",                          "&#x1f58b;"                            },
  { ":four:",                                  "&#x0034;&#xfe0f;&#x20e3;"             },
  { ":four_leaf_clover:",                      "&#x1f340;"                            },
  { ":fox_face:",                              "&#x1f98a;"                            },
  { ":fr:",                                    "&#x1f1eb;&#x1f1f7;"                   },
  { ":framed_picture:",                        "&#x1f5bc;"                            },
  { ":free:",                                  "&#x1f193;"                            },
  { ":french_guiana:",                         "&#x1f1ec;&#x1f1eb;"                   },
  { ":french_polynesia:",                      "&#x1f1f5;&#x1f1eb;"                   },
  { ":french_southern_territories:",           "&#x1f1f9;&#x1f1eb;"                   },
  { ":fried_egg:",                             "&#x1f373;"                            },
  { ":fried_shrimp:",                          "&#x1f364;"                            },
  { ":fries:",                                 "&#x1f35f;"                            },
  { ":frog:",                                  "&#x1f438;"                            },
  { ":frowning:",                              "&#x1f626;"                            },
  { ":frowning_face:",                         "&#x2639;"                             },
  { ":frowning_man:",                          "&#x1f64d;&#x200d;&#x2642;&#xfe0f;"    },
  { ":frowning_person:",                       "&#x1f64d;"                            },
  { ":frowning_woman:",                        "&#x1f64d;&#x200d;&#x2640;&#xfe0f;"    },
  { ":fu:",                                    "&#x1f595;"                            },
  { ":fuelpump:",                              "&#x26fd;"                             },
  { ":full_moon:",                             "&#x1f315;"                            },
  { ":full_moon_with_face:",                   "&#x1f31d;"                            },
  { ":funeral_urn:",                           "&#x26b1;"                             },
  { ":gabon:",                                 "&#x1f1ec;&#x1f1e6;"                   },
  { ":gambia:",                                "&#x1f1ec;&#x1f1f2;"                   },
  { ":game_die:",                              "&#x1f3b2;"                            },
  { ":garlic:",                                "&#x1f9c4;"                            },
  { ":gb:",                                    "&#x1f1ec;&#x1f1e7;"                   },
  { ":gear:",                                  "&#x2699;"                             },
  { ":gem:",                                   "&#x1f48e;"                            },
  { ":gemini:",                                "&#x264a;"                             },
  { ":genie:",                                 "&#x1f9de;"                            },
  { ":genie_man:",                             "&#x1f9de;&#x200d;&#x2642;&#xfe0f;"    },
  { ":genie_woman:",                           "&#x1f9de;&#x200d;&#x2640;&#xfe0f;"    },
  { ":georgia:",                               "&#x1f1ec;&#x1f1ea;"                   },
  { ":ghana:",                                 "&#x1f1ec;&#x1f1ed;"                   },
  { ":ghost:",                                 "&#x1f47b;"                            },
  { ":gibraltar:",                             "&#x1f1ec;&#x1f1ee;"                   },
  { ":gift:",                                  "&#x1f381;"                            },
  { ":gift_heart:",                            "&#x1f49d;"                            },
  { ":giraffe:",                               "&#x1f992;"                            },
  { ":girl:",                                  "&#x1f467;"                            },
  { ":globe_with_meridians:",                  "&#x1f310;"                            },
  { ":gloves:",                                "&#x1f9e4;"                            },
  { ":goal_net:",                              "&#x1f945;"                            },
  { ":goat:",                                  "&#x1f410;"                            },
  { ":goggles:",                               "&#x1f97d;"                            },
  { ":golf:",                                  "&#x26f3;"                             },
  { ":golfing:",                               "&#x1f3cc;"                            },
  { ":golfing_man:",                           "&#x1f3cc;&#xfe0f;&#x200d;&#x2642;&#xfe0f;" },
  { ":golfing_woman:",                         "&#x1f3cc;&#xfe0f;&#x200d;&#x2640;&#xfe0f;" },
  { ":gorilla:",                               "&#x1f98d;"                            },
  { ":grapes:",                                "&#x1f347;"                            },
  { ":greece:",                                "&#x1f1ec;&#x1f1f7;"                   },
  { ":green_apple:",                           "&#x1f34f;"                            },
  { ":green_book:",                            "&#x1f4d7;"                            },
  { ":green_circle:",                          "&#x1f7e2;"                            },
  { ":green_heart:",                           "&#x1f49a;"                            },
  { ":green_salad:",                           "&#x1f957;"                            },
  { ":green_square:",                          "&#x1f7e9;"                            },
  { ":greenland:",                             "&#x1f1ec;&#x1f1f1;"                   },
  { ":grenada:",                               "&#x1f1ec;&#x1f1e9;"                   },
  { ":grey_exclamation:",                      "&#x2755;"                             },
  { ":grey_question:",                         "&#x2754;"                             },
  { ":grimacing:",                             "&#x1f62c;"                            },
  { ":grin:",                                  "&#x1f601;"                            },
  { ":grinning:",                              "&#x1f600;"                            },
  { ":guadeloupe:",                            "&#x1f1ec;&#x1f1f5;"                   },
  { ":guam:",                                  "&#x1f1ec;&#x1f1fa;"                   },
  { ":guard:",                                 "&#x1f482;"                            },
  { ":guardsman:",                             "&#x1f482;&#x200d;&#x2642;&#xfe0f;"    },
  { ":guardswoman:",                           "&#x1f482;&#x200d;&#x2640;&#xfe0f;"    },
  { ":guatemala:",                             "&#x1f1ec;&#x1f1f9;"                   },
  { ":guernsey:",                              "&#x1f1ec;&#x1f1ec;"                   },
  { ":guide_dog:",                             "&#x1f9ae;"                            },
  { ":guinea:",                                "&#x1f1ec;&#x1f1f3;"                   },
  { ":guinea_bissau:",                         "&#x1f1ec;&#x1f1fc;"                   },
  { ":guitar:",                                "&#x1f3b8;"                            },
  { ":gun:",                                   "&#x1f52b;"                            },
  { ":guyana:",                                "&#x1f1ec;&#x1f1fe;"                   },
  { ":haircut:",                               "&#x1f487;"                            },
  { ":haircut_man:",                           "&#x1f487;&#x200d;&#x2642;&#xfe0f;"    },
  { ":haircut_woman:",                         "&#x1f487;&#x200d;&#x2640;&#xfe0f;"    },
  { ":haiti:",                                 "&#x1f1ed;&#x1f1f9;"                   },
  { ":hamburger:",                             "&#x1f354;"                            },
  { ":hammer:",                                "&#x1f528;"                            },
  { ":hammer_and_pick:",                       "&#x2692;"                             },
  { ":hammer_and_wrench:",                     "&#x1f6e0;"                            },
  { ":hamster:",                               "&#x1f439;"                            },
  { ":hand:",                                  "&#x270b;"                             },
  { ":hand_over_mouth:",                       "&#x1f92d;"                            },
  { ":handbag:",                               "&#x1f45c;"                            },
  { ":handball_person:",                       "&#x1f93e;"                            },
  { ":handshake:",                             "&#x1f91d;"                            },
  { ":hankey:",                                "&#x1f4a9;"                            },
  { ":hash:",                                  "&#x0023;&#xfe0f;&#x20e3;"             },
  { ":hatched_chick:",                         "&#x1f425;"                            },
  { ":hatching_chick:",                        "&#x1f423;"                            },
  { ":headphones:",                            "&#x1f3a7;"                            },
  { ":headstone:",                             "&#x1faa6;"                            },
  { ":health_worker:",                         "&#x1f9d1;&#x200d;&#x2695;&#xfe0f;"    },
  { ":hear_no_evil:",                          "&#x1f649;"                            },
  { ":heard_mcdonald_islands:",                "&#x1f1ed;&#x1f1f2;"                   },
  { ":heart:",                                 "&#x2764;&#xfe0f;&#x200d;&#x1f525;"    },
  { ":heart_decoration:",                      "&#x1f49f;"                            },
  { ":heart_eyes:",                            "&#x1f60d;"                            },
  { ":heart_eyes_cat:",                        "&#x1f63b;"                            },
  { ":heart_on_fire:",                         "&#x2764;&#xfe0f;&#x200d;&#x1f525;"    },
  { ":heartbeat:",                             "&#x1f493;"                            },
  { ":heartpulse:",                            "&#x1f497;"                            },
  { ":hearts:",                                "&#x2665;"                             },
  { ":heavy_check_mark:",                      "&#x2714;"                             },
  { ":heavy_division_sign:",                   "&#x2797;"                             },
  { ":heavy_dollar_sign:",                     "&#x1f4b2;"                            },
  { ":heavy_exclamation_mark:",                "&#x2757;"                             },
  { ":heavy_heart_exclamation:",               "&#x2763;"                             },
  { ":heavy_minus_sign:",                      "&#x2796;"                             },
  { ":heavy_multiplication_x:",                "&#x2716;"                             },
  { ":heavy_plus_sign:",                       "&#x2795;"                             },
  { ":hedgehog:",                              "&#x1f994;"                            },
  { ":helicopter:",                            "&#x1f681;"                            },
  { ":herb:",                                  "&#x1f33f;"                            },
  { ":hibiscus:",                              "&#x1f33a;"                            },
  { ":high_brightness:",                       "&#x1f506;"                            },
  { ":high_heel:",                             "&#x1f460;"                            },
  { ":hiking_boot:",                           "&#x1f97e;"                            },
  { ":hindu_temple:",                          "&#x1f6d5;"                            },
  { ":hippopotamus:",                          "&#x1f99b;"                            },
  { ":hocho:",                                 "&#x1f52a;"                            },
  { ":hole:",                                  "&#x1f573;"                            },
  { ":honduras:",                              "&#x1f1ed;&#x1f1f3;"                   },
  { ":honey_pot:",                             "&#x1f36f;"                            },
  { ":honeybee:",                              "&#x1f41d;"                            },
  { ":hong_kong:",                             "&#x1f1ed;&#x1f1f0;"                   },
  { ":hook:",                                  "&#x1fa9d;"                            },
  { ":horse:",                                 "&#x1f434;"                            },
  { ":horse_racing:",                          "&#x1f3c7;"                            },
  { ":hospital:",                              "&#x1f3e5;"                            },
  { ":hot_face:",                              "&#x1f975;"                            },
  { ":hot_pepper:",                            "&#x1f336;"                            },
  { ":hotdog:",                                "&#x1f32d;"                            },
  { ":hotel:",                                 "&#x1f3e8;"                            },
  { ":hotsprings:",                            "&#x2668;"                             },
  { ":hourglass:",                             "&#x231b;"                             },
  { ":hourglass_flowing_sand:",                "&#x23f3;"                             },
  { ":house:",                                 "&#x1f3e0;"                            },
  { ":house_with_garden:",                     "&#x1f3e1;"                            },
  { ":houses:",                                "&#x1f3d8;"                            },
  { ":hugs:",                                  "&#x1f917;"                            },
  { ":hungary:",                               "&#x1f1ed;&#x1f1fa;"                   },
  { ":hushed:",                                "&#x1f62f;"                            },
  { ":hut:",                                   "&#x1f6d6;"                            },
  { ":ice_cream:",                             "&#x1f368;"                            },
  { ":ice_cube:",                              "&#x1f9ca;"                            },
  { ":ice_hockey:",                            "&#x1f3d2;"                            },
  { ":ice_skate:",                             "&#x26f8;"                             },
  { ":icecream:",                              "&#x1f366;"                            },
  { ":iceland:",                               "&#x1f1ee;&#x1f1f8;"                   },
  { ":id:",                                    "&#x1f194;"                            },
  { ":ideograph_advantage:",                   "&#x1f250;"                            },
  { ":imp:",                                   "&#x1f47f;"                            },
  { ":inbox_tray:",                            "&#x1f4e5;"                            },
  { ":incoming_envelope:",                     "&#x1f4e8;"                            },
  { ":india:",                                 "&#x1f1ee;&#x1f1f3;"                   },
  { ":indonesia:",                             "&#x1f1ee;&#x1f1e9;"                   },
  { ":infinity:",                              "&#x267e;"                             },
  { ":information_desk_person:",               "&#x1f481;"                            },
  { ":information_source:",                    "&#x2139;"                             },
  { ":innocent:",                              "&#x1f607;"                            },
  { ":interrobang:",                           "&#x2049;"                             },
  { ":iphone:",                                "&#x1f4f1;"                            },
  { ":iran:",                                  "&#x1f1ee;&#x1f1f7;"                   },
  { ":iraq:",                                  "&#x1f1ee;&#x1f1f6;"                   },
  { ":ireland:",                               "&#x1f1ee;&#x1f1ea;"                   },
  { ":isle_of_man:",                           "&#x1f1ee;&#x1f1f2;"                   },
  { ":israel:",                                "&#x1f1ee;&#x1f1f1;"                   },
  { ":it:",                                    "&#x1f1ee;&#x1f1f9;"                   },
  { ":izakaya_lantern:",                       "&#x1f3ee;"                            },
  { ":jack_o_lantern:",                        "&#x1f383;"                            },
  { ":jamaica:",                               "&#x1f1ef;&#x1f1f2;"                   },
  { ":japan:",                                 "&#x1f5fe;"                            },
  { ":japanese_castle:",                       "&#x1f3ef;"                            },
  { ":japanese_goblin:",                       "&#x1f47a;"                            },
  { ":japanese_ogre:",                         "&#x1f479;"                            },
  { ":jeans:",                                 "&#x1f456;"                            },
  { ":jersey:",                                "&#x1f1ef;&#x1f1ea;"                   },
  { ":jigsaw:",                                "&#x1f9e9;"                            },
  { ":jordan:",                                "&#x1f1ef;&#x1f1f4;"                   },
  { ":joy:",                                   "&#x1f602;"                            },
  { ":joy_cat:",                               "&#x1f639;"                            },
  { ":joystick:",                              "&#x1f579;"                            },
  { ":jp:",                                    "&#x1f1ef;&#x1f1f5;"                   },
  { ":judge:",                                 "&#x1f9d1;&#x200d;&#x2696;&#xfe0f;"    },
  { ":juggling_person:",                       "&#x1f939;"                            },
  { ":kaaba:",                                 "&#x1f54b;"                            },
  { ":kangaroo:",                              "&#x1f998;"                            },
  { ":kazakhstan:",                            "&#x1f1f0;&#x1f1ff;"                   },
  { ":kenya:",                                 "&#x1f1f0;&#x1f1ea;"                   },
  { ":key:",                                   "&#x1f511;"                            },
  { ":keyboard:",                              "&#x2328;"                             },
  { ":keycap_ten:",                            "&#x1f51f;"                            },
  { ":kick_scooter:",                          "&#x1f6f4;"                            },
  { ":kimono:",                                "&#x1f458;"                            },
  { ":kiribati:",                              "&#x1f1f0;&#x1f1ee;"                   },
  { ":kiss:",                                  "&#x1f48b;"                            },
  { ":kissing:",                               "&#x1f617;"                            },
  { ":kissing_cat:",                           "&#x1f63d;"                            },
  { ":kissing_closed_eyes:",                   "&#x1f61a;"                            },
  { ":kissing_heart:",                         "&#x1f618;"                            },
  { ":kissing_smiling_eyes:",                  "&#x1f619;"                            },
  { ":kite:",                                  "&#x1fa81;"                            },
  { ":kiwi_fruit:",                            "&#x1f95d;"                            },
  { ":kneeling_man:",                          "&#x1f9ce;&#x200d;&#x2642;&#xfe0f;"    },
  { ":kneeling_person:",                       "&#x1f9ce;"                            },
  { ":kneeling_woman:",                        "&#x1f9ce;&#x200d;&#x2640;&#xfe0f;"    },
  { ":knife:",                                 "&#x1f52a;"                            },
  { ":knot:",                                  "&#x1faa2;"                            },
  { ":koala:",                                 "&#x1f428;"                            },
  { ":koko:",                                  "&#x1f201;"                            },
  { ":kosovo:",                                "&#x1f1fd;&#x1f1f0;"                   },
  { ":kr:",                                    "&#x1f1f0;&#x1f1f7;"                   },
  { ":kuwait:",                                "&#x1f1f0;&#x1f1fc;"                   },
  { ":kyrgyzstan:",                            "&#x1f1f0;&#x1f1ec;"                   },
  { ":lab_coat:",                              "&#x1f97c;"                            },
  { ":label:",                                 "&#x1f3f7;"                            },
  { ":lacrosse:",                              "&#x1f94d;"                            },
  { ":ladder:",                                "&#x1fa9c;"                            },
  { ":lady_beetle:",                           "&#x1f41e;"                            },
  { ":lantern:",                               "&#x1f3ee;"                            },
  { ":laos:",                                  "&#x1f1f1;&#x1f1e6;"                   },
  { ":large_blue_circle:",                     "&#x1f535;"                            },
  { ":large_blue_diamond:",                    "&#x1f537;"                            },
  { ":large_orange_diamond:",                  "&#x1f536;"                            },
  { ":last_quarter_moon:",                     "&#x1f317;"                            },
  { ":last_quarter_moon_with_face:",           "&#x1f31c;"                            },
  { ":latin_cross:",                           "&#x271d;"                             },
  { ":latvia:",                                "&#x1f1f1;&#x1f1fb;"                   },
  { ":laughing:",                              "&#x1f606;"                            },
  { ":leafy_green:",                           "&#x1f96c;"                            },
  { ":leaves:",                                "&#x1f343;"                            },
  { ":lebanon:",                               "&#x1f1f1;&#x1f1e7;"                   },
  { ":ledger:",                                "&#x1f4d2;"                            },
  { ":left_luggage:",                          "&#x1f6c5;"                            },
  { ":left_right_arrow:",                      "&#x2194;"                             },
  { ":left_speech_bubble:",                    "&#x1f5e8;"                            },
  { ":leftwards_arrow_with_hook:",             "&#x21a9;"                             },
  { ":leg:",                                   "&#x1f9b5;"                            },
  { ":lemon:",                                 "&#x1f34b;"                            },
  { ":leo:",                                   "&#x264c;"                             },
  { ":leopard:",                               "&#x1f406;"                            },
  { ":lesotho:",                               "&#x1f1f1;&#x1f1f8;"                   },
  { ":level_slider:",                          "&#x1f39a;"                            },
  { ":liberia:",                               "&#x1f1f1;&#x1f1f7;"                   },
  { ":libra:",                                 "&#x264e;"                             },
  { ":libya:",                                 "&#x1f1f1;&#x1f1fe;"                   },
  { ":liechtenstein:",                         "&#x1f1f1;&#x1f1ee;"                   },
  { ":light_rail:",                            "&#x1f688;"                            },
  { ":link:",                                  "&#x1f517;"                            },
  { ":lion:",                                  "&#x1f981;"                            },
  { ":lips:",                                  "&#x1f444;"                            },
  { ":lipstick:",                              "&#x1f484;"                            },
  { ":lithuania:",                             "&#x1f1f1;&#x1f1f9;"                   },
  { ":lizard:",                                "&#x1f98e;"                            },
  { ":llama:",                                 "&#x1f999;"                            },
  { ":lobster:",                               "&#x1f99e;"                            },
  { ":lock:",                                  "&#x1f512;"                            },
  { ":lock_with_ink_pen:",                     "&#x1f50f;"                            },
  { ":lollipop:",                              "&#x1f36d;"                            },
  { ":long_drum:",                             "&#x1fa98;"                            },
  { ":loop:",                                  "&#x27bf;"                             },
  { ":lotion_bottle:",                         "&#x1f9f4;"                            },
  { ":lotus_position:",                        "&#x1f9d8;"                            },
  { ":lotus_position_man:",                    "&#x1f9d8;&#x200d;&#x2642;&#xfe0f;"    },
  { ":lotus_position_woman:",                  "&#x1f9d8;&#x200d;&#x2640;&#xfe0f;"    },
  { ":loud_sound:",                            "&#x1f50a;"                            },
  { ":loudspeaker:",                           "&#x1f4e2;"                            },
  { ":love_hotel:",                            "&#x1f3e9;"                            },
  { ":love_letter:",                           "&#x1f48c;"                            },
  { ":love_you_gesture:",                      "&#x1f91f;"                            },
  { ":low_brightness:",                        "&#x1f505;"                            },
  { ":luggage:",                               "&#x1f9f3;"                            },
  { ":lungs:",                                 "&#x1fac1;"                            },
  { ":luxembourg:",                            "&#x1f1f1;&#x1f1fa;"                   },
  { ":lying_face:",                            "&#x1f925;"                            },
  { ":m:",                                     "&#x24c2;"                             },
  { ":macau:",                                 "&#x1f1f2;&#x1f1f4;"                   },
  { ":macedonia:",                             "&#x1f1f2;&#x1f1f0;"                   },
  { ":madagascar:",                            "&#x1f1f2;&#x1f1ec;"                   },
  { ":mag:",                                   "&#x1f50d;"                            },
  { ":mag_right:",                             "&#x1f50e;"                            },
  { ":mage:",                                  "&#x1f9d9;"                            },
  { ":mage_man:",                              "&#x1f9d9;&#x200d;&#x2642;&#xfe0f;"    },
  { ":mage_woman:",                            "&#x1f9d9;&#x200d;&#x2640;&#xfe0f;"    },
  { ":magic_wand:",                            "&#x1fa84;"                            },
  { ":magnet:",                                "&#x1f9f2;"                            },
  { ":mahjong:",                               "&#x1f004;"                            },
  { ":mailbox:",                               "&#x1f4eb;"                            },
  { ":mailbox_closed:",                        "&#x1f4ea;"                            },
  { ":mailbox_with_mail:",                     "&#x1f4ec;"                            },
  { ":mailbox_with_no_mail:",                  "&#x1f4ed;"                            },
  { ":malawi:",                                "&#x1f1f2;&#x1f1fc;"                   },
  { ":malaysia:",                              "&#x1f1f2;&#x1f1fe;"                   },
  { ":maldives:",                              "&#x1f1f2;&#x1f1fb;"                   },
  { ":male_detective:",                        "&#x1f575;&#xfe0f;&#x200d;&#x2642;&#xfe0f;" },
  { ":male_sign:",                             "&#x2642;"                             },
  { ":mali:",                                  "&#x1f1f2;&#x1f1f1;"                   },
  { ":malta:",                                 "&#x1f1f2;&#x1f1f9;"                   },
  { ":mammoth:",                               "&#x1f9a3;"                            },
  { ":man:",                                   "&#x1f468;"                            },
  { ":man_artist:",                            "&#x1f468;&#x200d;&#x1f3a8;"           },
  { ":man_astronaut:",                         "&#x1f468;&#x200d;&#x1f680;"           },
  { ":man_beard:",                             "&#x1f9d4;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_cartwheeling:",                      "&#x1f938;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_cook:",                              "&#x1f468;&#x200d;&#x1f373;"           },
  { ":man_dancing:",                           "&#x1f57a;"                            },
  { ":man_facepalming:",                       "&#x1f926;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_factory_worker:",                    "&#x1f468;&#x200d;&#x1f3ed;"           },
  { ":man_farmer:",                            "&#x1f468;&#x200d;&#x1f33e;"           },
  { ":man_feeding_baby:",                      "&#x1f468;&#x200d;&#x1f37c;"           },
  { ":man_firefighter:",                       "&#x1f468;&#x200d;&#x1f692;"           },
  { ":man_health_worker:",                     "&#x1f468;&#x200d;&#x2695;&#xfe0f;"    },
  { ":man_in_manual_wheelchair:",              "&#x1f468;&#x200d;&#x1f9bd;"           },
  { ":man_in_motorized_wheelchair:",           "&#x1f468;&#x200d;&#x1f9bc;"           },
  { ":man_in_tuxedo:",                         "&#x1f935;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_judge:",                             "&#x1f468;&#x200d;&#x2696;&#xfe0f;"    },
  { ":man_juggling:",                          "&#x1f939;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_mechanic:",                          "&#x1f468;&#x200d;&#x1f527;"           },
  { ":man_office_worker:",                     "&#x1f468;&#x200d;&#x1f4bc;"           },
  { ":man_pilot:",                             "&#x1f468;&#x200d;&#x2708;&#xfe0f;"    },
  { ":man_playing_handball:",                  "&#x1f93e;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_playing_water_polo:",                "&#x1f93d;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_scientist:",                         "&#x1f468;&#x200d;&#x1f52c;"           },
  { ":man_shrugging:",                         "&#x1f937;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_singer:",                            "&#x1f468;&#x200d;&#x1f3a4;"           },
  { ":man_student:",                           "&#x1f468;&#x200d;&#x1f393;"           },
  { ":man_teacher:",                           "&#x1f468;&#x200d;&#x1f3eb;"           },
  { ":man_technologist:",                      "&#x1f468;&#x200d;&#x1f4bb;"           },
  { ":man_with_gua_pi_mao:",                   "&#x1f472;"                            },
  { ":man_with_probing_cane:",                 "&#x1f468;&#x200d;&#x1f9af;"           },
  { ":man_with_turban:",                       "&#x1f473;&#x200d;&#x2642;&#xfe0f;"    },
  { ":man_with_veil:",                         "&#x1f470;&#x200d;&#x2642;&#xfe0f;"    },
  { ":mandarin:",                              "&#x1f34a;"                            },
  { ":mango:",                                 "&#x1f96d;"                            },
  { ":mans_shoe:",                             "&#x1f45e;"                            },
  { ":mantelpiece_clock:",                     "&#x1f570;"                            },
  { ":manual_wheelchair:",                     "&#x1f9bd;"                            },
  { ":maple_leaf:",                            "&#x1f341;"                            },
  { ":marshall_islands:",                      "&#x1f1f2;&#x1f1ed;"                   },
  { ":martial_arts_uniform:",                  "&#x1f94b;"                            },
  { ":martinique:",                            "&#x1f1f2;&#x1f1f6;"                   },
  { ":mask:",                                  "&#x1f637;"                            },
  { ":massage:",                               "&#x1f486;"                            },
  { ":massage_man:",                           "&#x1f486;&#x200d;&#x2642;&#xfe0f;"    },
  { ":massage_woman:",                         "&#x1f486;&#x200d;&#x2640;&#xfe0f;"    },
  { ":mate:",                                  "&#x1f9c9;"                            },
  { ":mauritania:",                            "&#x1f1f2;&#x1f1f7;"                   },
  { ":mauritius:",                             "&#x1f1f2;&#x1f1fa;"                   },
  { ":mayotte:",                               "&#x1f1fe;&#x1f1f9;"                   },
  { ":meat_on_bone:",                          "&#x1f356;"                            },
  { ":mechanic:",                              "&#x1f9d1;&#x200d;&#x1f527;"           },
  { ":mechanical_arm:",                        "&#x1f9be;"                            },
  { ":mechanical_leg:",                        "&#x1f9bf;"                            },
  { ":medal_military:",                        "&#x1f396;"                            },
  { ":medal_sports:",                          "&#x1f3c5;"                            },
  { ":medical_symbol:",                        "&#x2695;"                             },
  { ":mega:",                                  "&#x1f4e3;"                            },
  { ":melon:",                                 "&#x1f348;"                            },
  { ":memo:",                                  "&#x1f4dd;"                            },
  { ":men_wrestling:",                         "&#x1f93c;&#x200d;&#x2642;&#xfe0f;"    },
  { ":mending_heart:",                         "&#x2764;&#xfe0f;&#x200d;&#x1fa79;"    },
  { ":menorah:",                               "&#x1f54e;"                            },
  { ":mens:",                                  "&#x1f6b9;"                            },
  { ":mermaid:",                               "&#x1f9dc;&#x200d;&#x2640;&#xfe0f;"    },
  { ":merman:",                                "&#x1f9dc;&#x200d;&#x2642;&#xfe0f;"    },
  { ":merperson:",                             "&#x1f9dc;"                            },
  { ":metal:",                                 "&#x1f918;"                            },
  { ":metro:",                                 "&#x1f687;"                            },
  { ":mexico:",                                "&#x1f1f2;&#x1f1fd;"                   },
  { ":microbe:",                               "&#x1f9a0;"                            },
  { ":micronesia:",                            "&#x1f1eb;&#x1f1f2;"                   },
  { ":microphone:",                            "&#x1f3a4;"                            },
  { ":microscope:",                            "&#x1f52c;"                            },
  { ":middle_finger:",                         "&#x1f595;"                            },
  { ":military_helmet:",                       "&#x1fa96;"                            },
  { ":milk_glass:",                            "&#x1f95b;"                            },
  { ":milky_way:",                             "&#x1f30c;"                            },
  { ":minibus:",                               "&#x1f690;"                            },
  { ":minidisc:",                              "&#x1f4bd;"                            },
  { ":mirror:",                                "&#x1fa9e;"                            },
  { ":mobile_phone_off:",                      "&#x1f4f4;"                            },
  { ":moldova:",                               "&#x1f1f2;&#x1f1e9;"                   },
  { ":monaco:",                                "&#x1f1f2;&#x1f1e8;"                   },
  { ":money_mouth_face:",                      "&#x1f911;"                            },
  { ":money_with_wings:",                      "&#x1f4b8;"                            },
  { ":moneybag:",                              "&#x1f4b0;"                            },
  { ":mongolia:",                              "&#x1f1f2;&#x1f1f3;"                   },
  { ":monkey:",                                "&#x1f412;"                            },
  { ":monkey_face:",                           "&#x1f435;"                            },
  { ":monocle_face:",                          "&#x1f9d0;"                            },
  { ":monorail:",                              "&#x1f69d;"                            },
  { ":montenegro:",                            "&#x1f1f2;&#x1f1ea;"                   },
  { ":montserrat:",                            "&#x1f1f2;&#x1f1f8;"                   },
  { ":moon:",                                  "&#x1f314;"                            },
  { ":moon_cake:",                             "&#x1f96e;"                            },
  { ":morocco:",                               "&#x1f1f2;&#x1f1e6;"                   },
  { ":mortar_board:",                          "&#x1f393;"                            },
  { ":mosque:",                                "&#x1f54c;"                            },
  { ":mosquito:",                              "&#x1f99f;"                            },
  { ":motor_boat:",                            "&#x1f6e5;"                            },
  { ":motor_scooter:",                         "&#x1f6f5;"                            },
  { ":motorcycle:",                            "&#x1f3cd;"                            },
  { ":motorized_wheelchair:",                  "&#x1f9bc;"                            },
  { ":motorway:",                              "&#x1f6e3;"                            },
  { ":mount_fuji:",                            "&#x1f5fb;"                            },
  { ":mountain:",                              "&#x26f0;"                             },
  { ":mountain_bicyclist:",                    "&#x1f6b5;"                            },
  { ":mountain_biking_man:",                   "&#x1f6b5;&#x200d;&#x2642;&#xfe0f;"    },
  { ":mountain_biking_woman:",                 "&#x1f6b5;&#x200d;&#x2640;&#xfe0f;"    },
  { ":mountain_cableway:",                     "&#x1f6a0;"                            },
  { ":mountain_railway:",                      "&#x1f69e;"                            },
  { ":mountain_snow:",                         "&#x1f3d4;"                            },
  { ":mouse:",                                 "&#x1f42d;"                            },
  { ":mouse2:",                                "&#x1f401;"                            },
  { ":mouse_trap:",                            "&#x1faa4;"                            },
  { ":movie_camera:",                          "&#x1f3a5;"                            },
  { ":moyai:",                                 "&#x1f5ff;"                            },
  { ":mozambique:",                            "&#x1f1f2;&#x1f1ff;"                   },
  { ":mrs_claus:",                             "&#x1f936;"                            },
  { ":muscle:",                                "&#x1f4aa;"                            },
  { ":mushroom:",                              "&#x1f344;"                            },
  { ":musical_keyboard:",                      "&#x1f3b9;"                            },
  { ":musical_note:",                          "&#x1f3b5;"                            },
  { ":musical_score:",                         "&#x1f3bc;"                            },
  { ":mute:",                                  "&#x1f507;"                            },
  { ":mx_claus:",                              "&#x1f9d1;&#x200d;&#x1f384;"           },
  { ":myanmar:",                               "&#x1f1f2;&#x1f1f2;"                   },
  { ":nail_care:",                             "&#x1f485;"                            },
  { ":name_badge:",                            "&#x1f4db;"                            },
  { ":namibia:",                               "&#x1f1f3;&#x1f1e6;"                   },
  { ":national_park:",                         "&#x1f3de;"                            },
  { ":nauru:",                                 "&#x1f1f3;&#x1f1f7;"                   },
  { ":nauseated_face:",                        "&#x1f922;"                            },
  { ":nazar_amulet:",                          "&#x1f9ff;"                            },
  { ":necktie:",                               "&#x1f454;"                            },
  { ":negative_squared_cross_mark:",           "&#x274e;"                             },
  { ":nepal:",                                 "&#x1f1f3;&#x1f1f5;"                   },
  { ":nerd_face:",                             "&#x1f913;"                            },
  { ":nesting_dolls:",                         "&#x1fa86;"                            },
  { ":netherlands:",                           "&#x1f1f3;&#x1f1f1;"                   },
  { ":neutral_face:",                          "&#x1f610;"                            },
  { ":new:",                                   "&#x1f195;"                            },
  { ":new_caledonia:",                         "&#x1f1f3;&#x1f1e8;"                   },
  { ":new_moon:",                              "&#x1f311;"                            },
  { ":new_moon_with_face:",                    "&#x1f31a;"                            },
  { ":new_zealand:",                           "&#x1f1f3;&#x1f1ff;"                   },
  { ":newspaper:",                             "&#x1f4f0;"                            },
  { ":newspaper_roll:",                        "&#x1f5de;"                            },
  { ":next_track_button:",                     "&#x23ed;"                             },
  { ":ng:",                                    "&#x1f196;"                            },
  { ":ng_man:",                                "&#x1f645;&#x200d;&#x2642;&#xfe0f;"    },
  { ":ng_woman:",                              "&#x1f645;&#x200d;&#x2640;&#xfe0f;"    },
  { ":nicaragua:",                             "&#x1f1f3;&#x1f1ee;"                   },
  { ":niger:",                                 "&#x1f1f3;&#x1f1ea;"                   },
  { ":nigeria:",                               "&#x1f1f3;&#x1f1ec;"                   },
  { ":night_with_stars:",                      "&#x1f303;"                            },
  { ":nine:",                                  "&#x0039;&#xfe0f;&#x20e3;"             },
  { ":ninja:",                                 "&#x1f977;"                            },
  { ":niue:",                                  "&#x1f1f3;&#x1f1fa;"                   },
  { ":no_bell:",                               "&#x1f515;"                            },
  { ":no_bicycles:",                           "&#x1f6b3;"                            },
  { ":no_entry:",                              "&#x26d4;"                             },
  { ":no_entry_sign:",                         "&#x1f6ab;"                            },
  { ":no_good:",                               "&#x1f645;"                            },
  { ":no_good_man:",                           "&#x1f645;&#x200d;&#x2642;&#xfe0f;"    },
  { ":no_good_woman:",                         "&#x1f645;&#x200d;&#x2640;&#xfe0f;"    },
  { ":no_mobile_phones:",                      "&#x1f4f5;"                            },
  { ":no_mouth:",                              "&#x1f636;"                            },
  { ":no_pedestrians:",                        "&#x1f6b7;"                            },
  { ":no_smoking:",                            "&#x1f6ad;"                            },
  { ":non-potable_water:",                     "&#x1f6b1;"                            },
  { ":norfolk_island:",                        "&#x1f1f3;&#x1f1eb;"                   },
  { ":north_korea:",                           "&#x1f1f0;&#x1f1f5;"                   },
  { ":northern_mariana_islands:",              "&#x1f1f2;&#x1f1f5;"                   },
  { ":norway:",                                "&#x1f1f3;&#x1f1f4;"                   },
  { ":nose:",                                  "&#x1f443;"                            },
  { ":notebook:",                              "&#x1f4d3;"                            },
  { ":notebook_with_decorative_cover:",        "&#x1f4d4;"                            },
  { ":notes:",                                 "&#x1f3b6;"                            },
  { ":nut_and_bolt:",                          "&#x1f529;"                            },
  { ":o:",                                     "&#x2b55;"                             },
  { ":o2:",                                    "&#x1f17e;"                            },
  { ":ocean:",                                 "&#x1f30a;"                            },
  { ":octopus:",                               "&#x1f419;"                            },
  { ":oden:",                                  "&#x1f362;"                            },
  { ":office:",                                "&#x1f3e2;"                            },
  { ":office_worker:",                         "&#x1f9d1;&#x200d;&#x1f4bc;"           },
  { ":oil_drum:",                              "&#x1f6e2;"                            },
  { ":ok:",                                    "&#x1f197;"                            },
  { ":ok_hand:",                               "&#x1f44c;"                            },
  { ":ok_man:",                                "&#x1f646;&#x200d;&#x2642;&#xfe0f;"    },
  { ":ok_person:",                             "&#x1f646;"                            },
  { ":ok_woman:",                              "&#x1f646;&#x200d;&#x2640;&#xfe0f;"    },
  { ":old_key:",                               "&#x1f5dd;"                            },
  { ":older_adult:",                           "&#x1f9d3;"                            },
  { ":older_man:",                             "&#x1f474;"                            },
  { ":older_woman:",                           "&#x1f475;"                            },
  { ":olive:",                                 "&#x1fad2;"                            },
  { ":om:",                                    "&#x1f549;"                            },
  { ":oman:",                                  "&#x1f1f4;&#x1f1f2;"                   },
  { ":on:",                                    "&#x1f51b;"                            },
  { ":oncoming_automobile:",                   "&#x1f698;"                            },
  { ":oncoming_bus:",                          "&#x1f68d;"                            },
  { ":oncoming_police_car:",                   "&#x1f694;"                            },
  { ":oncoming_taxi:",                         "&#x1f696;"                            },
  { ":one:",                                   "&#x0031;&#xfe0f;&#x20e3;"             },
  { ":one_piece_swimsuit:",                    "&#x1fa71;"                            },
  { ":onion:",                                 "&#x1f9c5;"                            },
  { ":open_book:",                             "&#x1f4d6;"                            },
  { ":open_file_folder:",                      "&#x1f4c2;"                            },
  { ":open_hands:",                            "&#x1f450;"                            },
  { ":open_mouth:",                            "&#x1f62e;&#x200d;&#x1f4a8;"           },
  { ":open_umbrella:",                         "&#x2602;"                             },
  { ":ophiuchus:",                             "&#x26ce;"                             },
  { ":orange:",                                "&#x1f34a;"                            },
  { ":orange_book:",                           "&#x1f4d9;"                            },
  { ":orange_circle:",                         "&#x1f7e0;"                            },
  { ":orange_heart:",                          "&#x1f9e1;"                            },
  { ":orange_square:",                         "&#x1f7e7;"                            },
  { ":orangutan:",                             "&#x1f9a7;"                            },
  { ":orthodox_cross:",                        "&#x2626;"                             },
  { ":otter:",                                 "&#x1f9a6;"                            },
  { ":outbox_tray:",                           "&#x1f4e4;"                            },
  { ":owl:",                                   "&#x1f989;"                            },
  { ":ox:",                                    "&#x1f402;"                            },
  { ":oyster:",                                "&#x1f9aa;"                            },
  { ":package:",                               "&#x1f4e6;"                            },
  { ":page_facing_up:",                        "&#x1f4c4;"                            },
  { ":page_with_curl:",                        "&#x1f4c3;"                            },
  { ":pager:",                                 "&#x1f4df;"                            },
  { ":paintbrush:",                            "&#x1f58c;"                            },
  { ":pakistan:",                              "&#x1f1f5;&#x1f1f0;"                   },
  { ":palau:",                                 "&#x1f1f5;&#x1f1fc;"                   },
  { ":palestinian_territories:",               "&#x1f1f5;&#x1f1f8;"                   },
  { ":palm_tree:",                             "&#x1f334;"                            },
  { ":palms_up_together:",                     "&#x1f932;"                            },
  { ":panama:",                                "&#x1f1f5;&#x1f1e6;"                   },
  { ":pancakes:",                              "&#x1f95e;"                            },
  { ":panda_face:",                            "&#x1f43c;"                            },
  { ":paperclip:",                             "&#x1f4ce;"                            },
  { ":paperclips:",                            "&#x1f587;"                            },
  { ":papua_new_guinea:",                      "&#x1f1f5;&#x1f1ec;"                   },
  { ":parachute:",                             "&#x1fa82;"                            },
  { ":paraguay:",                              "&#x1f1f5;&#x1f1fe;"                   },
  { ":parasol_on_ground:",                     "&#x26f1;"                             },
  { ":parking:",                               "&#x1f17f;"                            },
  { ":parrot:",                                "&#x1f99c;"                            },
  { ":part_alternation_mark:",                 "&#x303d;"                             },
  { ":partly_sunny:",                          "&#x26c5;"                             },
  { ":partying_face:",                         "&#x1f973;"                            },
  { ":passenger_ship:",                        "&#x1f6f3;"                            },
  { ":passport_control:",                      "&#x1f6c2;"                            },
  { ":pause_button:",                          "&#x23f8;"                             },
  { ":paw_prints:",                            "&#x1f43e;"                            },
  { ":peace_symbol:",                          "&#x262e;"                             },
  { ":peach:",                                 "&#x1f351;"                            },
  { ":peacock:",                               "&#x1f99a;"                            },
  { ":peanuts:",                               "&#x1f95c;"                            },
  { ":pear:",                                  "&#x1f350;"                            },
  { ":pen:",                                   "&#x1f58a;"                            },
  { ":pencil:",                                "&#x1f4dd;"                            },
  { ":pencil2:",                               "&#x270f;"                             },
  { ":penguin:",                               "&#x1f427;"                            },
  { ":pensive:",                               "&#x1f614;"                            },
  { ":people_holding_hands:",                  "&#x1f9d1;&#x200d;&#x1f91d;&#x200d;&#x1f9d1;" },
  { ":people_hugging:",                        "&#x1fac2;"                            },
  { ":performing_arts:",                       "&#x1f3ad;"                            },
  { ":persevere:",                             "&#x1f623;"                            },
  { ":person_bald:",                           "&#x1f9d1;&#x200d;&#x1f9b2;"           },
  { ":person_curly_hair:",                     "&#x1f9d1;&#x200d;&#x1f9b1;"           },
  { ":person_feeding_baby:",                   "&#x1f9d1;&#x200d;&#x1f37c;"           },
  { ":person_fencing:",                        "&#x1f93a;"                            },
  { ":person_in_manual_wheelchair:",           "&#x1f9d1;&#x200d;&#x1f9bd;"           },
  { ":person_in_motorized_wheelchair:",        "&#x1f9d1;&#x200d;&#x1f9bc;"           },
  { ":person_in_tuxedo:",                      "&#x1f935;"                            },
  { ":person_red_hair:",                       "&#x1f9d1;&#x200d;&#x1f9b0;"           },
  { ":person_white_hair:",                     "&#x1f9d1;&#x200d;&#x1f9b3;"           },
  { ":person_with_probing_cane:",              "&#x1f9d1;&#x200d;&#x1f9af;"           },
  { ":person_with_turban:",                    "&#x1f473;"                            },
  { ":person_with_veil:",                      "&#x1f470;"                            },
  { ":peru:",                                  "&#x1f1f5;&#x1f1ea;"                   },
  { ":petri_dish:",                            "&#x1f9eb;"                            },
  { ":philippines:",                           "&#x1f1f5;&#x1f1ed;"                   },
  { ":phone:",                                 "&#x260e;"                             },
  { ":pick:",                                  "&#x26cf;"                             },
  { ":pickup_truck:",                          "&#x1f6fb;"                            },
  { ":pie:",                                   "&#x1f967;"                            },
  { ":pig:",                                   "&#x1f437;"                            },
  { ":pig2:",                                  "&#x1f416;"                            },
  { ":pig_nose:",                              "&#x1f43d;"                            },
  { ":pill:",                                  "&#x1f48a;"                            },
  { ":pilot:",                                 "&#x1f9d1;&#x200d;&#x2708;&#xfe0f;"    },
  { ":pinata:",                                "&#x1fa85;"                            },
  { ":pinched_fingers:",                       "&#x1f90c;"                            },
  { ":pinching_hand:",                         "&#x1f90f;"                            },
  { ":pineapple:",                             "&#x1f34d;"                            },
  { ":ping_pong:",                             "&#x1f3d3;"                            },
  { ":pirate_flag:",                           "&#x1f3f4;&#x200d;&#x2620;&#xfe0f;"    },
  { ":pisces:",                                "&#x2653;"                             },
  { ":pitcairn_islands:",                      "&#x1f1f5;&#x1f1f3;"                   },
  { ":pizza:",                                 "&#x1f355;"                            },
  { ":placard:",                               "&#x1faa7;"                            },
  { ":place_of_worship:",                      "&#x1f6d0;"                            },
  { ":plate_with_cutlery:",                    "&#x1f37d;"                            },
  { ":play_or_pause_button:",                  "&#x23ef;"                             },
  { ":pleading_face:",                         "&#x1f97a;"                            },
  { ":plunger:",                               "&#x1faa0;"                            },
  { ":point_down:",                            "&#x1f447;"                            },
  { ":point_left:",                            "&#x1f448;"                            },
  { ":point_right:",                           "&#x1f449;"                            },
  { ":point_up:",                              "&#x261d;"                             },
  { ":point_up_2:",                            "&#x1f446;"                            },
  { ":poland:",                                "&#x1f1f5;&#x1f1f1;"                   },
  { ":polar_bear:",                            "&#x1f43b;&#x200d;&#x2744;&#xfe0f;"    },
  { ":police_car:",                            "&#x1f693;"                            },
  { ":police_officer:",                        "&#x1f46e;"                            },
  { ":policeman:",                             "&#x1f46e;&#x200d;&#x2642;&#xfe0f;"    },
  { ":policewoman:",                           "&#x1f46e;&#x200d;&#x2640;&#xfe0f;"    },
  { ":poodle:",                                "&#x1f429;"                            },
  { ":poop:",                                  "&#x1f4a9;"                            },
  { ":popcorn:",                               "&#x1f37f;"                            },
  { ":portugal:",                              "&#x1f1f5;&#x1f1f9;"                   },
  { ":post_office:",                           "&#x1f3e3;"                            },
  { ":postal_horn:",                           "&#x1f4ef;"                            },
  { ":postbox:",                               "&#x1f4ee;"                            },
  { ":potable_water:",                         "&#x1f6b0;"                            },
  { ":potato:",                                "&#x1f954;"                            },
  { ":potted_plant:",                          "&#x1fab4;"                            },
  { ":pouch:",                                 "&#x1f45d;"                            },
  { ":poultry_leg:",                           "&#x1f357;"                            },
  { ":pound:",                                 "&#x1f4b7;"                            },
  { ":pout:",                                  "&#x1f621;"                            },
  { ":pouting_cat:",                           "&#x1f63e;"                            },
  { ":pouting_face:",                          "&#x1f64e;"                            },
  { ":pouting_man:",                           "&#x1f64e;&#x200d;&#x2642;&#xfe0f;"    },
  { ":pouting_woman:",                         "&#x1f64e;&#x200d;&#x2640;&#xfe0f;"    },
  { ":pray:",                                  "&#x1f64f;"                            },
  { ":prayer_beads:",                          "&#x1f4ff;"                            },
  { ":pregnant_woman:",                        "&#x1f930;"                            },
  { ":pretzel:",                               "&#x1f968;"                            },
  { ":previous_track_button:",                 "&#x23ee;"                             },
  { ":prince:",                                "&#x1f934;"                            },
  { ":princess:",                              "&#x1f478;"                            },
  { ":printer:",                               "&#x1f5a8;"                            },
  { ":probing_cane:",                          "&#x1f9af;"                            },
  { ":puerto_rico:",                           "&#x1f1f5;&#x1f1f7;"                   },
  { ":punch:",                                 "&#x1f44a;"                            },
  { ":purple_circle:",                         "&#x1f7e3;"                            },
  { ":purple_heart:",                          "&#x1f49c;"                            },
  { ":purple_square:",                         "&#x1f7ea;"                            },
  { ":purse:",                                 "&#x1f45b;"                            },
  { ":pushpin:",                               "&#x1f4cc;"                            },
  { ":put_litter_in_its_place:",               "&#x1f6ae;"                            },
  { ":qatar:",                                 "&#x1f1f6;&#x1f1e6;"                   },
  { ":question:",                              "&#x2753;"                             },
  { ":rabbit:",                                "&#x1f430;"                            },
  { ":rabbit2:",                               "&#x1f407;"                            },
  { ":raccoon:",                               "&#x1f99d;"                            },
  { ":racehorse:",                             "&#x1f40e;"                            },
  { ":racing_car:",                            "&#x1f3ce;"                            },
  { ":radio:",                                 "&#x1f4fb;"                            },
  { ":radio_button:",                          "&#x1f518;"                            },
  { ":radioactive:",                           "&#x2622;"                             },
  { ":rage:",                                  "&#x1f621;"                            },
  { ":railway_car:",                           "&#x1f683;"                            },
  { ":railway_track:",                         "&#x1f6e4;"                            },
  { ":rainbow:",                               "&#x1f308;"                            },
  { ":rainbow_flag:",                          "&#x1f3f3;&#xfe0f;&#x200d;&#x1f308;"   },
  { ":raised_back_of_hand:",                   "&#x1f91a;"                            },
  { ":raised_eyebrow:",                        "&#x1f928;"                            },
  { ":raised_hand:",                           "&#x270b;"                             },
  { ":raised_hand_with_fingers_splayed:",      "&#x1f590;"                            },
  { ":raised_hands:",                          "&#x1f64c;"                            },
  { ":raising_hand:",                          "&#x1f64b;"                            },
  { ":raising_hand_man:",                      "&#x1f64b;&#x200d;&#x2642;&#xfe0f;"    },
  { ":raising_hand_woman:",                    "&#x1f64b;&#x200d;&#x2640;&#xfe0f;"    },
  { ":ram:",                                   "&#x1f40f;"                            },
  { ":ramen:",                                 "&#x1f35c;"                            },
  { ":rat:",                                   "&#x1f400;"                            },
  { ":razor:",                                 "&#x1fa92;"                            },
  { ":receipt:",                               "&#x1f9fe;"                            },
  { ":record_button:",                         "&#x23fa;"                             },
  { ":recycle:",                               "&#x267b;"                             },
  { ":red_car:",                               "&#x1f697;"                            },
  { ":red_circle:",                            "&#x1f534;"                            },
  { ":red_envelope:",                          "&#x1f9e7;"                            },
  { ":red_haired_man:",                        "&#x1f468;&#x200d;&#x1f9b0;"           },
  { ":red_haired_woman:",                      "&#x1f469;&#x200d;&#x1f9b0;"           },
  { ":red_square:",                            "&#x1f7e5;"                            },
  { ":registered:",                            "&#x00ae;"                             },
  { ":relaxed:",                               "&#x263a;"                             },
  { ":relieved:",                              "&#x1f60c;"                            },
  { ":reminder_ribbon:",                       "&#x1f397;"                            },
  { ":repeat:",                                "&#x1f501;"                            },
  { ":repeat_one:",                            "&#x1f502;"                            },
  { ":rescue_worker_helmet:",                  "&#x26d1;"                             },
  { ":restroom:",                              "&#x1f6bb;"                            },
  { ":reunion:",                               "&#x1f1f7;&#x1f1ea;"                   },
  { ":revolving_hearts:",                      "&#x1f49e;"                            },
  { ":rewind:",                                "&#x23ea;"                             },
  { ":rhinoceros:",                            "&#x1f98f;"                            },
  { ":ribbon:",                                "&#x1f380;"                            },
  { ":rice:",                                  "&#x1f35a;"                            },
  { ":rice_ball:",                             "&#x1f359;"                            },
  { ":rice_cracker:",                          "&#x1f358;"                            },
  { ":rice_scene:",                            "&#x1f391;"                            },
  { ":right_anger_bubble:",                    "&#x1f5ef;"                            },
  { ":ring:",                                  "&#x1f48d;"                            },
  { ":ringed_planet:",                         "&#x1fa90;"                            },
  { ":robot:",                                 "&#x1f916;"                            },
  { ":rock:",                                  "&#x1faa8;"                            },
  { ":rocket:",                                "&#x1f680;"                            },
  { ":rofl:",                                  "&#x1f923;"                            },
  { ":roll_eyes:",                             "&#x1f644;"                            },
  { ":roll_of_paper:",                         "&#x1f9fb;"                            },
  { ":roller_coaster:",                        "&#x1f3a2;"                            },
  { ":roller_skate:",                          "&#x1f6fc;"                            },
  { ":romania:",                               "&#x1f1f7;&#x1f1f4;"                   },
  { ":rooster:",                               "&#x1f413;"                            },
  { ":rose:",                                  "&#x1f339;"                            },
  { ":rosette:",                               "&#x1f3f5;"                            },
  { ":rotating_light:",                        "&#x1f6a8;"                            },
  { ":round_pushpin:",                         "&#x1f4cd;"                            },
  { ":rowboat:",                               "&#x1f6a3;"                            },
  { ":rowing_man:",                            "&#x1f6a3;&#x200d;&#x2642;&#xfe0f;"    },
  { ":rowing_woman:",                          "&#x1f6a3;&#x200d;&#x2640;&#xfe0f;"    },
  { ":ru:",                                    "&#x1f1f7;&#x1f1fa;"                   },
  { ":rugby_football:",                        "&#x1f3c9;"                            },
  { ":runner:",                                "&#x1f3c3;"                            },
  { ":running:",                               "&#x1f3c3;"                            },
  { ":running_man:",                           "&#x1f3c3;&#x200d;&#x2642;&#xfe0f;"    },
  { ":running_shirt_with_sash:",               "&#x1f3bd;"                            },
  { ":running_woman:",                         "&#x1f3c3;&#x200d;&#x2640;&#xfe0f;"    },
  { ":rwanda:",                                "&#x1f1f7;&#x1f1fc;"                   },
  { ":sa:",                                    "&#x1f202;"                            },
  { ":safety_pin:",                            "&#x1f9f7;"                            },
  { ":safety_vest:",                           "&#x1f9ba;"                            },
  { ":sagittarius:",                           "&#x2650;"                             },
  { ":sailboat:",                              "&#x26f5;"                             },
  { ":sake:",                                  "&#x1f376;"                            },
  { ":salt:",                                  "&#x1f9c2;"                            },
  { ":samoa:",                                 "&#x1f1fc;&#x1f1f8;"                   },
  { ":san_marino:",                            "&#x1f1f8;&#x1f1f2;"                   },
  { ":sandal:",                                "&#x1f461;"                            },
  { ":sandwich:",                              "&#x1f96a;"                            },
  { ":santa:",                                 "&#x1f385;"                            },
  { ":sao_tome_principe:",                     "&#x1f1f8;&#x1f1f9;"                   },
  { ":sari:",                                  "&#x1f97b;"                            },
  { ":sassy_man:",                             "&#x1f481;&#x200d;&#x2642;&#xfe0f;"    },
  { ":sassy_woman:",                           "&#x1f481;&#x200d;&#x2640;&#xfe0f;"    },
  { ":satellite:",                             "&#x1f4e1;"                            },
  { ":satisfied:",                             "&#x1f606;"                            },
  { ":saudi_arabia:",                          "&#x1f1f8;&#x1f1e6;"                   },
  { ":sauna_man:",                             "&#x1f9d6;&#x200d;&#x2642;&#xfe0f;"    },
  { ":sauna_person:",                          "&#x1f9d6;"                            },
  { ":sauna_woman:",                           "&#x1f9d6;&#x200d;&#x2640;&#xfe0f;"    },
  { ":sauropod:",                              "&#x1f995;"                            },
  { ":saxophone:",                             "&#x1f3b7;"                            },
  { ":scarf:",                                 "&#x1f9e3;"                            },
  { ":school:",                                "&#x1f3eb;"                            },
  { ":school_satchel:",                        "&#x1f392;"                            },
  { ":scientist:",                             "&#x1f9d1;&#x200d;&#x1f52c;"           },
  { ":scissors:",                              "&#x2702;"                             },
  { ":scorpion:",                              "&#x1f982;"                            },
  { ":scorpius:",                              "&#x264f;"                             },
  { ":scotland:",                              "&#x1f3f4;&#xe0067;&#xe0062;&#xe0073;&#xe0063;&#xe0074;&#xe007f;" },
  { ":scream:",                                "&#x1f631;"                            },
  { ":scream_cat:",                            "&#x1f640;"                            },
  { ":screwdriver:",                           "&#x1fa9b;"                            },
  { ":scroll:",                                "&#x1f4dc;"                            },
  { ":seal:",                                  "&#x1f9ad;"                            },
  { ":seat:",                                  "&#x1f4ba;"                            },
  { ":secret:",                                "&#x3299;"                             },
  { ":see_no_evil:",                           "&#x1f648;"                            },
  { ":seedling:",                              "&#x1f331;"                            },
  { ":selfie:",                                "&#x1f933;"                            },
  { ":senegal:",                               "&#x1f1f8;&#x1f1f3;"                   },
  { ":serbia:",                                "&#x1f1f7;&#x1f1f8;"                   },
  { ":service_dog:",                           "&#x1f415;&#x200d;&#x1f9ba;"           },
  { ":seven:",                                 "&#x0037;&#xfe0f;&#x20e3;"             },
  { ":sewing_needle:",                         "&#x1faa1;"                            },
  { ":seychelles:",                            "&#x1f1f8;&#x1f1e8;"                   },
  { ":shallow_pan_of_food:",                   "&#x1f958;"                            },
  { ":shamrock:",                              "&#x2618;"                             },
  { ":shark:",                                 "&#x1f988;"                            },
  { ":shaved_ice:",                            "&#x1f367;"                            },
  { ":sheep:",                                 "&#x1f411;"                            },
  { ":shell:",                                 "&#x1f41a;"                            },
  { ":shield:",                                "&#x1f6e1;"                            },
  { ":shinto_shrine:",                         "&#x26e9;"                             },
  { ":ship:",                                  "&#x1f6a2;"                            },
  { ":shirt:",                                 "&#x1f455;"                            },
  { ":shit:",                                  "&#x1f4a9;"                            },
  { ":shoe:",                                  "&#x1f45e;"                            },
  { ":shopping:",                              "&#x1f6cd;"                            },
  { ":shopping_cart:",                         "&#x1f6d2;"                            },
  { ":shorts:",                                "&#x1fa73;"                            },
  { ":shower:",                                "&#x1f6bf;"                            },
  { ":shrimp:",                                "&#x1f990;"                            },
  { ":shrug:",                                 "&#x1f937;"                            },
  { ":shushing_face:",                         "&#x1f92b;"                            },
  { ":sierra_leone:",                          "&#x1f1f8;&#x1f1f1;"                   },
  { ":signal_strength:",                       "&#x1f4f6;"                            },
  { ":singapore:",                             "&#x1f1f8;&#x1f1ec;"                   },
  { ":singer:",                                "&#x1f9d1;&#x200d;&#x1f3a4;"           },
  { ":sint_maarten:",                          "&#x1f1f8;&#x1f1fd;"                   },
  { ":six:",                                   "&#x0036;&#xfe0f;&#x20e3;"             },
  { ":six_pointed_star:",                      "&#x1f52f;"                            },
  { ":skateboard:",                            "&#x1f6f9;"                            },
  { ":ski:",                                   "&#x1f3bf;"                            },
  { ":skier:",                                 "&#x26f7;"                             },
  { ":skull:",                                 "&#x1f480;"                            },
  { ":skull_and_crossbones:",                  "&#x2620;"                             },
  { ":skunk:",                                 "&#x1f9a8;"                            },
  { ":sled:",                                  "&#x1f6f7;"                            },
  { ":sleeping:",                              "&#x1f634;"                            },
  { ":sleeping_bed:",                          "&#x1f6cc;"                            },
  { ":sleepy:",                                "&#x1f62a;"                            },
  { ":slightly_frowning_face:",                "&#x1f641;"                            },
  { ":slightly_smiling_face:",                 "&#x1f642;"                            },
  { ":slot_machine:",                          "&#x1f3b0;"                            },
  { ":sloth:",                                 "&#x1f9a5;"                            },
  { ":slovakia:",                              "&#x1f1f8;&#x1f1f0;"                   },
  { ":slovenia:",                              "&#x1f1f8;&#x1f1ee;"                   },
  { ":small_airplane:",                        "&#x1f6e9;"                            },
  { ":small_blue_diamond:",                    "&#x1f539;"                            },
  { ":small_orange_diamond:",                  "&#x1f538;"                            },
  { ":small_red_triangle:",                    "&#x1f53a;"                            },
  { ":small_red_triangle_down:",               "&#x1f53b;"                            },
  { ":smile:",                                 "&#x1f604;"                            },
  { ":smile_cat:",                             "&#x1f638;"                            },
  { ":smiley:",                                "&#x1f603;"                            },
  { ":smiley_cat:",                            "&#x1f63a;"                            },
  { ":smiling_face_with_tear:",                "&#x1f972;"                            },
  { ":smiling_face_with_three_hearts:",        "&#x1f970;"                            },
  { ":smiling_imp:",                           "&#x1f608;"                            },
  { ":smirk:",                                 "&#x1f60f;"                            },
  { ":smirk_cat:",                             "&#x1f63c;"                            },
  { ":smoking:",                               "&#x1f6ac;"                            },
  { ":snail:",                                 "&#x1f40c;"                            },
  { ":snake:",                                 "&#x1f40d;"                            },
  { ":sneezing_face:",                         "&#x1f927;"                            },
  { ":snowboarder:",                           "&#x1f3c2;"                            },
  { ":snowflake:",                             "&#x2744;"                             },
  { ":snowman:",                               "&#x26c4;"                             },
  { ":snowman_with_snow:",                     "&#x2603;"                             },
  { ":soap:",                                  "&#x1f9fc;"                            },
  { ":sob:",                                   "&#x1f62d;"                            },
  { ":soccer:",                                "&#x26bd;"                             },
  { ":socks:",                                 "&#x1f9e6;"                            },
  { ":softball:",                              "&#x1f94e;"                            },
  { ":solomon_islands:",                       "&#x1f1f8;&#x1f1e7;"                   },
  { ":somalia:",                               "&#x1f1f8;&#x1f1f4;"                   },
  { ":soon:",                                  "&#x1f51c;"                            },
  { ":sos:",                                   "&#x1f198;"                            },
  { ":sound:",                                 "&#x1f509;"                            },
  { ":south_africa:",                          "&#x1f1ff;&#x1f1e6;"                   },
  { ":south_georgia_south_sandwich_islands:",  "&#x1f1ec;&#x1f1f8;"                   },
  { ":south_sudan:",                           "&#x1f1f8;&#x1f1f8;"                   },
  { ":space_invader:",                         "&#x1f47e;"                            },
  { ":spades:",                                "&#x2660;"                             },
  { ":spaghetti:",                             "&#x1f35d;"                            },
  { ":sparkle:",                               "&#x2747;"                             },
  { ":sparkler:",                              "&#x1f387;"                            },
  { ":sparkles:",                              "&#x2728;"                             },
  { ":sparkling_heart:",                       "&#x1f496;"                            },
  { ":speak_no_evil:",                         "&#x1f64a;"                            },
  { ":speaker:",                               "&#x1f508;"                            },
  { ":speaking_head:",                         "&#x1f5e3;"                            },
  { ":speech_balloon:",                        "&#x1f4ac;"                            },
  { ":speedboat:",                             "&#x1f6a4;"                            },
  { ":spider:",                                "&#x1f577;"                            },
  { ":spider_web:",                            "&#x1f578;"                            },
  { ":spiral_calendar:",                       "&#x1f5d3;"                            },
  { ":spiral_notepad:",                        "&#x1f5d2;"                            },
  { ":sponge:",                                "&#x1f9fd;"                            },
  { ":spoon:",                                 "&#x1f944;"                            },
  { ":squid:",                                 "&#x1f991;"                            },
  { ":sri_lanka:",                             "&#x1f1f1;&#x1f1f0;"                   },
  { ":st_barthelemy:",                         "&#x1f1e7;&#x1f1f1;"                   },
  { ":st_helena:",                             "&#x1f1f8;&#x1f1ed;"                   },
  { ":st_kitts_nevis:",                        "&#x1f1f0;&#x1f1f3;"                   },
  { ":st_lucia:",                              "&#x1f1f1;&#x1f1e8;"                   },
  { ":st_martin:",                             "&#x1f1f2;&#x1f1eb;"                   },
  { ":st_pierre_miquelon:",                    "&#x1f1f5;&#x1f1f2;"                   },
  { ":st_vincent_grenadines:",                 "&#x1f1fb;&#x1f1e8;"                   },
  { ":stadium:",                               "&#x1f3df;"                            },
  { ":standing_man:",                          "&#x1f9cd;&#x200d;&#x2642;&#xfe0f;"    },
  { ":standing_person:",                       "&#x1f9cd;"                            },
  { ":standing_woman:",                        "&#x1f9cd;&#x200d;&#x2640;&#xfe0f;"    },
  { ":star:",                                  "&#x2b50;"                             },
  { ":star2:",                                 "&#x1f31f;"                            },
  { ":star_and_crescent:",                     "&#x262a;"                             },
  { ":star_of_david:",                         "&#x2721;"                             },
  { ":star_struck:",                           "&#x1f929;"                            },
  { ":stars:",                                 "&#x1f320;"                            },
  { ":station:",                               "&#x1f689;"                            },
  { ":statue_of_liberty:",                     "&#x1f5fd;"                            },
  { ":steam_locomotive:",                      "&#x1f682;"                            },
  { ":stethoscope:",                           "&#x1fa7a;"                            },
  { ":stew:",                                  "&#x1f372;"                            },
  { ":stop_button:",                           "&#x23f9;"                             },
  { ":stop_sign:",                             "&#x1f6d1;"                            },
  { ":stopwatch:",                             "&#x23f1;"                             },
  { ":straight_ruler:",                        "&#x1f4cf;"                            },
  { ":strawberry:",                            "&#x1f353;"                            },
  { ":stuck_out_tongue:",                      "&#x1f61b;"                            },
  { ":stuck_out_tongue_closed_eyes:",          "&#x1f61d;"                            },
  { ":stuck_out_tongue_winking_eye:",          "&#x1f61c;"                            },
  { ":student:",                               "&#x1f9d1;&#x200d;&#x1f393;"           },
  { ":studio_microphone:",                     "&#x1f399;"                            },
  { ":stuffed_flatbread:",                     "&#x1f959;"                            },
  { ":sudan:",                                 "&#x1f1f8;&#x1f1e9;"                   },
  { ":sun_behind_large_cloud:",                "&#x1f325;"                            },
  { ":sun_behind_rain_cloud:",                 "&#x1f326;"                            },
  { ":sun_behind_small_cloud:",                "&#x1f324;"                            },
  { ":sun_with_face:",                         "&#x1f31e;"                            },
  { ":sunflower:",                             "&#x1f33b;"                            },
  { ":sunglasses:",                            "&#x1f60e;"                            },
  { ":sunny:",                                 "&#x2600;"                             },
  { ":sunrise:",                               "&#x1f305;"                            },
  { ":sunrise_over_mountains:",                "&#x1f304;"                            },
  { ":superhero:",                             "&#x1f9b8;"                            },
  { ":superhero_man:",                         "&#x1f9b8;&#x200d;&#x2642;&#xfe0f;"    },
  { ":superhero_woman:",                       "&#x1f9b8;&#x200d;&#x2640;&#xfe0f;"    },
  { ":supervillain:",                          "&#x1f9b9;"                            },
  { ":supervillain_man:",                      "&#x1f9b9;&#x200d;&#x2642;&#xfe0f;"    },
  { ":supervillain_woman:",                    "&#x1f9b9;&#x200d;&#x2640;&#xfe0f;"    },
  { ":surfer:",                                "&#x1f3c4;"                            },
  { ":surfing_man:",                           "&#x1f3c4;&#x200d;&#x2642;&#xfe0f;"    },
  { ":surfing_woman:",                         "&#x1f3c4;&#x200d;&#x2640;&#xfe0f;"    },
  { ":suriname:",                              "&#x1f1f8;&#x1f1f7;"                   },
  { ":sushi:",                                 "&#x1f363;"                            },
  { ":suspension_railway:",                    "&#x1f69f;"                            },
  { ":svalbard_jan_mayen:",                    "&#x1f1f8;&#x1f1ef;"                   },
  { ":swan:",                                  "&#x1f9a2;"                            },
  { ":swaziland:",                             "&#x1f1f8;&#x1f1ff;"                   },
  { ":sweat:",                                 "&#x1f613;"                            },
  { ":sweat_drops:",                           "&#x1f4a6;"                            },
  { ":sweat_smile:",                           "&#x1f605;"                            },
  { ":sweden:",                                "&#x1f1f8;&#x1f1ea;"                   },
  { ":sweet_potato:",                          "&#x1f360;"                            },
  { ":swim_brief:",                            "&#x1fa72;"                            },
  { ":swimmer:",                               "&#x1f3ca;"                            },
  { ":swimming_man:",                          "&#x1f3ca;&#x200d;&#x2642;&#xfe0f;"    },
  { ":swimming_woman:",                        "&#x1f3ca;&#x200d;&#x2640;&#xfe0f;"    },
  { ":switzerland:",                           "&#x1f1e8;&#x1f1ed;"                   },
  { ":symbols:",                               "&#x1f523;"                            },
  { ":synagogue:",                             "&#x1f54d;"                            },
  { ":syria:",                                 "&#x1f1f8;&#x1f1fe;"                   },
  { ":syringe:",                               "&#x1f489;"                            },
  { ":t-rex:",                                 "&#x1f996;"                            },
  { ":taco:",                                  "&#x1f32e;"                            },
  { ":tada:",                                  "&#x1f389;"                            },
  { ":taiwan:",                                "&#x1f1f9;&#x1f1fc;"                   },
  { ":tajikistan:",                            "&#x1f1f9;&#x1f1ef;"                   },
  { ":takeout_box:",                           "&#x1f961;"                            },
  { ":tamale:",                                "&#x1fad4;"                            },
  { ":tanabata_tree:",                         "&#x1f38b;"                            },
  { ":tangerine:",                             "&#x1f34a;"                            },
  { ":tanzania:",                              "&#x1f1f9;&#x1f1ff;"                   },
  { ":taurus:",                                "&#x2649;"                             },
  { ":taxi:",                                  "&#x1f695;"                            },
  { ":tea:",                                   "&#x1f375;"                            },
  { ":teacher:",                               "&#x1f9d1;&#x200d;&#x1f3eb;"           },
  { ":teapot:",                                "&#x1fad6;"                            },
  { ":technologist:",                          "&#x1f9d1;&#x200d;&#x1f4bb;"           },
  { ":teddy_bear:",                            "&#x1f9f8;"                            },
  { ":telephone:",                             "&#x260e;"                             },
  { ":telephone_receiver:",                    "&#x1f4de;"                            },
  { ":telescope:",                             "&#x1f52d;"                            },
  { ":tennis:",                                "&#x1f3be;"                            },
  { ":tent:",                                  "&#x26fa;"                             },
  { ":test_tube:",                             "&#x1f9ea;"                            },
  { ":thailand:",                              "&#x1f1f9;&#x1f1ed;"                   },
  { ":thermometer:",                           "&#x1f321;"                            },
  { ":thinking:",                              "&#x1f914;"                            },
  { ":thong_sandal:",                          "&#x1fa74;"                            },
  { ":thought_balloon:",                       "&#x1f4ad;"                            },
  { ":thread:",                                "&#x1f9f5;"                            },
  { ":three:",                                 "&#x0033;&#xfe0f;&#x20e3;"             },
  { ":thumbsdown:",                            "&#x1f44e;"                            },
  { ":thumbsup:",                              "&#x1f44d;"                            },
  { ":ticket:",                                "&#x1f3ab;"                            },
  { ":tickets:",                               "&#x1f39f;"                            },
  { ":tiger:",                                 "&#x1f42f;"                            },
  { ":tiger2:",                                "&#x1f405;"                            },
  { ":timer_clock:",                           "&#x23f2;"                             },
  { ":timor_leste:",                           "&#x1f1f9;&#x1f1f1;"                   },
  { ":tipping_hand_man:",                      "&#x1f481;&#x200d;&#x2642;&#xfe0f;"    },
  { ":tipping_hand_person:",                   "&#x1f481;"                            },
  { ":tipping_hand_woman:",                    "&#x1f481;&#x200d;&#x2640;&#xfe0f;"    },
  { ":tired_face:",                            "&#x1f62b;"                            },
  { ":tm:",                                    "&#x2122;"                             },
  { ":togo:",                                  "&#x1f1f9;&#x1f1ec;"                   },
  { ":toilet:",                                "&#x1f6bd;"                            },
  { ":tokelau:",                               "&#x1f1f9;&#x1f1f0;"                   },
  { ":tokyo_tower:",                           "&#x1f5fc;"                            },
  { ":tomato:",                                "&#x1f345;"                            },
  { ":tonga:",                                 "&#x1f1f9;&#x1f1f4;"                   },
  { ":tongue:",                                "&#x1f445;"                            },
  { ":toolbox:",                               "&#x1f9f0;"                            },
  { ":tooth:",                                 "&#x1f9b7;"                            },
  { ":toothbrush:",                            "&#x1faa5;"                            },
  { ":top:",                                   "&#x1f51d;"                            },
  { ":tophat:",                                "&#x1f3a9;"                            },
  { ":tornado:",                               "&#x1f32a;"                            },
  { ":tr:",                                    "&#x1f1f9;&#x1f1f7;"                   },
  { ":trackball:",                             "&#x1f5b2;"                            },
  { ":tractor:",                               "&#x1f69c;"                            },
  { ":traffic_light:",                         "&#x1f6a5;"                            },
  { ":train:",                                 "&#x1f68b;"                            },
  { ":train2:",                                "&#x1f686;"                            },
  { ":tram:",                                  "&#x1f68a;"                            },
  { ":transgender_flag:",                      "&#x1f3f3;&#xfe0f;&#x200d;&#x26a7;&#xfe0f;" },
  { ":transgender_symbol:",                    "&#x26a7;"                             },
  { ":triangular_flag_on_post:",               "&#x1f6a9;"                            },
  { ":triangular_ruler:",                      "&#x1f4d0;"                            },
  { ":trident:",                               "&#x1f531;"                            },
  { ":trinidad_tobago:",                       "&#x1f1f9;&#x1f1f9;"                   },
  { ":tristan_da_cunha:",                      "&#x1f1f9;&#x1f1e6;"                   },
  { ":triumph:",                               "&#x1f624;"                            },
  { ":trolleybus:",                            "&#x1f68e;"                            },
  { ":trophy:",                                "&#x1f3c6;"                            },
  { ":tropical_drink:",                        "&#x1f379;"                            },
  { ":tropical_fish:",                         "&#x1f420;"                            },
  { ":truck:",                                 "&#x1f69a;"                            },
  { ":trumpet:",                               "&#x1f3ba;"                            },
  { ":tshirt:",                                "&#x1f455;"                            },
  { ":tulip:",                                 "&#x1f337;"                            },
  { ":tumbler_glass:",                         "&#x1f943;"                            },
  { ":tunisia:",                               "&#x1f1f9;&#x1f1f3;"                   },
  { ":turkey:",                                "&#x1f983;"                            },
  { ":turkmenistan:",                          "&#x1f1f9;&#x1f1f2;"                   },
  { ":turks_caicos_islands:",                  "&#x1f1f9;&#x1f1e8;"                   },
  { ":turtle:",                                "&#x1f422;"                            },
  { ":tuvalu:",                                "&#x1f1f9;&#x1f1fb;"                   },
  { ":tv:",                                    "&#x1f4fa;"                            },
  { ":twisted_rightwards_arrows:",             "&#x1f500;"                            },
  { ":two:",                                   "&#x0032;&#xfe0f;&#x20e3;"             },
  { ":two_hearts:",                            "&#x1f495;"                            },
  { ":two_men_holding_hands:",                 "&#x1f46c;"                            },
  { ":two_women_holding_hands:",               "&#x1f46d;"                            },
  { ":u5272:",                                 "&#x1f239;"                            },
  { ":u5408:",                                 "&#x1f234;"                            },
  { ":u55b6:",                                 "&#x1f23a;"                            },
  { ":u6307:",                                 "&#x1f22f;"                            },
  { ":u6708:",                                 "&#x1f237;"                            },
  { ":u6709:",                                 "&#x1f236;"                            },
  { ":u6e80:",                                 "&#x1f235;"                            },
  { ":u7121:",                                 "&#x1f21a;"                            },
  { ":u7533:",                                 "&#x1f238;"                            },
  { ":u7981:",                                 "&#x1f232;"                            },
  { ":u7a7a:",                                 "&#x1f233;"                            },
  { ":uganda:",                                "&#x1f1fa;&#x1f1ec;"                   },
  { ":uk:",                                    "&#x1f1ec;&#x1f1e7;"                   },
  { ":ukraine:",                               "&#x1f1fa;&#x1f1e6;"                   },
  { ":umbrella:",                              "&#x2614;"                             },
  { ":unamused:",                              "&#x1f612;"                            },
  { ":underage:",                              "&#x1f51e;"                            },
  { ":unicorn:",                               "&#x1f984;"                            },
  { ":united_arab_emirates:",                  "&#x1f1e6;&#x1f1ea;"                   },
  { ":united_nations:",                        "&#x1f1fa;&#x1f1f3;"                   },
  { ":unlock:",                                "&#x1f513;"                            },
  { ":up:",                                    "&#x1f199;"                            },
  { ":upside_down_face:",                      "&#x1f643;"                            },
  { ":uruguay:",                               "&#x1f1fa;&#x1f1fe;"                   },
  { ":us:",                                    "&#x1f1fa;&#x1f1f8;"                   },
  { ":us_outlying_islands:",                   "&#x1f1fa;&#x1f1f2;"                   },
  { ":us_virgin_islands:",                     "&#x1f1fb;&#x1f1ee;"                   },
  { ":uzbekistan:",                            "&#x1f1fa;&#x1f1ff;"                   },
  { ":v:",                                     "&#x270c;"                             },
  { ":vampire:",                               "&#x1f9db;"                            },
  { ":vampire_man:",                           "&#x1f9db;&#x200d;&#x2642;&#xfe0f;"    },
  { ":vampire_woman:",                         "&#x1f9db;&#x200d;&#x2640;&#xfe0f;"    },
  { ":vanuatu:",                               "&#x1f1fb;&#x1f1fa;"                   },
  { ":vatican_city:",                          "&#x1f1fb;&#x1f1e6;"                   },
  { ":venezuela:",                             "&#x1f1fb;&#x1f1ea;"                   },
  { ":vertical_traffic_light:",                "&#x1f6a6;"                            },
  { ":vhs:",                                   "&#x1f4fc;"                            },
  { ":vibration_mode:",                        "&#x1f4f3;"                            },
  { ":video_camera:",                          "&#x1f4f9;"                            },
  { ":video_game:",                            "&#x1f3ae;"                            },
  { ":vietnam:",                               "&#x1f1fb;&#x1f1f3;"                   },
  { ":violin:",                                "&#x1f3bb;"                            },
  { ":virgo:",                                 "&#x264d;"                             },
  { ":volcano:",                               "&#x1f30b;"                            },
  { ":volleyball:",                            "&#x1f3d0;"                            },
  { ":vomiting_face:",                         "&#x1f92e;"                            },
  { ":vs:",                                    "&#x1f19a;"                            },
  { ":vulcan_salute:",                         "&#x1f596;"                            },
  { ":waffle:",                                "&#x1f9c7;"                            },
  { ":wales:",                                 "&#x1f3f4;&#xe0067;&#xe0062;&#xe0077;&#xe006c;&#xe0073;&#xe007f;" },
  { ":walking:",                               "&#x1f6b6;"                            },
  { ":walking_man:",                           "&#x1f6b6;&#x200d;&#x2642;&#xfe0f;"    },
  { ":walking_woman:",                         "&#x1f6b6;&#x200d;&#x2640;&#xfe0f;"    },
  { ":wallis_futuna:",                         "&#x1f1fc;&#x1f1eb;"                   },
  { ":waning_crescent_moon:",                  "&#x1f318;"                            },
  { ":waning_gibbous_moon:",                   "&#x1f316;"                            },
  { ":warning:",                               "&#x26a0;"                             },
  { ":wastebasket:",                           "&#x1f5d1;"                            },
  { ":watch:",                                 "&#x231a;"                             },
  { ":water_buffalo:",                         "&#x1f403;"                            },
  { ":water_polo:",                            "&#x1f93d;"                            },
  { ":watermelon:",                            "&#x1f349;"                            },
  { ":wave:",                                  "&#x1f44b;"                            },
  { ":wavy_dash:",                             "&#x3030;"                             },
  { ":waxing_crescent_moon:",                  "&#x1f312;"                            },
  { ":waxing_gibbous_moon:",                   "&#x1f314;"                            },
  { ":wc:",                                    "&#x1f6be;"                            },
  { ":weary:",                                 "&#x1f629;"                            },
  { ":wedding:",                               "&#x1f492;"                            },
  { ":weight_lifting:",                        "&#x1f3cb;"                            },
  { ":weight_lifting_man:",                    "&#x1f3cb;&#xfe0f;&#x200d;&#x2642;&#xfe0f;" },
  { ":weight_lifting_woman:",                  "&#x1f3cb;&#xfe0f;&#x200d;&#x2640;&#xfe0f;" },
  { ":western_sahara:",                        "&#x1f1ea;&#x1f1ed;"                   },
  { ":whale:",                                 "&#x1f433;"                            },
  { ":whale2:",                                "&#x1f40b;"                            },
  { ":wheel_of_dharma:",                       "&#x2638;"                             },
  { ":wheelchair:",                            "&#x267f;"                             },
  { ":white_check_mark:",                      "&#x2705;"                             },
  { ":white_circle:",                          "&#x26aa;"                             },
  { ":white_flag:",                            "&#x1f3f3;"                            },
  { ":white_flower:",                          "&#x1f4ae;"                            },
  { ":white_haired_man:",                      "&#x1f468;&#x200d;&#x1f9b3;"           },
  { ":white_haired_woman:",                    "&#x1f469;&#x200d;&#x1f9b3;"           },
  { ":white_heart:",                           "&#x1f90d;"                            },
  { ":white_large_square:",                    "&#x2b1c;"                             },
  { ":white_medium_small_square:",             "&#x25fd;"                             },
  { ":white_medium_square:",                   "&#x25fb;"                             },
  { ":white_small_square:",                    "&#x25ab;"                             },
  { ":white_square_button:",                   "&#x1f533;"                            },
  { ":wilted_flower:",                         "&#x1f940;"                            },
  { ":wind_chime:",                            "&#x1f390;"                            },
  { ":wind_face:",                             "&#x1f32c;"                            },
  { ":window:",                                "&#x1fa9f;"                            },
  { ":wine_glass:",                            "&#x1f377;"                            },
  { ":wink:",                                  "&#x1f609;"                            },
  { ":wolf:",                                  "&#x1f43a;"                            },
  { ":woman:",                                 "&#x1f469;"                            },
  { ":woman_artist:",                          "&#x1f469;&#x200d;&#x1f3a8;"           },
  { ":woman_astronaut:",                       "&#x1f469;&#x200d;&#x1f680;"           },
  { ":woman_beard:",                           "&#x1f9d4;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_cartwheeling:",                    "&#x1f938;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_cook:",                            "&#x1f469;&#x200d;&#x1f373;"           },
  { ":woman_dancing:",                         "&#x1f483;"                            },
  { ":woman_facepalming:",                     "&#x1f926;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_factory_worker:",                  "&#x1f469;&#x200d;&#x1f3ed;"           },
  { ":woman_farmer:",                          "&#x1f469;&#x200d;&#x1f33e;"           },
  { ":woman_feeding_baby:",                    "&#x1f469;&#x200d;&#x1f37c;"           },
  { ":woman_firefighter:",                     "&#x1f469;&#x200d;&#x1f692;"           },
  { ":woman_health_worker:",                   "&#x1f469;&#x200d;&#x2695;&#xfe0f;"    },
  { ":woman_in_manual_wheelchair:",            "&#x1f469;&#x200d;&#x1f9bd;"           },
  { ":woman_in_motorized_wheelchair:",         "&#x1f469;&#x200d;&#x1f9bc;"           },
  { ":woman_in_tuxedo:",                       "&#x1f935;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_judge:",                           "&#x1f469;&#x200d;&#x2696;&#xfe0f;"    },
  { ":woman_juggling:",                        "&#x1f939;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_mechanic:",                        "&#x1f469;&#x200d;&#x1f527;"           },
  { ":woman_office_worker:",                   "&#x1f469;&#x200d;&#x1f4bc;"           },
  { ":woman_pilot:",                           "&#x1f469;&#x200d;&#x2708;&#xfe0f;"    },
  { ":woman_playing_handball:",                "&#x1f93e;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_playing_water_polo:",              "&#x1f93d;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_scientist:",                       "&#x1f469;&#x200d;&#x1f52c;"           },
  { ":woman_shrugging:",                       "&#x1f937;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_singer:",                          "&#x1f469;&#x200d;&#x1f3a4;"           },
  { ":woman_student:",                         "&#x1f469;&#x200d;&#x1f393;"           },
  { ":woman_teacher:",                         "&#x1f469;&#x200d;&#x1f3eb;"           },
  { ":woman_technologist:",                    "&#x1f469;&#x200d;&#x1f4bb;"           },
  { ":woman_with_headscarf:",                  "&#x1f9d5;"                            },
  { ":woman_with_probing_cane:",               "&#x1f469;&#x200d;&#x1f9af;"           },
  { ":woman_with_turban:",                     "&#x1f473;&#x200d;&#x2640;&#xfe0f;"    },
  { ":woman_with_veil:",                       "&#x1f470;&#x200d;&#x2640;&#xfe0f;"    },
  { ":womans_clothes:",                        "&#x1f45a;"                            },
  { ":womans_hat:",                            "&#x1f452;"                            },
  { ":women_wrestling:",                       "&#x1f93c;&#x200d;&#x2640;&#xfe0f;"    },
  { ":womens:",                                "&#x1f6ba;"                            },
  { ":wood:",                                  "&#x1fab5;"                            },
  { ":woozy_face:",                            "&#x1f974;"                            },
  { ":world_map:",                             "&#x1f5fa;"                            },
  { ":worm:",                                  "&#x1fab1;"                            },
  { ":worried:",                               "&#x1f61f;"                            },
  { ":wrench:",                                "&#x1f527;"                            },
  { ":wrestling:",                             "&#x1f93c;"                            },
  { ":writing_hand:",                          "&#x270d;"                             },
  { ":x:",                                     "&#x274c;"                             },
  { ":yarn:",                                  "&#x1f9f6;"                            },
  { ":yawning_face:",                          "&#x1f971;"                            },
  { ":yellow_circle:",                         "&#x1f7e1;"                            },
  { ":yellow_heart:",                          "&#x1f49b;"                            },
  { ":yellow_square:",                         "&#x1f7e8;"                            },
  { ":yemen:",                                 "&#x1f1fe;&#x1f1ea;"                   },
  { ":yen:",                                   "&#x1f4b4;"                            },
  { ":yin_yang:",                              "&#x262f;"                             },
  { ":yo_yo:",                                 "&#x1fa80;"                            },
  { ":yum:",                                   "&#x1f60b;"                            },
  { ":zambia:",                                "&#x1f1ff;&#x1f1f2;"                   },
  { ":zany_face:",                             "&#x1f92a;"                            },
  { ":zap:",                                   "&#x26a1;"                             },
  { ":zebra:",                                 "&#x1f993;"                            },
  { ":zero:",                                  "&#x0030;&#xfe0f;&#x20e3;"             },
  { ":zimbabwe:",                              "&#x1f1ff;&#x1f1fc;"                   },
  { ":zipper_mouth_face:",                     "&#x1f910;"                            },
  { ":zombie:",                                "&#x1f9df;"                            },
  { ":zombie_man:",                            "&#x1f9df;&#x200d;&#x2642;&#xfe0f;"    },
  { ":zombie_woman:",                          "&#x1f9df;&#x200d;&#x2640;&#xfe0f;"    },
  { ":zzz:",                                   "&#x1f4a4;"                            },
};
// compatibility with older versions
static struct emojiEntityCompatibility
{
  const char *oldName;
  const char *newName;
} g_emojiCompatibilityEntities[] =
{
  {":blonde_man:",                            ":blond_haired_man:"},
  {":person_frowning:",                       ":frowning_person:"},
  {":person_with_blond_hair:",                ":blond_haired_person:"},
  {":person_with_pouting_face:",              ":pouting_face:"},
};

static const size_t g_numEmojiEntities = sizeof(g_emojiEntities)/sizeof(*g_emojiEntities);
static const size_t g_numEmojiCompatibilityEntities = sizeof(g_emojiCompatibilityEntities)/sizeof(*g_emojiCompatibilityEntities);

EmojiEntityMapper *EmojiEntityMapper::s_instance = 0;

EmojiEntityMapper::EmojiEntityMapper()
{
  for (size_t i = 0; i < g_numEmojiEntities; i++)
  {
    m_name2symGh.insert(std::make_pair(g_emojiEntities[i].name, static_cast<int>(i)));
  }
  for (size_t i = 0; i < g_numEmojiCompatibilityEntities; i++)
  {
    int ii = symbol2index(g_emojiCompatibilityEntities[i].newName);
    if (ii != -1) m_name2symGh.insert(std::make_pair(g_emojiCompatibilityEntities[i].oldName, ii));
  }
}

EmojiEntityMapper::~EmojiEntityMapper()
{
}

/** Returns the one and only instance of the Emoji entity mapper */
EmojiEntityMapper *EmojiEntityMapper::instance()
{
  if (s_instance==0)
  {
    s_instance = new EmojiEntityMapper;
  }
  return s_instance;
}

/** Deletes the one and only instance of the Emoji entity mapper */
void EmojiEntityMapper::deleteInstance()
{
  delete s_instance;
  s_instance=0;
}

/*!
 * @brief Returns a code for the requested Emoji entity name
 * @param symName Emoji entity name
 * @return the code for the requested Emoji entity name,
 *         in case the requested Emoji item does not exist `-1` is returned.
 */
int EmojiEntityMapper::symbol2index(const std::string &symName) const
{
  auto it = m_name2symGh.find(symName);
  return it!=m_name2symGh.end() ? it->second : -1;
}

/*!
 * @brief Writes the list of supported emojis to the given file.
 */
void EmojiEntityMapper::writeEmojiFile(TextStream &t)
{
  for (size_t i = 0; i < g_numEmojiEntities; i++)
  {
    t << g_emojiEntities[i].name << "\n";
  }
  for (size_t i = 0; i < g_numEmojiCompatibilityEntities; i++)
  {
    t << g_emojiCompatibilityEntities[i].oldName << "\n";
  }
}

/*! @brief Access routine to the unicode sequence for the Emoji entity
 *
 * @param index code of the requested Emoji entity returned by symbol2index()
 * @return the unicode sequence of the Emoji entity,
 */
const char *EmojiEntityMapper::unicode(int index) const
{
  return index>=0 && static_cast<size_t>(index)<g_numEmojiEntities ? g_emojiEntities[index].unicode : 0;
}

/*! @brief Access routine to the name of the Emoji entity
 *
 * @param index code of the requested Emoji entity returned by symbol2index()
 * @return the name of the Emoji entity in GitHub format (i.e. :smile:)
 */
const char *EmojiEntityMapper::name(int index) const
{
  return index>=0 && static_cast<size_t>(index)<g_numEmojiEntities ? g_emojiEntities[index].name : 0;
}
