/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.option;

import java.io.File;


/**
 * Die Klasse <code>DirectoryOption</code> verarbeitet ein Argument auf der
 * Kommandozeile, das ein Verzeichnis angibt. 
 * 
 * @author michael
 * 
 */
public class DirectoryOption extends Option<File> {

	private boolean isExisting = false;
	private boolean createPath = false;

	public DirectoryOption() {
		super();
		hasArgument(true);
	}

	public DirectoryOption(String longName) {
		super(longName);
		hasArgument(true);
	}

	public DirectoryOption(String longName, String shortName) {
		super(longName, shortName);
		hasArgument(true);
	}

	public void isExisting(boolean value) {
		isExisting = value;
	}

	public void setCreatePath(boolean createPath) {
		this.createPath = createPath;
	}

	protected boolean checkArgument(String arg) {

		arg = expandPath(arg);

		File file = new File(arg);

		if (file.exists() == false && createPath == true) {
			file.mkdirs();
		}

		if (isExisting == true && file.exists() == false) {
			return false;
		}

		if (file.exists() == true && file.isDirectory() == false) {
			return false;
		}

		return true;
	}

	@Override
	public void addValueFromString(String value) {
		addValue(new File(expandPath(value)));
	}

	@Override
	public void setValueFromString(String value) {
		setValue(new File(expandPath(value)));
	}

	@Override
	public OptionType getType() {
		return OptionType.FILE;
	}
}
