/*
                 Convert expression to boolean expression
                 Links are not generated by p_expr2bool(), but they
                 may exist.
*/

#include "parser.ih"

void p_expr2bool(SemVal *e)
{
    switch (e->type & (e_int | e_str | e_list | e_bool))
    {
        case e_int:
            if (test_type(e, e_const))
            {
                e->evalue = e->evalue != 0;
                set_type(e, e_int | e_const);
                return;
            }
        break;

        case e_str:
            if (test_type(e, e_const))
            {
                e->evalue = 1;
                set_type(e, e_int | e_const);
                return;
            }
        break;

        case e_bool:
            return;
    }
    p_expr2stack(e);                                /* convert to code */

    p_generateCode (e, op_jmp_true);
    p_generateCode (e, op_jmp, j_falselist);
    set_type(e, e_stack | e_bool);
}
