/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.ui;

import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import jonelo.jacksum.JacksumAPI;
import jonelo.jacksum.ui.MetaInfoVersionException;
import jonelo.sugar.util.Version;

public class MetaInfo {
    private boolean _r = false;
    private boolean _p = false;
    private boolean _A = false;
    private String timestampFormat = null;
    private char filesep = File.separatorChar;
    private int grouping = 0;
    private char groupChar = (char)32;
    private String algorithm = null;
    private String encoding = "";
    private String separator = null;
    private String commentchars = "Jacksum: Comment:";
    private Properties props = new Properties();
    public static final String METAINFO = "Jacksum: Meta-Info: ";

    public MetaInfo() {
    }

    public MetaInfo(String string) throws MetaInfoVersionException {
        this.parse(string);
    }

    public void parse(String string) throws MetaInfoVersionException {
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(METAINFO.length()), ";");
        while (stringTokenizer2.hasMoreTokens()) {
            stringTokenizer = new StringTokenizer(stringTokenizer2.nextToken(), "=");
            this.props.setProperty(stringTokenizer.nextToken(), stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "");
        }
        if (new Version(this.props.getProperty("version")).compareTo(JacksumAPI.getVersion()) > 0) {
            throw new MetaInfoVersionException("The file was generated by a newer version of Jacksum.\nUpgrade to the latest Jacksum release, at least to version " + this.props.getProperty("version"));
        }
        if (new Version(this.props.getProperty("version")).compareTo(new Version("1.6.0")) < 0) {
            this.props.setProperty("fieldsep", "\t");
        }
        this._A = false;
        this._r = false;
        this._p = false;
        this._r = false;
        String string2 = this.props.getProperty("flags", "");
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == 'A') {
                this._A = true;
                continue;
            }
            if (string2.charAt(i) == 'x') {
                this.encoding = "hex";
                continue;
            }
            if (string2.charAt(i) == 'X') {
                this.encoding = "hexup";
                continue;
            }
            if (string2.charAt(i) == 'r') {
                this._r = true;
                continue;
            }
            if (string2.charAt(i) != 'p') continue;
            this._p = true;
        }
        this.encoding = this.props.getProperty("encoding") == null || this.props.getProperty("encoding").length() == 0 ? null : this.props.getProperty("encoding");
        this.algorithm = this.props.getProperty("algorithm", "sha1");
        if (this.algorithm.equals("whirlpool") && new Version(this.props.getProperty("version")).compareTo(new Version("1.6.0")) < 0) {
            this.algorithm = "whirlpool1";
        }
        this.separator = this.props.getProperty("fieldsep") == null || this.props.getProperty("fieldsep").length() == 0 ? null : this.props.getProperty("fieldsep");
        if (this.props.getProperty("group") == null || this.props.getProperty("group").length() == 0) {
            this.grouping = 0;
        } else {
            try {
                this.grouping = Integer.parseInt(this.props.getProperty("group"));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Jacksum: Warning: Ignoring the group value, because the value is invalid.");
                this.grouping = 0;
            }
        }
        this.groupChar = this.props.getProperty("groupChar") == null || this.props.getProperty("groupChar").length() == 0 ? (char)32 : this.props.getProperty("groupChar").charAt(0);
        if (this.props.getProperty("comment") == null || this.props.getProperty("comment").length() == 0) {
            this.setCommentchars("Jacksum: Comment:");
        } else {
            this.setCommentchars(this.props.getProperty("comment"));
        }
        this.filesep = this.props.getProperty("filesep") == null || this.props.getProperty("filesep").length() == 0 ? File.separatorChar : this.props.getProperty("filesep").charAt(0);
        if (this.props.getProperty("tformat") == null || this.props.getProperty("tformat").length() == 0) {
            this.setTimestampFormat(null);
        } else if (this.props.getProperty("tformat").equals("null")) {
            System.err.println("Jacksum: Can't determine timeformat (tformat=null), trying default (tformat=yyyyMMddHHmmss)");
            this.setTimestampFormat("yyyyMMddHHmmss");
        } else {
            this.setTimestampFormat(this.props.getProperty("tformat"));
        }
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setVersion(String string) {
        this.props.setProperty("version", string);
    }

    public String getVersion() {
        return this.props.getProperty("version");
    }

    public void setRecursive(boolean bl) {
        this._r = bl;
    }

    public boolean isRecursive() {
        return this._r;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isEncoding() {
        return this.encoding != null;
    }

    public void setPathInfo(boolean bl) {
        this._p = bl;
    }

    public boolean isPathInfo() {
        return this._p;
    }

    public void setAlternate(boolean bl) {
        this._A = bl;
    }

    public boolean isAlternate() {
        return this._A;
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat = string;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public boolean isTimestampFormat() {
        return this.timestampFormat != null;
    }

    public void setGrouping(int n) {
        this.grouping = n;
    }

    public int getGrouping() {
        return this.grouping;
    }

    public boolean isGrouping() {
        return this.grouping > 0;
    }

    public void setGroupChar(char c) {
        this.groupChar = c;
    }

    public char getGroupChar() {
        return this.groupChar;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean isSeparatorWanted() {
        return this.separator != null;
    }

    public void setCommentchars(String string) {
        this.commentchars = string;
    }

    public String getCommentchars() {
        return this.commentchars;
    }

    public void setFilesep(char c) {
        this.filesep = c;
    }

    public char getFilesep() {
        return this.filesep;
    }

    public String getComment() {
        StringBuffer stringBuffer = new StringBuffer(240);
        stringBuffer.append(this.commentchars);
        stringBuffer.append(" created with ");
        stringBuffer.append("Jacksum");
        stringBuffer.append(" ");
        stringBuffer.append(JacksumAPI.getVersionString());
        stringBuffer.append(", http://jacksum.sourceforge.net");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(this.commentchars);
        stringBuffer.append(" created on ");
        stringBuffer.append(new Date());
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(this.commentchars);
        stringBuffer.append(" os name=");
        stringBuffer.append(System.getProperty("os.name"));
        stringBuffer.append(";os version=");
        stringBuffer.append(System.getProperty("os.version"));
        stringBuffer.append(";os arch=");
        stringBuffer.append(System.getProperty("os.arch"));
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(this.commentchars);
        stringBuffer.append(" jvm vendor=");
        stringBuffer.append(System.getProperty("java.vm.vendor"));
        stringBuffer.append(";jvm version=");
        stringBuffer.append(System.getProperty("java.vm.version"));
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(this.commentchars);
        stringBuffer.append(" user dir=");
        stringBuffer.append(System.getProperty("user.dir"));
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(METAINFO);
        stringBuffer.append("version=");
        stringBuffer.append(this.getVersion());
        stringBuffer.append(";");
        stringBuffer.append("algorithm=");
        stringBuffer.append(this.algorithm);
        stringBuffer.append(";");
        stringBuffer.append("filesep=");
        stringBuffer.append(this.filesep);
        stringBuffer.append(";");
        StringBuffer stringBuffer2 = new StringBuffer(5);
        if (this._r) {
            stringBuffer2.append('r');
        }
        if (this._p) {
            stringBuffer2.append('p');
        }
        if (this._A) {
            stringBuffer2.append('A');
        }
        if (stringBuffer2.toString().length() > 0) {
            stringBuffer.append("flags=");
            stringBuffer.append(stringBuffer2.toString());
            stringBuffer.append(";");
        }
        if (this.timestampFormat != null && this.timestampFormat.length() != 0) {
            stringBuffer.append("tformat=");
            stringBuffer.append(this.timestampFormat);
            stringBuffer.append(";");
        }
        if (this.grouping > 0) {
            stringBuffer.append("group=");
            stringBuffer.append(Integer.toString(this.grouping));
            stringBuffer.append(";");
            if (this.groupChar != ' ') {
                stringBuffer.append("groupChar=");
                stringBuffer.append(this.groupChar);
                stringBuffer.append(";");
            }
        }
        if (this.encoding != null && this.encoding.length() > 0) {
            stringBuffer.append("encoding=");
            stringBuffer.append(this.encoding);
            stringBuffer.append(";");
        }
        if (this.separator != null && !this.separator.equals("\t")) {
            stringBuffer.append("fieldsep=");
            stringBuffer.append(this.separator);
            stringBuffer.append(";");
        }
        if (this.commentchars.length() > 0 && !this.commentchars.equals("Jacksum: Comment:")) {
            stringBuffer.append("comment=");
            stringBuffer.append(this.commentchars);
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }
}

