/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={ResultSet.class, OracleResultSet.class, oracle.jdbc.internal.OracleResultSet.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class NonTxnReplayableResultSet
extends NonTxnReplayableBase
implements Replayable {
    private static final String RSET_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableResultSet";
    private static Logger RSET_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="deleteRow", args={}), @Signature(name="insertRow", args={}), @Signature(name="updateRow", args={})})
    protected void preForRowUpdates(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, entering preForRowUpdates({1})", new Object[]{this, method.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        } else {
            RSET_REPLAY_LOGGER.log(Level.SEVERE, "On result set {0}, failover manager not set", this);
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, exiting preForRowUpdates()", this);
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, entering preForRowUpdates({1})", new Object[]{this, method.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        } else {
            RSET_REPLAY_LOGGER.log(Level.SEVERE, "On result set {0}, failover manager not set", this);
        }
        RSET_REPLAY_LOGGER.log(Level.FINER, "On result set {0}, exiting preForRowUpdates()", this);
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="next", args={})})
    protected boolean postForNext(Method method, boolean bl) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingNext(method, bl, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplaying(method, bl, null);
            }
        }
        return bl;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.doPostWhenRecordingClose(method, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        this.onErrorForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method method, SQLException sQLException) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw sQLException;
        }
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (sQLException instanceof SQLRecoverableException && replayLifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            RSET_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, failed call for initial outage is last()", this);
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) throws SQLException {
        OracleStatement oracleStatement = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        long l2 = oracleStatement.getChecksum();
        RSET_REPLAY_LOGGER.log(Level.FINEST, "On proxy {0}, method {1}, filling in checksum: {2}", new Object[]{callHistoryEntry.jdbcProxy, callHistoryEntry.method, l2});
        this.failoverMngr.update(this, callHistoryEntry, callHistoryEntry.result, callHistoryEntry.callStatus, l2, callHistoryEntry.scn, callHistoryEntry.callException);
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = super.replayOneCall(callHistoryEntry, sQLRecoverableException);
        return object;
    }

    protected void doPostWhenRecordingNext(Method method, Object object, SQLException sQLException) {
        long l2 = 0L;
        OracleStatement oracleStatement = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        try {
            l2 = oracleStatement.getChecksum();
        }
        catch (SQLException sQLException2) {
            l2 = 0L;
            RSET_REPLAY_LOGGER.log(Level.WARNING, "On result set {0}, getChecksum() gets exception: {1}", new Object[]{this, sQLException2});
        }
        this.failoverMngr.update(this, null, object, "completed", l2, -1L, sQLException);
    }

    protected void doPostWhenRecordingClose(Method method, SQLException sQLException) {
        NonTxnReplayableStatement nonTxnReplayableStatement = (NonTxnReplayableStatement)this.getCreator();
        if (nonTxnReplayableStatement.okToPurgeSameProxyList()) {
            this.purgeSameProxyList();
        }
        this.isClosedAndNoReplay = true;
    }

    @Override
    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
        try {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case REPLAYING: {
                    if (this.replayingCallEntry.checksum == 0L) break;
                    OracleStatement oracleStatement = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
                    long l2 = oracleStatement.getChecksum();
                    RSET_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", new Object[]{this.replayingCallEntry.jdbcProxy, this.replayingCallEntry.method, l2, this.replayingCallEntry.checksum});
                    if (this.replayingCallEntry.checksum != l2) {
                        this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 386, "Replay failed because of checksum mismatch", this.originalError);
                    }
                    break;
                }
            }
        }
        catch (SQLException sQLException2) {
            RSET_REPLAY_LOGGER.log(Level.WARNING, "On result set {0}, doPostWhenReplaying exception: {1}", new Object[]{this, sQLException2});
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() {
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)this.getDelegate();
    }

    static {
        if (RSET_REPLAY_LOGGER == null) {
            RSET_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(RSET_FEATURE_LOGGER_NAME);
        }
    }
}

