"use strict";

var helpers = require("../../helpers/helpers");

exports["Australia/Victoria"] = {

	"guess:by:offset" : helpers.makeTestGuess("Australia/Victoria", { offset: true, expect: "Australia/Sydney" }),

	"guess:by:abbr" : helpers.makeTestGuess("Australia/Victoria", { abbr: true, expect: "Australia/Sydney" }),

	"1916" : helpers.makeTestYear("Australia/Victoria", [
		["1916-12-31T14:00:59+00:00", "00:00:59", "AEST", -600],
		["1916-12-31T14:01:00+00:00", "01:01:00", "AEDT", -660]
	]),

	"1917" : helpers.makeTestYear("Australia/Victoria", [
		["1917-03-24T14:59:59+00:00", "01:59:59", "AEDT", -660],
		["1917-03-24T15:00:00+00:00", "01:00:00", "AEST", -600]
	]),

	"1941" : helpers.makeTestYear("Australia/Victoria", [
		["1941-12-31T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1941-12-31T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1942" : helpers.makeTestYear("Australia/Victoria", [
		["1942-03-28T14:59:59+00:00", "01:59:59", "AEDT", -660],
		["1942-03-28T15:00:00+00:00", "01:00:00", "AEST", -600],
		["1942-09-26T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1942-09-26T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1943" : helpers.makeTestYear("Australia/Victoria", [
		["1943-03-27T14:59:59+00:00", "01:59:59", "AEDT", -660],
		["1943-03-27T15:00:00+00:00", "01:00:00", "AEST", -600],
		["1943-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1943-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1944" : helpers.makeTestYear("Australia/Victoria", [
		["1944-03-25T14:59:59+00:00", "01:59:59", "AEDT", -660],
		["1944-03-25T15:00:00+00:00", "01:00:00", "AEST", -600]
	]),

	"1971" : helpers.makeTestYear("Australia/Victoria", [
		["1971-10-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1971-10-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1972" : helpers.makeTestYear("Australia/Victoria", [
		["1972-02-26T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1972-02-26T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1972-10-28T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1972-10-28T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1973" : helpers.makeTestYear("Australia/Victoria", [
		["1973-03-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1973-03-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1973-10-27T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1973-10-27T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1974" : helpers.makeTestYear("Australia/Victoria", [
		["1974-03-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1974-03-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1974-10-26T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1974-10-26T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1975" : helpers.makeTestYear("Australia/Victoria", [
		["1975-03-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1975-03-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1975-10-25T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1975-10-25T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1976" : helpers.makeTestYear("Australia/Victoria", [
		["1976-03-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1976-03-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1976-10-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1976-10-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1977" : helpers.makeTestYear("Australia/Victoria", [
		["1977-03-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1977-03-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1977-10-29T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1977-10-29T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1978" : helpers.makeTestYear("Australia/Victoria", [
		["1978-03-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1978-03-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1978-10-28T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1978-10-28T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1979" : helpers.makeTestYear("Australia/Victoria", [
		["1979-03-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1979-03-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1979-10-27T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1979-10-27T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1980" : helpers.makeTestYear("Australia/Victoria", [
		["1980-03-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1980-03-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1980-10-25T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1980-10-25T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1981" : helpers.makeTestYear("Australia/Victoria", [
		["1981-02-28T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1981-02-28T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1981-10-24T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1981-10-24T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1982" : helpers.makeTestYear("Australia/Victoria", [
		["1982-03-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1982-03-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1982-10-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1982-10-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1983" : helpers.makeTestYear("Australia/Victoria", [
		["1983-03-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1983-03-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1983-10-29T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1983-10-29T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1984" : helpers.makeTestYear("Australia/Victoria", [
		["1984-03-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1984-03-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1984-10-27T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1984-10-27T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1985" : helpers.makeTestYear("Australia/Victoria", [
		["1985-03-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1985-03-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1985-10-26T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1985-10-26T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1986" : helpers.makeTestYear("Australia/Victoria", [
		["1986-03-15T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1986-03-15T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1986-10-18T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1986-10-18T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1987" : helpers.makeTestYear("Australia/Victoria", [
		["1987-03-14T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1987-03-14T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1987-10-17T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1987-10-17T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1988" : helpers.makeTestYear("Australia/Victoria", [
		["1988-03-19T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1988-03-19T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1988-10-29T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1988-10-29T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1989" : helpers.makeTestYear("Australia/Victoria", [
		["1989-03-18T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1989-03-18T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1989-10-28T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1989-10-28T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1990" : helpers.makeTestYear("Australia/Victoria", [
		["1990-03-17T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1990-03-17T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1990-10-27T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1990-10-27T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1991" : helpers.makeTestYear("Australia/Victoria", [
		["1991-03-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1991-03-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1991-10-26T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1991-10-26T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1992" : helpers.makeTestYear("Australia/Victoria", [
		["1992-02-29T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1992-02-29T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1992-10-24T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1992-10-24T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1993" : helpers.makeTestYear("Australia/Victoria", [
		["1993-03-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1993-03-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1993-10-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1993-10-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1994" : helpers.makeTestYear("Australia/Victoria", [
		["1994-03-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1994-03-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1994-10-29T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1994-10-29T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1995" : helpers.makeTestYear("Australia/Victoria", [
		["1995-03-25T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1995-03-25T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1995-10-28T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1995-10-28T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1996" : helpers.makeTestYear("Australia/Victoria", [
		["1996-03-30T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1996-03-30T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1996-10-26T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1996-10-26T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1997" : helpers.makeTestYear("Australia/Victoria", [
		["1997-03-29T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1997-03-29T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1997-10-25T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1997-10-25T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1998" : helpers.makeTestYear("Australia/Victoria", [
		["1998-03-28T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1998-03-28T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1998-10-24T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1998-10-24T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"1999" : helpers.makeTestYear("Australia/Victoria", [
		["1999-03-27T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["1999-03-27T16:00:00+00:00", "02:00:00", "AEST", -600],
		["1999-10-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["1999-10-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2000" : helpers.makeTestYear("Australia/Victoria", [
		["2000-03-25T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2000-03-25T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2000-08-26T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2000-08-26T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2001" : helpers.makeTestYear("Australia/Victoria", [
		["2001-03-24T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2001-03-24T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2001-10-27T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2001-10-27T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2002" : helpers.makeTestYear("Australia/Victoria", [
		["2002-03-30T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2002-03-30T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2002-10-26T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2002-10-26T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2003" : helpers.makeTestYear("Australia/Victoria", [
		["2003-03-29T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2003-03-29T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2003-10-25T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2003-10-25T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2004" : helpers.makeTestYear("Australia/Victoria", [
		["2004-03-27T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2004-03-27T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2004-10-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2004-10-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2005" : helpers.makeTestYear("Australia/Victoria", [
		["2005-03-26T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2005-03-26T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2005-10-29T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2005-10-29T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2006" : helpers.makeTestYear("Australia/Victoria", [
		["2006-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2006-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2006-10-28T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2006-10-28T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2007" : helpers.makeTestYear("Australia/Victoria", [
		["2007-03-24T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2007-03-24T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2007-10-27T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2007-10-27T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2008" : helpers.makeTestYear("Australia/Victoria", [
		["2008-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2008-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2008-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2008-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2009" : helpers.makeTestYear("Australia/Victoria", [
		["2009-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2009-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2009-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2009-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2010" : helpers.makeTestYear("Australia/Victoria", [
		["2010-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2010-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2010-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2010-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2011" : helpers.makeTestYear("Australia/Victoria", [
		["2011-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2011-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2011-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2011-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2012" : helpers.makeTestYear("Australia/Victoria", [
		["2012-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2012-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2012-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2012-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2013" : helpers.makeTestYear("Australia/Victoria", [
		["2013-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2013-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2013-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2013-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2014" : helpers.makeTestYear("Australia/Victoria", [
		["2014-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2014-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2014-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2014-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2015" : helpers.makeTestYear("Australia/Victoria", [
		["2015-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2015-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2015-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2015-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2016" : helpers.makeTestYear("Australia/Victoria", [
		["2016-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2016-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2016-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2016-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2017" : helpers.makeTestYear("Australia/Victoria", [
		["2017-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2017-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2017-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2017-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2018" : helpers.makeTestYear("Australia/Victoria", [
		["2018-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2018-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2018-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2018-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2019" : helpers.makeTestYear("Australia/Victoria", [
		["2019-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2019-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2019-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2019-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2020" : helpers.makeTestYear("Australia/Victoria", [
		["2020-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2020-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2020-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2020-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2021" : helpers.makeTestYear("Australia/Victoria", [
		["2021-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2021-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2021-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2021-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2022" : helpers.makeTestYear("Australia/Victoria", [
		["2022-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2022-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2022-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2022-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2023" : helpers.makeTestYear("Australia/Victoria", [
		["2023-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2023-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2023-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2023-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2024" : helpers.makeTestYear("Australia/Victoria", [
		["2024-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2024-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2024-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2024-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2025" : helpers.makeTestYear("Australia/Victoria", [
		["2025-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2025-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2025-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2025-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2026" : helpers.makeTestYear("Australia/Victoria", [
		["2026-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2026-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2026-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2026-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2027" : helpers.makeTestYear("Australia/Victoria", [
		["2027-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2027-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2027-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2027-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2028" : helpers.makeTestYear("Australia/Victoria", [
		["2028-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2028-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2028-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2028-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2029" : helpers.makeTestYear("Australia/Victoria", [
		["2029-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2029-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2029-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2029-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2030" : helpers.makeTestYear("Australia/Victoria", [
		["2030-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2030-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2030-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2030-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2031" : helpers.makeTestYear("Australia/Victoria", [
		["2031-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2031-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2031-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2031-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2032" : helpers.makeTestYear("Australia/Victoria", [
		["2032-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2032-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2032-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2032-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2033" : helpers.makeTestYear("Australia/Victoria", [
		["2033-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2033-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2033-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2033-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2034" : helpers.makeTestYear("Australia/Victoria", [
		["2034-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2034-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2034-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2034-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2035" : helpers.makeTestYear("Australia/Victoria", [
		["2035-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2035-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2035-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2035-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2036" : helpers.makeTestYear("Australia/Victoria", [
		["2036-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2036-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2036-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2036-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2037" : helpers.makeTestYear("Australia/Victoria", [
		["2037-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2037-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2037-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2037-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2038" : helpers.makeTestYear("Australia/Victoria", [
		["2038-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2038-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2038-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2038-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2039" : helpers.makeTestYear("Australia/Victoria", [
		["2039-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2039-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2039-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2039-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2040" : helpers.makeTestYear("Australia/Victoria", [
		["2040-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2040-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2040-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2040-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2041" : helpers.makeTestYear("Australia/Victoria", [
		["2041-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2041-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2041-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2041-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2042" : helpers.makeTestYear("Australia/Victoria", [
		["2042-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2042-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2042-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2042-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2043" : helpers.makeTestYear("Australia/Victoria", [
		["2043-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2043-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2043-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2043-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2044" : helpers.makeTestYear("Australia/Victoria", [
		["2044-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2044-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2044-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2044-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2045" : helpers.makeTestYear("Australia/Victoria", [
		["2045-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2045-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2045-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2045-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2046" : helpers.makeTestYear("Australia/Victoria", [
		["2046-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2046-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2046-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2046-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2047" : helpers.makeTestYear("Australia/Victoria", [
		["2047-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2047-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2047-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2047-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2048" : helpers.makeTestYear("Australia/Victoria", [
		["2048-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2048-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2048-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2048-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2049" : helpers.makeTestYear("Australia/Victoria", [
		["2049-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2049-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2049-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2049-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2050" : helpers.makeTestYear("Australia/Victoria", [
		["2050-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2050-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2050-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2050-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2051" : helpers.makeTestYear("Australia/Victoria", [
		["2051-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2051-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2051-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2051-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2052" : helpers.makeTestYear("Australia/Victoria", [
		["2052-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2052-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2052-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2052-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2053" : helpers.makeTestYear("Australia/Victoria", [
		["2053-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2053-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2053-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2053-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2054" : helpers.makeTestYear("Australia/Victoria", [
		["2054-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2054-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2054-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2054-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2055" : helpers.makeTestYear("Australia/Victoria", [
		["2055-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2055-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2055-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2055-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2056" : helpers.makeTestYear("Australia/Victoria", [
		["2056-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2056-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2056-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2056-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2057" : helpers.makeTestYear("Australia/Victoria", [
		["2057-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2057-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2057-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2057-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2058" : helpers.makeTestYear("Australia/Victoria", [
		["2058-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2058-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2058-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2058-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2059" : helpers.makeTestYear("Australia/Victoria", [
		["2059-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2059-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2059-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2059-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2060" : helpers.makeTestYear("Australia/Victoria", [
		["2060-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2060-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2060-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2060-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2061" : helpers.makeTestYear("Australia/Victoria", [
		["2061-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2061-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2061-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2061-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2062" : helpers.makeTestYear("Australia/Victoria", [
		["2062-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2062-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2062-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2062-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2063" : helpers.makeTestYear("Australia/Victoria", [
		["2063-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2063-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2063-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2063-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2064" : helpers.makeTestYear("Australia/Victoria", [
		["2064-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2064-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2064-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2064-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2065" : helpers.makeTestYear("Australia/Victoria", [
		["2065-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2065-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2065-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2065-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2066" : helpers.makeTestYear("Australia/Victoria", [
		["2066-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2066-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2066-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2066-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2067" : helpers.makeTestYear("Australia/Victoria", [
		["2067-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2067-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2067-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2067-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2068" : helpers.makeTestYear("Australia/Victoria", [
		["2068-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2068-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2068-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2068-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2069" : helpers.makeTestYear("Australia/Victoria", [
		["2069-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2069-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2069-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2069-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2070" : helpers.makeTestYear("Australia/Victoria", [
		["2070-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2070-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2070-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2070-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2071" : helpers.makeTestYear("Australia/Victoria", [
		["2071-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2071-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2071-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2071-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2072" : helpers.makeTestYear("Australia/Victoria", [
		["2072-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2072-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2072-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2072-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2073" : helpers.makeTestYear("Australia/Victoria", [
		["2073-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2073-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2073-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2073-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2074" : helpers.makeTestYear("Australia/Victoria", [
		["2074-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2074-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2074-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2074-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2075" : helpers.makeTestYear("Australia/Victoria", [
		["2075-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2075-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2075-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2075-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2076" : helpers.makeTestYear("Australia/Victoria", [
		["2076-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2076-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2076-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2076-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2077" : helpers.makeTestYear("Australia/Victoria", [
		["2077-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2077-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2077-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2077-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2078" : helpers.makeTestYear("Australia/Victoria", [
		["2078-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2078-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2078-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2078-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2079" : helpers.makeTestYear("Australia/Victoria", [
		["2079-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2079-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2079-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2079-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2080" : helpers.makeTestYear("Australia/Victoria", [
		["2080-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2080-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2080-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2080-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2081" : helpers.makeTestYear("Australia/Victoria", [
		["2081-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2081-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2081-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2081-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2082" : helpers.makeTestYear("Australia/Victoria", [
		["2082-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2082-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2082-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2082-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2083" : helpers.makeTestYear("Australia/Victoria", [
		["2083-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2083-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2083-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2083-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2084" : helpers.makeTestYear("Australia/Victoria", [
		["2084-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2084-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2084-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2084-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2085" : helpers.makeTestYear("Australia/Victoria", [
		["2085-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2085-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2085-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2085-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2086" : helpers.makeTestYear("Australia/Victoria", [
		["2086-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2086-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2086-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2086-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2087" : helpers.makeTestYear("Australia/Victoria", [
		["2087-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2087-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2087-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2087-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2088" : helpers.makeTestYear("Australia/Victoria", [
		["2088-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2088-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2088-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2088-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2089" : helpers.makeTestYear("Australia/Victoria", [
		["2089-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2089-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2089-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2089-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2090" : helpers.makeTestYear("Australia/Victoria", [
		["2090-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2090-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2090-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2090-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2091" : helpers.makeTestYear("Australia/Victoria", [
		["2091-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2091-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2091-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2091-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2092" : helpers.makeTestYear("Australia/Victoria", [
		["2092-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2092-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2092-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2092-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2093" : helpers.makeTestYear("Australia/Victoria", [
		["2093-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2093-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2093-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2093-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2094" : helpers.makeTestYear("Australia/Victoria", [
		["2094-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2094-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2094-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2094-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2095" : helpers.makeTestYear("Australia/Victoria", [
		["2095-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2095-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2095-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2095-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2096" : helpers.makeTestYear("Australia/Victoria", [
		["2096-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2096-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2096-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2096-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2097" : helpers.makeTestYear("Australia/Victoria", [
		["2097-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2097-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2097-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2097-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2098" : helpers.makeTestYear("Australia/Victoria", [
		["2098-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2098-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2098-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2098-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2099" : helpers.makeTestYear("Australia/Victoria", [
		["2099-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2099-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2099-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2099-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2100" : helpers.makeTestYear("Australia/Victoria", [
		["2100-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2100-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2100-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2100-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2101" : helpers.makeTestYear("Australia/Victoria", [
		["2101-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2101-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2101-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2101-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2102" : helpers.makeTestYear("Australia/Victoria", [
		["2102-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2102-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2102-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2102-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2103" : helpers.makeTestYear("Australia/Victoria", [
		["2103-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2103-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2103-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2103-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2104" : helpers.makeTestYear("Australia/Victoria", [
		["2104-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2104-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2104-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2104-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2105" : helpers.makeTestYear("Australia/Victoria", [
		["2105-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2105-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2105-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2105-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2106" : helpers.makeTestYear("Australia/Victoria", [
		["2106-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2106-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2106-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2106-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2107" : helpers.makeTestYear("Australia/Victoria", [
		["2107-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2107-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2107-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2107-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2108" : helpers.makeTestYear("Australia/Victoria", [
		["2108-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2108-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2108-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2108-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2109" : helpers.makeTestYear("Australia/Victoria", [
		["2109-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2109-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2109-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2109-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2110" : helpers.makeTestYear("Australia/Victoria", [
		["2110-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2110-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2110-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2110-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2111" : helpers.makeTestYear("Australia/Victoria", [
		["2111-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2111-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2111-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2111-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2112" : helpers.makeTestYear("Australia/Victoria", [
		["2112-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2112-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2112-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2112-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2113" : helpers.makeTestYear("Australia/Victoria", [
		["2113-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2113-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2113-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2113-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2114" : helpers.makeTestYear("Australia/Victoria", [
		["2114-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2114-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2114-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2114-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2115" : helpers.makeTestYear("Australia/Victoria", [
		["2115-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2115-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2115-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2115-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2116" : helpers.makeTestYear("Australia/Victoria", [
		["2116-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2116-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2116-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2116-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2117" : helpers.makeTestYear("Australia/Victoria", [
		["2117-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2117-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2117-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2117-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2118" : helpers.makeTestYear("Australia/Victoria", [
		["2118-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2118-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2118-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2118-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2119" : helpers.makeTestYear("Australia/Victoria", [
		["2119-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2119-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2119-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2119-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2120" : helpers.makeTestYear("Australia/Victoria", [
		["2120-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2120-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2120-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2120-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2121" : helpers.makeTestYear("Australia/Victoria", [
		["2121-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2121-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2121-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2121-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2122" : helpers.makeTestYear("Australia/Victoria", [
		["2122-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2122-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2122-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2122-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2123" : helpers.makeTestYear("Australia/Victoria", [
		["2123-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2123-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2123-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2123-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2124" : helpers.makeTestYear("Australia/Victoria", [
		["2124-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2124-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2124-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2124-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2125" : helpers.makeTestYear("Australia/Victoria", [
		["2125-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2125-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2125-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2125-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2126" : helpers.makeTestYear("Australia/Victoria", [
		["2126-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2126-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2126-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2126-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2127" : helpers.makeTestYear("Australia/Victoria", [
		["2127-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2127-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2127-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2127-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2128" : helpers.makeTestYear("Australia/Victoria", [
		["2128-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2128-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2128-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2128-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2129" : helpers.makeTestYear("Australia/Victoria", [
		["2129-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2129-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2129-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2129-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2130" : helpers.makeTestYear("Australia/Victoria", [
		["2130-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2130-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2130-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2130-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2131" : helpers.makeTestYear("Australia/Victoria", [
		["2131-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2131-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2131-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2131-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2132" : helpers.makeTestYear("Australia/Victoria", [
		["2132-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2132-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2132-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2132-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2133" : helpers.makeTestYear("Australia/Victoria", [
		["2133-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2133-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2133-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2133-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2134" : helpers.makeTestYear("Australia/Victoria", [
		["2134-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2134-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2134-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2134-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2135" : helpers.makeTestYear("Australia/Victoria", [
		["2135-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2135-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2135-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2135-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2136" : helpers.makeTestYear("Australia/Victoria", [
		["2136-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2136-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2136-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2136-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2137" : helpers.makeTestYear("Australia/Victoria", [
		["2137-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2137-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2137-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2137-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2138" : helpers.makeTestYear("Australia/Victoria", [
		["2138-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2138-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2138-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2138-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2139" : helpers.makeTestYear("Australia/Victoria", [
		["2139-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2139-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2139-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2139-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2140" : helpers.makeTestYear("Australia/Victoria", [
		["2140-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2140-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2140-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2140-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2141" : helpers.makeTestYear("Australia/Victoria", [
		["2141-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2141-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2141-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2141-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2142" : helpers.makeTestYear("Australia/Victoria", [
		["2142-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2142-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2142-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2142-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2143" : helpers.makeTestYear("Australia/Victoria", [
		["2143-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2143-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2143-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2143-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2144" : helpers.makeTestYear("Australia/Victoria", [
		["2144-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2144-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2144-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2144-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2145" : helpers.makeTestYear("Australia/Victoria", [
		["2145-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2145-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2145-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2145-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2146" : helpers.makeTestYear("Australia/Victoria", [
		["2146-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2146-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2146-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2146-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2147" : helpers.makeTestYear("Australia/Victoria", [
		["2147-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2147-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2147-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2147-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2148" : helpers.makeTestYear("Australia/Victoria", [
		["2148-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2148-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2148-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2148-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2149" : helpers.makeTestYear("Australia/Victoria", [
		["2149-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2149-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2149-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2149-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2150" : helpers.makeTestYear("Australia/Victoria", [
		["2150-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2150-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2150-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2150-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2151" : helpers.makeTestYear("Australia/Victoria", [
		["2151-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2151-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2151-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2151-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2152" : helpers.makeTestYear("Australia/Victoria", [
		["2152-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2152-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2152-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2152-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2153" : helpers.makeTestYear("Australia/Victoria", [
		["2153-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2153-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2153-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2153-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2154" : helpers.makeTestYear("Australia/Victoria", [
		["2154-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2154-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2154-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2154-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2155" : helpers.makeTestYear("Australia/Victoria", [
		["2155-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2155-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2155-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2155-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2156" : helpers.makeTestYear("Australia/Victoria", [
		["2156-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2156-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2156-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2156-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2157" : helpers.makeTestYear("Australia/Victoria", [
		["2157-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2157-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2157-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2157-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2158" : helpers.makeTestYear("Australia/Victoria", [
		["2158-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2158-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2158-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2158-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2159" : helpers.makeTestYear("Australia/Victoria", [
		["2159-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2159-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2159-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2159-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2160" : helpers.makeTestYear("Australia/Victoria", [
		["2160-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2160-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2160-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2160-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2161" : helpers.makeTestYear("Australia/Victoria", [
		["2161-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2161-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2161-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2161-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2162" : helpers.makeTestYear("Australia/Victoria", [
		["2162-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2162-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2162-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2162-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2163" : helpers.makeTestYear("Australia/Victoria", [
		["2163-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2163-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2163-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2163-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2164" : helpers.makeTestYear("Australia/Victoria", [
		["2164-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2164-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2164-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2164-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2165" : helpers.makeTestYear("Australia/Victoria", [
		["2165-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2165-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2165-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2165-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2166" : helpers.makeTestYear("Australia/Victoria", [
		["2166-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2166-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2166-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2166-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2167" : helpers.makeTestYear("Australia/Victoria", [
		["2167-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2167-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2167-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2167-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2168" : helpers.makeTestYear("Australia/Victoria", [
		["2168-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2168-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2168-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2168-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2169" : helpers.makeTestYear("Australia/Victoria", [
		["2169-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2169-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2169-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2169-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2170" : helpers.makeTestYear("Australia/Victoria", [
		["2170-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2170-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2170-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2170-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2171" : helpers.makeTestYear("Australia/Victoria", [
		["2171-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2171-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2171-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2171-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2172" : helpers.makeTestYear("Australia/Victoria", [
		["2172-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2172-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2172-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2172-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2173" : helpers.makeTestYear("Australia/Victoria", [
		["2173-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2173-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2173-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2173-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2174" : helpers.makeTestYear("Australia/Victoria", [
		["2174-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2174-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2174-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2174-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2175" : helpers.makeTestYear("Australia/Victoria", [
		["2175-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2175-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2175-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2175-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2176" : helpers.makeTestYear("Australia/Victoria", [
		["2176-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2176-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2176-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2176-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2177" : helpers.makeTestYear("Australia/Victoria", [
		["2177-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2177-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2177-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2177-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2178" : helpers.makeTestYear("Australia/Victoria", [
		["2178-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2178-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2178-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2178-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2179" : helpers.makeTestYear("Australia/Victoria", [
		["2179-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2179-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2179-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2179-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2180" : helpers.makeTestYear("Australia/Victoria", [
		["2180-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2180-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2180-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2180-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2181" : helpers.makeTestYear("Australia/Victoria", [
		["2181-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2181-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2181-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2181-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2182" : helpers.makeTestYear("Australia/Victoria", [
		["2182-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2182-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2182-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2182-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2183" : helpers.makeTestYear("Australia/Victoria", [
		["2183-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2183-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2183-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2183-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2184" : helpers.makeTestYear("Australia/Victoria", [
		["2184-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2184-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2184-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2184-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2185" : helpers.makeTestYear("Australia/Victoria", [
		["2185-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2185-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2185-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2185-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2186" : helpers.makeTestYear("Australia/Victoria", [
		["2186-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2186-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2186-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2186-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2187" : helpers.makeTestYear("Australia/Victoria", [
		["2187-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2187-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2187-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2187-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2188" : helpers.makeTestYear("Australia/Victoria", [
		["2188-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2188-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2188-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2188-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2189" : helpers.makeTestYear("Australia/Victoria", [
		["2189-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2189-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2189-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2189-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2190" : helpers.makeTestYear("Australia/Victoria", [
		["2190-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2190-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2190-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2190-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2191" : helpers.makeTestYear("Australia/Victoria", [
		["2191-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2191-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2191-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2191-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2192" : helpers.makeTestYear("Australia/Victoria", [
		["2192-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2192-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2192-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2192-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2193" : helpers.makeTestYear("Australia/Victoria", [
		["2193-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2193-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2193-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2193-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2194" : helpers.makeTestYear("Australia/Victoria", [
		["2194-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2194-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2194-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2194-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2195" : helpers.makeTestYear("Australia/Victoria", [
		["2195-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2195-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2195-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2195-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2196" : helpers.makeTestYear("Australia/Victoria", [
		["2196-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2196-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2196-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2196-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2197" : helpers.makeTestYear("Australia/Victoria", [
		["2197-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2197-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2197-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2197-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2198" : helpers.makeTestYear("Australia/Victoria", [
		["2198-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2198-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2198-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2198-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2199" : helpers.makeTestYear("Australia/Victoria", [
		["2199-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2199-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2199-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2199-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2200" : helpers.makeTestYear("Australia/Victoria", [
		["2200-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2200-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2200-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2200-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2201" : helpers.makeTestYear("Australia/Victoria", [
		["2201-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2201-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2201-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2201-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2202" : helpers.makeTestYear("Australia/Victoria", [
		["2202-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2202-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2202-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2202-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2203" : helpers.makeTestYear("Australia/Victoria", [
		["2203-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2203-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2203-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2203-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2204" : helpers.makeTestYear("Australia/Victoria", [
		["2204-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2204-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2204-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2204-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2205" : helpers.makeTestYear("Australia/Victoria", [
		["2205-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2205-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2205-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2205-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2206" : helpers.makeTestYear("Australia/Victoria", [
		["2206-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2206-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2206-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2206-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2207" : helpers.makeTestYear("Australia/Victoria", [
		["2207-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2207-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2207-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2207-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2208" : helpers.makeTestYear("Australia/Victoria", [
		["2208-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2208-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2208-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2208-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2209" : helpers.makeTestYear("Australia/Victoria", [
		["2209-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2209-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2209-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2209-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2210" : helpers.makeTestYear("Australia/Victoria", [
		["2210-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2210-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2210-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2210-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2211" : helpers.makeTestYear("Australia/Victoria", [
		["2211-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2211-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2211-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2211-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2212" : helpers.makeTestYear("Australia/Victoria", [
		["2212-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2212-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2212-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2212-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2213" : helpers.makeTestYear("Australia/Victoria", [
		["2213-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2213-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2213-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2213-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2214" : helpers.makeTestYear("Australia/Victoria", [
		["2214-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2214-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2214-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2214-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2215" : helpers.makeTestYear("Australia/Victoria", [
		["2215-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2215-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2215-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2215-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2216" : helpers.makeTestYear("Australia/Victoria", [
		["2216-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2216-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2216-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2216-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2217" : helpers.makeTestYear("Australia/Victoria", [
		["2217-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2217-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2217-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2217-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2218" : helpers.makeTestYear("Australia/Victoria", [
		["2218-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2218-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2218-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2218-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2219" : helpers.makeTestYear("Australia/Victoria", [
		["2219-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2219-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2219-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2219-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2220" : helpers.makeTestYear("Australia/Victoria", [
		["2220-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2220-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2220-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2220-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2221" : helpers.makeTestYear("Australia/Victoria", [
		["2221-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2221-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2221-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2221-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2222" : helpers.makeTestYear("Australia/Victoria", [
		["2222-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2222-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2222-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2222-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2223" : helpers.makeTestYear("Australia/Victoria", [
		["2223-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2223-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2223-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2223-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2224" : helpers.makeTestYear("Australia/Victoria", [
		["2224-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2224-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2224-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2224-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2225" : helpers.makeTestYear("Australia/Victoria", [
		["2225-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2225-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2225-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2225-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2226" : helpers.makeTestYear("Australia/Victoria", [
		["2226-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2226-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2226-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2226-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2227" : helpers.makeTestYear("Australia/Victoria", [
		["2227-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2227-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2227-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2227-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2228" : helpers.makeTestYear("Australia/Victoria", [
		["2228-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2228-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2228-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2228-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2229" : helpers.makeTestYear("Australia/Victoria", [
		["2229-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2229-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2229-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2229-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2230" : helpers.makeTestYear("Australia/Victoria", [
		["2230-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2230-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2230-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2230-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2231" : helpers.makeTestYear("Australia/Victoria", [
		["2231-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2231-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2231-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2231-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2232" : helpers.makeTestYear("Australia/Victoria", [
		["2232-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2232-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2232-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2232-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2233" : helpers.makeTestYear("Australia/Victoria", [
		["2233-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2233-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2233-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2233-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2234" : helpers.makeTestYear("Australia/Victoria", [
		["2234-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2234-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2234-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2234-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2235" : helpers.makeTestYear("Australia/Victoria", [
		["2235-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2235-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2235-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2235-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2236" : helpers.makeTestYear("Australia/Victoria", [
		["2236-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2236-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2236-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2236-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2237" : helpers.makeTestYear("Australia/Victoria", [
		["2237-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2237-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2237-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2237-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2238" : helpers.makeTestYear("Australia/Victoria", [
		["2238-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2238-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2238-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2238-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2239" : helpers.makeTestYear("Australia/Victoria", [
		["2239-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2239-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2239-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2239-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2240" : helpers.makeTestYear("Australia/Victoria", [
		["2240-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2240-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2240-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2240-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2241" : helpers.makeTestYear("Australia/Victoria", [
		["2241-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2241-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2241-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2241-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2242" : helpers.makeTestYear("Australia/Victoria", [
		["2242-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2242-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2242-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2242-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2243" : helpers.makeTestYear("Australia/Victoria", [
		["2243-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2243-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2243-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2243-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2244" : helpers.makeTestYear("Australia/Victoria", [
		["2244-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2244-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2244-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2244-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2245" : helpers.makeTestYear("Australia/Victoria", [
		["2245-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2245-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2245-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2245-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2246" : helpers.makeTestYear("Australia/Victoria", [
		["2246-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2246-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2246-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2246-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2247" : helpers.makeTestYear("Australia/Victoria", [
		["2247-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2247-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2247-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2247-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2248" : helpers.makeTestYear("Australia/Victoria", [
		["2248-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2248-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2248-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2248-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2249" : helpers.makeTestYear("Australia/Victoria", [
		["2249-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2249-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2249-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2249-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2250" : helpers.makeTestYear("Australia/Victoria", [
		["2250-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2250-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2250-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2250-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2251" : helpers.makeTestYear("Australia/Victoria", [
		["2251-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2251-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2251-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2251-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2252" : helpers.makeTestYear("Australia/Victoria", [
		["2252-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2252-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2252-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2252-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2253" : helpers.makeTestYear("Australia/Victoria", [
		["2253-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2253-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2253-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2253-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2254" : helpers.makeTestYear("Australia/Victoria", [
		["2254-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2254-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2254-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2254-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2255" : helpers.makeTestYear("Australia/Victoria", [
		["2255-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2255-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2255-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2255-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2256" : helpers.makeTestYear("Australia/Victoria", [
		["2256-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2256-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2256-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2256-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2257" : helpers.makeTestYear("Australia/Victoria", [
		["2257-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2257-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2257-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2257-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2258" : helpers.makeTestYear("Australia/Victoria", [
		["2258-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2258-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2258-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2258-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2259" : helpers.makeTestYear("Australia/Victoria", [
		["2259-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2259-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2259-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2259-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2260" : helpers.makeTestYear("Australia/Victoria", [
		["2260-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2260-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2260-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2260-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2261" : helpers.makeTestYear("Australia/Victoria", [
		["2261-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2261-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2261-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2261-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2262" : helpers.makeTestYear("Australia/Victoria", [
		["2262-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2262-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2262-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2262-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2263" : helpers.makeTestYear("Australia/Victoria", [
		["2263-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2263-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2263-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2263-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2264" : helpers.makeTestYear("Australia/Victoria", [
		["2264-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2264-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2264-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2264-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2265" : helpers.makeTestYear("Australia/Victoria", [
		["2265-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2265-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2265-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2265-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2266" : helpers.makeTestYear("Australia/Victoria", [
		["2266-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2266-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2266-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2266-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2267" : helpers.makeTestYear("Australia/Victoria", [
		["2267-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2267-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2267-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2267-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2268" : helpers.makeTestYear("Australia/Victoria", [
		["2268-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2268-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2268-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2268-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2269" : helpers.makeTestYear("Australia/Victoria", [
		["2269-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2269-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2269-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2269-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2270" : helpers.makeTestYear("Australia/Victoria", [
		["2270-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2270-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2270-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2270-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2271" : helpers.makeTestYear("Australia/Victoria", [
		["2271-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2271-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2271-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2271-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2272" : helpers.makeTestYear("Australia/Victoria", [
		["2272-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2272-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2272-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2272-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2273" : helpers.makeTestYear("Australia/Victoria", [
		["2273-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2273-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2273-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2273-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2274" : helpers.makeTestYear("Australia/Victoria", [
		["2274-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2274-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2274-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2274-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2275" : helpers.makeTestYear("Australia/Victoria", [
		["2275-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2275-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2275-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2275-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2276" : helpers.makeTestYear("Australia/Victoria", [
		["2276-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2276-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2276-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2276-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2277" : helpers.makeTestYear("Australia/Victoria", [
		["2277-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2277-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2277-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2277-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2278" : helpers.makeTestYear("Australia/Victoria", [
		["2278-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2278-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2278-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2278-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2279" : helpers.makeTestYear("Australia/Victoria", [
		["2279-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2279-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2279-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2279-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2280" : helpers.makeTestYear("Australia/Victoria", [
		["2280-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2280-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2280-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2280-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2281" : helpers.makeTestYear("Australia/Victoria", [
		["2281-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2281-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2281-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2281-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2282" : helpers.makeTestYear("Australia/Victoria", [
		["2282-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2282-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2282-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2282-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2283" : helpers.makeTestYear("Australia/Victoria", [
		["2283-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2283-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2283-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2283-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2284" : helpers.makeTestYear("Australia/Victoria", [
		["2284-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2284-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2284-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2284-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2285" : helpers.makeTestYear("Australia/Victoria", [
		["2285-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2285-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2285-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2285-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2286" : helpers.makeTestYear("Australia/Victoria", [
		["2286-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2286-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2286-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2286-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2287" : helpers.makeTestYear("Australia/Victoria", [
		["2287-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2287-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2287-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2287-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2288" : helpers.makeTestYear("Australia/Victoria", [
		["2288-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2288-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2288-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2288-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2289" : helpers.makeTestYear("Australia/Victoria", [
		["2289-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2289-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2289-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2289-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2290" : helpers.makeTestYear("Australia/Victoria", [
		["2290-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2290-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2290-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2290-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2291" : helpers.makeTestYear("Australia/Victoria", [
		["2291-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2291-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2291-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2291-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2292" : helpers.makeTestYear("Australia/Victoria", [
		["2292-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2292-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2292-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2292-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2293" : helpers.makeTestYear("Australia/Victoria", [
		["2293-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2293-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2293-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2293-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2294" : helpers.makeTestYear("Australia/Victoria", [
		["2294-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2294-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2294-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2294-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2295" : helpers.makeTestYear("Australia/Victoria", [
		["2295-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2295-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2295-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2295-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2296" : helpers.makeTestYear("Australia/Victoria", [
		["2296-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2296-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2296-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2296-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2297" : helpers.makeTestYear("Australia/Victoria", [
		["2297-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2297-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2297-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2297-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2298" : helpers.makeTestYear("Australia/Victoria", [
		["2298-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2298-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2298-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2298-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2299" : helpers.makeTestYear("Australia/Victoria", [
		["2299-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2299-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2299-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2299-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2300" : helpers.makeTestYear("Australia/Victoria", [
		["2300-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2300-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2300-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2300-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2301" : helpers.makeTestYear("Australia/Victoria", [
		["2301-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2301-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2301-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2301-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2302" : helpers.makeTestYear("Australia/Victoria", [
		["2302-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2302-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2302-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2302-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2303" : helpers.makeTestYear("Australia/Victoria", [
		["2303-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2303-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2303-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2303-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2304" : helpers.makeTestYear("Australia/Victoria", [
		["2304-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2304-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2304-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2304-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2305" : helpers.makeTestYear("Australia/Victoria", [
		["2305-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2305-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2305-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2305-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2306" : helpers.makeTestYear("Australia/Victoria", [
		["2306-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2306-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2306-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2306-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2307" : helpers.makeTestYear("Australia/Victoria", [
		["2307-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2307-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2307-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2307-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2308" : helpers.makeTestYear("Australia/Victoria", [
		["2308-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2308-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2308-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2308-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2309" : helpers.makeTestYear("Australia/Victoria", [
		["2309-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2309-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2309-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2309-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2310" : helpers.makeTestYear("Australia/Victoria", [
		["2310-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2310-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2310-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2310-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2311" : helpers.makeTestYear("Australia/Victoria", [
		["2311-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2311-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2311-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2311-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2312" : helpers.makeTestYear("Australia/Victoria", [
		["2312-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2312-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2312-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2312-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2313" : helpers.makeTestYear("Australia/Victoria", [
		["2313-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2313-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2313-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2313-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2314" : helpers.makeTestYear("Australia/Victoria", [
		["2314-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2314-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2314-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2314-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2315" : helpers.makeTestYear("Australia/Victoria", [
		["2315-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2315-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2315-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2315-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2316" : helpers.makeTestYear("Australia/Victoria", [
		["2316-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2316-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2316-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2316-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2317" : helpers.makeTestYear("Australia/Victoria", [
		["2317-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2317-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2317-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2317-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2318" : helpers.makeTestYear("Australia/Victoria", [
		["2318-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2318-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2318-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2318-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2319" : helpers.makeTestYear("Australia/Victoria", [
		["2319-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2319-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2319-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2319-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2320" : helpers.makeTestYear("Australia/Victoria", [
		["2320-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2320-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2320-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2320-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2321" : helpers.makeTestYear("Australia/Victoria", [
		["2321-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2321-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2321-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2321-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2322" : helpers.makeTestYear("Australia/Victoria", [
		["2322-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2322-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2322-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2322-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2323" : helpers.makeTestYear("Australia/Victoria", [
		["2323-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2323-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2323-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2323-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2324" : helpers.makeTestYear("Australia/Victoria", [
		["2324-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2324-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2324-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2324-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2325" : helpers.makeTestYear("Australia/Victoria", [
		["2325-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2325-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2325-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2325-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2326" : helpers.makeTestYear("Australia/Victoria", [
		["2326-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2326-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2326-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2326-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2327" : helpers.makeTestYear("Australia/Victoria", [
		["2327-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2327-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2327-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2327-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2328" : helpers.makeTestYear("Australia/Victoria", [
		["2328-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2328-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2328-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2328-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2329" : helpers.makeTestYear("Australia/Victoria", [
		["2329-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2329-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2329-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2329-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2330" : helpers.makeTestYear("Australia/Victoria", [
		["2330-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2330-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2330-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2330-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2331" : helpers.makeTestYear("Australia/Victoria", [
		["2331-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2331-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2331-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2331-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2332" : helpers.makeTestYear("Australia/Victoria", [
		["2332-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2332-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2332-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2332-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2333" : helpers.makeTestYear("Australia/Victoria", [
		["2333-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2333-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2333-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2333-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2334" : helpers.makeTestYear("Australia/Victoria", [
		["2334-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2334-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2334-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2334-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2335" : helpers.makeTestYear("Australia/Victoria", [
		["2335-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2335-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2335-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2335-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2336" : helpers.makeTestYear("Australia/Victoria", [
		["2336-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2336-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2336-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2336-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2337" : helpers.makeTestYear("Australia/Victoria", [
		["2337-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2337-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2337-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2337-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2338" : helpers.makeTestYear("Australia/Victoria", [
		["2338-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2338-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2338-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2338-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2339" : helpers.makeTestYear("Australia/Victoria", [
		["2339-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2339-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2339-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2339-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2340" : helpers.makeTestYear("Australia/Victoria", [
		["2340-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2340-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2340-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2340-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2341" : helpers.makeTestYear("Australia/Victoria", [
		["2341-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2341-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2341-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2341-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2342" : helpers.makeTestYear("Australia/Victoria", [
		["2342-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2342-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2342-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2342-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2343" : helpers.makeTestYear("Australia/Victoria", [
		["2343-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2343-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2343-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2343-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2344" : helpers.makeTestYear("Australia/Victoria", [
		["2344-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2344-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2344-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2344-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2345" : helpers.makeTestYear("Australia/Victoria", [
		["2345-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2345-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2345-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2345-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2346" : helpers.makeTestYear("Australia/Victoria", [
		["2346-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2346-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2346-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2346-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2347" : helpers.makeTestYear("Australia/Victoria", [
		["2347-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2347-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2347-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2347-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2348" : helpers.makeTestYear("Australia/Victoria", [
		["2348-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2348-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2348-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2348-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2349" : helpers.makeTestYear("Australia/Victoria", [
		["2349-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2349-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2349-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2349-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2350" : helpers.makeTestYear("Australia/Victoria", [
		["2350-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2350-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2350-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2350-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2351" : helpers.makeTestYear("Australia/Victoria", [
		["2351-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2351-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2351-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2351-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2352" : helpers.makeTestYear("Australia/Victoria", [
		["2352-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2352-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2352-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2352-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2353" : helpers.makeTestYear("Australia/Victoria", [
		["2353-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2353-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2353-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2353-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2354" : helpers.makeTestYear("Australia/Victoria", [
		["2354-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2354-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2354-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2354-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2355" : helpers.makeTestYear("Australia/Victoria", [
		["2355-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2355-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2355-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2355-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2356" : helpers.makeTestYear("Australia/Victoria", [
		["2356-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2356-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2356-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2356-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2357" : helpers.makeTestYear("Australia/Victoria", [
		["2357-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2357-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2357-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2357-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2358" : helpers.makeTestYear("Australia/Victoria", [
		["2358-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2358-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2358-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2358-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2359" : helpers.makeTestYear("Australia/Victoria", [
		["2359-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2359-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2359-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2359-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2360" : helpers.makeTestYear("Australia/Victoria", [
		["2360-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2360-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2360-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2360-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2361" : helpers.makeTestYear("Australia/Victoria", [
		["2361-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2361-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2361-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2361-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2362" : helpers.makeTestYear("Australia/Victoria", [
		["2362-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2362-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2362-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2362-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2363" : helpers.makeTestYear("Australia/Victoria", [
		["2363-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2363-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2363-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2363-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2364" : helpers.makeTestYear("Australia/Victoria", [
		["2364-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2364-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2364-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2364-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2365" : helpers.makeTestYear("Australia/Victoria", [
		["2365-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2365-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2365-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2365-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2366" : helpers.makeTestYear("Australia/Victoria", [
		["2366-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2366-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2366-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2366-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2367" : helpers.makeTestYear("Australia/Victoria", [
		["2367-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2367-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2367-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2367-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2368" : helpers.makeTestYear("Australia/Victoria", [
		["2368-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2368-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2368-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2368-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2369" : helpers.makeTestYear("Australia/Victoria", [
		["2369-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2369-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2369-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2369-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2370" : helpers.makeTestYear("Australia/Victoria", [
		["2370-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2370-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2370-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2370-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2371" : helpers.makeTestYear("Australia/Victoria", [
		["2371-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2371-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2371-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2371-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2372" : helpers.makeTestYear("Australia/Victoria", [
		["2372-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2372-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2372-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2372-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2373" : helpers.makeTestYear("Australia/Victoria", [
		["2373-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2373-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2373-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2373-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2374" : helpers.makeTestYear("Australia/Victoria", [
		["2374-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2374-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2374-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2374-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2375" : helpers.makeTestYear("Australia/Victoria", [
		["2375-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2375-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2375-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2375-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2376" : helpers.makeTestYear("Australia/Victoria", [
		["2376-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2376-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2376-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2376-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2377" : helpers.makeTestYear("Australia/Victoria", [
		["2377-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2377-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2377-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2377-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2378" : helpers.makeTestYear("Australia/Victoria", [
		["2378-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2378-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2378-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2378-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2379" : helpers.makeTestYear("Australia/Victoria", [
		["2379-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2379-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2379-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2379-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2380" : helpers.makeTestYear("Australia/Victoria", [
		["2380-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2380-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2380-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2380-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2381" : helpers.makeTestYear("Australia/Victoria", [
		["2381-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2381-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2381-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2381-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2382" : helpers.makeTestYear("Australia/Victoria", [
		["2382-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2382-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2382-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2382-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2383" : helpers.makeTestYear("Australia/Victoria", [
		["2383-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2383-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2383-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2383-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2384" : helpers.makeTestYear("Australia/Victoria", [
		["2384-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2384-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2384-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2384-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2385" : helpers.makeTestYear("Australia/Victoria", [
		["2385-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2385-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2385-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2385-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2386" : helpers.makeTestYear("Australia/Victoria", [
		["2386-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2386-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2386-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2386-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2387" : helpers.makeTestYear("Australia/Victoria", [
		["2387-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2387-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2387-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2387-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2388" : helpers.makeTestYear("Australia/Victoria", [
		["2388-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2388-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2388-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2388-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2389" : helpers.makeTestYear("Australia/Victoria", [
		["2389-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2389-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2389-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2389-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2390" : helpers.makeTestYear("Australia/Victoria", [
		["2390-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2390-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2390-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2390-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2391" : helpers.makeTestYear("Australia/Victoria", [
		["2391-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2391-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2391-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2391-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2392" : helpers.makeTestYear("Australia/Victoria", [
		["2392-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2392-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2392-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2392-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2393" : helpers.makeTestYear("Australia/Victoria", [
		["2393-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2393-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2393-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2393-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2394" : helpers.makeTestYear("Australia/Victoria", [
		["2394-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2394-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2394-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2394-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2395" : helpers.makeTestYear("Australia/Victoria", [
		["2395-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2395-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2395-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2395-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2396" : helpers.makeTestYear("Australia/Victoria", [
		["2396-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2396-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2396-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2396-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2397" : helpers.makeTestYear("Australia/Victoria", [
		["2397-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2397-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2397-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2397-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2398" : helpers.makeTestYear("Australia/Victoria", [
		["2398-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2398-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2398-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2398-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2399" : helpers.makeTestYear("Australia/Victoria", [
		["2399-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2399-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2399-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2399-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2400" : helpers.makeTestYear("Australia/Victoria", [
		["2400-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2400-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2400-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2400-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2401" : helpers.makeTestYear("Australia/Victoria", [
		["2401-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2401-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2401-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2401-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2402" : helpers.makeTestYear("Australia/Victoria", [
		["2402-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2402-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2402-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2402-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2403" : helpers.makeTestYear("Australia/Victoria", [
		["2403-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2403-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2403-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2403-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2404" : helpers.makeTestYear("Australia/Victoria", [
		["2404-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2404-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2404-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2404-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2405" : helpers.makeTestYear("Australia/Victoria", [
		["2405-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2405-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2405-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2405-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2406" : helpers.makeTestYear("Australia/Victoria", [
		["2406-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2406-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2406-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2406-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2407" : helpers.makeTestYear("Australia/Victoria", [
		["2407-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2407-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2407-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2407-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2408" : helpers.makeTestYear("Australia/Victoria", [
		["2408-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2408-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2408-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2408-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2409" : helpers.makeTestYear("Australia/Victoria", [
		["2409-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2409-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2409-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2409-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2410" : helpers.makeTestYear("Australia/Victoria", [
		["2410-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2410-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2410-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2410-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2411" : helpers.makeTestYear("Australia/Victoria", [
		["2411-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2411-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2411-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2411-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2412" : helpers.makeTestYear("Australia/Victoria", [
		["2412-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2412-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2412-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2412-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2413" : helpers.makeTestYear("Australia/Victoria", [
		["2413-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2413-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2413-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2413-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2414" : helpers.makeTestYear("Australia/Victoria", [
		["2414-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2414-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2414-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2414-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2415" : helpers.makeTestYear("Australia/Victoria", [
		["2415-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2415-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2415-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2415-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2416" : helpers.makeTestYear("Australia/Victoria", [
		["2416-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2416-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2416-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2416-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2417" : helpers.makeTestYear("Australia/Victoria", [
		["2417-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2417-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2417-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2417-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2418" : helpers.makeTestYear("Australia/Victoria", [
		["2418-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2418-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2418-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2418-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2419" : helpers.makeTestYear("Australia/Victoria", [
		["2419-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2419-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2419-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2419-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2420" : helpers.makeTestYear("Australia/Victoria", [
		["2420-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2420-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2420-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2420-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2421" : helpers.makeTestYear("Australia/Victoria", [
		["2421-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2421-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2421-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2421-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2422" : helpers.makeTestYear("Australia/Victoria", [
		["2422-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2422-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2422-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2422-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2423" : helpers.makeTestYear("Australia/Victoria", [
		["2423-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2423-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2423-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2423-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2424" : helpers.makeTestYear("Australia/Victoria", [
		["2424-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2424-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2424-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2424-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2425" : helpers.makeTestYear("Australia/Victoria", [
		["2425-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2425-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2425-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2425-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2426" : helpers.makeTestYear("Australia/Victoria", [
		["2426-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2426-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2426-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2426-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2427" : helpers.makeTestYear("Australia/Victoria", [
		["2427-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2427-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2427-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2427-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2428" : helpers.makeTestYear("Australia/Victoria", [
		["2428-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2428-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2428-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2428-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2429" : helpers.makeTestYear("Australia/Victoria", [
		["2429-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2429-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2429-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2429-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2430" : helpers.makeTestYear("Australia/Victoria", [
		["2430-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2430-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2430-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2430-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2431" : helpers.makeTestYear("Australia/Victoria", [
		["2431-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2431-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2431-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2431-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2432" : helpers.makeTestYear("Australia/Victoria", [
		["2432-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2432-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2432-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2432-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2433" : helpers.makeTestYear("Australia/Victoria", [
		["2433-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2433-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2433-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2433-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2434" : helpers.makeTestYear("Australia/Victoria", [
		["2434-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2434-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2434-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2434-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2435" : helpers.makeTestYear("Australia/Victoria", [
		["2435-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2435-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2435-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2435-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2436" : helpers.makeTestYear("Australia/Victoria", [
		["2436-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2436-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2436-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2436-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2437" : helpers.makeTestYear("Australia/Victoria", [
		["2437-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2437-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2437-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2437-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2438" : helpers.makeTestYear("Australia/Victoria", [
		["2438-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2438-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2438-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2438-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2439" : helpers.makeTestYear("Australia/Victoria", [
		["2439-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2439-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2439-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2439-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2440" : helpers.makeTestYear("Australia/Victoria", [
		["2440-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2440-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2440-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2440-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2441" : helpers.makeTestYear("Australia/Victoria", [
		["2441-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2441-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2441-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2441-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2442" : helpers.makeTestYear("Australia/Victoria", [
		["2442-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2442-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2442-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2442-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2443" : helpers.makeTestYear("Australia/Victoria", [
		["2443-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2443-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2443-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2443-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2444" : helpers.makeTestYear("Australia/Victoria", [
		["2444-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2444-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2444-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2444-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2445" : helpers.makeTestYear("Australia/Victoria", [
		["2445-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2445-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2445-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2445-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2446" : helpers.makeTestYear("Australia/Victoria", [
		["2446-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2446-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2446-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2446-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2447" : helpers.makeTestYear("Australia/Victoria", [
		["2447-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2447-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2447-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2447-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2448" : helpers.makeTestYear("Australia/Victoria", [
		["2448-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2448-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2448-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2448-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2449" : helpers.makeTestYear("Australia/Victoria", [
		["2449-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2449-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2449-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2449-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2450" : helpers.makeTestYear("Australia/Victoria", [
		["2450-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2450-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2450-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2450-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2451" : helpers.makeTestYear("Australia/Victoria", [
		["2451-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2451-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2451-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2451-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2452" : helpers.makeTestYear("Australia/Victoria", [
		["2452-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2452-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2452-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2452-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2453" : helpers.makeTestYear("Australia/Victoria", [
		["2453-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2453-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2453-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2453-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2454" : helpers.makeTestYear("Australia/Victoria", [
		["2454-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2454-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2454-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2454-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2455" : helpers.makeTestYear("Australia/Victoria", [
		["2455-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2455-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2455-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2455-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2456" : helpers.makeTestYear("Australia/Victoria", [
		["2456-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2456-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2456-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2456-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2457" : helpers.makeTestYear("Australia/Victoria", [
		["2457-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2457-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2457-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2457-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2458" : helpers.makeTestYear("Australia/Victoria", [
		["2458-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2458-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2458-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2458-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2459" : helpers.makeTestYear("Australia/Victoria", [
		["2459-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2459-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2459-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2459-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2460" : helpers.makeTestYear("Australia/Victoria", [
		["2460-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2460-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2460-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2460-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2461" : helpers.makeTestYear("Australia/Victoria", [
		["2461-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2461-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2461-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2461-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2462" : helpers.makeTestYear("Australia/Victoria", [
		["2462-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2462-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2462-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2462-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2463" : helpers.makeTestYear("Australia/Victoria", [
		["2463-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2463-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2463-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2463-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2464" : helpers.makeTestYear("Australia/Victoria", [
		["2464-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2464-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2464-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2464-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2465" : helpers.makeTestYear("Australia/Victoria", [
		["2465-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2465-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2465-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2465-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2466" : helpers.makeTestYear("Australia/Victoria", [
		["2466-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2466-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2466-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2466-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2467" : helpers.makeTestYear("Australia/Victoria", [
		["2467-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2467-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2467-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2467-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2468" : helpers.makeTestYear("Australia/Victoria", [
		["2468-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2468-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2468-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2468-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2469" : helpers.makeTestYear("Australia/Victoria", [
		["2469-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2469-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2469-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2469-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2470" : helpers.makeTestYear("Australia/Victoria", [
		["2470-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2470-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2470-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2470-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2471" : helpers.makeTestYear("Australia/Victoria", [
		["2471-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2471-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2471-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2471-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2472" : helpers.makeTestYear("Australia/Victoria", [
		["2472-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2472-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2472-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2472-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2473" : helpers.makeTestYear("Australia/Victoria", [
		["2473-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2473-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2473-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2473-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2474" : helpers.makeTestYear("Australia/Victoria", [
		["2474-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2474-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2474-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2474-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2475" : helpers.makeTestYear("Australia/Victoria", [
		["2475-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2475-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2475-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2475-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2476" : helpers.makeTestYear("Australia/Victoria", [
		["2476-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2476-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2476-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2476-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2477" : helpers.makeTestYear("Australia/Victoria", [
		["2477-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2477-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2477-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2477-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2478" : helpers.makeTestYear("Australia/Victoria", [
		["2478-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2478-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2478-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2478-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2479" : helpers.makeTestYear("Australia/Victoria", [
		["2479-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2479-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2479-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2479-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2480" : helpers.makeTestYear("Australia/Victoria", [
		["2480-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2480-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2480-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2480-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2481" : helpers.makeTestYear("Australia/Victoria", [
		["2481-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2481-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2481-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2481-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2482" : helpers.makeTestYear("Australia/Victoria", [
		["2482-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2482-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2482-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2482-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2483" : helpers.makeTestYear("Australia/Victoria", [
		["2483-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2483-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2483-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2483-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2484" : helpers.makeTestYear("Australia/Victoria", [
		["2484-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2484-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2484-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2484-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2485" : helpers.makeTestYear("Australia/Victoria", [
		["2485-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2485-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2485-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2485-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2486" : helpers.makeTestYear("Australia/Victoria", [
		["2486-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2486-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2486-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2486-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2487" : helpers.makeTestYear("Australia/Victoria", [
		["2487-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2487-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2487-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2487-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2488" : helpers.makeTestYear("Australia/Victoria", [
		["2488-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2488-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2488-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2488-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2489" : helpers.makeTestYear("Australia/Victoria", [
		["2489-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2489-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2489-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2489-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2490" : helpers.makeTestYear("Australia/Victoria", [
		["2490-04-01T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2490-04-01T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2490-09-30T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2490-09-30T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2491" : helpers.makeTestYear("Australia/Victoria", [
		["2491-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2491-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2491-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2491-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2492" : helpers.makeTestYear("Australia/Victoria", [
		["2492-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2492-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2492-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2492-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2493" : helpers.makeTestYear("Australia/Victoria", [
		["2493-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2493-04-04T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2493-10-03T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2493-10-03T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2494" : helpers.makeTestYear("Australia/Victoria", [
		["2494-04-03T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2494-04-03T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2494-10-02T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2494-10-02T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2495" : helpers.makeTestYear("Australia/Victoria", [
		["2495-04-02T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2495-04-02T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2495-10-01T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2495-10-01T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2496" : helpers.makeTestYear("Australia/Victoria", [
		["2496-03-31T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2496-03-31T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2496-10-06T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2496-10-06T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2497" : helpers.makeTestYear("Australia/Victoria", [
		["2497-04-06T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2497-04-06T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2497-10-05T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2497-10-05T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2498" : helpers.makeTestYear("Australia/Victoria", [
		["2498-04-05T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2498-04-05T16:00:00+00:00", "02:00:00", "AEST", -600],
		["2498-10-04T15:59:59+00:00", "01:59:59", "AEST", -600],
		["2498-10-04T16:00:00+00:00", "03:00:00", "AEDT", -660]
	]),

	"2499" : helpers.makeTestYear("Australia/Victoria", [
		["2499-04-04T15:59:59+00:00", "02:59:59", "AEDT", -660],
		["2499-04-04T16:00:00+00:00", "02:00:00", "AEST", -600]
	])
};