/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.File;
import java.text.ParseException;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.plugins.report.XmlReportParser$SaxXmlReportParser;

public final class XmlReportParser {
    private XmlReportParser$SaxXmlReportParser parser = null;

    public final void parse(File file2) {
        if (!file2.exists()) {
            throw new IllegalStateException("Report file '" + file2.getAbsolutePath() + "' does not exist.");
        }
        this.parser = new XmlReportParser$SaxXmlReportParser(file2);
        try {
            this.parser.parse();
            return;
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException("failed to parse report: " + file2 + ": " + exception.getMessage(), 0);
            parseException.initCause(exception);
            throw parseException;
        }
    }

    public final ArtifactDownloadReport[] getArtifactReports() {
        return this.parser.getArtifactReports().toArray(new ArtifactDownloadReport[this.parser.getArtifactReports().size()]);
    }

    public final ModuleRevisionId[] getDependencyRevisionIds() {
        return this.parser.getModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getModuleRevisionIds().size()]);
    }

    public final ModuleRevisionId[] getRealDependencyRevisionIds() {
        return this.parser.getRealModuleRevisionIds().toArray(new ModuleRevisionId[this.parser.getRealModuleRevisionIds().size()]);
    }

    public final MetadataArtifactDownloadReport getMetadataArtifactReport(ModuleRevisionId moduleRevisionId) {
        return this.parser.getMetadataArtifactReport(moduleRevisionId);
    }
}

