# Cumulative Layout Shift Changes in Chrome 88

## Changes in Chrome 88

### Bug fix for descendents of sticky elements

Before Chrome 88, Cumulative Layout Shift did not take shifts of descendents of
sticky elements into account. This has been fixed in Chrome 88.
[Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2519360).

### Bug fix for fixed position elements

Prior to Chrome 88, Cumulative Layout Shift did not take shifts of fixed
position elements into account. This has been fixed in Chrome 88.
[Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2520330).

### Bug fix for content-visibility: auto

When the `content-visibility: auto` feature was shipped in Chrome 85, a
CLS-impacting flaw was present: changes between the skipped and not-skipped
state of a `content-visibility: auto` subtree caused an observed layout shift
in the `content;visibility: auto` element as it resized.

In Chrome 88, the CLS issue was [fixed](https://crbug.com/1151526).
Going forward, there should be no CLS penalty for such elements. (Note that
there still may be a layout shift for onscreen elements adjacent to (but not
descendants of) the `content-visibility: auto` element.

### Ignore layout shift when visibility:hidden becomes visible

We have been always ignoring layout shifts when the element has
visibility:hidden. However before Chrome 89, if the element having
visibility:hidden became visible and shift at the same time, we reported layout
shift. Now we also consider the previous visibility and ignore layout shift in
the case.
[Source code for this change](https://chromium-review.googlesource.com/c/chromium/src/+/2591367)

## How does this affect a site's metrics?

All of these changes only affect sites with specific types of content. Here are
the specifics for each change:

### Bug fix for descendents of sticky elements

Sites with descendents of  sticky position elements which shift unexpectedly
should see an increase in their Cumulative Layout Shift scores.

### Bug fix for fixed position elements

Sites with fixed position elements which shift unexpectedly should see an
increase in their Cumulative Layout Shift scores.

### Bug fix for content-visibility: auto

Sites using `content-visibility: auto` should no longer see any impact of this
feature on their Cumulative Layout Shift scores, resulting in a decrease in
their scores.

### Ignore layout shift when visibility:hidden becomes visible

Sites using visibility:hidden to hide layout changes may see a decrease in
their Cumulative Layout Shift scores.

### Fixed bug when recording paint offset translation deltas

A bug was introduced in Chrome 86 in which Cumulative Layout Shift was measured
incorrectly for certain cases involving nested out-of-flow elements
(absolute-position or fixed-position). This caused reported shifts even in
some cases where there was not actually a shift.

## When were users affected?

Chrome 88 is currently scheduled to be released the week of January 19, 2021.
