description("Test that color values are properly clamped (R, G, B should be 0-255), alpha 0.0-1.0");

var ctx = document.createElement('canvas').getContext('2d');

shouldBe("ctx.shadowColor = 'rgba(0,0,0,0)'; ctx.shadowColor", "'rgba(0, 0, 0, 0)'");
shouldBe("ctx.shadowColor = 'rgb(0,0,0)'; ctx.shadowColor", "'#000000'");
shouldBe("ctx.shadowColor = 'rgb(0,999,0)'; ctx.shadowColor", "'#00ff00'");
shouldBe("ctx.shadowColor = 'rgb(0,999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999,0)'; ctx.shadowColor", "'#00ff00'");
shouldBe("ctx.shadowColor = 'rgb(0,0,256)'; ctx.shadowColor", "'#0000ff'");
shouldBe("ctx.shadowColor = 'rgb(999999999999999999999999,0,-9999999999999999999999999999)'; ctx.shadowColor", "'#ff0000'");
shouldBe("ctx.shadowColor = 'rgba(9999999999999999999999999999999999999999999999999999999999999999999999999999999999,9,0,1)'; ctx.shadowColor", "'#ff0900'");
shouldBe("ctx.shadowColor = 'rgba(9999999999999999999999999999999999999999999999999999999999999999999999999999999999,9,0,-99999999999999999999999999999999999999)'; ctx.shadowColor", "'rgba(255, 9, 0, 0)'");
shouldBe("ctx.shadowColor = 'rgba(7,9999999999999999999999999999999999999999999999999999999999999999999999999999999999,0,99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999)'; ctx.shadowColor", "'#07ff00'");
shouldBe("ctx.shadowColor = 'rgba(-7,9999999999999999999999999999999999999999999999999999999999999999999999999999999999,0,99999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999)'; ctx.shadowColor", "'#00ff00'");
shouldBe("ctx.shadowColor = 'rgba(0%,100%,0%,0.4)'; ctx.shadowColor", "'rgba(0, 255, 0, 0.4)'");
