/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "VisualMerge.h"
#include "WcStatus.h"
#include "WcEntry.h"
#include "util/CommandArgs.h"


namespace svn
{

VisualMerge::VisualMerge( svn_client_ctx_t* context, const sc::String& mergeCmd,
  apr_pool_t* pool )
: _context(context), _mergeCmd(mergeCmd), _pool(pool)
{
}

VisualMerge::~VisualMerge()
{
}

svn_error_t* VisualMerge::run( WcStatusPtr file )
{
  int            result;
  apr_exit_why_e why;

  const svn::WcEntry* entry = file->getWcEntry();

  sc::String    path  = file->getName();
  svn_string_t* path2 = svn_string_create( path, _pool );
  apr_size_t    size  = svn_string_find_char_backward( path2, '/' );
  path = path.left(size);

  CommandArgs cmdArgs( _mergeCmd, _pool );
  cmdArgs.setArg( sc::String("{base}"),   entry->getConflictOld() );
  cmdArgs.setArg( sc::String("{mine}"),   entry->getConflictWrk() );
  cmdArgs.setArg( sc::String("{theirs}"), entry->getConflictNew() );
  cmdArgs.setArg( sc::String("{merged}"), file->getName() );
 
  return svn_io_run_cmd( path/*cmdArgs.getPath()*/, cmdArgs.getArgs()[0],
    cmdArgs.getArgs(), &result, &why, true, 0, 0, 0, _pool );
}


} // namespace
