/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.packet;

import net.tinyos.packet.NetworkByteSource;
import net.tinyos.packet.PacketSource;
import net.tinyos.packet.Packetizer;
import net.tinyos.packet.ParseArgs;
import net.tinyos.packet.PhoenixSource;
import net.tinyos.packet.Platform;
import net.tinyos.packet.SFSource;
import net.tinyos.packet.SerialByteSource;
import net.tinyos.util.Env;
import net.tinyos.util.Messenger;

public class BuildSource {
    public static PhoenixSource makePhoenix(PacketSource packetSource, Messenger messenger) {
        return new PhoenixSource(packetSource, messenger);
    }

    public static PhoenixSource makePhoenix(String string, Messenger messenger) {
        PacketSource packetSource = BuildSource.makePacketSource(string);
        if (packetSource == null) {
            return null;
        }
        return new PhoenixSource(packetSource, messenger);
    }

    public static PhoenixSource makePhoenix(Messenger messenger) {
        PacketSource packetSource = BuildSource.makePacketSource();
        if (packetSource == null) {
            return null;
        }
        return new PhoenixSource(packetSource, messenger);
    }

    public static PacketSource makePacketSource() {
        return BuildSource.makePacketSource(Env.getenv("MOTECOM"));
    }

    public static PacketSource makePacketSource(String string) {
        if (string == null) {
            string = "sf@localhost:9002";
        }
        ParseArgs parseArgs = new ParseArgs(string, "@");
        String string2 = parseArgs.next();
        String string3 = parseArgs.next();
        PacketSource packetSource = null;
        if (string2.equals("sf")) {
            packetSource = BuildSource.makeArgsSF(string3);
        }
        if (string2.equals("serial")) {
            packetSource = BuildSource.makeArgsSerial(string3);
        }
        if (string2.equals("network")) {
            packetSource = BuildSource.makeArgsNetwork(string3);
        }
        if (string2.equals("tossim-serial")) {
            packetSource = BuildSource.makeArgsTossimSerial(string3);
        }
        if (string2.equals("tossim-radio")) {
            packetSource = BuildSource.makeArgsTossimRadio(string3);
        }
        return packetSource;
    }

    public static String sourceHelp() {
        return "  - sf@HOSTNAME:PORTNUMBER\n    A serial forwarder.\n  - serial@SERIALPORT:BAUDRATE\n    A mote connected to a serial port using the TinyOS 2.0 serial protocol.\n     BAUDRATE is either a number or a platform name (selects platform's\n     default baud rate).\n  - network@HOSTNAME:PORTNUMBER\n    A mote whose serial port is accessed over the network.\n  - tossim-serial[@HOSTNAME]\n    The serial port of tossim node 0.\n  - tossim-radio[@HOSTNAME]\n    The radios of tossim nodes.\n\nExamples: serial@COM1:mica2, serial@/dev/ttyUSB2:19200, sf@localhost:9000";
    }

    public static PacketSource makeArgsSF(String string) {
        if (string == null) {
            string = "localhost:9002";
        }
        ParseArgs parseArgs = new ParseArgs(string, ":");
        String string2 = parseArgs.next();
        String string3 = parseArgs.next();
        if (string3 == null) {
            return null;
        }
        int n = Integer.parseInt(string3);
        return BuildSource.makeSF(string2, n);
    }

    public static PacketSource makeSF(String string, int n) {
        return new SFSource(string, n);
    }

    private static int decodeBaudrate(String string) {
        try {
            int n = Platform.get(string);
            if (n == -1) {
                n = Integer.parseInt(string);
            }
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static PacketSource makeArgsSerial(String string) {
        if (string == null) {
            string = "COM1";
        }
        ParseArgs parseArgs = new ParseArgs(string, ":");
        String string2 = parseArgs.next();
        String string3 = parseArgs.next();
        int n = BuildSource.decodeBaudrate(string3);
        if (n < 0) {
            return null;
        }
        return BuildSource.makeSerial(string2, n);
    }

    public static PacketSource makeSerial(String string, int n) {
        return new Packetizer("serial@" + string + ":" + n, new SerialByteSource(string, n));
    }

    public static PacketSource makeArgsNetwork(String string) {
        if (string == null) {
            return null;
        }
        ParseArgs parseArgs = new ParseArgs(string, ":,");
        String string2 = parseArgs.next();
        String string3 = parseArgs.next();
        if (string3 == null) {
            return null;
        }
        int n = Integer.parseInt(string3);
        return BuildSource.makeNetwork(string2, n);
    }

    public static PacketSource makeNetwork(String string, int n) {
        return new Packetizer("network@" + string + ":" + n, new NetworkByteSource(string, n));
    }

    public static PacketSource makeArgsTossimSerial(String string) {
        if (string == null) {
            string = "localhost";
        }
        return BuildSource.makeTossimSerial(string);
    }

    public static PacketSource makeTossimSerial(String string) {
        return BuildSource.makeTossimSource("TossimSerialSource", string);
    }

    public static PacketSource makeArgsTossimRadio(String string) {
        if (string == null) {
            string = "localhost";
        }
        return BuildSource.makeTossimRadio(string);
    }

    public static PacketSource makeTossimRadio(String string) {
        return BuildSource.makeTossimSource("TossimRadioSource", string);
    }

    private static PacketSource makeTossimSource(String string, String string2) {
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Object[] objectArray = new Object[]{string2};
            Class<?> clazz = Class.forName("net.tinyos.sim.packet." + string);
            return (PacketSource)clazz.getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            System.err.println("Couldn't instantiate tossim packet source");
            System.err.println("Did you compile tossim?");
            return null;
        }
    }

    public static void main(String[] stringArray) {
        System.err.println(BuildSource.sourceHelp());
    }
}

