/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include "mainwindow.h"
#include "settings.h"
#include "database/tb_task.h"
#include "database/tb_donwload_task_status.h"
#include "database/tb_url_info.h"
#include "deleteitemthread.h"
#include <QDebug>
#include <QSound>
#include <dfilechooseredit.h>
#include <QDesktopServices>
#include <QMimeData>
#include <QProcess>
#include <QMap>
#include <QSqlDatabase>
#include <QStandardPaths>
#include <DSettingsWidgetFactory>
#include <DSettingsGroup>
#include <DSettings>
#include <stdio.h>
#include"messagebox.h"

#define DATABASE_VERISON    "1"
#define AIRA_CONFIG_PATH "/usr/share/uos-downloadmanager/config/aria2.conf"
#define NFS_DOWNLOAD_MANAGER_DATABASE_OLD_FILENAME  "uos-downloadmanager-task.db"
#define NFS_DOWNLOAD_MANAGER_DATABASE_FILENAME   "uos-downloadmanager-task"+DATABASE_VERISON+".db"
#define NFS_DOWNLOAD_MANAGER_DATABASE_SOURCE_FILENAME "uos-downloadmanager-task.db"
#define NFS_DONWLOAD_MANAGER_DATABASE_PATH "/usr/share/uos-downloadmanager/database/"
#define SETTING_SOURCE_CONFIG_PATH  "/usr/share/uos-downloadmanager/config/config.conf"
#define UOS_DOWNLOAD_MANAGER_DESKTOP_PATH  "/usr/share/uos-downloadmanager/desktop/"

QSqlDatabase database ;
MainWindow::MainWindow()
    : DMainWindow(),
      m_toolBar(new ToolBar)
{
    initDataBase();
    initConfig();
    initUI();
    initConnections();
    initaria2();
    init_tableData();
}
MainWindow::~MainWindow()
{
//    aria2c->pauseAll();
//    aria2c->purgeDownloadResult();
//    aria2c->shutdown();
//    aria2c->forceShutdown();
    delete aria2c;
    delete updatetimer;
}

//初始化设置配置文件
void MainWindow::initConfig()
{
    QString m_configPath = QString("%1/%2/%3/config.conf")
        .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
        .arg(qApp->organizationName())
        .arg(qApp->applicationName());

    QFileInfo * databaseFile = new QFileInfo(m_configPath);
    //如果设置配置文件不存在
    if(!databaseFile->isFile())
    {
        //拷贝配置文件
        QFile::copy(QString(SETTING_SOURCE_CONFIG_PATH),
                    m_configPath);
    }
}
void MainWindow::initUI()
{
    this->setTitlebarShadowEnabled(true);

    m_settings = new Settings ;
    connect(m_settings,&Settings::get_download_limitspeed_changed,this,&MainWindow::on_download_limitspeed_slot);
    connect(m_settings,&Settings::get_upload_limitspeed_changed,this,&MainWindow::on_UploadSpeed_limitspeed_slot);
    connect(m_settings,&Settings::get_disckCacheNum_changed,this,&MainWindow::on_disckCacheNum_slot);
    connect(m_settings,&Settings::get_speedLimit_period_changed,this,&MainWindow::deal_download_upload_limit_period);
    connect(m_settings,&Settings::get_max_downloadnum_changed,this,&MainWindow::deal_max_download_slot);
    connect(m_settings,&Settings::get_poweron_changed,this,&MainWindow::on_deal_poweron_slot);


    current_listview_row=0;
    downloading_tableview= new TableView(downloading);
    downloading_tableview->verticalHeader()->setDefaultSectionSize(56);
    connect(downloading_tableview,&TableView::header_stateChanged,this,&MainWindow::get_header_stateChanged);
    connect(this,&MainWindow::switch_table_signal,downloading_tableview,&TableView::clear_header_check);
    downloading_tableview->setColumnHidden(4,true);
    recycle_tableview = new TableView(recycle);
    recycle_tableview->verticalHeader()->setDefaultSectionSize(30);
    connect(recycle_tableview,&TableView::header_stateChanged,this,&MainWindow::get_header_stateChanged);
    connect(this,&MainWindow::switch_table_signal,recycle_tableview,&TableView::clear_header_check);

    recycle_tableview->setColumnHidden(3,true);
    setMinimumSize(838, 636);
    titlebar()->setCustomWidget(m_toolBar, false);
   // titlebar()->setSeparatorVisible(true);
    titlebar()->setFixedHeight(50);
    QPalette p;
    p.setColor(QPalette::Background,QColor(255,255,255));
   // p.setBrush(this->backgroundRole(),QBrush(QColor(255,255,255)));
    QFrame *MainWidget = new QFrame;
    MainWidget->setFrameShape(QFrame::NoFrame);

    QHBoxLayout *MainHLayout = new QHBoxLayout(MainWidget);
    this->setCentralWidget(MainWidget);
    MainHLayout->setContentsMargins(0,0,0,0);
    MainHLayout->setSpacing(0);
    //MainHLayout->setContentsMargins(0,10,10,10);
    setAcceptDrops(true);
    LeftWidget = new QWidget;
    LeftWidget->setAutoFillBackground(true);
    QVBoxLayout *LeftLayout = new QVBoxLayout(LeftWidget);
    LeftWidget->setPalette(p);
    LeftWidget->setFixedWidth(132);
    LeftLayout->setContentsMargins(10,0,10,0);
   // LeftLayout->setMargin(0);
    Right_Widget= new QWidget;
    noTask_Widget= new QWidget;
    noTask_Widget->setAutoFillBackground(true);
    noTask_Widget->setPalette(p);

    QVBoxLayout *noTask_WidgetLayout = new QVBoxLayout(noTask_Widget);
    noTask_WidgetLayout->setContentsMargins(10,0,0,0);
    noTask_label= new DLabel();
    noTask_label->setForegroundRole(DPalette::PlaceholderText);
    QFont  lable_font;
    lable_font.setPointSize(15);
    lable_font.setBold(QFont::DemiBold);
    lable_font.setFamily("T5");
    QPalette font_p;
    QColor color=QColor(192,198,212,76);
    font_p.setColor(QPalette::WindowText,color);
    //font_p.setBrush(QPalette::WindowText,DGuiApplicationHelper::instance()->applicationPalette().frameBorder());
    noTask_label->setFont(lable_font);
    noTask_label->setText(tr("current no download task"));
    noTask_label->setAlignment(Qt::AlignHCenter);
    //noTask_label->setPalette(font_p);
    noTask_WidgetLayout->addWidget(noTask_label);
    noTask_tip_Label= new QLabel();
    QFont  noTask_tip_Label_font;
    noTask_tip_Label_font.setPointSize(13);
    noTask_tip_Label->setFont(noTask_tip_Label_font);
    QPalette noTask_tip_Label_p;
    noTask_tip_Label_p.setColor(QPalette::WindowText,QColor(65,77,104,70));
    noTask_tip_Label->setText(tr("can click add button to create new download"));
    noTask_tip_Label->setAlignment(Qt::AlignHCenter);
    noTask_tip_Label->setPalette(noTask_tip_Label_p);
    noTask_WidgetLayout->addWidget(noTask_tip_Label);
    noTask_WidgetLayout->addStretch(5);
    QVBoxLayout *RightLayout = new QVBoxLayout(Right_Widget);
    RightLayout->setContentsMargins(0,0,0,0);
    RightStackwidget = new QStackedWidget(this);
    //RightLayout->setMargin(0);
    QPalette p_task_num;
    p_task_num.setBrush(this->backgroundRole(),QBrush(QColor(255,255,255,178)));
    Task_Num_Widget= new QWidget;
    Task_Num_Widget->setFixedHeight(30);
    Task_Num_Widget->setAutoFillBackground(true);
    Task_Num_Widget->setPalette(p_task_num);
    QHBoxLayout *Task_Num_WidgetLayout = new QHBoxLayout(Task_Num_Widget);
    Task_Num_WidgetLayout->setMargin(0);
    Task_Num= new QLabel(tr("0 task"));
   // Task_Num->setFixedHeight(30);
    Task_Num->setAlignment(Qt::AlignHCenter|Qt::AlignVCenter);
    Task_Num->setPalette(noTask_tip_Label_p);
    Task_Num_WidgetLayout->addWidget(Task_Num);
    RightStackwidget->addWidget(downloading_tableview);
    RightStackwidget->addWidget(recycle_tableview);
    RightLayout->addWidget(RightStackwidget);
    RightLayout->addWidget(noTask_Widget);
    RightLayout->addWidget(Task_Num_Widget);
    RightLayout->setSpacing(0);
//    RightLayout->setMargin(0);

    MainHLayout->addWidget(LeftWidget);
    MainHLayout->addWidget(Right_Widget);

    left_list= new DListView;


    left_list->setItemSpacing(0);
    left_list->setItemSize(QSize(112,40));
    left_list->setItemMargins(QMargins(10,2,5,2));
    left_list->setIconSize(QSize(14,14));
    QFont font;
    font.setFamily("Source Han Sans");
    font.setPointSize(14);
    left_list->setFont(font);
    LeftList_mode= new QStandardItemModel(this);

    downloading_item= new QStandardItem(QIcon::fromTheme("ndm_list_downloading"),tr(" Download"));
    downloadFinish_item= new QStandardItem(QIcon::fromTheme("ndm_print_done"),tr("  Finish"));
    recycle_item= new QStandardItem(QIcon::fromTheme("ndm_list_delete"),tr("  Recycle"));
    downloading_item->setBackground(QColor(255,255,255));
    downloadFinish_item->setBackground(QColor(255,255,255));
    recycle_item->setBackground(QColor(255,255,255));
    downloading_item->setEditable(false);
    downloadFinish_item->setEditable(false);
    recycle_item->setEditable(false);
    LeftList_mode->appendRow(downloading_item);
    LeftList_mode->appendRow(downloadFinish_item);
    LeftList_mode->appendRow(recycle_item);
    left_list->setModel(LeftList_mode);
    LeftLayout->addWidget(left_list,0);
    updatetimer = new QTimer(this);
    left_list->setCurrentIndex(LeftList_mode->index(0,0));
    downloading_tableview->setContextMenuPolicy(Qt::CustomContextMenu);
    recycle_tableview->setContextMenuPolicy(Qt::CustomContextMenu);

    RightStackwidget->setCurrentIndex(0);
//    MainHLayout->setStretchFactor(LeftWidget,1);
//    MainHLayout->setStretchFactor(Right_Widget,4);

    //添加设置界面
    settings_menu = new DMenu;
    settingAction = new QAction(tr("Settings"), this);
    settings_menu->addAction(settingAction);
    titlebar()->setMenu(settings_menu);
   // QIcon tryIcon=QIcon::fromTheme("ndm_preferencesystem");

    QIcon tryIcon=QIcon(":/icons/deepin/builtin/light/icons/ndm_preferencesystem_24px.svg");
    systemTray = new QSystemTrayIcon(this);
    systemTray->setIcon(tryIcon);
    systemTray->setToolTip(tr("Download Manager"));

    quitAct = new QAction(tr("Quit Application"), this);
    connect(quitAct, SIGNAL(triggered()), this, SLOT(on_tray_quit_click()));

    trayMenu = new QMenu(this);
    trayMenu->addAction(quitAct);
    connect(systemTray , SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT(onActivated(QSystemTrayIcon::ActivationReason)));

    systemTray->setContextMenu(trayMenu);
    systemTray->show();
    if(DGuiApplicationHelper::instance()->themeType()==2)
        get_paletteTypeChanged(DGuiApplicationHelper::ColorType::DarkType);
    else {
        get_paletteTypeChanged(DGuiApplicationHelper::ColorType::LightType);

    }

}

void MainWindow::onActivated(QSystemTrayIcon::ActivationReason reason)
{
   if(reason == QSystemTrayIcon::ActivationReason::Trigger)
   {
       if(this->isHidden())
       {
           //恢复窗口显示
           this->show();
           this->setWindowState(Qt::WindowActive);
           this->activateWindow();
           if(this->minimumAct)
           {
              this->setWindowState((this->windowState() & ~Qt::WindowMinimized) | Qt::WindowActive);
           }
       }
       else {
           this->hide();
       }
   }

}
void MainWindow::init_tableData()
{

    QList<Tb_Task *> list;
    Tb_Task tbTask;
    int task_num=0;
    list = tbTask.getAllTbTask();
    for(int i=0;i<list.length();i++)
    {
        DataItem *data= new DataItem;
        data->gid=list.at(i)->gid;
        data->url=list.at(i)->url;
        data->time="0";
        data->speed="0kb/s";
        data->taskId=list.at(i)->task_id;
        Tb_Donwload_Task_Status tb_task_status;
        Tb_Donwload_Task_Status *get_task_status;
        get_task_status=tb_task_status.getTbDownloadStatusByTaskId(data->taskId);
        if(get_task_status!=nullptr)
        {
	    int percent=get_task_status->percent;
            if(percent < 0 || percent > 100)
            {
                percent = 0 ;
            }
            data->percent=percent;
            data->fileName=list.at(i)->download_filename;
            data->savePath=list.at(i)->download_path;
            data->Ischecked=0;
            data->totalLength=get_task_status->totalLength;
            data->completedLength=get_task_status->compeletedLength;
            if(get_task_status->download_status==Global::Status::Active)
            {
                data->status=Global::Status::Lastincomplete;
            }
            else
            {
                data->status=get_task_status->download_status;
            }
            data->total=get_task_status->totalFromSource;
            if(data->status==Global::Status::Lastincomplete)
            {
                ++task_num;
            }
            if(data->status!=Global::Status::Removed)
            {
               if(data->status==Global::Status::Complete)
                   data->time=get_task_status->modify_time.toString("yyyy-MM-dd hh:mm:ss");
                if(data->status==Global::Status::Lastincomplete)
                {
                    noTask_Widget->hide();
                    QVariant autostart_unfinished_task_switchbutton = m_settings->settings->getOption("basic.select_multiple.autostart_unfinished_task_switchbutton");
                    downloading_tableview->get_tableViewModel()->append(data);
                    if(autostart_unfinished_task_switchbutton.toBool())
                    {
                        QString save_path=get_download_savePath_from_config();
                        QMap<QString, QVariant> opt;
                        opt.insert("dir", save_path);
                        Tb_Url_Info *url_info= new Tb_Url_Info;
                        Tb_Url_Info *get_url_info;
                        get_url_info= url_info->getTbUrlInfoByTaskId(data->taskId);
                        if(get_url_info!=nullptr)
                        {
                            if(get_url_info->download_type=="torrent")
                            {
                                QString select_num=get_url_info->selectedNum;
                                QMap<QString,QVariant> opt;
                                opt.insert("dir",save_path);
                                opt.insert("select-file",select_num);
                                if(!QFile(get_url_info->seedFile).exists())
                                {
                                    show_Warning_MsgBox(tr("seed file not exists or broken;"));
                                }
                                else {
                                    aria2c->addTorrent(get_url_info->seedFile,opt,get_url_info->task_id);
                                    if (updatetimer->isActive() == false)
                                    {
                                        updatetimer->start(2*1000);
                                    }


                                }


                            }
                        }
                        else
                        {
                            deal_download_upload_limit_period();
                            aria2c->addUri(data->url,opt,data->taskId);
                            if (updatetimer->isActive() == false)
                            {
                                updatetimer->start(2*1000);
                            }

                        }
                   }

                }
                else
                    downloading_tableview->get_tableViewModel()->append(data);
            }
            else
            {
                DelDataItem *deldata= new DelDataItem;
                deldata->taskId=data->taskId;
                deldata->gid=data->gid;
                deldata->url=data->url;
                deldata->status=data->status;
                deldata->fileName=data->fileName;
                deldata->savePath=data->savePath;
                deldata->deleteTime=get_task_status->modify_time.toString("yyyy-MM-dd hh:mm:ss");
                deldata->totalLength=data->totalLength;
                deldata->completedLength=data->completedLength;
                deldata->finishTime=get_task_status->finish_time.toString("yyyy-MM-dd hh:mm:ss");
                recycle_tableview->get_tableViewModel()->append(deldata);
            }
        }

    }
    refreshTableView(0);

    setTask_Num(current_listview_row);
}

void MainWindow::initDataBase()
{
    QString m_dataBasePath = QString("%1/%2/%3/")
            .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
            .arg(qApp->organizationName())
            .arg(qApp->applicationName())
            ;
    QDir * databaseDir = new QDir(m_dataBasePath);
    QFileInfo * databaseFile = new QFileInfo(m_dataBasePath+NFS_DOWNLOAD_MANAGER_DATABASE_FILENAME);
    //如果数据库文件不存在
    if(!databaseFile->isFile())
    {
        //数据库目录不存在
        if(!databaseDir->exists())
        {
            databaseDir->mkpath(m_dataBasePath);
        }
       //拷贝数据库文件
        qDebug() << "copy file " << QString(NFS_DONWLOAD_MANAGER_DATABASE_PATH)+NFS_DOWNLOAD_MANAGER_DATABASE_FILENAME << QString(m_dataBasePath)+NFS_DOWNLOAD_MANAGER_DATABASE_FILENAME<<endl;

        QString strold=m_dataBasePath+NFS_DOWNLOAD_MANAGER_DATABASE_OLD_FILENAME;
        QByteArray ba=strold.toLatin1();
        char *old_database_file=ba.data();
        remove(old_database_file);
        QFile::copy(QString(NFS_DONWLOAD_MANAGER_DATABASE_PATH)+NFS_DOWNLOAD_MANAGER_DATABASE_SOURCE_FILENAME,
                    QString(m_dataBasePath+NFS_DOWNLOAD_MANAGER_DATABASE_FILENAME));



    }

   database = QSqlDatabase::addDatabase("QSQLITE");
   database.setDatabaseName(m_dataBasePath+NFS_DOWNLOAD_MANAGER_DATABASE_FILENAME);

}

void MainWindow::on_tray_quit_click()
{
    save_data_before_close();
    qApp->quit();
}
void  MainWindow::on_tray_restore_click()
{
    if(this->isHidden())
    {
        //恢复窗口显示
        this->show();
        this->setWindowState(Qt::WindowActive);
        this->activateWindow();
    }
    if(this->minimumAct)
    {
       this->setWindowState((this->windowState() & ~Qt::WindowMinimized) | Qt::WindowActive);
    }
}

//比较时间
//返回值 0 开始时间，结束时间相同
//返回值 -1 开始时间大于结束时间
//返回值 1  开始时间小于结束时间
int  MainWindow:: checkTime(QTime * start_time,QTime *end_time)
{
    if(start_time->hour() == end_time->hour() )
    {
        if(start_time->minute() == end_time->minute())
        {
            return 0;
        }
        else if(start_time->minute()  < end_time->minute())
        {
            return 1;
        }
        else {
            return -1;
        }
    }
    else if(start_time->hour() < end_time->hour())
    {
        return 1;
    }
    else {
        return -1;
    }
    return 0;
}
//判断当前时间是否在限速时间内
//返回值true 在限速时间内
//返回值false 不在限速时间内
bool MainWindow::check_if_in_period(QTime * current_time,QTime *period_start_time, QTime *period_end_time)
{
    int period_result = checkTime(period_start_time,period_end_time);
    int cmp_begin_result = checkTime(current_time,period_start_time);
    int cmp_end_result = checkTime(current_time,period_end_time);
    //开始时间与结束时间相同，只在相同时刻限速
    if(period_result == 0)
    {
        //当前时间和限速时间相同，在限速时间内
        if(cmp_begin_result ==0)
        {
            return true;
        }
    }
    //开始时间，小于结束时间
    else if(period_result == 1)
    {
        //当前时间大于开始时间，并且小于结束时间
         if(cmp_begin_result == -1 && cmp_end_result == 1)
         {
             return true;
         }
    }
    //开始时间，大于结束时间，即限时为开始时间到24点，0点到结束时间
    else {
        if(cmp_begin_result == -1 || cmp_end_result ==1)
        {
            return true;
        }

    }

    return false;
}
void MainWindow::on_deal_poweron_slot(int poweronStatus)
{
    QString autostart_desktop = "autostart/uos-downloadmanager.desktop";
    QString default_desktop = "uos-downloadmanager.desktop";
    QString user_default_desktop_path = QString("%1/autostart/")
        .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation));

    if(poweronStatus ==0)
    {
        QString cmd = QString("cp %1 %2").arg(UOS_DOWNLOAD_MANAGER_DESKTOP_PATH+default_desktop).arg(user_default_desktop_path);
        char*  ch;
        QByteArray ba = cmd.toLatin1();
        ch=ba.data();
        system(ch);

    }
    else {
         QString cmd = QString("cp %1 %2").arg(UOS_DOWNLOAD_MANAGER_DESKTOP_PATH+autostart_desktop).arg(user_default_desktop_path);
         char*  ch;
         QByteArray ba = cmd.toLatin1();
         ch=ba.data();
         system(ch);
    }

}
void MainWindow::deal_max_download_slot(QString maxDownload)
{
    QMap<QString, QVariant> opt;
    QString value = "max-concurrent-downloads=" + maxDownload;
    modify_config_file("max-concurrent-downloads=", value);
    opt.insert("max-concurrent-downloads",maxDownload);
    aria2c->changeGlobalOption(opt);
}
void MainWindow::change_download_upload_speed(QString downloadSpeed, QString uploadSpeed)
{
    QMap<QString, QVariant> opt;
    QString down_speed = downloadSpeed+"K";
    opt.insert("max-overall-download-limit",down_speed);
   // aria2c->changeGlobalOption(opt);

    QString upload_speed = uploadSpeed + "K";
    opt.insert("max-overall-upload-limit",upload_speed);
    aria2c->changeGlobalOption(opt);
}
//当有下载任务时，判断是否在限速时间内，并且根据时间进行限速设置
void MainWindow::deal_download_upload_limit_period()
{
    QTime  current_time = QTime::currentTime();
    QTime * period_start_time = new QTime();
    QTime * period_end_time = new QTime();
    QString downloadSpeed ,uploadSpeed;
    get_limit_speed_time(period_start_time,period_end_time);
    get_download_upload_limit_speed(&downloadSpeed,&uploadSpeed);
    //判断当前时间是否在限速时间内
    bool bInPeriod = check_if_in_period(&current_time,period_start_time,period_end_time);
    if(!bInPeriod)
    {
        change_download_upload_speed("102400","5120");
    }
    else
    {
        change_download_upload_speed(downloadSpeed,uploadSpeed);
    }
}

void MainWindow::get_download_upload_limit_speed(QString * downloadSpeed, QString *uploadSpeed )
{
    QString m_configPath = QString("%1/%2/%3/config.conf")
        .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
        .arg(qApp->organizationName())
        .arg(qApp->applicationName());

    Dtk::Core::QSettingBackend *m_backend = new QSettingBackend(m_configPath);

    DSettings * settings = DSettings::fromJsonFile(":/resources/json/settings.json");

    settings->setBackend(m_backend);

    QVariant maximumDownloadSpeedLimit =  settings->getOption("downloadsettings.downloadMode.maximumDownloadSpeedLimit");

    * downloadSpeed = maximumDownloadSpeedLimit.toString();

    QVariant maximumUploadSpeedLimit =  settings->getOption("downloadsettings.downloadMode.maximumUploadSpeedLimit");

    * uploadSpeed = maximumUploadSpeedLimit.toString();

}
void MainWindow::get_limit_speed_time(QTime *period_start_time, QTime *period_end_time )
{
    QString m_configPath = QString("%1/%2/%3/config.conf")
        .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
        .arg(qApp->organizationName())
        .arg(qApp->applicationName());

    Dtk::Core::QSettingBackend *m_backend = new QSettingBackend(m_configPath);

    DSettings * settings = DSettings::fromJsonFile(":/resources/json/settings.json");

    settings->setBackend(m_backend);

    QVariant speedLimitPeriod =  settings->getOption("downloadsettings.downloadMode.speedLimitPeriod");

    QString strPeriod = speedLimitPeriod.toString();

    if(!strPeriod.isEmpty())
    {
        QString start_time_info = strPeriod.section(";",0,0);

        period_start_time->setHMS(start_time_info.section(",",0,0).toInt(),start_time_info.section(",",1,1).toInt(),
                            start_time_info.section(",",2,2).toInt());
        QString end_time_info = strPeriod.section(";",1,1);

        period_end_time->setHMS(end_time_info.section(",",0,0).toInt(),end_time_info.section(",",1,1).toInt(),
                            end_time_info.section(",",2,2).toInt());
    }
}

void MainWindow::modify_config_file(QString config_item, QString value)
{
    QString strAll;
    QStringList strList;

    QString m_aria2configPath = QString("%1/%2/%3/aria2.conf")
        .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
        .arg(qApp->organizationName())
        .arg(qApp->applicationName());

    QFile readFile(m_aria2configPath);
    if(readFile.open((QIODevice::ReadOnly|QIODevice::Text)))
    {
        QTextStream stream(&readFile);
        strAll=stream.readAll();
    }
    readFile.close();
    QFile writeFile(m_aria2configPath);
    if(writeFile.open(QIODevice::WriteOnly|QIODevice::Text))
    {
        QTextStream stream(&writeFile);
        strList=strAll.split("\n");
        for(int i=0;i<strList.count();i++)
        {
            if(strList.at(i).contains(config_item))
            {
                QString tempStr=strList.at(i);
                tempStr.replace(0,tempStr.length(),value);
                stream<<tempStr<<'\n';
            }
            else {
                if(i==strList.count()-1)
                {
                    //最后一行不需要换行
                    stream<<strList.at(i);
                }
                else
                {
                    stream<<strList.at(i)<<'\n';
                }
            }
        }
    }
    writeFile.close();
}

void MainWindow::on_disckCacheNum_slot(QString disckCacheNum)
{
    QMap<QString, QVariant> opt;
    QString cacheNum = disckCacheNum+"M";
    opt.insert("disk-cache",cacheNum);
    aria2c->changeGlobalOption(opt);
    QString value = "disk-cache=" + cacheNum;
    modify_config_file("disk-cache=", value);
}
void MainWindow::on_download_limitspeed_slot(QString downloadlimitSpeed)
{
    QMap<QString, QVariant> opt;
    QTime  current_time = QTime::currentTime();
    QTime * period_start_time = new QTime();
    QTime * period_end_time = new QTime();
    QString downloadSpeed ,uploadSpeed;
    get_limit_speed_time(period_start_time,period_end_time);
    bool bInPeriod = check_if_in_period(&current_time,period_start_time,period_end_time);

    QString speed = downloadlimitSpeed+"K";
    if(bInPeriod)
    {
        opt.insert("max-overall-download-limit",speed);
        aria2c->changeGlobalOption(opt);
    }

    QString value = "max-overall-download-limit=" + speed;
    modify_config_file("max-overall-download-limit=", value);
}

void MainWindow::on_UploadSpeed_limitspeed_slot(QString UploadlimitSpeed)
{
    QMap<QString, QVariant> opt;
    QTime  current_time = QTime::currentTime();
    QTime * period_start_time = new QTime();
    QTime * period_end_time = new QTime();
    QString downloadSpeed ,uploadSpeed;
    QString speed = UploadlimitSpeed+"K";
    get_limit_speed_time(period_start_time,period_end_time);
    bool bInPeriod = check_if_in_period(&current_time,period_start_time,period_end_time);
    if(bInPeriod)
    {
        opt.insert("max-overall-upload-limit",speed);
        aria2c->changeGlobalOption(opt);
    }

    QString value = "max-overall-upload-limit=" + speed;
    modify_config_file("max-overall-upload-limit=", value);
}
void MainWindow::slotContextMenu(QPoint pos)
{
    int chkedCnt = 0;
    if(current_listview_row == 2) {
        QList<DelDataItem*> recyleList = recycle_tableview->get_tableViewModel()->recyleList();
        for(int i = 0; i < recyleList.size(); i++) {
            if(recyleList.at(i)->Ischecked) {
                chkedCnt++;
            }
        }
    }
    else {
        QList<DataItem*> selectList = downloading_tableview->get_tableViewModel()->renderList();
        for(int i = 0; i < selectList.size(); i++) {
            if(selectList.at(i)->Ischecked) {
                chkedCnt++;
            }
        }
    }
    if(chkedCnt == 0) {
        return;
    }

    int activeCount=0;
    int pauseCount =0;
    int renamCount =0;
    int errorCount =0;
    QMenu *delmenlist= new QMenu(this);
    if(current_listview_row==0)
    {
       QList<DataItem*> selectList= downloading_tableview->get_tableViewModel()->renderList();
       for(int i = 0; i < selectList.size(); ++i)
       {
            if(selectList.at(i)->Ischecked==1)
            {
                DataItem *data = selectList.at(i);
                if(data->status==Global::Status::Active)
                {
                    ++activeCount;
                }
                if(data->status==Global::Status::Paused||data->status==Global::Status::Lastincomplete)
                {
                    ++pauseCount;
                }
                if(data->status==Global::Status::Error)
                {
                    ++errorCount;
                }
            }
        }
        if(pauseCount>0)
        {
            QAction *actionStart= new QAction();
            actionStart->setText(tr("start"));
            delmenlist->addAction(actionStart);
            connect(actionStart,&QAction::triggered,this,&MainWindow::onStartDownloadBtnClicked);
        }

        if(activeCount>0)
        {
            QAction *actionPause= new QAction();
            actionPause->setText(tr("pause"));
            delmenlist->addAction(actionPause);
            connect(actionPause,&QAction::triggered,this,&MainWindow::onPauseDownloadBtnClicked);
        }
        if(errorCount>0)
        {
            QAction *actionredownload= new QAction();
            actionredownload->setText(tr("Redownload"));
            delmenlist->addAction(actionredownload);
            connect(actionredownload,&QAction::triggered,this, &MainWindow::redownload_Action);
        }
        delmenlist->addSeparator();
    }
    if(current_listview_row==2)
    {
        QAction *returned_to_origin= new QAction();
        returned_to_origin->setText(tr("return to origin"));
        connect(returned_to_origin,&QAction::triggered,this, &MainWindow::returnTo_origin_Action);
        delmenlist->addAction(returned_to_origin);

    }
    if(current_listview_row==1||current_listview_row==2)
    {
        QAction *actionopenFile= new QAction();
        actionopenFile->setText(tr("Open"));
        delmenlist->addAction(actionopenFile);
        connect(actionopenFile,&QAction::triggered,this, &MainWindow::open_file_Action);
     }
    QAction *actionopenFoler= new QAction();
    actionopenFoler->setText(tr("Open folder"));
    delmenlist->addAction(actionopenFoler);
    connect(actionopenFoler,&QAction::triggered,this,&MainWindow::open_Folder_Action);


//    if(current_listview_row==0||current_listview_row==1)
//    {
//        QAction *action_move_to_directory= new QAction();
//        action_move_to_directory->setText(tr("move to directory"));
//        delmenlist->addAction(action_move_to_directory);
//        connect(action_move_to_directory,&QAction::triggered,this, &MainWindow::moveTo_directory_Action);

//    }
    if(current_listview_row==0)
    {
        delmenlist->addSeparator();
    }
    if(current_listview_row==1)
    {
        QList<DataItem*> selectList= downloading_tableview->get_tableViewModel()->renderList();
        for(int i = 0; i < selectList.size(); ++i)
        {
             if(selectList.at(i)->Ischecked==1)
             {
                 DataItem *data = selectList.at(i);
                 if(data->status==Global::Status::Complete)
                 {
                     ++renamCount;
                 }
             }
        }

        if(renamCount==1)
        {

            QAction *action_rename= new QAction();
            action_rename->setText(tr("rename"));
            delmenlist->addAction(action_rename);
            delmenlist->addSeparator();
            connect(action_rename,&QAction::triggered,this, &MainWindow::rename_Action);
        }


    }
    if(current_listview_row==1||current_listview_row==2)
    {
        QAction *actionredownload= new QAction();
        actionredownload->setText(tr("Redownload"));
        delmenlist->addAction(actionredownload);
        connect(actionredownload,&QAction::triggered,this, &MainWindow::redownload_Action);

    }
    QAction *action_copy_download_url= new QAction();
    action_copy_download_url->setText(tr("Copy Download Url"));
    delmenlist->addAction(action_copy_download_url);
    delmenlist->addSeparator();
    connect(action_copy_download_url,&QAction::triggered,this, &MainWindow::copy_download_url_Action);
    if(current_listview_row==0||current_listview_row==1)
    {
        QAction *actiondel_downloading= new QAction();
        actiondel_downloading->setText(tr("Delete" ));
        delmenlist->addAction(actiondel_downloading);
        connect(actiondel_downloading,&QAction::triggered,this,&MainWindow::del_downloading_Action);
    }
    QAction *action_delete_permanently= new QAction();
    action_delete_permanently->setText(tr("Delete permanently"));
    delmenlist->addAction(action_delete_permanently);
    connect(action_delete_permanently,&QAction::triggered,this, &MainWindow::delete_permanently_Action);
    if(current_listview_row==2)
    {
        QAction *action_clear_recycle= new QAction();
        action_clear_recycle->setText(tr("Clear"));
        delmenlist->addAction(action_clear_recycle);
        connect(action_clear_recycle,&QAction::triggered,this, &MainWindow::clear_recycle_Action);
    }

    delmenlist->exec(QCursor::pos());
    delete  delmenlist;

}
void MainWindow::rename_Action()
{
    QList<DataItem *> selectList;
    int selected_count=0;
    rename_list.clear();
    selectList= downloading_tableview->get_tableViewModel()->renderList();
   for(int i = 0; i < selectList.size(); ++i)
   {
       if(selectList.at(i)->status==Complete)
       {
           if(selectList.at(i)->Ischecked==1)
           {
               DataItem *data=selectList.at(i);
               rename_list.append(data);
               ++selected_count;
           }
       }
   }
   if(selected_count==0)
   {
       show_Warning_MsgBox(tr("no item is selected,please check items!"));
   }
   else
   {
    show_rename_MsgBox();
   }

}
void MainWindow::clear_recycle_Action()
{
      show_clear_MsgBox();
}
void MainWindow::returnTo_origin_Action()
{
    int selected_count=0;
    QList<DelDataItem *> recycle_list=recycle_tableview->get_tableViewModel()->recyleList();
    for(int i=0;i<recycle_list.size();i++)
    {
        DelDataItem *data=recycle_list.at(i);
        if(data->Ischecked==1&&!recycle_tableview->isRowHidden(i))
        {
            DataItem * returnTo_data= new DataItem;
            ++selected_count;
            if(data->completedLength==data->totalLength)
            {
                if(data->totalLength != "0B")
                {
                    returnTo_data->status=Global::Status::Complete;
                }
                else
                {
                    returnTo_data->status=Global::Status::Active;
                }


            }
            else
            {
                long completedLength=returnTo_data->completedLength.toLong();


        if (returnTo_data->completedLength != "0B" && returnTo_data->totalLength != "0B") {
                  returnTo_data->percent=  returnTo_data->completedLength.toLong() * 100.0 / returnTo_data->totalLength.toLong();

                  if(returnTo_data->percent < 0 || returnTo_data->percent > 100)
                  {
                      returnTo_data->percent =0;
                  }
              }
              else {
                  returnTo_data->percent = 0;
              }


            }
            returnTo_data->fileName=data->fileName;
            returnTo_data->savePath=data->savePath;
            returnTo_data->totalLength=data->totalLength;
            returnTo_data->completedLength=data->completedLength;
            returnTo_data->url=data->url;
            returnTo_data->gid=data->gid;
            returnTo_data->time=data->finishTime;
            returnTo_data->taskId=data->taskId;
            downloading_tableview->get_tableViewModel()->append(returnTo_data);
            if(data->completedLength!=data->totalLength||data->totalLength=="0B")
            {
                QMap<QString, QVariant> opt;
                returnTo_data->url=data->url;
                QString file_path = data->savePath;
                QString file_name = data->fileName;
                QString default_savePath = get_download_savePath_from_config() ;
                QString save_path ;

                if(default_savePath != data->savePath)
                {
                    int name_length = file_name.size();
                    int file_path_length = file_path.size();
                    int folder_path_length = file_path_length-name_length-1;
                    save_path = file_path.left(folder_path_length);
                }
                else {
                    save_path = default_savePath;
                }


                opt.insert("dir", save_path);

                Tb_Url_Info *url_info= new Tb_Url_Info;
                Tb_Url_Info *get_url_info;
                get_url_info= url_info->getTbUrlInfoByTaskId(returnTo_data->taskId);
                if(get_url_info!=nullptr)
                {
                    if(get_url_info->download_type=="torrent")
                    {
                        QString select_num=get_url_info->selectedNum;
                        QString seed_file_path=get_url_info->seedFile;

                        opt.insert("select-file",select_num);

                        if(!QFile(seed_file_path).exists())
                        {
                            show_Warning_MsgBox(tr("seed file not exists or broken;"));
                        }
                        else {
                            aria2c->addTorrent(seed_file_path,opt,get_url_info->task_id);
                            if (updatetimer->isActive() == false)
                            {
                                updatetimer->start(2*1000);
                            }

                        }


                    }
                }
                else
                {
                    deal_download_upload_limit_period();
                    aria2c->addUri(returnTo_data->url,opt, returnTo_data->taskId);
                    Global_Url=returnTo_data->url;
                    if (updatetimer->isActive() == false)
                    {
                         updatetimer->start(2*1000);
                    }

                }
            }
            recycle_tableview->get_tableViewModel()->removeItem(data);
	    setTask_Num(current_listview_row);

        }
    }
    if(selected_count==0)
    {
        show_Warning_MsgBox(tr("no item is selected,please check items!"));
    }
    else {
        //ToolBar禁用按钮联动：还原后禁用按钮
        this->m_toolBar->enableStartBtn(false);
        this->m_toolBar->enablePauseBtn(false);
        this->m_toolBar->enableDeleteBtn(false);
    }

}
void MainWindow::moveTo_directory_Action()
{

}
void MainWindow::redownload_Action()
{
    int selected_count=0;

    if(current_listview_row==1||current_listview_row==0)
    {
        QList<DataItem *> selectList;
        reload_list.clear();
        selectList= downloading_tableview->get_tableViewModel()->renderList();
       for(int i = 0; i < selectList.size(); ++i)
       {

           if((current_listview_row==1&&selectList.at(i)->status==Complete)||(current_listview_row==0&&selectList.at(i)->status==Error))
           {
               if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
               {
                   DataItem *data=selectList.at(i);
                   reload_list.append(data);
                   ++selected_count;
               }
           }
       }
    }
    else
    {
        QList<DelDataItem *> selectList;
        recycle_reload_list.clear();
        selectList= recycle_tableview->get_tableViewModel()->recyleList();
       for(int i = 0; i < selectList.size(); ++i)
       {
           if(selectList.at(i)->status==Removed)
           {
               if(selectList.at(i)->Ischecked==1&&!recycle_tableview->isRowHidden(i))
               {
                   DelDataItem *data=selectList.at(i);
                   recycle_reload_list.append(data);
                   ++selected_count;
               }
           }
       }
    }
   if(selected_count==0)
       show_Warning_MsgBox(tr("no item is selected,please check items!"));
   else {
       show_reload_MsgBox();
   }


}
void MainWindow::get_Redowload_confirm_slot()
{
    if(current_listview_row==1||current_listview_row==0)
    {
        for(int i=0;i<reload_list.size();i++)
        {
            DataItem *data=reload_list.at(i);
            QString url=data->url;
            QString aria_temp_file=data->savePath+".aria2";
            QString taskId=data->taskId;
            if(!data->savePath.isEmpty())
            {
                QFile::remove(data->savePath);
                if(QFile::exists(aria_temp_file))
                {
                    QFile::remove(aria_temp_file);
                }
            }

            QString file_path = data->savePath;
            QString file_name = data->fileName;
            QString default_savePath = get_download_savePath_from_config() ;
            QString save_path ;

            if(default_savePath != data->savePath)
            {
                int name_length = file_name.size();
                int file_path_length = file_path.size();
                int folder_path_length = file_path_length-name_length-1;
                save_path = file_path.left(folder_path_length);
            }
            else {
                save_path = default_savePath;
            }

            //aria2c->remove(data->gid,data->taskId);
            aria2c->removeDownloadResult(data->gid,data->taskId);
           downloading_tableview->get_tableViewModel()->removeItem(data);
          // QString save_path=get_download_savePath_from_config();

           deal_download_upload_limit_period();

           Tb_Task task;
           task.deleteTbTask(taskId);
           Tb_Url_Info url_info;
           Tb_Url_Info *get_url_info;
           get_url_info= url_info.getTbUrlInfoByTaskId(taskId);
           if(get_url_info!=NULL)
           {
               if(get_url_info->download_type=="torrent")
               {
                   if(!get_url_info->infoHash.isEmpty())
                   {
                       QFile::remove(get_url_info->infoHash+".torrent");
                   }
                   QMap<QString,QVariant> opt;
                   opt.insert("dir",save_path);
                   opt.insert("select-file",get_url_info->selectedNum);
                   aria2c->addTorrent(get_url_info->seedFile,opt,get_url_info->task_id);
                   Tb_Task *add_task= new Tb_Task(get_url_info->task_id,"",0,"","",file_name,QDateTime::currentDateTime());
                   task.addTbTask(add_task);
                }
           }
           else
           {
               QUuid id = QUuid::createUuid();
               QString strId = id.toString();
               QMap<QString, QVariant> opt;
               opt.insert("dir", save_path);
               aria2c->addUri(url,opt,strId);

               QString filename=QString(url).right(url.length() - url.lastIndexOf('/') - 1);
               if(!filename.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
               {
                   const QByteArray filename_byte=filename.toLatin1();
                   QString filename_decode=QUrl::fromPercentEncoding(filename_byte);
                   filename=filename_decode;
               }

               Tb_Task *add_task= new Tb_Task(strId,"",0,url,file_path,filename,QDateTime::currentDateTime());
               task.addTbTask(add_task);

           }
        }
    }
    else
    {
        for(int i=0;i<recycle_reload_list.size();i++)
        {
            DelDataItem *data=recycle_reload_list.at(i);
            QString url=data->url;
            QString taskId=data->taskId;
            QString aria_temp_file=data->savePath+".aria2";
            if(!data->savePath.isEmpty())
            {
                QFile::remove(data->savePath);
                if(QFile::exists(aria_temp_file))
                {
                    QFile::remove(aria_temp_file);
                }
            }
            QString file_path = data->savePath;
            QString file_name = data->fileName;
            QString default_savePath = get_download_savePath_from_config() ;
            QString save_path ;

            if(default_savePath != data->savePath)
            {
                int name_length = file_name.size();
                int file_path_length = file_path.size();
                int folder_path_length = file_path_length-name_length-1;
                save_path = file_path.left(folder_path_length);
            }
            else {
                save_path = default_savePath;
            }

           // aria2c->remove(data->gid,taskId);
            aria2c->removeDownloadResult(data->gid);
            recycle_tableview->get_tableViewModel()->removeItem(data);
            deal_download_upload_limit_period();
           // QString  save_path=get_download_savePath_from_config();
            Tb_Task task;
            task.deleteTbTask(taskId);
            QUuid id = QUuid::createUuid();
            QString strId = id.toString();
            Tb_Url_Info url_info;
            Tb_Url_Info *get_url_info;
            get_url_info= url_info.getTbUrlInfoByTaskId(taskId);
            if(get_url_info!=NULL)
            {
                if(get_url_info->download_type=="torrent")
                {

                    if(!get_url_info->infoHash.isEmpty())
                    {
                        QFile::remove(get_url_info->infoHash+".torrent");
                    }
                    QMap<QString,QVariant> opt;
                    opt.insert("dir",save_path);
                    opt.insert("select-file",get_url_info->selectedNum);
                    aria2c->addTorrent(get_url_info->seedFile,opt,get_url_info->task_id);

                    Tb_Task *add_task= new Tb_Task(get_url_info->task_id,"",0,"","",file_name,QDateTime::currentDateTime());
                    task.addTbTask(add_task);

                }
            }

            else
            {

                QMap<QString, QVariant> opt;
                opt.insert("dir", save_path);
                aria2c->addUri(url,opt,strId);
                QString filename=QString(url).right(url.length() - url.lastIndexOf('/') - 1);
                if(!filename.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
                {
                    const QByteArray filename_byte=filename.toLatin1();
                    QString filename_decode=QUrl::fromPercentEncoding(filename_byte);
                    filename=filename_decode;
                }
                Tb_Task *add_task= new Tb_Task(strId,"",0,url,file_path,filename,QDateTime::currentDateTime());
                task.addTbTask(add_task);
            }
        }
    }
    if (updatetimer->isActive() == false)
    {
        updatetimer->start(2*1000);
    }

}


void MainWindow::get_delete_confirm_slot(bool ischecked,bool permanent)
{

        QString gid;
        QString aria_temp_file;
        QString save_path;
        QString task_id;
        bool ifDeleteLocal = permanent||ischecked;
        if (updatetimer->isActive() )
        {
            updatetimer->stop();
        }

        if(current_listview_row==2)
        {

            QList<DelDataItem> thread_recycle_delete_list;
            for(int i=0;i<recycle_delete_list.size();i++)
            {
                DelDataItem tempdata;
                tempdata.status = recycle_delete_list.at(i)->status;
                tempdata.Ischecked = recycle_delete_list.at(i)->Ischecked;
                tempdata.taskId = recycle_delete_list.at(i)->taskId;
                tempdata.fileName = recycle_delete_list.at(i)->fileName;
                tempdata.completedLength =  recycle_delete_list.at(i)->completedLength;
                tempdata.savePath = recycle_delete_list.at(i)->savePath;
                tempdata.gid = recycle_delete_list.at(i)->gid;
                tempdata.url = recycle_delete_list.at(i)->url;
                tempdata.totalLength = recycle_delete_list.at(i)->totalLength;
                tempdata.deleteTime = recycle_delete_list.at(i)->deleteTime;
                tempdata.finishTime = recycle_delete_list.at(i)->finishTime;
                thread_recycle_delete_list.append(tempdata);


            }

            DeleteItemThread * deleteItemThread = new DeleteItemThread(thread_recycle_delete_list,recycle_tableview ,aria2c,ifDeleteLocal,"recycle_delete");
            connect(deleteItemThread, SIGNAL(signal_aria2_remove(QString, QString)), this, SLOT(slot_aria2_remove(QString, QString)), Qt::QueuedConnection);
            deleteItemThread->start();

            for(int i=0;i<recycle_delete_list.size();i++)
            {
                DelDataItem *data= new DelDataItem;
                data = recycle_delete_list.at(i);
                task_id = data->taskId;

                Tb_Donwload_Task_Status tb_download_status;
                tb_download_status.deleteTbTaskStauts(task_id);
                Tb_Url_Info tb_url_info;
                tb_url_info.deleteTbUrl(task_id);

                recycle_tableview->get_tableViewModel()->removeItem(data);

            }
            setTask_Num(current_listview_row);

        }
        else
        {
            DataItem *data= new DataItem;

            QList<DataItem> thread_delete_list;


            for(int i=0;i<delete_list.size();i++)
            {
                DataItem tempdata;

                tempdata.status = delete_list.at(i)->status;
                tempdata.percent = delete_list.at(i)->percent;
                tempdata.total = delete_list.at(i)->total;
                tempdata.Ischecked = delete_list.at(i)->Ischecked;
                tempdata.taskId = delete_list.at(i)->taskId;
                tempdata.fileName = delete_list.at(i)->fileName;
                tempdata.completedLength =  delete_list.at(i)->completedLength;
                tempdata.totalLength =  delete_list.at(i)->totalLength;
                tempdata.savePath = delete_list.at(i)->savePath;
                tempdata.speed = delete_list.at(i)->speed;
                tempdata.gid = delete_list.at(i)->gid;
                tempdata.url = delete_list.at(i)->url;
                tempdata.time = delete_list.at(i)->time;
                tempdata.createTime = delete_list.at(i)->createTime;

                thread_delete_list.append(tempdata);


            }

            DeleteItemThread * deleteItemThread = new DeleteItemThread(thread_delete_list,downloading_tableview,aria2c,ifDeleteLocal,"download_delete");
            connect(deleteItemThread, SIGNAL(signal_aria2_remove(QString, QString)), this, SLOT(slot_aria2_remove(QString, QString)), Qt::QueuedConnection);
            deleteItemThread->start();

            for(int i = 0; i < delete_list.size(); i++)
            {
                 data=delete_list.at(i);
                 save_path=data->savePath;
                 gid=data->gid;
                 task_id=data->taskId;
                 QDateTime finish_time;
                 if(data->status==Complete)
                     finish_time=QDateTime::fromString(data->time, "yyyy-MM-dd hh:mm:ss");
                 else {
                     finish_time=QDateTime::fromString("","yyyy-MM-dd hh:mm:ss");
                 }

                 Tb_Donwload_Task_Status get_status;
                 Tb_Donwload_Task_Status *download_status = new Tb_Donwload_Task_Status(data->taskId,Global::Status::Removed,QDateTime::currentDateTime(),data->completedLength,data->speed,data->totalLength,data->percent,data->total,finish_time);




                 if(permanent||ischecked)
                 {
                         Tb_Donwload_Task_Status tb_download_status;
                         tb_download_status.deleteTbTaskStauts(task_id);
                         Tb_Url_Info tb_url_info;
                         tb_url_info.deleteTbUrl(task_id);
                         aria2c->purgeDownloadResult(data->gid);
                        // aria2c->removeDownloadResult(data->gid,task_id);
                  }

                 if(!permanent && !ischecked)
                 {
                      DelDataItem *delData= new DelDataItem;
                      delData->taskId=data->taskId;
                      delData->gid=data->gid;
                      delData->url=data->url;
                      delData->fileName=data->fileName;
                      delData->savePath=data->savePath;
                      delData->Ischecked=false;
                      delData->totalLength=data->totalLength;
                      delData->completedLength=data->completedLength;
                      delData->deleteTime=QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss");
                      delData->finishTime=data->time;

                      addDeleteItem_toRecycle(delData);

                      if(get_status.getTbDownloadStatusByTaskId(delData->taskId)!=NULL)
                      {
                          download_status->updateTbDownloadStatusByTaskId(download_status);
                      }
                      else
                      {
                          download_status->addTbDownloadTaskStatus(download_status);
                      }


                }

                 downloading_tableview->get_tableViewModel()->removeItem(data);
            }

            setTask_Num(current_listview_row);
        }
        if(this->g_search_content != "")
        {
            slot_searchEditTextChange(this->g_search_content);
        }
        if (updatetimer->isActive() == false)
        {
             updatetimer->start(2*1000);
        }

}


void MainWindow::get_clear_Recycle_slot(bool ischecked)
{
    QList<DelDataItem *> recycle_list=recycle_tableview->get_tableViewModel()->recyleList();
    if(ischecked)
    {
        for(int i=0;i<recycle_list.size();++i)
        {
            DelDataItem *data=recycle_list.at(i);
            QString aria_temp_file=data->savePath+".aria2";
           if(!data->savePath.isEmpty())
            {
                 QFile::remove(data->savePath);
                 if(QFile::exists(aria_temp_file))
                 {
                      QFile::remove(aria_temp_file);
                  }
              }
           aria2c->removeDownloadResult(data->gid);

        }

    }
    for(int i=0;i<recycle_list.size();++i)
    {
        DelDataItem *data=recycle_list.at(i);
        Tb_Donwload_Task_Status tb_download_status;
        tb_download_status.deleteTbTaskStauts(data->taskId);
        Tb_Url_Info tb_url_info;
        tb_url_info.deleteTbUrl(data->taskId);
    }

    recycle_tableview->get_tableViewModel()->removeItems(true);


}
void MainWindow::copy_download_url_Action()
{
    QList<DelDataItem *> recycle_selectList;
    int selected_count=0;
    QString copy_url="";
    QString url;
    if(current_listview_row==2)
    {
      recycle_selectList= recycle_tableview->get_tableViewModel()->recyleList();
      for(int i = 0; i < recycle_selectList.size(); ++i)
      {
          DelDataItem *data=recycle_selectList.at(i);
          if(data->Ischecked==1&&!recycle_tableview->isRowHidden(i))
          {
              Tb_Url_Info *url_info= new Tb_Url_Info;
              Tb_Url_Info *get_url_info;
              get_url_info= url_info->getTbUrlInfoByTaskId(data->taskId);
              if(get_url_info!=nullptr)
              {
                  if(get_url_info->download_type=="torrent")
                  {
                      url="magnet:?xt=urn:btih:"+get_url_info->infoHash;
                  }
              }
              else
              {
                   url=data->url;

              }

              ++selected_count;
              if(copy_url=="")
                copy_url=url;
              else
              {
                copy_url=copy_url+"\n"+url;
              }
          }
      }
    }
    else
    {
        QList<DataItem *> selectList;

       selectList= downloading_tableview->get_tableViewModel()->renderList();

       for(int i = 0; i < selectList.size(); ++i)
       {
           DataItem *data= new DataItem;
           bool isSelect = false;
            if(current_listview_row==1&&selectList.at(i)->status==Complete)
            {
                   if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                   {
                       data=selectList.at(i);
                       ++selected_count;
                       isSelect = true;

                   }
            }
            else
            {
                if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                {
                    data=selectList.at(i);
                    ++selected_count;
                     isSelect = true;

                }

             }
            if(isSelect)
            {
                Tb_Url_Info *url_info= new Tb_Url_Info;
                Tb_Url_Info *get_url_info;
                QString url;
                get_url_info= url_info->getTbUrlInfoByTaskId(data->taskId);
                if(get_url_info!=nullptr)
                {
                    if(get_url_info->download_type=="torrent")
                    {
                        url="magnet:?xt=urn:btih:"+get_url_info->infoHash;
                    }
                }
                else
                {
                    url=data->url;
                }
                if(copy_url=="")
                 copy_url=url;
                else
                {
                  copy_url=copy_url+"\n"+url;
                }
            }

         }
   }


   if(selected_count==0)
   {
       show_Warning_MsgBox(tr("no item is selected,please check items!"));
   }
   else {
       QClipboard *clipboard = DApplication::clipboard();
       clipboard->setText(copy_url);

       Task_Num->setText(tr("download uri already copyed"));
   }
}
void MainWindow::delete_permanently_Action()
{
    int selected_count=0;
    if(current_listview_row==2)
    {
        QList<DelDataItem *> recycle_selectList;
        recycle_delete_list.clear();
        recycle_selectList= recycle_tableview->get_tableViewModel()->recyleList();
        for(int i = 0; i < recycle_selectList.size(); ++i)
        {
                if(recycle_selectList.at(i)->Ischecked==1&&!recycle_tableview->isRowHidden(i))
                {
                    recycle_delete_list.append(recycle_selectList.at(i));
                    selected_count++;
                }
        }
    }
    else
    {
        QList<DataItem *> selectList;
        delete_list.clear();
        selectList= downloading_tableview->get_tableViewModel()->renderList();
           for(int i = 0; i < selectList.size(); ++i)
           {
               DataItem *data= new DataItem;
               if(current_listview_row==1)
               {
                   if(selectList.at(i)->status==Complete)
                   {
                        if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                       {
                            data=selectList.at(i);
                            delete_list.append(data);
                            ++selected_count;
                       }
                   }
               }
               else
               {
                   if(selectList.at(i)->status!=Complete)
                   {
                        if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                       {
                            data=selectList.at(i);
                            delete_list.append(data);
                           ++selected_count;
                       }

                   }
               }

           }

    }
    if(selected_count==0)
    {
        show_Warning_MsgBox(tr("no item is selected,please check items!"));

    }
    else
    {
        show_delete_MsgBox(true);
    }

}
void MainWindow::del_downloading_Action()
{
    int selected_count=0;
    if(current_listview_row==2)
    {
        QList<DelDataItem *> recycle_selectList;
        recycle_delete_list.clear();
        recycle_selectList= recycle_tableview->get_tableViewModel()->recyleList();
        for(int i = 0; i < recycle_selectList.size(); ++i)
        {
                if(recycle_selectList.at(i)->Ischecked==1&&!recycle_tableview->isRowHidden(i))
                {
                    recycle_delete_list.append(recycle_selectList.at(i));
                    selected_count++;
                }
        }
    }
    else
    {
        QList<DataItem *> selectList;
        delete_list.clear();
        selectList= downloading_tableview->get_tableViewModel()->renderList();
           for(int i = 0; i < selectList.size(); ++i)
           {
               DataItem *data= new DataItem;

               if(current_listview_row==1)
               {
                   if(selectList.at(i)->status==Complete)
                   {
                       if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                        {
                            data=selectList.at(i);
                            delete_list.append(data);
                            ++selected_count;

                         }
                   }
               }
               else
               {
                   if(selectList.at(i)->status!=Complete)
                   {
                       if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                        {
                            data=selectList.at(i);
                            delete_list.append(data);
                            ++selected_count;

                        }
                   }
               }

           }

    }
    if(selected_count==0)
    {
        show_Warning_MsgBox(tr("no item is selected,please check items!"));

    }
    else
    {
        show_delete_MsgBox(false);
    }

    }

void MainWindow::open_file_Action()
{
    QList<DataItem *> selectList;
    QList<DelDataItem *> delList;
    int selected_count=0;
    if(current_listview_row==1)
    {
        selectList= downloading_tableview->get_tableViewModel()->renderList();
        for(int i = 0; i < selectList.size(); ++i)
        {
             if(selectList.at(i)->status==Complete)
             {
                if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                {
                    DataItem *data=selectList.at(i);
                    ++selected_count;
                    QString file_path=data->savePath;
                    QString file_name=data->fileName;
                    QString path=QString("file:///")+ file_path;
                    bool is_open= QDesktopServices::openUrl(QUrl(path,QUrl::TolerantMode));
                }
             }
        }
    }
    else
    {

        delList= recycle_tableview->get_tableViewModel()->recyleList();
        for(int i = 0; i < delList.size(); ++i)
        {
                if(delList.at(i)->Ischecked==1&&!recycle_tableview->isRowHidden(i))
                {

                    DelDataItem *data=delList.at(i);
                    ++selected_count;
                    QString file_path=data->savePath;
                    QString file_name=data->fileName;
                    QString path=QString("file:///")+ file_path;
                    bool is_open= QDesktopServices::openUrl(QUrl(path,QUrl::TolerantMode));
                }
        }

    }

    if(selected_count==0)
    {
        show_Warning_MsgBox(tr("no item is selected,please check items!"));

    }
}
void MainWindow::open_Folder_Action()
{

    QList<DataItem *> selectList;
    QList<DelDataItem *> delList;
    int selected_count=0;
    if(current_listview_row==2)
    {
        delList= recycle_tableview->get_tableViewModel()->recyleList();
        for(int j=0;j<delList.size();++j)
        {
            if(delList.at(j)->Ischecked==1&&!recycle_tableview->isRowHidden(j))
            {
                DelDataItem *deldata= delList.at(j);
                selected_count++;
                QString file_path = deldata->savePath;
                QString file_name = deldata->fileName;
                QString default_savePath = get_download_savePath_from_config() ;
                QString file_folder_path ;

                if(default_savePath != deldata->savePath)
                {
                    int name_length = file_name.size();
                    int file_path_length = file_path.size();
                    int folder_path_length = file_path_length-name_length-1;
                    file_folder_path = file_path.left(folder_path_length);
                }
                else {
                    file_folder_path = default_savePath;
                }

                QString path=QString("file:///")+ file_folder_path;
                bool is_open= QDesktopServices::openUrl(QUrl(path,QUrl::TolerantMode));
            }
        }
    }
    else
    {

       selectList= downloading_tableview->get_tableViewModel()->renderList();
       for(int i = 0; i < selectList.size(); ++i)
       {
           if(current_listview_row==1)
           {
               if(selectList.at(i)->status==Complete)
               {
                   if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
                   {
                       DataItem *data=selectList.at(i);
                       ++selected_count;

                       QString file_path = data->savePath;
                       QString file_name = data->fileName;
                       QString default_savePath = get_download_savePath_from_config() ;
                       QString file_folder_path ;

                       if(default_savePath != data->savePath)
                       {
                           int name_length = file_name.size();
                           int file_path_length = file_path.size();
                           int folder_path_length = file_path_length-name_length-1;
                           file_folder_path = file_path.left(folder_path_length);
                       }
                       else {
                           file_folder_path = default_savePath;
                       }

                       QString path=QString("file:///")+ file_folder_path;
                       bool is_open= QDesktopServices::openUrl(QUrl(path,QUrl::TolerantMode));
                   }
               }
           }
           else
           {
              if(selectList.at(i)->status!=Complete)
              {
               if(selectList.at(i)->Ischecked==1&&!downloading_tableview->isRowHidden(i))
               {
                   DataItem *data=selectList.at(i);
                   ++selected_count;

                   QString file_path = data->savePath;
                   QString file_name = data->fileName;
                   QString default_savePath = get_download_savePath_from_config() ;
                   QString file_folder_path ;

                   if(default_savePath != data->savePath)
                   {
                       int name_length = file_name.size();
                       int file_path_length = file_path.size();
                       int folder_path_length = file_path_length-name_length-1;
                       file_folder_path = file_path.left(folder_path_length);
                   }
                   else {
                       file_folder_path = default_savePath;
                   }


                   QString path=QString("file:///")+ file_folder_path;
                   bool is_open= QDesktopServices::openUrl(QUrl(path,QUrl::TolerantMode));
               }
              }
           }
       }
    }
   if(selected_count==0)
   {
       show_Warning_MsgBox(tr("no item is selected,please check items!"));

   }

}




void MainWindow::initConnections()
{
    connect(updatetimer, SIGNAL(timeout()), this, SLOT(Update_MainUi()));
    connect(downloading_tableview,SIGNAL(customContextMenuRequested(const QPoint)),this,SLOT(slotContextMenu(const QPoint)));
    connect(recycle_tableview,SIGNAL(customContextMenuRequested(const QPoint)),this,SLOT(slotContextMenu(const QPoint)));

    connect(downloading_tableview, SIGNAL(pressed(QModelIndex)), this, SLOT(slot_selected(QModelIndex)));
    connect(recycle_tableview, SIGNAL(pressed(QModelIndex)), this, SLOT(slot_selected(QModelIndex)));

//    connect(downloading_tableview,SIGNAL(get_datachanged()),this,SLOT(update_checkbox()));
    connect(left_list,SIGNAL(clicked(const QModelIndex)),this,SLOT(itemClicked(const QModelIndex)));
    connect(m_toolBar, &ToolBar::newDownloadBtnClicked, this, &MainWindow::onNewDownloadBtnClicked);
    connect(m_toolBar, &ToolBar::pauseDownloadBtnClicked, this, &MainWindow::onPauseDownloadBtnClicked);
    connect(m_toolBar, &ToolBar::startDownloadBtnClicked, this, &MainWindow::onStartDownloadBtnClicked);
    connect(m_toolBar, &ToolBar::deleteDownloadBtnClicked, this, &MainWindow::onDeleteDownloadBtnClicked);
    connect(m_toolBar, &ToolBar::getSearchEditFocus, this, &MainWindow::onSearchEditFocusChanged);
    connect(this, &MainWindow::table_changed, m_toolBar, &ToolBar::get_table_changed);
    connect(settingAction, &QAction::triggered, this, &MainWindow::onSettingsMenuClicked);

    //search begin
    connect(m_toolBar, SIGNAL(getSearchEditTextChange(QString)), this, SLOT(slot_searchEditTextChange(QString)));
    //search end
    //auto download bt begin 连接异步信号
    connect(this, SIGNAL(signal_auto_download_bt(QString)), this, SLOT(slot_auto_download_bt(QString)), Qt::QueuedConnection);
    //auto download bt end
    connect(downloading_tableview->get_tableViewModel(), SIGNAL(signal_check_change(bool, int)), this, SLOT(slot_check_change(bool, int)));
    connect(recycle_tableview->get_tableViewModel(), SIGNAL(signal_check_change(bool, int)), this, SLOT(slot_check_change(bool, int)));
    connect(DGuiApplicationHelper::instance(),&DGuiApplicationHelper::paletteTypeChanged,this,&MainWindow::get_paletteTypeChanged);

}
void MainWindow::itemClicked(const QModelIndex &index)
{
    current_listview_row=index.row();
    QString DownloadTask_Lable_Text;
    if(index.row()==0||index.row()==1)
    {

        RightStackwidget->setCurrentIndex(0);
        refreshTableView(index.row());
        downloading_tableview->horizontalHeader()->reset();
        bool switched=true;
        downloading_tableview->reset(switched);
        if(index.row()==1)
        {
            connect(downloading_tableview, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(get_doubleClicked(QModelIndex)));
            downloading_tableview->verticalHeader()->setDefaultSectionSize(30);
            noTask_Widget->show();
            noTask_label->setText(tr("current no download finish task"));
            noTask_tip_Label->hide();

        }
        else
        {
            disconnect(downloading_tableview, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(get_doubleClicked(QModelIndex)));
            downloading_tableview->verticalHeader()->setDefaultSectionSize(56);
            noTask_label->setText(tr("current no download task"));
            noTask_Widget->show();
            noTask_tip_Label->show();
        }
    }
    else
    {
        RightStackwidget->setCurrentIndex(1);
        noTask_Widget->show();
        noTask_label->setText(tr("current no delete files"));
        noTask_tip_Label->hide();



    }
    clear_table_item_check_status();

    emit switch_table_signal();

    setTask_Num(current_listview_row);

    //search begin
    slot_searchEditTextChange(this->m_toolBar->getSearchText());
    emit table_changed(index.row());

    //search end

}
void MainWindow::setTask_Num(int num)
{
    QList<DataItem *> data_list=downloading_tableview->get_tableViewModel()->dataList();
    QList<DataItem *> render_list =downloading_tableview->get_tableViewModel()->renderList();

    QList<DelDataItem *> m_recycleList=recycle_tableview->get_tableViewModel()->recyleList();
    int activeCount=0;
    int finishCount=0;
    int recycleCount=0;
    QString active_num;
    if(num==0)
    {
	    int i = 0;
            for (const auto *item : render_list)
            {
                if (item->status == Global::Status::Active||item->status==Global::Status::Paused||item->status==Global::Status::Lastincomplete||item->status==Global::Status::Error||item->status==Global::Waiting)
                {
	            if(!downloading_tableview->isRowHidden(i))
                    {
                         ++activeCount;
                    }

                }
                i++;
            }
            active_num=QString::number(activeCount)+tr(" item tasks");
            if(activeCount==0)
            {
                noTask_Widget->show();
            }
            else {
                noTask_Widget->hide();
            }
    }
    else if(num==1)
    {
	int j = 0;
        for (const auto *item : render_list)
        {
            if (item->status == Global::Status::Complete)
            {
		if(!downloading_tableview->isRowHidden(j))
                {
                   ++finishCount;
                }
            }
	    j++;
        }
        active_num=QString::number(finishCount)+tr(" files");
        if(finishCount==0)
        {
            noTask_Widget->show();

        }
        else {
            noTask_Widget->hide();

        }

    }
    else
    {
	int k = 0;
        for (const auto *item : m_recycleList)
        {
            if(!recycle_tableview->isRowHidden(k))
            {
               ++recycleCount;
            }
	    k++;
        }
        active_num=QString::number(recycleCount)+tr(" files");
        if(recycleCount==0)
        {
            noTask_Widget->show();

        }
        else {
            noTask_Widget->hide();

        }

    }
  Task_Num->setText(active_num);
}
void MainWindow::onNewDownloadBtnClicked()
{
    MessageBox *m_msgBox;
    m_msgBox = new MessageBox(NewDownloding);
    m_msgBox->setWindowFlags(Qt::WindowStaysOnTopHint);
    connect(m_msgBox,&MessageBox::NewDownload_sig,this,&MainWindow::get_NewDowload_slot);
    connect(m_msgBox,&MessageBox::DownloadTorrent_sig,this,&MainWindow::get_TorrentDowload_slot);
    QString  save_path=get_download_savePath_from_config();
    m_msgBox->set_new_download_MsgBox(save_path);
    m_msgBox->exec();
}
void MainWindow::onPauseDownloadBtnClicked()
{
    QList<DataItem *> selectList;
    int selected_count=0;
    if(current_listview_row==0)
    {
        selectList= downloading_tableview->get_tableViewModel()->renderList();
        for(int i = 0; i < selectList.size(); ++i)
        {
            if(selectList.at(i)->Ischecked&&!downloading_tableview->isRowHidden(i))
            {
                ++selected_count;
                if(selectList.at(i)->status!= Global::Status::Paused)
                {
                    aria2c->pause(selectList.at(i)->gid,selectList.at(i)->taskId);
                    QDateTime finish_time=QDateTime::fromString("", "yyyy-MM-dd hh:mm:ss");
                    Tb_Donwload_Task_Status get_status;
                    Tb_Donwload_Task_Status *download_status = new Tb_Donwload_Task_Status(selectList.at(i)->taskId,Global::Status::Paused,QDateTime::currentDateTime(),selectList.at(i)->completedLength,selectList.at(i)->speed,selectList.at(i)->totalLength,selectList.at(i)->percent,selectList.at(i)->total,finish_time);

                    if(get_status.getTbDownloadStatusByTaskId(selectList.at(i)->taskId)!=NULL)
                    {
                        download_status->updateTbDownloadStatusByTaskId(download_status);
                    }
                    else
                    {

                        download_status->addTbDownloadTaskStatus(download_status);

                    }
                }
            }
        }
    }
    if(selected_count==0)
        show_Warning_MsgBox(tr("no item is selected,please check items!"));

}

void MainWindow::onSearchEditFocusChanged(bool focus)
{
}

//search begin
void MainWindow::slot_searchEditTextChange(QString text)
{
        g_search_content = text;
        TableViewModel* dtModel = this->downloading_tableview->get_tableViewModel();
        TableViewModel* rtModel = this->recycle_tableview->get_tableViewModel();
        if(text == "") {
            for(int i = 0;i < dtModel->rowCount(QModelIndex());i++) {
                this->downloading_tableview->setRowHidden(i, false);
                dtModel->setData(dtModel->index(i, 0), false, TableViewModel::Ischecked);
            }
            for(int i = 0;i < rtModel->rowCount(QModelIndex());i++) {
                this->recycle_tableview->setRowHidden(i, false);
                rtModel->setData(dtModel->index(i, 0), false, TableViewModel::Ischecked);
            }
        }
        else {
            for(int i = 0;i < dtModel->rowCount(QModelIndex());i++) {
                this->downloading_tableview->setRowHidden(i, false);
                QString fileName = dtModel->data(dtModel->index(i, 1), TableViewModel::FileName).toString();
                if(!fileName.contains(text, Qt::CaseInsensitive)) {
                    this->downloading_tableview->setRowHidden(i, true);
                }
                dtModel->setData(dtModel->index(i, 0), false, TableViewModel::Ischecked);
            }

            for(int i = 0;i < rtModel->rowCount(QModelIndex());i++) {
                this->recycle_tableview->setRowHidden(i, false);
                QString fileName = rtModel->data(rtModel->index(i, 1), TableViewModel::FileName).toString();
                if(!fileName.contains(text, Qt::CaseInsensitive)) {
                    this->recycle_tableview->setRowHidden(i, true);
                }
                rtModel->setData(dtModel->index(i, 0), false, TableViewModel::Ischecked);
            }
       }
       this->downloading_tableview->reset();
       this->recycle_tableview->reset();
       setTask_Num(current_listview_row);
}

//search end

void MainWindow::onStartDownloadBtnClicked()
{
    QList<DataItem *> selectList;
    int selected_count=0;
    if(current_listview_row==0)
    {
        selectList= downloading_tableview->get_tableViewModel()->renderList();
        for(int i = 0; i < selectList.size(); ++i)
        {
            if(selectList.at(i)->Ischecked&&!downloading_tableview->isRowHidden(i))
            {
                ++selected_count;
                if(selectList.at(i)->status!= Global::Status::Active)
                {
                    if(selectList.at(i)->status==Global::Status::Lastincomplete)
                    {
                        //QString  save_path=selectList.at(i)->savePath;
                        QString file_path = selectList.at(i)->savePath;
                        QString file_name = selectList.at(i)->fileName;
                        QString default_savePath = get_download_savePath_from_config() ;
                        QString save_path ;
                        if(default_savePath != selectList.at(i)->savePath)
                        {
                            int name_length = file_name.size();
                            int file_path_length = file_path.size();
                            int folder_path_length = file_path_length-name_length-1;
                            save_path = file_path.left(folder_path_length);
                        }
                        else {
                            save_path = default_savePath;
                        }

                        QMap<QString, QVariant> opt;
                        opt.insert("dir", save_path);


                        Tb_Url_Info *url_info= new Tb_Url_Info;
                        Tb_Url_Info *get_url_info;
                        get_url_info= url_info->getTbUrlInfoByTaskId(selectList.at(i)->taskId);
                        if(get_url_info!=nullptr)
                        {
                            if(get_url_info->download_type=="torrent")
                            {
                                QString select_num=get_url_info->selectedNum;
                                QMap<QString,QVariant> opt;
                                opt.insert("dir",save_path);
                                opt.insert("select-file",select_num);
                                if(!QFile(get_url_info->seedFile).exists())
                                {
                                    show_Warning_MsgBox(tr("seed file not exists or broken;"));
                                }
                                else {
                                    aria2c->addTorrent(get_url_info->seedFile,opt,get_url_info->task_id);
                                    if (updatetimer->isActive() == false)
                                    {
                                        updatetimer->start(2*1000);
                                    }

                                }


                            }
                        }
                        else
                        {
                            deal_download_upload_limit_period();
                            aria2c->addUri(selectList.at(i)->url,opt, selectList.at(i)->taskId);
                            if (updatetimer->isActive() == false)
                            {
                                updatetimer->start(2*1000);
                            }

                        }

                    }
                    else
                    {
                    aria2c->unpause(selectList.at(i)->gid,selectList.at(i)->taskId);

                    }

                }
            }
        }
    }
    if(selected_count==0)
    {
        show_Warning_MsgBox(tr("no item is selected,please check items!"));
    }


}
void MainWindow::onDeleteDownloadBtnClicked()
{

    del_downloading_Action();

}
void MainWindow::initaria2()
{
    QString m_aria2configPath = QString("%1/%2/%3/aria2.conf")
        .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
        .arg(qApp->organizationName())
        .arg(qApp->applicationName());

    QFileInfo fileInfo(m_aria2configPath);
    if(!fileInfo.exists())
    {
        QFile::copy(AIRA_CONFIG_PATH,m_aria2configPath);
    }
    aria2c = new Aria2cInterface(this);
    connect(aria2c, SIGNAL(signal_success(QString, QJsonObject)), this, SLOT(slot_rpc_success(QString, QJsonObject)));
    connect(aria2c, SIGNAL(signal_error(QString, QString, int)), this, SLOT(slot_rpc_error(QString, QString, int)));

    aria2c->setConfigPath(m_aria2configPath);
    bool rs = aria2c->startup();
    qDebug()<<"Startup aria:"<<QString::number(rs);

}
void MainWindow::Update_MainUi()
{
    qDebug()<<"__________________________";
    const QList<DataItem *> renderList = downloading_tableview->get_tableViewModel()->renderList();
    const QList<DataItem *> dataList =downloading_tableview->get_tableViewModel()->dataList();
    int activeCount = 0;
    for (const auto *item : dataList)
    {
        if(item->status==Global::Status::Active || item->status==Global::Status::Waiting )
        {
            aria2c->tellStatus(item->gid,item->taskId);
        }
    }

    for (const auto *item : dataList)
    {
        if (item->status == Global::Status::Active||item->status == Global::Status::Waiting||item->status==Global::Status::Paused||item->status==Global::Status::Lastincomplete||item->status==Global::Status::Error) {
            ++activeCount;
        }
    }
  /*  if(this->g_search_content != "")
    {
        slot_searchEditTextChange(this->g_search_content);
    }*/
    if (activeCount == 0) {

        if (updatetimer->isActive() )
        {
             updatetimer->stop();
        }

    }
    setTask_Num(current_listview_row);

}
void MainWindow::get_NewDowload_slot(QString url,QString savepath)
{
    QMap<QString, QVariant> opt;
    opt.insert("dir", savepath);
    QStringList url_list=url.split("\n");
    int sameUrl=0;
    QList<QString> repeat_url_list;
    QStringList add_url_list;
    for(int j=0;j<url_list.size();j++)
    {
        if(add_url_list.size()==0)
            add_url_list.append(url_list.at(j));
        else
        {
            bool found_same=false;
            for(int k=0;k<add_url_list.size();k++)
            {
                QString url_decode;
                QString add_url_decode;
                if(!url_list.at(j).contains(QRegExp("[\\x4e00-\\x9fa5]+")))
                {
                    const QByteArray byte_download=url_list.at(j).toLatin1();
                    url_decode=QUrl::fromPercentEncoding(byte_download);
                }
                else {
                    url_decode=url_list.at(j);
                }
                if(!add_url_list.at(k).contains(QRegExp("[\\x4e00-\\x9fa5]+")))
                {
                    const QByteArray byte_download=add_url_list.at(k).toLatin1();
                    add_url_decode=QUrl::fromPercentEncoding(byte_download);
                }
                else
                {
                    add_url_decode=add_url_list.at(k);
                }
                if(add_url_decode==url_decode)
                {
                    found_same=true;
                    continue;
                }

            }
            if(!found_same)
                add_url_list.append(url_list.at(j));
        }
    }
    if(add_url_list.size()>0)
    {
        for(int i=0;i<add_url_list.size();i++)
        {
            int sameUrl_count=0;
            QUuid id = QUuid::createUuid();
            QString strId = id.toString();
            QString download_url=add_url_list.at(i);
            Tb_Task tb_task;
            QList <DataItem *> data_list=downloading_tableview->get_tableViewModel()->dataList();
            QList<DelDataItem *> recycle_list=recycle_tableview->get_tableViewModel()->recyleList();
            QString download_url_decode;
            if(!download_url.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
            {
                const QByteArray byte_download=download_url.toLatin1();
                download_url_decode=QUrl::fromPercentEncoding(byte_download);
            }
            else {
                download_url_decode = download_url;
            }
            for(int i=0;i<data_list.size();i++)
            {
                DataItem *data=data_list.at(i);

                QString url_decode;
                if(!data->url.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
                {
                    const QByteArray byte=data->url.toLatin1();
                    url_decode=QUrl::fromPercentEncoding(byte);
                }
                else {
                    url_decode = data->url;
                }

		if(!download_url.isEmpty())
	        {

                    if(url_decode==download_url_decode ||  download_url == url_decode)
                    {
                        repeat_url_list.append(download_url);
                        ++sameUrl_count;
                        sameUrl=sameUrl+sameUrl_count;

                    }
		}
            }
            if(sameUrl==0)
            {
                for(int i=0;i<recycle_list.size();i++)
                {
                    DelDataItem *data=recycle_list.at(i);
                    QString url_decode;
                    if(!data->url.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
                    {
                        const QByteArray byte=data->url.toLatin1();
                        url_decode=QUrl::fromPercentEncoding(byte);
                    }
                    else {
                        url_decode = data->url;
                    }
                    if(url_decode==download_url_decode ||  download_url == url_decode)
                    {
                        ++sameUrl_count;
                        repeat_url_list.append(download_url);
                        sameUrl=sameUrl+sameUrl_count;
                    }
                }
            }

            if(sameUrl_count==0)
            {
               deal_download_upload_limit_period();
               Tb_Task task;
               QString filename;
               if(download_url.startsWith("magnet"))
               {
                   //filename
                   if(download_url.contains("&"))
                   {
                       filename=download_url.split("&")[0];
                       if(filename.contains("btih:"))
                       {
                           filename=filename.split("btih:")[1]+".torrent";
                       }
                   }
                   else
                   {
                       filename=download_url.right(40);
                   }
               }
               else {
                   filename=QString(download_url).right(download_url.length() - download_url.lastIndexOf('/') - 1);
               }

               if(!filename.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
               {
               const QByteArray filename_byte=filename.toLatin1();
               QString filename_decode=QUrl::fromPercentEncoding(filename_byte);
               if(filename_decode.contains("?"))
               {
                   filename_decode=filename_decode.split("?")[0];
               }
               filename=filename_decode;
                }
                Tb_Task *add_task=new Tb_Task(strId,"",0,download_url,savepath+"/"+filename,filename,QDateTime::currentDateTime());
                task.addTbTask(add_task);
//                DataItem *data=new DataItem;
//                data->taskId=strId;
//                data->gid="";
//                data->url=download_url;
//                data->savePath=savepath+"/"+filename;
//                data->fileName=filename;
//                data->Ischecked=0;
//                data->createTime=QDateTime::currentDateTime().toString();
//                downloading_tableview->get_tableViewModel()->append(data);
                aria2c->addUri(download_url,opt,strId);
                noTask_Widget->hide();
                if (updatetimer->isActive() == false)
                {
                    updatetimer->start(2 * 1000);
                }

            }

        }
        if(sameUrl>0)
        {
            QString warning_msg=tr("has ")+QString::number(sameUrl)+tr(" the same download");
            show_Warning_MsgBox(warning_msg,sameUrl,repeat_url_list);
        }
    }

}
void MainWindow::get_ReName_confirm_slot(QString newname)
{
    QList<DataItem *> render_list=downloading_tableview->get_tableViewModel()->renderList();
    QString old_file_path;
    QString new_file_path;
    QString oldname;
   for(int i=0;i<rename_list.size();++i)
   {
        DataItem *data=downloading_tableview->get_tableViewModel()->find(rename_list.at(i)->taskId);
        old_file_path=data->savePath;
        oldname=data->fileName;
        int name_length=oldname.size();
        int file_path_length=old_file_path.size();
         QString default_savePath = get_download_savePath_from_config() ;
         QString file_folder_path ;
         if(default_savePath != old_file_path)
         {
             int folder_path_length=file_path_length-name_length;
             file_folder_path=old_file_path.left(folder_path_length);

         }
         else
         {
             file_folder_path = default_savePath;
         }

        QString new_file_path=file_folder_path+"/"+newname;
        QFile::rename(old_file_path,new_file_path);
        data->fileName=newname;
        data->savePath=new_file_path;
        downloading_tableview->update();
   }


}

void MainWindow::Deal_Notificaiton_Settings(QString statusStr , QString fileName)
{
    //获取免打扰模式值
    QVariant undisturbed_mode_switchbutton = m_settings->settings->getOption("basic.select_multiple.undisturbed_mode_switchbutton");
    if(undisturbed_mode_switchbutton.toBool())
    {
        bool topStatus = this->isTopLevel();
        bool maxStatus = this->isMaximized();
        if(topStatus && maxStatus)
        {
            return ;
        }
    }

    QVariant afterDownloadPlayTone = m_settings->settings->getOption("noticeReminder.remind.afterDownloadPlayTone");
    if(afterDownloadPlayTone.toBool())
    {
        QSound::play(":/resources/wav/downloadfinish.wav");
    }
    else {
        qDebug() << " not in select down load finsh wav" << endl;
    }

    QVariant downloadInfoNotify = m_settings->settings->getOption("noticeReminder.remind.downloadInfoNotify");
    if(downloadInfoNotify.toBool())
    {
        QProcess *p = new QProcess;
	QString showInfo ;
        if(statusStr == "error")
        {
            showInfo = fileName + tr(" download error");
        }
        else {
            showInfo = fileName + tr(" download complete");
        }
        p->start("notify-send", QStringList() << showInfo);
        p->waitForStarted();
        p->waitForFinished();
    }
}
void MainWindow::slot_rpc_error(QString method, QString id, int error)
{
    qDebug()<<"slot rpc error method is:"<<method<<error;
    //save_data_before_close();
    if(error == 400) {
        if(method == ARIA2C_METHOD_FORCE_REMOVE && id.startsWith("REDOWNLOAD_")) {
            //当重新下载400移除失败时直接重新下载
            QStringList sp = id.split("_");
            QString taskId = sp.at(2);
            int rd = sp.at(1).toInt();
            emit signal_redownload(taskId, rd);
        }
    }
}
void MainWindow::slot_rpc_success(QString method, QJsonObject json)
{
    if(method == ARIA2C_METHOD_ADD_URI
            || method == ARIA2C_METHOD_ADD_TORRENT
            || method == ARIA2C_METHOD_ADD_METALINK)
    {
        QString id=json.value("id").toString();
        QString gId = json.value("result").toString();

        DataItem*  finddata=downloading_tableview->get_tableViewModel()->find(id);
        if(finddata!=nullptr)
        {
            finddata->gid=gId;
            finddata->taskId=id;
            QDateTime finish_time=QDateTime::fromString("", "yyyy-MM-dd hh:mm:ss");
            Tb_Donwload_Task_Status get_status;
            Tb_Donwload_Task_Status *download_status = new Tb_Donwload_Task_Status(finddata->taskId,Global::Status::Active,QDateTime::currentDateTime(),finddata->completedLength,finddata->speed,finddata->totalLength,finddata->percent,finddata->total,finish_time);

            if(get_status.getTbDownloadStatusByTaskId(finddata->taskId)!=NULL)
            {
                download_status->updateTbDownloadStatusByTaskId(download_status);
            }
            else
            {
                download_status->addTbDownloadTaskStatus(download_status);
            }
            finddata->status=Global::Status::Active;
        }
        else
        {
            //获取下载信息
            //aria2c->tellStatus(gId, gId);
            aria2c->getFiles(gId, id);
            DataItem *data = new DataItem;
            data->taskId=id;
            data->gid = gId;
            data->Ischecked=0;
            QDateTime time=QDateTime::currentDateTime();
            data->createTime=time.toString("yyyy-MM-dd hh:mm:ss");

            Tb_Task *get_task_info;
            Tb_Task task_info;
            get_task_info=task_info.getTbTaskByTaskId(id);
            Tb_Task *task ;
            if(get_task_info!=NULL)
            {

                task= new Tb_Task(get_task_info->task_id,gId,0,get_task_info->url,get_task_info->download_path,get_task_info->download_filename,time);
                task_info.updateTbTaskByTaskId(task);
                data->fileName=get_task_info->download_filename;

            }
            else
            {
                task= new Tb_Task(id, gId, 0, "", "","Unknow", time);
                task_info.addTbTask(task);
            }
            downloading_tableview->get_tableViewModel()->append(data);
            if(this->g_search_content!="" && !data->fileName.contains(this->g_search_content))
            {
                TableViewModel* dtModel = this->downloading_tableview->get_tableViewModel();
                downloading_tableview->setRowHidden(dtModel->rowCount(QModelIndex()),true);


            }
          }
    refreshTableView(current_listview_row);
    }
    else if(method == ARIA2C_METHOD_TELL_STATUS)
    {
        QJsonObject result = json.value("result").toObject();
        QJsonObject bittorrent=result.value("bittorrent").toObject();
        QString mode;
        QString bittorrent_name;
        QString taskId=json.value("id").toString();
        QString bittorrent_dir="";

        if(!bittorrent.isEmpty())
        {
            mode= bittorrent.value("mode").toString();
            if(mode=="multi")
            {
                bittorrent_dir=result.value("dir").toString();
            }
            QJsonObject btInfo=bittorrent.value("info").toObject();
            bittorrent_name = btInfo.value("name").toString();
            QString infoHash=result.value("infoHash").toString();
            Tb_Url_Info tb_url_info;
            Tb_Url_Info *get_url_info;
            get_url_info=tb_url_info.getTbUrlInfoByTaskId(taskId);
            if(get_url_info!=nullptr)
            {
                if(get_url_info->infoHash.isEmpty())
                {
                    Tb_Url_Info *url_info=new Tb_Url_Info(get_url_info->task_id,get_url_info->url,get_url_info->download_type,get_url_info->seedFile,get_url_info->selectedNum,infoHash);
                    url_info->updateUrlInfoByTaskId(url_info);
                }
            }
        }
        QJsonArray files = result.value("files").toArray();

        QString filePath;
        QString fileUri;
        for (int i = 0; i < files.size(); ++i)
        {
            QJsonObject file = files[i].toObject();
            filePath = file.value("path").toString();
            QJsonArray uri =file.value("uris").toArray();
            for(int j=0;j<uri.size();++j)
            {
                QJsonObject uriObject = uri[j].toObject();
                fileUri = uriObject.value("uri").toString();
            }

        }

        QString gId = result.value("gid").toString();

        long totalLength = result.value("totalLength").toString().toLong();//字节
        long completedLength = result.value("completedLength").toString().toLong();//字节
        long downloadSpeed = result.value("downloadSpeed").toString().toLong();//字节/每秒
        QString fileName = this->getFileName(filePath);
        QString statusStr = result.value("status").toString();

        /*if(statusStr == "complete" && result.contains("followedBy"))
        {
            QString followedGId = result.value("followedBy").toArray().at(0).toString();
            DataItem *data = downloading_tableview->get_tableViewModel()->find(gId);

            if(data!=nullptr)
            {

                data->gid= followedGId;
                aria2c->getFiles(followedGId, followedGId);
            }
        }*/

            int percent = 0;
            int status = 0;

	    if (completedLength != 0 && totalLength !=0)
            {
                double temp_percent = completedLength * 100.0 / totalLength;
                percent = temp_percent;
                if(percent < 0 || percent > 100)
                {
                    percent =0;
                }
                if(completedLength==totalLength)
                {
                    statusStr="complete";
                }
            }

            if (statusStr == "active")
            {
                status = Global::Status::Active;
            }
            else if (statusStr == "waiting")
            {
                status = Global::Status::Waiting;
            }
            else if (statusStr == "paused")
            {
                status = Global::Status::Paused;
            }
            else if (statusStr == "error")
            {
                status = Global::Status::Error;
                Deal_Notificaiton_Settings(statusStr,fileName);
            }
            else if (statusStr == "complete")
            {
                status = Global::Status::Complete;
                //下载文件为种子文件
                if(fileName.endsWith(".torrent")) {
                    emit signal_auto_download_bt(filePath);
                }
                //下载文件为磁链种子文件
                QString infoHash = result.value("infoHash").toString();
                if(filePath.startsWith("[METADATA]")) {
                    QString dir = result.value("dir").toString();
                  
                    emit signal_auto_download_bt(dir +"/"+ infoHash + ".torrent");
                    fileName = infoHash+".torrent";
                }
                //
                Deal_Notificaiton_Settings(statusStr,fileName);
            }
            else if (statusStr == "removed")
            {
                status = Global::Status::Removed;
            }

            DataItem *data = downloading_tableview->get_tableViewModel()->find(taskId);
            if (data == nullptr)
            {
                return;
            }
            data->gid=gId;
            data->totalLength = this->formatFileSize(totalLength);
            data->completedLength = this->formatFileSize(completedLength);
            data->speed = (downloadSpeed != 0) ? this->formatDownloadSpeed(downloadSpeed):"0kb/s";

            if(bittorrent.isEmpty())
            {
                if(!fileName.isEmpty()&&data->fileName!=fileName)
                {
                    data->fileName=fileName;
                }
//                if(data->fileName==QObject::tr("Unknown"))
//                {
//                    data->fileName = (fileName.isEmpty()) ? Global::UNKNOWN : fileName;
//                }
                data->status = status;
            }
            else
            {
               // data->fileName = (bittorrent_name.isEmpty()) ? Global::UNKNOWN : bittorrent_name;
                if(mode=="multi")
                {
                    filePath=bittorrent_dir+"/"+bittorrent_name;
                }
                if(totalLength != 0 && totalLength == completedLength)
                {
                    data->status=Complete;
                    Deal_Notificaiton_Settings("complete",filePath);
                }
                else
                {
                    data->status = status;
                }

            fileUri="";
            }
            data->percent = percent;
            data->total = totalLength;
             if(filePath != "")
            {
                data->savePath=filePath;
            }
            else {
                data->savePath = get_download_savePath_from_config();
            }

            data->url=fileUri;
            data->time="";

            if (totalLength != completedLength && totalLength != 0 &&
                data->status == Global::Status::Active)
            {
                QTime t(0, 0, 0);
                t = t.addSecs((totalLength - completedLength * 1.0) / downloadSpeed);
                data->time = t.toString("mm:ss");
            }
            else if(totalLength == 0 && data->status == Global::Status::Active)
            {
                data->time=("--:--");
            }
            else
            {
                if(data->time=="")
                    data->time = QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss");
//              updatetimer->stop();
            }
            Tb_Task task;
            Tb_Task *get_task;
            get_task=task.getTbTaskByTaskId(data->taskId);
            if(get_task!=NULL)
            {
                if(get_task->url!="")
                    data->url=get_task->url;
            }

            downloading_tableview->update();
            downloading_tableview->reset();
            Tb_Donwload_Task_Status task_status;
            Tb_Donwload_Task_Status *get_task_status=NULL;
            get_task_status= task_status.getTbDownloadStatusByTaskId(data->taskId);

            QDateTime get_time=QDateTime::fromString(data->time,"yyyy-MM-dd hh:mm:ss");
            Tb_Donwload_Task_Status *save_task_status= new Tb_Donwload_Task_Status(data->taskId,data->status,get_time,data->completedLength,data->speed,data->totalLength,data->percent,data->total,get_time);
            if(get_task_status==NULL)
            {
                task_status.addTbDownloadTaskStatus(save_task_status);
            }
            else
            {
                if(get_task_status->download_status!=data->status)
                {
                      task_status.updateTbDownloadStatusByTaskId(save_task_status);
                }

            }
            refreshTableView(current_listview_row);
            if(data->status ==Complete && this->g_search_content!="")
            {
                slot_searchEditTextChange(this->g_search_content);
            }

    }
    else if(method == ARIA2C_METHOD_SHUTDOWN)
    {
        QString result = json.value("result").toString();
        if(result == "OK")
        {
            shutdownOk = true;
            qDebug()<<"close downloadmanager";
            this->close();
            DApplication::exit();

        }
    }
    else if(method == ARIA2C_METHOD_GET_FILES)
    {
        QString id = json.value("id").toString();
        DataItem *data = downloading_tableview->get_tableViewModel()->find(id);
        if(data==nullptr)
       {//id等于gid
            data=new DataItem();
            QJsonArray ja = json.value("result").toArray();
            QJsonObject jo = ja.at(0).toObject();
            data->totalLength = jo.value("length").toString().toLong();//文件大小
            data->savePath = jo.value("path").toString();//下载路径，带文件名
            data->fileName = data->savePath.mid(data->savePath.lastIndexOf('/') + 1);
            QJsonArray uris = jo.value("uris").toArray();
            data->url = uris.at(0).toObject().value("uri").toString();//下载链接
            data->taskId=id;
            downloading_tableview->get_tableViewModel()->append(data);
        }
        downloading_tableview->reset();
        refreshTableView(current_listview_row);
        //aria2c->tellStatus(id);
    }
    else if(method == ARIA2C_METHOD_UNPAUSE)
    {
        QString gId = json.value("result").toString();
        QString taskId= json.value("id").toString();

        DataItem *data = downloading_tableview->get_tableViewModel()->find(taskId);
        if(data!=nullptr)
        {
            data->status=Global::Status::Active;
            refreshTableView(current_listview_row);
        }

    }
    /*else if(method == ARIA2C_METHOD_REMOVE) {
        QString id = json.value("id").toString();
        if(id.startsWith("REDOWNLOAD_")) {
            QString gid = json.value("result").toString();
            //QThread::sleep(1);
            aria2c->removeDownloadResult(gid, id);
        }
    }
    else if(method == ARIA2C_METHOD_REMOVE_DOWNLOAD_RESULT) {//ARIA2C_METHOD_PURGE_DOWNLOAD_RESULT
        QString id = json.value("id").toString();
        if(id.startsWith("REDOWNLOAD_")) {//重新下载前的移除完成后
            QStringList sp = id.split("_");
            QString taskId = sp.at(2);
            int rd = sp.at(1).toInt();
            emit signal_redownload(taskId, rd);
        }
    }*/
    else if(method == ARIA2C_METHOD_FORCE_REMOVE) {
        QString id = json.value("id").toString();
        if(id.startsWith("REDOWNLOAD_")) {//重新下载前的移除完成后
            QStringList sp = id.split("_");
            QString taskId = sp.at(2);
            int rd = sp.at(1).toInt();
            QThread::msleep(500);
            emit signal_redownload(taskId, rd);
        }
    }
}
QString MainWindow::getFileName(const QString &url)
{
    return QString(url).right(url.length() - url.lastIndexOf('/') - 1);
}

QString MainWindow::formatFileSize(long size)
{
    QString result = "";

    if (size < 1024) {
        result = QString::number(size) + "B";
    } else if (size / 1024 < 1024) {
        result = QString::number(size * 1.0 / 1024, 'r', 1) + "KB";
    } else if (size / 1024 / 1024 < 1024) {
        result = QString::number(size * 1.0 / 1024 / 1024, 'r', 1) + "MB";
    } else if (size / 1024 / 1024 / 1024 < 1024) {
        result = QString::number(size * 1.0 / 1024 / 1024 / 1024, 'r', 1) + "GB";
    }

    return result;
}
QString MainWindow::formatDownloadSpeed( long size)
{
    QString result = "";

    if (size < 1024) {
        result = QString::number(size) + " B/s";
    } else if (size / 1024 < 1024) {
        result = QString::number(size * 1.0 / 1024, 'r', 1) + " KB/s";
    } else if (size / 1024 / 1024 < 1024) {
        result = QString::number(size * 1.0 / 1024 / 1024, 'r', 1) + " MB/s";
    } else if (size / 1024 / 1024 / 1024 < 1024) {
        result = QString::number(size * 1.0 / 1024 / 1024 / 1024, 'r', 1) + " GB/s";
    }

    return result;
}

void MainWindow::refreshTableView(const int &index, bool isClearSelection)
{
    switch (index) {
    case 0: {
        downloading_tableview->get_tableViewModel()->switchDownloadingMode();
        downloading_tableview->setColumnHidden(3,false);
        downloading_tableview->setColumnHidden(4,true);
        //联动工具栏按钮 begin
        int chkedCnt = 0;
        if(current_listview_row == 0) {
            QList<DataItem*> selectList = downloading_tableview->get_tableViewModel()->renderList();
            for(int i = 0; i < selectList.size(); i++) {
                if(selectList.at(i)->Ischecked) {
                    chkedCnt++;
                }
            }
            if(chkedCnt > 0) {
                this->m_toolBar->enableStartBtn(true);
                this->m_toolBar->enablePauseBtn(true);
                this->m_toolBar->enableDeleteBtn(true);
            }
            else {
                this->m_toolBar->enableStartBtn(false);
                this->m_toolBar->enablePauseBtn(false);
                this->m_toolBar->enableDeleteBtn(false);
            }
        }
        //end
        break;
    }
    case 1:
       downloading_tableview->get_tableViewModel()->switchFinishedMode();

       downloading_tableview->setColumnHidden(3,true);
       downloading_tableview->setColumnHidden(4,false);
        break;
   }


    downloading_tableview->update();
}

void MainWindow::addDeleteItem_toRecycle(DelDataItem *data)
{
    recycle_tableview->get_tableViewModel()->append(data);
    recycle_tableview->update();

}
void MainWindow::show_Warning_MsgBox(QString title,int sameurl_count,QList<QString> same_url_list)
{
    MessageBox *msg=new MessageBox(Warnings);
    msg->set_warning_MsgBox(title,tr("sure"),"",sameurl_count,same_url_list);
    msg->exec();
}

void MainWindow::show_repeat_download_task()
{
    MessageBox *msg=new MessageBox(RepeatDownload);
    connect(msg,&MessageBox::RepeatDownload_sig,this,&MainWindow::get_Repeatdowload_confirm_slot);
    QString title=tr("repeat download,the task already in list");
    msg->set_warning_MsgBox(title,tr("redownload"),tr("cancel"));
    msg->exec();
}
void MainWindow::show_reload_MsgBox()
{
    MessageBox *msg=new MessageBox(ReDownload);
    //connect(msg,&MessageBox::ReDownload_sig,this,&MainWindow::get_Redowload_confirm_slot);
    QString title=tr("reload will delete this local file,Do you continue?");
    msg->set_warning_MsgBox(title,tr("sure"),tr("cancel"));
    int rs = msg->exec();
    if(rs == DDialog::Accepted) {
        //ToolBar禁用按钮联动：确认后禁用按钮
        this->m_toolBar->enableStartBtn(false);
        this->m_toolBar->enablePauseBtn(false);
        this->m_toolBar->enableDeleteBtn(false);

        //重新下载：通知aria2移除下载项
        connect(this, SIGNAL(signal_redownload(QString, int)), this, SLOT(slot_redownload(QString, int)), Qt::QueuedConnection);
        if(current_listview_row == 0 || current_listview_row == 1) {
            for(int i = 0;i < reload_list.size();i++) {
                DataItem *data = reload_list.at(i);
                aria2c->forceRemove(data->gid, "REDOWNLOAD_" + QString::number(current_listview_row) + "_" + data->taskId);
            }
        }
        else {
            for(int i=0;i<recycle_reload_list.size();i++) {
                DelDataItem *data = recycle_reload_list.at(i);
                aria2c->forceRemove(data->gid, "REDOWNLOAD_" + QString::number(current_listview_row) + "_" + data->taskId);
            }
        }
    }
}

void MainWindow::onSettingsMenuClicked()
{
    DSettingsDialog *settings_dialog = new DSettingsDialog(this);
    settings_dialog->widgetFactory()->registerWidget("filechooseredit", Settings::createFileChooserEditHandle);
    settings_dialog->widgetFactory()->registerWidget("describeMaxDownloadNumInputBox", Settings::createDescribeMaxDownloadNumInputBoxHandle);
    settings_dialog->widgetFactory()->registerWidget("describeInputBox", Settings::createDescribeInputBoxHandle);
    settings_dialog->widgetFactory()->registerWidget("describeUploadInputBox", Settings::createdescribeUploadInputBoxHandle);
    settings_dialog->widgetFactory()->registerWidget("timeSectionControlBox", Settings::createTimeSectionControlBoxHandle);
    settings_dialog->widgetFactory()->registerWidget("settingslabel", Settings::createSettingsLabelHandle);

    settings_dialog->updateSettings(m_settings->settings);
    settings_dialog->exec();
    delete settings_dialog;
    m_settings->settings->sync();
}
void MainWindow::show_rename_MsgBox()
{
     MessageBox *msg = new MessageBox(ReName);
     connect(msg,&MessageBox::ReName_sig,this,&MainWindow::get_ReName_confirm_slot);
     QString title=tr("Rename");
     for(int i=0;i<rename_list.size();++i)
     {
        DataItem *data= rename_list.at(i);
        msg->set_rename_MsgBox(title,tr("sure"),tr("cancel"),data->fileName);

     }
     msg->exec();

}
void MainWindow::show_delete_MsgBox(bool permanently)
{
    MessageBox *msg = new MessageBox(Delete);
    connect(msg,&MessageBox::DeleteDownload_sig,this,&MainWindow::get_delete_confirm_slot);
    msg->set_delete_Task_MsgBox(permanently);
    int rs = msg->exec();
    if(rs == DDialog::Accepted) {
        //ToolBar禁用按钮联动：确认后禁用按钮
        this->m_toolBar->enableStartBtn(false);
        this->m_toolBar->enablePauseBtn(false);
        this->m_toolBar->enableDeleteBtn(false);
    }
}

void MainWindow::show_clear_MsgBox()
{
    MessageBox *msg = new MessageBox(Clear);
    connect(msg,&MessageBox::ClearRecycle_sig,this,&MainWindow::get_clear_Recycle_slot);
    msg->set_clear_Task_MsgBox();
    int rs = msg->exec();
    if(rs == DDialog::Accepted) {
        //ToolBar禁用按钮联动：确认后禁用按钮
        this->m_toolBar->enableStartBtn(false);
        this->m_toolBar->enablePauseBtn(false);
        this->m_toolBar->enableDeleteBtn(false);
    }
}

void MainWindow::dragEnterEvent(QDragEnterEvent *event)
{
     if(event->mimeData()->hasUrls()) //数据中是否包含URL
     {
         event->acceptProposedAction(); //如果是则接受动作
     }
     else
         event->ignore();

}
void MainWindow::dropEvent(QDropEvent *event)
{
   const QMimeData *mineData=event->mimeData();//获取MIME数据
   if(mineData->hasUrls())                     //如数据中包含URL
   {
       QList<QUrl>urlList=mineData->urls();    //获取URL列表
       if(urlList.isEmpty())return ;
       QString fileName;
      //将其中第一个URL表示为本地文件路径
      for(int i=0;i<urlList.size();++i)
      {
       fileName=urlList.at(i).toString();

      

       if(fileName.isEmpty())return;

       if(!fileName.isEmpty())                 //若文件路径不为空
      {
           if(fileName.startsWith("file:")&&fileName.endsWith(".torrent"))
           {
               fileName=fileName.right(fileName.length()-6);
               QString save_path=get_download_savePath_from_config();
               BtInfoDialog *dialog = new BtInfoDialog(fileName,save_path);//torrent文件路径
               int ret = dialog->exec();
               if(ret == QDialog::Accepted) {
                   QMap<QString,QVariant> opt;
                   opt.insert("dir",dialog->getSaveto());
                   opt.insert("select-file",dialog->getSelected());
                   QString infoHash=dialog->getBtInfo().infoHash;
                   get_TorrentDowload_slot(fileName,opt,dialog->getName(),infoHash);
                   //this->close();

               }
               delete dialog;

           }
           else
           {
               MessageBox *m_msgBox;
               m_msgBox = new MessageBox(NewDownloding);
               m_msgBox->setWindowFlags(Qt::WindowStaysOnTopHint);
               connect(m_msgBox,&MessageBox::NewDownload_sig,this,&MainWindow::get_NewDowload_slot);
               QString  save_path=get_download_savePath_from_config();
               m_msgBox->set_new_download_MsgBox(save_path,fileName);
               m_msgBox->exec();

           }
         }
       }
   }
}
void MainWindow::get_TorrentDowload_slot(QString filename,QMap<QString, QVariant> opt,QString infoName, QString infoHash)
{
    QUuid id = QUuid::createUuid();
    QString strId = id.toString();
    QString selectedNum=opt.value("select-file").toString();
    if(selectedNum.isEmpty())
    {
        show_Warning_MsgBox(tr("no selection in seed"));
    }
    else
    {
        if(Is_duplicate_seed_file(infoHash,selectedNum))
        {
            show_Warning_MsgBox(tr("has the same download!"));
        }
        else
        {
            aria2c->addTorrent(filename,opt,strId);
            if (updatetimer->isActive() == false)
            {
                 updatetimer->start(2*1000);
            }


            Tb_Task task;
            Tb_Task *add_task= new Tb_Task(strId,"",0,"","",infoName,QDateTime::currentDateTime());
            task.addTbTask(add_task);
            Tb_Url_Info *url_info= new Tb_Url_Info(strId,"" ,"torrent",filename,selectedNum,"");
            url_info->addUrlInfo(url_info);

        }

    }

}
void MainWindow::closeEvent(QCloseEvent *evt)
{
    evt->ignore();
    this->hide();

    if(!shutdownOk)
    {
        save_data_before_close();
        aria2c->shutdown();

    }

}
void MainWindow::resizeEvent(QResizeEvent *event)
{
    downloading_tableview->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    downloading_tableview->horizontalHeader()->setSectionResizeMode(0,QHeaderView::Fixed);
    recycle_tableview->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    recycle_tableview->horizontalHeader()->setSectionResizeMode(0,QHeaderView::Fixed);

}

void MainWindow::get_Repeatdowload_confirm_slot()
{

}


QString   MainWindow::get_download_savePath_from_config()
{
    QVariant downloadRadioGroup = m_settings->settings->getOption("basic.downloadDirectory.downloadDirectoryFileChooser");

    QString path="";

    QString current_value = downloadRadioGroup.toString();
    //无设置信息
    if(current_value.isEmpty())
    {
        path  = QStandardPaths::writableLocation(QStandardPaths::HomeLocation) + QString("/Downloads");
    }
    else {
        //用户设置默认目录
        if(current_value.contains("custom;"))
        {
            path = current_value.section(QString(';'),1,1);
            if(path.isEmpty())
            {
                path =  QStandardPaths::writableLocation(QStandardPaths::HomeLocation) + QString("/Downloads");
            }
        }
       //自动修改为上次使用目录
        else {
            QString config_path=QString("%1/%2/%3/last_save_path")
                    .arg(QStandardPaths::writableLocation(QStandardPaths::ConfigLocation))
                    .arg(qApp->organizationName())
                    .arg(qApp->applicationName());
            QFile file;
            file.setFileName(config_path);
            if(file.exists())
            {
                bool isOK = file.open(QIODevice::ReadOnly);
               if(isOK == true)
               {
                   QByteArray array = file.readAll();

                   path=array;
               }
               else
               {
                   path=QStandardPaths::writableLocation(QStandardPaths::HomeLocation) + QString("/Downloads");
               }
               file.close();
            }
            else
            {
                path  = QStandardPaths::writableLocation(QStandardPaths::HomeLocation) + QString("/Downloads");
            }
        }
    }
    return path;

}

void MainWindow::get_header_stateChanged(bool i)
{
    //ToolBar禁用按钮联动：表头全选复选框状体变化 begin
    int cnt = (current_listview_row == 2 ? recycle_tableview->get_tableViewModel()->rowCount(QModelIndex())
                                         : downloading_tableview->get_tableViewModel()->rowCount(QModelIndex()));
    if(cnt > 0) {
        if(current_listview_row == 0) {
            this->m_toolBar->enableStartBtn(i);
            this->m_toolBar->enablePauseBtn(i);
            this->m_toolBar->enableDeleteBtn(i);
        }
        else {
            this->m_toolBar->enableStartBtn(false);
            this->m_toolBar->enablePauseBtn(false);
            this->m_toolBar->enableDeleteBtn(i);
        }
    }
    else {
        this->m_toolBar->enableStartBtn(false);
        this->m_toolBar->enablePauseBtn(false);
        this->m_toolBar->enableDeleteBtn(false);
    }
    //end
    if(current_listview_row==0||current_listview_row==1)
    {
        QList<DataItem *> render_list=downloading_tableview->get_tableViewModel()->renderList();
        for(int j=0;j<render_list.size();j++)
        {
            DataItem *data= render_list.at(j);
            if(!i)
            {
                if(current_listview_row==0)
                    downloading_header_check_status=0;
                if(current_listview_row==1)
                    finish_header_check_status=0;
                data->Ischecked=false;
            }
            else
            {
                if(current_listview_row==0)
                    downloading_header_check_status=2;
                if(current_listview_row==1)
                    finish_header_check_status=2;
                data->Ischecked=true;
            }

            downloading_tableview->reset();
        }
    }
    else {
        QList<DelDataItem *> recycle_list=recycle_tableview->get_tableViewModel()->recyleList();
        for(int j=0;j<recycle_list.size();j++)
        {
            DelDataItem *data= recycle_list.at(j);
            if(!i)
            {
                data->Ischecked=false;
            }
            else
            {
                data->Ischecked=true;
            }

            recycle_tableview->reset();
        }

    }
}

void MainWindow::slot_auto_download_bt(QString btFilePath)
{
    BtInfoDialog *dialog = new BtInfoDialog(btFilePath, get_download_savePath_from_config());//torrent文件路径
    int ret = dialog->exec();
    if(ret == QDialog::Accepted) {
        QMap<QString,QVariant> opt;
        opt.insert("dir", dialog->getSaveto());
        opt.insert("select-file", dialog->getSelected());
        QString infoHash=dialog->getBtInfo().infoHash;
        get_TorrentDowload_slot(btFilePath, opt,dialog->getName(),infoHash);
    }
    delete dialog;
}

void MainWindow::slot_selected(const QModelIndex &selected)
{

    bool chked = selected.model()->data(selected, TableViewModel::DataRole::Ischecked).toBool();
    if(ctrlKey_press==false)
    {
           QList<DataItem *> data_list=downloading_tableview->get_tableViewModel()->dataList();
           for(int i=0;i<data_list.size();i++)
           {
               data_list.at(i)->Ischecked=false;
           }
           QList<DelDataItem *> recycle_list=recycle_tableview->get_tableViewModel()->recyleList();
           for(int i=0;i<recycle_list.size();i++)
           {
               recycle_list.at(i)->Ischecked=false;
           }
           downloading_tableview->reset();
           recycle_tableview->reset();
           ((TableViewModel*)selected.model())->setData(selected.model()->index(selected.row(), 0), true, TableViewModel::Ischecked);
    }
    else if(ctrlKey_press==true)
    {
        downloading_tableview->reset();
        recycle_tableview->reset();
        ((TableViewModel*)selected.model())->setData(selected.model()->index(selected.row(), 0), !chked, TableViewModel::Ischecked);

    }

}

void MainWindow::slot_aria2_remove(QString gId, QString id)
{
    aria2c->remove(gId, id);
}

void MainWindow::slot_check_change(bool checked, int flag)
{
    //ToolBar禁用按钮联动：列表内复选框状态变化 begin
    int chkedCnt = 0;
    if(current_listview_row == 2) {
        QList<DelDataItem*> recyleList = recycle_tableview->get_tableViewModel()->recyleList();
        for(int i = 0; i < recyleList.size(); i++) {
            if(recyleList.at(i)->Ischecked) {
                chkedCnt++;
            }
        }
    }
    else {
        QList<DataItem*> selectList = downloading_tableview->get_tableViewModel()->renderList();
        for(int i = 0; i < selectList.size(); i++) {
            if(selectList.at(i)->Ischecked) {
                chkedCnt++;
            }
        }
    }

    if(chkedCnt > 0) {
        if(current_listview_row == 0) {
            this->m_toolBar->enableStartBtn(true);
            this->m_toolBar->enablePauseBtn(true);
            this->m_toolBar->enableDeleteBtn(true);
        }
        else if(current_listview_row == 1) {
            this->m_toolBar->enableStartBtn(false);
            this->m_toolBar->enablePauseBtn(false);
            this->m_toolBar->enableDeleteBtn(true);
        }
        else if(current_listview_row == 2) {
            this->m_toolBar->enableStartBtn(false);
            this->m_toolBar->enablePauseBtn(false);
            this->m_toolBar->enableDeleteBtn(true);
        }
    }
    else {
        this->m_toolBar->enableStartBtn(false);
        this->m_toolBar->enablePauseBtn(false);
        this->m_toolBar->enableDeleteBtn(false);
    }
    //end
}

void MainWindow::slot_redownload(QString taskId, int rd)
{
    if(rd == 0 || rd == 1)
    {
        DataItem *data = downloading_tableview->get_tableViewModel()->find(taskId);
        if(data == nullptr) return;
        QString url = data->url;
        QString aria_temp_file = data->savePath + ".aria2";
        QString taskId = data->taskId;
        if(!data->savePath.isEmpty())
        {
            QFileInfo fi(data->savePath);
            if(fi.isDir() && data->savePath.contains(data->fileName) && !data->fileName.isEmpty()) {
                QDir tar(data->savePath);
                tar.removeRecursively();
            }
            else {
                QFile::remove(data->savePath);
            }
            if(QFile::exists(aria_temp_file))
            {
                QThread::sleep(1);
                QFile::remove(aria_temp_file);
            }
        }

        QString file_path = data->savePath;
        QString file_name = data->fileName;
        QString default_savePath = get_download_savePath_from_config() ;
        QString save_path ;

        if(default_savePath != data->savePath)
        {
            int name_length = file_name.size();
            int file_path_length = file_path.size();
            int folder_path_length = file_path_length-name_length-1;
            save_path = file_path.left(folder_path_length);
        }
        else {
            save_path = default_savePath;
        }


        downloading_tableview->get_tableViewModel()->removeItem(data);
        //QString save_path=get_download_savePath_from_config();

        deal_download_upload_limit_period();

        Tb_Task task;
        task.deleteTbTask(taskId);
        Tb_Url_Info url_info;
        Tb_Url_Info *get_url_info;
        get_url_info = url_info.getTbUrlInfoByTaskId(taskId);
        if(get_url_info != NULL)
        {
           if(get_url_info->download_type == "torrent")
           {
               /*if(!get_url_info->infoHash.isEmpty())
               {
                   QFile::remove(get_url_info->infoHash+".torrent");//???
               }*/
               QMap<QString,QVariant> opt;
               opt.insert("dir",save_path);
               opt.insert("select-file",get_url_info->selectedNum);
               //aria2c->addTorrent(get_url_info->seedFile,opt,get_url_info->task_id);
               Tb_Task *add_task = new Tb_Task(get_url_info->task_id, "", 0, "", "", file_name, QDateTime::currentDateTime());
               task.addTbTask(add_task);
               aria2c->addTorrent(get_url_info->seedFile, opt, get_url_info->task_id);
            }
        }
        else
        {
           QUuid id = QUuid::createUuid();
           QString strId = id.toString();
           QMap<QString, QVariant> opt;
           opt.insert("dir", save_path);
           aria2c->addUri(url,opt,strId);

           QString filename=QString(url).right(url.length() - url.lastIndexOf('/') - 1);
           if(!filename.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
           {
               const QByteArray filename_byte=filename.toLatin1();
               QString filename_decode=QUrl::fromPercentEncoding(filename_byte);
               filename=filename_decode;
           }

           Tb_Task *add_task= new Tb_Task(strId,"",0,url,file_path,filename,QDateTime::currentDateTime());
           task.addTbTask(add_task);

        }
    }
    else {
        DelDataItem *data = recycle_tableview->get_tableViewModel()->find(taskId, 2);
        if(data == nullptr) return;
        QString url = data->url;
        QString taskId = data->taskId;
        QString aria_temp_file = data->savePath+".aria2";
        if(!data->savePath.isEmpty())
        {
            QFileInfo fi(data->savePath);
            if(fi.isDir() && data->savePath.contains(data->fileName) && !data->fileName.isEmpty()) {
                QDir tar(data->savePath);
                tar.removeRecursively();
            }
            else {
                QFile::remove(data->savePath);
            }
            if(QFile::exists(aria_temp_file))
            {
                QFile::remove(aria_temp_file);
            }
        }
        QString file_path = data->savePath;
        QString file_name = data->fileName;
        QString default_savePath = get_download_savePath_from_config() ;
        QString save_path ;
        if(default_savePath != data->savePath)
        {
            int name_length = file_name.size();
            int file_path_length = file_path.size();
            int folder_path_length = file_path_length-name_length-1;
            save_path = file_path.left(folder_path_length);
        }
        else {
            save_path = default_savePath;
        }


        recycle_tableview->get_tableViewModel()->removeItem(data);
        deal_download_upload_limit_period();
       // QString  save_path=get_download_savePath_from_config();
        Tb_Task task;
        task.deleteTbTask(taskId);
        QUuid id = QUuid::createUuid();
        QString strId = id.toString();
        Tb_Url_Info url_info;
        Tb_Url_Info *get_url_info;
        get_url_info = url_info.getTbUrlInfoByTaskId(taskId);
        if(get_url_info != NULL)
        {
            if(get_url_info->download_type == "torrent")
            {
                if(!get_url_info->infoHash.isEmpty())
                {
                    QFile::remove(get_url_info->infoHash+".torrent");
                }
                QMap<QString,QVariant> opt;
                opt.insert("dir",save_path);
                opt.insert("select-file",get_url_info->selectedNum);
                //aria2c->addTorrent(get_url_info->seedFile,opt,get_url_info->task_id);

                Tb_Task *add_task = new Tb_Task(get_url_info->task_id, "", 0, "", "", file_name, QDateTime::currentDateTime());
                task.addTbTask(add_task);

                aria2c->addTorrent(get_url_info->seedFile,opt,get_url_info->task_id);
            }
        }
        else
        {
            QMap<QString, QVariant> opt;
            opt.insert("dir", save_path);
            aria2c->addUri(url, opt, strId);
            QString filename = QString(url).right(url.length() - url.lastIndexOf('/') - 1);
            if(!filename.contains(QRegExp("[\\x4e00-\\x9fa5]+")))
            {
                const QByteArray filename_byte = filename.toLatin1();
                QString filename_decode = QUrl::fromPercentEncoding(filename_byte);
                filename = filename_decode;
            }
            Tb_Task *add_task= new Tb_Task(strId, "", 0, url, file_path, filename, QDateTime::currentDateTime());
            task.addTbTask(add_task);
        }
    }
    Update_MainUi();
    if (updatetimer->isActive() == false)
    {
        updatetimer->start(2*1000);
    }

}

void MainWindow::clear_table_item_check_status()
{
    if(current_listview_row==0||current_listview_row==1)
    {
        QList<DataItem *> render_list=downloading_tableview->get_tableViewModel()->renderList();
        for(int j=0;j<render_list.size();j++)
        {
            DataItem *data= render_list.at(j);
            data->Ischecked=false;
            downloading_tableview->reset();
        }
    }
    else
    {
        QList<DelDataItem *> recycle_list=recycle_tableview->get_tableViewModel()->recyleList();
        for(int j=0;j<recycle_list.size();j++)
        {
            DelDataItem *data= recycle_list.at(j);
            data->Ischecked=false;
            recycle_tableview->reset();
        }
    }

}
void MainWindow::save_data_before_close()
{
    QList<DataItem *> dataList=downloading_tableview->get_tableViewModel()->dataList();
    QList<DelDataItem *> recyclelist=recycle_tableview->get_tableViewModel()->recyleList();
    if(recyclelist.size()>0)
    {
      for(int j=0;j<recyclelist.size();j++)
      {
        DelDataItem *del_data= recyclelist.at(j);
        QDateTime deltime=QDateTime::fromString(del_data->deleteTime, "yyyy-MM-dd hh:mm:ss");
        Tb_Task *task= new Tb_Task(del_data->taskId, del_data->gid, 0, del_data->url, del_data->savePath,
                                     del_data->fileName, deltime);

        task->updateTbTaskByTaskId(task);

      }

    }
    if(dataList.size()>0)
    {
    for(int i=0;i<dataList.size();i++)
    {
        DataItem * data=dataList.at(i);
        QDateTime time = QDateTime::fromString(data->createTime, "yyyy-MM-dd hh:mm:ss");


        Tb_Task *task= new Tb_Task(data->taskId, data->gid, 0, data->url, data->savePath,
                                     data->fileName, time);

        task->updateTbTaskByTaskId(task);
         QDateTime finish_time;
        if(data->status==Global::Status::Complete)
        {
           finish_time= QDateTime::fromString(data->time,"yyyy-MM-dd hh:mm:ss");
        }
        else
        {
           finish_time=QDateTime::currentDateTime();

        }
        Tb_Donwload_Task_Status get_status;
        int status;
        if(data->status==Global::Status::Complete||data->status==Global::Status::Removed)
        {
            status=data->status;
        }
        else
        {
            status=Global::Status::Lastincomplete;
        }

        Tb_Donwload_Task_Status *download_status = new Tb_Donwload_Task_Status(data->taskId,status,finish_time,data->completedLength,data->speed,data->totalLength,data->percent,data->total,finish_time);

        if(get_status.getTbDownloadStatusByTaskId(data->taskId)!=NULL)
        {
            download_status->updateTbDownloadStatusByTaskId(download_status);
        }
        else
        {
            download_status->addTbDownloadTaskStatus(download_status);
        }
     }

  }
}
bool  MainWindow::Is_duplicate_seed_file(QString infoHash,QString select_num)
{
   Tb_Url_Info tb_url_info;
   QList<Tb_Url_Info *> tb_url_info_list;
   tb_url_info_list=tb_url_info.getAllTbUrlInfo();
   bool found=false;
   for(int j=0;j<tb_url_info_list.size();j++)
   {
       Tb_Url_Info *get_tb_url_info;
       get_tb_url_info=  tb_url_info_list.at(j);
       if(get_tb_url_info->infoHash==infoHash&&get_tb_url_info->selectedNum==select_num)
       {
           found=true;
       }
   }
   return  found;
}
void MainWindow::keyPressEvent(QKeyEvent *event)
{
    if(event->modifiers()==Qt::ControlModifier)
    {
        ctrlKey_press=true;
    }
    if(event->modifiers()==Qt::ControlModifier&&event->key() == Qt::Key_C)
    {
        return;
    }
    QWidget::keyPressEvent(event);

}
void MainWindow::keyReleaseEvent(QKeyEvent *event)
{
    if(ctrlKey_press==true)
    {
        ctrlKey_press=false;

    }
    QWidget::keyReleaseEvent(event);
}
void MainWindow::get_paletteTypeChanged(DGuiApplicationHelper::ColorType type)
{

    left_list->setPalette(DGuiApplicationHelper::instance()->applicationPalette());

    if(DGuiApplicationHelper::instance()->themeType()==2)
    {
        QPalette deeptheme_palette;
        deeptheme_palette.setBrush(QPalette::Background,DGuiApplicationHelper::instance()->applicationPalette().base());
        LeftWidget->setPalette(deeptheme_palette);
        downloading_item->setBackground(DGuiApplicationHelper::instance()->applicationPalette().base());
        downloadFinish_item->setBackground(DGuiApplicationHelper::instance()->applicationPalette().base());
        recycle_item->setBackground(DGuiApplicationHelper::instance()->applicationPalette().base());
        QPalette label_palette;
        label_palette.setBrush(QPalette::Text,DGuiApplicationHelper::instance()->applicationPalette().placeholderText());
        //noTask_label->setPalette(label_palette);
        noTask_tip_Label->setPalette(DGuiApplicationHelper::instance()->applicationPalette());
        QPalette tableview_palette;
        //tableview_palette.setColor(QPalette::Base,QColor("#262626"));
        tableview_palette.setBrush(QPalette::Base,DGuiApplicationHelper::instance()->applicationPalette().window());

        downloading_tableview->setPalette(tableview_palette);
        recycle_tableview->setPalette(tableview_palette);
        noTask_Widget->setPalette(tableview_palette);
        Task_Num_Widget->setPalette(tableview_palette);
        downloading_item->setIcon(QIcon::fromTheme("ndm_list_downloading_dark"));
        downloadFinish_item->setIcon(QIcon::fromTheme("ndm_print_done_dark"));
        recycle_item->setIcon(QIcon::fromTheme("ndm_list_delete_dark"));
        QPalette noTask_tip_Label_p;
        noTask_tip_Label_p.setBrush(QPalette::WindowText,DGuiApplicationHelper::instance()->applicationPalette().textTips());
        Task_Num->setPalette(noTask_tip_Label_p);


    }
    //else if(DGuiApplicationHelper::instance()->themeType()==1)
    else
    {
        downloading_item->setBackground(QColor(255,255,255));
        downloadFinish_item->setBackground(QColor(255,255,255));
        recycle_item->setBackground(QColor(255,255,255));

        downloading_item->setIcon(QIcon::fromTheme("ndm_list_downloading"));
        downloadFinish_item->setIcon(QIcon::fromTheme("ndm_print_done"));
        recycle_item->setIcon(QIcon::fromTheme("ndm_list_delete"));

        QPalette p;
        p.setColor(QPalette::Background,QColor(255,255,255));
        QPalette tableview_palette;
        tableview_palette.setBrush(QPalette::Base,DGuiApplicationHelper::instance()->applicationPalette().window());
        LeftWidget->setPalette(p);
        //noTask_Widget->setPalette(p);
        noTask_Widget->setPalette(tableview_palette);
        downloading_tableview->setPalette(tableview_palette);
        recycle_tableview->setPalette(tableview_palette);
        Task_Num_Widget->setPalette(tableview_palette);

        QPalette font_p;
        QColor color=QColor(192,198,212,76);
        font_p.setColor(QPalette::WindowText,color);
       // noTask_label->setPalette(font_p);
        QPalette noTask_tip_Label_p;
        noTask_tip_Label_p.setColor(QPalette::WindowText,QColor(65,77,104,70));
        Task_Num->setPalette(noTask_tip_Label_p);



    }

}
void MainWindow::get_doubleClicked(const QModelIndex &index)
{
    QString file_path = index.model()->data(index, TableViewModel::DataRole::SavePath).toString();
    QString path=QString("file:///")+ file_path;
    bool is_open= QDesktopServices::openUrl(QUrl(path,QUrl::TolerantMode));
}
