/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosaccount.h"

void          uos_account_read_config_all   (void){
    account_read_config_all   ();
}

void          uos_account_write_config_all  (void){
    account_write_config_all  ();
}

UosPrefsAccount *uos_account_find_from_smtp_server (const gchar    *address,
                                                    const gchar    *smtp_server){
    return account_find_from_smtp_server (address,smtp_server);
}

UosPrefsAccount *uos_account_find_from_address     (const gchar    *address){
    return account_find_from_address (address);
}

UosPrefsAccount *uos_account_find_from_id      (gint        id){
    return account_find_from_id      (id);
}

UosPrefsAccount *uos_account_find_from_item        (UosFolderItem *item){
    return account_find_from_item        (item);
}

UosPrefsAccount *uos_account_find_from_item_property   (UosFolderItem *item){
    return account_find_from_item_property   (item);
}

UosPrefsAccount *uos_account_find_from_message_file    (const gchar    *file){
    return account_find_from_message_file    (file);
}

UosPrefsAccount *uos_account_find_from_msginfo (UosMsgInfo    *msginfo){
    return account_find_from_msginfo(msginfo);
}


gboolean      uos_account_address_exist (const gchar    *address){
    return account_address_exist (address);
}

void          uos_account_foreach       (UosAccountFunc     func,
                                         gpointer    user_data){
    account_foreach       (func,user_data);
}

GList        *uos_account_get_list      (void){
    return account_get_list      ();
}

void          uos_account_list_free     (void){
    account_list_free      ();
}

void          uos_account_append        (UosPrefsAccount   *ac_prefs){
    account_append        (ac_prefs);
}


void          uos_account_set_as_default    (UosPrefsAccount   *ac_prefs){
    account_set_as_default        (ac_prefs);
}

UosPrefsAccount *uos_account_get_default   (void){
    return account_get_default   ();
}

UosFolderItem   *uos_account_get_special_folder(UosPrefsAccount       *ac_prefs,
                                                UosSpecialFolderItemType   type){
    return account_get_special_folder(ac_prefs,type);
}


void          uos_account_destroy       (UosPrefsAccount   *ac_prefs){
    account_destroy       (ac_prefs);
}

void          uos_account_update_lock   (void){
    account_update_lock   ();
}

void          uos_account_update_unlock (void){
    account_update_unlock   ();
}

void          uos_account_updated       (void){
    account_updated   ();
}

