/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "uosxml.h"

XMLFile *uos_xml_open_file		(const gchar	*path){
     return xml_open_file		(path);
}

void     uos_xml_close_file		(XMLFile	*file){
    xml_close_file		(file);
}

GNode   *uos_xml_parse_file		(const gchar	*path){
    return xml_parse_file		(path);
}

gint uos_xml_get_dtd		(XMLFile	*file){
    return xml_get_dtd		(file);
}

gint uos_xml_parse_next_tag		(XMLFile	*file){
    return xml_parse_next_tag		(file);
}

void uos_xml_push_tag		(XMLFile	*file,
                 XMLTag		*tag){
    xml_push_tag		(file,tag);
}

void uos_xml_pop_tag		(XMLFile	*file){
    xml_pop_tag		(file);
}

XMLTag *uos_xml_get_current_tag	(XMLFile	*file){
    return xml_get_current_tag		(file);
}

GList  *uos_xml_get_current_tag_attr(XMLFile	*file){
    return xml_get_current_tag_attr(file);
}

gchar  *uos_xml_get_element		(XMLFile	*file){
    return xml_get_element(file);
}

gint uos_xml_read_line		(XMLFile	*file){
    return xml_read_line(file);
}

void uos_xml_truncate_buf		(XMLFile	*file){
    xml_truncate_buf(file);
}

gboolean  uos_xml_compare_tag	(XMLFile	*file,
                 const gchar	*name){
    return xml_compare_tag	(file,name);
}


XMLNode *uos_xml_node_new		(XMLTag		*tag,
                 const gchar	*text){
    return xml_node_new		(tag,text);
}

XMLTag *uos_xml_tag_new		(const gchar	*tag){
    return xml_tag_new		(tag);
}

XMLAttr *uos_xml_attr_new		(const gchar	*name,
                 const gchar	*value){
    return xml_attr_new		(name,value);
}

void uos_xml_tag_add_attr		(XMLTag		*tag,
                 XMLAttr	*attr){
    xml_tag_add_attr		(tag,attr);
}

XMLTag  *uos_xml_copy_tag		(XMLTag		*tag){
    return xml_copy_tag		(tag);
}

XMLAttr *uos_xml_copy_attr		(XMLAttr	*attr){
    return xml_copy_attr		(attr);
}

gint uos_xml_unescape_str		(gchar		*str){
    return xml_unescape_str		(str);
}

gchar *uos_xml_escape_str		(const gchar	*str){
    return xml_escape_str		(str);
}

gint uos_xml_file_put_escape_str	(FILE		*fp,
                 const gchar	*str){
    return xml_file_put_escape_str	(fp,str);
}

gint uos_xml_file_put_xml_decl	(FILE		*fp){
    return xml_file_put_xml_decl	(fp);
}

gint uos_xml_file_put_node		(FILE		*fp,
                 XMLNode	*node){
    return xml_file_put_node		(fp,node);
}

void uos_xml_free_node		(XMLNode	*node){
    xml_free_node		(node);
}

void uos_xml_free_tree		(GNode		*node){
    xml_free_tree		(node);
}

