/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/checkbutton.h"
#include "vdk/forms.h"
#include "vdk/tooltips.h"
#include "vdk/colors.h"
/*
should be investigated more since
seems to be unuseless, perhaps this
compiler is'nt full ANSI compliant
*/
/*
  template <class T>
  void vdk_cast(T** obj ,void* gp)
  {
  T* addr = reinterpret_cast<T*>(gp);
  *obj = dynamic_cast<T*>(addr);
  }
*/ 

void VDKCheckButton::ToggleEvent(GtkWidget *wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKCheckButton* obj = reinterpret_cast<VDKCheckButton*>(gp);
  obj->Checked(GTK_TOGGLE_BUTTON(wid)->active ? true : false);
  obj->SignalEmit(toggled_signal);
#ifdef USE_SIGCPLUSPLUS
  obj->OnButtonToggled(obj, GTK_TOGGLE_BUTTON(wid)->active ? true : false);
#endif /* USE_SIGCPLUSPLUS */
}
 
VDKCheckButton::VDKCheckButton(VDKForm* owner, char* label, char* tip):
  VDKAbstractButton(owner),
  Checked ("Checked", this, false, &VDKCheckButton::SetChecked, 
	   &VDKCheckButton::GetChecked),
  Caption ("Caption", this, label, &VDKCheckButton::SetCaption, 
	   &VDKCheckButton::GetCaption),
  CaptionWrap ("CaptionWrap", this, true, &VDKCheckButton::SetCaptionWrap, 
	       &VDKCheckButton::GetCaptionWrap)
{
if(label)
  widget = gtk_check_button_new_with_label(label);
else
  widget = gtk_check_button_new (); 
connectId = gtk_signal_connect(GTK_OBJECT(widget),"toggled",
		   GTK_SIGNAL_FUNC(VDKCheckButton::ToggleEvent),
			       reinterpret_cast<gpointer>(this));
#ifdef USE_SIGCPLUSPLUS
make_gtksigc_connection(this, widget); 
#endif /* USE_SIGCPLUSPLUS */
if (tip)
  tooltip = new VDKTooltip(owner, this, tip);
else
  tooltip = 0;
 ConnectDefaultSignals();
}

void VDKCheckButton::SetCaption(char* str)
{
    gtk_label_set_text (GTK_LABEL(GTK_BIN(widget)->child),str);
}

char* VDKCheckButton::GetCaption () {
    return GTK_LABEL (GTK_BIN(widget)->child)->label;
}

void VDKCheckButton::SetCaptionWrap (bool flag) {
    gtk_label_set_line_wrap (GTK_LABEL (GTK_BIN(widget)->child), flag);
}

bool VDKCheckButton::GetCaptionWrap () {
    return GTK_LABEL (GTK_BIN(widget)->child)->wrap;
}

void 
VDKCheckButton::SetForeground(VDKRgb color, GtkStateType state)
{
  VDKColor *vdkcolor = NULL;
  if(!GTK_IS_WIDGET(widget))
    return;
  else
    {
      GtkButton* button = GTK_BUTTON(widget);
      GtkLabel* label =  GTK_LABEL(GTK_BIN (button)->child);

      //      vdkcolor = new VDKColor(/*Owner() ? Owner() : */this ,color);
      vdkcolor = new VDKColor(Owner() ? static_cast<VDKObject*>(Owner()) 
			              : static_cast<VDKObject*>(this)
			      ,color);
      gtk_widget_modify_fg (GTK_WIDGET(label), 
			      state, vdkcolor->Color());     
    }
}

void
VDKCheckButton::SetFont(VDKFont* font)
{
  if(!GTK_IS_WIDGET(widget))
    return;
  else
    {
      GtkButton* button = GTK_BUTTON(widget);
      GtkWidget* label =  GTK_WIDGET(GTK_BIN (button)->child);
      VDKObject::_setFont_(label,font);
    }
}
