/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0
 * Revision 7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
/*
OVERVIEW
--------
This file has the aim to be a footstep that shows how to make a 
gtk+ widget wrapper in vdk.
We choose here to wrap gtk_calendar() widget.
*/

#ifndef _VDKCALENDAR_H
#define _VDKCALENDAR_H
#include <vdk/vdk.h>
/*
  defines for signals,
  we use user_signal as base in order to avoid
  possible conflicts with vdk internal signal system
*/
#define day_select_signal           user_signal + 1024
#define day_selected_double_click   day_select_signal + 1

class VDKCalendar: public VDKObject
{


 public:
  // 
  VDKCalendar(VDKForm* owner = NULL);
  virtual ~VDKCalendar();
  /*
    note:
    others gtk_calendar functions could be wrapped,
    but since in most cases it will be a 1:1 wrapping we decide
    to do not do it.
    User have at their hand: VDKObject::Widget	() to access
    directly to gtk_calendar.
    For instance to mark in bold face a day:
    ....
    VDKCalendar calendar = new VDKCalendar(this);
    calendardate today;
    gtk_calendar_mark_day ( GTK_CALENDAR(calendar->Widget()),today.Day());
    ....
  */
  //------------------
  // signal section
  //------------------
 protected:
  /*
    to wrap signals we use static class function that bind
    a signal and propagates it into vdk hierarchy.
    To decide which signal can be wrapped we take a look at
    gtkcalendar.h in gtk+ distribution.
    We see:
    void (* month_changed)		(GtkCalendar *calendar);
    void (* day_selected)		(GtkCalendar *calendar);
    void (* day_selected_double_click)	(GtkCalendar *calendar);
    void (* prev_month)			(GtkCalendar *calendar);
    void (* next_month)			(GtkCalendar *calendar);
    void (* prev_year)			(GtkCalendar *calendar);
    void (* next_year)			(GtkCalendar *calendar);
    So we decide to wrap following signals;
    - day_selected
    - day_selected_double_click
    for static tables, leaving others to be connected at user choice
    using dynamics tables.
    Now let's take a look to signal handlers to see how 
    should be the signature of the handlers.Since they all
    have just the widget as parameter we know that the handler
    will have the classic form:
    -----------------------------------
    void handler(GtkWidget*, gpointer);
    -----------------------------------
    (in many cases there is also an example how the widget
    works, both in testgtk.c or in examples dir. In our case
    there is a good one on  example/calendar/gcalendar.c).
  */
  static void DaySelectedHandler(GtkWidget*, gpointer);
  static void DaySelectedDoubleClickHandler(GtkWidget*, gpointer);

  //---------------------
  // properties section
  //---------------------
  /*
    To decide which properties are suitable to be wrapped,
    we take a look to gtkcalendar.h in gtk+ distribution
    to see wich gtk_set... or gtk_get... are available there.
    We see :
    void  gtk_calendar_display_options (GtkCalendar * calendar,
              GtkCalendarDisplayOptions options);
    void  gtk_calendar_get_date	(GtkCalendar *, 
				 guint	     *year,
				 guint	     *month,
				 guint	     *day);
    gint  gtk_calendar_select_month(GtkCalendar *calendar,
                                 guint	      month,
				 guint	      year);
    void  gtk_calendar_select_day(GtkCalendar *calendar,
				  guint       day);				 
    So we decide to have following properties:
    - GtkCalendarOptions DisplayOptions
    - calendardate SelectedDate (read only)
    - int SelectedDay
    - VDKPoint SelectedMonth (where point.x is mont and point.y is day)
    (note: gtk+ numbers months using base 0:
    january = 0, february =1,...december = 11
    Instead we decide to use base 1 for the wrapper).
  */

  /* --------- DisplayOptions property ----------
     This property sets/gets  how calendar displays,
     options can be one or more of the following:
     (can be ored togheter)
     GTK_CALENDAR_SHOW_HEADING
     GTK_CALENDAR_SHOW_DAY_NAMES
     GTK_CALENDAR_NO_MONTH_CHANGE
     GTK_CALENDAR_SHOW_WEEK_NUMBERS
     GTK_CALENDAR_WEEK_START_MONDAY
  */
 public:
  __rwproperty(VDKCalendar, GtkCalendarDisplayOptions) DisplayOptions;
  /* and setting/getting functions */
 protected:
  void SetDisplayOptions(GtkCalendarDisplayOptions options);
  /* 
     getting function isn't necessary,
     since we use raw property read
     ( see vdk reference under "properties" section
     for further informations)
  */

  /* ------------- SelectedDate property --------
    This (read only) property read selected date
    in gtk_calendar widget.
    We use here calendardate object in vdk stock
    as property type.
  */
 public:
  __rproperty(VDKCalendar,calendardate) SelectedDate;
  /* and getting functions (since property is read-only */
 protected:
  calendardate GetSelectedDate();

  /* ------ SelectedDay property --------------
    this property set/get selected day
  */
 public:
  __rwproperty(VDKCalendar, int) SelectedDay;
 protected:
 void SetSelectedDay(int d);
  /* getting function isn't necessary*/
 

 /* -------- SelectedMonth property --------------
   this property set/get selected month/year
 */
 public:
 __rwproperty(VDKCalendar, VDKPoint) SelectedMonth;
 protected:
 void SetSelectedMonth(VDKPoint p);
 /* getting function isn't necessary*/

};

#endif

