/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef RADIOBTNGROUP_H
#define RADIOBTNGROUP_H
#include <vdk/widcontain.h>
#include <vdk/checkbutton.h>
#include <vdk/eventbox.h>
#include <vdk/vdkprops.h>
class VDKRadioButton;

typedef VDKList<VDKRadioButton> RadioButtonList;
typedef VDKListiterator<VDKRadioButton> RadioButtonListIterator;

class VDKRadioButtonGroup;
/*!
  \class VDKRadioButtonGroup
  \brief Providesa radio button group
  \par SIGNALS
  \arg \b toggled_signal received whenever one of the buttons into 
  group is toggled.
  \par EXAMPLES
  Into ./testvdk/rbutton.cc
 */
class VDKRadioButtonGroup: public VDKObjectContainer
{
 protected:
  VDKEventBox *box;
  GSList* gs_group;
 public:

  // properties
  /*!
    Use this property to know wich button was toggled after a toggle_signal.
    Or to force a selection. Selected propery contais the ordinal number
    of toggled button ( 0 <= x < n)
    Defaults to 0
   */
  VDKReadWriteValueProp<VDKRadioButtonGroup,int> Selected;
  

  /*!
    Returns a list of radio buttons contained into group.
    You can acces them:
    \code
    // disables last radio button
    int last = radio_group->Buttons.size()-1;
    radio_group->Buttons[last]->Enabled = false;
    \endcode
    <read only>
   */
  RadioButtonList Buttons;
  /*!
    same as Buttons
   */
  VDKReadOnlyValueProp<VDKRadioButtonGroup, RadioButtonList*> ButtonList;
  /*!
    Constructor
    \param owner
    \param mode either v_box or h_box
   */
  VDKRadioButtonGroup(VDKForm* owner,int mode = v_box);
  /*!
    Destructor
  */
  ~VDKRadioButtonGroup(){}
  /*!
    Sets the button that will be selected by default
    \param buttonNumber ordinal number of selected button
    (0 <= buttonNumber < Buttons.size())
   */
  void SetDefault(int buttonNumber);
  void SetSelected(int index);
  int  GetSelected() { return Selected; }
  void Add(VDKObject* obj, int j = l_justify, 
	   int e = false, int f = false, int p = false);
  /*!
    Remove a button from radio button group
    \param button which button has to be removed
   */
  void RemoveButton(VDKRadioButton* button);
  GSList* GsGroup(GSList* gs = NULL)
  { if(gs) gs_group = gs; return gs_group; }
  /*!
    Return group box
   */
  VDKEventBox* GBox() { return box; }
  static void ToggleEvent(GtkWidget *wid, gpointer bn);
};

/*!
  \class VDKRadioButton
  \brief Provides a radio button
  \par TIP
  This emit his own "toggled" signal, user can connect using
  dynamic tables and <gtk> arg set to false.
  \code
  SignalConnect("toggled",&MyForm::HandleToggled,false);
  // or
  SignalConnect(group,"toggled",&MyForm::HandleToggled,false);
  \endcode
  \par EXAMPLES
  Into ./testvdk/rbutton.cc
 */
class VDKRadioButton: public VDKCheckButton
{
protected:
  int buttonId;
  VDKRadioButtonGroup *rbgroup;
  friend class VDKRadioButtonGroup;
public:
  /*!
    Constructor
    \param group owner radio group
    \label button label
   */
  VDKRadioButton(VDKRadioButtonGroup* group, char* label = NULL);
  /*!
    \internal
  */
  VDKRadioButton(VDKForm* owner,char* label);
  /*!
    Destructor
   */
  virtual ~VDKRadioButton() {}
  /*!
    Returns owner group
   */
  VDKRadioButtonGroup* Group(VDKRadioButtonGroup* g = NULL) 
    { if(g) rbgroup = g; return rbgroup; }

};

#endif










